/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.test.j2ee.addmethod;

import java.io.IOException;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.modules.java.editor.GenerateCodeOperator;

/**
 *  Called from EJBValidation test suite.
 * 
 * @author Libor Martinek
 */
public class SendMessageTest extends AddMethodBase {

    /** Creates a new instance of AddMethodTest */
    public SendMessageTest(String name) {
        super(name);
    }

    public void testSendMessage1InSB() throws IOException {
        beanName = "TestingSession";
        // "Send JMS Message..."
        editorPopup = Bundle.getStringTrimmed("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.Bundle", "LBL_SendJMSMessageAction");
        // "Send JMS Message"
        dialogTitle = Bundle.getString("org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.Bundle", "LBL_SendJmsMessage");
        toSearchInEditor = "sendJMSMessageToTestingMessageBean";
        isDDModified = true;
        saveFile = true;
        addMethod();
    }

    protected void addMethod() throws IOException {
        EditorOperator editor = EditorWindowOperator.getEditor(beanName + "Bean.java");
        editor.select("private javax.ejb.SessionContext context;");

        GenerateCodeOperator.openDialog(editorPopup, editor);
        NbDialogOperator sendJMSOper = new NbDialogOperator(dialogTitle);
        sendJMSOper.ok();
        editor.txtEditorPane().waitText(toSearchInEditor);
        if (saveFile) {
            editor.save();
        }
        compareFiles();
    }
}
