# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

package Math::GSL::Diff;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::Diffc;
bootstrap Math::GSL::Diff;
package Math::GSL::Diff;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::Diff;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Diff;

*gsl_error = *Math::GSL::Diffc::gsl_error;
*gsl_stream_printf = *Math::GSL::Diffc::gsl_stream_printf;
*gsl_strerror = *Math::GSL::Diffc::gsl_strerror;
*gsl_set_error_handler = *Math::GSL::Diffc::gsl_set_error_handler;
*gsl_set_error_handler_off = *Math::GSL::Diffc::gsl_set_error_handler_off;
*gsl_set_stream_handler = *Math::GSL::Diffc::gsl_set_stream_handler;
*gsl_set_stream = *Math::GSL::Diffc::gsl_set_stream;
*gsl_diff_central = *Math::GSL::Diffc::gsl_diff_central;
*gsl_diff_backward = *Math::GSL::Diffc::gsl_diff_backward;
*gsl_diff_forward = *Math::GSL::Diffc::gsl_diff_forward;

# ------- VARIABLE STUBS --------

package Math::GSL::Diff;

*GSL_VERSION = *Math::GSL::Diffc::GSL_VERSION;
*GSL_MAJOR_VERSION = *Math::GSL::Diffc::GSL_MAJOR_VERSION;
*GSL_MINOR_VERSION = *Math::GSL::Diffc::GSL_MINOR_VERSION;
*GSL_POSZERO = *Math::GSL::Diffc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::Diffc::GSL_NEGZERO;
*GSL_SUCCESS = *Math::GSL::Diffc::GSL_SUCCESS;
*GSL_FAILURE = *Math::GSL::Diffc::GSL_FAILURE;
*GSL_CONTINUE = *Math::GSL::Diffc::GSL_CONTINUE;
*GSL_EDOM = *Math::GSL::Diffc::GSL_EDOM;
*GSL_ERANGE = *Math::GSL::Diffc::GSL_ERANGE;
*GSL_EFAULT = *Math::GSL::Diffc::GSL_EFAULT;
*GSL_EINVAL = *Math::GSL::Diffc::GSL_EINVAL;
*GSL_EFAILED = *Math::GSL::Diffc::GSL_EFAILED;
*GSL_EFACTOR = *Math::GSL::Diffc::GSL_EFACTOR;
*GSL_ESANITY = *Math::GSL::Diffc::GSL_ESANITY;
*GSL_ENOMEM = *Math::GSL::Diffc::GSL_ENOMEM;
*GSL_EBADFUNC = *Math::GSL::Diffc::GSL_EBADFUNC;
*GSL_ERUNAWAY = *Math::GSL::Diffc::GSL_ERUNAWAY;
*GSL_EMAXITER = *Math::GSL::Diffc::GSL_EMAXITER;
*GSL_EZERODIV = *Math::GSL::Diffc::GSL_EZERODIV;
*GSL_EBADTOL = *Math::GSL::Diffc::GSL_EBADTOL;
*GSL_ETOL = *Math::GSL::Diffc::GSL_ETOL;
*GSL_EUNDRFLW = *Math::GSL::Diffc::GSL_EUNDRFLW;
*GSL_EOVRFLW = *Math::GSL::Diffc::GSL_EOVRFLW;
*GSL_ELOSS = *Math::GSL::Diffc::GSL_ELOSS;
*GSL_EROUND = *Math::GSL::Diffc::GSL_EROUND;
*GSL_EBADLEN = *Math::GSL::Diffc::GSL_EBADLEN;
*GSL_ENOTSQR = *Math::GSL::Diffc::GSL_ENOTSQR;
*GSL_ESING = *Math::GSL::Diffc::GSL_ESING;
*GSL_EDIVERGE = *Math::GSL::Diffc::GSL_EDIVERGE;
*GSL_EUNSUP = *Math::GSL::Diffc::GSL_EUNSUP;
*GSL_EUNIMPL = *Math::GSL::Diffc::GSL_EUNIMPL;
*GSL_ECACHE = *Math::GSL::Diffc::GSL_ECACHE;
*GSL_ETABLE = *Math::GSL::Diffc::GSL_ETABLE;
*GSL_ENOPROG = *Math::GSL::Diffc::GSL_ENOPROG;
*GSL_ENOPROGJ = *Math::GSL::Diffc::GSL_ENOPROGJ;
*GSL_ETOLF = *Math::GSL::Diffc::GSL_ETOLF;
*GSL_ETOLX = *Math::GSL::Diffc::GSL_ETOLX;
*GSL_ETOLG = *Math::GSL::Diffc::GSL_ETOLG;
*GSL_EOF = *Math::GSL::Diffc::GSL_EOF;

@EXPORT_OK = qw/
               gsl_diff_central
               gsl_diff_backward
               gsl_diff_forward
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

__END__

=encoding utf8

=head1 NAME

Math::GSL::Diff - Numerical differentiation routines

=head1 SYNOPSIS

    use Math::GSL::Diff qw/:all/;

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over

=item C<gsl_diff_central>

This function computes the numerical derivative of the function f
at the point x using an adaptive central difference algorithm.
The result is an array where the first position is an error code (0 for success),
the second is derivative value, and the third is an estimate of its absolute error.

   my ($success, $result, $error) =
         gsl_diff_central(sub { return $_[0] ** 1.5 }, 2.0);

=item C<gsl_diff_backward>

This function computes the numerical derivative of the function f 
at the point x using an adaptive forward difference algorithm.
Its usage is similar to C<gsl_diff_central>.

   my ($success, $result, $error) =
          gsl_diff_backward(sub { return $_[0] ** 1.5 }, 0.0);


=item C<gsl_diff_forward>

This function computes the numerical derivative of the
function f at the point x using an adaptive backward difference algorithm.
Its usage is similar to C<gsl_diff_central>.

   my ($success, $result, $error) =
          gsl_diff_forward(sub { return $_[0] ** 1.5 }, 1.0);


=back

=head1 EXAMPLES

=head1 AUTHORS

Jonathan "Duke" Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2024 Jonathan "Duke" Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
1;
