/*
 * Copyright (C) 2004 TiongHiang Lee
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not,  write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Email: thlee@onemindsoft.org
 */

package org.onemind.jxp.config;

import org.onemind.commons.java.util.StringUtils;
import org.onemind.commons.java.xml.digest.SaxDigesterHandler;
import org.onemind.jxp.CachingPageSource;
import org.onemind.jxp.FilePageSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
/**
 * A FileSourceDigester digest "filesource" element in an xml to create a JxpFilePageSource object
 * @author TiongHiang Lee (thlee@onemindsoft.org)
 */
public class FileSourceDigester extends CachingPageSourceDigester
{

    /**
     * Constructor
     */
    public FileSourceDigester()
    {
        super("filesource");
    }

    /** 
     * {@inheritDoc}
     */
    public CachingPageSource createPageSource(SaxDigesterHandler handler, Attributes attrs) throws SAXException
    {
        String prefix = attrs.getValue("path");
        if (StringUtils.isNullOrEmpty(prefix))
        {
            throw new IllegalArgumentException("Expecing \"path\" attribute in " + handler.getCurrentPath());
        } else
        {
            FilePageSource source = new FilePageSource(prefix);
            String modCheck = attrs.getValue("modcheck");
            if (modCheck != null && modCheck.equals("true"))
            {
                source.setModCheck(true);
            }
            return source;
        }
    }
}