/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatBufferImpl;

class DirectFloatBuffer
extends FloatBufferImpl {
    DirectFloatBuffer(ByteBufferImpl byteBufferImpl, int n, int n2) {
        super(byteBufferImpl, n, null, n2);
    }

    public boolean isDirect() {
        return true;
    }

    public FloatBuffer slice() {
        return new DirectFloatBuffer(this.parent, this.limit - this.position, this.arrayOffset + (this.position << 2));
    }

    public float get(int n) {
        return ByteBufferImpl._getFloat(this.arrayOffset + (this.checkIndex(n) << 2));
    }

    final void copyToArray(float[] fArray, int n, int n2) {
        ByteBufferImpl.memoryToFloatArray(this.arrayOffset + (this.position << 2), fArray, n, n2);
    }

    public FloatBuffer put(int n, float f) {
        ByteBufferImpl._putFloat(this.arrayOffset + (this.checkIndex(n) << 2), f);
        return this;
    }

    void copyFromArray(float[] fArray, int n, int n2) {
        ByteBufferImpl.floatArrayToMemory(fArray, n, this.arrayOffset + (this.position << 2), n2);
    }

    void copyToFloatBuffer(int n, FloatBuffer floatBuffer) {
        floatBuffer.copyFromDirectFloatBuffer(this, n);
    }

    void copyFromHeapFloatBuffer(FloatBuffer floatBuffer, int n) {
        ByteBufferImpl.floatArrayToMemory(floatBuffer.array, floatBuffer.arrayOffset + floatBuffer.position, this.arrayOffset + (this.position << 2), n);
    }

    void copyFromByteBufferAsFloatBuffer(FloatBuffer floatBuffer, int n) {
        byte[] byArray = floatBuffer.parent.array;
        int n2 = floatBuffer.parent.arrayOffset + floatBuffer.arrayOffset + (floatBuffer.position << 2);
        int n3 = this.arrayOffset + (this.position << 2);
        ByteBufferImpl.byteArrayToMemory(byArray, n2, n3, 4 * n);
    }

    void copyFromDirectFloatBuffer(FloatBuffer floatBuffer, int n) {
        int n2 = floatBuffer.arrayOffset + (floatBuffer.position << 2);
        int n3 = this.arrayOffset + (this.position << 2);
        ByteBufferImpl._copyBytes(n2, n3, n << 2);
    }
}

