/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

public class Proxy
implements Serializable {
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map loaderToCache = new WeakHashMap(3);
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map proxyClasses = Collections.synchronizedMap(new WeakHashMap(3));
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.h = invocationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(ClassLoader classLoader, Class[] classArray) throws IllegalArgumentException {
        Object object;
        Object object2;
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class clazz = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            object2 = null;
            try {
                object2 = Class.forName(classArray[i].getName(), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object2 != classArray[i]) {
                throw new IllegalArgumentException(classArray[i] + " is not visible from class loader");
            }
            if (!((Class)object2).isInterface()) {
                throw new IllegalArgumentException(((Class)object2).getName() + " is not an interface");
            }
            stringBuffer.append(classArray[i].getName()).append(';');
        }
        String string = stringBuffer.toString();
        Object object3 = loaderToCache;
        synchronized (object3) {
            object2 = (Map)loaderToCache.get(classLoader);
            if (object2 == null) {
                object2 = new HashMap(3);
                loaderToCache.put(classLoader, object2);
            }
        }
        object3 = object2;
        synchronized (object3) {
            while (true) {
                Object object4;
                if ((object4 = object2.get(string)) instanceof Reference) {
                    clazz = (Class)((Reference)object4).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (object4 != pendingGenerationMarker) break;
                try {
                    object2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            object2.put(string, pendingGenerationMarker);
        }
        try {
            long l;
            Object object5;
            object3 = null;
            for (int i = 0; i < classArray.length; ++i) {
                String string2;
                int n = classArray[i].getModifiers();
                if (Modifier.isPublic(n)) continue;
                object5 = classArray[i].getName();
                int n2 = ((String)object5).lastIndexOf(46);
                String string3 = string2 = n2 == -1 ? "" : ((String)object5).substring(0, n2 + 1);
                if (object3 == null) {
                    object3 = string2;
                    continue;
                }
                if (string2.equals(object3)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (object3 == null) {
                object3 = "";
            }
            object5 = nextUniqueNumberLock;
            synchronized (object5) {
                l = nextUniqueNumber++;
            }
            object5 = (String)object3 + proxyClassNamePrefix + l;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object5, classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object5, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
            Object var14_22 = null;
            object = object2;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            Object object6 = object2;
            synchronized (object6) {
                if (clazz != null) {
                    object2.put(string, new WeakReference(clazz));
                } else {
                    object2.remove(string);
                }
                object2.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            if (clazz != null) {
                object2.put(string, new WeakReference(clazz));
            } else {
                object2.remove(string);
            }
            object2.notifyAll();
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            Constructor constructor = clazz.getConstructor(constructorParams);
            return constructor.newInstance(new Object[]{invocationHandler});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }

    public static boolean isProxyClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);
}

