/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.CVM;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;

    private Constructor() {
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Class[] classArray;
            Class[] classArray2;
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass() && (classArray2 = this.parameterTypes).length == (classArray = constructor.parameterTypes).length) {
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object newInstance(Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.parameterTypes.length == 0 ? objectArray != null && objectArray.length != 0 : objectArray == null || objectArray.length != this.parameterTypes.length) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        CVM.setContextArtificial();
        Object object = Constructor.allocateUninitializedObject(this.clazz);
        try {
            this.invokeConstructor(object, objectArray);
        }
        catch (ArgumentException argumentException) {
            throw new IllegalArgumentException("wrong object type, or unwrapping conversion failed");
        }
        catch (AccessException accessException) {
            throw new IllegalAccessException();
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
        return object;
    }

    private static native Object allocateUninitializedObject(Class var0) throws InstantiationException, IllegalAccessException;

    private native void invokeConstructor(Object var1, Object[] var2) throws ArgumentException, AccessException, Exception;

    private static class AccessException
    extends Exception {
        private AccessException() {
        }
    }

    private static class ArgumentException
    extends Exception {
        private ArgumentException() {
        }
    }
}

