/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.http;

import com.sun.cdc.io.j2me.UniversalFilterInputStream;
import com.sun.cdc.io.j2me.UniversalFilterOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.microedition.io.StreamConnection;

class HttpStreamConnection
implements StreamConnection {
    private final String LOCALHOST = "localhost";
    private String host = null;
    private int port = 0;
    private boolean copen = false;
    private Socket socket;

    public HttpStreamConnection(String string, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("bad port number: " + n);
        }
        this.host = string;
        this.port = n;
        final String string2 = string == null || string.length() == 0 ? "localhost" : string;
        final int n2 = n;
        try {
            this.socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException, IOException {
                    return new Socket(string2, n2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
        this.copen = true;
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new UniversalFilterInputStream(this, this.socket.getInputStream());
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new UniversalFilterOutputStream(this, this.socket.getOutputStream());
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized void close() throws IOException {
        if (this.copen) {
            this.copen = false;
            this.socket.close();
        }
    }
}

