//start of HashDefault.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * HashDefault.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import jp.gr.java_conf.dangan.util.lha.HashMethod;

//import exceptions


/**
 * vO ar940528  LHa for Unix ŎgpĂnbV֐B<br>
 * gzip ŎgpĂQlɂ悤B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: HashDefault.java,v $
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     HashMethod ̃C^tFCXύXɂ킹ăCetFCXύXB
 *     RXgN^ň`FbN폜B
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class HashDefault implements HashMethod{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  private static final int HashMask
    //------------------------------------------------------------------
    /**
     * nbVl𐶐邽߂̃}XNl
     */
    private static final int HashMask = 0x7FFF;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private byte[] TextBuffer
    //------------------------------------------------------------------
    /**
     * LZSSk{߂̃obt@B
     * Ö͎A
     * 㔼͈k{߂̃f[^̓obt@B
     * HashMethod̎ł Hashl̐̂߂̓ǂݍ݂ɂ̂ݎgpB
     */
    private byte[] TextBuffer;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private HashDefault()
    //  public HashDefault( byte[] TextBuffer )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gps
     */
    private HashDefault(){  }

    /**
     * ar940528  LHa for Unix ŎgpĂnbV֐\zB
     * 
     * @param TextBuffer LZSSkp̃obt@B
     *                   Hashl̂ߓǂݍݗpɎgpB
     */
    public HashDefault( byte[] TextBuffer ){
        this.TextBuffer = TextBuffer;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.HashMethod
    //------------------------------------------------------------------
    //  public int hash( int position )
    //  public int hashRequires()
    //  public int tableSize()
    //------------------------------------------------------------------
    /**
     * nbV֐B<br>
     * RXgN^œnꂽ TextBuffer  position 
     * f[^p^ hashl𐶐B
     *
     * @param position f[^p^̊Jnʒu
     * 
     * @return nbVl
     */
    public int hash( int position ){
        return ( ( ( this.TextBuffer[ position ] << 5 ) 
                 ^ ( this.TextBuffer[ position + 1 ] & 0xFF ) )
               << 5 ^( this.TextBuffer[ position + 2 ] & 0xFF ) )
             & HashDefault.HashMask;
    }

    /**
     * nbV֐nbVl𐶐邽߂ɎgpoCg𓾂B<br>
     * ̃nbV֐ 3oCg̃f[^
     * VtgXORgpănbVl𐶐邽߁A
     * ̃\bh͏ 3 ԂB
     * 
     * @return  3
     */
    public int hashRequires(){
        return 3;
    }

    /**
     * nbVe[ũTCY𓾂B<br>
     * ̃nbV֐ 0x0000 ` 0x7FFF ̃nbVl𐶐邽߁A
     * ̃\bh͏ 0x8000(32768) ԂB
     * 
     * @return  0x8000(32768)
     */
    public int tableSize(){
        return 0x8000;
    }

}
//end of HashDefault.java
