/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployment.spi;

/**
 * An interface for resolving deployment endpoints by reference name or
 * interface type.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public interface DeploymentEndpointResolver
{
   /**
    * Find the deployment endpoint info for the given business interface and
    * expected endpoint type.
    * 
    * @param businessIntf - the interface the endpoint should implement
    * @param endpointType - the type of endpoint
    * @param vfsContext - the vfs relative path for the deployment initiating
    *    the resolution request.  This is used to properly resolve
    *    interface scopes from the inside out.
    * @return the matching endpoint info if found, null otherwise
    */
   @SuppressWarnings("unchecked")
   EndpointInfo getEndpointInfo(Class businessIntf, String endpointType, String vfsContext);

   /**
    * Find the deployment endpoint for the given reference name. This may be
    * relative name qualified by a path prefix, or just the endpoint name.
    * 
    * @param ref - relative or exact endpoint name
    * @param endpointType the type of endpoint
    * @param vfsContext - the vfs relative path for the deployment initiating
    *    the resolution request.  This is used to properly resolve
    *    relative references.
    * @return the matching endpoint info if found, null otherwise
    * @see EndpointType
    */
   EndpointInfo getEndpointInfo(String ref, String endpointType, String vfsContext);
   
}

