/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import java.util.Properties;

/**
 * Unit test that runs the the tests defined JDBCCacheLoaderTest using a standalone
 * connection pool factory based on c3p0 library.
 *
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class C3p0JDBCCacheLoaderTest extends JDBCCacheLoaderTest
{
   private static final String CF_CLASS = "org.jboss.cache.loader.C3p0ConnectionFactory";

   protected void configureCache() throws Exception
   {
      Properties prop = getProperties();

      String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" +
                     "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" +
                     "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" +
                     "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" +
                     "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" +
                     "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat") + "\n" +
                     "cache.jdbc.connection.factory=" + CF_CLASS;

      cache.getConfiguration().setCacheLoaderConfig(getSingleCacheLoaderConfig("",
                                                                               "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
   }
}
