/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.assertEquals;

import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * LFU Configuration test.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class LFUConfigurationTest
{

   public void testXMLParsing() throws Exception
   {
      LFUConfiguration config = new LFUConfiguration();
      String xml =
            "<region name=\"abc\">" +
            "<attribute name=\"minNodes\">10</attribute>" +
            "<attribute name=\"maxNodes\">20</attribute>" +
            "</region>";

      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(10, config.getMinNodes());
      assertEquals(20, config.getMaxNodes());
   }

   public void testXMLParsing2() throws Exception
   {
      LFUConfiguration config = new LFUConfiguration();
      String xml =
            "<region name=\"abc\">" +
            "<attribute name=\"minNodes\">10</attribute>" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(10, config.getMinNodes());
      assertEquals(0, config.getMaxNodes());
   }

   public void testXMLParsing3() throws Exception
   {
      LFUConfiguration config = new LFUConfiguration();
      String xml =
            "<region name=\"abc\">" +
            "<attribute name=\"maxNodes\">20</attribute>" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(0, config.getMinNodes());
      assertEquals(20, config.getMaxNodes());

   }
}
