package org.jboss.cache.notifications.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation should be used on methods that need to be notified when the cache is called to participate in a transaction and
 * the transaction completes, either with a commit or a rollback.
 * <p/>
 * Methods annotated with this annotation should accept a single
 * parameter, a {@link org.jboss.cache.notifications.event.TransactionCompletedEvent} otherwise a {@link org.jboss.cache.notifications.IncorrectCacheListenerException}
 * will be thrown when registering your listener.
 * <p/>
 * Note that methods marked with this annotation will only be fired <i>after the fact</i>, i.e., your method will never be
 * called with {@link org.jboss.cache.notifications.event.Event#isPre()} being set to <tt>true</tt>.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @see CacheListener
 * @since 2.0.0
 */
// ensure this annotation is available at runtime.
@Retention(RetentionPolicy.RUNTIME)
// ensure that this annotation is applied to classes.
@Target(ElementType.METHOD)
public @interface TransactionCompleted
{
}
