package org.jboss.cache.commands.tx;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.transaction.GlobalTransaction;

/**
 * Represents a commit() call, the 2nd part of a 2-phase commit.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
public class CommitCommand extends AbstractTransactionCommand
{
   public static final int METHOD_ID = 11;

   public CommitCommand(GlobalTransaction globalTransaction)
   {
      this.globalTransaction = globalTransaction;
   }

   public CommitCommand()
   {
   }

   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitCommitCommand(ctx, this);
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }
}
