package org.jboss.cache.commands;

import org.jboss.cache.optimistic.DataVersion;

/**
 * Just like a {@link org.jboss.cache.commands.DataCommand}, except that these are versioned and reversible too.  Versioning
 * is currently used by optimistic locking, and in future will be used by MVCC as well.
 *
 * @author Mircea.Markus@jboss.com
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public interface VersionedDataCommand extends ReversibleCommand
{
   /**
    * @return the DataVersion pertaining to this command.
    */
   DataVersion getDataVersion();

   /**
    * Sets the DataVersion pertaining to this command.
    *
    * @param dataVersion to set
    */
   void setDataVersion(DataVersion dataVersion);

   /**
    * Has data version set? (i.e. not null)
    *
    * @return true if getDataVersion() would not return null; false otherwise.
    */
   boolean isVersioned();
}
