package org.jboss.cache.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A marker annotation to mark that a class, method or field is experimental and as such, should be used with extreme
 * care as it may not be completely implemented, may not work at all, and/or may be prone to incompatible changes in
 * future releases.
 * <p/>
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
@Retention(RetentionPolicy.SOURCE)
@Target({ElementType.TYPE, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE,
      ElementType.METHOD, ElementType.PACKAGE, ElementType.PARAMETER})
public @interface Experimental
{
}
