/*
 * @(#)ReadByteStreamUTest.java
 *
 * Copyright (C) 2001,,2003 2002 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.io.v1;

import java.io.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * 
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    0.9.1d Alpha (sometime in 2001)
 * @version  $Date: 2003/05/23 22:37:58 $
 */
public class ReadByteStreamUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Global constructs that only depend upon the class name
    private static final Class THIS_CLASS = ReadByteStreamUTest.class;
    
    public ReadByteStreamUTest( String name )
    {
        super( name );
    }
    
    
    //-------------------------------------------------------------------------
    // Test methods
    
    public void testConstructor1()
    {
        try
        {
            new ReadByteStream( null );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception
        }
    }
    
    public void testConstructor2()
    {
        try
        {
            new ReadByteStream( null, 1, 1 );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception
        }
    }
    
    public void testConstructor3()
    {
        ByteArrayInputStream bais = new ByteArrayInputStream( new byte[0] );
        try
        {
            new ReadByteStream( bais, 0, 1 );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception
        }
    }
    
    
    public void testConstructor4()
    {
        ByteArrayInputStream bais = new ByteArrayInputStream( new byte[0] );
        try
        {
            new ReadByteStream( bais, 1, 0 );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception
        }
    }
    
    
    public void testConstructor5()
    {
        byte b[] = {};
        new ReadByteStream( createStream( b ), 1, 1 );
    }
    
    
    public void testReadByteStream1() throws IOException
    {
        byte in[] = {};
        ReadByteStream rbs = new ReadByteStream( createStream( in ) );
        byte out[] = rbs.readByteStream();
        assertEquals( "Did not read empty stream correctly", in, out );
    }
    
    
    public void testReadByteStream3() throws IOException
    {
        byte in[] = { (byte)1, Byte.MAX_VALUE, Byte.MIN_VALUE, (byte)0 };
        byte out[] = ReadByteStream.readByteStream( createStream( in ),
            ReadByteStream.READ_TO_END_OF_STREAM, 2 );
        assertEquals( "Did not read 4 byte stream correctly", in, out );
    }
    
    
    public void testReadByteStream4() throws IOException
    {
        byte in[] = { Byte.MAX_VALUE };
        byte out[] = ReadByteStream.readByteStream( createStream( in ),
            ReadByteStream.READ_TO_END_OF_STREAM, 2 );
        assertEquals( "Did not read 1 byte stream correctly", in, out );
    }
    
    
    public void testReadByteStream5() throws IOException
    {
        byte in[] = { (byte)1, Byte.MAX_VALUE, Byte.MIN_VALUE };
        byte out[] = ReadByteStream.readByteStream( createStream( in ),
            ReadByteStream.READ_TO_END_OF_STREAM, 2 );
        assertEquals( "Did not read 3 byte stream correctly", in, out );
    }
    
    
    public void testReadByteStream6() throws IOException
    {
        byte in[] = { (byte)1, Byte.MAX_VALUE, Byte.MIN_VALUE };
        byte out[] = ReadByteStream.readByteStream( createStream( in ) );
        assertEquals( "Did not read 3 byte stream correctly", in, out );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    protected InputStream createStream( byte[] b )
    {
        return new ByteArrayInputStream( b );
    }
    
    
    protected void assertEquals( String msg, byte[] expected, byte[] real )
    {
        if (expected == null)
        {
            assertNull( msg, real );
            return;
        }
        assertNotNull( msg, real );
        
        assertEquals(
            msg+": lengths are different.",
            expected.length,
            real.length);
        for (int i = 0; i < expected.length; ++i)
        {
            assertEquals( msg+": index "+i+" is different.",
                expected[i],
                real[i] );
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Global static methods that don't change.
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }

}
