/*
 *  @(#)DefaultAutoDocFactory.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.defimpl;


import net.sourceforge.groboutils.util.classes.v1.SPISingletonStore;

import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocFactory;
import net.sourceforge.groboutils.autodoc.v1.AutoDocLog;
import net.sourceforge.groboutils.autodoc.v1.AutoDocIT;
import net.sourceforge.groboutils.autodoc.v1.AutoDocTP;

import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocLogFactory;
import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocITFactory;
import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocTPFactory;

import java.util.Vector;
import java.util.Enumeration;

import org.apache.log4j.Logger;


/**
 * An interface which defines the kinds of classes which should be loaded
 * for the <tt>AutoDoc</tt> entry point.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:11 $
 * @since      March 16, 2002
 */
public class DefaultAutoDocFactory implements AutoDocFactory
{
    private static final Logger LOG = Logger.getLogger(
        DefaultAutoDocFactory.class.getName() );
    
    
    private static final SPISingletonStore s_lfStore = new SPISingletonStore(
        AutoDocLogFactory.class, SPISingletonStore.NO_MULTIPLES_SILENT );
    
    private static final SPISingletonStore s_itfStore = new SPISingletonStore(
        AutoDocITFactory.class, SPISingletonStore.NO_MULTIPLES_SILENT );
    
    private static final SPISingletonStore s_tpfStore = new SPISingletonStore(
        AutoDocTPFactory.class, SPISingletonStore.NO_MULTIPLES_SILENT );
    
    private Vector lf = null;
    private Vector itf = null;
    private Vector tpf = null;
    
    
    /**
     * Default constructor (required).
     */
    public DefaultAutoDocFactory()
    {
        // do nothing - delay the loading of the factory until the last
        // moment.
    }
    
    
    /**
     * Creates a new Log for the class owner.
     *
     * @param owner the Class owner, as passed to the <tt>AutoDoc</tt> class.
     * @return the loaded AutoDocLogFactory's created instance.
     */
    public AutoDocLog createLog( Class owner )
    {
        if (owner == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        AutoDocLogSet set = new AutoDocLogSet();
        Enumeration enum = getLogFactories();
        while (enum.hasMoreElements())
        {
            set.addLog( ((AutoDocLogFactory)enum.nextElement()).
                createLog( owner ) );
        }
        return set;
    }
    
    
    /**
     * Creates the Issue Tracker entry point.
     *
     * @param owner the Class owner, as passed to the <tt>AutoDoc</tt> class.
     * @return the loaded AutoDocITFactory's created instance.
     */
    public AutoDocIT createIT( Class owner )
    {
        if (owner == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        AutoDocITSet set = new AutoDocITSet();
        Enumeration enum = getITFactories();
        while (enum.hasMoreElements())
        {
            set.addIT( ((AutoDocITFactory)enum.nextElement()).
                createIT( owner ) );
        }
        return set;
    }
    
    
    /**
     * Creates a Test Procedure entry point.
     *
     * @param owner the Class owner, as passed to the <tt>AutoDoc</tt> class.
     * @return the loaded AutoDocTPFactory's created instance.
     */
    public AutoDocTP createTP( Class owner )
    {
        if (owner == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        AutoDocTPSet set = new AutoDocTPSet();
        Enumeration enum = getTPFactories();
        while (enum.hasMoreElements())
        {
            set.addTP( ((AutoDocTPFactory)enum.nextElement()).
                createTP( owner ) );
        }
        return set;
    }
    
    
    /**
     * Creates the Log factory if it has not yet been created, or the already
     * created factory.
     */
    protected Enumeration getLogFactories()
    {
        return getLogFactoryStore().getSingletons();
    }
    
    
    /**
     * Creates the IT factory if it has not yet been created, or the already
     * created factory.
     */
    protected Enumeration getITFactories()
    {
        return getITFactoryStore().getSingletons();
    }
    
    
    /**
     * Creates the TP factory if it has not yet been created, or the already
     * created factory.
     */
    protected Enumeration getTPFactories()
    {
        return getTPFactoryStore().getSingletons();
    }
    
    
    //-------------------------------------------------------------------------
    // Static methods
    
    
    /**
     * 
     */
    public static SPISingletonStore getLogFactoryStore()
    {
        return s_lfStore;
    }
    
    
    /**
     * 
     */
    public static SPISingletonStore getITFactoryStore()
    {
        return s_itfStore;
    }
    
    
    /**
     * 
     */
    public static SPISingletonStore getTPFactoryStore()
    {
        return s_tpfStore;
    }
}

