/*
 *  @(#)DefaultEditableAttributeSet.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.defimpl;

import net.sourceforge.groboutils.pmti.v1.IEditableAttributeSet;
import net.sourceforge.groboutils.pmti.v1.IEditableAttribute;
import net.sourceforge.groboutils.pmti.v1.IAttribute;


/**
 * An editable form of an IAttributeSet.  Note that the set of editable
 * attributes cannot be changed - just their contents.
 * <P>
 * Note: as written, this class is not easily extendable, especially if the
 * corresponding super class is different.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:58 $
 * @since      July 12, 2002
 */
public class DefaultEditableAttributeSet extends DefaultAttributeSet
        implements IEditableAttributeSet
{
    
    public DefaultEditableAttributeSet( IEditableAttribute a[] )
    {
        super( a );
    }
    
    
    /**
     * Synonymn for <tt>getAttributes()</tt>
     */
    public IEditableAttribute[] getEditableAttributes()
    {
        return (IEditableAttribute[])getAttributes();
    }
    
    
    /**
     * Synonymn for <tt>getAttribute( String )</tt>
     */
    public IEditableAttribute getEditableAttribute( String name )
    {
        return (IEditableAttribute)getAttribute( name );
    }
    
    
    
    protected IAttribute[] createAttributeArray( int size )
    {
        return new IEditableAttribute[ size ];
    }
}

