/*
 *  @(#)XMLFileParser.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1.xml;


import java.io.File;
import java.io.Reader;
import java.io.FileReader;
import java.io.IOException;

import java.net.URL;

import net.sourceforge.groboutils.pmti.v1.itf.parser.AbstractParser;
import net.sourceforge.groboutils.pmti.v1.itf.IIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecord;

import net.sourceforge.groboutils.pmti.v1.itf.impl.DefaultIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.impl.ImmutableTestRecord;
import net.sourceforge.groboutils.pmti.v1.itf.impl.DefaultTestIssueRecord;

import java.util.Locale;

import org.xml.sax.Locator;
import org.xml.sax.InputSource;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.DocumentHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.XMLReaderAdapter;
import org.xml.sax.Parser;

import org.apache.log4j.Logger;


/**
 * Parses the output of XMLFileServer.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:51:57 $
 */
public class XMLFileParser extends AbstractParser
{
    private static final Class THIS_CLASS = XMLFileParser.class;
    private static final org.apache.log4j.Logger LOG =
        org.apache.log4j.Logger.getLogger( THIS_CLASS );
    
    
    private File file;
    private Parser parser;
    
    
    public XMLFileParser( File f, Parser p )
    {
        if ( f == null
            || !f.exists()
            || !f.isFile()
            || !f.canRead() )
        {
            throw new IllegalArgumentException("not valid file: "+f);
        }
        if ( p == null )
        {
            throw new IllegalArgumentException("no null SAX parser");
        }
        
        this.parser = p;
        this.file = f;
    }
    
    
    protected void findRecords()
    {
        try
        {
            FileReader fr = new FileReader( this.file );
            try
            {
                InputSource source = new InputSource( fr );
                source.setSystemId( (new URL( "file:" +
                    this.file.getAbsolutePath() )).toString() );
            }
            finally
            {
                fr.close();
            }
        }
        catch (IOException ioe)
        {
            LOG.warn( "Error accessing file: "+this.file, ioe );
        }
    }
    
    
    //protected class 
}

