/*
 *  @(#)AbstractAppendFileServer.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1.server;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.io.FileWriter;

import net.sourceforge.groboutils.autodoc.v1.testserver.AbstractWriterServer;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;


/**
 * An interface which corresponds to a part of the framework that knows how
 * to deal with the framework's <tt>TestData</tt>.  It may directly deal with
 * the data, or pass it off to a remote server.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:56 $
 * @since      March 30, 2002
 */
public abstract class AbstractAppendFileServer extends AbstractWriterServer
{
    private File file;
    
    public AbstractAppendFileServer( File f )
    {
        if (f == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        this.file = f;
    }
    
    
    /**
     * Open a writer stream.  This will be done once per result, so log-like
     * actions may need to append to the previous results.
     */
    protected Writer openOutput( TestData td )
            throws IOException
    {
        // append to the end of the last write
        FileWriter fw = new FileWriter( this.file.getAbsolutePath(), true );
        return fw;
    }
}

