//  This software code is made available "AS IS" without warranties of any
//  kind.  You may copy, display, modify and redistribute the software
//  code either by itself or as incorporated into your code; provided that
//  you do not remove any proprietary notices.  Your use of this software
//  code is at your own risk and you waive any claim against Amazon
//  Digital Services, Inc. or its affiliates with respect to your use of
//  this software code. (c) 2006 Amazon Digital Services, Inc. or its
//  affiliates.

package net.noderunner.amazon.s3;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.httpclient.methods.GetMethod;

/**
 * A Response object returned from Connection.getStream(). 
 * This response, once read, must be released by calling {@link #release()}.
 */
public class GetStreamResponse extends Response {

	private GetMethod method;

	/**
	 * Pulls a representation of an S3Object out of the HttpURLConnection
	 * response.
	 */
	GetStreamResponse(GetMethod method) throws IOException {
		super(method);
		this.method = method;
	}
	
	/**
	 * Returns an input stream for the content.
	 * Call {@link #release}) after done reading.
	 * @throws IOException 
	 */
	public InputStream getInputStream() throws IOException {
		InputStream body = method.getResponseBodyAsStream();
		if (body == null)
			throw new IllegalStateException("body null");
		return body;
	}
	
	/**
	 * Returns the content length, if known. 
	 */
	public long getLength() {
		return method.getResponseContentLength();
	}
	
	/**
	 * Releases this connection.
	 */
	public void release() {
		method.releaseConnection();
	}

	/**
	 * Returns a debug string.
	 */
	@Override
	public String toString() {
		return super.toString() + " method=" + method;
	}
}
