/* Autogenerated: ECCKiila https://gitlab.com/nisec/ecckiila */
/*-
 * MIT License
 * 
 * Copyright (c) 2020 Luis Rivera-Zamarripa, Jesús-Javier Chi-Domínguez, Billy Bob Brumley
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#if defined(__SIZEOF_INT128__) && !defined(PEDANTIC)

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 64
#define LIMB_CNT 10
/* Field elements */
typedef uint64_t fe_t[LIMB_CNT];
typedef uint64_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_TC26_GOST_3410_2012_512_PARAMSETA_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

#define fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(c, a, b) \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_add(c, a, b);          \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(c, c)
#define fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(c, a, b) \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_sub(c, a, b);          \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(c, c)

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: unsaturated_solinas --static --use-value-barrier id_tc26_gost_3410_2012_512_paramSetA 64 '(auto)' '2^512 - 569' */
/* curve description: id_tc26_gost_3410_2012_512_paramSetA */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* n = 10 (from "(auto)") */
/* s-c = 2^512 - [(1, 569)] (from "2^512 - 569") */
/* tight_bounds_multiplier = 1 (from "") */
/*  */
/* Computed values: */
/* carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1] */
/* eval z = z[0] + (z[1] << 52) + (z[2] << 103) + (z[3] << 154) + (z[4] << 205) + (z[5] << 256) + (z[6] << 0x134) + (z[7] << 0x167) + (z[8] << 0x19a) + (z[9] << 0x1cd) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) */
/* balance = [0x1ffffffffffb8e, 0xffffffffffffe, 0xffffffffffffe, 0xffffffffffffe, 0xffffffffffffe, 0x1ffffffffffffe, 0xffffffffffffe, 0xffffffffffffe, 0xffffffffffffe, 0xffffffffffffe] */

#include <stdint.h>
typedef unsigned char fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1;
typedef signed char fiat_id_tc26_gost_3410_2012_512_paramSetA_int1;
typedef signed __int128 fiat_id_tc26_gost_3410_2012_512_paramSetA_int128;
typedef unsigned __int128 fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_TC26_GOST_3410_2012_512_PARAMSETA_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint64_t
fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u64(uint64_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u64(x) (x)
#endif

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u52 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^52
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^52⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffffffffff]
 *   arg3: [0x0 ~> 0xfffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u52(
    uint64_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    uint64_t x1;
    uint64_t x2;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT64_C(0xfffffffffffff));
    x3 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x1 >> 52);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u52 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^52
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^52⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xfffffffffffff]
 *   arg3: [0x0 ~> 0xfffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xfffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u52(
    uint64_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    int64_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_int1 x2;
    uint64_t x3;
    x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
    x2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(x1 >> 52);
    x3 = (x1 & UINT64_C(0xfffffffffffff));
    *out1 = x3;
    *out2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^51
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^51⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffffffffff]
 *   arg3: [0x0 ~> 0x7ffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
    uint64_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    uint64_t x1;
    uint64_t x2;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT64_C(0x7ffffffffffff));
    x3 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x1 >> 51);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^51
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^51⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffffffffff]
 *   arg3: [0x0 ~> 0x7ffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
    uint64_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    int64_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_int1 x2;
    uint64_t x3;
    x1 = ((int64_t)(arg2 - (int64_t)arg1) - (int64_t)arg3);
    x2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(x1 >> 51);
    x3 = (x1 & UINT64_C(0x7ffffffffffff));
    *out1 = x3;
    *out2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(
    uint64_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1,
    uint64_t arg2, uint64_t arg3) {
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(0x0 - x1) &
          UINT64_C(0xffffffffffffffff));
    x3 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u64(x2) &
           arg3) |
          (fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u64((~x2)) &
           arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 *   arg2: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(
    uint64_t out1[10], const uint64_t arg1[10], const uint64_t arg2[10]) {
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x2;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x3;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x4;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x5;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x6;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x7;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x8;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x9;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x10;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x11;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x12;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x13;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x14;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x15;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x16;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x17;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x18;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x19;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x20;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x21;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x22;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x23;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x24;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x25;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x26;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x27;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x28;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x29;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x30;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x31;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x32;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x33;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x34;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x35;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x36;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x37;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x38;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x39;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x40;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x41;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x42;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x43;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x44;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x45;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x46;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x47;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x48;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x49;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x50;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x51;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x52;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x53;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x54;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x55;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x56;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x57;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x58;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x59;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x60;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x61;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x62;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x63;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x64;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x65;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x66;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x67;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x68;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x69;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x70;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x71;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x72;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x73;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x74;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x75;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x76;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x77;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x78;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x79;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x80;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x81;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x82;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x83;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x84;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x85;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x86;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x87;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x88;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x89;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x90;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x91;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x92;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x93;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x94;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x95;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x96;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x97;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x98;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x99;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x100;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x101;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x102;
    uint64_t x103;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x104;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x105;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x106;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x107;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x108;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x109;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x110;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x111;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x112;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x113;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x114;
    uint64_t x115;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x116;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x117;
    uint64_t x118;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x119;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x120;
    uint64_t x121;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x122;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x123;
    uint64_t x124;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x125;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x126;
    uint64_t x127;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x128;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x129;
    uint64_t x130;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x131;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x132;
    uint64_t x133;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x134;
    uint64_t x135;
    uint64_t x136;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x137;
    uint64_t x138;
    uint64_t x139;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x140;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x145;
    uint64_t x146;
    uint64_t x147;
    x1 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[9])));
    x2 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[8])));
    x3 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[7])));
    x4 = (UINT16_C(0x239) *
          (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
            (arg2[6])) *
           0x2));
    x5 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[5])));
    x6 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[4])));
    x7 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[3])));
    x8 = (UINT16_C(0x239) *
          ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[2])));
    x9 = (UINT16_C(0x239) *
          (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
            (arg2[1])) *
           0x2));
    x10 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
            (arg2[9])));
    x11 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
            (arg2[8])));
    x12 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
             (arg2[7])) *
            0x2));
    x13 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
             (arg2[6])) *
            0x2));
    x14 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
            (arg2[5])));
    x15 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
            (arg2[4])));
    x16 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
            (arg2[3])));
    x17 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
             (arg2[2])) *
            0x2));
    x18 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
            (arg2[9])));
    x19 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
             (arg2[8])) *
            0x2));
    x20 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
             (arg2[7])) *
            0x2));
    x21 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
             (arg2[6])) *
            0x2));
    x22 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
            (arg2[5])));
    x23 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
            (arg2[4])));
    x24 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
             (arg2[3])) *
            0x2));
    x25 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
             (arg2[9])) *
            0x2));
    x26 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
             (arg2[8])) *
            0x2));
    x27 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
             (arg2[7])) *
            0x2));
    x28 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
             (arg2[6])) *
            0x2));
    x29 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
            (arg2[5])));
    x30 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
             (arg2[4])) *
            0x2));
    x31 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
            (arg2[9])));
    x32 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
            (arg2[8])));
    x33 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
            (arg2[7])));
    x34 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
            (arg2[6])));
    x35 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
            (arg2[5])));
    x36 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
            (arg2[9])));
    x37 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
            (arg2[8])));
    x38 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
            (arg2[7])));
    x39 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
             (arg2[6])) *
            0x2));
    x40 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
            (arg2[9])));
    x41 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
            (arg2[8])));
    x42 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
             (arg2[7])) *
            0x2));
    x43 = (UINT16_C(0x239) *
           ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
            (arg2[9])));
    x44 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
             (arg2[8])) *
            0x2));
    x45 = (UINT16_C(0x239) *
           (((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
             (arg2[9])) *
            0x2));
    x46 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) *
           (arg2[0]));
    x47 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
           ((arg2[1]) * 0x2));
    x48 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) *
           (arg2[0]));
    x49 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
           ((arg2[2]) * 0x2));
    x50 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
           ((arg2[1]) * 0x2));
    x51 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
           (arg2[0]));
    x52 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           ((arg2[3]) * 0x2));
    x53 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           ((arg2[2]) * 0x2));
    x54 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           ((arg2[1]) * 0x2));
    x55 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           (arg2[0]));
    x56 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
           (arg2[4]));
    x57 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
           (arg2[3]));
    x58 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
           (arg2[2]));
    x59 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
           (arg2[1]));
    x60 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) *
           (arg2[0]));
    x61 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg2[5]));
    x62 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg2[4]));
    x63 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg2[3]));
    x64 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg2[2]));
    x65 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           ((arg2[1]) * 0x2));
    x66 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg2[0]));
    x67 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           ((arg2[6]) * 0x2));
    x68 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (arg2[5]));
    x69 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (arg2[4]));
    x70 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (arg2[3]));
    x71 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           ((arg2[2]) * 0x2));
    x72 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           ((arg2[1]) * 0x2));
    x73 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (arg2[0]));
    x74 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg2[7]) * 0x2));
    x75 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg2[6]) * 0x2));
    x76 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (arg2[5]));
    x77 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (arg2[4]));
    x78 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg2[3]) * 0x2));
    x79 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg2[2]) * 0x2));
    x80 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg2[1]) * 0x2));
    x81 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (arg2[0]));
    x82 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[8]) * 0x2));
    x83 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[7]) * 0x2));
    x84 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[6]) * 0x2));
    x85 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (arg2[5]));
    x86 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[4]) * 0x2));
    x87 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[3]) * 0x2));
    x88 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[2]) * 0x2));
    x89 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg2[1]) * 0x2));
    x90 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (arg2[0]));
    x91 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[9]));
    x92 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[8]));
    x93 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[7]));
    x94 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[6]));
    x95 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[5]));
    x96 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[4]));
    x97 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[3]));
    x98 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[2]));
    x99 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg2[1]));
    x100 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
            (arg2[0]));
    x101 = (x100 +
            (x45 + (x44 + (x42 + (x39 + (x35 + (x30 + (x24 + (x17 + x9)))))))));
    x102 = (x101 >> 52);
    x103 = (uint64_t)(x101 & UINT64_C(0xfffffffffffff));
    x104 =
        (x91 +
         (x82 + (x74 + (x67 + (x61 + (x56 + (x52 + (x49 + (x47 + x46)))))))));
    x105 = (x92 +
            (x83 + (x75 + (x68 + (x62 + (x57 + (x53 + (x50 + (x48 + x1)))))))));
    x106 = (x93 +
            (x84 + (x76 + (x69 + (x63 + (x58 + (x54 + (x51 + (x10 + x2)))))))));
    x107 = (x94 +
            (x85 + (x77 + (x70 + (x64 + (x59 + (x55 + (x18 + (x11 + x3)))))))));
    x108 = (x95 +
            (x86 + (x78 + (x71 + (x65 + (x60 + (x25 + (x19 + (x12 + x4)))))))));
    x109 = (x96 +
            (x87 + (x79 + (x72 + (x66 + (x31 + (x26 + (x20 + (x13 + x5)))))))));
    x110 = (x97 +
            (x88 + (x80 + (x73 + (x36 + (x32 + (x27 + (x21 + (x14 + x6)))))))));
    x111 = (x98 +
            (x89 + (x81 + (x40 + (x37 + (x33 + (x28 + (x22 + (x15 + x7)))))))));
    x112 = (x99 +
            (x90 + (x43 + (x41 + (x38 + (x34 + (x29 + (x23 + (x16 + x8)))))))));
    x113 = (x102 + x112);
    x114 = (x113 >> 51);
    x115 = (uint64_t)(x113 & UINT64_C(0x7ffffffffffff));
    x116 = (x114 + x111);
    x117 = (x116 >> 51);
    x118 = (uint64_t)(x116 & UINT64_C(0x7ffffffffffff));
    x119 = (x117 + x110);
    x120 = (x119 >> 51);
    x121 = (uint64_t)(x119 & UINT64_C(0x7ffffffffffff));
    x122 = (x120 + x109);
    x123 = (x122 >> 51);
    x124 = (uint64_t)(x122 & UINT64_C(0x7ffffffffffff));
    x125 = (x123 + x108);
    x126 = (x125 >> 52);
    x127 = (uint64_t)(x125 & UINT64_C(0xfffffffffffff));
    x128 = (x126 + x107);
    x129 = (x128 >> 51);
    x130 = (uint64_t)(x128 & UINT64_C(0x7ffffffffffff));
    x131 = (x129 + x106);
    x132 = (x131 >> 51);
    x133 = (uint64_t)(x131 & UINT64_C(0x7ffffffffffff));
    x134 = (x132 + x105);
    x135 = (uint64_t)(x134 >> 51);
    x136 = (uint64_t)(x134 & UINT64_C(0x7ffffffffffff));
    x137 = (x135 + x104);
    x138 = (uint64_t)(x137 >> 51);
    x139 = (uint64_t)(x137 & UINT64_C(0x7ffffffffffff));
    x140 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)UINT16_C(0x239) *
            x138);
    x141 = (x103 + x140);
    x142 = (uint64_t)(x141 >> 52);
    x143 = (uint64_t)(x141 & UINT64_C(0xfffffffffffff));
    x144 = (x142 + x115);
    x145 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x144 >> 51);
    x146 = (x144 & UINT64_C(0x7ffffffffffff));
    x147 = (x145 + x118);
    out1[0] = x143;
    out1[1] = x146;
    out1[2] = x147;
    out1[3] = x121;
    out1[4] = x124;
    out1[5] = x127;
    out1[6] = x130;
    out1[7] = x133;
    out1[8] = x136;
    out1[9] = x139;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(
    uint64_t out1[10], const uint64_t arg1[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x19;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x20;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x21;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x22;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x23;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x24;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x25;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x26;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x27;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x28;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x29;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x30;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x31;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x32;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x33;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x34;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x35;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x36;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x37;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x38;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x39;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x40;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x41;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x42;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x43;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x44;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x45;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x46;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x47;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x48;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x49;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x50;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x51;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x52;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x53;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x54;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x55;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x56;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x57;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x58;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x59;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x60;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x61;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x62;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x63;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x64;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x65;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x66;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x67;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x68;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x69;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x70;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x71;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x72;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x73;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x74;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x75;
    uint64_t x76;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x77;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x78;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x79;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x80;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x81;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x82;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x83;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x84;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x85;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x86;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x87;
    uint64_t x88;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x89;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x90;
    uint64_t x91;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x92;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x93;
    uint64_t x94;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x95;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x96;
    uint64_t x97;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x98;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x99;
    uint64_t x100;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x101;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x102;
    uint64_t x103;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x104;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x105;
    uint64_t x106;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x107;
    uint64_t x108;
    uint64_t x109;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x110;
    uint64_t x111;
    uint64_t x112;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x113;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128 x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x118;
    uint64_t x119;
    uint64_t x120;
    x1 = ((arg1[9]) * UINT16_C(0x239));
    x2 = (x1 * 0x2);
    x3 = ((arg1[9]) * 0x2);
    x4 = ((arg1[8]) * UINT16_C(0x239));
    x5 = (x4 * 0x2);
    x6 = ((arg1[8]) * 0x2);
    x7 = ((arg1[7]) * UINT16_C(0x239));
    x8 = (x7 * 0x2);
    x9 = ((arg1[7]) * 0x2);
    x10 = ((arg1[6]) * UINT16_C(0x239));
    x11 = (x10 * 0x2);
    x12 = ((arg1[6]) * 0x2);
    x13 = ((arg1[5]) * UINT16_C(0x239));
    x14 = ((arg1[5]) * 0x2);
    x15 = ((arg1[4]) * 0x2);
    x16 = ((arg1[3]) * 0x2);
    x17 = ((arg1[2]) * 0x2);
    x18 = ((arg1[1]) * 0x2);
    x19 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[9]) * x1);
    x20 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) * x2);
    x21 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[8]) * x4);
    x22 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) * x2);
    x23 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
           (x5 * 0x2));
    x24 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[7]) *
           (x7 * 0x2));
    x25 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           (x2 * 0x2));
    x26 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           (x5 * 0x2));
    x27 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           (x8 * 0x2));
    x28 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[6]) *
           (x10 * 0x2));
    x29 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) * x2);
    x30 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) * x5);
    x31 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) * x8);
    x32 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) * x11);
    x33 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[5]) * x13);
    x34 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) * x2);
    x35 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) * x5);
    x36 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) * x8);
    x37 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (x11 * 0x2));
    x38 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) * x14);
    x39 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[4]) *
           (arg1[4]));
    x40 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) * x2);
    x41 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) * x5);
    x42 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (x8 * 0x2));
    x43 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (x12 * 0x2));
    x44 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) * x14);
    x45 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) * x15);
    x46 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[3]) *
           (arg1[3]));
    x47 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) * x2);
    x48 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (x5 * 0x2));
    x49 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (x9 * 0x2));
    x50 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (x12 * 0x2));
    x51 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) * x14);
    x52 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) * x15);
    x53 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           (x16 * 0x2));
    x54 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[2]) *
           ((arg1[2]) * 0x2));
    x55 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x2 * 0x2));
    x56 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x6 * 0x2));
    x57 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x9 * 0x2));
    x58 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x12 * 0x2));
    x59 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) * x14);
    x60 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x15 * 0x2));
    x61 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x16 * 0x2));
    x62 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           (x17 * 0x2));
    x63 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[1]) *
           ((arg1[1]) * 0x2));
    x64 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x3);
    x65 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x6);
    x66 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x9);
    x67 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x12);
    x68 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x14);
    x69 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x15);
    x70 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x16);
    x71 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x17);
    x72 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) * x18);
    x73 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)(arg1[0]) *
           (arg1[0]));
    x74 = (x73 + (x55 + (x48 + (x42 + (x37 + x33)))));
    x75 = (x74 >> 52);
    x76 = (uint64_t)(x74 & UINT64_C(0xfffffffffffff));
    x77 = (x64 + (x56 + (x49 + (x43 + x38))));
    x78 = (x65 + (x57 + (x50 + (x44 + (x39 + x19)))));
    x79 = (x66 + (x58 + (x51 + (x45 + x20))));
    x80 = (x67 + (x59 + (x52 + (x46 + (x22 + x21)))));
    x81 = (x68 + (x60 + (x53 + (x25 + x23))));
    x82 = (x69 + (x61 + (x54 + (x29 + (x26 + x24)))));
    x83 = (x70 + (x62 + (x34 + (x30 + x27))));
    x84 = (x71 + (x63 + (x40 + (x35 + (x31 + x28)))));
    x85 = (x72 + (x47 + (x41 + (x36 + x32))));
    x86 = (x75 + x85);
    x87 = (x86 >> 51);
    x88 = (uint64_t)(x86 & UINT64_C(0x7ffffffffffff));
    x89 = (x87 + x84);
    x90 = (x89 >> 51);
    x91 = (uint64_t)(x89 & UINT64_C(0x7ffffffffffff));
    x92 = (x90 + x83);
    x93 = (x92 >> 51);
    x94 = (uint64_t)(x92 & UINT64_C(0x7ffffffffffff));
    x95 = (x93 + x82);
    x96 = (x95 >> 51);
    x97 = (uint64_t)(x95 & UINT64_C(0x7ffffffffffff));
    x98 = (x96 + x81);
    x99 = (x98 >> 52);
    x100 = (uint64_t)(x98 & UINT64_C(0xfffffffffffff));
    x101 = (x99 + x80);
    x102 = (x101 >> 51);
    x103 = (uint64_t)(x101 & UINT64_C(0x7ffffffffffff));
    x104 = (x102 + x79);
    x105 = (x104 >> 51);
    x106 = (uint64_t)(x104 & UINT64_C(0x7ffffffffffff));
    x107 = (x105 + x78);
    x108 = (uint64_t)(x107 >> 51);
    x109 = (uint64_t)(x107 & UINT64_C(0x7ffffffffffff));
    x110 = (x108 + x77);
    x111 = (uint64_t)(x110 >> 51);
    x112 = (uint64_t)(x110 & UINT64_C(0x7ffffffffffff));
    x113 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint128)UINT16_C(0x239) *
            x111);
    x114 = (x76 + x113);
    x115 = (uint64_t)(x114 >> 52);
    x116 = (uint64_t)(x114 & UINT64_C(0xfffffffffffff));
    x117 = (x115 + x88);
    x118 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x117 >> 51);
    x119 = (x117 & UINT64_C(0x7ffffffffffff));
    x120 = (x118 + x91);
    out1[0] = x116;
    out1[1] = x119;
    out1[2] = x120;
    out1[3] = x94;
    out1[4] = x97;
    out1[5] = x100;
    out1[6] = x103;
    out1[7] = x106;
    out1[8] = x109;
    out1[9] = x112;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(
    uint64_t out1[10], const uint64_t arg1[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    x1 = (arg1[0]);
    x2 = ((x1 >> 52) + (arg1[1]));
    x3 = ((x2 >> 51) + (arg1[2]));
    x4 = ((x3 >> 51) + (arg1[3]));
    x5 = ((x4 >> 51) + (arg1[4]));
    x6 = ((x5 >> 51) + (arg1[5]));
    x7 = ((x6 >> 52) + (arg1[6]));
    x8 = ((x7 >> 51) + (arg1[7]));
    x9 = ((x8 >> 51) + (arg1[8]));
    x10 = ((x9 >> 51) + (arg1[9]));
    x11 = ((x1 & UINT64_C(0xfffffffffffff)) + (UINT16_C(0x239) * (x10 >> 51)));
    x12 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x11 >> 52) +
           (x2 & UINT64_C(0x7ffffffffffff)));
    x13 = (x11 & UINT64_C(0xfffffffffffff));
    x14 = (x12 & UINT64_C(0x7ffffffffffff));
    x15 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x12 >> 51) +
           (x3 & UINT64_C(0x7ffffffffffff)));
    x16 = (x4 & UINT64_C(0x7ffffffffffff));
    x17 = (x5 & UINT64_C(0x7ffffffffffff));
    x18 = (x6 & UINT64_C(0xfffffffffffff));
    x19 = (x7 & UINT64_C(0x7ffffffffffff));
    x20 = (x8 & UINT64_C(0x7ffffffffffff));
    x21 = (x9 & UINT64_C(0x7ffffffffffff));
    x22 = (x10 & UINT64_C(0x7ffffffffffff));
    out1[0] = x13;
    out1[1] = x14;
    out1[2] = x15;
    out1[3] = x16;
    out1[4] = x17;
    out1[5] = x18;
    out1[6] = x19;
    out1[7] = x20;
    out1[8] = x21;
    out1[9] = x22;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 *   arg2: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_add(
    uint64_t out1[10], const uint64_t arg1[10], const uint64_t arg2[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    x1 = ((arg1[0]) + (arg2[0]));
    x2 = ((arg1[1]) + (arg2[1]));
    x3 = ((arg1[2]) + (arg2[2]));
    x4 = ((arg1[3]) + (arg2[3]));
    x5 = ((arg1[4]) + (arg2[4]));
    x6 = ((arg1[5]) + (arg2[5]));
    x7 = ((arg1[6]) + (arg2[6]));
    x8 = ((arg1[7]) + (arg2[7]));
    x9 = ((arg1[8]) + (arg2[8]));
    x10 = ((arg1[9]) + (arg2[9]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 *   arg2: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_sub(
    uint64_t out1[10], const uint64_t arg1[10], const uint64_t arg2[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    x1 = ((UINT64_C(0x1ffffffffffb8e) + (arg1[0])) - (arg2[0]));
    x2 = ((UINT64_C(0xffffffffffffe) + (arg1[1])) - (arg2[1]));
    x3 = ((UINT64_C(0xffffffffffffe) + (arg1[2])) - (arg2[2]));
    x4 = ((UINT64_C(0xffffffffffffe) + (arg1[3])) - (arg2[3]));
    x5 = ((UINT64_C(0xffffffffffffe) + (arg1[4])) - (arg2[4]));
    x6 = ((UINT64_C(0x1ffffffffffffe) + (arg1[5])) - (arg2[5]));
    x7 = ((UINT64_C(0xffffffffffffe) + (arg1[6])) - (arg2[6]));
    x8 = ((UINT64_C(0xffffffffffffe) + (arg1[7])) - (arg2[7]));
    x9 = ((UINT64_C(0xffffffffffffe) + (arg1[8])) - (arg2[8]));
    x10 = ((UINT64_C(0xffffffffffffe) + (arg1[9])) - (arg2[9]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x30000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000], [0x0 ~> 0x18000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(
    uint64_t out1[10], const uint64_t arg1[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    x1 = (UINT64_C(0x1ffffffffffb8e) - (arg1[0]));
    x2 = (UINT64_C(0xffffffffffffe) - (arg1[1]));
    x3 = (UINT64_C(0xffffffffffffe) - (arg1[2]));
    x4 = (UINT64_C(0xffffffffffffe) - (arg1[3]));
    x5 = (UINT64_C(0xffffffffffffe) - (arg1[4]));
    x6 = (UINT64_C(0x1ffffffffffffe) - (arg1[5]));
    x7 = (UINT64_C(0xffffffffffffe) - (arg1[6]));
    x8 = (UINT64_C(0xffffffffffffe) - (arg1[7]));
    x9 = (UINT64_C(0xffffffffffffe) - (arg1[8]));
    x10 = (UINT64_C(0xffffffffffffe) - (arg1[9]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
    uint64_t out1[10], fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1,
    const uint64_t arg2[10], const uint64_t arg3[10]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x1, arg1, (arg2[0]),
                                                          (arg3[0]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x2, arg1, (arg2[1]),
                                                          (arg3[1]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x3, arg1, (arg2[2]),
                                                          (arg3[2]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x4, arg1, (arg2[3]),
                                                          (arg3[3]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x5, arg1, (arg2[4]),
                                                          (arg3[4]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x6, arg1, (arg2[5]),
                                                          (arg3[5]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x7, arg1, (arg2[6]),
                                                          (arg3[6]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x8, arg1, (arg2[7]),
                                                          (arg3[7]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x9, arg1, (arg2[8]),
                                                          (arg3[8]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(&x10, arg1, (arg2[9]),
                                                          (arg3[9]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..63]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(
    uint8_t out1[64], const uint64_t arg1[10]) {
    uint64_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x2;
    uint64_t x3;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x4;
    uint64_t x5;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x6;
    uint64_t x7;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x8;
    uint64_t x9;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x10;
    uint64_t x11;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x12;
    uint64_t x13;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x14;
    uint64_t x15;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x16;
    uint64_t x17;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x18;
    uint64_t x19;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x20;
    uint64_t x21;
    uint64_t x22;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x23;
    uint64_t x24;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x25;
    uint64_t x26;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x27;
    uint64_t x28;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x29;
    uint64_t x30;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x31;
    uint64_t x32;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x33;
    uint64_t x34;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x35;
    uint64_t x36;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x37;
    uint64_t x38;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x39;
    uint64_t x40;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint8_t x50;
    uint64_t x51;
    uint8_t x52;
    uint64_t x53;
    uint8_t x54;
    uint64_t x55;
    uint8_t x56;
    uint64_t x57;
    uint8_t x58;
    uint64_t x59;
    uint8_t x60;
    uint8_t x61;
    uint64_t x62;
    uint8_t x63;
    uint64_t x64;
    uint8_t x65;
    uint64_t x66;
    uint8_t x67;
    uint64_t x68;
    uint8_t x69;
    uint64_t x70;
    uint8_t x71;
    uint64_t x72;
    uint8_t x73;
    uint8_t x74;
    uint64_t x75;
    uint8_t x76;
    uint64_t x77;
    uint8_t x78;
    uint64_t x79;
    uint8_t x80;
    uint64_t x81;
    uint8_t x82;
    uint64_t x83;
    uint8_t x84;
    uint64_t x85;
    uint8_t x86;
    uint64_t x87;
    uint8_t x88;
    uint8_t x89;
    uint64_t x90;
    uint8_t x91;
    uint64_t x92;
    uint8_t x93;
    uint64_t x94;
    uint8_t x95;
    uint64_t x96;
    uint8_t x97;
    uint64_t x98;
    uint8_t x99;
    uint64_t x100;
    uint8_t x101;
    uint8_t x102;
    uint64_t x103;
    uint8_t x104;
    uint64_t x105;
    uint8_t x106;
    uint64_t x107;
    uint8_t x108;
    uint64_t x109;
    uint8_t x110;
    uint64_t x111;
    uint8_t x112;
    uint64_t x113;
    uint8_t x114;
    uint8_t x115;
    uint8_t x116;
    uint64_t x117;
    uint8_t x118;
    uint64_t x119;
    uint8_t x120;
    uint64_t x121;
    uint8_t x122;
    uint64_t x123;
    uint8_t x124;
    uint64_t x125;
    uint8_t x126;
    uint8_t x127;
    uint64_t x128;
    uint8_t x129;
    uint64_t x130;
    uint8_t x131;
    uint64_t x132;
    uint8_t x133;
    uint64_t x134;
    uint8_t x135;
    uint64_t x136;
    uint8_t x137;
    uint64_t x138;
    uint8_t x139;
    uint8_t x140;
    uint64_t x141;
    uint8_t x142;
    uint64_t x143;
    uint8_t x144;
    uint64_t x145;
    uint8_t x146;
    uint64_t x147;
    uint8_t x148;
    uint64_t x149;
    uint8_t x150;
    uint64_t x151;
    uint8_t x152;
    uint64_t x153;
    uint8_t x154;
    uint8_t x155;
    uint64_t x156;
    uint8_t x157;
    uint64_t x158;
    uint8_t x159;
    uint64_t x160;
    uint8_t x161;
    uint64_t x162;
    uint8_t x163;
    uint64_t x164;
    uint8_t x165;
    uint64_t x166;
    uint8_t x167;
    uint8_t x168;
    uint64_t x169;
    uint8_t x170;
    uint64_t x171;
    uint8_t x172;
    uint64_t x173;
    uint8_t x174;
    uint64_t x175;
    uint8_t x176;
    uint64_t x177;
    uint8_t x178;
    uint64_t x179;
    uint8_t x180;
    uint8_t x181;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u52(
        &x1, &x2, 0x0, (arg1[0]), UINT64_C(0xffffffffffdc7));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x3, &x4, x2, (arg1[1]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x5, &x6, x4, (arg1[2]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x7, &x8, x6, (arg1[3]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x9, &x10, x8, (arg1[4]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u52(
        &x11, &x12, x10, (arg1[5]), UINT64_C(0xfffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x13, &x14, x12, (arg1[6]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x15, &x16, x14, (arg1[7]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x17, &x18, x16, (arg1[8]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u51(
        &x19, &x20, x18, (arg1[9]), UINT64_C(0x7ffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u64(
        &x21, x20, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u52(
        &x22, &x23, 0x0, x1, (x21 & UINT64_C(0xffffffffffdc7)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x24, &x25, x23, x3, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x26, &x27, x25, x5, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x28, &x29, x27, x7, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x30, &x31, x29, x9, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u52(
        &x32, &x33, x31, x11, (x21 & UINT64_C(0xfffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x34, &x35, x33, x13, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x36, &x37, x35, x15, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x38, &x39, x37, x17, (x21 & UINT64_C(0x7ffffffffffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u51(
        &x40, &x41, x39, x19, (x21 & UINT64_C(0x7ffffffffffff)));
    x42 = (x40 << 5);
    x43 = (x38 << 2);
    x44 = (x36 << 7);
    x45 = (x34 << 4);
    x46 = (x30 << 5);
    x47 = (x28 << 2);
    x48 = (x26 << 7);
    x49 = (x24 << 4);
    x50 = (uint8_t)(x22 & UINT8_C(0xff));
    x51 = (x22 >> 8);
    x52 = (uint8_t)(x51 & UINT8_C(0xff));
    x53 = (x51 >> 8);
    x54 = (uint8_t)(x53 & UINT8_C(0xff));
    x55 = (x53 >> 8);
    x56 = (uint8_t)(x55 & UINT8_C(0xff));
    x57 = (x55 >> 8);
    x58 = (uint8_t)(x57 & UINT8_C(0xff));
    x59 = (x57 >> 8);
    x60 = (uint8_t)(x59 & UINT8_C(0xff));
    x61 = (uint8_t)(x59 >> 8);
    x62 = (x49 + (uint64_t)x61);
    x63 = (uint8_t)(x62 & UINT8_C(0xff));
    x64 = (x62 >> 8);
    x65 = (uint8_t)(x64 & UINT8_C(0xff));
    x66 = (x64 >> 8);
    x67 = (uint8_t)(x66 & UINT8_C(0xff));
    x68 = (x66 >> 8);
    x69 = (uint8_t)(x68 & UINT8_C(0xff));
    x70 = (x68 >> 8);
    x71 = (uint8_t)(x70 & UINT8_C(0xff));
    x72 = (x70 >> 8);
    x73 = (uint8_t)(x72 & UINT8_C(0xff));
    x74 = (uint8_t)(x72 >> 8);
    x75 = (x48 + (uint64_t)x74);
    x76 = (uint8_t)(x75 & UINT8_C(0xff));
    x77 = (x75 >> 8);
    x78 = (uint8_t)(x77 & UINT8_C(0xff));
    x79 = (x77 >> 8);
    x80 = (uint8_t)(x79 & UINT8_C(0xff));
    x81 = (x79 >> 8);
    x82 = (uint8_t)(x81 & UINT8_C(0xff));
    x83 = (x81 >> 8);
    x84 = (uint8_t)(x83 & UINT8_C(0xff));
    x85 = (x83 >> 8);
    x86 = (uint8_t)(x85 & UINT8_C(0xff));
    x87 = (x85 >> 8);
    x88 = (uint8_t)(x87 & UINT8_C(0xff));
    x89 = (uint8_t)(x87 >> 8);
    x90 = (x47 + (uint64_t)x89);
    x91 = (uint8_t)(x90 & UINT8_C(0xff));
    x92 = (x90 >> 8);
    x93 = (uint8_t)(x92 & UINT8_C(0xff));
    x94 = (x92 >> 8);
    x95 = (uint8_t)(x94 & UINT8_C(0xff));
    x96 = (x94 >> 8);
    x97 = (uint8_t)(x96 & UINT8_C(0xff));
    x98 = (x96 >> 8);
    x99 = (uint8_t)(x98 & UINT8_C(0xff));
    x100 = (x98 >> 8);
    x101 = (uint8_t)(x100 & UINT8_C(0xff));
    x102 = (uint8_t)(x100 >> 8);
    x103 = (x46 + (uint64_t)x102);
    x104 = (uint8_t)(x103 & UINT8_C(0xff));
    x105 = (x103 >> 8);
    x106 = (uint8_t)(x105 & UINT8_C(0xff));
    x107 = (x105 >> 8);
    x108 = (uint8_t)(x107 & UINT8_C(0xff));
    x109 = (x107 >> 8);
    x110 = (uint8_t)(x109 & UINT8_C(0xff));
    x111 = (x109 >> 8);
    x112 = (uint8_t)(x111 & UINT8_C(0xff));
    x113 = (x111 >> 8);
    x114 = (uint8_t)(x113 & UINT8_C(0xff));
    x115 = (uint8_t)(x113 >> 8);
    x116 = (uint8_t)(x32 & UINT8_C(0xff));
    x117 = (x32 >> 8);
    x118 = (uint8_t)(x117 & UINT8_C(0xff));
    x119 = (x117 >> 8);
    x120 = (uint8_t)(x119 & UINT8_C(0xff));
    x121 = (x119 >> 8);
    x122 = (uint8_t)(x121 & UINT8_C(0xff));
    x123 = (x121 >> 8);
    x124 = (uint8_t)(x123 & UINT8_C(0xff));
    x125 = (x123 >> 8);
    x126 = (uint8_t)(x125 & UINT8_C(0xff));
    x127 = (uint8_t)(x125 >> 8);
    x128 = (x45 + (uint64_t)x127);
    x129 = (uint8_t)(x128 & UINT8_C(0xff));
    x130 = (x128 >> 8);
    x131 = (uint8_t)(x130 & UINT8_C(0xff));
    x132 = (x130 >> 8);
    x133 = (uint8_t)(x132 & UINT8_C(0xff));
    x134 = (x132 >> 8);
    x135 = (uint8_t)(x134 & UINT8_C(0xff));
    x136 = (x134 >> 8);
    x137 = (uint8_t)(x136 & UINT8_C(0xff));
    x138 = (x136 >> 8);
    x139 = (uint8_t)(x138 & UINT8_C(0xff));
    x140 = (uint8_t)(x138 >> 8);
    x141 = (x44 + (uint64_t)x140);
    x142 = (uint8_t)(x141 & UINT8_C(0xff));
    x143 = (x141 >> 8);
    x144 = (uint8_t)(x143 & UINT8_C(0xff));
    x145 = (x143 >> 8);
    x146 = (uint8_t)(x145 & UINT8_C(0xff));
    x147 = (x145 >> 8);
    x148 = (uint8_t)(x147 & UINT8_C(0xff));
    x149 = (x147 >> 8);
    x150 = (uint8_t)(x149 & UINT8_C(0xff));
    x151 = (x149 >> 8);
    x152 = (uint8_t)(x151 & UINT8_C(0xff));
    x153 = (x151 >> 8);
    x154 = (uint8_t)(x153 & UINT8_C(0xff));
    x155 = (uint8_t)(x153 >> 8);
    x156 = (x43 + (uint64_t)x155);
    x157 = (uint8_t)(x156 & UINT8_C(0xff));
    x158 = (x156 >> 8);
    x159 = (uint8_t)(x158 & UINT8_C(0xff));
    x160 = (x158 >> 8);
    x161 = (uint8_t)(x160 & UINT8_C(0xff));
    x162 = (x160 >> 8);
    x163 = (uint8_t)(x162 & UINT8_C(0xff));
    x164 = (x162 >> 8);
    x165 = (uint8_t)(x164 & UINT8_C(0xff));
    x166 = (x164 >> 8);
    x167 = (uint8_t)(x166 & UINT8_C(0xff));
    x168 = (uint8_t)(x166 >> 8);
    x169 = (x42 + (uint64_t)x168);
    x170 = (uint8_t)(x169 & UINT8_C(0xff));
    x171 = (x169 >> 8);
    x172 = (uint8_t)(x171 & UINT8_C(0xff));
    x173 = (x171 >> 8);
    x174 = (uint8_t)(x173 & UINT8_C(0xff));
    x175 = (x173 >> 8);
    x176 = (uint8_t)(x175 & UINT8_C(0xff));
    x177 = (x175 >> 8);
    x178 = (uint8_t)(x177 & UINT8_C(0xff));
    x179 = (x177 >> 8);
    x180 = (uint8_t)(x179 & UINT8_C(0xff));
    x181 = (uint8_t)(x179 >> 8);
    out1[0] = x50;
    out1[1] = x52;
    out1[2] = x54;
    out1[3] = x56;
    out1[4] = x58;
    out1[5] = x60;
    out1[6] = x63;
    out1[7] = x65;
    out1[8] = x67;
    out1[9] = x69;
    out1[10] = x71;
    out1[11] = x73;
    out1[12] = x76;
    out1[13] = x78;
    out1[14] = x80;
    out1[15] = x82;
    out1[16] = x84;
    out1[17] = x86;
    out1[18] = x88;
    out1[19] = x91;
    out1[20] = x93;
    out1[21] = x95;
    out1[22] = x97;
    out1[23] = x99;
    out1[24] = x101;
    out1[25] = x104;
    out1[26] = x106;
    out1[27] = x108;
    out1[28] = x110;
    out1[29] = x112;
    out1[30] = x114;
    out1[31] = x115;
    out1[32] = x116;
    out1[33] = x118;
    out1[34] = x120;
    out1[35] = x122;
    out1[36] = x124;
    out1[37] = x126;
    out1[38] = x129;
    out1[39] = x131;
    out1[40] = x133;
    out1[41] = x135;
    out1[42] = x137;
    out1[43] = x139;
    out1[44] = x142;
    out1[45] = x144;
    out1[46] = x146;
    out1[47] = x148;
    out1[48] = x150;
    out1[49] = x152;
    out1[50] = x154;
    out1[51] = x157;
    out1[52] = x159;
    out1[53] = x161;
    out1[54] = x163;
    out1[55] = x165;
    out1[56] = x167;
    out1[57] = x170;
    out1[58] = x172;
    out1[59] = x174;
    out1[60] = x176;
    out1[61] = x178;
    out1[62] = x180;
    out1[63] = x181;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x10000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000], [0x0 ~> 0x8000000000000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(
    uint64_t out1[10], const uint8_t arg1[64]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint8_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint8_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint8_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint8_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint8_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint8_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint8_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint8_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    uint64_t x142;
    x1 = ((uint64_t)(arg1[63]) << 43);
    x2 = ((uint64_t)(arg1[62]) << 35);
    x3 = ((uint64_t)(arg1[61]) << 27);
    x4 = ((uint64_t)(arg1[60]) << 19);
    x5 = ((uint64_t)(arg1[59]) << 11);
    x6 = ((uint64_t)(arg1[58]) << 3);
    x7 = ((uint64_t)(arg1[57]) << 46);
    x8 = ((uint64_t)(arg1[56]) << 38);
    x9 = ((uint64_t)(arg1[55]) << 30);
    x10 = ((uint64_t)(arg1[54]) << 22);
    x11 = ((uint64_t)(arg1[53]) << 14);
    x12 = ((uint64_t)(arg1[52]) << 6);
    x13 = ((uint64_t)(arg1[51]) << 49);
    x14 = ((uint64_t)(arg1[50]) << 41);
    x15 = ((uint64_t)(arg1[49]) << 33);
    x16 = ((uint64_t)(arg1[48]) << 25);
    x17 = ((uint64_t)(arg1[47]) << 17);
    x18 = ((uint64_t)(arg1[46]) << 9);
    x19 = ((uint64_t)(arg1[45]) * 0x2);
    x20 = ((uint64_t)(arg1[44]) << 44);
    x21 = ((uint64_t)(arg1[43]) << 36);
    x22 = ((uint64_t)(arg1[42]) << 28);
    x23 = ((uint64_t)(arg1[41]) << 20);
    x24 = ((uint64_t)(arg1[40]) << 12);
    x25 = ((uint64_t)(arg1[39]) << 4);
    x26 = ((uint64_t)(arg1[38]) << 48);
    x27 = ((uint64_t)(arg1[37]) << 40);
    x28 = ((uint64_t)(arg1[36]) << 32);
    x29 = ((uint64_t)(arg1[35]) << 24);
    x30 = ((uint64_t)(arg1[34]) << 16);
    x31 = ((uint64_t)(arg1[33]) << 8);
    x32 = (arg1[32]);
    x33 = ((uint64_t)(arg1[31]) << 43);
    x34 = ((uint64_t)(arg1[30]) << 35);
    x35 = ((uint64_t)(arg1[29]) << 27);
    x36 = ((uint64_t)(arg1[28]) << 19);
    x37 = ((uint64_t)(arg1[27]) << 11);
    x38 = ((uint64_t)(arg1[26]) << 3);
    x39 = ((uint64_t)(arg1[25]) << 46);
    x40 = ((uint64_t)(arg1[24]) << 38);
    x41 = ((uint64_t)(arg1[23]) << 30);
    x42 = ((uint64_t)(arg1[22]) << 22);
    x43 = ((uint64_t)(arg1[21]) << 14);
    x44 = ((uint64_t)(arg1[20]) << 6);
    x45 = ((uint64_t)(arg1[19]) << 49);
    x46 = ((uint64_t)(arg1[18]) << 41);
    x47 = ((uint64_t)(arg1[17]) << 33);
    x48 = ((uint64_t)(arg1[16]) << 25);
    x49 = ((uint64_t)(arg1[15]) << 17);
    x50 = ((uint64_t)(arg1[14]) << 9);
    x51 = ((uint64_t)(arg1[13]) * 0x2);
    x52 = ((uint64_t)(arg1[12]) << 44);
    x53 = ((uint64_t)(arg1[11]) << 36);
    x54 = ((uint64_t)(arg1[10]) << 28);
    x55 = ((uint64_t)(arg1[9]) << 20);
    x56 = ((uint64_t)(arg1[8]) << 12);
    x57 = ((uint64_t)(arg1[7]) << 4);
    x58 = ((uint64_t)(arg1[6]) << 48);
    x59 = ((uint64_t)(arg1[5]) << 40);
    x60 = ((uint64_t)(arg1[4]) << 32);
    x61 = ((uint64_t)(arg1[3]) << 24);
    x62 = ((uint64_t)(arg1[2]) << 16);
    x63 = ((uint64_t)(arg1[1]) << 8);
    x64 = (arg1[0]);
    x65 = (x63 + (uint64_t)x64);
    x66 = (x62 + x65);
    x67 = (x61 + x66);
    x68 = (x60 + x67);
    x69 = (x59 + x68);
    x70 = (x58 + x69);
    x71 = (x70 & UINT64_C(0xfffffffffffff));
    x72 = (uint8_t)(x70 >> 52);
    x73 = (x57 + (uint64_t)x72);
    x74 = (x56 + x73);
    x75 = (x55 + x74);
    x76 = (x54 + x75);
    x77 = (x53 + x76);
    x78 = (x52 + x77);
    x79 = (x78 & UINT64_C(0x7ffffffffffff));
    x80 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x78 >> 51);
    x81 = (x51 + (uint64_t)x80);
    x82 = (x50 + x81);
    x83 = (x49 + x82);
    x84 = (x48 + x83);
    x85 = (x47 + x84);
    x86 = (x46 + x85);
    x87 = (x45 + x86);
    x88 = (x87 & UINT64_C(0x7ffffffffffff));
    x89 = (uint8_t)(x87 >> 51);
    x90 = (x44 + (uint64_t)x89);
    x91 = (x43 + x90);
    x92 = (x42 + x91);
    x93 = (x41 + x92);
    x94 = (x40 + x93);
    x95 = (x39 + x94);
    x96 = (x95 & UINT64_C(0x7ffffffffffff));
    x97 = (uint8_t)(x95 >> 51);
    x98 = (x38 + (uint64_t)x97);
    x99 = (x37 + x98);
    x100 = (x36 + x99);
    x101 = (x35 + x100);
    x102 = (x34 + x101);
    x103 = (x33 + x102);
    x104 = (x31 + (uint64_t)x32);
    x105 = (x30 + x104);
    x106 = (x29 + x105);
    x107 = (x28 + x106);
    x108 = (x27 + x107);
    x109 = (x26 + x108);
    x110 = (x109 & UINT64_C(0xfffffffffffff));
    x111 = (uint8_t)(x109 >> 52);
    x112 = (x25 + (uint64_t)x111);
    x113 = (x24 + x112);
    x114 = (x23 + x113);
    x115 = (x22 + x114);
    x116 = (x21 + x115);
    x117 = (x20 + x116);
    x118 = (x117 & UINT64_C(0x7ffffffffffff));
    x119 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x117 >> 51);
    x120 = (x19 + (uint64_t)x119);
    x121 = (x18 + x120);
    x122 = (x17 + x121);
    x123 = (x16 + x122);
    x124 = (x15 + x123);
    x125 = (x14 + x124);
    x126 = (x13 + x125);
    x127 = (x126 & UINT64_C(0x7ffffffffffff));
    x128 = (uint8_t)(x126 >> 51);
    x129 = (x12 + (uint64_t)x128);
    x130 = (x11 + x129);
    x131 = (x10 + x130);
    x132 = (x9 + x131);
    x133 = (x8 + x132);
    x134 = (x7 + x133);
    x135 = (x134 & UINT64_C(0x7ffffffffffff));
    x136 = (uint8_t)(x134 >> 51);
    x137 = (x6 + (uint64_t)x136);
    x138 = (x5 + x137);
    x139 = (x4 + x138);
    x140 = (x3 + x139);
    x141 = (x2 + x140);
    x142 = (x1 + x141);
    out1[0] = x71;
    out1[1] = x79;
    out1[2] = x88;
    out1[3] = x96;
    out1[4] = x103;
    out1[5] = x110;
    out1[6] = x118;
    out1[7] = x127;
    out1[8] = x135;
    out1[9] = x142;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_tc26_gost_3410_2012_512_paramSetA/fe_inv.op3
 * custom repunit addition chain
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(fe_t output,
                                                          const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t102, t12, t198, t2, t200, t24, t3, t400, t48, t502, t6, t96;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t3);
    for (i = 0; i < 2; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t6, acc, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t6);
    for (i = 0; i < 5; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t12, acc, t6);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t12);
    for (i = 0; i < 11; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t24, acc, t12);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t24);
    for (i = 0; i < 23; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t48, acc, t24);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t48);
    for (i = 0; i < 47; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t96, acc, t48);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t96);
    for (i = 0; i < 5; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t102, acc, t6);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t102);
    for (i = 0; i < 95; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t198, acc, t96);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t198);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t200, acc, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t200);
    for (i = 0; i < 199; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t400, acc, t200);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t400);
    for (i = 0; i < 101; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t502, acc, t102);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t502);
    for (i = 0; i < 3; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(acc, acc, t3);
    for (i = 0; i < 4; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(acc, acc, t1);
    for (i = 0; i < 2; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(output, acc, t1);
}

/* curve coefficient constants */

static const limb_t const_one[10] = {
    UINT64_C(0x0000000000000001), UINT64_C(0x0000000000000000),
    UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
    UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
    UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
    UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)};

static const limb_t const_b[10] = {
    UINT64_C(0x000190785A71C760), UINT64_C(0x00054EBEE4761503),
    UINT64_C(0x0001B521BB0C5DF3), UINT64_C(0x0001D8532D15D004),
    UINT64_C(0x000771E584879869), UINT64_C(0x000D081CFD0B6265),
    UINT64_C(0x00074761CB0E879B), UINT64_C(0x0004CFE3B469704A),
    UINT64_C(0x0001B7706F42CAD9), UINT64_C(0x0007461282EF6FE4)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[12][16] = {
    {
        {{UINT64_C(0x0000000000000003), UINT64_C(0x0000000000000000),
          UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
          UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
          UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
          UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)},
         {UINT64_C(0x000589CB5215F2A4), UINT64_C(0x0005FC235F5B889A),
          UINT64_C(0x00047483D30051FC), UINT64_C(0x0005BA4F5D79A943),
          UINT64_C(0x0006F8B135F27E81), UINT64_C(0x000064FDCBEFA921),
          UINT64_C(0x00013ACF1ABC1778), UINT64_C(0x0004A8A1CD9CBC39),
          UINT64_C(0x0002B8E986E205B8), UINT64_C(0x0003A81E7F43D41B)}},
        {{UINT64_C(0x000134687CCB87C3), UINT64_C(0x0003A10544E8416E),
          UINT64_C(0x00061120F5D8AB9F), UINT64_C(0x0004D75D92CBD5EC),
          UINT64_C(0x00021E94205A696E), UINT64_C(0x000291D5F488FBA5),
          UINT64_C(0x0004C096168A1174), UINT64_C(0x00034ACFF09B62AD),
          UINT64_C(0x00019FAD4E4D776D), UINT64_C(0x00050FF8D5938951)},
         {UINT64_C(0x000CD7EC518D90D6), UINT64_C(0x000711A4FB6C7125),
          UINT64_C(0x000298DBA98C6CDE), UINT64_C(0x00005BBAB3EB0BFA),
          UINT64_C(0x00008E9D7BF33E26), UINT64_C(0x00019E3F333F7EB3),
          UINT64_C(0x00048D7F84FBFA38), UINT64_C(0x00076B7309883C74),
          UINT64_C(0x0000DFCC0DD3C626), UINT64_C(0x0001E5AE220BF623)}},
        {{UINT64_C(0x000AEA0CE47F1E5F), UINT64_C(0x0006DA872DC7D9E3),
          UINT64_C(0x0004026E133CB612), UINT64_C(0x0001D4C81CBDD5C9),
          UINT64_C(0x000116A46100FB10), UINT64_C(0x000C71645B8C9FFB),
          UINT64_C(0x0006AFE06F1C1484), UINT64_C(0x0000B6FF2FF4E6C1),
          UINT64_C(0x0000A642376D824E), UINT64_C(0x0002B4540E895C56)},
         {UINT64_C(0x000BB3B92706CBC6), UINT64_C(0x0005700DE178E056),
          UINT64_C(0x000197807544BFFA), UINT64_C(0x000706F69DD298A6),
          UINT64_C(0x000205A8622A4E8B), UINT64_C(0x000109A43ED36596),
          UINT64_C(0x00049AB5B2BD5C17), UINT64_C(0x000515CF2C048D7F),
          UINT64_C(0x000651FD0ECDF273), UINT64_C(0x0003C6B66DABD057)}},
        {{UINT64_C(0x000ABFC1B7D256E0), UINT64_C(0x00022DFADD1D6E68),
          UINT64_C(0x00033EEC39057D08), UINT64_C(0x00075EC5CD3B3AFE),
          UINT64_C(0x000073336BE8A8F9), UINT64_C(0x000528C313659874),
          UINT64_C(0x000045D76D6402E5), UINT64_C(0x0007B1F5060389E6),
          UINT64_C(0x0005D713A16A99F2), UINT64_C(0x0003C394B1ED6CB5)},
         {UINT64_C(0x000A8C1A38755E5A), UINT64_C(0x0005CA589C9447E1),
          UINT64_C(0x0002D738BA7D236E), UINT64_C(0x00005E7DB74C629B),
          UINT64_C(0x000062E362468963), UINT64_C(0x000EBFCB8EE6AF9E),
          UINT64_C(0x000193EA82E68F84), UINT64_C(0x00003CAA0E7EFC3A),
          UINT64_C(0x00054937BC67C142), UINT64_C(0x000432F67FAB85C5)}},
        {{UINT64_C(0x000C34CEE53642A2), UINT64_C(0x00048BA44E987AEF),
          UINT64_C(0x0007CFBA481AC93A), UINT64_C(0x000252C52E6724E2),
          UINT64_C(0x00069C1386DDE181), UINT64_C(0x0003FE183213C47A),
          UINT64_C(0x0006C13A8DC37861), UINT64_C(0x0004546EA0F50627),
          UINT64_C(0x0007B6C23C692349), UINT64_C(0x0004307D8079E6F2)},
         {UINT64_C(0x000812879D2E3C8E), UINT64_C(0x000191C73044FE47),
          UINT64_C(0x00077218289340D5), UINT64_C(0x0005DA711BBBFF71),
          UINT64_C(0x0001C57405B59E36), UINT64_C(0x000C7F1B91C21105),
          UINT64_C(0x000066E23EF3A609), UINT64_C(0x00012EB6D5C73D15),
          UINT64_C(0x00020C3294080ED7), UINT64_C(0x00033ABC6BDE0FD2)}},
        {{UINT64_C(0x00002EE1E7135C5B), UINT64_C(0x000147440718098F),
          UINT64_C(0x000742216A0AD24C), UINT64_C(0x000209FAE0414762),
          UINT64_C(0x0007523CACA53442), UINT64_C(0x0002240ADDECED0B),
          UINT64_C(0x00023970F6F47640), UINT64_C(0x000799A6033CA82E),
          UINT64_C(0x00013F8D7EBD8951), UINT64_C(0x0003167F9B05B77B)},
         {UINT64_C(0x00084059554ECF79), UINT64_C(0x0005753C6736FF73),
          UINT64_C(0x000619A371C7BA90), UINT64_C(0x00007A6287324180),
          UINT64_C(0x00037396508E43B1), UINT64_C(0x000B92328505DD45),
          UINT64_C(0x00055C92400C6EE2), UINT64_C(0x0002654406A9F655),
          UINT64_C(0x0003AF03185F59DF), UINT64_C(0x0000C9632A02E2DE)}},
        {{UINT64_C(0x00082288639F2EBD), UINT64_C(0x0004E3BE5A9F335C),
          UINT64_C(0x0000475B64CDF3D5), UINT64_C(0x00003AD875B443CE),
          UINT64_C(0x0005A22CF276D7D8), UINT64_C(0x00059A094CC2E917),
          UINT64_C(0x0002CAA724BAEBC5), UINT64_C(0x0001CB230407F535),
          UINT64_C(0x00043A679D215417), UINT64_C(0x00032069427B390F)},
         {UINT64_C(0x00005AAE7CCDEA72), UINT64_C(0x000227E312EBD77B),
          UINT64_C(0x0006C48359C093AD), UINT64_C(0x00066AE122001431),
          UINT64_C(0x0002A7685789D1A1), UINT64_C(0x000DDDC9B1721593),
          UINT64_C(0x0002EB3A73075BAE), UINT64_C(0x00010D483A062D6E),
          UINT64_C(0x000414E1A10675C2), UINT64_C(0x0003FC179BB802A2)}},
        {{UINT64_C(0x000FA7D670E14D45), UINT64_C(0x0005B60822C15C07),
          UINT64_C(0x0006E1C8DC8B953D), UINT64_C(0x0003AA1F0C09E3C3),
          UINT64_C(0x0004C494E672EDE4), UINT64_C(0x00061EB986E7C9B9),
          UINT64_C(0x0003EDBB8C82ECC2), UINT64_C(0x0007B7E098625DE1),
          UINT64_C(0x0001652C34790E48), UINT64_C(0x000181E9C44FB652)},
         {UINT64_C(0x00026B7BFCB41422), UINT64_C(0x0004420662645444),
          UINT64_C(0x0005427FA987FF52), UINT64_C(0x0005B9040DF26326),
          UINT64_C(0x000334DEEC131B7C), UINT64_C(0x0009976A9AEB37C6),
          UINT64_C(0x0005DE6BDA0EE26F), UINT64_C(0x00046CD4B8DA22BF),
          UINT64_C(0x0001A9277ED46EDA), UINT64_C(0x00048FE9C8EA98F0)}},
        {{UINT64_C(0x00069292A4F09AE6), UINT64_C(0x00059EEEC0228FDC),
          UINT64_C(0x0002E6A2EB99E1C1), UINT64_C(0x00028B36B1CB7EDC),
          UINT64_C(0x0007C4D51AEABB6E), UINT64_C(0x00040FA7C5F982AC),
          UINT64_C(0x0000A163AFAB5A89), UINT64_C(0x000436DC36654D6F),
          UINT64_C(0x0006E7E4EFBDBA76), UINT64_C(0x000469D46D1AEC82)},
         {UINT64_C(0x0003F3770683CF55), UINT64_C(0x0007581899AFCAA5),
          UINT64_C(0x00021BB9291EC382), UINT64_C(0x000725C1812F5867),
          UINT64_C(0x00010D68EF013EA6), UINT64_C(0x000D8AD6CCEEDD36),
          UINT64_C(0x0004145477456E2A), UINT64_C(0x000350F4CCCDD3ED),
          UINT64_C(0x0006D247F4FCCCBC), UINT64_C(0x0002C35AD24695CC)}},
        {{UINT64_C(0x0000563E3BB2C9A3), UINT64_C(0x0004731F28271C7E),
          UINT64_C(0x00006474AEE84E9A), UINT64_C(0x00079618BA66931E),
          UINT64_C(0x0005DEEC306DF549), UINT64_C(0x000A49F4075B243E),
          UINT64_C(0x00072F449585855D), UINT64_C(0x000031C0CC652EF1),
          UINT64_C(0x00003DDAA420F12A), UINT64_C(0x00027047A35D3C45)},
         {UINT64_C(0x0008D45AEA9F97DE), UINT64_C(0x00031B40D05861EA),
          UINT64_C(0x00022DF5AC218686), UINT64_C(0x000237062CC05B46),
          UINT64_C(0x000511B267DD6BA7), UINT64_C(0x000818297550A398),
          UINT64_C(0x000702FE7A56CB70), UINT64_C(0x00053C7D673599DE),
          UINT64_C(0x0003ED45D15B6C15), UINT64_C(0x0001806F568245B9)}},
        {{UINT64_C(0x0009351072DB2170), UINT64_C(0x00033196A2CEF459),
          UINT64_C(0x0006744E6383FCEF), UINT64_C(0x0005C51252A32D28),
          UINT64_C(0x00005FA2110CC455), UINT64_C(0x0004B8063421A324),
          UINT64_C(0x0007D30325E5137D), UINT64_C(0x0002AFA7F320E835),
          UINT64_C(0x00011A9719C3D5ED), UINT64_C(0x0006DFED78D57C93)},
         {UINT64_C(0x000CD2B1C06C89E0), UINT64_C(0x00005887BE69BEF0),
          UINT64_C(0x00023A5834EEE4F0), UINT64_C(0x00064984FA6CCD98),
          UINT64_C(0x00006FB77FDF3397), UINT64_C(0x0001EBEBCE68907A),
          UINT64_C(0x0006784C0935BED2), UINT64_C(0x00050FF3F3DFF454),
          UINT64_C(0x0004036C327922ED), UINT64_C(0x00008DE3F2C6A92E)}},
        {{UINT64_C(0x0006E03B0A49FC14), UINT64_C(0x0002D86C93A83EE0),
          UINT64_C(0x0004A7F892C15148), UINT64_C(0x0002FC12A44E72B1),
          UINT64_C(0x0000F1222DB270EC), UINT64_C(0x0005C305D53F498F),
          UINT64_C(0x0005C15989BD840C), UINT64_C(0x0005FD28651837A4),
          UINT64_C(0x0001F44FE46C7F06), UINT64_C(0x00025B96CDAFE605)},
         {UINT64_C(0x0009FDD223F15C01), UINT64_C(0x0007578682CC2965),
          UINT64_C(0x0006222B764EE30D), UINT64_C(0x0002695A8C2DDC09),
          UINT64_C(0x0003EED3043E0B4D), UINT64_C(0x000DF4BA29380423),
          UINT64_C(0x000799CE51DCFEE3), UINT64_C(0x0001DC423C4607A6),
          UINT64_C(0x000353F2E08F2F67), UINT64_C(0x0002DE3BCB26FB64)}},
        {{UINT64_C(0x000121C2DFF5C5F8), UINT64_C(0x0002C6372966E3BB),
          UINT64_C(0x00040EDCBB6FAE3D), UINT64_C(0x00045E8590C45B65),
          UINT64_C(0x00057F2556A1008A), UINT64_C(0x000D2C63669622C2),
          UINT64_C(0x00053762BBDA6A4D), UINT64_C(0x000638814A3C0C15),
          UINT64_C(0x0006306A8C676FEC), UINT64_C(0x00039FEA5B5F2932)},
         {UINT64_C(0x00045B18CC6F6BD4), UINT64_C(0x000572570661CF49),
          UINT64_C(0x0003DB3E7E6325C0), UINT64_C(0x0000D4366AC3C833),
          UINT64_C(0x0000BA40102D6C2B), UINT64_C(0x000D88CD5627BDAA),
          UINT64_C(0x0001A191F2BD95D8), UINT64_C(0x0007B490EB1F6E2E),
          UINT64_C(0x0001854754C42C14), UINT64_C(0x0004F9B402BCF150)}},
        {{UINT64_C(0x00062710FFD6E4C3), UINT64_C(0x00075F168936C9E7),
          UINT64_C(0x0005EBCC23DECE92), UINT64_C(0x0006A533FC0618A4),
          UINT64_C(0x00006276D8296DCC), UINT64_C(0x000C6FDBE7DDD556),
          UINT64_C(0x0005F77BF0F1421B), UINT64_C(0x00021327FBB8BE4C),
          UINT64_C(0x00039F51E09D0F1B), UINT64_C(0x00036B0DC0560BD1)},
         {UINT64_C(0x00090F866EA9C581), UINT64_C(0x0001BB6C84E218AF),
          UINT64_C(0x00016801E510D5D1), UINT64_C(0x00048969111EF218),
          UINT64_C(0x00032F01F97E8EAC), UINT64_C(0x000846529FDA255F),
          UINT64_C(0x00003E0DA43E7BC5), UINT64_C(0x0005377E9AD3A533),
          UINT64_C(0x00054F1C41B443CC), UINT64_C(0x0001E2C9C182A7B8)}},
        {{UINT64_C(0x0006822BBEC85A6F), UINT64_C(0x00037FF627207C7D),
          UINT64_C(0x000099E1EDB38619), UINT64_C(0x00024EABAAEF4727),
          UINT64_C(0x0001634583C11813), UINT64_C(0x0005BF27EB8FC0B2),
          UINT64_C(0x0002C5E6D68AED81), UINT64_C(0x00051011E59FEFC1),
          UINT64_C(0x0005BDE68E16008B), UINT64_C(0x00001CDB6AC4A926)},
         {UINT64_C(0x000F9C8354532F1F), UINT64_C(0x0003B7D13F24D465),
          UINT64_C(0x0001EE14FAFB642C), UINT64_C(0x0003086537C154F6),
          UINT64_C(0x000498FB21A3549B), UINT64_C(0x000D5F9768C501AF),
          UINT64_C(0x0007358BD9264583), UINT64_C(0x00020604DE0C73BC),
          UINT64_C(0x0004C1EFB4D90397), UINT64_C(0x000316FD7FD552FA)}},
        {{UINT64_C(0x000DF775325B2BEF), UINT64_C(0x0007C981BDB56B5B),
          UINT64_C(0x00030415FEF5D1EB), UINT64_C(0x00066427FB342115),
          UINT64_C(0x00039F275DCEB907), UINT64_C(0x000FC52CB944765D),
          UINT64_C(0x00063BA40ACC8623), UINT64_C(0x000217B5022687A4),
          UINT64_C(0x0003782EE74343F6), UINT64_C(0x0006E344AF9791BC)},
         {UINT64_C(0x0006A094A3D00C90), UINT64_C(0x0000A8C2AF5A4ED6),
          UINT64_C(0x0002593EB8606459), UINT64_C(0x0006BB706B63F1A3),
          UINT64_C(0x0001AC9ABD940E22), UINT64_C(0x000A8AFEAB077BE2),
          UINT64_C(0x000053C3E6DE9695), UINT64_C(0x00035197B6C50B68),
          UINT64_C(0x0005F05ED56144C6), UINT64_C(0x0005D16C6B2F7A7D)}},
    },
    {
        {{UINT64_C(0x0009697EFB5343B1), UINT64_C(0x00030F79CEE2F4D7),
          UINT64_C(0x0007C57239C2BFFF), UINT64_C(0x0005E177E6306573),
          UINT64_C(0x00058AECAB18B5E4), UINT64_C(0x000C2D8B42DA873F),
          UINT64_C(0x00067CEC60F40D7C), UINT64_C(0x0001CD069631374B),
          UINT64_C(0x00053BF89F276A0A), UINT64_C(0x000211BC2F82ABCC)},
         {UINT64_C(0x000F42F918BECCB0), UINT64_C(0x00050BCCFB9278C6),
          UINT64_C(0x000521F422BE023A), UINT64_C(0x000247E206708DFF),
          UINT64_C(0x000603F8EAFA08E8), UINT64_C(0x0001C8FA49E8E7A9),
          UINT64_C(0x0000ED2F247FA8F2), UINT64_C(0x00054F2BD90FC41F),
          UINT64_C(0x000613E3F3A0E141), UINT64_C(0x00058F502829C1A3)}},
        {{UINT64_C(0x000FA958A02414EA), UINT64_C(0x0005694D8B531753),
          UINT64_C(0x0002596B7F70E2D2), UINT64_C(0x0006F58C437031E9),
          UINT64_C(0x0005E52B9AB2FC87), UINT64_C(0x00047681FFAD52A2),
          UINT64_C(0x00054CFD109661E6), UINT64_C(0x0002642E41E026F7),
          UINT64_C(0x00015A4C0B3E2C49), UINT64_C(0x00012DBAB3D25C66)},
         {UINT64_C(0x000F66D444F2C6A3), UINT64_C(0x000465ABD7FBD63E),
          UINT64_C(0x000346682E14F62C), UINT64_C(0x0007D1BFDC2BDD7C),
          UINT64_C(0x00014B50150CDD7D), UINT64_C(0x000F1BAD6F065607),
          UINT64_C(0x0001B669F08E4917), UINT64_C(0x0007147465D09FD0),
          UINT64_C(0x0002E2E3DF8C1CE5), UINT64_C(0x0003E168C6A9219B)}},
        {{UINT64_C(0x00026E66F048E71C), UINT64_C(0x00021DA6DDB4379F),
          UINT64_C(0x0006A446FCD70668), UINT64_C(0x0000ED5A782862E2),
          UINT64_C(0x000600DB452AEA1A), UINT64_C(0x00070E2B0EE96B31),
          UINT64_C(0x000272BCDA0E468B), UINT64_C(0x0006754F74551E8E),
          UINT64_C(0x00030B2901255489), UINT64_C(0x00018BA394D8F24B)},
         {UINT64_C(0x000EF5DAB92AD60C), UINT64_C(0x0007A4E353682E4C),
          UINT64_C(0x0004D92B14F64543), UINT64_C(0x0006FB1C445C4562),
          UINT64_C(0x00005F0C73553832), UINT64_C(0x000F219585C811FA),
          UINT64_C(0x00002373528CE90C), UINT64_C(0x0005AEFE0F86FFD6),
          UINT64_C(0x000065686EF3DFA1), UINT64_C(0x0004BCFCBABBE76F)}},
        {{UINT64_C(0x000A04E942DB5726), UINT64_C(0x0004E0A8E957D2EB),
          UINT64_C(0x000042171E8C74B0), UINT64_C(0x0002CD5D9C992A32),
          UINT64_C(0x00021775A666DF3B), UINT64_C(0x0009B1719FCE5AFD),
          UINT64_C(0x00070479A5510650), UINT64_C(0x00076CA597F5197E),
          UINT64_C(0x0002FF8004DC7298), UINT64_C(0x000427FBA3F2118F)},
         {UINT64_C(0x000B2B7F0F1BC525), UINT64_C(0x0004F49FDAF0E9F8),
          UINT64_C(0x000119E1F8B31D5C), UINT64_C(0x00002C2E70F7717A),
          UINT64_C(0x000547EB13E64F24), UINT64_C(0x00061C10285CB68B),
          UINT64_C(0x00027F33F80AC82B), UINT64_C(0x00007A73F720ACD1),
          UINT64_C(0x0000FA4783E28EA8), UINT64_C(0x0005E1B01569FE4A)}},
        {{UINT64_C(0x000C8833182EEC18), UINT64_C(0x0005188EE3CCBD7D),
          UINT64_C(0x000145800FA7D3B9), UINT64_C(0x00015F410C821BF2),
          UINT64_C(0x0006D6985D22BB97), UINT64_C(0x000ACE8A202EEB11),
          UINT64_C(0x000000D3BC5FFCBC), UINT64_C(0x0005A94DE37C5B1E),
          UINT64_C(0x0006A3E90AE676A0), UINT64_C(0x0003DC3E9B9DEA03)},
         {UINT64_C(0x000ADDB18897A653), UINT64_C(0x00028BB1348E369A),
          UINT64_C(0x0000E0EF15D097A0), UINT64_C(0x000369538A36A67C),
          UINT64_C(0x0004F11787ECB811), UINT64_C(0x000DAB579DC3F6E7),
          UINT64_C(0x00051EEDC98205E1), UINT64_C(0x000296B14C5B057C),
          UINT64_C(0x0006A6B518D5A499), UINT64_C(0x0004B973FBCAD781)}},
        {{UINT64_C(0x00092403168F568C), UINT64_C(0x00050C76745944DA),
          UINT64_C(0x00045586DDAA3849), UINT64_C(0x0002424F7A393AE3),
          UINT64_C(0x0003613FCF452DAE), UINT64_C(0x000483477F08760D),
          UINT64_C(0x0006DE9C9C30A9F7), UINT64_C(0x0006DE3DC9E26B78),
          UINT64_C(0x00072E8A269F2328), UINT64_C(0x0001A0904E3E62B3)},
         {UINT64_C(0x000F53CF7A63B520), UINT64_C(0x00016E19E79779D7),
          UINT64_C(0x0003BA73148BC41B), UINT64_C(0x0000A0B9CB876955),
          UINT64_C(0x0002C3678483C9E4), UINT64_C(0x0001717604F49F0C),
          UINT64_C(0x0006DA52AE47D9A6), UINT64_C(0x00018A068DEAD248),
          UINT64_C(0x0000A45F44D54D0B), UINT64_C(0x000201738C7D6750)}},
        {{UINT64_C(0x000BFD50B6C0ED05), UINT64_C(0x0003B59B6181691D),
          UINT64_C(0x00036E5595022312), UINT64_C(0x0006371166F016C4),
          UINT64_C(0x0000D2463D93685C), UINT64_C(0x0000FB99CEC22230),
          UINT64_C(0x000662B7CA84328B), UINT64_C(0x0005B058F277AA90),
          UINT64_C(0x000744C6285E6BE8), UINT64_C(0x00044924B43A399C)},
         {UINT64_C(0x0009FE2EF5756858), UINT64_C(0x0002609FAC19675C),
          UINT64_C(0x0001EDB73C43A527), UINT64_C(0x00018040218709B5),
          UINT64_C(0x00038E60561A169C), UINT64_C(0x000716A3DE9C2728),
          UINT64_C(0x0001312CD53738AB), UINT64_C(0x00003A5EADF12479),
          UINT64_C(0x0004F1C4C30A626A), UINT64_C(0x00017077F028932B)}},
        {{UINT64_C(0x0005E4B52DDE7879), UINT64_C(0x0000DD824234AF86),
          UINT64_C(0x0007E33F8D4E4720), UINT64_C(0x0007DE0000448CDA),
          UINT64_C(0x00033984E740002A), UINT64_C(0x000C47E6A3586EA2),
          UINT64_C(0x00044D0958EBE073), UINT64_C(0x00001246801B8077),
          UINT64_C(0x0002F9FC5AA5757F), UINT64_C(0x0001A2DCE0976101)},
         {UINT64_C(0x000660A83163C88F), UINT64_C(0x000537D8B7F6309C),
          UINT64_C(0x00008DD86923D2DE), UINT64_C(0x0001EDCB48974621),
          UINT64_C(0x00006C01F610F051), UINT64_C(0x0008C9E7599C4A9D),
          UINT64_C(0x00036EA13E261953), UINT64_C(0x0003ED8BC32C0F96),
          UINT64_C(0x000755A3B7B81967), UINT64_C(0x00013DE89A6B4D9D)}},
        {{UINT64_C(0x000CA6E0EB363C7F), UINT64_C(0x0005F55CE82062CB),
          UINT64_C(0x00054C8A253358D0), UINT64_C(0x0002C5D656290FF8),
          UINT64_C(0x00057F5B9325F1DA), UINT64_C(0x0001FEF7C4623421),
          UINT64_C(0x000751B35DC509CC), UINT64_C(0x0000D577E46356BC),
          UINT64_C(0x0001AE1750B963E0), UINT64_C(0x000101926AD538C7)},
         {UINT64_C(0x000ADB8B609BBDFF), UINT64_C(0x00071752C179ED60),
          UINT64_C(0x0001F4F46D3CDA68), UINT64_C(0x0006AB70B8479B34),
          UINT64_C(0x00025F7ED7DEE309), UINT64_C(0x000DDC2D9609A612),
          UINT64_C(0x0004E68BAF1E467F), UINT64_C(0x00040F9B19D3CBE2),
          UINT64_C(0x00037E8C1EC0C6A4), UINT64_C(0x0003125691C2193B)}},
        {{UINT64_C(0x00067DA2BD46C9EA), UINT64_C(0x00026B6CAB294387),
          UINT64_C(0x0001D6166D7C9065), UINT64_C(0x00062BF47248BD53),
          UINT64_C(0x0002E90A5DD8639A), UINT64_C(0x0003936168470E19),
          UINT64_C(0x000528F76D8AF696), UINT64_C(0x0006ED2117C0F595),
          UINT64_C(0x00053A94B0075896), UINT64_C(0x00029EA83F539A1E)},
         {UINT64_C(0x0002028A9BD76B91), UINT64_C(0x0004FD251AA0E6F2),
          UINT64_C(0x0005AC8CC0D23EFF), UINT64_C(0x000128939573B39C),
          UINT64_C(0x000672B16EA38AE5), UINT64_C(0x0004D9266E6063F1),
          UINT64_C(0x000059E6A8535CE8), UINT64_C(0x0000599ECB0EF8DD),
          UINT64_C(0x0007013D35E8201F), UINT64_C(0x0002C65B4B7CFED7)}},
        {{UINT64_C(0x0008F58A1E3612AD), UINT64_C(0x0003A9FB96EDB71F),
          UINT64_C(0x0001F18D41C781FC), UINT64_C(0x00018367EBB23895),
          UINT64_C(0x0005D1FCD3BE526A), UINT64_C(0x000A42281101E568),
          UINT64_C(0x0005BABB0531BAFA), UINT64_C(0x0000A5F2A706F2D0),
          UINT64_C(0x00004127B930A594), UINT64_C(0x0000EB497CC34685)},
         {UINT64_C(0x00073B79A1945681), UINT64_C(0x000752EA80F8AC71),
          UINT64_C(0x0006302573AC640B), UINT64_C(0x00078867625480E5),
          UINT64_C(0x0007079395B2C6EF), UINT64_C(0x000C10FF5DD268D7),
          UINT64_C(0x00057909D9F5E805), UINT64_C(0x0003A161EE637F23),
          UINT64_C(0x00076AA86D84AD92), UINT64_C(0x0001EF085DE6C3AC)}},
        {{UINT64_C(0x000C311C4599BCA4), UINT64_C(0x00071D198CA022EA),
          UINT64_C(0x0007BCCA6C1EA7A9), UINT64_C(0x0005A91F6CE54B62),
          UINT64_C(0x00040F2F68ADFDE8), UINT64_C(0x0006DA7F20DC869C),
          UINT64_C(0x00059DD3EE431C99), UINT64_C(0x000714D6993F24A2),
          UINT64_C(0x0007C5152642D91F), UINT64_C(0x0002F4E11F2CC27F)},
         {UINT64_C(0x000A8ACA2FD26CFD), UINT64_C(0x0002EB39C4AC80BE),
          UINT64_C(0x0005BFAD35FC99F2), UINT64_C(0x0002BFAB444638F8),
          UINT64_C(0x000355F04D6D03C9), UINT64_C(0x000EB7D307BB548E),
          UINT64_C(0x00045256FDC37CFF), UINT64_C(0x000455EACB7CD74C),
          UINT64_C(0x0005F5BC0A0265A1), UINT64_C(0x0004E4B55474C1FB)}},
        {{UINT64_C(0x000405C3B4CBBA99), UINT64_C(0x0003A2CFD9BA8CE7),
          UINT64_C(0x0004D38F33BA729F), UINT64_C(0x00058368002B41A8),
          UINT64_C(0x0001EB778063FAFA), UINT64_C(0x00000CB2D95428C0),
          UINT64_C(0x0007A5F40E6F6248), UINT64_C(0x00066402E02185E2),
          UINT64_C(0x0002874AE640E9BA), UINT64_C(0x00025092EF1270C6)},
         {UINT64_C(0x0004F5A43B7EA260), UINT64_C(0x00024FC17540A356),
          UINT64_C(0x0001076B47F9F931), UINT64_C(0x0002FB78183398A6),
          UINT64_C(0x000229276794FECA), UINT64_C(0x0001B56FD26AC511),
          UINT64_C(0x00013652FDA2807D), UINT64_C(0x0000AD7AC8AF8820),
          UINT64_C(0x00059580D670358C), UINT64_C(0x0007B37AB910DB85)}},
        {{UINT64_C(0x000E7AAFAA81120D), UINT64_C(0x0001EFCC9131C28F),
          UINT64_C(0x0000F04662F79A92), UINT64_C(0x00018481A743283F),
          UINT64_C(0x0003227CCC1B0051), UINT64_C(0x000889F9DEBDBBB6),
          UINT64_C(0x00026E53C8DB36F4), UINT64_C(0x00040E757FC7CCB6),
          UINT64_C(0x000796C1E48AF493), UINT64_C(0x0005CD8E286C308F)},
         {UINT64_C(0x000FEEF26280024C), UINT64_C(0x00008656CE73F334),
          UINT64_C(0x000047F19B4CCB60), UINT64_C(0x0003E09FD007DE6A),
          UINT64_C(0x0006DFDC10446128), UINT64_C(0x0001C5059DDF7FB5),
          UINT64_C(0x0000C6D4835DEC52), UINT64_C(0x0001ECDEF9FA549E),
          UINT64_C(0x00004A50331A27BB), UINT64_C(0x0007445C7A2F53C4)}},
        {{UINT64_C(0x000919F3EC9CCC4F), UINT64_C(0x0005F2F6CF149577),
          UINT64_C(0x00060C560F67551A), UINT64_C(0x0007E358E045685B),
          UINT64_C(0x00070CCBF13484CF), UINT64_C(0x000C37725A783FCF),
          UINT64_C(0x00054AB9E7EE7B1E), UINT64_C(0x0003333BAB51E43A),
          UINT64_C(0x000017DC7BC018D7), UINT64_C(0x00003CA4BCFA7DD5)},
         {UINT64_C(0x0003E1A7A3069435), UINT64_C(0x000480EFF4E48BC7),
          UINT64_C(0x00062115BD5D5E69), UINT64_C(0x0007096DD6C931AD),
          UINT64_C(0x0002608249CB7A58), UINT64_C(0x0008A26364C8096A),
          UINT64_C(0x0003C1F2D4A059E3), UINT64_C(0x00010E330E128864),
          UINT64_C(0x0003B581FC1DE5C7), UINT64_C(0x000588DBEAEEB225)}},
        {{UINT64_C(0x0003AC2924B671D6), UINT64_C(0x00027D78B698A45A),
          UINT64_C(0x00015C6FF89B42E6), UINT64_C(0x000480FF26EC1381),
          UINT64_C(0x0000CC4426AAA245), UINT64_C(0x000FB55D009EF0BB),
          UINT64_C(0x000298CBBB4ADE83), UINT64_C(0x000718B823375BD8),
          UINT64_C(0x0007751B44E5F80F), UINT64_C(0x00059A1E5D2A4A5C)},
         {UINT64_C(0x000CB0EE2657342C), UINT64_C(0x00055C4B6D401505),
          UINT64_C(0x00056E99CE0E1574), UINT64_C(0x00002F6CB06EAD80),
          UINT64_C(0x000476059C9E6EB0), UINT64_C(0x000C60BC1D3204D4),
          UINT64_C(0x00050DC61142023B), UINT64_C(0x000726C34A8A210F),
          UINT64_C(0x0005C72290CE928B), UINT64_C(0x0004DFA0CEB1B72D)}},
    },
    {
        {{UINT64_C(0x000247F93F2BDD27), UINT64_C(0x0007C93034C92904),
          UINT64_C(0x00027DAD72E4B40B), UINT64_C(0x00014E25E82ABBD1),
          UINT64_C(0x00060E4F42A6C475), UINT64_C(0x000DC708D6D66CCB),
          UINT64_C(0x00036DB87A4B6343), UINT64_C(0x0003C58123691EAF),
          UINT64_C(0x0004DAD470664927), UINT64_C(0x0006A82E32F9C5E6)},
         {UINT64_C(0x0002A35EDD030037), UINT64_C(0x000219F0D4AE2250),
          UINT64_C(0x0003A7450131A667), UINT64_C(0x00061472E2C5CAD3),
          UINT64_C(0x0000BDF65BE7AF81), UINT64_C(0x0007F887A21C419E),
          UINT64_C(0x00048915425E3C2E), UINT64_C(0x00046299A3659CE9),
          UINT64_C(0x00044FD643C6825F), UINT64_C(0x00041408EE3F7EE7)}},
        {{UINT64_C(0x0001D71DC21EAB28), UINT64_C(0x00065A53D38F953D),
          UINT64_C(0x00032DEB59D8023C), UINT64_C(0x0004054571AECBAF),
          UINT64_C(0x0006227C20ADC1B1), UINT64_C(0x0004052B60ED5E09),
          UINT64_C(0x0007D536170CE49B), UINT64_C(0x000133F69C75D93C),
          UINT64_C(0x000631A47E596690), UINT64_C(0x0007BE94B2BCFA10)},
         {UINT64_C(0x000D3D75C6EDBD10), UINT64_C(0x0002F0C1700CF75C),
          UINT64_C(0x0000880BD06AC9F8), UINT64_C(0x0007F4DE75015506),
          UINT64_C(0x0004F7D9218E4531), UINT64_C(0x000525D094B57596),
          UINT64_C(0x000303BA4ADC93BE), UINT64_C(0x000781A6DDE92BB0),
          UINT64_C(0x0000145A33FB664A), UINT64_C(0x0003075364E801EA)}},
        {{UINT64_C(0x000B5C724B664A37), UINT64_C(0x0002503E28109C51),
          UINT64_C(0x00025B829904E428), UINT64_C(0x00069506DB016812),
          UINT64_C(0x0004A750C8A64E1B), UINT64_C(0x000B87DB220A7C57),
          UINT64_C(0x00031EFD957F4D41), UINT64_C(0x000049A333D86B06),
          UINT64_C(0x0001D8EAEB6440B9), UINT64_C(0x000276C32B4CE41C)},
         {UINT64_C(0x0008857C83EF71E8), UINT64_C(0x0005E721B3AB9D6B),
          UINT64_C(0x00017EACB90E5F00), UINT64_C(0x0005C3E831C481C5),
          UINT64_C(0x0007C0B8197E5462), UINT64_C(0x000DBDC919F92AA9),
          UINT64_C(0x0002200849E9CAEE), UINT64_C(0x0004BE6C719C5906),
          UINT64_C(0x0004E280855B1920), UINT64_C(0x0005C5B91DB6D1EA)}},
        {{UINT64_C(0x000424B6E394CF88), UINT64_C(0x0003C2C97C04AC74),
          UINT64_C(0x00063ADB5E77144A), UINT64_C(0x0005D883FF8E6B47),
          UINT64_C(0x0004F87D0A1CC558), UINT64_C(0x000BB8A228CF7739),
          UINT64_C(0x0004B3A03FA0D71F), UINT64_C(0x000753D34ABABB8E),
          UINT64_C(0x000562AB4C8CB943), UINT64_C(0x0001CEBF9BBC430C)},
         {UINT64_C(0x0007223CBD30A33E), UINT64_C(0x0007335C7215C6C3),
          UINT64_C(0x000603E2856D2862), UINT64_C(0x0002A848E65B42A0),
          UINT64_C(0x0004218F69174E09), UINT64_C(0x0005FFA3227A0A23),
          UINT64_C(0x00005B5868C2514B), UINT64_C(0x0004938AFADAD730),
          UINT64_C(0x0007660F9A69E6DE), UINT64_C(0x00065102D85E579B)}},
        {{UINT64_C(0x000D8ADCE1ED036C), UINT64_C(0x00075B271EA827E2),
          UINT64_C(0x00076B7F6030D0B9), UINT64_C(0x0001CF9A9998A24D),
          UINT64_C(0x0003EAAA8D599E8C), UINT64_C(0x000926867BCB228B),
          UINT64_C(0x0005C256FF24300F), UINT64_C(0x0002D2C9DDD6690E),
          UINT64_C(0x000318EC38CFD857), UINT64_C(0x00040F4D05884680)},
         {UINT64_C(0x000BA16121F40EA5), UINT64_C(0x0003E1A3C8625ED4),
          UINT64_C(0x0003A030ED90ADCB), UINT64_C(0x00051906502C4E1E),
          UINT64_C(0x00056353D129BB9B), UINT64_C(0x00097E025B071B0B),
          UINT64_C(0x0007FEFDDBE2C9B0), UINT64_C(0x0005B33FC31E9599),
          UINT64_C(0x0004B5E596C70338), UINT64_C(0x0001C9B00B315DC4)}},
        {{UINT64_C(0x000607DBC162717D), UINT64_C(0x0000D1169F3006DA),
          UINT64_C(0x0000DD28C7A17F77), UINT64_C(0x000575B9A5BE6190),
          UINT64_C(0x0001608A9002E304), UINT64_C(0x0008355DA341F5E9),
          UINT64_C(0x0006F9C8170EE63C), UINT64_C(0x00014428C0115E5D),
          UINT64_C(0x00023A2E2E57272F), UINT64_C(0x000688C75933F079)},
         {UINT64_C(0x000FF6A2CDB10A3C), UINT64_C(0x00011BFAEC3923D3),
          UINT64_C(0x00042ED75727E176), UINT64_C(0x00014FA777DC3A6C),
          UINT64_C(0x000160BDE1742549), UINT64_C(0x000AB16C591470C7),
          UINT64_C(0x00028D130B66A9E4), UINT64_C(0x00047E950B4F11C5),
          UINT64_C(0x000135717CA7A661), UINT64_C(0x000654B545B4E06F)}},
        {{UINT64_C(0x00021C7F20682330), UINT64_C(0x0006E09BA4DD4E28),
          UINT64_C(0x0005ED0838CEDFB5), UINT64_C(0x00046FAAD6213185),
          UINT64_C(0x00042F098929C355), UINT64_C(0x0002587008E96E6D),
          UINT64_C(0x000705A22499C027), UINT64_C(0x0000D8B3B0087A17),
          UINT64_C(0x0003A94A483422C6), UINT64_C(0x0003D967C7D3D6FD)},
         {UINT64_C(0x0009965DB7927E5D), UINT64_C(0x0005AB719C5CAE45),
          UINT64_C(0x00033CCD1F896812), UINT64_C(0x0001AE9A7A4BA5D3),
          UINT64_C(0x00072043806DB7CF), UINT64_C(0x0008763B930B883A),
          UINT64_C(0x0002E90170B740E5), UINT64_C(0x00058F5C1631E156),
          UINT64_C(0x0000C3D179B466C2), UINT64_C(0x0005E600D05FAA9D)}},
        {{UINT64_C(0x0001BDEA3D7E7C27), UINT64_C(0x0000D69B04E78772),
          UINT64_C(0x0006FD1A96FF1C3D), UINT64_C(0x000704C7BCD74C67),
          UINT64_C(0x0006587D24D60D0B), UINT64_C(0x0009A72FB4EDBDF3),
          UINT64_C(0x0005F66F2FC11A22), UINT64_C(0x0005C07A5C028CB3),
          UINT64_C(0x000427DC53252FD7), UINT64_C(0x00000C0FE0D5E259)},
         {UINT64_C(0x00015C9DCE11A938), UINT64_C(0x0002F708542BA021),
          UINT64_C(0x0006DAB5EC8723B2), UINT64_C(0x0003151DBC6DBEA3),
          UINT64_C(0x000309C003EEA187), UINT64_C(0x000986E93A4AD727),
          UINT64_C(0x0005A27640EB41AD), UINT64_C(0x00064B4B969CE91A),
          UINT64_C(0x00058AD60A48BA18), UINT64_C(0x0007DE07E6483D46)}},
        {{UINT64_C(0x0001C747EC0357A9), UINT64_C(0x00053CBE4FDF72AE),
          UINT64_C(0x0001FB453499F9E9), UINT64_C(0x0004C4167C9B02FD),
          UINT64_C(0x000127DCADD50EB4), UINT64_C(0x000805FB4E216AE0),
          UINT64_C(0x00029FAA52099B86), UINT64_C(0x00047C3F68455806),
          UINT64_C(0x0001B9FA50F58DBC), UINT64_C(0x0003BD919AFF02A8)},
         {UINT64_C(0x0000E4A059AF4846), UINT64_C(0x0007E18DF861A61A),
          UINT64_C(0x0006C2588CE7246D), UINT64_C(0x000662D80DEF8736),
          UINT64_C(0x00067C77B3EBB3CB), UINT64_C(0x000DB319339B4754),
          UINT64_C(0x0002F3DAFE1D02AD), UINT64_C(0x0001AB8E0CEDA23A),
          UINT64_C(0x0000839E55FF286D), UINT64_C(0x000427E6A937B04C)}},
        {{UINT64_C(0x0009CD5E8F10490A), UINT64_C(0x000770DEE503609F),
          UINT64_C(0x0002F4D1F9822AF0), UINT64_C(0x000209D7D6C6D432),
          UINT64_C(0x000577EE861AD61E), UINT64_C(0x000D96564BC24BF1),
          UINT64_C(0x0007205D262B6DBF), UINT64_C(0x0003C7E6251A1A93),
          UINT64_C(0x00013FC13A41D60E), UINT64_C(0x000213F2333B026A)},
         {UINT64_C(0x0008E0F9A2F3F058), UINT64_C(0x00052D3E4E010B53),
          UINT64_C(0x00048FB0F03593BF), UINT64_C(0x0007400230A674D3),
          UINT64_C(0x0007D42DE3498D1B), UINT64_C(0x00088D98507324A9),
          UINT64_C(0x0006FEBD72D5E2AE), UINT64_C(0x00023587543DE864),
          UINT64_C(0x0006101B209DB09C), UINT64_C(0x0007176D895A251A)}},
        {{UINT64_C(0x0005B6A111C3F2A8), UINT64_C(0x000287D5A1A25472),
          UINT64_C(0x0004C3C87F77626A), UINT64_C(0x0007EAFB9945BB03),
          UINT64_C(0x0000B01EC3BD3FD6), UINT64_C(0x0003CFA14713C9F7),
          UINT64_C(0x00055DC5C2B54DF9), UINT64_C(0x00040CB8F2FD4F74),
          UINT64_C(0x0002B2C21AAD7697), UINT64_C(0x0006A800C6F15DE5)},
         {UINT64_C(0x00087EBAC501C1CD), UINT64_C(0x0004B94A8B9744A9),
          UINT64_C(0x00071EA1C4951821), UINT64_C(0x0002F01B39CE1A3C),
          UINT64_C(0x0005D4D68C89745D), UINT64_C(0x000CDC8D00E9F950),
          UINT64_C(0x0004C2450A80D882), UINT64_C(0x0002B0D6F20496F6),
          UINT64_C(0x0000E2B53712BC8E), UINT64_C(0x0004FB508F36E069)}},
        {{UINT64_C(0x0009905B853D75DD), UINT64_C(0x0002202313A58A10),
          UINT64_C(0x00047F9FAA6A8086), UINT64_C(0x0006997CD94C68DB),
          UINT64_C(0x00053560DF08CE67), UINT64_C(0x00058B243F1C8213),
          UINT64_C(0x00023330F3EAC431), UINT64_C(0x00029615BF1FDC4B),
          UINT64_C(0x0000E02FFE4339AB), UINT64_C(0x0006701924C686EC)},
         {UINT64_C(0x00028B574C85D822), UINT64_C(0x00023BDBC197A77D),
          UINT64_C(0x0000CA80105F893D), UINT64_C(0x0004A4B3F8BA0A40),
          UINT64_C(0x0006606848556101), UINT64_C(0x0002691001720525),
          UINT64_C(0x000492966DED5935), UINT64_C(0x0004330B122DF4B0),
          UINT64_C(0x0003F277BB31C2EC), UINT64_C(0x000415C4C2A49A50)}},
        {{UINT64_C(0x00067B9FED7E7EA9), UINT64_C(0x0000C6210735C315),
          UINT64_C(0x000015C61BE12C57), UINT64_C(0x00031A65953D8E09),
          UINT64_C(0x0000C16E4265E92A), UINT64_C(0x00038511318F2F8F),
          UINT64_C(0x0006D2553216EB6C), UINT64_C(0x00014C8A2AC5A158),
          UINT64_C(0x000155D5D24C02F3), UINT64_C(0x00028479C9ACA656)},
         {UINT64_C(0x0007F082D316A5DE), UINT64_C(0x0003727A88716E25),
          UINT64_C(0x000759E99508C576), UINT64_C(0x000268F8E924CE60),
          UINT64_C(0x0006584B44F67E86), UINT64_C(0x00010FC03061696C),
          UINT64_C(0x000111F962EADA3C), UINT64_C(0x000287220D2E4A6F),
          UINT64_C(0x0003DB8A5947F03E), UINT64_C(0x00063C396A142480)}},
        {{UINT64_C(0x0008D64DDD35262C), UINT64_C(0x0000E4419BEEDCBC),
          UINT64_C(0x0002644C710FD7DF), UINT64_C(0x0002B9FD57D1EDA6),
          UINT64_C(0x0001B443D6794EE2), UINT64_C(0x00066E8A571BA2F0),
          UINT64_C(0x0002A7DDA194FF52), UINT64_C(0x0000F1F9B9EB114E),
          UINT64_C(0x0002D0C71939AF7D), UINT64_C(0x0007B1CF36555692)},
         {UINT64_C(0x000E6FC6E690E6C9), UINT64_C(0x00025FE13962D085),
          UINT64_C(0x00057EF392B58263), UINT64_C(0x0000601F80D88963),
          UINT64_C(0x0000F77167FACF40), UINT64_C(0x0005C1EB1F4AF8D3),
          UINT64_C(0x0004E45CA91A75A3), UINT64_C(0x0007A538AF4D39AB),
          UINT64_C(0x0002FC7EF186BF83), UINT64_C(0x0002BB96633B032F)}},
        {{UINT64_C(0x000A511387235D97), UINT64_C(0x0000C5AEBD7CD669),
          UINT64_C(0x0001E2B79B37FC76), UINT64_C(0x000633A0ED45A1B2),
          UINT64_C(0x00002A485310156D), UINT64_C(0x000CF71C1E86A953),
          UINT64_C(0x000380A9470BDE9B), UINT64_C(0x0006C3A16CD16C98),
          UINT64_C(0x0003FD675030BD33), UINT64_C(0x0005733732E1E8BD)},
         {UINT64_C(0x0005DC87E99B96E0), UINT64_C(0x00061EEB65283A4A),
          UINT64_C(0x00066868AD05A9F6), UINT64_C(0x0003149FA1801E6C),
          UINT64_C(0x00009D644B39DFC5), UINT64_C(0x00088AA6A5735E82),
          UINT64_C(0x000329D82B26F648), UINT64_C(0x00038BF5BA7C68AD),
          UINT64_C(0x0000C5080B2DF90F), UINT64_C(0x00038D1F9AC2EAFD)}},
        {{UINT64_C(0x000DB14BDA7C7B66), UINT64_C(0x0000C49B073976FE),
          UINT64_C(0x000594F284FFA26E), UINT64_C(0x000082CF489F3922),
          UINT64_C(0x00052C957BF245F7), UINT64_C(0x0006E308A2AB1201),
          UINT64_C(0x000099B40ACA95A7), UINT64_C(0x0002815B6839730D),
          UINT64_C(0x0000B4295FDA8783), UINT64_C(0x00056F95752DE2DE)},
         {UINT64_C(0x000F056FEC9E88EA), UINT64_C(0x0007747F406F4246),
          UINT64_C(0x000125F62E04125C), UINT64_C(0x000286A0E4919620),
          UINT64_C(0x000691348CCDE24C), UINT64_C(0x0000010E5ED700B6),
          UINT64_C(0x0000B69D2C21F3C6), UINT64_C(0x00073767577F6F02),
          UINT64_C(0x0005344DA12140FD), UINT64_C(0x00063AC1FFD1B34E)}},
    },
    {
        {{UINT64_C(0x00073DCFA4CC1F6E), UINT64_C(0x000058B4C7ED3A6B),
          UINT64_C(0x00044FC7BBBB4D1C), UINT64_C(0x00073AA6DD4CD996),
          UINT64_C(0x000603CE62F0768C), UINT64_C(0x000DDF011F0B6AB3),
          UINT64_C(0x0003E05089170D90), UINT64_C(0x0005874DCC299BE8),
          UINT64_C(0x0001472869B59056), UINT64_C(0x000509DDD9B76FFE)},
         {UINT64_C(0x000EF415076C2F66), UINT64_C(0x00011E95B1CD79BE),
          UINT64_C(0x00072B66656ECB77), UINT64_C(0x0000C32231A4FA37),
          UINT64_C(0x000078B2D3568104), UINT64_C(0x00071892DBCB8007),
          UINT64_C(0x00003A0D60762137), UINT64_C(0x0001972E82FD7568),
          UINT64_C(0x0003B928B40F35C4), UINT64_C(0x00008D70A3EF6199)}},
        {{UINT64_C(0x000AFC3506C0703F), UINT64_C(0x000624FB1C5785C2),
          UINT64_C(0x0000AABC82587858), UINT64_C(0x0004C835073ADCF9),
          UINT64_C(0x000687A3E10BEBEC), UINT64_C(0x000594AAE6A6AE1A),
          UINT64_C(0x00065326690F40A8), UINT64_C(0x0000FAAF35DCEA85),
          UINT64_C(0x0000F2D71EE73779), UINT64_C(0x00066971F9CF6697)},
         {UINT64_C(0x000438C3AE869675), UINT64_C(0x00058F4A97CCECEE),
          UINT64_C(0x00038C0DA4EAB715), UINT64_C(0x0002EFF5EC967DA5),
          UINT64_C(0x0004EC8C45F8A0B7), UINT64_C(0x0001A00E90F5CDF1),
          UINT64_C(0x00008DEA644831E0), UINT64_C(0x000344FDFCB694A6),
          UINT64_C(0x0001645897F09A36), UINT64_C(0x0003CD2366934F24)}},
        {{UINT64_C(0x0003A9CBC10E78A2), UINT64_C(0x0005680C903EE3AA),
          UINT64_C(0x0006148C4134D494), UINT64_C(0x0000B708AB89AB5E),
          UINT64_C(0x0004077F94E08257), UINT64_C(0x0006E5183D078408),
          UINT64_C(0x000100C1D80D49CE), UINT64_C(0x00077E3B5B1FD1E9),
          UINT64_C(0x0001D5173866042B), UINT64_C(0x0002EC241DBE6604)},
         {UINT64_C(0x000D707611B80741), UINT64_C(0x000004EDC429B806),
          UINT64_C(0x00025B85B91E12D5), UINT64_C(0x0005A874EFD18EE2),
          UINT64_C(0x000679D292E2E5E8), UINT64_C(0x0007C4E1CF9D2493),
          UINT64_C(0x00007FEC8151F6C5), UINT64_C(0x0007077C6CE7BCBD),
          UINT64_C(0x0004E603D2D1C045), UINT64_C(0x000120DC52FC4C28)}},
        {{UINT64_C(0x00024CAB433F1EE9), UINT64_C(0x00029390B5399AC6),
          UINT64_C(0x0000A140735E1061), UINT64_C(0x0006209FAAABDAEB),
          UINT64_C(0x000313939B1E27F8), UINT64_C(0x00071218CE90C274),
          UINT64_C(0x00004D454CA99B52), UINT64_C(0x000244DC876EE217),
          UINT64_C(0x0007B9AEDFF13E10), UINT64_C(0x0007C60093FD8081)},
         {UINT64_C(0x000DA5DEA4CAF297), UINT64_C(0x00068C8666E24B9C),
          UINT64_C(0x0002429BB8CB157C), UINT64_C(0x00075FA673A5EDA2),
          UINT64_C(0x000374A3EAD4DEAA), UINT64_C(0x000BDA91FD4D7B4C),
          UINT64_C(0x000219669647B2DF), UINT64_C(0x0003EDAFFBB15EF4),
          UINT64_C(0x00024CF5BC63EF28), UINT64_C(0x00027124899C9A4B)}},
        {{UINT64_C(0x00040B019B1261D0), UINT64_C(0x0000B4F4F45584EA),
          UINT64_C(0x00010867C36FE3B7), UINT64_C(0x0001B956EFC67D1C),
          UINT64_C(0x00060551212213FD), UINT64_C(0x00045B1AC4D20479),
          UINT64_C(0x00031E79405F14E6), UINT64_C(0x00054F01E909A81E),
          UINT64_C(0x00001536D9DE39DB), UINT64_C(0x0000B62D820D6FE3)},
         {UINT64_C(0x0003F4243CF34066), UINT64_C(0x00024F7957E1D750),
          UINT64_C(0x000080B613A16A90), UINT64_C(0x0004FFBB7D0412AA),
          UINT64_C(0x00048AADB4617EEB), UINT64_C(0x0005590404BF6350),
          UINT64_C(0x0005FB0DEC254DD3), UINT64_C(0x0006E456239D68DC),
          UINT64_C(0x0006AA0BAC97FBC4), UINT64_C(0x0007C0F318810C9E)}},
        {{UINT64_C(0x00095C2255EB8676), UINT64_C(0x0002EEBEE04E7BD1),
          UINT64_C(0x00047162E07D3E1B), UINT64_C(0x00019CBB802D7D2F),
          UINT64_C(0x0004D5BCA1F2FE81), UINT64_C(0x000636275F6E3CD0),
          UINT64_C(0x000074C1065AE748), UINT64_C(0x00000ED33D724610),
          UINT64_C(0x000382AAE71C671F), UINT64_C(0x00050F862E56FE82)},
         {UINT64_C(0x000F0C6FE0519997), UINT64_C(0x0004AF7A837FAD03),
          UINT64_C(0x00029E2DCFC7D836), UINT64_C(0x0000D7429D3F9BC8),
          UINT64_C(0x0002062ED538B7FE), UINT64_C(0x00048D96CEDB79F1),
          UINT64_C(0x00035E77C26028A3), UINT64_C(0x0002BEBC515C0C05),
          UINT64_C(0x0001137EC9DBE5EA), UINT64_C(0x0004EF0306F592B4)}},
        {{UINT64_C(0x00045CFFCC0FA82B), UINT64_C(0x000147CD2A7BCEF8),
          UINT64_C(0x0004A7DF37A543F3), UINT64_C(0x0000E83C08C7DB26),
          UINT64_C(0x000433C19A259924), UINT64_C(0x000060A2CC17C1B7),
          UINT64_C(0x00048887C01708A7), UINT64_C(0x0004F7B43946A5B5),
          UINT64_C(0x0000318DA056D31F), UINT64_C(0x0005816FA3E55B23)},
         {UINT64_C(0x00028F1B6BE8EDBD), UINT64_C(0x0002FAEDDF5DD2E3),
          UINT64_C(0x0004F7E40BA33E35), UINT64_C(0x00065C3B855FC053),
          UINT64_C(0x0001874EF8C8D7C7), UINT64_C(0x0009EE69935EB5BD),
          UINT64_C(0x0005209285BDCD9B), UINT64_C(0x00065CD4AD193A52),
          UINT64_C(0x0007AF07028EFAD4), UINT64_C(0x0003D64202012D6B)}},
        {{UINT64_C(0x000B9243B209436A), UINT64_C(0x0004A9127BF30A58),
          UINT64_C(0x0006E0E94A1E2713), UINT64_C(0x0004376EAD2B248D),
          UINT64_C(0x000767EEA5E05823), UINT64_C(0x0009BF8F74216C3F),
          UINT64_C(0x00024B8202C21037), UINT64_C(0x00013B0257209206),
          UINT64_C(0x0002F0B8A9C57E63), UINT64_C(0x0001559540A76AA1)},
         {UINT64_C(0x00066AF801F7DD9E), UINT64_C(0x00075AFD2B0FB2AA),
          UINT64_C(0x00055CB5FD0A01A3), UINT64_C(0x000139A9A848804F),
          UINT64_C(0x0004DB6F2563F825), UINT64_C(0x0001293E77720431),
          UINT64_C(0x0005D00E9E6814E5), UINT64_C(0x00033A3B82EBAE98),
          UINT64_C(0x00032C37E6C66CBB), UINT64_C(0x000690013DADC456)}},
        {{UINT64_C(0x000272465B8B5D7D), UINT64_C(0x000720DB646ED253),
          UINT64_C(0x0002AB65B7565858), UINT64_C(0x00014AD6B607866E),
          UINT64_C(0x000598494CC47B43), UINT64_C(0x000001AE0D244024),
          UINT64_C(0x00029E1DE544546D), UINT64_C(0x0002D87A26EE67AB),
          UINT64_C(0x0002767B394A967D), UINT64_C(0x0005DD104AA8F32A)},
         {UINT64_C(0x00068115CF22CDAC), UINT64_C(0x0006E7DA3BE129A8),
          UINT64_C(0x00037A31451A8758), UINT64_C(0x00039CB3690F9258),
          UINT64_C(0x00069351BF30A237), UINT64_C(0x000943CB31F201C2),
          UINT64_C(0x00056D93FDE091B5), UINT64_C(0x0007A6DAFB6FE56C),
          UINT64_C(0x00076EBD371AC14C), UINT64_C(0x00022219B02515D5)}},
        {{UINT64_C(0x0007126658D45F84), UINT64_C(0x0005F94089210333),
          UINT64_C(0x0000DF0B1374230F), UINT64_C(0x0000C22084A59475),
          UINT64_C(0x0005B56056BEF979), UINT64_C(0x0003B18C16D005D1),
          UINT64_C(0x00009A3D6108A669), UINT64_C(0x0002B5446C86171D),
          UINT64_C(0x0003C25E4502353F), UINT64_C(0x0002AF979DDD05A1)},
         {UINT64_C(0x000CE57EA911389C), UINT64_C(0x00060CBCB1000CD6),
          UINT64_C(0x0002AEF497970566), UINT64_C(0x0003002606F34647),
          UINT64_C(0x0005BAC30DE7C37E), UINT64_C(0x000ACE8DDCA7F508),
          UINT64_C(0x0004C49914338529), UINT64_C(0x000201F520B0AA42),
          UINT64_C(0x0003ACEB18EE94D1), UINT64_C(0x00043292408A3327)}},
        {{UINT64_C(0x00071CFCF4149893), UINT64_C(0x0002FF24B716F1CF),
          UINT64_C(0x0002E9DD42D79E81), UINT64_C(0x0005F2E12A9D3787),
          UINT64_C(0x0000B67ABBDD6226), UINT64_C(0x000E14AD866F075E),
          UINT64_C(0x0000DF8C5452E7ED), UINT64_C(0x000179D614E61B47),
          UINT64_C(0x0005F5E532D764C5), UINT64_C(0x000134C30CA43904)},
         {UINT64_C(0x0008A3D8E0E5028B), UINT64_C(0x0002AD02FF65DB2D),
          UINT64_C(0x000024B54F477366), UINT64_C(0x0004DF76000BEBD4),
          UINT64_C(0x0001BABEBBC5B492), UINT64_C(0x000293A99B9A4E9E),
          UINT64_C(0x0006DA8EC81880DF), UINT64_C(0x0004D62443F19541),
          UINT64_C(0x0007788BC32D12B7), UINT64_C(0x00053D73A62F6A5D)}},
        {{UINT64_C(0x0008D1269BFE5E8B), UINT64_C(0x0000FE4C7CBD9622),
          UINT64_C(0x0003CF67B2F4ACFF), UINT64_C(0x0006A8A24518F03D),
          UINT64_C(0x000347DAE1827AD4), UINT64_C(0x000F291ACCCDE5C5),
          UINT64_C(0x0000C9C96024DBC2), UINT64_C(0x0006E1493787400F),
          UINT64_C(0x0004557C49C13B5E), UINT64_C(0x0001BBD5022E461F)},
         {UINT64_C(0x00029EF080397D2A), UINT64_C(0x0007D3AEFB96A5DA),
          UINT64_C(0x0005CE903FC41243), UINT64_C(0x0007ACF27A77BE2F),
          UINT64_C(0x00069367C2BB5B2D), UINT64_C(0x000EA380A0F28EC9),
          UINT64_C(0x0004D091094729F5), UINT64_C(0x0000568ED1C33BAF),
          UINT64_C(0x0006FFC9FEC1754C), UINT64_C(0x00079AF250E87C71)}},
        {{UINT64_C(0x0001B7181A9FE1E7), UINT64_C(0x0004BF3195C7079A),
          UINT64_C(0x00004C65A8623BD7), UINT64_C(0x000293D8EC50869E),
          UINT64_C(0x00061ECDC77A17C7), UINT64_C(0x00024A53FBCEF78C),
          UINT64_C(0x0006DE143AB5A0EC), UINT64_C(0x0004F508E8AD0226),
          UINT64_C(0x0006DB9363078A38), UINT64_C(0x0002687048D33591)},
         {UINT64_C(0x00002320E24E6A1C), UINT64_C(0x000313A5A33B1564),
          UINT64_C(0x00032A7B146533BC), UINT64_C(0x00071698E42DC91D),
          UINT64_C(0x00013FC72B6E6862), UINT64_C(0x000192B68047991B),
          UINT64_C(0x00077CB246D0CF66), UINT64_C(0x00019BF6E968E141),
          UINT64_C(0x00022BEFB71228A7), UINT64_C(0x0007A8BE0F3AB802)}},
        {{UINT64_C(0x0004ADD37A15BAF2), UINT64_C(0x0002BA4932A7035A),
          UINT64_C(0x0007F27F93062C33), UINT64_C(0x0001E46147E6199F),
          UINT64_C(0x0004849455CB21C9), UINT64_C(0x000DF6C55755F760),
          UINT64_C(0x00062C25D51F8005), UINT64_C(0x00018D552106AE65),
          UINT64_C(0x00036D4A8E15A67D), UINT64_C(0x0002EAE18E596E61)},
         {UINT64_C(0x000A03842DB9836A), UINT64_C(0x00048F98CEFB00D3),
          UINT64_C(0x0005190809ADF2BA), UINT64_C(0x0002DFB56F0A20D0),
          UINT64_C(0x00027970FAA41846), UINT64_C(0x000A481D0AD15C42),
          UINT64_C(0x000613F431F58DB3), UINT64_C(0x00007B1DF30C2753),
          UINT64_C(0x000724A12A33FE21), UINT64_C(0x00061257C4C8D5D9)}},
        {{UINT64_C(0x0006B38283640BFC), UINT64_C(0x00071A8876D2D39B),
          UINT64_C(0x0000F57FF4B7C4D2), UINT64_C(0x00048165C6651FA6),
          UINT64_C(0x000261CAB432E4D9), UINT64_C(0x0003A33A1024655B),
          UINT64_C(0x00016A80FB002EFE), UINT64_C(0x0007F53959DC0BF4),
          UINT64_C(0x000327B19C41762A), UINT64_C(0x0003AEB118550BD1)},
         {UINT64_C(0x000194446473FAA4), UINT64_C(0x00056252C5E6D79B),
          UINT64_C(0x000385407B1E32BE), UINT64_C(0x0004F62D3BA2C380),
          UINT64_C(0x0006709FC90E66D9), UINT64_C(0x000BF2EFEC69E52A),
          UINT64_C(0x00025E53D4588CB4), UINT64_C(0x000767AF079A8486),
          UINT64_C(0x0006B1B2BCF33774), UINT64_C(0x00054711D18A6446)}},
        {{UINT64_C(0x0002F65D12A437F5), UINT64_C(0x0004C193BB16BB5C),
          UINT64_C(0x00044CB11429B380), UINT64_C(0x000575B1D96C4371),
          UINT64_C(0x0004792169D089CC), UINT64_C(0x000A44E79CFC086D),
          UINT64_C(0x0007F7A9AA829C6C), UINT64_C(0x0000E51AD40E415B),
          UINT64_C(0x0003741299AE5AB0), UINT64_C(0x00034773AD27F4C8)},
         {UINT64_C(0x0001088846755E86), UINT64_C(0x0007C43CEE739306),
          UINT64_C(0x0006DFB006FC973D), UINT64_C(0x00075D11ABB97E3F),
          UINT64_C(0x0006CE4EAD9FD40A), UINT64_C(0x00090DE95E0B71B8),
          UINT64_C(0x000677FB1CA2400F), UINT64_C(0x0001D6A9EAC1F91B),
          UINT64_C(0x0004B5A0DEA254E4), UINT64_C(0x00031843DB8ACA4B)}},
    },
    {
        {{UINT64_C(0x00040F0FEE5191D7), UINT64_C(0x0007AD757B218666),
          UINT64_C(0x00025B684155AF20), UINT64_C(0x00029F4B5C485180),
          UINT64_C(0x0007D8377347091F), UINT64_C(0x000A22940AF54A77),
          UINT64_C(0x0003BDF6CB1B3734), UINT64_C(0x000579D05F06E011),
          UINT64_C(0x00032F87199B836F), UINT64_C(0x000467CDC3E7620A)},
         {UINT64_C(0x00099269E81CAEA9), UINT64_C(0x00060FAD5B89DD61),
          UINT64_C(0x0005D82009E159C4), UINT64_C(0x000543570882A388),
          UINT64_C(0x0005742B11F41567), UINT64_C(0x00005532CC1A04CF),
          UINT64_C(0x0007E7D67CA82018), UINT64_C(0x00030811921ED542),
          UINT64_C(0x00033B0153C0A9D2), UINT64_C(0x000027EEDE45D652)}},
        {{UINT64_C(0x00054628B564DD25), UINT64_C(0x000278E72161A60B),
          UINT64_C(0x0002875070456F4D), UINT64_C(0x0000A471C5023AE6),
          UINT64_C(0x00053142CC156044), UINT64_C(0x000EB689710B36EE),
          UINT64_C(0x000749FE221A7A5D), UINT64_C(0x0005CE289B236184),
          UINT64_C(0x00064A9332E96DFA), UINT64_C(0x00019F74B7F23AA6)},
         {UINT64_C(0x000047C80E1C6849), UINT64_C(0x00032C0409EB2702),
          UINT64_C(0x0005472D7A3265A6), UINT64_C(0x00007486A002948B),
          UINT64_C(0x0005B35D6DCD0117), UINT64_C(0x000F09583142990E),
          UINT64_C(0x00020994F45554BA), UINT64_C(0x0002A8A2ED9245E6),
          UINT64_C(0x0001FCB7F2469865), UINT64_C(0x0003ABDD4F76D182)}},
        {{UINT64_C(0x0007EF170E5B61C6), UINT64_C(0x00072FD9870DA526),
          UINT64_C(0x00052A5CE07FB8A2), UINT64_C(0x000641090CDA363A),
          UINT64_C(0x0001F046CD11B1C9), UINT64_C(0x000C5ACA2B42DE77),
          UINT64_C(0x0003FA2D3D3A78D1), UINT64_C(0x00022EE52A68BA15),
          UINT64_C(0x0006ED9A8FFEDB9E), UINT64_C(0x000628597175CF09)},
         {UINT64_C(0x0007233FAD040661), UINT64_C(0x0002DBF1724897C1),
          UINT64_C(0x00058AF887383FF2), UINT64_C(0x0001A82F626A8BA1),
          UINT64_C(0x000663B0E734D3AD), UINT64_C(0x00041A94CEBE29A8),
          UINT64_C(0x0000EBE98973931D), UINT64_C(0x0007653DABE4C434),
          UINT64_C(0x00077F080BA025B1), UINT64_C(0x0001349D8D6D5053)}},
        {{UINT64_C(0x000BE1C7FB3EA365), UINT64_C(0x0000DEC547480E21),
          UINT64_C(0x0003063031574C24), UINT64_C(0x0004A1A78E047579),
          UINT64_C(0x000606500AB9A488), UINT64_C(0x00027F5C522D4690),
          UINT64_C(0x0001EDD9FF35555F), UINT64_C(0x00027FDC2B282190),
          UINT64_C(0x000683CED2B98C75), UINT64_C(0x000650923C157066)},
         {UINT64_C(0x00092C9AF39CBACB), UINT64_C(0x0007D3858C2DD00B),
          UINT64_C(0x00031E676BBB7275), UINT64_C(0x0003AA2D98F4F933),
          UINT64_C(0x0003DCA9CE27A62B), UINT64_C(0x000A07F50B9E690F),
          UINT64_C(0x000051DF1C1BCD4A), UINT64_C(0x0003517B8AC99CFD),
          UINT64_C(0x0006367C0179F6E0), UINT64_C(0x0002CE5C968BCB6D)}},
        {{UINT64_C(0x000200C339FA6063), UINT64_C(0x0002D8C7E4167214),
          UINT64_C(0x00043F59D8D68BBE), UINT64_C(0x00020ABF6635C5FA),
          UINT64_C(0x000676FC3B2B32D8), UINT64_C(0x000EBE9FD818DFC0),
          UINT64_C(0x0006D7A4486F3794), UINT64_C(0x000684F5E2DF04E3),
          UINT64_C(0x00032590E104D8CA), UINT64_C(0x0007F86F511DEAF5)},
         {UINT64_C(0x00034E941C93C058), UINT64_C(0x00034819A8DA6A22),
          UINT64_C(0x000164AD4449303E), UINT64_C(0x00042BE59CA73B0D),
          UINT64_C(0x00014B7F6EA0A455), UINT64_C(0x00098C54814B4ED9),
          UINT64_C(0x0004C74E9049A134), UINT64_C(0x0001859C7C28787A),
          UINT64_C(0x0002BF6FCC75D79D), UINT64_C(0x0007A8E2129CEB51)}},
        {{UINT64_C(0x00018E8A6D68977A), UINT64_C(0x000202BA27C4F548),
          UINT64_C(0x000765E7CECDA47B), UINT64_C(0x000363DB05A69000),
          UINT64_C(0x0005F96506BEB7D3), UINT64_C(0x00089C30791266ED),
          UINT64_C(0x00077E5CAB5C1F29), UINT64_C(0x0006E87E942A7A13),
          UINT64_C(0x0001FD90D57F757B), UINT64_C(0x0007B1FF16E524CF)},
         {UINT64_C(0x0005EA5BBEA59591), UINT64_C(0x000427E51D91AE1C),
          UINT64_C(0x00070FC7F83A8541), UINT64_C(0x00069E9D31A36625),
          UINT64_C(0x00030C2ED2385F4C), UINT64_C(0x00095E9CEDC7EC18),
          UINT64_C(0x0004DF297D2AB731), UINT64_C(0x0007FD32EE0B4C2F),
          UINT64_C(0x0006423F55007B50), UINT64_C(0x000582AFCEAF6692)}},
        {{UINT64_C(0x000132229C4BE432), UINT64_C(0x000062BDAF1A965D),
          UINT64_C(0x0002C1A7663C1E53), UINT64_C(0x00038DAE7DCFB8CC),
          UINT64_C(0x00072695BB1282ED), UINT64_C(0x0006EC32706E7F8F),
          UINT64_C(0x0004FDED61E285BE), UINT64_C(0x0003D1D5A48B6110),
          UINT64_C(0x000552ACEEFD0F10), UINT64_C(0x00011D10445A68E0)},
         {UINT64_C(0x000CB3E30A36F50F), UINT64_C(0x0004A7B7557E35AE),
          UINT64_C(0x00066CFBF15B4D97), UINT64_C(0x0000508B08233B2E),
          UINT64_C(0x0003F31FB5C7AE10), UINT64_C(0x000E6621F3031E22),
          UINT64_C(0x000482990F4ECDC4), UINT64_C(0x000484D2AA8A0F24),
          UINT64_C(0x00009D4CF9C0A36A), UINT64_C(0x0001CC385C527853)}},
        {{UINT64_C(0x000A4792A9EEE2A9), UINT64_C(0x00072FA6FDF2C7C6),
          UINT64_C(0x0007C7826E4812BE), UINT64_C(0x0006F6D236CF8FD6),
          UINT64_C(0x00073F81409D27AF), UINT64_C(0x0006499E587E37BE),
          UINT64_C(0x0001D910B9037DCA), UINT64_C(0x00076B6BA2C2DD1C),
          UINT64_C(0x0000C40F587E10E9), UINT64_C(0x0003A0C39693B06A)},
         {UINT64_C(0x000B22437DF0A661), UINT64_C(0x000740D926C3CA81),
          UINT64_C(0x0004D6FC409922D3), UINT64_C(0x0006C8B0A63EBE3B),
          UINT64_C(0x0007A7E09C658E92), UINT64_C(0x000EE849F67956DF),
          UINT64_C(0x00009ACED8E8FE8F), UINT64_C(0x0001CD4640F2626A),
          UINT64_C(0x0000370AE99E0EF4), UINT64_C(0x000081E0D1461BE8)}},
        {{UINT64_C(0x00073065330BAB74), UINT64_C(0x0001574E266A5243),
          UINT64_C(0x0002D1F64CEC7BBF), UINT64_C(0x0005B4B35FD5F97F),
          UINT64_C(0x0006E328070806B7), UINT64_C(0x000194194F915C7A),
          UINT64_C(0x00073D3745896020), UINT64_C(0x0005E613BB39AE2A),
          UINT64_C(0x00011D507ABCADE1), UINT64_C(0x0002EAF0689489D1)},
         {UINT64_C(0x000058D096BDB2AB), UINT64_C(0x00069969F77F9CB1),
          UINT64_C(0x00039B6125B8F829), UINT64_C(0x00044A07AEC2D0C6),
          UINT64_C(0x000504B4F3946022), UINT64_C(0x00080D0DFA735E99),
          UINT64_C(0x0002BC6CCE0171E5), UINT64_C(0x0003D83527837207),
          UINT64_C(0x00066CBA871AC0F9), UINT64_C(0x00024A295AAEBA6A)}},
        {{UINT64_C(0x000D2B933FA0DA3A), UINT64_C(0x00079892AF905B11),
          UINT64_C(0x00021863855AA63A), UINT64_C(0x00052D86FEC679D3),
          UINT64_C(0x000791B1FDE46EBE), UINT64_C(0x000AF24DC2D97724),
          UINT64_C(0x000430197793B4EF), UINT64_C(0x0001355100B792D4),
          UINT64_C(0x00067BC1C675D49F), UINT64_C(0x00013F553362D7E5)},
         {UINT64_C(0x0004977612BCB0EB), UINT64_C(0x0003E50B8F31A3A8),
          UINT64_C(0x0007CD4AF5A9CB24), UINT64_C(0x0002D3E56A2C0F66),
          UINT64_C(0x0002D65C455CD2EF), UINT64_C(0x0002086963C9C7D0),
          UINT64_C(0x000145D5C4A9FFAE), UINT64_C(0x000619BAC8505C4A),
          UINT64_C(0x000027E3A7AE4A7A), UINT64_C(0x0000B67AD3689936)}},
        {{UINT64_C(0x000CC7D3BF4762C0), UINT64_C(0x0001F746EDBE329E),
          UINT64_C(0x0001DF8B85050FA2), UINT64_C(0x0003BD3B0F568385),
          UINT64_C(0x000180BF161ABAC6), UINT64_C(0x0000215CE0594FA0),
          UINT64_C(0x00047C0CB6A73218), UINT64_C(0x0000DBAEA7BF27D7),
          UINT64_C(0x0002F869F09063DD), UINT64_C(0x00054D9BA9522E09)},
         {UINT64_C(0x0002FE8D87A17CE0), UINT64_C(0x00057E4AC584E74A),
          UINT64_C(0x0002DAC318271EF4), UINT64_C(0x0002423F79D4DEB2),
          UINT64_C(0x0003E960755CCBC4), UINT64_C(0x000D266A7438DBF6),
          UINT64_C(0x000477E42DA16918), UINT64_C(0x0006B11A646B2B6A),
          UINT64_C(0x000431429BD1F7B7), UINT64_C(0x0006ED79801CF551)}},
        {{UINT64_C(0x000C2F5AD403D304), UINT64_C(0x00000E16E8839A82),
          UINT64_C(0x0006E1D15D839778), UINT64_C(0x0005F5B10106BB12),
          UINT64_C(0x0005C19D486DD5C6), UINT64_C(0x000719C29C1E59DF),
          UINT64_C(0x000659479542B834), UINT64_C(0x0007ACDE37B973BE),
          UINT64_C(0x0003482AD9321747), UINT64_C(0x000505ADD6521552)},
         {UINT64_C(0x000F913FC1522D09), UINT64_C(0x00037BFD0D4ABC49),
          UINT64_C(0x00001FA1DDC7C8F2), UINT64_C(0x000557253E6A7DB6),
          UINT64_C(0x0006E4F330384051), UINT64_C(0x000EB36BC2271684),
          UINT64_C(0x0006E60BC26E1F0F), UINT64_C(0x00054A6E03B188FB),
          UINT64_C(0x0003C21955E62B44), UINT64_C(0x00029C4483BA7D4D)}},
        {{UINT64_C(0x000670CC3896EBA5), UINT64_C(0x000259CFB18CBAE2),
          UINT64_C(0x0006699793CC03B7), UINT64_C(0x0006E571D3FF8F29),
          UINT64_C(0x00001EB92283238D), UINT64_C(0x000F5DE25A4C21F7),
          UINT64_C(0x00021DA151657372), UINT64_C(0x0005351A570D55D1),
          UINT64_C(0x0005E3C40430A85A), UINT64_C(0x0001A3FAEB0F9878)},
         {UINT64_C(0x00041F28CA0920E8), UINT64_C(0x0000528AA3286F64),
          UINT64_C(0x000550CD85825A5A), UINT64_C(0x0006A07132346430),
          UINT64_C(0x0006248B435552B3), UINT64_C(0x000C51E8492A342A),
          UINT64_C(0x000238B2E633EAE5), UINT64_C(0x00077EFF4FF5E3AF),
          UINT64_C(0x000737FE3C5938DC), UINT64_C(0x0003E7F342587F14)}},
        {{UINT64_C(0x0000469EA4F316A5), UINT64_C(0x0000CFF01ADFC8EC),
          UINT64_C(0x000752DEE0AF6B42), UINT64_C(0x0000FBD7A1DB547A),
          UINT64_C(0x00071529F9CBFCB7), UINT64_C(0x0002EEF2C4E55DE9),
          UINT64_C(0x00068B08FC158B20), UINT64_C(0x0005BA1440B0CD47),
          UINT64_C(0x000770690268EB1C), UINT64_C(0x0004FEA766326EEE)},
         {UINT64_C(0x0007E31940932215), UINT64_C(0x0006F953571E0D10),
          UINT64_C(0x000325DB7CA114C1), UINT64_C(0x0003346F1BDB76FF),
          UINT64_C(0x0004B2D608C398A0), UINT64_C(0x000880C15A6358CD),
          UINT64_C(0x00003A12DA7DAE1C), UINT64_C(0x00012A98295624DC),
          UINT64_C(0x0003F435F64DA03F), UINT64_C(0x00077E682761BD79)}},
        {{UINT64_C(0x000725EBE3550E60), UINT64_C(0x00009759E82357AA),
          UINT64_C(0x000707477FAC3456), UINT64_C(0x00056FDC23023B2E),
          UINT64_C(0x00051E1365B47E4D), UINT64_C(0x000B5D849F58CA94),
          UINT64_C(0x000685BF93742A36), UINT64_C(0x0001A1BC548F6279),
          UINT64_C(0x000344BB9DE268D0), UINT64_C(0x0005FDFB2BC3DEF5)},
         {UINT64_C(0x000848AFB0499C56), UINT64_C(0x00010DC37ABCFDEA),
          UINT64_C(0x0006C1811764BA4D), UINT64_C(0x0002A308A7745FCC),
          UINT64_C(0x00074CBB9E51FB1A), UINT64_C(0x000AC8D6F8659635),
          UINT64_C(0x000154D1F4F69089), UINT64_C(0x00028051B6633DBB),
          UINT64_C(0x0003335687BF4293), UINT64_C(0x0005ED908B0510A4)}},
        {{UINT64_C(0x0004904C9668E6CD), UINT64_C(0x00079071B2B92E94),
          UINT64_C(0x0001E7AE6FF7AF6A), UINT64_C(0x0002127FE63573CD),
          UINT64_C(0x0000D3D1E41CDAC6), UINT64_C(0x00011204952E81CE),
          UINT64_C(0x000271F8C2A453E2), UINT64_C(0x0001B69F9248DB24),
          UINT64_C(0x000379D0353FB400), UINT64_C(0x0001295BB193D08F)},
         {UINT64_C(0x000E90DA27BA514F), UINT64_C(0x0003159CBE1F9C35),
          UINT64_C(0x0005521CD6FEB8F3), UINT64_C(0x0005119F047F6EB1),
          UINT64_C(0x0004D5D0948D614B), UINT64_C(0x0006892CA0E25568),
          UINT64_C(0x0000FD25BBE0A6E7), UINT64_C(0x00021564372435F1),
          UINT64_C(0x00027D8B49CAD04C), UINT64_C(0x00007D5A2C89462D)}},
    },
    {
        {{UINT64_C(0x000F514B71EBBDCC), UINT64_C(0x0004035582F1B252),
          UINT64_C(0x0002A1C7C414989A), UINT64_C(0x0007743F23DC3274),
          UINT64_C(0x000791E243AE6EF8), UINT64_C(0x0009076C398D3FDA),
          UINT64_C(0x00055D23854865C6), UINT64_C(0x00067630F1F7A188),
          UINT64_C(0x0004FEF4830113F0), UINT64_C(0x0006EF4DC0128B39)},
         {UINT64_C(0x000AE1F76A7AB992), UINT64_C(0x0003D7ABB33C7671),
          UINT64_C(0x0007A82D28545FE8), UINT64_C(0x00034AB6DCB3D487),
          UINT64_C(0x0007701ECE7EE900), UINT64_C(0x000E400E5BC2A1A4),
          UINT64_C(0x000693EAE58F5DF2), UINT64_C(0x00037BBA5ED12DB3),
          UINT64_C(0x0005ED5B1E21C1B3), UINT64_C(0x000641DC0D967E8B)}},
        {{UINT64_C(0x00054C95BB0652B1), UINT64_C(0x00046F4FED58813D),
          UINT64_C(0x00050815BA4C242F), UINT64_C(0x0003C70A5ADB1CBD),
          UINT64_C(0x00018471501C557F), UINT64_C(0x00061B89E1DB46F5),
          UINT64_C(0x00030130047B6C15), UINT64_C(0x00024E7E179F958E),
          UINT64_C(0x00029B81AFD116BD), UINT64_C(0x0001F1C0E6F5B495)},
         {UINT64_C(0x00023C05D2947309), UINT64_C(0x000077CE6739DA7A),
          UINT64_C(0x0007175E6FC632C3), UINT64_C(0x00079215145A49EE),
          UINT64_C(0x0005582902E4AEC2), UINT64_C(0x0003D193BC0C12D2),
          UINT64_C(0x0005BA6F099A5DF0), UINT64_C(0x000403F8EF0B4955),
          UINT64_C(0x000642EB7C8A43A1), UINT64_C(0x0005D32BCC2F8B89)}},
        {{UINT64_C(0x00017EB1EE4CB1A1), UINT64_C(0x0006638C230FE375),
          UINT64_C(0x00023DCF4460C9F8), UINT64_C(0x0002497719F0A400),
          UINT64_C(0x00040836988B5191), UINT64_C(0x0004916DE1D1C20D),
          UINT64_C(0x0001141194F546D7), UINT64_C(0x00002179582ACA27),
          UINT64_C(0x0004DBC84C72F8E0), UINT64_C(0x00023C1DFC8EFD14)},
         {UINT64_C(0x00070B7F76ADAF26), UINT64_C(0x0003C6CEB8B1DA8A),
          UINT64_C(0x0003FD11262FDAE0), UINT64_C(0x0002770D8C7E9FB3),
          UINT64_C(0x0006D3BD713575D9), UINT64_C(0x0007838C17F3658C),
          UINT64_C(0x00077F30784494CF), UINT64_C(0x0001CE5F8562296E),
          UINT64_C(0x0005C03FBD4434BB), UINT64_C(0x0001FF536CDDE62E)}},
        {{UINT64_C(0x0001172A96A1E7D6), UINT64_C(0x0001098F9CBA5BBC),
          UINT64_C(0x00074F5479589BDA), UINT64_C(0x0003E78B80CE763C),
          UINT64_C(0x00045042B492B949), UINT64_C(0x000135B01953B25D),
          UINT64_C(0x000564A958658405), UINT64_C(0x00073391FC7A30CF),
          UINT64_C(0x00051DA995FAF2AC), UINT64_C(0x00008899D026CFE6)},
         {UINT64_C(0x0002EF92641119A3), UINT64_C(0x0007CFCD3D8E8348),
          UINT64_C(0x000251D519AA1667), UINT64_C(0x0007524C025888AD),
          UINT64_C(0x0002847F5CB47F5C), UINT64_C(0x0000C637101A1799),
          UINT64_C(0x000684496C314774), UINT64_C(0x0005DF9F71863B37),
          UINT64_C(0x0003099895A2F373), UINT64_C(0x0000333CA2E94544)}},
        {{UINT64_C(0x00070CCF02ECB2CC), UINT64_C(0x000105EF4D0A506E),
          UINT64_C(0x00007BF7A4DE2CA0), UINT64_C(0x0006DAB36E4422DE),
          UINT64_C(0x0005261AD9D05DF0), UINT64_C(0x000C9FCA9FCF1803),
          UINT64_C(0x00077F743B9F8F4A), UINT64_C(0x00054F8CFD871DBE),
          UINT64_C(0x00008369A88F23E3), UINT64_C(0x0004DE24D800793E)},
         {UINT64_C(0x00080D00BBD99113), UINT64_C(0x000705E433C3D50A),
          UINT64_C(0x0000CC78397E7790), UINT64_C(0x00033741085A403B),
          UINT64_C(0x0006E31F0AE64239), UINT64_C(0x0004B8AE3CC6DEFC),
          UINT64_C(0x0007FC3C4D4BFA22), UINT64_C(0x0005A85FF42BA85E),
          UINT64_C(0x0005E2879D483F75), UINT64_C(0x000111B21C595B57)}},
        {{UINT64_C(0x000B69E54FB31425), UINT64_C(0x0007670DB77E68C9),
          UINT64_C(0x000200548E67C390), UINT64_C(0x0007E58E7DA1316B),
          UINT64_C(0x00065C0A1A2EC1E9), UINT64_C(0x000566CC8A93BAED),
          UINT64_C(0x00034140BA9D29BD), UINT64_C(0x00066D8BC0434EC9),
          UINT64_C(0x000545F0A0BE9D95), UINT64_C(0x0005D43571D5259A)},
         {UINT64_C(0x000CB66450379E4A), UINT64_C(0x0002EA896E3D63C2),
          UINT64_C(0x0000A1CBC3C15620), UINT64_C(0x0004F3A6795DCE0B),
          UINT64_C(0x0007A3F6DAC83AC6), UINT64_C(0x0005EC06F01B9BAD),
          UINT64_C(0x0006468A896619D3), UINT64_C(0x0003C2FAACC2C60B),
          UINT64_C(0x0006858F9F24FF57), UINT64_C(0x00011A6265D8A36E)}},
        {{UINT64_C(0x00041C66E40F1A90), UINT64_C(0x0004E4F0180E78EF),
          UINT64_C(0x0003FB530CA47EAF), UINT64_C(0x0007ABB19E0A2FA0),
          UINT64_C(0x00041ABDD6CB403F), UINT64_C(0x000DAB4EEE08EF52),
          UINT64_C(0x00023FC4E743BC92), UINT64_C(0x0005B913456A7476),
          UINT64_C(0x0001C85ADE3AC4F1), UINT64_C(0x0004C1EA18C4581B)},
         {UINT64_C(0x000AC8C9F1F7F0A6), UINT64_C(0x0007E11A1C557ED2),
          UINT64_C(0x0000E1E16CCE15D8), UINT64_C(0x000132838704418A),
          UINT64_C(0x0002E6AFA3B1E448), UINT64_C(0x000D76FF3FBC3F61),
          UINT64_C(0x00015097A2812475), UINT64_C(0x0000F295A5BC66CB),
          UINT64_C(0x0002FF9986FD6334), UINT64_C(0x000792181517F379)}},
        {{UINT64_C(0x000593BFA181F4DE), UINT64_C(0x00076E78859CC727),
          UINT64_C(0x0000768CDCBCFB1D), UINT64_C(0x0002B147828E8906),
          UINT64_C(0x0004D189BBDFAF3E), UINT64_C(0x000F4188F2DE5620),
          UINT64_C(0x0005541E2603D86E), UINT64_C(0x00068B0163E24EF2),
          UINT64_C(0x000732F7A222EC67), UINT64_C(0x00030102005758D0)},
         {UINT64_C(0x000965B8766CC610), UINT64_C(0x0006CED5C6750EC9),
          UINT64_C(0x0002510890A11A94), UINT64_C(0x00050A335E380C21),
          UINT64_C(0x0002D3AAA4B5ABB1), UINT64_C(0x000C3DEBF83FD12E),
          UINT64_C(0x00042A5B613A963D), UINT64_C(0x00048A5474D5B2CC),
          UINT64_C(0x0006DBC324E377DF), UINT64_C(0x0004A450113CC47F)}},
        {{UINT64_C(0x00082FD2D666BA94), UINT64_C(0x000307B3C69374F1),
          UINT64_C(0x00030E4DCCADA50B), UINT64_C(0x00025121DD5AF46E),
          UINT64_C(0x0005DAE113DE717D), UINT64_C(0x000F540F6A242AF7),
          UINT64_C(0x0001984B2DEE5FE8), UINT64_C(0x000751006703C07F),
          UINT64_C(0x0003C4BED0C06C42), UINT64_C(0x0006834E2CFEAF97)},
         {UINT64_C(0x00079EF331F8BE0C), UINT64_C(0x0006C58FB2C0D852),
          UINT64_C(0x000642C225B2131C), UINT64_C(0x0003F1F2DD654AF1),
          UINT64_C(0x0003F6D400299A16), UINT64_C(0x000A1D524B709913),
          UINT64_C(0x0007F61D15FA8CD7), UINT64_C(0x00007D279176192A),
          UINT64_C(0x0004CB0573788091), UINT64_C(0x00017B43566C1463)}},
        {{UINT64_C(0x0007A50D58E645CD), UINT64_C(0x000717BFEFCEFD32),
          UINT64_C(0x00021533C2082002), UINT64_C(0x0000B6C97BE84215),
          UINT64_C(0x0003D9526234147F), UINT64_C(0x000736AFD37F86C3),
          UINT64_C(0x0001446C15A309FC), UINT64_C(0x00049F6A2E32732D),
          UINT64_C(0x0005A7F6B6BD0310), UINT64_C(0x00049050A86F7F6E)},
         {UINT64_C(0x000478A084486F70), UINT64_C(0x0004B485E454FFE6),
          UINT64_C(0x00005134AC546D22), UINT64_C(0x00045EC4A7C0DB13),
          UINT64_C(0x0003AB8CCE7A0B15), UINT64_C(0x000601A238F1B5B3),
          UINT64_C(0x00063D63F830D881), UINT64_C(0x0000F2D0A86F5488),
          UINT64_C(0x00077A07AB5A6307), UINT64_C(0x0001A0E97FE656C5)}},
        {{UINT64_C(0x0002B8E72C38FDE6), UINT64_C(0x0001650DDE9F2E2E),
          UINT64_C(0x00028EF99CEB5566), UINT64_C(0x00041C64DDA06D6A),
          UINT64_C(0x00005CB89B26AD37), UINT64_C(0x000A5F15A5F8AF03),
          UINT64_C(0x00025505F3937C0E), UINT64_C(0x000159B4CD9043F4),
          UINT64_C(0x000343C00F6BA0DB), UINT64_C(0x00047E9671AB1CFB)},
         {UINT64_C(0x0007DE9E2086ECD6), UINT64_C(0x0000A7B07155978A),
          UINT64_C(0x00026C99DCA72BC9), UINT64_C(0x0004F4F2C6EB2ED1),
          UINT64_C(0x00074C9CE7C64240), UINT64_C(0x000A4D876B2764B2),
          UINT64_C(0x0005394454615D25), UINT64_C(0x000481776CCE078B),
          UINT64_C(0x000186A538247AB1), UINT64_C(0x000333D9943B1146)}},
        {{UINT64_C(0x00084973CEDC2791), UINT64_C(0x0002950F48F39EEB),
          UINT64_C(0x0000EF6F70D1EFF2), UINT64_C(0x0004D3D6FD70FEAF),
          UINT64_C(0x000638ED86C3A27D), UINT64_C(0x000F9B23D52DAEF5),
          UINT64_C(0x0007DCA2C6212A71), UINT64_C(0x0003A72278C541D8),
          UINT64_C(0x0000D206D53E4F6B), UINT64_C(0x0007CC2FD213C6D8)},
         {UINT64_C(0x0009C9835F59129E), UINT64_C(0x0007F4A22C2FB8AC),
          UINT64_C(0x0000EB9FBBDAB0AF), UINT64_C(0x000397BE0B58FC49),
          UINT64_C(0x0000D58A5D14AA83), UINT64_C(0x000CBCDEEF3C688F),
          UINT64_C(0x0007F56D84202AE6), UINT64_C(0x0001AACDE92E0055),
          UINT64_C(0x0006A0198A5DD4EF), UINT64_C(0x00009072B8CFBB20)}},
        {{UINT64_C(0x000F7FEC5A5D3591), UINT64_C(0x0003CC91186CC1D7),
          UINT64_C(0x0000539F22D56CB3), UINT64_C(0x00014418785A7E75),
          UINT64_C(0x0007DD55510142B3), UINT64_C(0x00027C9298FBB5F7),
          UINT64_C(0x0002E6839156F4F1), UINT64_C(0x00006806E7AF3BDD),
          UINT64_C(0x00017FEEBFA3E11C), UINT64_C(0x0005E3B668C8CF1E)},
         {UINT64_C(0x0002E308DB4D3ABB), UINT64_C(0x0002519214DBB309),
          UINT64_C(0x00053F1D5795FB73), UINT64_C(0x00006C5A6BA835DE),
          UINT64_C(0x0007282B5833FF0C), UINT64_C(0x0007CA1C54F0B679),
          UINT64_C(0x00067F8A25FBF269), UINT64_C(0x00006A247708AB5B),
          UINT64_C(0x000271FDD248BDC5), UINT64_C(0x00001617D43FC96F)}},
        {{UINT64_C(0x000530DC05A439D4), UINT64_C(0x0002C89DF13D212F),
          UINT64_C(0x00006CD963D870CE), UINT64_C(0x00070E6A17E094DF),
          UINT64_C(0x0005335D7B440052), UINT64_C(0x0005D20A7FC5B6E6),
          UINT64_C(0x0000816C1BD2E991), UINT64_C(0x00015BFD4D6A50B8),
          UINT64_C(0x000611290ED60372), UINT64_C(0x000252141FDE02E6)},
         {UINT64_C(0x000EE270D2D5D91D), UINT64_C(0x00064864D00DF773),
          UINT64_C(0x0002CDF8C5BDD29E), UINT64_C(0x0004B4D19D843238),
          UINT64_C(0x0001E7349DF960FB), UINT64_C(0x000AB7E45A9B26DB),
          UINT64_C(0x0002D5282F6EE449), UINT64_C(0x0004F9B215872CD1),
          UINT64_C(0x0002F931EDC40DD7), UINT64_C(0x0004C76A77256A9F)}},
        {{UINT64_C(0x0006A781358C169E), UINT64_C(0x000093BAB2A31F43),
          UINT64_C(0x0002C0B13C7E6C0A), UINT64_C(0x00035E6DBE645073),
          UINT64_C(0x00027A3CF6B52BB2), UINT64_C(0x0007090F7CD7F0B6),
          UINT64_C(0x00049B2C3B592E30), UINT64_C(0x0002359164A5EB6A),
          UINT64_C(0x0004DC6C9A544458), UINT64_C(0x0007423068D875B5)},
         {UINT64_C(0x00059D79EBA27F83), UINT64_C(0x0005D19F0CBC111F),
          UINT64_C(0x000753952EB35496), UINT64_C(0x00062897B4108C18),
          UINT64_C(0x0006D7F09D866E46), UINT64_C(0x0005897E202402FA),
          UINT64_C(0x0001D12E39D2981C), UINT64_C(0x0004D1F9BD50FDDC),
          UINT64_C(0x00060754737FA4EC), UINT64_C(0x0004B66C109681C2)}},
        {{UINT64_C(0x00091EB3450A8B6F), UINT64_C(0x0006E67784D11649),
          UINT64_C(0x00052A0A75E83A4C), UINT64_C(0x0000C7EF54A33FAB),
          UINT64_C(0x0007E4B1F177CCAC), UINT64_C(0x000B1572C584C7B2),
          UINT64_C(0x0003F88F3DDE8AF6), UINT64_C(0x00055A76B8A9FEC4),
          UINT64_C(0x0004D726D797ABF3), UINT64_C(0x000063A37056B2C1)},
         {UINT64_C(0x000BEC5B8D4113B1), UINT64_C(0x0004AF1E78531E4F),
          UINT64_C(0x0003A706B01EA69E), UINT64_C(0x000114C7197A503E),
          UINT64_C(0x00068D6405B730D6), UINT64_C(0x00037F60FB050D8E),
          UINT64_C(0x0002625FCDD6414D), UINT64_C(0x0000A66900D00C7B),
          UINT64_C(0x0007AADE957078F1), UINT64_C(0x000708B1373BF752)}},
    },
    {
        {{UINT64_C(0x000C3BAB92C31CE5), UINT64_C(0x00002134ECD1DE22),
          UINT64_C(0x000610E7706C8F42), UINT64_C(0x0004D37D742251A7),
          UINT64_C(0x0003F0AD3A1A8A28), UINT64_C(0x0005B53175168302),
          UINT64_C(0x0007812CA56B0662), UINT64_C(0x0006DBA3FECD0E65),
          UINT64_C(0x000488903D3A2C5C), UINT64_C(0x000356F226A3070C)},
         {UINT64_C(0x000C6272379969A8), UINT64_C(0x000030E999753799),
          UINT64_C(0x00006FA2FD45CF73), UINT64_C(0x0005B8B69287AF76),
          UINT64_C(0x0005213C07A81179), UINT64_C(0x0008D822B335452D),
          UINT64_C(0x000011E080D0121B), UINT64_C(0x000337047AED499C),
          UINT64_C(0x0005F3F0DAE82068), UINT64_C(0x000287D13EDC6853)}},
        {{UINT64_C(0x000890BAE3CD0A60), UINT64_C(0x0007CFCB31DC10E6),
          UINT64_C(0x00042A0AD557A444), UINT64_C(0x0005E3E8DEDD318E),
          UINT64_C(0x0004B768FB3B1B2D), UINT64_C(0x000A74BE0F89CA10),
          UINT64_C(0x0003022817A331F0), UINT64_C(0x000398531778D3CE),
          UINT64_C(0x0003F92B536499CA), UINT64_C(0x00039BBC19367C44)},
         {UINT64_C(0x0003D17E79CF10DA), UINT64_C(0x00041C136308597C),
          UINT64_C(0x0001C7CFCC962C3F), UINT64_C(0x0005F7010BF5A11D),
          UINT64_C(0x00018E8314AB3E4C), UINT64_C(0x000B784160490F36),
          UINT64_C(0x00002C72D731F23C), UINT64_C(0x00059E1083EF050E),
          UINT64_C(0x00029D7C307711F7), UINT64_C(0x00028978EEF174D0)}},
        {{UINT64_C(0x0000B2EDE471ED48), UINT64_C(0x00049FF7F87A8FDE),
          UINT64_C(0x000407DAC8E66330), UINT64_C(0x00017A99137DCD53),
          UINT64_C(0x000413D5BA8A3E49), UINT64_C(0x00069E2849ED7ACF),
          UINT64_C(0x00011A49582E3C16), UINT64_C(0x0003EF82C8E245ED),
          UINT64_C(0x0002209E0B7EA09E), UINT64_C(0x000640B26788B817)},
         {UINT64_C(0x000FB77EC4895293), UINT64_C(0x000521EE12FEC7C5),
          UINT64_C(0x0006B87272F0F4BE), UINT64_C(0x000743571A70D3FA),
          UINT64_C(0x00012A853508E676), UINT64_C(0x000C8E90D720C744),
          UINT64_C(0x0004E53325BF55D5), UINT64_C(0x00022141D2FC04DE),
          UINT64_C(0x0002C08E37CCB8A9), UINT64_C(0x0005B2FF2928CA19)}},
        {{UINT64_C(0x00093112664E6955), UINT64_C(0x000318FAC599B3B0),
          UINT64_C(0x0004E86FFA5DC372), UINT64_C(0x00011CEA6B7ED8B5),
          UINT64_C(0x00032C5BB4D4B3E4), UINT64_C(0x00012FAB789556A8),
          UINT64_C(0x0005FD6D51C50C39), UINT64_C(0x0001F53B8DF4EB2C),
          UINT64_C(0x0003DC5A71DF97A9), UINT64_C(0x000202CBFD6A2695)},
         {UINT64_C(0x000A8D3B3805ED4E), UINT64_C(0x0006E97BF7B19A75),
          UINT64_C(0x000020C8EF1A157A), UINT64_C(0x0000DDAD96ECC141),
          UINT64_C(0x000634B69890E950), UINT64_C(0x000BCFBDA6464E18),
          UINT64_C(0x00057A50EC40E5E7), UINT64_C(0x000369C5C34E75A1),
          UINT64_C(0x0001DDDA57109D52), UINT64_C(0x000109C8DA359727)}},
        {{UINT64_C(0x000DC858E40E2D09), UINT64_C(0x0006583010E4FCF5),
          UINT64_C(0x0005616E9FBECEE8), UINT64_C(0x0004CC7EC96FFCA8),
          UINT64_C(0x0005436EDC94F6C0), UINT64_C(0x0001BFB47EC04EC2),
          UINT64_C(0x000353148F9B2046), UINT64_C(0x0002E68773E2D458),
          UINT64_C(0x000128904A0917E3), UINT64_C(0x0007E5A730228042)},
         {UINT64_C(0x000447DEFB88BB4F), UINT64_C(0x00012D87179A012D),
          UINT64_C(0x0002379DFC6577E4), UINT64_C(0x000646EB1BA5867E),
          UINT64_C(0x0004927A6707CB7F), UINT64_C(0x000F2F4B5DD2C056),
          UINT64_C(0x000148E5C0EB9590), UINT64_C(0x000022E829ADA8D2),
          UINT64_C(0x00066C299B36127A), UINT64_C(0x000208ACAE17BA18)}},
        {{UINT64_C(0x0003FD0BE2AFDA6A), UINT64_C(0x00079A3A05AFE09A),
          UINT64_C(0x00024431B9238AF6), UINT64_C(0x000196CDCEEABC5D),
          UINT64_C(0x0005CD6BA856B384), UINT64_C(0x0003376ABB9C7D13),
          UINT64_C(0x0000E28403D233B1), UINT64_C(0x0001E3E601F20B20),
          UINT64_C(0x000553A7F33316D7), UINT64_C(0x00077A41CF9D1895)},
         {UINT64_C(0x00018114833694B4), UINT64_C(0x00066ACE25DEC0AC),
          UINT64_C(0x000000AD04607BBE), UINT64_C(0x0001C2BBD9D88ED5),
          UINT64_C(0x000207EF8CDA325D), UINT64_C(0x0008C36267211FB6),
          UINT64_C(0x0004148ABE972485), UINT64_C(0x00032559C1C5BC5F),
          UINT64_C(0x0000D7CC34EB0616), UINT64_C(0x0006CFEBFC675164)}},
        {{UINT64_C(0x0006391786A18B11), UINT64_C(0x00072B22981C2BBC),
          UINT64_C(0x00064B2DCDABB7B4), UINT64_C(0x000307055034DD3A),
          UINT64_C(0x00051C4CAE5629B9), UINT64_C(0x0007AAF27949F035),
          UINT64_C(0x0002346889D53C01), UINT64_C(0x0006F67E4A19CA62),
          UINT64_C(0x000331666606352F), UINT64_C(0x0005374DF049C2AC)},
         {UINT64_C(0x0002B2B3139457D6), UINT64_C(0x000351A98E4D4EB2),
          UINT64_C(0x0003DC00C4EBC1E7), UINT64_C(0x00017CA9107B252F),
          UINT64_C(0x0007D9A4523CFBEB), UINT64_C(0x00037F677495611A),
          UINT64_C(0x00032ACDFB65FA6E), UINT64_C(0x000005C03EBCCAC4),
          UINT64_C(0x00044D67340F21A9), UINT64_C(0x0006F83F5FED3656)}},
        {{UINT64_C(0x000E79AA3546F16F), UINT64_C(0x0000A94AF4903B11),
          UINT64_C(0x0005BFBC2B88E83A), UINT64_C(0x0001616214CA6D22),
          UINT64_C(0x0002F33B14AC87D4), UINT64_C(0x000DC3668AC17EC3),
          UINT64_C(0x0003F9A5CD0FA18C), UINT64_C(0x00012136A765687B),
          UINT64_C(0x000477263FD5ADD5), UINT64_C(0x00047574A89B0A9F)},
         {UINT64_C(0x00086FD1F3EC5E19), UINT64_C(0x0001A0517754F902),
          UINT64_C(0x0003FBB71A4EF414), UINT64_C(0x00060C166C23D6D5),
          UINT64_C(0x0003CB4401A452C9), UINT64_C(0x00084139B2A26F87),
          UINT64_C(0x000194184853F0AF), UINT64_C(0x000725C3E883547A),
          UINT64_C(0x00007311B46CFE9E), UINT64_C(0x0006272C00057E36)}},
        {{UINT64_C(0x00091526FAFA38D9), UINT64_C(0x00013C7B17BEB483),
          UINT64_C(0x0005FBC53CC1E78B), UINT64_C(0x0000C1040CBB5D8E),
          UINT64_C(0x0003A0AF18FC9ADE), UINT64_C(0x0007BC9B9B737A51),
          UINT64_C(0x00058EAEC3E9FED9), UINT64_C(0x0000D346CF710790),
          UINT64_C(0x0003BE2B75105FA1), UINT64_C(0x0004D079255CE7B8)},
         {UINT64_C(0x00006C7D92D0825D), UINT64_C(0x00027A8C0386749E),
          UINT64_C(0x0001C5B09D0FC792), UINT64_C(0x0002C2B760A9C963),
          UINT64_C(0x0001524437DB7579), UINT64_C(0x0001B37F4B60ABD4),
          UINT64_C(0x0007FE579406D534), UINT64_C(0x0002739C0C35BD00),
          UINT64_C(0x00051086E45FFF04), UINT64_C(0x0003F4C9935FE354)}},
        {{UINT64_C(0x0004E5D268BD8A83), UINT64_C(0x000377586FC26AA0),
          UINT64_C(0x00030113A02CBC64), UINT64_C(0x000692EB25CA12F0),
          UINT64_C(0x0001A47E293F9D79), UINT64_C(0x000DD2612D416AA9),
          UINT64_C(0x00019FAC853D7BDD), UINT64_C(0x00001B9C4E8811EC),
          UINT64_C(0x000164570C0AABCB), UINT64_C(0x0002DBCACCC287E8)},
         {UINT64_C(0x00027EADFBCEA391), UINT64_C(0x000406BA866FB97C),
          UINT64_C(0x000250E70AA28457), UINT64_C(0x0000CE5D6B77F502),
          UINT64_C(0x0007E1FE982DC604), UINT64_C(0x00077DC8CD9AEDE3),
          UINT64_C(0x0006EECC4E8C56CC), UINT64_C(0x000529E001D51C07),
          UINT64_C(0x0000D42CF53B5E54), UINT64_C(0x00059F46F2041F90)}},
        {{UINT64_C(0x000A993579C46A7C), UINT64_C(0x0003FADB3C50214A),
          UINT64_C(0x0007552587801072), UINT64_C(0x00008E9ED9922E64),
          UINT64_C(0x0001D65D1FE863B0), UINT64_C(0x000B68B2D984977E),
          UINT64_C(0x00026F8BCC4EF71E), UINT64_C(0x0004580D2CF9C07C),
          UINT64_C(0x0005F7DB9F7C5608), UINT64_C(0x00039723A14ADB8F)},
         {UINT64_C(0x0001FC8374852517), UINT64_C(0x0004EFCD85E78688),
          UINT64_C(0x0005BA5C6E340E04), UINT64_C(0x0002AD5541C4F7E0),
          UINT64_C(0x0007AFEAD74D7911), UINT64_C(0x000772EEA94A657C),
          UINT64_C(0x000372BB0B3340C5), UINT64_C(0x0002DFFC3FE428C3),
          UINT64_C(0x0007780B19634458), UINT64_C(0x000396C2E8AD8E1B)}},
        {{UINT64_C(0x000A0DC2AEA8D665), UINT64_C(0x000497C1A0EAAB74),
          UINT64_C(0x00034918630C5E96), UINT64_C(0x00021960961A8492),
          UINT64_C(0x00056059C4ACA995), UINT64_C(0x000FDDE1D84A2BCA),
          UINT64_C(0x0003E28D6D947C37), UINT64_C(0x00059FA17EA39CB1),
          UINT64_C(0x0002B2B829872434), UINT64_C(0x0001AD4DAEAA9FE2)},
         {UINT64_C(0x000F2E4853E5AF32), UINT64_C(0x0004693D39964BD6),
          UINT64_C(0x0006A84B327FFE47), UINT64_C(0x0002F3C1238E197A),
          UINT64_C(0x0003790974398BDF), UINT64_C(0x000FF31F3581AF07),
          UINT64_C(0x0004C239726330EE), UINT64_C(0x0002C366AFC8A963),
          UINT64_C(0x0005B30D24500CBF), UINT64_C(0x0007D9C6B29592A1)}},
        {{UINT64_C(0x000E71DDD57E8296), UINT64_C(0x000346C03100FF87),
          UINT64_C(0x00046A920C6C7EF3), UINT64_C(0x00017883AE0679DA),
          UINT64_C(0x0007371362C409A2), UINT64_C(0x0003F3FD0398532B),
          UINT64_C(0x00047C47A292C97E), UINT64_C(0x0003E20A94F0DAB2),
          UINT64_C(0x000615A39700E27A), UINT64_C(0x0004DD4F52D80B70)},
         {UINT64_C(0x000D8189C3E7FF9B), UINT64_C(0x0006A323F12ACCE3),
          UINT64_C(0x000218561CEBE916), UINT64_C(0x000582DFFA5B6244),
          UINT64_C(0x00017E86803253FE), UINT64_C(0x000F6E066437E671),
          UINT64_C(0x00003379D07B3571), UINT64_C(0x00028E80792D0F88),
          UINT64_C(0x0003ADB5E00F7D48), UINT64_C(0x0004490947B64CC1)}},
        {{UINT64_C(0x000966BA117EB5A0), UINT64_C(0x0003EAD0F9635F78),
          UINT64_C(0x0001127434D7F565), UINT64_C(0x000166F7EFE73A42),
          UINT64_C(0x0006E1EB3EE2C95B), UINT64_C(0x0002169A44ADD28F),
          UINT64_C(0x0007D099F80F5E40), UINT64_C(0x00001673EEDC2717),
          UINT64_C(0x0006D35CE7C87042), UINT64_C(0x0001F1659FA895C4)},
         {UINT64_C(0x0000CDA418AFEEA2), UINT64_C(0x00022BB4CD3D78EA),
          UINT64_C(0x0007CCB3C8415D6C), UINT64_C(0x00072FAD0144A08F),
          UINT64_C(0x0006AD7BD312743A), UINT64_C(0x0009717E7E313571),
          UINT64_C(0x00030507C307B184), UINT64_C(0x00037E8A184867EE),
          UINT64_C(0x0005A0F950ED5715), UINT64_C(0x00035FB26907AA86)}},
        {{UINT64_C(0x00087069CFCD15C6), UINT64_C(0x0005E74CAE8DD69A),
          UINT64_C(0x00077415248EC6CF), UINT64_C(0x00039CFB19D98136),
          UINT64_C(0x0004102ADA4617F0), UINT64_C(0x00091344A9950D43),
          UINT64_C(0x0007F37FAA893404), UINT64_C(0x0000894C6ED07059),
          UINT64_C(0x0001CBD2D8C191AE), UINT64_C(0x0005E7D0A8D6C1FB)},
         {UINT64_C(0x000D8A6DCD86A648), UINT64_C(0x00069DFB00FAC67A),
          UINT64_C(0x00055E4E4A8BF53E), UINT64_C(0x00052C3F21F19F1A),
          UINT64_C(0x000199681E75B076), UINT64_C(0x000B461379ABA50E),
          UINT64_C(0x00027C35B013932E), UINT64_C(0x0003E43D98DC3C8B),
          UINT64_C(0x0005299D0D27C3FF), UINT64_C(0x000501003FB5C76B)}},
        {{UINT64_C(0x0002584D9F215747), UINT64_C(0x0007BE751EE9975B),
          UINT64_C(0x0006739CFFA040AB), UINT64_C(0x00021F693AB51286),
          UINT64_C(0x0004378F5B99BA03), UINT64_C(0x00092021DCD03E29),
          UINT64_C(0x00029C3D833529D1), UINT64_C(0x0003218DAA201C66),
          UINT64_C(0x00068DD2830252B2), UINT64_C(0x0000C547881361FE)},
         {UINT64_C(0x0004DA1DDF2727C5), UINT64_C(0x000141088C10F286),
          UINT64_C(0x00033EFA65C7AD64), UINT64_C(0x000309E225C521F2),
          UINT64_C(0x000165C50DA477FD), UINT64_C(0x0006A39D52AC02AF),
          UINT64_C(0x000583FDD7E42212), UINT64_C(0x00049409EBFF68E5),
          UINT64_C(0x0003F0AC36D8B5F7), UINT64_C(0x0007F9BFC22F82AF)}},
    },
    {
        {{UINT64_C(0x0002372DBC024334), UINT64_C(0x0003AC04780C37E6),
          UINT64_C(0x0000B462B14E1199), UINT64_C(0x000789AB88A9152C),
          UINT64_C(0x0004669A83086007), UINT64_C(0x0002875233E2BB95),
          UINT64_C(0x000164D14E6DD133), UINT64_C(0x0007834C96D7F2E1),
          UINT64_C(0x0000376AF8A1FB72), UINT64_C(0x00025E655DD42C55)},
         {UINT64_C(0x000BC3F8D59BD4F8), UINT64_C(0x0004295AE12759FE),
          UINT64_C(0x0001710B8788649D), UINT64_C(0x00063FB5252144E8),
          UINT64_C(0x0000FB67B48BFB15), UINT64_C(0x000EF2243C620B1A),
          UINT64_C(0x00043471BAB61989), UINT64_C(0x000297865EB6854C),
          UINT64_C(0x00041EC649B840B6), UINT64_C(0x0000DBB860FE03FD)}},
        {{UINT64_C(0x000F3F668337995A), UINT64_C(0x0000D23F1A076787),
          UINT64_C(0x000559B19C7D6F35), UINT64_C(0x0001F5D63B1D816A),
          UINT64_C(0x0004919133B61F8E), UINT64_C(0x00031862225D9C14),
          UINT64_C(0x0003C6604EA7EF2F), UINT64_C(0x00062AF2D864BE9B),
          UINT64_C(0x0004E75593316CB0), UINT64_C(0x0006270C9215DEE8)},
         {UINT64_C(0x00079DDB43AE991A), UINT64_C(0x0000D9D288C5279D),
          UINT64_C(0x00010A5CE9E2122D), UINT64_C(0x0006627C1899977C),
          UINT64_C(0x0004545C3F73568F), UINT64_C(0x00041DA4E722FDD7),
          UINT64_C(0x0001D1CA3BA6C0E4), UINT64_C(0x000154DDB8B11262),
          UINT64_C(0x00076A8BBB916CBA), UINT64_C(0x000264F61CEB449C)}},
        {{UINT64_C(0x000C03E88F01C0CF), UINT64_C(0x0002DE2458CBF5D8),
          UINT64_C(0x00059AB57877E3A8), UINT64_C(0x000022BA99E9FF36),
          UINT64_C(0x0006E3D7F3651BA4), UINT64_C(0x00091A76C49112C9),
          UINT64_C(0x00033BFF09F31D44), UINT64_C(0x00037DF6585ECCB8),
          UINT64_C(0x00031E08F635DFAB), UINT64_C(0x00061B6BEEA111BC)},
         {UINT64_C(0x000EC7C8AED31D53), UINT64_C(0x0001C2D420733AED),
          UINT64_C(0x00028A0A574AB6AC), UINT64_C(0x0000C07A2A7F50B8),
          UINT64_C(0x000146FAE597AF65), UINT64_C(0x000BFB422415D9A7),
          UINT64_C(0x0003B3FAF595D88B), UINT64_C(0x00016FABFA94B1DD),
          UINT64_C(0x00077BD9F4E1A511), UINT64_C(0x0001ED87CB724465)}},
        {{UINT64_C(0x000213F3A12FADCB), UINT64_C(0x00073702A45BFCC2),
          UINT64_C(0x00005344B6A0BE9D), UINT64_C(0x0005780B5541C989),
          UINT64_C(0x0004689EA1E50219), UINT64_C(0x0005B3C5CE5DF752),
          UINT64_C(0x000187B449599429), UINT64_C(0x0004F3F92602410B),
          UINT64_C(0x00008266C08FAD01), UINT64_C(0x00006449FDC76A08)},
         {UINT64_C(0x0001290134E207CC), UINT64_C(0x0005FC0BF00CD133),
          UINT64_C(0x0005093E94846544), UINT64_C(0x0001904D36A7E4E0),
          UINT64_C(0x0006CFB29FCB4C43), UINT64_C(0x00021A5E794AD08A),
          UINT64_C(0x00049AF3B74BD0CA), UINT64_C(0x0003D12DD54A42E0),
          UINT64_C(0x00020F8191FC6C17), UINT64_C(0x0005271ACF2BEF13)}},
        {{UINT64_C(0x0003973D23C5FC40), UINT64_C(0x00022C79CF716759),
          UINT64_C(0x000698E37C807E96), UINT64_C(0x00061499D8A20942),
          UINT64_C(0x0003CA6565D1591A), UINT64_C(0x000376C82319132C),
          UINT64_C(0x0000AB592C414D58), UINT64_C(0x00078DCD766F3A9F),
          UINT64_C(0x000235326903A314), UINT64_C(0x0001C533CF655AFB)},
         {UINT64_C(0x000417ABAE4343FF), UINT64_C(0x0000CC1BEBE8BA73),
          UINT64_C(0x00035CFD9C4CD9EB), UINT64_C(0x000525DDECFE78DD),
          UINT64_C(0x0004018B732A3EA9), UINT64_C(0x0004158841836B35),
          UINT64_C(0x00013A9FC11821AB), UINT64_C(0x0001A62E3E9F6760),
          UINT64_C(0x00019D2F382BFC5A), UINT64_C(0x00048B8C5EE1498A)}},
        {{UINT64_C(0x00067BC07969E710), UINT64_C(0x00056FE1647FF971),
          UINT64_C(0x00056B9EC60E5571), UINT64_C(0x0004FF5FF4D6D59D),
          UINT64_C(0x00048349FDBC6F40), UINT64_C(0x0000EDA3EDA8889B),
          UINT64_C(0x0000C724742965C9), UINT64_C(0x0004CA3A42627635),
          UINT64_C(0x00047141B8D6F392), UINT64_C(0x0003D2FEDEAA1C29)},
         {UINT64_C(0x000716C803508620), UINT64_C(0x0004F95142A62BB6),
          UINT64_C(0x000486FEE8AA4AD7), UINT64_C(0x0007AEE5F2F7D145),
          UINT64_C(0x00073A3D7B302EEA), UINT64_C(0x000C31B194B33CB5),
          UINT64_C(0x0005E8F7E9DB0F29), UINT64_C(0x00026804A1976839),
          UINT64_C(0x000224312A20168B), UINT64_C(0x0004C6397AFDC614)}},
        {{UINT64_C(0x000B366A0560CD66), UINT64_C(0x0005ACD26E6E7D4B),
          UINT64_C(0x0001A29126E560EF), UINT64_C(0x00077D0A85F35263),
          UINT64_C(0x00066BB4F7909A61), UINT64_C(0x000089487A0F6CA2),
          UINT64_C(0x00004201AC59EC89), UINT64_C(0x0003517D862DA268),
          UINT64_C(0x0004E06334DCBFC2), UINT64_C(0x000542129BF06EDC)},
         {UINT64_C(0x0009AC6AC40ECFAD), UINT64_C(0x0004A4A6435450F2),
          UINT64_C(0x0003884DC2B01CE7), UINT64_C(0x00033DFEBB566E48),
          UINT64_C(0x000578290964FDAC), UINT64_C(0x00023B7A353BC889),
          UINT64_C(0x0005060A08B7EE8B), UINT64_C(0x0007AB7A129FEBF9),
          UINT64_C(0x000546502F940252), UINT64_C(0x0001DBB0164F28EF)}},
        {{UINT64_C(0x00018A4A75F64304), UINT64_C(0x00046FFF5757186A),
          UINT64_C(0x000114066ED84642), UINT64_C(0x0002551CC10C6D4D),
          UINT64_C(0x000402FACD10897C), UINT64_C(0x00015C0E2DCC992B),
          UINT64_C(0x00040E8F0EBF60EE), UINT64_C(0x000060EB6563E9C6),
          UINT64_C(0x0003B809A3126313), UINT64_C(0x00017A66BDC55746)},
         {UINT64_C(0x0009062DED579427), UINT64_C(0x00044A5F128A6E10),
          UINT64_C(0x000151DC6DCB8F89), UINT64_C(0x000141A87B41F52E),
          UINT64_C(0x0000D7A6A002BD72), UINT64_C(0x000E8B9C9303AC1F),
          UINT64_C(0x0001834AD28690AA), UINT64_C(0x00032ADCC504A8B7),
          UINT64_C(0x0000A927B2B2E93B), UINT64_C(0x0002A737885EE993)}},
        {{UINT64_C(0x0006BCF992E8B9F6), UINT64_C(0x00040A05E593A37A),
          UINT64_C(0x0003A56755FA1A2F), UINT64_C(0x0003C89364FAE34E),
          UINT64_C(0x0007E77DBC3D88C6), UINT64_C(0x0002ED2A5FAC8E6E),
          UINT64_C(0x0005FAFA89C46962), UINT64_C(0x0004DBFA31641429),
          UINT64_C(0x0000DB79C8D1176F), UINT64_C(0x00019941D0C3522A)},
         {UINT64_C(0x00041A75E1C8E526), UINT64_C(0x0004C6B783802833),
          UINT64_C(0x0001B562BAFECB1F), UINT64_C(0x0003E09662D4B955),
          UINT64_C(0x00036C04E510554C), UINT64_C(0x000E4C0F87B4805F),
          UINT64_C(0x00073B95C41A7C5A), UINT64_C(0x00010377BD353B8C),
          UINT64_C(0x0000E2A301E84DD8), UINT64_C(0x0004AA08670DB7E8)}},
        {{UINT64_C(0x00056A0D36E91A81), UINT64_C(0x0007AE104EAE22F7),
          UINT64_C(0x000377C28F77E9A6), UINT64_C(0x00077E662A50D752),
          UINT64_C(0x0000806A44DC69B2), UINT64_C(0x0007C6E8FEC3651E),
          UINT64_C(0x0003B809BA19FDFE), UINT64_C(0x0002B748E1AF6B23),
          UINT64_C(0x00013D51330F00A4), UINT64_C(0x000054847211A69E)},
         {UINT64_C(0x00012FB021D29481), UINT64_C(0x0006FA2B27174477),
          UINT64_C(0x0003C6438378319E), UINT64_C(0x0000FFD2B056F1C6),
          UINT64_C(0x0004D77E75145534), UINT64_C(0x00020A7895D994A3),
          UINT64_C(0x0003166E20D7EAB2), UINT64_C(0x0006B6D0CB136A52),
          UINT64_C(0x0002B5C30551AFC3), UINT64_C(0x00068443D6142CD4)}},
        {{UINT64_C(0x000408A9351DFB46), UINT64_C(0x0006B998F97E7968),
          UINT64_C(0x0005B54EB77BAE87), UINT64_C(0x0001D1547584B3F6),
          UINT64_C(0x0000DEC5666F2759), UINT64_C(0x00097223408D9F44),
          UINT64_C(0x0004E4F55A177F66), UINT64_C(0x000008514532470B),
          UINT64_C(0x0000856C14AE04B3), UINT64_C(0x00061CA70F3895B4)},
         {UINT64_C(0x000253C057F4BB69), UINT64_C(0x0001163F0D6F162A),
          UINT64_C(0x00016E781BFFB4F3), UINT64_C(0x0001F13813403F57),
          UINT64_C(0x000720EC959BE2A5), UINT64_C(0x00004CAD26FC8BC3),
          UINT64_C(0x0004430E9FD18B54), UINT64_C(0x000127BC205199CF),
          UINT64_C(0x0006E3D5CCB5D82C), UINT64_C(0x0002C08FFC17839E)}},
        {{UINT64_C(0x00038FAE0545EF38), UINT64_C(0x00053E6BB230EB0F),
          UINT64_C(0x0003612B0393816C), UINT64_C(0x00073B82CB17AA32),
          UINT64_C(0x000164306BE664B8), UINT64_C(0x0007DECB1BEAB083),
          UINT64_C(0x0003ABA14AB6DFEF), UINT64_C(0x0006698C134B72CB),
          UINT64_C(0x00048700868CEFB6), UINT64_C(0x0004DC5186706827)},
         {UINT64_C(0x000D284BA53E67E8), UINT64_C(0x0004F1D7F1CDA504),
          UINT64_C(0x000763E8AAD17850), UINT64_C(0x0003EE3C7D2B43AB),
          UINT64_C(0x0005EDDBD6D373C5), UINT64_C(0x000F6B7396FD7F7F),
          UINT64_C(0x0006367A99D09B8F), UINT64_C(0x0001571A1CD21578),
          UINT64_C(0x0007236B9994F1FA), UINT64_C(0x00062AA7DCD740A8)}},
        {{UINT64_C(0x000895A1FD8F0DA1), UINT64_C(0x0000940D048284D5),
          UINT64_C(0x0007059173020EB7), UINT64_C(0x00034CBCC3643F29),
          UINT64_C(0x00054D38DFC9A9C7), UINT64_C(0x00004D0D54222865),
          UINT64_C(0x0007AC3D3F2E7588), UINT64_C(0x0004BD1D9A8CC40C),
          UINT64_C(0x0004BA573C79363A), UINT64_C(0x0003B77EA3C0F6CE)},
         {UINT64_C(0x0004EA2FC4B8BA7C), UINT64_C(0x0001ADDAEDBD593B),
          UINT64_C(0x0007B6AB6C9FFEBE), UINT64_C(0x000246C34D52441A),
          UINT64_C(0x000664D1C2133D2A), UINT64_C(0x0005A8FCC6F82245),
          UINT64_C(0x0003C821241B7620), UINT64_C(0x0007ABB29F71AC83),
          UINT64_C(0x0000126E955FDD3A), UINT64_C(0x000483EA750D326E)}},
        {{UINT64_C(0x0003FD366EBA1606), UINT64_C(0x0002D9ABAF3B8EC5),
          UINT64_C(0x00011FB79452ADD0), UINT64_C(0x0004D367D2541244),
          UINT64_C(0x00014C5A74A4D2BE), UINT64_C(0x000BD9255862125B),
          UINT64_C(0x00053C3CF655527E), UINT64_C(0x000040AA6D6CB56E),
          UINT64_C(0x0005F328C422C551), UINT64_C(0x000635823C8498F1)},
         {UINT64_C(0x000B8D2832D1E4F0), UINT64_C(0x0002253CC89289E1),
          UINT64_C(0x0004AFE460B4CFA4), UINT64_C(0x00047F33AFB8FB72),
          UINT64_C(0x0003147C7881EF17), UINT64_C(0x000B142D32392AC5),
          UINT64_C(0x0002DB71D8F10037), UINT64_C(0x000445CB1A7CD1AC),
          UINT64_C(0x0005320C19EF8761), UINT64_C(0x0006956661FEB75C)}},
        {{UINT64_C(0x0008A4F6E3E57DAD), UINT64_C(0x00052E3220306CD3),
          UINT64_C(0x00016C04A243039F), UINT64_C(0x0006F0BB18CACDCB),
          UINT64_C(0x000061BCDE864EC1), UINT64_C(0x00029F6788292DC0),
          UINT64_C(0x000022F1DB885727), UINT64_C(0x00058B87F88D42DB),
          UINT64_C(0x00067E1B4B34B7CE), UINT64_C(0x00065DB9E57B9F40)},
         {UINT64_C(0x000DB97A65B73FBC), UINT64_C(0x0005DDAD4615047A),
          UINT64_C(0x0003254BA8C48789), UINT64_C(0x0007BDDF93DDA4BB),
          UINT64_C(0x0002C0DF753CF13C), UINT64_C(0x000F1261EE450629),
          UINT64_C(0x0001AFB00BDE3B73), UINT64_C(0x0007AD40F78FD9B6),
          UINT64_C(0x000275243D6431D9), UINT64_C(0x000670BF2C9CC698)}},
        {{UINT64_C(0x0009312A3CA8CBBC), UINT64_C(0x0000D499C81D0092),
          UINT64_C(0x0001F9D05BE7A579), UINT64_C(0x000262C322C0431E),
          UINT64_C(0x00078231853C844C), UINT64_C(0x00046A359E9EA4F7),
          UINT64_C(0x000490A7B54A0D2C), UINT64_C(0x0005AAE046C3E758),
          UINT64_C(0x00059A6FF1C516DC), UINT64_C(0x0005C2CEC2165D95)},
         {UINT64_C(0x000912BFF9FC238B), UINT64_C(0x0007FEBB522D20DD),
          UINT64_C(0x00070A32C9786B85), UINT64_C(0x0003419D9DCB4F51),
          UINT64_C(0x0006464E7100B7D1), UINT64_C(0x0001B5E3520C4AE3),
          UINT64_C(0x00019B50C7D74FC7), UINT64_C(0x0003ECE80D56DEDC),
          UINT64_C(0x00031A0A04910717), UINT64_C(0x0002DC124F80EA68)}},
    },
    {
        {{UINT64_C(0x0007FC3E471A068B), UINT64_C(0x0001F9C0BD1E7FDA),
          UINT64_C(0x0005B816710E054C), UINT64_C(0x000641A4989CA761),
          UINT64_C(0x0005868FBF10DBFA), UINT64_C(0x000AB68C9F619D52),
          UINT64_C(0x000610CC30529BEC), UINT64_C(0x000627D1E7BB0ABB),
          UINT64_C(0x000312A648EFC13F), UINT64_C(0x000720DB474C9967)},
         {UINT64_C(0x00088A74ECFAC532), UINT64_C(0x0000CA6C465E54E3),
          UINT64_C(0x00063BCCC230DDCA), UINT64_C(0x000545133A54D8A3),
          UINT64_C(0x000289A2A21D7DAD), UINT64_C(0x00064142FD2154C0),
          UINT64_C(0x0000AE8DE8498437), UINT64_C(0x0000FEE6A05C9CA4),
          UINT64_C(0x0005A712CADD4BD3), UINT64_C(0x00073C7C0CB9DC7E)}},
        {{UINT64_C(0x00014BC20D8FC866), UINT64_C(0x0001B713C72B026C),
          UINT64_C(0x0002BB1B00DD97B0), UINT64_C(0x0003DDF6D5D77C14),
          UINT64_C(0x0000018D34DBE288), UINT64_C(0x000B37E4BE21CFC1),
          UINT64_C(0x00042460ABD75619), UINT64_C(0x00048564EF06DBBE),
          UINT64_C(0x0001D0F8F700CFDF), UINT64_C(0x00050BF2E57EF201)},
         {UINT64_C(0x0000E7551324C838), UINT64_C(0x00013E348DFFE7EF),
          UINT64_C(0x0005667611C90CF1), UINT64_C(0x00054F8E74F0FE54),
          UINT64_C(0x00046065CFEC47E4), UINT64_C(0x00020F5CA7131E31),
          UINT64_C(0x00056BCD632BBD22), UINT64_C(0x0004068611AE97FE),
          UINT64_C(0x000342E9BF1AE60D), UINT64_C(0x00059284EE40F315)}},
        {{UINT64_C(0x000695C423B1830F), UINT64_C(0x000061319340E99D),
          UINT64_C(0x00056EECAD0FDEF4), UINT64_C(0x0001851799B6AF30),
          UINT64_C(0x000574BFEEC6CF78), UINT64_C(0x00090695389CAC68),
          UINT64_C(0x0004AD41B7692D45), UINT64_C(0x00067399705E0A02),
          UINT64_C(0x0004D01C657BFE93), UINT64_C(0x0007AE346F356E78)},
         {UINT64_C(0x0005ED517D1CECA6), UINT64_C(0x0004FA192E057F98),
          UINT64_C(0x00028B4C280516A2), UINT64_C(0x0000F57015483B8B),
          UINT64_C(0x000381A2B0925CBA), UINT64_C(0x0007EC4E45D3BCA9),
          UINT64_C(0x0005E6AE14D94280), UINT64_C(0x00044AA8A233553A),
          UINT64_C(0x000188ECFCF3FD6B), UINT64_C(0x00056CD6831AF6A1)}},
        {{UINT64_C(0x000BAD665FBBA51D), UINT64_C(0x0005CE5627119792),
          UINT64_C(0x000013618EFFC45B), UINT64_C(0x00059C97725250C5),
          UINT64_C(0x00034D2A31C26543), UINT64_C(0x000FC7D8B33901C2),
          UINT64_C(0x0004049BB70B6E8C), UINT64_C(0x000298E4AB70ACB4),
          UINT64_C(0x00024A67CAB12D0F), UINT64_C(0x0000658DD54DD249)},
         {UINT64_C(0x00018A1BE3CECA73), UINT64_C(0x0007CB9EB76F08C8),
          UINT64_C(0x0001B277825030CD), UINT64_C(0x0005EE5C3A83FB88),
          UINT64_C(0x000520DD7C104236), UINT64_C(0x0000B4C8EAC628F4),
          UINT64_C(0x00067414680C3CBD), UINT64_C(0x000634E9A20A30CC),
          UINT64_C(0x0006FCA2CD50A25E), UINT64_C(0x0003207EC54AE849)}},
        {{UINT64_C(0x000A7C2C9FA19751), UINT64_C(0x00032EAC1838C0AE),
          UINT64_C(0x000704308B256AC4), UINT64_C(0x0002462B6C4B26A1),
          UINT64_C(0x0002E3D83A96467F), UINT64_C(0x000FE8591432EB6A),
          UINT64_C(0x0003FD27EAF7B31A), UINT64_C(0x00058F724E26D47B),
          UINT64_C(0x00076136F099E12E), UINT64_C(0x000558F5CDCDEAA6)},
         {UINT64_C(0x0006ED04F333B165), UINT64_C(0x000634F9F9299870),
          UINT64_C(0x0006E7943903D73C), UINT64_C(0x00005689249D8E40),
          UINT64_C(0x00043B4AC0439BF3), UINT64_C(0x000553178FDF6D63),
          UINT64_C(0x000439F7375523D2), UINT64_C(0x0005F10CB0346B4A),
          UINT64_C(0x00004E0AE314DF84), UINT64_C(0x00069471AB5DFADA)}},
        {{UINT64_C(0x0000E9501E9FAFE7), UINT64_C(0x0001ED4A26197388),
          UINT64_C(0x0005CAA03225B2DC), UINT64_C(0x0003498CF6071DD5),
          UINT64_C(0x00002CF8D255A84E), UINT64_C(0x000FA75C0885DE81),
          UINT64_C(0x00030965CE1A47CB), UINT64_C(0x00011FB194A95BB0),
          UINT64_C(0x0004800A95408A73), UINT64_C(0x0002EEA35FCE3212)},
         {UINT64_C(0x00087C5B9DE51934), UINT64_C(0x00036D95402D7411),
          UINT64_C(0x00037FB02C63558B), UINT64_C(0x0006A1232CBC6C08),
          UINT64_C(0x0005C0E468414E24), UINT64_C(0x0007F99C0CCF2D15),
          UINT64_C(0x000094592332F465), UINT64_C(0x0002AB96A524CF72),
          UINT64_C(0x0007E87F1D99C378), UINT64_C(0x0000207DD0DD808E)}},
        {{UINT64_C(0x000ECD9FF97D4931), UINT64_C(0x0001D4B8B850BE44),
          UINT64_C(0x0006C1F7D66BFB33), UINT64_C(0x000286B0E020CE70),
          UINT64_C(0x00057D2D930A9035), UINT64_C(0x000F70CD43EF78D8),
          UINT64_C(0x0005595A2E3FB21C), UINT64_C(0x0002B23212C03281),
          UINT64_C(0x0006BE2A6AB3CEFB), UINT64_C(0x0007B13ACF77F80E)},
         {UINT64_C(0x000CB860BC601AFD), UINT64_C(0x0006ACF4F99A1471),
          UINT64_C(0x0006698A5886492B), UINT64_C(0x000245BF72D02C00),
          UINT64_C(0x00067720650A5EB3), UINT64_C(0x000D9E8B3198D8BE),
          UINT64_C(0x00072728DEA3F720), UINT64_C(0x0000B079DF1DF966),
          UINT64_C(0x000764E77F92B823), UINT64_C(0x00004721437DFB0D)}},
        {{UINT64_C(0x0008C47E3E9972F3), UINT64_C(0x0005F6800BF3F5AC),
          UINT64_C(0x00040B8943EC9A82), UINT64_C(0x00018C3DE68795BC),
          UINT64_C(0x000798ACD9D5C188), UINT64_C(0x000626A89DFFB9C7),
          UINT64_C(0x0000A446A1E585FF), UINT64_C(0x00003F9D6C0F2522),
          UINT64_C(0x00045DA3E3E5843E), UINT64_C(0x0001DF8788F4C149)},
         {UINT64_C(0x00002D1EA1F1D567), UINT64_C(0x0007D2CEB46D5CF9),
          UINT64_C(0x0000AE8762EDBE19), UINT64_C(0x0004D34041C698A3),
          UINT64_C(0x0002249A52FB7AFB), UINT64_C(0x0001AA28A184F6D0),
          UINT64_C(0x0004AEDC54AC0233), UINT64_C(0x0001A52FA2FE3789),
          UINT64_C(0x000684CDB10852C6), UINT64_C(0x000006A488535FB8)}},
        {{UINT64_C(0x000B69CD208922BD), UINT64_C(0x000113C0A2CDC098),
          UINT64_C(0x00034EB1527C9342), UINT64_C(0x0002E33524A72273),
          UINT64_C(0x0005D54F4B29D1BB), UINT64_C(0x000935E2895D6B59),
          UINT64_C(0x00002467FF51247E), UINT64_C(0x00064A19BE2B9B33),
          UINT64_C(0x0000CA9B34B3CC48), UINT64_C(0x0001C1179DC502AF)},
         {UINT64_C(0x00030DD196A35DEC), UINT64_C(0x0004F43012319797),
          UINT64_C(0x0003AD2F85C0A8FE), UINT64_C(0x000767B8C3625127),
          UINT64_C(0x0007156D91446AF4), UINT64_C(0x000A52B80B684D9E),
          UINT64_C(0x000493C29A3C9396), UINT64_C(0x00060B66E8B18710),
          UINT64_C(0x00073CE5C6E23F4E), UINT64_C(0x0000C0E9CF09DBEA)}},
        {{UINT64_C(0x000D847204E88E6A), UINT64_C(0x00014392C2DBD5D4),
          UINT64_C(0x0003647F5392D642), UINT64_C(0x00005CD6B4397528),
          UINT64_C(0x0003CA804BE0E6E6), UINT64_C(0x000AFA2DEBF9BDF0),
          UINT64_C(0x0003B70844F7F77A), UINT64_C(0x00055FD54AED8423),
          UINT64_C(0x0001E87463CB4E23), UINT64_C(0x0001BCB9D95AA334)},
         {UINT64_C(0x0008AD95903A42F5), UINT64_C(0x0002B77C076B1514),
          UINT64_C(0x00004EA8D39728A1), UINT64_C(0x00006196D1EAC34C),
          UINT64_C(0x00021AD5CD908FB5), UINT64_C(0x0009231E8FBDFA13),
          UINT64_C(0x0006F53F72D12265), UINT64_C(0x0004EEB89634BD92),
          UINT64_C(0x000467E16722B0C0), UINT64_C(0x000322B4828C8354)}},
        {{UINT64_C(0x000749D2D2151628), UINT64_C(0x00017DB343621D73),
          UINT64_C(0x000165CD9CF505C3), UINT64_C(0x0006EF002B6F7508),
          UINT64_C(0x0006A5B3F2EBD640), UINT64_C(0x00088918A6F47361),
          UINT64_C(0x00024A4CC1F89F3D), UINT64_C(0x0002A883A0915ACB),
          UINT64_C(0x0000B430E4311864), UINT64_C(0x0002E5AFD5631755)},
         {UINT64_C(0x000E6600C23AF414), UINT64_C(0x0004A68A06127530),
          UINT64_C(0x0000119CF5DBEFF9), UINT64_C(0x00031BD59339EC9D),
          UINT64_C(0x0007AFB0A0652755), UINT64_C(0x0004E54D473D5D91),
          UINT64_C(0x0006663BBC911425), UINT64_C(0x00060CD99F4A6814),
          UINT64_C(0x0004D70E317492DC), UINT64_C(0x00057C676F34207B)}},
        {{UINT64_C(0x000FA45FEB394F79), UINT64_C(0x0002595780239750),
          UINT64_C(0x0006DAEAFB6AF370), UINT64_C(0x0004F71BE680332B),
          UINT64_C(0x0007A2B88BEC444F), UINT64_C(0x0006D282845556D8),
          UINT64_C(0x0003A48753C8FEB2), UINT64_C(0x0005314A5E71A50D),
          UINT64_C(0x00064B67D3BEDF37), UINT64_C(0x00049BB87F9AA6E0)},
         {UINT64_C(0x000F9E3C83D99F56), UINT64_C(0x0002AFD6DA547B1C),
          UINT64_C(0x000799EBA75D7647), UINT64_C(0x00017702967C6572),
          UINT64_C(0x00036DAA4C258B87), UINT64_C(0x0005BAA7744D42CE),
          UINT64_C(0x0006706FA16409C8), UINT64_C(0x0003833BD25E3852),
          UINT64_C(0x0005B9B25E71D72C), UINT64_C(0x0000851A32EE02B9)}},
        {{UINT64_C(0x00096C7F5422B60A), UINT64_C(0x0000A451DBBE6CC7),
          UINT64_C(0x0004DFB70D71B03F), UINT64_C(0x00047A85B6A73205),
          UINT64_C(0x000552D4E655E4A4), UINT64_C(0x00026F31F95A9399),
          UINT64_C(0x0001C446539B5383), UINT64_C(0x000544DB6B46DF8B),
          UINT64_C(0x0003348ADD036467), UINT64_C(0x0000AA2D0D6935D7)},
         {UINT64_C(0x0007D5B7A1E58219), UINT64_C(0x0004617A5AB605AC),
          UINT64_C(0x0006A6AF7E81B995), UINT64_C(0x00042EE78EACBEE0),
          UINT64_C(0x00049DD85014D117), UINT64_C(0x0009591FD9314E76),
          UINT64_C(0x0005DB569F458EB8), UINT64_C(0x00051D4F2503D183),
          UINT64_C(0x00063FBB28BA6AD3), UINT64_C(0x0006D3AC67CC821C)}},
        {{UINT64_C(0x000DB3F243061D75), UINT64_C(0x0006D73931E621F2),
          UINT64_C(0x0000B17170E27A4D), UINT64_C(0x00004483B525B3B3),
          UINT64_C(0x0000CEC6BF188345), UINT64_C(0x00028C93F5247B6F),
          UINT64_C(0x0004A6511A5DEF06), UINT64_C(0x00076B62AEAC63B1),
          UINT64_C(0x00074A604ED95C71), UINT64_C(0x00009EFCC184826A)},
         {UINT64_C(0x0008BAC2B060443D), UINT64_C(0x000344E9D3B2EEA9),
          UINT64_C(0x00020435D407DCEB), UINT64_C(0x00022E3643D85699),
          UINT64_C(0x0001A1F508400E9C), UINT64_C(0x000D7CC9B1AC0494),
          UINT64_C(0x0004C1AD9E2EB052), UINT64_C(0x00009FBD9B150459),
          UINT64_C(0x000369468497704F), UINT64_C(0x0003FF2AC90D8014)}},
        {{UINT64_C(0x000F26B79E392352), UINT64_C(0x0002B957BF938557),
          UINT64_C(0x000715D0978BD2B2), UINT64_C(0x00045531E667D86D),
          UINT64_C(0x00038962FCA00EDE), UINT64_C(0x000DC1791F176B3F),
          UINT64_C(0x000743403651C9FA), UINT64_C(0x0004ABD020A84523),
          UINT64_C(0x0006DECB17845C69), UINT64_C(0x0003DF12469D37F5)},
         {UINT64_C(0x000FA8419C8A9D27), UINT64_C(0x000768869058EE8E),
          UINT64_C(0x0000D174A1CB1143), UINT64_C(0x00070F67326B9037),
          UINT64_C(0x00026979FA59E935), UINT64_C(0x000F4AA12B6BC96F),
          UINT64_C(0x000606751117A342), UINT64_C(0x00047A115AF10FB7),
          UINT64_C(0x0006DF7816619F79), UINT64_C(0x00072158DA5671BF)}},
        {{UINT64_C(0x000ECAFE87CBB23D), UINT64_C(0x000512A524D4D77C),
          UINT64_C(0x0005FF1AF3F9CDCC), UINT64_C(0x0005A5222E7CCBCA),
          UINT64_C(0x00037F25D366C5D3), UINT64_C(0x000DEE9CD4A0BD44),
          UINT64_C(0x0001BA906B38FE5F), UINT64_C(0x0002479A4422043C),
          UINT64_C(0x0007F85530950F05), UINT64_C(0x00026843F9CA979A)},
         {UINT64_C(0x000E6EBFB1D7D79A), UINT64_C(0x0001962262421C26),
          UINT64_C(0x000749C75E0896B7), UINT64_C(0x00072656E0591FB4),
          UINT64_C(0x00048C25570B4B5D), UINT64_C(0x000C0F6689F57006),
          UINT64_C(0x000106B77BE98B19), UINT64_C(0x00070FD9ADA250C6),
          UINT64_C(0x0004B2AC835CA2CF), UINT64_C(0x0005FD38C57539D3)}},
    },
    {
        {{UINT64_C(0x00078CF823118058), UINT64_C(0x000084E70B90249E),
          UINT64_C(0x000340E63640803E), UINT64_C(0x000259F3BA46031B),
          UINT64_C(0x0004025A533D8FB6), UINT64_C(0x00021525975D8B46),
          UINT64_C(0x00016415CB875BF3), UINT64_C(0x00037D3C94CF88C2),
          UINT64_C(0x0001303423D046C3), UINT64_C(0x00064D6CA6CF50E4)},
         {UINT64_C(0x0001C4F51365236C), UINT64_C(0x00074C650114C6D7),
          UINT64_C(0x00030B74EB231DBC), UINT64_C(0x000108DDE7A79F07),
          UINT64_C(0x0005C84883DAAC53), UINT64_C(0x000F4FFFB87D65C4),
          UINT64_C(0x0003A077D6424776), UINT64_C(0x00074EF17A8FF930),
          UINT64_C(0x0001C70531DAACC1), UINT64_C(0x0004FDAB70943349)}},
        {{UINT64_C(0x000D10852C9532B6), UINT64_C(0x000043AAC71DC676),
          UINT64_C(0x0000699B3F568856), UINT64_C(0x00062AA64E24D6D0),
          UINT64_C(0x0000AC30CB5E809D), UINT64_C(0x0003DF891FADF9D0),
          UINT64_C(0x0002E8AEFD6E009D), UINT64_C(0x000763BB5C596056),
          UINT64_C(0x00027648417EC3B3), UINT64_C(0x00026FFF568DBEC6)},
         {UINT64_C(0x00046866CD52C51B), UINT64_C(0x00074EBD129DAF5E),
          UINT64_C(0x0007E8A44CB2D0FF), UINT64_C(0x0001754AF2E0C3E1),
          UINT64_C(0x00075DF74CCBA4EB), UINT64_C(0x0007015D1AC6F756),
          UINT64_C(0x0007CC58CB459B84), UINT64_C(0x0004431C9AFC9478),
          UINT64_C(0x0001496EF18E492E), UINT64_C(0x00040F52B9782D09)}},
        {{UINT64_C(0x0005432D2ABFAEFB), UINT64_C(0x000219E9F74B6891),
          UINT64_C(0x000772FBB5A56EDD), UINT64_C(0x0003F9B32B854A6E),
          UINT64_C(0x0000E23A82F7F4DB), UINT64_C(0x00079910F350CA56),
          UINT64_C(0x0002F2CBD94634FD), UINT64_C(0x00062DE8463F621C),
          UINT64_C(0x00018A84A27F47AC), UINT64_C(0x000492918B0A6CFC)},
         {UINT64_C(0x000917028ABF0C6C), UINT64_C(0x0005885BCB7EC09C),
          UINT64_C(0x00007B7029F86047), UINT64_C(0x0004E980E40CB14D),
          UINT64_C(0x0002414620471CAF), UINT64_C(0x000638833F454BE0),
          UINT64_C(0x0007530E1D810E0C), UINT64_C(0x00007BC1509E4C84),
          UINT64_C(0x000234FE03106A25), UINT64_C(0x0007B3C1744922CE)}},
        {{UINT64_C(0x0001D6F26560D816), UINT64_C(0x000761F53B7DED62),
          UINT64_C(0x0003F63729C380A1), UINT64_C(0x0000D9AABEB1F8E4),
          UINT64_C(0x0002FC799030E923), UINT64_C(0x00090EB9E83FC112),
          UINT64_C(0x000276A6C7B64189), UINT64_C(0x0005C92C57117936),
          UINT64_C(0x0003A76769F60AB1), UINT64_C(0x0000214C6BFF3AB2)},
         {UINT64_C(0x000F91FA223FB871), UINT64_C(0x00072F8E905BA3A7),
          UINT64_C(0x00054D9829B0E1C4), UINT64_C(0x000041AADCD2F042),
          UINT64_C(0x0006B33B8DBF5DAC), UINT64_C(0x0005E138CA79ABDB),
          UINT64_C(0x0007F91015FD64B0), UINT64_C(0x0003E42D44B48D18),
          UINT64_C(0x0003070F61FC98CE), UINT64_C(0x0003ECFBC333B9A7)}},
        {{UINT64_C(0x000A1C5F63F4003A), UINT64_C(0x00073E65E07CAEF9),
          UINT64_C(0x0007EE53E05454BD), UINT64_C(0x0002832BB0CB8A80),
          UINT64_C(0x0007F92B5F28C3C9), UINT64_C(0x000B198CFA188FC6),
          UINT64_C(0x0001B4972BD5EA15), UINT64_C(0x0003371055BFF265),
          UINT64_C(0x00040289DB496278), UINT64_C(0x000037FB8AEF99C7)},
         {UINT64_C(0x0003E8BA240F2657), UINT64_C(0x000507715E41F403),
          UINT64_C(0x00000AC5E34F938B), UINT64_C(0x00010AC246A10935),
          UINT64_C(0x00035E92D9586CD7), UINT64_C(0x000A927B7C112162),
          UINT64_C(0x0001E320A6A23B35), UINT64_C(0x0002AEA76305FB4D),
          UINT64_C(0x00027FC7B4E55E7B), UINT64_C(0x0007F605FDDB3012)}},
        {{UINT64_C(0x0007B3BEE04C4C80), UINT64_C(0x0005EC1698F3E6D0),
          UINT64_C(0x00058683E8514BF8), UINT64_C(0x00003490978C1C15),
          UINT64_C(0x0003FD63AD3797AF), UINT64_C(0x00078C4971CAD19E),
          UINT64_C(0x0006E7EC2A846823), UINT64_C(0x00077586A76BAADD),
          UINT64_C(0x00022BF1CA7743E1), UINT64_C(0x000719DBF8CE1E82)},
         {UINT64_C(0x000E187887A1EB86), UINT64_C(0x0006E15CE17F34FE),
          UINT64_C(0x000165A9C070F6B8), UINT64_C(0x000235BE0B50B7A1),
          UINT64_C(0x0000701631632860), UINT64_C(0x0001520CD1B97E69),
          UINT64_C(0x000324D126195433), UINT64_C(0x000695BD1FBD3083),
          UINT64_C(0x0007D0E98F84E4E6), UINT64_C(0x000076D0FD61BE2C)}},
        {{UINT64_C(0x0001C135C074F082), UINT64_C(0x0001B1C98964C70E),
          UINT64_C(0x00070F16F51C63DE), UINT64_C(0x00065C546121FD21),
          UINT64_C(0x0006E0EA00711AC1), UINT64_C(0x00019C4ED64CA43A),
          UINT64_C(0x0007B5F5DE4D83CD), UINT64_C(0x0004A3289E196D3B),
          UINT64_C(0x000379BD42718428), UINT64_C(0x00028B586AD8AC43)},
         {UINT64_C(0x00081CF90B74F2A0), UINT64_C(0x0002D685FCE339CF),
          UINT64_C(0x00029BACF289048F), UINT64_C(0x00031B11C9F022B9),
          UINT64_C(0x000723747A599137), UINT64_C(0x00008CAE4A9C10E7),
          UINT64_C(0x000252D22A179598), UINT64_C(0x000462BF1945C2A5),
          UINT64_C(0x0005E7BF4B6F8B7E), UINT64_C(0x0004A5CC544E7A94)}},
        {{UINT64_C(0x0002CE082C195DF7), UINT64_C(0x0000B2902F1DD4F4),
          UINT64_C(0x0002EBCE1E8E6C3E), UINT64_C(0x0003DBB93DD984FC),
          UINT64_C(0x000294BCFA46D91A), UINT64_C(0x000E47F5EB6C49F2),
          UINT64_C(0x00027D01A275F685), UINT64_C(0x0002A8AB31F7A7C5),
          UINT64_C(0x000065DEDCCEB9FE), UINT64_C(0x0007EE40D2F05D3F)},
         {UINT64_C(0x000AA9F92E841F87), UINT64_C(0x00025B8A866BCAA0),
          UINT64_C(0x000456616AD0616E), UINT64_C(0x000019C95CBF2929),
          UINT64_C(0x00018B84E8563743), UINT64_C(0x000D9BBA3F123075),
          UINT64_C(0x0003C88C52754F28), UINT64_C(0x0002A84A28E16C62),
          UINT64_C(0x00006C4CBF9BD1BE), UINT64_C(0x00014E2ED761883C)}},
        {{UINT64_C(0x000DD43327A5EC62), UINT64_C(0x00037A88C2CE8F10),
          UINT64_C(0x00079FB7AF273687), UINT64_C(0x0005C217AE2F9294),
          UINT64_C(0x0007B658E58E2D4D), UINT64_C(0x0001B9F8E201BDE2),
          UINT64_C(0x00003AF8B1C4F58C), UINT64_C(0x000023F0302D4943),
          UINT64_C(0x0000F016949D42FE), UINT64_C(0x0005DA77793E30DF)},
         {UINT64_C(0x0009A4A03292A077), UINT64_C(0x0005E38597159B13),
          UINT64_C(0x000438CD4AA3B94B), UINT64_C(0x00039E50FBBA527D),
          UINT64_C(0x00032E5CFA99121B), UINT64_C(0x000CE6179D42746B),
          UINT64_C(0x000201FC90B2780E), UINT64_C(0x0002129922687B60),
          UINT64_C(0x0001410E58988022), UINT64_C(0x0005E3F21AE57B91)}},
        {{UINT64_C(0x000EE44D178CCA07), UINT64_C(0x0002290775707084),
          UINT64_C(0x000256E01D88B556), UINT64_C(0x0001EF98ED0CEE11),
          UINT64_C(0x0003BD6824481F73), UINT64_C(0x000BAAFD1FEBD7AB),
          UINT64_C(0x0006C5370AC07A93), UINT64_C(0x00039FFED4B7C601),
          UINT64_C(0x00039A6B4153D857), UINT64_C(0x00077A6BC55E5234)},
         {UINT64_C(0x000816AA9A09968B), UINT64_C(0x0007BDB9C7F2EAF9),
          UINT64_C(0x00032ACE09E1CBDC), UINT64_C(0x000522E8C19D3EEB),
          UINT64_C(0x0003827A069B97BD), UINT64_C(0x0006716F9981A71A),
          UINT64_C(0x000554503B7BA012), UINT64_C(0x000074637BF2E394),
          UINT64_C(0x000615A2194548E8), UINT64_C(0x000006C523A794B4)}},
        {{UINT64_C(0x000A0B318735C445), UINT64_C(0x00055C3BC1A59729),
          UINT64_C(0x000355C87CF06A80), UINT64_C(0x0000ABBB95628B32),
          UINT64_C(0x00073A2D28549A3A), UINT64_C(0x000CC8F16C0B5FB6),
          UINT64_C(0x0005190FEF2C780C), UINT64_C(0x000485C8686725FF),
          UINT64_C(0x000212610F06DB7C), UINT64_C(0x000186C78ED4F0AC)},
         {UINT64_C(0x00051A0699ABFB29), UINT64_C(0x0004079D38322CB8),
          UINT64_C(0x0004E0C463922EE4), UINT64_C(0x0005EC25735A7F4C),
          UINT64_C(0x00030ACD8B3755D5), UINT64_C(0x0004533C09F622E8),
          UINT64_C(0x00065BD64578113C), UINT64_C(0x000011679C79532B),
          UINT64_C(0x000270C486D96F98), UINT64_C(0x00064FCDA161257D)}},
        {{UINT64_C(0x000A95E15137A104), UINT64_C(0x000184008DF11135),
          UINT64_C(0x00005609A6FCBD2E), UINT64_C(0x0004EDFE7BC6F8F9),
          UINT64_C(0x00053CA3D1760E75), UINT64_C(0x000EA2FB5A31F0F3),
          UINT64_C(0x00077ABE20D50F91), UINT64_C(0x0007C0E34B46F175),
          UINT64_C(0x0007A94E7592DB90), UINT64_C(0x000249BEAED5FC42)},
         {UINT64_C(0x000F85AF26A73A5A), UINT64_C(0x0002B83D21F3C411),
          UINT64_C(0x000069FD92DFF608), UINT64_C(0x000407178D3E9436),
          UINT64_C(0x0000D6C1A603C407), UINT64_C(0x000C556CBD53BF39),
          UINT64_C(0x0000802C8ABE0ADC), UINT64_C(0x00024A5E6F60B0DA),
          UINT64_C(0x0007DB9843929DA3), UINT64_C(0x0001FF410E9D19C7)}},
        {{UINT64_C(0x00094E812DBE8C32), UINT64_C(0x0006D33ED80BCDA2),
          UINT64_C(0x00002D936BC7580C), UINT64_C(0x00043D349744E6D4),
          UINT64_C(0x00020A0DEB1F77B4), UINT64_C(0x00031B3519BBF1AA),
          UINT64_C(0x0007A520ED4CEF61), UINT64_C(0x000043394E7A87E8),
          UINT64_C(0x00040764584AEB95), UINT64_C(0x0003155C9B8CCF57)},
         {UINT64_C(0x000C17DA9E28ADF8), UINT64_C(0x0003424BBFF78B37),
          UINT64_C(0x0003CC6A19FFC5FF), UINT64_C(0x0002CB497A44C566),
          UINT64_C(0x00022DDAD26DE223), UINT64_C(0x000AC080F18A0065),
          UINT64_C(0x000575057C11015D), UINT64_C(0x00078021729DE91B),
          UINT64_C(0x0005796ED9E76DA3), UINT64_C(0x0006FE4AB6E74734)}},
        {{UINT64_C(0x0005F849D235CCE0), UINT64_C(0x000436E70A0D70E1),
          UINT64_C(0x00035E68AA2BDD02), UINT64_C(0x0003E7FE63874EA2),
          UINT64_C(0x00026C88F7884563), UINT64_C(0x000FCD9BAE21D5B1),
          UINT64_C(0x0005C69101494E3A), UINT64_C(0x00037DB907EEE3A2),
          UINT64_C(0x00064C59AE199A08), UINT64_C(0x00039423CE12F5BB)},
         {UINT64_C(0x0000AAAF7EEE09F7), UINT64_C(0x0004C5314B2C4D75),
          UINT64_C(0x0003EC74B3A6D36C), UINT64_C(0x000620CA51245767),
          UINT64_C(0x00044F419AE83224), UINT64_C(0x00080A722E02A693),
          UINT64_C(0x0007A360EBC5DBD9), UINT64_C(0x000381727BCF6E58),
          UINT64_C(0x000617B700F3ADF6), UINT64_C(0x0000FA1A09F64950)}},
        {{UINT64_C(0x00096F84C0BDFF5B), UINT64_C(0x0006E5B26C5065BB),
          UINT64_C(0x0001952942E39562), UINT64_C(0x000653E9892230FF),
          UINT64_C(0x0000F763C13E4999), UINT64_C(0x0009F0784B215E56),
          UINT64_C(0x000270D42201B3A3), UINT64_C(0x00045740B9AF7F09),
          UINT64_C(0x000229B251B5D908), UINT64_C(0x000657F560FDA230)},
         {UINT64_C(0x00031EFD1B4B981B), UINT64_C(0x0007B1F5B3F7B1EA),
          UINT64_C(0x000170AF323B8DC9), UINT64_C(0x00055F77521B9F83),
          UINT64_C(0x0003B381A7CCCC0F), UINT64_C(0x00086767112D35DD),
          UINT64_C(0x0000C15A5CC603CB), UINT64_C(0x00026C0095FA28DE),
          UINT64_C(0x0005178C03D1D4CC), UINT64_C(0x0006A499CD28196A)}},
        {{UINT64_C(0x0009617A9ECA8281), UINT64_C(0x0002F03DC8FC403F),
          UINT64_C(0x0005A200AB22733A), UINT64_C(0x000402BA3A81D989),
          UINT64_C(0x0006690A4DAA9371), UINT64_C(0x0001CC8F6D90CC2C),
          UINT64_C(0x000293AC50B59125), UINT64_C(0x0004D1A882B9D469),
          UINT64_C(0x00014C4DF2707168), UINT64_C(0x0005A3C384944E0D)},
         {UINT64_C(0x000B2CD4D51F74FF), UINT64_C(0x00021EB289F478F1),
          UINT64_C(0x0004BF9CA3A7AC0A), UINT64_C(0x0003DB4F626C2310),
          UINT64_C(0x0005CBF13B00CCC4), UINT64_C(0x00029073A697E0B9),
          UINT64_C(0x0002C5D67FD6CD73), UINT64_C(0x0005D10BAA363615),
          UINT64_C(0x000051A608EA619E), UINT64_C(0x0004155A6B02D3FB)}},
    },
    {
        {{UINT64_C(0x000B63BE2E2471B6), UINT64_C(0x000793F7C56B8C12),
          UINT64_C(0x00003A61A28C6343), UINT64_C(0x00073E8EF4E8B82C),
          UINT64_C(0x000770A1A8474CE7), UINT64_C(0x000B2231CECAFDB4),
          UINT64_C(0x0006E5A738D66F01), UINT64_C(0x0002489688C31B78),
          UINT64_C(0x00060068F8F76B83), UINT64_C(0x0003D6F5D74A6F06)},
         {UINT64_C(0x0002EEDB0339BF8A), UINT64_C(0x0006213ECE2A8CBB),
          UINT64_C(0x0006876AC31EC71D), UINT64_C(0x0001ADFE07733CDB),
          UINT64_C(0x000192FE0B2619CE), UINT64_C(0x00000B3F7CB6D64F),
          UINT64_C(0x000193DD7BC97D28), UINT64_C(0x0005572F38C9E619),
          UINT64_C(0x000117122583880C), UINT64_C(0x0003F2E95F7AD5BD)}},
        {{UINT64_C(0x0005C60618A27AB4), UINT64_C(0x00041A118681EEDE),
          UINT64_C(0x000264B9365ED5C1), UINT64_C(0x000257E09A79B510),
          UINT64_C(0x0007087B4DFA9B18), UINT64_C(0x000BC4BD3F5B7665),
          UINT64_C(0x00047988ECDAA2B4), UINT64_C(0x00038D5A0D231327),
          UINT64_C(0x00061EBA028CB516), UINT64_C(0x00034DFCB32D1C33)},
         {UINT64_C(0x0007BF2B53E6F733), UINT64_C(0x0007363F62FE6A5D),
          UINT64_C(0x00009E88E9E4BBC7), UINT64_C(0x00053137DF685DF0),
          UINT64_C(0x0000D26EEFA89EB2), UINT64_C(0x00060E84ECFF317A),
          UINT64_C(0x000562FC49406706), UINT64_C(0x0004010FC39B719E),
          UINT64_C(0x00059BF4CE26C533), UINT64_C(0x00016B0A194ADE86)}},
        {{UINT64_C(0x00025D428CB55AB4), UINT64_C(0x000349C469FB2C47),
          UINT64_C(0x00011112758D3875), UINT64_C(0x0005BBB75049ADD3),
          UINT64_C(0x00013E42E4FC95BB), UINT64_C(0x00063D2C733F5E50),
          UINT64_C(0x00071ECB0DB2E6CD), UINT64_C(0x00047F5C9C428E03),
          UINT64_C(0x0000C8ACA14009B2), UINT64_C(0x0000FEBA85C091ED)},
         {UINT64_C(0x000319368C78D149), UINT64_C(0x0000A97A3731C17E),
          UINT64_C(0x0005734AA19A7BF7), UINT64_C(0x0004110947FCD175),
          UINT64_C(0x00027E988A2F1542), UINT64_C(0x0001405032878E0A),
          UINT64_C(0x00035BAF2C56A5E2), UINT64_C(0x000539BA8560A8C0),
          UINT64_C(0x0006BE84D2118DA9), UINT64_C(0x0005E0476ABA3F5B)}},
        {{UINT64_C(0x0003AA4CC1DD3F97), UINT64_C(0x00063185FB6A0D5E),
          UINT64_C(0x0007EAE973FA7134), UINT64_C(0x0000D566EB4BA56E),
          UINT64_C(0x000432A20DAAF7BF), UINT64_C(0x000C99D6D0DE97D6),
          UINT64_C(0x00040CD8D71B4231), UINT64_C(0x00061DBA01336D9F),
          UINT64_C(0x00010DC031C5661D), UINT64_C(0x0007DBFCC3C94CE7)},
         {UINT64_C(0x00092DCF6D493BCC), UINT64_C(0x00008741DFAF5D31),
          UINT64_C(0x0002E2A67554DF10), UINT64_C(0x0005119B1E5ADE23),
          UINT64_C(0x000501601DB80686), UINT64_C(0x00016AF164683AA7),
          UINT64_C(0x00013250FB11AA12), UINT64_C(0x00070A10DFF37326),
          UINT64_C(0x0000F9D812FF4EAB), UINT64_C(0x00002035714DCE83)}},
        {{UINT64_C(0x0007CA219AED5320), UINT64_C(0x0000DC5D44C110A5),
          UINT64_C(0x000211982529953C), UINT64_C(0x000330BE049F485C),
          UINT64_C(0x0006B006A9948E28), UINT64_C(0x0000B04E018D4DC0),
          UINT64_C(0x000215F49B9F8FF2), UINT64_C(0x00079CE3A3D8E522),
          UINT64_C(0x0006EDC3EA4A4987), UINT64_C(0x0006F9FD6811BC4F)},
         {UINT64_C(0x000FEF3CB3BE843C), UINT64_C(0x0005B9E17892CE3D),
          UINT64_C(0x0005168AA844E7A9), UINT64_C(0x000600B2314595D6),
          UINT64_C(0x000477B0AFD0F4F6), UINT64_C(0x00053D8F4E812FCD),
          UINT64_C(0x00049909798B2B0F), UINT64_C(0x0000B0BD698B1D5E),
          UINT64_C(0x000009B704E143DF), UINT64_C(0x00043C8ABB658E21)}},
        {{UINT64_C(0x0009311B2D0959AA), UINT64_C(0x000408C67EBE4373),
          UINT64_C(0x0004708398C93D1C), UINT64_C(0x0005CEEB3BA4DF18),
          UINT64_C(0x00059663D0C68975), UINT64_C(0x000D6F23DB87CD7A),
          UINT64_C(0x0007FE452E537133), UINT64_C(0x000067D1FF579E76),
          UINT64_C(0x000678700E4625F3), UINT64_C(0x000512B5A1BD51F9)},
         {UINT64_C(0x000E28A401845C37), UINT64_C(0x0005334538459412),
          UINT64_C(0x000415EEBEE74BD9), UINT64_C(0x00014AFBBC227A22),
          UINT64_C(0x000214A015E7D9E7), UINT64_C(0x000139325A047952),
          UINT64_C(0x00029504D6930EAE), UINT64_C(0x0005D1BCA17818E8),
          UINT64_C(0x0002DD22238F7A8E), UINT64_C(0x0004F8349B5B0ED3)}},
        {{UINT64_C(0x00034C0AE7DDF681), UINT64_C(0x0007688311AB02D5),
          UINT64_C(0x0002EB0E8A6E1F1D), UINT64_C(0x0005FF8BCF6AAEB8),
          UINT64_C(0x0002CAD1E56904C4), UINT64_C(0x000FA16935A53E47),
          UINT64_C(0x00002881197DC9DD), UINT64_C(0x0005C925AAAF6DA8),
          UINT64_C(0x0006034B84FE7D23), UINT64_C(0x0005D6AE622F2E8E)},
         {UINT64_C(0x00065068FCC0ACD6), UINT64_C(0x000070B371C8C2DF),
          UINT64_C(0x0003DA0FCB5BFD98), UINT64_C(0x0005B4F3426521A8),
          UINT64_C(0x000689F815FC00FE), UINT64_C(0x0002E666CEEBA0E2),
          UINT64_C(0x0001E39832C0990E), UINT64_C(0x000574558F79940A),
          UINT64_C(0x00076D485F8B12D9), UINT64_C(0x000156F30CEE05D5)}},
        {{UINT64_C(0x0007D87AFB920C3D), UINT64_C(0x0002A9E23A083533),
          UINT64_C(0x0001543E5ED3B5D9), UINT64_C(0x0000B974928CFC56),
          UINT64_C(0x0002CF48F5FC7EE6), UINT64_C(0x000CE1C3C95C8368),
          UINT64_C(0x000333FD6C3D7D3F), UINT64_C(0x00044589E3099078),
          UINT64_C(0x0001F34D2E96B01D), UINT64_C(0x00017EAC450F370E)},
         {UINT64_C(0x0001B2713A497273), UINT64_C(0x00030B002E865A54),
          UINT64_C(0x000182D7C612D473), UINT64_C(0x00026397A5C46946),
          UINT64_C(0x000187CB68D83F11), UINT64_C(0x00077ADF60174A14),
          UINT64_C(0x0002BC33B9BC9135), UINT64_C(0x00036AD6BE31C9F9),
          UINT64_C(0x0001AC5D650B5D13), UINT64_C(0x0003F43A72E4D5E3)}},
        {{UINT64_C(0x000EF6C11E20B6EA), UINT64_C(0x0005905102070C81),
          UINT64_C(0x00024652608509D4), UINT64_C(0x000205B6D7FBB6A0),
          UINT64_C(0x00032589FE0677BD), UINT64_C(0x00085D8055C79F1F),
          UINT64_C(0x00004E43893D83E7), UINT64_C(0x00013EDB219CA7D3),
          UINT64_C(0x0007BF9B35859660), UINT64_C(0x0005DF7DCB816251)},
         {UINT64_C(0x0001EF55471D4356), UINT64_C(0x000540AF79AD9A97),
          UINT64_C(0x00060EB528DDF6D9), UINT64_C(0x000328BCC97D7964),
          UINT64_C(0x000706B99B540A23), UINT64_C(0x0007753141D6BF4E),
          UINT64_C(0x000256E51FDE35B1), UINT64_C(0x0005324363DCFDED),
          UINT64_C(0x0004E0FE9820F921), UINT64_C(0x000368ECFA81C767)}},
        {{UINT64_C(0x000AE3882AC0F8F0), UINT64_C(0x00023952C3BBED16),
          UINT64_C(0x0002208B0CCB771B), UINT64_C(0x00032499978C3D1E),
          UINT64_C(0x0000B08DEF9DE24A), UINT64_C(0x00014733B64362CB),
          UINT64_C(0x00044CEB44FBCD29), UINT64_C(0x00062081D15BFA79),
          UINT64_C(0x000612FF02BEFFD5), UINT64_C(0x00016207454BB815)},
         {UINT64_C(0x000E140447F99D22), UINT64_C(0x0004415B5CE2B9E2),
          UINT64_C(0x000497FECE7E53B5), UINT64_C(0x0003BBA75954C646),
          UINT64_C(0x00075267384AD185), UINT64_C(0x000BE077D1B86BB1),
          UINT64_C(0x0000A186FFAE61F0), UINT64_C(0x0007E20C811F4FAE),
          UINT64_C(0x0004F69AD42F56BF), UINT64_C(0x00006F7B76AEA2AF)}},
        {{UINT64_C(0x000BEDEC2A48D51F), UINT64_C(0x00040C00234C90E7),
          UINT64_C(0x0003BC8777CA6ECC), UINT64_C(0x0000D79570C70B74),
          UINT64_C(0x000157D50E130D10), UINT64_C(0x0003932A1F3A8446),
          UINT64_C(0x000520C248ECB88C), UINT64_C(0x00073A8FF16D17F0),
          UINT64_C(0x0006B070CCE2E887), UINT64_C(0x00006F6D81DF9ECD)},
         {UINT64_C(0x0007C3E53178DAC6), UINT64_C(0x0000802C2D20978A),
          UINT64_C(0x0005CC0D9E0C57C8), UINT64_C(0x0000A2DB47B4AA42),
          UINT64_C(0x0000D0C16DEAE477), UINT64_C(0x00030AECB867C0D4),
          UINT64_C(0x0006545EF5ADABE6), UINT64_C(0x0006207530AC956A),
          UINT64_C(0x0004B667DB2FBFC5), UINT64_C(0x0007231A93C94578)}},
        {{UINT64_C(0x0006EE7B285AAF99), UINT64_C(0x000184C97496A4CA),
          UINT64_C(0x0000E820762561C8), UINT64_C(0x0003069976AB441A),
          UINT64_C(0x0002F2D34AB64E3A), UINT64_C(0x0008DA8798C4984C),
          UINT64_C(0x00018E10EC261ED8), UINT64_C(0x0005572CDE59EF3B),
          UINT64_C(0x0005243583492A31), UINT64_C(0x000553EBD5BD4F76)},
         {UINT64_C(0x00003CD44541889B), UINT64_C(0x0000A15FD3B46A03),
          UINT64_C(0x0002445DDC01C49C), UINT64_C(0x0000FF7AB524990D),
          UINT64_C(0x00067DD44CEF1BC4), UINT64_C(0x00011A6A854E822E),
          UINT64_C(0x00020922345D9089), UINT64_C(0x00004F8BE8B1C52C),
          UINT64_C(0x000334AD5EA9B90D), UINT64_C(0x0004E5FE9C90028A)}},
        {{UINT64_C(0x000068C177996387), UINT64_C(0x000019B13C995F39),
          UINT64_C(0x00065BFEAB3691E1), UINT64_C(0x0003CEAA9FF90919),
          UINT64_C(0x00070CE531ADC5B6), UINT64_C(0x000E2CEBFDBB5331),
          UINT64_C(0x0000D202455F41D3), UINT64_C(0x000671180605FF9D),
          UINT64_C(0x00011AD81B928580), UINT64_C(0x00028FC16864D6F0)},
         {UINT64_C(0x000A61CD60DAEB8D), UINT64_C(0x000365700D8B7834),
          UINT64_C(0x00057BC9FDF724EE), UINT64_C(0x0001F7A1B9F925AF),
          UINT64_C(0x0007AA4AEFCA0359), UINT64_C(0x00034A27F50833A0),
          UINT64_C(0x0000ED7927DFB95D), UINT64_C(0x0007B8F116040DEA),
          UINT64_C(0x000117F98382AC39), UINT64_C(0x00020171F463D451)}},
        {{UINT64_C(0x00059264A9F49C09), UINT64_C(0x00044F0F00815067),
          UINT64_C(0x000151E20E3CE2F3), UINT64_C(0x0003CB10A0F261AA),
          UINT64_C(0x00019DAE7938AAE9), UINT64_C(0x000FA6C983FECF4D),
          UINT64_C(0x0000A4A7CA460046), UINT64_C(0x00069CD684FAA9A3),
          UINT64_C(0x0005962FD31973AC), UINT64_C(0x0001A315E3CE66B5)},
         {UINT64_C(0x0001EE33900F6430), UINT64_C(0x00064BE92C2C1CDD),
          UINT64_C(0x00011FCA5905D7B7), UINT64_C(0x0001664E4C15055D),
          UINT64_C(0x000124F50846C1DD), UINT64_C(0x0005A95B64C89DD6),
          UINT64_C(0x000635C7B470A25B), UINT64_C(0x00044199D92D72BC),
          UINT64_C(0x000317D8CC4D6593), UINT64_C(0x0004A1E8E879471E)}},
        {{UINT64_C(0x00070F53D415523F), UINT64_C(0x00008843EE85FF0C),
          UINT64_C(0x0001E10C523BB14C), UINT64_C(0x0004756E413F0932),
          UINT64_C(0x0003DE85A220DF46), UINT64_C(0x000E272251866340),
          UINT64_C(0x00008C97549ABE3D), UINT64_C(0x0003998C7C359F9D),
          UINT64_C(0x00018EC0C21FA45C), UINT64_C(0x0007A6A308E8E50C)},
         {UINT64_C(0x0002370A35276C0F), UINT64_C(0x0002729B26DBEA22),
          UINT64_C(0x0000D95854453918), UINT64_C(0x0000FEBB57C7378F),
          UINT64_C(0x0002E3F0D283969D), UINT64_C(0x000875CC00175050),
          UINT64_C(0x00050E7B3F62B00A), UINT64_C(0x0006E1A11C5C2BEA),
          UINT64_C(0x0003461785DC962F), UINT64_C(0x00006A29E20D62BD)}},
        {{UINT64_C(0x000537C77DAC5528), UINT64_C(0x00008C1BE92F83C6),
          UINT64_C(0x000611D61F939CC5), UINT64_C(0x00067A47050E3CE6),
          UINT64_C(0x0006FC68EE4297A6), UINT64_C(0x00076CC8299AC1F1),
          UINT64_C(0x000798EF7F4F028F), UINT64_C(0x0003D929F2A08907),
          UINT64_C(0x0007F626DB8181AE), UINT64_C(0x00038C7518A169E3)},
         {UINT64_C(0x0003C2C303DDCFAE), UINT64_C(0x0005A51351AFA1EB),
          UINT64_C(0x00033D8168A6178F), UINT64_C(0x0002BAE4B7BD921A),
          UINT64_C(0x00079BB0E6C13360), UINT64_C(0x0002FEC8223E6E6A),
          UINT64_C(0x00057EB3E02985A1), UINT64_C(0x0006A5F6F23E337D),
          UINT64_C(0x0000B51AD9A8DF7E), UINT64_C(0x0007C85F9D74F60E)}},
    },
    {
        {{UINT64_C(0x000373002424FC6B), UINT64_C(0x000265A533B8CF47),
          UINT64_C(0x00015EAD4A0AE37C), UINT64_C(0x00022EEEA45AEA56),
          UINT64_C(0x0005CA0E0AF3AAE5), UINT64_C(0x000216AD75D115B7),
          UINT64_C(0x0002B2885E63BCC1), UINT64_C(0x00001DEB58FCEA8C),
          UINT64_C(0x00050D28722A0E55), UINT64_C(0x00016C1C97050E66)},
         {UINT64_C(0x000BACBCDEEAFAB6), UINT64_C(0x000210A7858140DE),
          UINT64_C(0x0006E228E5AB34EE), UINT64_C(0x00038068E28B5065),
          UINT64_C(0x0002BDB4015D78E6), UINT64_C(0x000E7DF0E5A47C2C),
          UINT64_C(0x000091791C6E0564), UINT64_C(0x00047E8BA82005E7),
          UINT64_C(0x0002E2976DD2714D), UINT64_C(0x00029F182BE6C8A5)}},
        {{UINT64_C(0x000D83B94CB40D60), UINT64_C(0x000182EE55A47AB2),
          UINT64_C(0x0002A9A2A11F16C0), UINT64_C(0x00050CC737555D01),
          UINT64_C(0x000189A2DA48966B), UINT64_C(0x000A973CE36E61C1),
          UINT64_C(0x0004AF3A17E7233F), UINT64_C(0x00045CB6428ED4F1),
          UINT64_C(0x0001768287382675), UINT64_C(0x0000C6B22C10147C)},
         {UINT64_C(0x000401DB5A4C6A3E), UINT64_C(0x00023EE16B73E10C),
          UINT64_C(0x0002FEA5C8440A34), UINT64_C(0x00018E7129952281),
          UINT64_C(0x0001A31C2F9C5948), UINT64_C(0x0006685938AF9BD8),
          UINT64_C(0x0002F4C9F4721C11), UINT64_C(0x0006D88254B2B220),
          UINT64_C(0x00007BC40460348E), UINT64_C(0x0001773137A2404B)}},
        {{UINT64_C(0x000C6B4D1144D64A), UINT64_C(0x0006D90E0E79B31D),
          UINT64_C(0x00068DA0056E18D5), UINT64_C(0x0005340F7E02D070),
          UINT64_C(0x0001D5DF828F1380), UINT64_C(0x000636F195DCDB2B),
          UINT64_C(0x0000E7E7E014119C), UINT64_C(0x0007B435A9FBE2C0),
          UINT64_C(0x00076EB85EA1EFBB), UINT64_C(0x00022AA0A0C698A1)},
         {UINT64_C(0x000B9CB571CA9CF0), UINT64_C(0x0004B86CE22A5E6D),
          UINT64_C(0x0006E4462F85131B), UINT64_C(0x0002F155E75A2EED),
          UINT64_C(0x00063F764F24AC73), UINT64_C(0x000FFA94474DEF2E),
          UINT64_C(0x0004A1B60F2E7A47), UINT64_C(0x00063EE08D47164B),
          UINT64_C(0x0005ECDC6B2A7E48), UINT64_C(0x00071C6910C71824)}},
        {{UINT64_C(0x0007813E229F97CB), UINT64_C(0x00043ADE3B460997),
          UINT64_C(0x0005E8C96137590A), UINT64_C(0x000484EEC3127431),
          UINT64_C(0x0003A512D58F34EC), UINT64_C(0x000B47722D5ECC77),
          UINT64_C(0x00076E35AE2C410D), UINT64_C(0x000142A4F3860A59),
          UINT64_C(0x0005AD2423E3E88D), UINT64_C(0x00032A4A2C6376BD)},
         {UINT64_C(0x0009DB45FC2C575A), UINT64_C(0x0007CF11E987B02F),
          UINT64_C(0x000329AE7B16D79A), UINT64_C(0x0006BA1FDDBA003F),
          UINT64_C(0x00072F40C3D1D0E1), UINT64_C(0x000A2168272DEAEB),
          UINT64_C(0x00040B3BC5E98BE4), UINT64_C(0x0005426244ED0D94),
          UINT64_C(0x000610D19F336894), UINT64_C(0x0001EC5B0CD24773)}},
        {{UINT64_C(0x000126DC95FF47CB), UINT64_C(0x0006D821C64139FD),
          UINT64_C(0x00036D6653EA637C), UINT64_C(0x0005A97F942DD0FF),
          UINT64_C(0x00000318724B076A), UINT64_C(0x000ED3C1F9BBE805),
          UINT64_C(0x0002E76961D49FCA), UINT64_C(0x000759A40326E7D9),
          UINT64_C(0x0002641EFF076C29), UINT64_C(0x00006CA5347A2017)},
         {UINT64_C(0x00010765B5C69CBC), UINT64_C(0x0001782241147DAD),
          UINT64_C(0x000104E6A5297609), UINT64_C(0x0006495BFD0C4503),
          UINT64_C(0x0006B9D0D10CA297), UINT64_C(0x00034803A8F4A7B8),
          UINT64_C(0x00069B1A0E7F94AF), UINT64_C(0x00076E9131740435),
          UINT64_C(0x00079E1647538E00), UINT64_C(0x000381FB07DCC831)}},
        {{UINT64_C(0x0000623E19A529B0), UINT64_C(0x0002A1F34419A0BA),
          UINT64_C(0x0007450BB7C4CEEC), UINT64_C(0x000724D0766E901A),
          UINT64_C(0x0006FDCF27272EFB), UINT64_C(0x000E99E1E2856702),
          UINT64_C(0x0006AF1B534CF0E7), UINT64_C(0x00024538A8F87630),
          UINT64_C(0x0002DBFF74B7F80D), UINT64_C(0x0006689E4424A84F)},
         {UINT64_C(0x000A25CFDE9D7DDB), UINT64_C(0x00025B06D5477447),
          UINT64_C(0x00040103EF10F2A9), UINT64_C(0x0000589A19B6B3E8),
          UINT64_C(0x0001001736EC3E24), UINT64_C(0x000B77124673C96A),
          UINT64_C(0x00053B0645C3104F), UINT64_C(0x00066AEE9346C15C),
          UINT64_C(0x000336D117178F21), UINT64_C(0x0004C8732602283A)}},
        {{UINT64_C(0x000B072ABBE3BA75), UINT64_C(0x00015A08F89BDB09),
          UINT64_C(0x00034F423F9E09E0), UINT64_C(0x0001EF27A09841EF),
          UINT64_C(0x00065B203436FF75), UINT64_C(0x00018864D568B13F),
          UINT64_C(0x00069449D057FB4C), UINT64_C(0x000005868A6A3CD5),
          UINT64_C(0x0007932D29BB522B), UINT64_C(0x0001069BF48AA2B7)},
         {UINT64_C(0x000EE21FDCDDE7C7), UINT64_C(0x0006CAF6E905C045),
          UINT64_C(0x00031A72930255A6), UINT64_C(0x00076FCF5F4A6F74),
          UINT64_C(0x00001AA0517A0131), UINT64_C(0x00040DDFF2E11FAF),
          UINT64_C(0x0004A5512DFF3F02), UINT64_C(0x00055F08A9212CD2),
          UINT64_C(0x000519761093F184), UINT64_C(0x00027B6A1B2A1EF7)}},
        {{UINT64_C(0x000EA5C61B6DBC4E), UINT64_C(0x00051A4DCC7D6792),
          UINT64_C(0x0003357B7EAF7670), UINT64_C(0x000554E802A50353),
          UINT64_C(0x00072BF41E70B24F), UINT64_C(0x000049E5C8DA1177),
          UINT64_C(0x00037C5CB7FD16BA), UINT64_C(0x0003803F2EEEF15D),
          UINT64_C(0x000146D4B548675B), UINT64_C(0x0000E11A2717E6B2)},
         {UINT64_C(0x000C794070988A0A), UINT64_C(0x0002A32EF7BCEEB5),
          UINT64_C(0x00050C772349C586), UINT64_C(0x0000FA8C6654583D),
          UINT64_C(0x000385E544F610DF), UINT64_C(0x000C27780562C065),
          UINT64_C(0x0004D0E5952E5D7A), UINT64_C(0x00022358D60920AE),
          UINT64_C(0x000647D3BCA69083), UINT64_C(0x000663401832196F)}},
        {{UINT64_C(0x0002E9B7160E3961), UINT64_C(0x0000CFDD2754F2C2),
          UINT64_C(0x000737ED6627095B), UINT64_C(0x0000907EAC442E04),
          UINT64_C(0x0004BFDDFD6D0E23), UINT64_C(0x0009C97A7D587EEF),
          UINT64_C(0x000543F2822FAFB5), UINT64_C(0x0003FDF6AF5D7A19),
          UINT64_C(0x0000FC963721698D), UINT64_C(0x000179F21E6577FB)},
         {UINT64_C(0x00025DABF637CE7B), UINT64_C(0x0000DEF29AADAC3D),
          UINT64_C(0x0001737E91658123), UINT64_C(0x000249402C7B4BC4),
          UINT64_C(0x0001F964C1BA2B35), UINT64_C(0x0006547130478601),
          UINT64_C(0x00004A763BB9F26E), UINT64_C(0x0002DEE0532A3ABA),
          UINT64_C(0x0000FB73209B3189), UINT64_C(0x000323CB18309CBF)}},
        {{UINT64_C(0x000F430885B15B6B), UINT64_C(0x00075D059AEC5A1E),
          UINT64_C(0x0004453A277EFFCE), UINT64_C(0x00064F823D9E2950),
          UINT64_C(0x00073827A14B9299), UINT64_C(0x0001C133BA90B752),
          UINT64_C(0x0002FE7DB431EADF), UINT64_C(0x0007321007818326),
          UINT64_C(0x00071653A5874521), UINT64_C(0x000797A5565F102D)},
         {UINT64_C(0x00036CFD54EEA72C), UINT64_C(0x0000808016DA4E23),
          UINT64_C(0x0003D2134B084DFE), UINT64_C(0x00011B5581647A89),
          UINT64_C(0x00052FAD726D60BB), UINT64_C(0x000DCFDB5420868A),
          UINT64_C(0x000750548DD329FF), UINT64_C(0x00019FE6DA0749CC),
          UINT64_C(0x00005B85FA39A2C1), UINT64_C(0x00023AE3BBD89F61)}},
        {{UINT64_C(0x000CA8883C4EF58F), UINT64_C(0x0006E759199F54FA),
          UINT64_C(0x00055E8867F4288D), UINT64_C(0x000225E439FE7035),
          UINT64_C(0x00040EE9678BC4D1), UINT64_C(0x000E0C8FEC05A2E2),
          UINT64_C(0x000586D8C13D487A), UINT64_C(0x00008B4A7E530498),
          UINT64_C(0x0001E781B4E18C6D), UINT64_C(0x00017D763BE7083C)},
         {UINT64_C(0x000A451105CF54F0), UINT64_C(0x000637BF27522C26),
          UINT64_C(0x0006042AB901CB43), UINT64_C(0x0000F3A157D77CEC),
          UINT64_C(0x00040B5652E5D030), UINT64_C(0x0003F395A2C01F02),
          UINT64_C(0x00041B950FC573CA), UINT64_C(0x0007DED4FDDEA439),
          UINT64_C(0x00012CAC59609158), UINT64_C(0x0000EC63DC4F41D8)}},
        {{UINT64_C(0x000027B04D23C68B), UINT64_C(0x000525B4F2B59AFC),
          UINT64_C(0x0001473B3791B81E), UINT64_C(0x0004234680C59597),
          UINT64_C(0x00049B5B1E7B7404), UINT64_C(0x000CA846EE9B6288),
          UINT64_C(0x0002F4D705212A30), UINT64_C(0x000435199A6D217F),
          UINT64_C(0x0002C022FF19EE1F), UINT64_C(0x0003594F8F0758A9)},
         {UINT64_C(0x000968170931C47A), UINT64_C(0x000621AD96C9DEDE),
          UINT64_C(0x0001F40DB9806854), UINT64_C(0x0006535786069F3A),
          UINT64_C(0x0002BAAF09744048), UINT64_C(0x000CE1A02746C6D1),
          UINT64_C(0x000159007061AA2D), UINT64_C(0x000679FCA2D81FCD),
          UINT64_C(0x000418AC9FB46B4D), UINT64_C(0x000308BE060423D1)}},
        {{UINT64_C(0x0000C4AC87AF9AD9), UINT64_C(0x0000CDECE641A609),
          UINT64_C(0x0001E12CC58F8FCD), UINT64_C(0x000510A219809940),
          UINT64_C(0x0006DA7CEA8384F8), UINT64_C(0x000AB5F0694566E0),
          UINT64_C(0x0001CC9EE803A140), UINT64_C(0x0000F9FBB28BDD1E),
          UINT64_C(0x0007F4EFEB56B1DE), UINT64_C(0x000277916C4688BF)},
         {UINT64_C(0x000D23553900C111), UINT64_C(0x0002646A893D2545),
          UINT64_C(0x0003F85DED9F79E4), UINT64_C(0x0003D6EBC7956C87),
          UINT64_C(0x00042C8421E33668), UINT64_C(0x0000CE0FCEE92113),
          UINT64_C(0x00062F37FB71D455), UINT64_C(0x0002B5C2D8B8E0D9),
          UINT64_C(0x0001F89A7B791F03), UINT64_C(0x00026E0534AAFC55)}},
        {{UINT64_C(0x0002995D9382FB5B), UINT64_C(0x0007C05714B2BDCD),
          UINT64_C(0x00055EFDFFD811CA), UINT64_C(0x0000C43B6FA2E22F),
          UINT64_C(0x0003930FE770F72D), UINT64_C(0x00082F4073A9EB83),
          UINT64_C(0x00028C90A8534165), UINT64_C(0x00020C6D2C543EAE),
          UINT64_C(0x0003F98A8E8F71B7), UINT64_C(0x0007B8FB4D43C48C)},
         {UINT64_C(0x000C54F1DA463909), UINT64_C(0x000482EC99C805E1),
          UINT64_C(0x000301F27ED477A1), UINT64_C(0x0005CA99320599DA),
          UINT64_C(0x0003F84676223EB7), UINT64_C(0x00001D5F50BC87AC),
          UINT64_C(0x0006D360C6473C45), UINT64_C(0x00078FE24EB5EF6D),
          UINT64_C(0x0003E18E1D8C918F), UINT64_C(0x0000BAAA9526A788)}},
        {{UINT64_C(0x0003CFAC186FC15D), UINT64_C(0x0004079422F8115B),
          UINT64_C(0x00015745819F82E6), UINT64_C(0x0003618BCA6799CF),
          UINT64_C(0x000147DCBEB05016), UINT64_C(0x0008E01C4060F0AE),
          UINT64_C(0x0006DD9C9ABCADD5), UINT64_C(0x00055C9418FA0C56),
          UINT64_C(0x0004ADEDA517CF14), UINT64_C(0x0000A4AEB8D1A937)},
         {UINT64_C(0x0004727D18C04C1D), UINT64_C(0x000459FEB8D4258F),
          UINT64_C(0x000134BF4171D346), UINT64_C(0x000686442480B1AF),
          UINT64_C(0x000739A7BBB7AB37), UINT64_C(0x000F61BC7DC00473),
          UINT64_C(0x0003746597B948CE), UINT64_C(0x000125EAB46F1D2B),
          UINT64_C(0x000033F4805B72AE), UINT64_C(0x000584748C0B9409)}},
        {{UINT64_C(0x00092A49D3069003), UINT64_C(0x0005840D8AF17ED6),
          UINT64_C(0x000174B6F581B1E5), UINT64_C(0x000163189D301971),
          UINT64_C(0x0000018D239951ED), UINT64_C(0x0009B7C92C641D5C),
          UINT64_C(0x000289C88DD6E0A4), UINT64_C(0x0000CE7ED79D24F4),
          UINT64_C(0x0007F5A09563A4B9), UINT64_C(0x0007A4A25F6B4D5C)},
         {UINT64_C(0x00002966A02D81D0), UINT64_C(0x00079C7EA96452D3),
          UINT64_C(0x0007C34AB0AA795A), UINT64_C(0x00050A1B57CC0E57),
          UINT64_C(0x0007DE8829195BCB), UINT64_C(0x0006242A9B8D0EC5),
          UINT64_C(0x0005DD50FAD307D9), UINT64_C(0x0001B700B637CA0B),
          UINT64_C(0x0003455689EBE7C1), UINT64_C(0x0002782C47D2932F)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t0, X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t1, Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t2, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, X, Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, Y, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, X, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, X3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t2, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t2, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, Z3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, Z3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, t0, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t4, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t0, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
}

/*-
 * out1 = (arg1 == 0) ? 0 : nz
 * NB: this is not a "mod p equiv" 0, but literal 0
 * NB: this is not a real Fiat function, just named that way for consistency.
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_nonzero(limb_t *out1,
                                                              const fe_t arg1) {
    limb_t x1 = 0;
    int i;

    for (i = 0; i < LIMB_CNT; i++) x1 |= arg1[i];
    *out1 = x1;
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, X1, X2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, Y1, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, X2, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, X1, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, Y2, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t4, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X2, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, X1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, X3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Z1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t1, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t4, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, t0, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, t3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t4, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->X, nz, Q->X, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, X1, X2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, Y1, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, Z1, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, X1, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, X2, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, Y1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t5, Y2, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, t4, t5);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t5, t1, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t4, t4, t5);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, X2, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, X3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t2, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t1, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t1, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t4, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, t0, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, t3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t4, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[64], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 64) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[103], const unsigned char in[64]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 102; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[513], const unsigned char in[64]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 513; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[64],
                              const unsigned char b[64], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[513] = {0};
    int8_t bnaf[513] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 512; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[64],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[103] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[102] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, diff, Q.X,
                                                            precomp[j].X);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, diff, Q.Y,
                                                            precomp[j].Y);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, diff, Q.Z,
                                                            precomp[j].Z);
    }

    for (i = 101; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(out->Y, lut.Y);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(lut.Y, is_neg,
                                                            lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, scalar[0] & 1,
                                                        lut.X, Q.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, scalar[0] & 1,
                                                        lut.Y, Q.Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, scalar[0] & 1,
                                                        lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[64]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[103] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 9; i >= 0; i--) {
        for (j = 0; i != 9 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 12; j++) {
            if (j * 10 + i > 102) continue;
            d = rnaf[j * 10 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(out->Y, lut.Y);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(lut.Y, is_neg,
                                                                lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, scalar[0] & 1, R.X,
                                                        Q.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, scalar[0] & 1, R.Y,
                                                        Q.Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, scalar[0] & 1, R.Z,
                                                        Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[64], unsigned char outy[64],
                          const unsigned char a[64], const unsigned char b[64],
                          const unsigned char inx[64],
                          const unsigned char iny[64]) {
    pt_aff_t P;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.X, inx);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.Y, iny);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[64], unsigned char outy[64],
                        const unsigned char scalar[64]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[64], unsigned char outy[64],
                      const unsigned char scalar[64],
                      const unsigned char inx[64],
                      const unsigned char iny[64]) {
    pt_aff_t P;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.X, inx);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.Y, iny);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[64] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_tc26_gost_3410_2012_512_paramSetA(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_n[64];
    unsigned char b_m[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 64) != 64 || BN_bn2lebinpad(y, b_y, 64) != 64 ||
        BN_bn2lebinpad(n, b_n, 64) != 64 || BN_bn2lebinpad(m, b_m, 64) != 64)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_tc26_gost_3410_2012_512_paramSetA(const EC_GROUP *group,
                                                   EC_POINT *r,
                                                   const EC_POINT *q,
                                                   const BIGNUM *m,
                                                   BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_m[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 64) != 64 || BN_bn2lebinpad(y, b_y, 64) != 64 ||
        BN_bn2lebinpad(m, b_m, 64) != 64)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_tc26_gost_3410_2012_512_paramSetA(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const BIGNUM *n,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_n[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 64) != 64)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#else /* __SIZEOF_INT128__ */

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 32
#define LIMB_CNT 23
/* Field elements */
typedef uint32_t fe_t[LIMB_CNT];
typedef uint32_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_TC26_GOST_3410_2012_512_PARAMSETA_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

#define fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(c, a, b) \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_add(c, a, b);          \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(c, c)
#define fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(c, a, b) \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_sub(c, a, b);          \
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(c, c)

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: unsaturated_solinas --static --use-value-barrier id_tc26_gost_3410_2012_512_paramSetA 32 '(auto)' '2^512 - 569' */
/* curve description: id_tc26_gost_3410_2012_512_paramSetA */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* n = 23 (from "(auto)") */
/* s-c = 2^512 - [(1, 569)] (from "2^512 - 569") */
/* tight_bounds_multiplier = 1 (from "") */
/*  */
/* Computed values: */
/* carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 0, 1] */
/* eval z = z[0] + (z[1] << 23) + (z[2] << 45) + (z[3] << 67) + (z[4] << 90) + (z[5] << 112) + (z[6] << 134) + (z[7] << 156) + (z[8] << 179) + (z[9] << 201) + (z[10] << 223) + (z[11] << 245) + (z[12] << 0x10c) + (z[13] << 0x122) + (z[14] << 0x138) + (z[15] << 0x14e) + (z[16] << 0x165) + (z[17] << 0x17b) + (z[18] << 0x191) + (z[19] << 0x1a7) + (z[20] << 0x1be) + (z[21] << 0x1d4) + (z[22] << 0x1ea) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) */
/* balance = [0xfffb8e, 0x7ffffe, 0x7ffffe, 0xfffffe, 0x7ffffe, 0x7ffffe, 0x7ffffe, 0xfffffe, 0x7ffffe, 0x7ffffe, 0x7ffffe, 0xfffffe, 0x7ffffe, 0x7ffffe, 0x7ffffe, 0xfffffe, 0x7ffffe, 0x7ffffe, 0x7ffffe, 0xfffffe, 0x7ffffe, 0x7ffffe, 0x7ffffe] */

#include <stdint.h>
typedef unsigned char fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1;
typedef signed char fiat_id_tc26_gost_3410_2012_512_paramSetA_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_TC26_GOST_3410_2012_512_PARAMSETA_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t
fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u32(uint32_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u32(x) (x)
#endif

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^22
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^22⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3fffff]
 *   arg3: [0x0 ~> 0x3fffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3fffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
    uint32_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    uint32_t x1;
    uint32_t x2;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT32_C(0x3fffff));
    x3 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x1 >> 22);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^22
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^22⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3fffff]
 *   arg3: [0x0 ~> 0x3fffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3fffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
    uint32_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    int32_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_int1 x2;
    uint32_t x3;
    x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
    x2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(x1 >> 22);
    x3 = (x1 & UINT32_C(0x3fffff));
    *out1 = x3;
    *out2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^23
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^23⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7fffff]
 *   arg3: [0x0 ~> 0x7fffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7fffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
    uint32_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    uint32_t x1;
    uint32_t x2;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x3;
    x1 = ((arg1 + arg2) + arg3);
    x2 = (x1 & UINT32_C(0x7fffff));
    x3 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x1 >> 23);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^23
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^23⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7fffff]
 *   arg3: [0x0 ~> 0x7fffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7fffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
    uint32_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 *out2,
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    int32_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_int1 x2;
    uint32_t x3;
    x1 = ((int32_t)(arg2 - arg1) - (int32_t)arg3);
    x2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(x1 >> 23);
    x3 = (x1 & UINT32_C(0x7fffff));
    *out1 = x3;
    *out2 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
    uint32_t *out1, fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1,
    uint32_t arg2, uint32_t arg3) {
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_int1)(0x0 - x1) &
          UINT32_C(0xffffffff));
    x3 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u32(x2) &
           arg3) |
          (fiat_id_tc26_gost_3410_2012_512_paramSetA_value_barrier_u32((~x2)) &
           arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul multiplies two field elements and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 *   arg2: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(
    uint32_t out1[23], const uint32_t arg1[23], const uint32_t arg2[23]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint64_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    uint64_t x170;
    uint64_t x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    uint64_t x176;
    uint64_t x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    uint64_t x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    uint64_t x202;
    uint64_t x203;
    uint64_t x204;
    uint64_t x205;
    uint64_t x206;
    uint64_t x207;
    uint64_t x208;
    uint64_t x209;
    uint64_t x210;
    uint64_t x211;
    uint64_t x212;
    uint64_t x213;
    uint64_t x214;
    uint64_t x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    uint64_t x220;
    uint64_t x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    uint64_t x236;
    uint64_t x237;
    uint64_t x238;
    uint64_t x239;
    uint64_t x240;
    uint64_t x241;
    uint64_t x242;
    uint64_t x243;
    uint64_t x244;
    uint64_t x245;
    uint64_t x246;
    uint64_t x247;
    uint64_t x248;
    uint64_t x249;
    uint64_t x250;
    uint64_t x251;
    uint64_t x252;
    uint64_t x253;
    uint64_t x254;
    uint64_t x255;
    uint64_t x256;
    uint64_t x257;
    uint64_t x258;
    uint64_t x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    uint64_t x268;
    uint64_t x269;
    uint64_t x270;
    uint64_t x271;
    uint64_t x272;
    uint64_t x273;
    uint64_t x274;
    uint64_t x275;
    uint64_t x276;
    uint64_t x277;
    uint64_t x278;
    uint64_t x279;
    uint64_t x280;
    uint64_t x281;
    uint64_t x282;
    uint64_t x283;
    uint64_t x284;
    uint64_t x285;
    uint64_t x286;
    uint64_t x287;
    uint64_t x288;
    uint64_t x289;
    uint64_t x290;
    uint64_t x291;
    uint64_t x292;
    uint64_t x293;
    uint64_t x294;
    uint64_t x295;
    uint64_t x296;
    uint64_t x297;
    uint64_t x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    uint64_t x302;
    uint64_t x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    uint64_t x310;
    uint64_t x311;
    uint64_t x312;
    uint64_t x313;
    uint64_t x314;
    uint64_t x315;
    uint64_t x316;
    uint64_t x317;
    uint64_t x318;
    uint64_t x319;
    uint64_t x320;
    uint64_t x321;
    uint64_t x322;
    uint64_t x323;
    uint64_t x324;
    uint64_t x325;
    uint64_t x326;
    uint64_t x327;
    uint64_t x328;
    uint64_t x329;
    uint64_t x330;
    uint64_t x331;
    uint64_t x332;
    uint64_t x333;
    uint64_t x334;
    uint64_t x335;
    uint64_t x336;
    uint64_t x337;
    uint64_t x338;
    uint64_t x339;
    uint64_t x340;
    uint64_t x341;
    uint64_t x342;
    uint64_t x343;
    uint64_t x344;
    uint64_t x345;
    uint64_t x346;
    uint64_t x347;
    uint64_t x348;
    uint64_t x349;
    uint64_t x350;
    uint64_t x351;
    uint64_t x352;
    uint64_t x353;
    uint64_t x354;
    uint64_t x355;
    uint64_t x356;
    uint64_t x357;
    uint64_t x358;
    uint64_t x359;
    uint64_t x360;
    uint64_t x361;
    uint64_t x362;
    uint64_t x363;
    uint64_t x364;
    uint64_t x365;
    uint64_t x366;
    uint64_t x367;
    uint64_t x368;
    uint64_t x369;
    uint64_t x370;
    uint64_t x371;
    uint64_t x372;
    uint64_t x373;
    uint64_t x374;
    uint64_t x375;
    uint64_t x376;
    uint64_t x377;
    uint64_t x378;
    uint64_t x379;
    uint64_t x380;
    uint64_t x381;
    uint64_t x382;
    uint64_t x383;
    uint64_t x384;
    uint64_t x385;
    uint64_t x386;
    uint64_t x387;
    uint64_t x388;
    uint64_t x389;
    uint64_t x390;
    uint64_t x391;
    uint64_t x392;
    uint64_t x393;
    uint64_t x394;
    uint64_t x395;
    uint64_t x396;
    uint64_t x397;
    uint64_t x398;
    uint64_t x399;
    uint64_t x400;
    uint64_t x401;
    uint64_t x402;
    uint64_t x403;
    uint64_t x404;
    uint64_t x405;
    uint64_t x406;
    uint64_t x407;
    uint64_t x408;
    uint64_t x409;
    uint64_t x410;
    uint64_t x411;
    uint64_t x412;
    uint64_t x413;
    uint64_t x414;
    uint64_t x415;
    uint64_t x416;
    uint64_t x417;
    uint64_t x418;
    uint64_t x419;
    uint64_t x420;
    uint64_t x421;
    uint64_t x422;
    uint64_t x423;
    uint64_t x424;
    uint64_t x425;
    uint64_t x426;
    uint64_t x427;
    uint64_t x428;
    uint64_t x429;
    uint64_t x430;
    uint64_t x431;
    uint64_t x432;
    uint64_t x433;
    uint64_t x434;
    uint64_t x435;
    uint64_t x436;
    uint64_t x437;
    uint64_t x438;
    uint64_t x439;
    uint64_t x440;
    uint64_t x441;
    uint64_t x442;
    uint64_t x443;
    uint64_t x444;
    uint64_t x445;
    uint64_t x446;
    uint64_t x447;
    uint64_t x448;
    uint64_t x449;
    uint64_t x450;
    uint64_t x451;
    uint64_t x452;
    uint64_t x453;
    uint64_t x454;
    uint64_t x455;
    uint64_t x456;
    uint64_t x457;
    uint64_t x458;
    uint64_t x459;
    uint64_t x460;
    uint64_t x461;
    uint64_t x462;
    uint64_t x463;
    uint64_t x464;
    uint64_t x465;
    uint64_t x466;
    uint64_t x467;
    uint64_t x468;
    uint64_t x469;
    uint64_t x470;
    uint64_t x471;
    uint64_t x472;
    uint64_t x473;
    uint64_t x474;
    uint64_t x475;
    uint64_t x476;
    uint64_t x477;
    uint64_t x478;
    uint64_t x479;
    uint64_t x480;
    uint64_t x481;
    uint64_t x482;
    uint64_t x483;
    uint64_t x484;
    uint64_t x485;
    uint64_t x486;
    uint64_t x487;
    uint64_t x488;
    uint64_t x489;
    uint64_t x490;
    uint64_t x491;
    uint64_t x492;
    uint64_t x493;
    uint64_t x494;
    uint64_t x495;
    uint64_t x496;
    uint64_t x497;
    uint64_t x498;
    uint64_t x499;
    uint64_t x500;
    uint64_t x501;
    uint64_t x502;
    uint64_t x503;
    uint64_t x504;
    uint64_t x505;
    uint64_t x506;
    uint64_t x507;
    uint64_t x508;
    uint64_t x509;
    uint64_t x510;
    uint64_t x511;
    uint64_t x512;
    uint64_t x513;
    uint64_t x514;
    uint64_t x515;
    uint64_t x516;
    uint64_t x517;
    uint64_t x518;
    uint64_t x519;
    uint64_t x520;
    uint64_t x521;
    uint64_t x522;
    uint64_t x523;
    uint64_t x524;
    uint64_t x525;
    uint64_t x526;
    uint64_t x527;
    uint64_t x528;
    uint64_t x529;
    uint64_t x530;
    uint64_t x531;
    uint32_t x532;
    uint64_t x533;
    uint64_t x534;
    uint64_t x535;
    uint64_t x536;
    uint64_t x537;
    uint64_t x538;
    uint64_t x539;
    uint64_t x540;
    uint64_t x541;
    uint64_t x542;
    uint64_t x543;
    uint64_t x544;
    uint64_t x545;
    uint64_t x546;
    uint64_t x547;
    uint64_t x548;
    uint64_t x549;
    uint64_t x550;
    uint64_t x551;
    uint64_t x552;
    uint64_t x553;
    uint64_t x554;
    uint64_t x555;
    uint64_t x556;
    uint32_t x557;
    uint64_t x558;
    uint64_t x559;
    uint32_t x560;
    uint64_t x561;
    uint64_t x562;
    uint32_t x563;
    uint64_t x564;
    uint64_t x565;
    uint32_t x566;
    uint64_t x567;
    uint64_t x568;
    uint32_t x569;
    uint64_t x570;
    uint64_t x571;
    uint32_t x572;
    uint64_t x573;
    uint64_t x574;
    uint32_t x575;
    uint64_t x576;
    uint64_t x577;
    uint32_t x578;
    uint64_t x579;
    uint64_t x580;
    uint32_t x581;
    uint64_t x582;
    uint64_t x583;
    uint32_t x584;
    uint64_t x585;
    uint64_t x586;
    uint32_t x587;
    uint64_t x588;
    uint64_t x589;
    uint32_t x590;
    uint64_t x591;
    uint64_t x592;
    uint32_t x593;
    uint64_t x594;
    uint64_t x595;
    uint32_t x596;
    uint64_t x597;
    uint64_t x598;
    uint32_t x599;
    uint64_t x600;
    uint64_t x601;
    uint32_t x602;
    uint64_t x603;
    uint64_t x604;
    uint32_t x605;
    uint64_t x606;
    uint64_t x607;
    uint32_t x608;
    uint64_t x609;
    uint64_t x610;
    uint32_t x611;
    uint64_t x612;
    uint64_t x613;
    uint32_t x614;
    uint64_t x615;
    uint64_t x616;
    uint32_t x617;
    uint64_t x618;
    uint32_t x619;
    uint32_t x620;
    uint64_t x621;
    uint64_t x622;
    uint32_t x623;
    uint32_t x624;
    uint32_t x625;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x626;
    uint32_t x627;
    uint32_t x628;
    x1 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[22])));
    x2 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[21])));
    x3 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[20])) * 0x2));
    x4 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[19])));
    x5 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[18])));
    x6 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[17])));
    x7 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[16])) * 0x2));
    x8 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[15])));
    x9 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[14])));
    x10 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[13])));
    x11 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[12])) * 0x2));
    x12 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[11])));
    x13 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[10])));
    x14 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[9])));
    x15 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[8])) * 0x2));
    x16 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[7])));
    x17 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[6])));
    x18 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[5])));
    x19 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[4])) * 0x2));
    x20 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[3])));
    x21 = (UINT16_C(0x239) * ((uint64_t)(arg1[22]) * (arg2[2])));
    x22 = (UINT16_C(0x239) * (((uint64_t)(arg1[22]) * (arg2[1])) * 0x2));
    x23 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[22])));
    x24 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[21])) * 0x2));
    x25 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[20])) * 0x2));
    x26 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[19])));
    x27 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[18])));
    x28 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[17])) * 0x2));
    x29 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[16])) * 0x2));
    x30 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[15])));
    x31 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[14])));
    x32 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[13])) * 0x2));
    x33 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[12])) * 0x2));
    x34 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[11])));
    x35 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[10])));
    x36 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[9])) * 0x2));
    x37 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[8])) * 0x2));
    x38 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[7])));
    x39 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[6])));
    x40 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[5])) * 0x2));
    x41 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[4])) * 0x2));
    x42 = (UINT16_C(0x239) * ((uint64_t)(arg1[21]) * (arg2[3])));
    x43 = (UINT16_C(0x239) * (((uint64_t)(arg1[21]) * (arg2[2])) * 0x2));
    x44 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[22])) * 0x2));
    x45 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[21])) * 0x2));
    x46 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[20])) * 0x2));
    x47 = (UINT16_C(0x239) * ((uint64_t)(arg1[20]) * (arg2[19])));
    x48 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[18])) * 0x2));
    x49 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[17])) * 0x2));
    x50 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[16])) * 0x2));
    x51 = (UINT16_C(0x239) * ((uint64_t)(arg1[20]) * (arg2[15])));
    x52 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[14])) * 0x2));
    x53 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[13])) * 0x2));
    x54 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[12])) * 0x2));
    x55 = (UINT16_C(0x239) * ((uint64_t)(arg1[20]) * (arg2[11])));
    x56 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[10])) * 0x2));
    x57 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[9])) * 0x2));
    x58 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[8])) * 0x2));
    x59 = (UINT16_C(0x239) * ((uint64_t)(arg1[20]) * (arg2[7])));
    x60 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[6])) * 0x2));
    x61 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[5])) * 0x2));
    x62 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[4])) * 0x2));
    x63 = (UINT16_C(0x239) * (((uint64_t)(arg1[20]) * (arg2[3])) * 0x2));
    x64 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[22])));
    x65 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[21])));
    x66 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[20])));
    x67 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[19])));
    x68 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[18])));
    x69 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[17])));
    x70 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[16])));
    x71 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[15])));
    x72 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[14])));
    x73 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[13])));
    x74 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[12])));
    x75 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[11])));
    x76 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[10])));
    x77 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[9])));
    x78 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[8])));
    x79 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[7])));
    x80 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[6])));
    x81 = (UINT16_C(0x239) * ((uint64_t)(arg1[19]) * (arg2[5])));
    x82 = (UINT16_C(0x239) * (((uint64_t)(arg1[19]) * (arg2[4])) * 0x2));
    x83 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[22])));
    x84 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[21])));
    x85 = (UINT16_C(0x239) * (((uint64_t)(arg1[18]) * (arg2[20])) * 0x2));
    x86 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[19])));
    x87 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[18])));
    x88 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[17])));
    x89 = (UINT16_C(0x239) * (((uint64_t)(arg1[18]) * (arg2[16])) * 0x2));
    x90 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[15])));
    x91 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[14])));
    x92 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[13])));
    x93 = (UINT16_C(0x239) * (((uint64_t)(arg1[18]) * (arg2[12])) * 0x2));
    x94 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[11])));
    x95 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[10])));
    x96 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[9])));
    x97 = (UINT16_C(0x239) * (((uint64_t)(arg1[18]) * (arg2[8])) * 0x2));
    x98 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[7])));
    x99 = (UINT16_C(0x239) * ((uint64_t)(arg1[18]) * (arg2[6])));
    x100 = (UINT16_C(0x239) * (((uint64_t)(arg1[18]) * (arg2[5])) * 0x2));
    x101 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[22])));
    x102 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[21])) * 0x2));
    x103 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[20])) * 0x2));
    x104 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[19])));
    x105 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[18])));
    x106 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[17])) * 0x2));
    x107 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[16])) * 0x2));
    x108 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[15])));
    x109 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[14])));
    x110 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[13])) * 0x2));
    x111 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[12])) * 0x2));
    x112 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[11])));
    x113 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[10])));
    x114 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[9])) * 0x2));
    x115 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[8])) * 0x2));
    x116 = (UINT16_C(0x239) * ((uint64_t)(arg1[17]) * (arg2[7])));
    x117 = (UINT16_C(0x239) * (((uint64_t)(arg1[17]) * (arg2[6])) * 0x2));
    x118 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[22])) * 0x2));
    x119 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[21])) * 0x2));
    x120 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[20])) * 0x2));
    x121 = (UINT16_C(0x239) * ((uint64_t)(arg1[16]) * (arg2[19])));
    x122 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[18])) * 0x2));
    x123 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[17])) * 0x2));
    x124 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[16])) * 0x2));
    x125 = (UINT16_C(0x239) * ((uint64_t)(arg1[16]) * (arg2[15])));
    x126 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[14])) * 0x2));
    x127 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[13])) * 0x2));
    x128 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[12])) * 0x2));
    x129 = (UINT16_C(0x239) * ((uint64_t)(arg1[16]) * (arg2[11])));
    x130 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[10])) * 0x2));
    x131 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[9])) * 0x2));
    x132 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[8])) * 0x2));
    x133 = (UINT16_C(0x239) * (((uint64_t)(arg1[16]) * (arg2[7])) * 0x2));
    x134 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[22])));
    x135 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[21])));
    x136 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[20])));
    x137 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[19])));
    x138 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[18])));
    x139 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[17])));
    x140 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[16])));
    x141 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[15])));
    x142 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[14])));
    x143 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[13])));
    x144 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[12])));
    x145 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[11])));
    x146 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[10])));
    x147 = (UINT16_C(0x239) * ((uint64_t)(arg1[15]) * (arg2[9])));
    x148 = (UINT16_C(0x239) * (((uint64_t)(arg1[15]) * (arg2[8])) * 0x2));
    x149 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[22])));
    x150 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[21])));
    x151 = (UINT16_C(0x239) * (((uint64_t)(arg1[14]) * (arg2[20])) * 0x2));
    x152 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[19])));
    x153 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[18])));
    x154 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[17])));
    x155 = (UINT16_C(0x239) * (((uint64_t)(arg1[14]) * (arg2[16])) * 0x2));
    x156 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[15])));
    x157 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[14])));
    x158 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[13])));
    x159 = (UINT16_C(0x239) * (((uint64_t)(arg1[14]) * (arg2[12])) * 0x2));
    x160 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[11])));
    x161 = (UINT16_C(0x239) * ((uint64_t)(arg1[14]) * (arg2[10])));
    x162 = (UINT16_C(0x239) * (((uint64_t)(arg1[14]) * (arg2[9])) * 0x2));
    x163 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[22])));
    x164 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[21])) * 0x2));
    x165 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[20])) * 0x2));
    x166 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[19])));
    x167 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[18])));
    x168 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[17])) * 0x2));
    x169 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[16])) * 0x2));
    x170 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[15])));
    x171 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[14])));
    x172 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[13])) * 0x2));
    x173 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[12])) * 0x2));
    x174 = (UINT16_C(0x239) * ((uint64_t)(arg1[13]) * (arg2[11])));
    x175 = (UINT16_C(0x239) * (((uint64_t)(arg1[13]) * (arg2[10])) * 0x2));
    x176 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[22])) * 0x2));
    x177 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[21])) * 0x2));
    x178 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[20])) * 0x2));
    x179 = (UINT16_C(0x239) * ((uint64_t)(arg1[12]) * (arg2[19])));
    x180 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[18])) * 0x2));
    x181 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[17])) * 0x2));
    x182 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[16])) * 0x2));
    x183 = (UINT16_C(0x239) * ((uint64_t)(arg1[12]) * (arg2[15])));
    x184 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[14])) * 0x2));
    x185 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[13])) * 0x2));
    x186 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[12])) * 0x2));
    x187 = (UINT16_C(0x239) * (((uint64_t)(arg1[12]) * (arg2[11])) * 0x2));
    x188 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[22])));
    x189 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[21])));
    x190 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[20])));
    x191 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[19])));
    x192 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[18])));
    x193 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[17])));
    x194 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[16])));
    x195 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[15])));
    x196 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[14])));
    x197 = (UINT16_C(0x239) * ((uint64_t)(arg1[11]) * (arg2[13])));
    x198 = (UINT16_C(0x239) * (((uint64_t)(arg1[11]) * (arg2[12])) * 0x2));
    x199 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[22])));
    x200 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[21])));
    x201 = (UINT16_C(0x239) * (((uint64_t)(arg1[10]) * (arg2[20])) * 0x2));
    x202 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[19])));
    x203 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[18])));
    x204 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[17])));
    x205 = (UINT16_C(0x239) * (((uint64_t)(arg1[10]) * (arg2[16])) * 0x2));
    x206 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[15])));
    x207 = (UINT16_C(0x239) * ((uint64_t)(arg1[10]) * (arg2[14])));
    x208 = (UINT16_C(0x239) * (((uint64_t)(arg1[10]) * (arg2[13])) * 0x2));
    x209 = (UINT16_C(0x239) * ((uint64_t)(arg1[9]) * (arg2[22])));
    x210 = (UINT16_C(0x239) * (((uint64_t)(arg1[9]) * (arg2[21])) * 0x2));
    x211 = (UINT16_C(0x239) * (((uint64_t)(arg1[9]) * (arg2[20])) * 0x2));
    x212 = (UINT16_C(0x239) * ((uint64_t)(arg1[9]) * (arg2[19])));
    x213 = (UINT16_C(0x239) * ((uint64_t)(arg1[9]) * (arg2[18])));
    x214 = (UINT16_C(0x239) * (((uint64_t)(arg1[9]) * (arg2[17])) * 0x2));
    x215 = (UINT16_C(0x239) * (((uint64_t)(arg1[9]) * (arg2[16])) * 0x2));
    x216 = (UINT16_C(0x239) * ((uint64_t)(arg1[9]) * (arg2[15])));
    x217 = (UINT16_C(0x239) * (((uint64_t)(arg1[9]) * (arg2[14])) * 0x2));
    x218 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[22])) * 0x2));
    x219 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[21])) * 0x2));
    x220 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[20])) * 0x2));
    x221 = (UINT16_C(0x239) * ((uint64_t)(arg1[8]) * (arg2[19])));
    x222 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[18])) * 0x2));
    x223 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[17])) * 0x2));
    x224 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[16])) * 0x2));
    x225 = (UINT16_C(0x239) * (((uint64_t)(arg1[8]) * (arg2[15])) * 0x2));
    x226 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[22])));
    x227 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[21])));
    x228 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[20])));
    x229 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[19])));
    x230 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[18])));
    x231 = (UINT16_C(0x239) * ((uint64_t)(arg1[7]) * (arg2[17])));
    x232 = (UINT16_C(0x239) * (((uint64_t)(arg1[7]) * (arg2[16])) * 0x2));
    x233 = (UINT16_C(0x239) * ((uint64_t)(arg1[6]) * (arg2[22])));
    x234 = (UINT16_C(0x239) * ((uint64_t)(arg1[6]) * (arg2[21])));
    x235 = (UINT16_C(0x239) * (((uint64_t)(arg1[6]) * (arg2[20])) * 0x2));
    x236 = (UINT16_C(0x239) * ((uint64_t)(arg1[6]) * (arg2[19])));
    x237 = (UINT16_C(0x239) * ((uint64_t)(arg1[6]) * (arg2[18])));
    x238 = (UINT16_C(0x239) * (((uint64_t)(arg1[6]) * (arg2[17])) * 0x2));
    x239 = (UINT16_C(0x239) * ((uint64_t)(arg1[5]) * (arg2[22])));
    x240 = (UINT16_C(0x239) * (((uint64_t)(arg1[5]) * (arg2[21])) * 0x2));
    x241 = (UINT16_C(0x239) * (((uint64_t)(arg1[5]) * (arg2[20])) * 0x2));
    x242 = (UINT16_C(0x239) * ((uint64_t)(arg1[5]) * (arg2[19])));
    x243 = (UINT16_C(0x239) * (((uint64_t)(arg1[5]) * (arg2[18])) * 0x2));
    x244 = (UINT16_C(0x239) * (((uint64_t)(arg1[4]) * (arg2[22])) * 0x2));
    x245 = (UINT16_C(0x239) * (((uint64_t)(arg1[4]) * (arg2[21])) * 0x2));
    x246 = (UINT16_C(0x239) * (((uint64_t)(arg1[4]) * (arg2[20])) * 0x2));
    x247 = (UINT16_C(0x239) * (((uint64_t)(arg1[4]) * (arg2[19])) * 0x2));
    x248 = (UINT16_C(0x239) * ((uint64_t)(arg1[3]) * (arg2[22])));
    x249 = (UINT16_C(0x239) * ((uint64_t)(arg1[3]) * (arg2[21])));
    x250 = (UINT16_C(0x239) * (((uint64_t)(arg1[3]) * (arg2[20])) * 0x2));
    x251 = (UINT16_C(0x239) * ((uint64_t)(arg1[2]) * (arg2[22])));
    x252 = (UINT16_C(0x239) * (((uint64_t)(arg1[2]) * (arg2[21])) * 0x2));
    x253 = (UINT16_C(0x239) * (((uint64_t)(arg1[1]) * (arg2[22])) * 0x2));
    x254 = ((uint64_t)(arg1[22]) * (arg2[0]));
    x255 = ((uint64_t)(arg1[21]) * ((arg2[1]) * 0x2));
    x256 = ((uint64_t)(arg1[21]) * (arg2[0]));
    x257 = ((uint64_t)(arg1[20]) * ((arg2[2]) * 0x2));
    x258 = ((uint64_t)(arg1[20]) * ((arg2[1]) * 0x2));
    x259 = ((uint64_t)(arg1[20]) * (arg2[0]));
    x260 = ((uint64_t)(arg1[19]) * (arg2[3]));
    x261 = ((uint64_t)(arg1[19]) * (arg2[2]));
    x262 = ((uint64_t)(arg1[19]) * (arg2[1]));
    x263 = ((uint64_t)(arg1[19]) * (arg2[0]));
    x264 = ((uint64_t)(arg1[18]) * ((arg2[4]) * 0x2));
    x265 = ((uint64_t)(arg1[18]) * (arg2[3]));
    x266 = ((uint64_t)(arg1[18]) * (arg2[2]));
    x267 = ((uint64_t)(arg1[18]) * ((arg2[1]) * 0x2));
    x268 = ((uint64_t)(arg1[18]) * (arg2[0]));
    x269 = ((uint64_t)(arg1[17]) * ((arg2[5]) * 0x2));
    x270 = ((uint64_t)(arg1[17]) * ((arg2[4]) * 0x2));
    x271 = ((uint64_t)(arg1[17]) * (arg2[3]));
    x272 = ((uint64_t)(arg1[17]) * ((arg2[2]) * 0x2));
    x273 = ((uint64_t)(arg1[17]) * ((arg2[1]) * 0x2));
    x274 = ((uint64_t)(arg1[17]) * (arg2[0]));
    x275 = ((uint64_t)(arg1[16]) * ((arg2[6]) * 0x2));
    x276 = ((uint64_t)(arg1[16]) * ((arg2[5]) * 0x2));
    x277 = ((uint64_t)(arg1[16]) * ((arg2[4]) * 0x2));
    x278 = ((uint64_t)(arg1[16]) * ((arg2[3]) * 0x2));
    x279 = ((uint64_t)(arg1[16]) * ((arg2[2]) * 0x2));
    x280 = ((uint64_t)(arg1[16]) * ((arg2[1]) * 0x2));
    x281 = ((uint64_t)(arg1[16]) * (arg2[0]));
    x282 = ((uint64_t)(arg1[15]) * (arg2[7]));
    x283 = ((uint64_t)(arg1[15]) * (arg2[6]));
    x284 = ((uint64_t)(arg1[15]) * (arg2[5]));
    x285 = ((uint64_t)(arg1[15]) * ((arg2[4]) * 0x2));
    x286 = ((uint64_t)(arg1[15]) * (arg2[3]));
    x287 = ((uint64_t)(arg1[15]) * (arg2[2]));
    x288 = ((uint64_t)(arg1[15]) * (arg2[1]));
    x289 = ((uint64_t)(arg1[15]) * (arg2[0]));
    x290 = ((uint64_t)(arg1[14]) * ((arg2[8]) * 0x2));
    x291 = ((uint64_t)(arg1[14]) * (arg2[7]));
    x292 = ((uint64_t)(arg1[14]) * (arg2[6]));
    x293 = ((uint64_t)(arg1[14]) * ((arg2[5]) * 0x2));
    x294 = ((uint64_t)(arg1[14]) * ((arg2[4]) * 0x2));
    x295 = ((uint64_t)(arg1[14]) * (arg2[3]));
    x296 = ((uint64_t)(arg1[14]) * (arg2[2]));
    x297 = ((uint64_t)(arg1[14]) * ((arg2[1]) * 0x2));
    x298 = ((uint64_t)(arg1[14]) * (arg2[0]));
    x299 = ((uint64_t)(arg1[13]) * ((arg2[9]) * 0x2));
    x300 = ((uint64_t)(arg1[13]) * ((arg2[8]) * 0x2));
    x301 = ((uint64_t)(arg1[13]) * (arg2[7]));
    x302 = ((uint64_t)(arg1[13]) * ((arg2[6]) * 0x2));
    x303 = ((uint64_t)(arg1[13]) * ((arg2[5]) * 0x2));
    x304 = ((uint64_t)(arg1[13]) * ((arg2[4]) * 0x2));
    x305 = ((uint64_t)(arg1[13]) * (arg2[3]));
    x306 = ((uint64_t)(arg1[13]) * ((arg2[2]) * 0x2));
    x307 = ((uint64_t)(arg1[13]) * ((arg2[1]) * 0x2));
    x308 = ((uint64_t)(arg1[13]) * (arg2[0]));
    x309 = ((uint64_t)(arg1[12]) * ((arg2[10]) * 0x2));
    x310 = ((uint64_t)(arg1[12]) * ((arg2[9]) * 0x2));
    x311 = ((uint64_t)(arg1[12]) * ((arg2[8]) * 0x2));
    x312 = ((uint64_t)(arg1[12]) * ((arg2[7]) * 0x2));
    x313 = ((uint64_t)(arg1[12]) * ((arg2[6]) * 0x2));
    x314 = ((uint64_t)(arg1[12]) * ((arg2[5]) * 0x2));
    x315 = ((uint64_t)(arg1[12]) * ((arg2[4]) * 0x2));
    x316 = ((uint64_t)(arg1[12]) * ((arg2[3]) * 0x2));
    x317 = ((uint64_t)(arg1[12]) * ((arg2[2]) * 0x2));
    x318 = ((uint64_t)(arg1[12]) * ((arg2[1]) * 0x2));
    x319 = ((uint64_t)(arg1[12]) * (arg2[0]));
    x320 = ((uint64_t)(arg1[11]) * (arg2[11]));
    x321 = ((uint64_t)(arg1[11]) * (arg2[10]));
    x322 = ((uint64_t)(arg1[11]) * (arg2[9]));
    x323 = ((uint64_t)(arg1[11]) * ((arg2[8]) * 0x2));
    x324 = ((uint64_t)(arg1[11]) * (arg2[7]));
    x325 = ((uint64_t)(arg1[11]) * (arg2[6]));
    x326 = ((uint64_t)(arg1[11]) * (arg2[5]));
    x327 = ((uint64_t)(arg1[11]) * ((arg2[4]) * 0x2));
    x328 = ((uint64_t)(arg1[11]) * (arg2[3]));
    x329 = ((uint64_t)(arg1[11]) * (arg2[2]));
    x330 = ((uint64_t)(arg1[11]) * (arg2[1]));
    x331 = ((uint64_t)(arg1[11]) * (arg2[0]));
    x332 = ((uint64_t)(arg1[10]) * ((arg2[12]) * 0x2));
    x333 = ((uint64_t)(arg1[10]) * (arg2[11]));
    x334 = ((uint64_t)(arg1[10]) * (arg2[10]));
    x335 = ((uint64_t)(arg1[10]) * ((arg2[9]) * 0x2));
    x336 = ((uint64_t)(arg1[10]) * ((arg2[8]) * 0x2));
    x337 = ((uint64_t)(arg1[10]) * (arg2[7]));
    x338 = ((uint64_t)(arg1[10]) * (arg2[6]));
    x339 = ((uint64_t)(arg1[10]) * ((arg2[5]) * 0x2));
    x340 = ((uint64_t)(arg1[10]) * ((arg2[4]) * 0x2));
    x341 = ((uint64_t)(arg1[10]) * (arg2[3]));
    x342 = ((uint64_t)(arg1[10]) * (arg2[2]));
    x343 = ((uint64_t)(arg1[10]) * ((arg2[1]) * 0x2));
    x344 = ((uint64_t)(arg1[10]) * (arg2[0]));
    x345 = ((uint64_t)(arg1[9]) * ((arg2[13]) * 0x2));
    x346 = ((uint64_t)(arg1[9]) * ((arg2[12]) * 0x2));
    x347 = ((uint64_t)(arg1[9]) * (arg2[11]));
    x348 = ((uint64_t)(arg1[9]) * ((arg2[10]) * 0x2));
    x349 = ((uint64_t)(arg1[9]) * ((arg2[9]) * 0x2));
    x350 = ((uint64_t)(arg1[9]) * ((arg2[8]) * 0x2));
    x351 = ((uint64_t)(arg1[9]) * (arg2[7]));
    x352 = ((uint64_t)(arg1[9]) * ((arg2[6]) * 0x2));
    x353 = ((uint64_t)(arg1[9]) * ((arg2[5]) * 0x2));
    x354 = ((uint64_t)(arg1[9]) * ((arg2[4]) * 0x2));
    x355 = ((uint64_t)(arg1[9]) * (arg2[3]));
    x356 = ((uint64_t)(arg1[9]) * ((arg2[2]) * 0x2));
    x357 = ((uint64_t)(arg1[9]) * ((arg2[1]) * 0x2));
    x358 = ((uint64_t)(arg1[9]) * (arg2[0]));
    x359 = ((uint64_t)(arg1[8]) * ((arg2[14]) * 0x2));
    x360 = ((uint64_t)(arg1[8]) * ((arg2[13]) * 0x2));
    x361 = ((uint64_t)(arg1[8]) * ((arg2[12]) * 0x2));
    x362 = ((uint64_t)(arg1[8]) * ((arg2[11]) * 0x2));
    x363 = ((uint64_t)(arg1[8]) * ((arg2[10]) * 0x2));
    x364 = ((uint64_t)(arg1[8]) * ((arg2[9]) * 0x2));
    x365 = ((uint64_t)(arg1[8]) * ((arg2[8]) * 0x2));
    x366 = ((uint64_t)(arg1[8]) * ((arg2[7]) * 0x2));
    x367 = ((uint64_t)(arg1[8]) * ((arg2[6]) * 0x2));
    x368 = ((uint64_t)(arg1[8]) * ((arg2[5]) * 0x2));
    x369 = ((uint64_t)(arg1[8]) * ((arg2[4]) * 0x2));
    x370 = ((uint64_t)(arg1[8]) * ((arg2[3]) * 0x2));
    x371 = ((uint64_t)(arg1[8]) * ((arg2[2]) * 0x2));
    x372 = ((uint64_t)(arg1[8]) * ((arg2[1]) * 0x2));
    x373 = ((uint64_t)(arg1[8]) * (arg2[0]));
    x374 = ((uint64_t)(arg1[7]) * (arg2[15]));
    x375 = ((uint64_t)(arg1[7]) * (arg2[14]));
    x376 = ((uint64_t)(arg1[7]) * (arg2[13]));
    x377 = ((uint64_t)(arg1[7]) * ((arg2[12]) * 0x2));
    x378 = ((uint64_t)(arg1[7]) * (arg2[11]));
    x379 = ((uint64_t)(arg1[7]) * (arg2[10]));
    x380 = ((uint64_t)(arg1[7]) * (arg2[9]));
    x381 = ((uint64_t)(arg1[7]) * ((arg2[8]) * 0x2));
    x382 = ((uint64_t)(arg1[7]) * (arg2[7]));
    x383 = ((uint64_t)(arg1[7]) * (arg2[6]));
    x384 = ((uint64_t)(arg1[7]) * (arg2[5]));
    x385 = ((uint64_t)(arg1[7]) * ((arg2[4]) * 0x2));
    x386 = ((uint64_t)(arg1[7]) * (arg2[3]));
    x387 = ((uint64_t)(arg1[7]) * (arg2[2]));
    x388 = ((uint64_t)(arg1[7]) * (arg2[1]));
    x389 = ((uint64_t)(arg1[7]) * (arg2[0]));
    x390 = ((uint64_t)(arg1[6]) * ((arg2[16]) * 0x2));
    x391 = ((uint64_t)(arg1[6]) * (arg2[15]));
    x392 = ((uint64_t)(arg1[6]) * (arg2[14]));
    x393 = ((uint64_t)(arg1[6]) * ((arg2[13]) * 0x2));
    x394 = ((uint64_t)(arg1[6]) * ((arg2[12]) * 0x2));
    x395 = ((uint64_t)(arg1[6]) * (arg2[11]));
    x396 = ((uint64_t)(arg1[6]) * (arg2[10]));
    x397 = ((uint64_t)(arg1[6]) * ((arg2[9]) * 0x2));
    x398 = ((uint64_t)(arg1[6]) * ((arg2[8]) * 0x2));
    x399 = ((uint64_t)(arg1[6]) * (arg2[7]));
    x400 = ((uint64_t)(arg1[6]) * (arg2[6]));
    x401 = ((uint64_t)(arg1[6]) * ((arg2[5]) * 0x2));
    x402 = ((uint64_t)(arg1[6]) * ((arg2[4]) * 0x2));
    x403 = ((uint64_t)(arg1[6]) * (arg2[3]));
    x404 = ((uint64_t)(arg1[6]) * (arg2[2]));
    x405 = ((uint64_t)(arg1[6]) * ((arg2[1]) * 0x2));
    x406 = ((uint64_t)(arg1[6]) * (arg2[0]));
    x407 = ((uint64_t)(arg1[5]) * ((arg2[17]) * 0x2));
    x408 = ((uint64_t)(arg1[5]) * ((arg2[16]) * 0x2));
    x409 = ((uint64_t)(arg1[5]) * (arg2[15]));
    x410 = ((uint64_t)(arg1[5]) * ((arg2[14]) * 0x2));
    x411 = ((uint64_t)(arg1[5]) * ((arg2[13]) * 0x2));
    x412 = ((uint64_t)(arg1[5]) * ((arg2[12]) * 0x2));
    x413 = ((uint64_t)(arg1[5]) * (arg2[11]));
    x414 = ((uint64_t)(arg1[5]) * ((arg2[10]) * 0x2));
    x415 = ((uint64_t)(arg1[5]) * ((arg2[9]) * 0x2));
    x416 = ((uint64_t)(arg1[5]) * ((arg2[8]) * 0x2));
    x417 = ((uint64_t)(arg1[5]) * (arg2[7]));
    x418 = ((uint64_t)(arg1[5]) * ((arg2[6]) * 0x2));
    x419 = ((uint64_t)(arg1[5]) * ((arg2[5]) * 0x2));
    x420 = ((uint64_t)(arg1[5]) * ((arg2[4]) * 0x2));
    x421 = ((uint64_t)(arg1[5]) * (arg2[3]));
    x422 = ((uint64_t)(arg1[5]) * ((arg2[2]) * 0x2));
    x423 = ((uint64_t)(arg1[5]) * ((arg2[1]) * 0x2));
    x424 = ((uint64_t)(arg1[5]) * (arg2[0]));
    x425 = ((uint64_t)(arg1[4]) * ((arg2[18]) * 0x2));
    x426 = ((uint64_t)(arg1[4]) * ((arg2[17]) * 0x2));
    x427 = ((uint64_t)(arg1[4]) * ((arg2[16]) * 0x2));
    x428 = ((uint64_t)(arg1[4]) * ((arg2[15]) * 0x2));
    x429 = ((uint64_t)(arg1[4]) * ((arg2[14]) * 0x2));
    x430 = ((uint64_t)(arg1[4]) * ((arg2[13]) * 0x2));
    x431 = ((uint64_t)(arg1[4]) * ((arg2[12]) * 0x2));
    x432 = ((uint64_t)(arg1[4]) * ((arg2[11]) * 0x2));
    x433 = ((uint64_t)(arg1[4]) * ((arg2[10]) * 0x2));
    x434 = ((uint64_t)(arg1[4]) * ((arg2[9]) * 0x2));
    x435 = ((uint64_t)(arg1[4]) * ((arg2[8]) * 0x2));
    x436 = ((uint64_t)(arg1[4]) * ((arg2[7]) * 0x2));
    x437 = ((uint64_t)(arg1[4]) * ((arg2[6]) * 0x2));
    x438 = ((uint64_t)(arg1[4]) * ((arg2[5]) * 0x2));
    x439 = ((uint64_t)(arg1[4]) * ((arg2[4]) * 0x2));
    x440 = ((uint64_t)(arg1[4]) * ((arg2[3]) * 0x2));
    x441 = ((uint64_t)(arg1[4]) * ((arg2[2]) * 0x2));
    x442 = ((uint64_t)(arg1[4]) * ((arg2[1]) * 0x2));
    x443 = ((uint64_t)(arg1[4]) * (arg2[0]));
    x444 = ((uint64_t)(arg1[3]) * (arg2[19]));
    x445 = ((uint64_t)(arg1[3]) * (arg2[18]));
    x446 = ((uint64_t)(arg1[3]) * (arg2[17]));
    x447 = ((uint64_t)(arg1[3]) * ((arg2[16]) * 0x2));
    x448 = ((uint64_t)(arg1[3]) * (arg2[15]));
    x449 = ((uint64_t)(arg1[3]) * (arg2[14]));
    x450 = ((uint64_t)(arg1[3]) * (arg2[13]));
    x451 = ((uint64_t)(arg1[3]) * ((arg2[12]) * 0x2));
    x452 = ((uint64_t)(arg1[3]) * (arg2[11]));
    x453 = ((uint64_t)(arg1[3]) * (arg2[10]));
    x454 = ((uint64_t)(arg1[3]) * (arg2[9]));
    x455 = ((uint64_t)(arg1[3]) * ((arg2[8]) * 0x2));
    x456 = ((uint64_t)(arg1[3]) * (arg2[7]));
    x457 = ((uint64_t)(arg1[3]) * (arg2[6]));
    x458 = ((uint64_t)(arg1[3]) * (arg2[5]));
    x459 = ((uint64_t)(arg1[3]) * ((arg2[4]) * 0x2));
    x460 = ((uint64_t)(arg1[3]) * (arg2[3]));
    x461 = ((uint64_t)(arg1[3]) * (arg2[2]));
    x462 = ((uint64_t)(arg1[3]) * (arg2[1]));
    x463 = ((uint64_t)(arg1[3]) * (arg2[0]));
    x464 = ((uint64_t)(arg1[2]) * ((arg2[20]) * 0x2));
    x465 = ((uint64_t)(arg1[2]) * (arg2[19]));
    x466 = ((uint64_t)(arg1[2]) * (arg2[18]));
    x467 = ((uint64_t)(arg1[2]) * ((arg2[17]) * 0x2));
    x468 = ((uint64_t)(arg1[2]) * ((arg2[16]) * 0x2));
    x469 = ((uint64_t)(arg1[2]) * (arg2[15]));
    x470 = ((uint64_t)(arg1[2]) * (arg2[14]));
    x471 = ((uint64_t)(arg1[2]) * ((arg2[13]) * 0x2));
    x472 = ((uint64_t)(arg1[2]) * ((arg2[12]) * 0x2));
    x473 = ((uint64_t)(arg1[2]) * (arg2[11]));
    x474 = ((uint64_t)(arg1[2]) * (arg2[10]));
    x475 = ((uint64_t)(arg1[2]) * ((arg2[9]) * 0x2));
    x476 = ((uint64_t)(arg1[2]) * ((arg2[8]) * 0x2));
    x477 = ((uint64_t)(arg1[2]) * (arg2[7]));
    x478 = ((uint64_t)(arg1[2]) * (arg2[6]));
    x479 = ((uint64_t)(arg1[2]) * ((arg2[5]) * 0x2));
    x480 = ((uint64_t)(arg1[2]) * ((arg2[4]) * 0x2));
    x481 = ((uint64_t)(arg1[2]) * (arg2[3]));
    x482 = ((uint64_t)(arg1[2]) * (arg2[2]));
    x483 = ((uint64_t)(arg1[2]) * ((arg2[1]) * 0x2));
    x484 = ((uint64_t)(arg1[2]) * (arg2[0]));
    x485 = ((uint64_t)(arg1[1]) * ((arg2[21]) * 0x2));
    x486 = ((uint64_t)(arg1[1]) * ((arg2[20]) * 0x2));
    x487 = ((uint64_t)(arg1[1]) * (arg2[19]));
    x488 = ((uint64_t)(arg1[1]) * ((arg2[18]) * 0x2));
    x489 = ((uint64_t)(arg1[1]) * ((arg2[17]) * 0x2));
    x490 = ((uint64_t)(arg1[1]) * ((arg2[16]) * 0x2));
    x491 = ((uint64_t)(arg1[1]) * (arg2[15]));
    x492 = ((uint64_t)(arg1[1]) * ((arg2[14]) * 0x2));
    x493 = ((uint64_t)(arg1[1]) * ((arg2[13]) * 0x2));
    x494 = ((uint64_t)(arg1[1]) * ((arg2[12]) * 0x2));
    x495 = ((uint64_t)(arg1[1]) * (arg2[11]));
    x496 = ((uint64_t)(arg1[1]) * ((arg2[10]) * 0x2));
    x497 = ((uint64_t)(arg1[1]) * ((arg2[9]) * 0x2));
    x498 = ((uint64_t)(arg1[1]) * ((arg2[8]) * 0x2));
    x499 = ((uint64_t)(arg1[1]) * (arg2[7]));
    x500 = ((uint64_t)(arg1[1]) * ((arg2[6]) * 0x2));
    x501 = ((uint64_t)(arg1[1]) * ((arg2[5]) * 0x2));
    x502 = ((uint64_t)(arg1[1]) * ((arg2[4]) * 0x2));
    x503 = ((uint64_t)(arg1[1]) * (arg2[3]));
    x504 = ((uint64_t)(arg1[1]) * ((arg2[2]) * 0x2));
    x505 = ((uint64_t)(arg1[1]) * ((arg2[1]) * 0x2));
    x506 = ((uint64_t)(arg1[1]) * (arg2[0]));
    x507 = ((uint64_t)(arg1[0]) * (arg2[22]));
    x508 = ((uint64_t)(arg1[0]) * (arg2[21]));
    x509 = ((uint64_t)(arg1[0]) * (arg2[20]));
    x510 = ((uint64_t)(arg1[0]) * (arg2[19]));
    x511 = ((uint64_t)(arg1[0]) * (arg2[18]));
    x512 = ((uint64_t)(arg1[0]) * (arg2[17]));
    x513 = ((uint64_t)(arg1[0]) * (arg2[16]));
    x514 = ((uint64_t)(arg1[0]) * (arg2[15]));
    x515 = ((uint64_t)(arg1[0]) * (arg2[14]));
    x516 = ((uint64_t)(arg1[0]) * (arg2[13]));
    x517 = ((uint64_t)(arg1[0]) * (arg2[12]));
    x518 = ((uint64_t)(arg1[0]) * (arg2[11]));
    x519 = ((uint64_t)(arg1[0]) * (arg2[10]));
    x520 = ((uint64_t)(arg1[0]) * (arg2[9]));
    x521 = ((uint64_t)(arg1[0]) * (arg2[8]));
    x522 = ((uint64_t)(arg1[0]) * (arg2[7]));
    x523 = ((uint64_t)(arg1[0]) * (arg2[6]));
    x524 = ((uint64_t)(arg1[0]) * (arg2[5]));
    x525 = ((uint64_t)(arg1[0]) * (arg2[4]));
    x526 = ((uint64_t)(arg1[0]) * (arg2[3]));
    x527 = ((uint64_t)(arg1[0]) * (arg2[2]));
    x528 = ((uint64_t)(arg1[0]) * (arg2[1]));
    x529 = ((uint64_t)(arg1[0]) * (arg2[0]));
    x530 = (x529 +
            (x253 +
             (x252 +
              (x250 +
               (x247 +
                (x243 +
                 (x238 +
                  (x232 +
                   (x225 +
                    (x217 +
                     (x208 +
                      (x198 +
                       (x187 +
                        (x175 +
                         (x162 +
                          (x148 +
                           (x133 +
                            (x117 +
                             (x100 +
                              (x82 + (x63 + (x43 + x22))))))))))))))))))))));
    x531 = (x530 >> 23);
    x532 = (uint32_t)(x530 & UINT32_C(0x7fffff));
    x533 =
        (x507 +
         (x485 +
          (x464 +
           (x444 +
            (x425 +
             (x407 +
              (x390 +
               (x374 +
                (x359 +
                 (x345 +
                  (x332 +
                   (x320 +
                    (x309 +
                     (x299 +
                      (x290 +
                       (x282 +
                        (x275 +
                         (x269 +
                          (x264 +
                           (x260 + (x257 + (x255 + x254))))))))))))))))))))));
    x534 = (x508 +
            (x486 +
             (x465 +
              (x445 +
               (x426 +
                (x408 +
                 (x391 +
                  (x375 +
                   (x360 +
                    (x346 +
                     (x333 +
                      (x321 +
                       (x310 +
                        (x300 +
                         (x291 +
                          (x283 +
                           (x276 +
                            (x270 +
                             (x265 +
                              (x261 + (x258 + (x256 + x1))))))))))))))))))))));
    x535 = (x509 +
            (x487 +
             (x466 +
              (x446 +
               (x427 +
                (x409 +
                 (x392 +
                  (x376 +
                   (x361 +
                    (x347 +
                     (x334 +
                      (x322 +
                       (x311 +
                        (x301 +
                         (x292 +
                          (x284 +
                           (x277 +
                            (x271 +
                             (x266 +
                              (x262 + (x259 + (x23 + x2))))))))))))))))))))));
    x536 = (x510 +
            (x488 +
             (x467 +
              (x447 +
               (x428 +
                (x410 +
                 (x393 +
                  (x377 +
                   (x362 +
                    (x348 +
                     (x335 +
                      (x323 +
                       (x312 +
                        (x302 +
                         (x293 +
                          (x285 +
                           (x278 +
                            (x272 +
                             (x267 +
                              (x263 + (x44 + (x24 + x3))))))))))))))))))))));
    x537 =
        (x511 +
         (x489 +
          (x468 +
           (x448 +
            (x429 +
             (x411 +
              (x394 +
               (x378 +
                (x363 +
                 (x349 +
                  (x336 +
                   (x324 +
                    (x313 +
                     (x303 +
                      (x294 +
                       (x286 +
                        (x279 +
                         (x273 +
                          (x268 + (x64 + (x45 + (x25 + x4))))))))))))))))))))));
    x538 =
        (x512 +
         (x490 +
          (x469 +
           (x449 +
            (x430 +
             (x412 +
              (x395 +
               (x379 +
                (x364 +
                 (x350 +
                  (x337 +
                   (x325 +
                    (x314 +
                     (x304 +
                      (x295 +
                       (x287 +
                        (x280 +
                         (x274 +
                          (x83 + (x65 + (x46 + (x26 + x5))))))))))))))))))))));
    x539 =
        (x513 +
         (x491 +
          (x470 +
           (x450 +
            (x431 +
             (x413 +
              (x396 +
               (x380 +
                (x365 +
                 (x351 +
                  (x338 +
                   (x326 +
                    (x315 +
                     (x305 +
                      (x296 +
                       (x288 +
                        (x281 +
                         (x101 +
                          (x84 + (x66 + (x47 + (x27 + x6))))))))))))))))))))));
    x540 =
        (x514 +
         (x492 +
          (x471 +
           (x451 +
            (x432 +
             (x414 +
              (x397 +
               (x381 +
                (x366 +
                 (x352 +
                  (x339 +
                   (x327 +
                    (x316 +
                     (x306 +
                      (x297 +
                       (x289 +
                        (x118 +
                         (x102 +
                          (x85 + (x67 + (x48 + (x28 + x7))))))))))))))))))))));
    x541 =
        (x515 +
         (x493 +
          (x472 +
           (x452 +
            (x433 +
             (x415 +
              (x398 +
               (x382 +
                (x367 +
                 (x353 +
                  (x340 +
                   (x328 +
                    (x317 +
                     (x307 +
                      (x298 +
                       (x134 +
                        (x119 +
                         (x103 +
                          (x86 + (x68 + (x49 + (x29 + x8))))))))))))))))))))));
    x542 =
        (x516 +
         (x494 +
          (x473 +
           (x453 +
            (x434 +
             (x416 +
              (x399 +
               (x383 +
                (x368 +
                 (x354 +
                  (x341 +
                   (x329 +
                    (x318 +
                     (x308 +
                      (x149 +
                       (x135 +
                        (x120 +
                         (x104 +
                          (x87 + (x69 + (x50 + (x30 + x9))))))))))))))))))))));
    x543 =
        (x517 +
         (x495 +
          (x474 +
           (x454 +
            (x435 +
             (x417 +
              (x400 +
               (x384 +
                (x369 +
                 (x355 +
                  (x342 +
                   (x330 +
                    (x319 +
                     (x163 +
                      (x150 +
                       (x136 +
                        (x121 +
                         (x105 +
                          (x88 + (x70 + (x51 + (x31 + x10))))))))))))))))))))));
    x544 =
        (x518 +
         (x496 +
          (x475 +
           (x455 +
            (x436 +
             (x418 +
              (x401 +
               (x385 +
                (x370 +
                 (x356 +
                  (x343 +
                   (x331 +
                    (x176 +
                     (x164 +
                      (x151 +
                       (x137 +
                        (x122 +
                         (x106 +
                          (x89 + (x71 + (x52 + (x32 + x11))))))))))))))))))))));
    x545 =
        (x519 +
         (x497 +
          (x476 +
           (x456 +
            (x437 +
             (x419 +
              (x402 +
               (x386 +
                (x371 +
                 (x357 +
                  (x344 +
                   (x188 +
                    (x177 +
                     (x165 +
                      (x152 +
                       (x138 +
                        (x123 +
                         (x107 +
                          (x90 + (x72 + (x53 + (x33 + x12))))))))))))))))))))));
    x546 =
        (x520 +
         (x498 +
          (x477 +
           (x457 +
            (x438 +
             (x420 +
              (x403 +
               (x387 +
                (x372 +
                 (x358 +
                  (x199 +
                   (x189 +
                    (x178 +
                     (x166 +
                      (x153 +
                       (x139 +
                        (x124 +
                         (x108 +
                          (x91 + (x73 + (x54 + (x34 + x13))))))))))))))))))))));
    x547 =
        (x521 +
         (x499 +
          (x478 +
           (x458 +
            (x439 +
             (x421 +
              (x404 +
               (x388 +
                (x373 +
                 (x209 +
                  (x200 +
                   (x190 +
                    (x179 +
                     (x167 +
                      (x154 +
                       (x140 +
                        (x125 +
                         (x109 +
                          (x92 + (x74 + (x55 + (x35 + x14))))))))))))))))))))));
    x548 =
        (x522 +
         (x500 +
          (x479 +
           (x459 +
            (x440 +
             (x422 +
              (x405 +
               (x389 +
                (x218 +
                 (x210 +
                  (x201 +
                   (x191 +
                    (x180 +
                     (x168 +
                      (x155 +
                       (x141 +
                        (x126 +
                         (x110 +
                          (x93 + (x75 + (x56 + (x36 + x15))))))))))))))))))))));
    x549 =
        (x523 +
         (x501 +
          (x480 +
           (x460 +
            (x441 +
             (x423 +
              (x406 +
               (x226 +
                (x219 +
                 (x211 +
                  (x202 +
                   (x192 +
                    (x181 +
                     (x169 +
                      (x156 +
                       (x142 +
                        (x127 +
                         (x111 +
                          (x94 + (x76 + (x57 + (x37 + x16))))))))))))))))))))));
    x550 =
        (x524 +
         (x502 +
          (x481 +
           (x461 +
            (x442 +
             (x424 +
              (x233 +
               (x227 +
                (x220 +
                 (x212 +
                  (x203 +
                   (x193 +
                    (x182 +
                     (x170 +
                      (x157 +
                       (x143 +
                        (x128 +
                         (x112 +
                          (x95 + (x77 + (x58 + (x38 + x17))))))))))))))))))))));
    x551 =
        (x525 +
         (x503 +
          (x482 +
           (x462 +
            (x443 +
             (x239 +
              (x234 +
               (x228 +
                (x221 +
                 (x213 +
                  (x204 +
                   (x194 +
                    (x183 +
                     (x171 +
                      (x158 +
                       (x144 +
                        (x129 +
                         (x113 +
                          (x96 + (x78 + (x59 + (x39 + x18))))))))))))))))))))));
    x552 =
        (x526 +
         (x504 +
          (x483 +
           (x463 +
            (x244 +
             (x240 +
              (x235 +
               (x229 +
                (x222 +
                 (x214 +
                  (x205 +
                   (x195 +
                    (x184 +
                     (x172 +
                      (x159 +
                       (x145 +
                        (x130 +
                         (x114 +
                          (x97 + (x79 + (x60 + (x40 + x19))))))))))))))))))))));
    x553 =
        (x527 +
         (x505 +
          (x484 +
           (x248 +
            (x245 +
             (x241 +
              (x236 +
               (x230 +
                (x223 +
                 (x215 +
                  (x206 +
                   (x196 +
                    (x185 +
                     (x173 +
                      (x160 +
                       (x146 +
                        (x131 +
                         (x115 +
                          (x98 + (x80 + (x61 + (x41 + x20))))))))))))))))))))));
    x554 =
        (x528 +
         (x506 +
          (x251 +
           (x249 +
            (x246 +
             (x242 +
              (x237 +
               (x231 +
                (x224 +
                 (x216 +
                  (x207 +
                   (x197 +
                    (x186 +
                     (x174 +
                      (x161 +
                       (x147 +
                        (x132 +
                         (x116 +
                          (x99 + (x81 + (x62 + (x42 + x21))))))))))))))))))))));
    x555 = (x531 + x554);
    x556 = (x555 >> 22);
    x557 = (uint32_t)(x555 & UINT32_C(0x3fffff));
    x558 = (x556 + x553);
    x559 = (x558 >> 22);
    x560 = (uint32_t)(x558 & UINT32_C(0x3fffff));
    x561 = (x559 + x552);
    x562 = (x561 >> 23);
    x563 = (uint32_t)(x561 & UINT32_C(0x7fffff));
    x564 = (x562 + x551);
    x565 = (x564 >> 22);
    x566 = (uint32_t)(x564 & UINT32_C(0x3fffff));
    x567 = (x565 + x550);
    x568 = (x567 >> 22);
    x569 = (uint32_t)(x567 & UINT32_C(0x3fffff));
    x570 = (x568 + x549);
    x571 = (x570 >> 22);
    x572 = (uint32_t)(x570 & UINT32_C(0x3fffff));
    x573 = (x571 + x548);
    x574 = (x573 >> 23);
    x575 = (uint32_t)(x573 & UINT32_C(0x7fffff));
    x576 = (x574 + x547);
    x577 = (x576 >> 22);
    x578 = (uint32_t)(x576 & UINT32_C(0x3fffff));
    x579 = (x577 + x546);
    x580 = (x579 >> 22);
    x581 = (uint32_t)(x579 & UINT32_C(0x3fffff));
    x582 = (x580 + x545);
    x583 = (x582 >> 22);
    x584 = (uint32_t)(x582 & UINT32_C(0x3fffff));
    x585 = (x583 + x544);
    x586 = (x585 >> 23);
    x587 = (uint32_t)(x585 & UINT32_C(0x7fffff));
    x588 = (x586 + x543);
    x589 = (x588 >> 22);
    x590 = (uint32_t)(x588 & UINT32_C(0x3fffff));
    x591 = (x589 + x542);
    x592 = (x591 >> 22);
    x593 = (uint32_t)(x591 & UINT32_C(0x3fffff));
    x594 = (x592 + x541);
    x595 = (x594 >> 22);
    x596 = (uint32_t)(x594 & UINT32_C(0x3fffff));
    x597 = (x595 + x540);
    x598 = (x597 >> 23);
    x599 = (uint32_t)(x597 & UINT32_C(0x7fffff));
    x600 = (x598 + x539);
    x601 = (x600 >> 22);
    x602 = (uint32_t)(x600 & UINT32_C(0x3fffff));
    x603 = (x601 + x538);
    x604 = (x603 >> 22);
    x605 = (uint32_t)(x603 & UINT32_C(0x3fffff));
    x606 = (x604 + x537);
    x607 = (x606 >> 22);
    x608 = (uint32_t)(x606 & UINT32_C(0x3fffff));
    x609 = (x607 + x536);
    x610 = (x609 >> 23);
    x611 = (uint32_t)(x609 & UINT32_C(0x7fffff));
    x612 = (x610 + x535);
    x613 = (x612 >> 22);
    x614 = (uint32_t)(x612 & UINT32_C(0x3fffff));
    x615 = (x613 + x534);
    x616 = (x615 >> 22);
    x617 = (uint32_t)(x615 & UINT32_C(0x3fffff));
    x618 = (x616 + x533);
    x619 = (uint32_t)(x618 >> 22);
    x620 = (uint32_t)(x618 & UINT32_C(0x3fffff));
    x621 = ((uint64_t)UINT16_C(0x239) * x619);
    x622 = (x532 + x621);
    x623 = (uint32_t)(x622 >> 23);
    x624 = (uint32_t)(x622 & UINT32_C(0x7fffff));
    x625 = (x623 + x557);
    x626 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x625 >> 22);
    x627 = (x625 & UINT32_C(0x3fffff));
    x628 = (x626 + x560);
    out1[0] = x624;
    out1[1] = x627;
    out1[2] = x628;
    out1[3] = x563;
    out1[4] = x566;
    out1[5] = x569;
    out1[6] = x572;
    out1[7] = x575;
    out1[8] = x578;
    out1[9] = x581;
    out1[10] = x584;
    out1[11] = x587;
    out1[12] = x590;
    out1[13] = x593;
    out1[14] = x596;
    out1[15] = x599;
    out1[16] = x602;
    out1[17] = x605;
    out1[18] = x608;
    out1[19] = x611;
    out1[20] = x614;
    out1[21] = x617;
    out1[22] = x620;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square squares a field element and reduces the result.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(
    uint32_t out1[23], const uint32_t arg1[23]) {
    uint64_t x1;
    uint64_t x2;
    uint32_t x3;
    uint64_t x4;
    uint64_t x5;
    uint32_t x6;
    uint64_t x7;
    uint64_t x8;
    uint32_t x9;
    uint64_t x10;
    uint64_t x11;
    uint32_t x12;
    uint64_t x13;
    uint64_t x14;
    uint32_t x15;
    uint64_t x16;
    uint64_t x17;
    uint32_t x18;
    uint64_t x19;
    uint64_t x20;
    uint32_t x21;
    uint64_t x22;
    uint64_t x23;
    uint32_t x24;
    uint64_t x25;
    uint64_t x26;
    uint32_t x27;
    uint64_t x28;
    uint64_t x29;
    uint32_t x30;
    uint64_t x31;
    uint64_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    uint64_t x87;
    uint64_t x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    uint64_t x136;
    uint64_t x137;
    uint64_t x138;
    uint64_t x139;
    uint64_t x140;
    uint64_t x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    uint64_t x170;
    uint64_t x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    uint64_t x176;
    uint64_t x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    uint64_t x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    uint64_t x202;
    uint64_t x203;
    uint64_t x204;
    uint64_t x205;
    uint64_t x206;
    uint64_t x207;
    uint64_t x208;
    uint64_t x209;
    uint64_t x210;
    uint64_t x211;
    uint64_t x212;
    uint64_t x213;
    uint64_t x214;
    uint64_t x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    uint64_t x220;
    uint64_t x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    uint64_t x236;
    uint64_t x237;
    uint64_t x238;
    uint64_t x239;
    uint64_t x240;
    uint64_t x241;
    uint64_t x242;
    uint64_t x243;
    uint64_t x244;
    uint64_t x245;
    uint64_t x246;
    uint64_t x247;
    uint64_t x248;
    uint64_t x249;
    uint64_t x250;
    uint64_t x251;
    uint64_t x252;
    uint64_t x253;
    uint64_t x254;
    uint64_t x255;
    uint64_t x256;
    uint64_t x257;
    uint64_t x258;
    uint64_t x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    uint64_t x268;
    uint64_t x269;
    uint64_t x270;
    uint64_t x271;
    uint64_t x272;
    uint64_t x273;
    uint64_t x274;
    uint64_t x275;
    uint64_t x276;
    uint64_t x277;
    uint64_t x278;
    uint64_t x279;
    uint64_t x280;
    uint64_t x281;
    uint64_t x282;
    uint64_t x283;
    uint64_t x284;
    uint64_t x285;
    uint64_t x286;
    uint64_t x287;
    uint64_t x288;
    uint64_t x289;
    uint64_t x290;
    uint64_t x291;
    uint64_t x292;
    uint64_t x293;
    uint64_t x294;
    uint64_t x295;
    uint64_t x296;
    uint64_t x297;
    uint64_t x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    uint64_t x302;
    uint64_t x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    uint64_t x310;
    uint64_t x311;
    uint64_t x312;
    uint64_t x313;
    uint64_t x314;
    uint64_t x315;
    uint64_t x316;
    uint64_t x317;
    uint64_t x318;
    uint64_t x319;
    uint64_t x320;
    uint64_t x321;
    uint64_t x322;
    uint32_t x323;
    uint64_t x324;
    uint64_t x325;
    uint64_t x326;
    uint64_t x327;
    uint64_t x328;
    uint64_t x329;
    uint64_t x330;
    uint64_t x331;
    uint64_t x332;
    uint64_t x333;
    uint64_t x334;
    uint64_t x335;
    uint64_t x336;
    uint64_t x337;
    uint64_t x338;
    uint64_t x339;
    uint64_t x340;
    uint64_t x341;
    uint64_t x342;
    uint64_t x343;
    uint64_t x344;
    uint64_t x345;
    uint64_t x346;
    uint64_t x347;
    uint32_t x348;
    uint64_t x349;
    uint64_t x350;
    uint32_t x351;
    uint64_t x352;
    uint64_t x353;
    uint32_t x354;
    uint64_t x355;
    uint64_t x356;
    uint32_t x357;
    uint64_t x358;
    uint64_t x359;
    uint32_t x360;
    uint64_t x361;
    uint64_t x362;
    uint32_t x363;
    uint64_t x364;
    uint64_t x365;
    uint32_t x366;
    uint64_t x367;
    uint64_t x368;
    uint32_t x369;
    uint64_t x370;
    uint64_t x371;
    uint32_t x372;
    uint64_t x373;
    uint64_t x374;
    uint32_t x375;
    uint64_t x376;
    uint64_t x377;
    uint32_t x378;
    uint64_t x379;
    uint64_t x380;
    uint32_t x381;
    uint64_t x382;
    uint64_t x383;
    uint32_t x384;
    uint64_t x385;
    uint64_t x386;
    uint32_t x387;
    uint64_t x388;
    uint64_t x389;
    uint32_t x390;
    uint64_t x391;
    uint64_t x392;
    uint32_t x393;
    uint64_t x394;
    uint64_t x395;
    uint32_t x396;
    uint64_t x397;
    uint64_t x398;
    uint32_t x399;
    uint64_t x400;
    uint64_t x401;
    uint32_t x402;
    uint64_t x403;
    uint64_t x404;
    uint32_t x405;
    uint64_t x406;
    uint64_t x407;
    uint32_t x408;
    uint64_t x409;
    uint32_t x410;
    uint32_t x411;
    uint64_t x412;
    uint64_t x413;
    uint32_t x414;
    uint32_t x415;
    uint32_t x416;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x417;
    uint32_t x418;
    uint32_t x419;
    x1 = ((uint64_t)(arg1[22]) * UINT16_C(0x239));
    x2 = (x1 * 0x2);
    x3 = ((arg1[22]) * 0x2);
    x4 = ((uint64_t)(arg1[21]) * UINT16_C(0x239));
    x5 = (x4 * 0x2);
    x6 = ((arg1[21]) * 0x2);
    x7 = ((uint64_t)(arg1[20]) * UINT16_C(0x239));
    x8 = (x7 * 0x2);
    x9 = ((arg1[20]) * 0x2);
    x10 = ((uint64_t)(arg1[19]) * UINT16_C(0x239));
    x11 = (x10 * 0x2);
    x12 = ((arg1[19]) * 0x2);
    x13 = ((uint64_t)(arg1[18]) * UINT16_C(0x239));
    x14 = (x13 * 0x2);
    x15 = ((arg1[18]) * 0x2);
    x16 = ((uint64_t)(arg1[17]) * UINT16_C(0x239));
    x17 = (x16 * 0x2);
    x18 = ((arg1[17]) * 0x2);
    x19 = ((uint64_t)(arg1[16]) * UINT16_C(0x239));
    x20 = (x19 * 0x2);
    x21 = ((arg1[16]) * 0x2);
    x22 = ((uint64_t)(arg1[15]) * UINT16_C(0x239));
    x23 = (x22 * 0x2);
    x24 = ((arg1[15]) * 0x2);
    x25 = ((uint64_t)(arg1[14]) * UINT16_C(0x239));
    x26 = (x25 * 0x2);
    x27 = ((arg1[14]) * 0x2);
    x28 = ((uint64_t)(arg1[13]) * UINT16_C(0x239));
    x29 = (x28 * 0x2);
    x30 = ((arg1[13]) * 0x2);
    x31 = ((uint64_t)(arg1[12]) * UINT16_C(0x239));
    x32 = (x31 * 0x2);
    x33 = ((arg1[12]) * 0x2);
    x34 = ((arg1[11]) * 0x2);
    x35 = ((arg1[10]) * 0x2);
    x36 = ((arg1[9]) * 0x2);
    x37 = ((arg1[8]) * 0x2);
    x38 = ((arg1[7]) * 0x2);
    x39 = ((arg1[6]) * 0x2);
    x40 = ((arg1[5]) * 0x2);
    x41 = ((arg1[4]) * 0x2);
    x42 = ((arg1[3]) * 0x2);
    x43 = ((arg1[2]) * 0x2);
    x44 = ((arg1[1]) * 0x2);
    x45 = ((arg1[22]) * x1);
    x46 = ((arg1[21]) * x2);
    x47 = ((arg1[21]) * (x4 * 0x2));
    x48 = ((arg1[20]) * (x2 * 0x2));
    x49 = ((arg1[20]) * (x5 * 0x2));
    x50 = ((arg1[20]) * (x7 * 0x2));
    x51 = ((arg1[19]) * x2);
    x52 = ((arg1[19]) * x5);
    x53 = ((arg1[19]) * x8);
    x54 = ((arg1[19]) * x10);
    x55 = ((arg1[18]) * x2);
    x56 = ((arg1[18]) * x5);
    x57 = ((arg1[18]) * (x8 * 0x2));
    x58 = ((arg1[18]) * x11);
    x59 = ((arg1[18]) * x13);
    x60 = ((arg1[17]) * x2);
    x61 = ((arg1[17]) * (x5 * 0x2));
    x62 = ((arg1[17]) * (x8 * 0x2));
    x63 = ((arg1[17]) * x11);
    x64 = ((arg1[17]) * x14);
    x65 = ((arg1[17]) * (x16 * 0x2));
    x66 = ((arg1[16]) * (x2 * 0x2));
    x67 = ((arg1[16]) * (x5 * 0x2));
    x68 = ((arg1[16]) * (x8 * 0x2));
    x69 = ((arg1[16]) * x11);
    x70 = ((arg1[16]) * (x14 * 0x2));
    x71 = ((arg1[16]) * (x17 * 0x2));
    x72 = ((arg1[16]) * (x19 * 0x2));
    x73 = ((arg1[15]) * x2);
    x74 = ((arg1[15]) * x5);
    x75 = ((arg1[15]) * x8);
    x76 = ((arg1[15]) * x11);
    x77 = ((arg1[15]) * x14);
    x78 = ((arg1[15]) * x17);
    x79 = ((arg1[15]) * x20);
    x80 = ((arg1[15]) * x22);
    x81 = ((arg1[14]) * x2);
    x82 = ((arg1[14]) * x5);
    x83 = ((arg1[14]) * (x8 * 0x2));
    x84 = ((arg1[14]) * x11);
    x85 = ((arg1[14]) * x14);
    x86 = ((arg1[14]) * x17);
    x87 = ((arg1[14]) * (x20 * 0x2));
    x88 = ((arg1[14]) * x23);
    x89 = ((arg1[14]) * x25);
    x90 = ((arg1[13]) * x2);
    x91 = ((arg1[13]) * (x5 * 0x2));
    x92 = ((arg1[13]) * (x8 * 0x2));
    x93 = ((arg1[13]) * x11);
    x94 = ((arg1[13]) * x14);
    x95 = ((arg1[13]) * (x17 * 0x2));
    x96 = ((arg1[13]) * (x20 * 0x2));
    x97 = ((arg1[13]) * x23);
    x98 = ((arg1[13]) * x26);
    x99 = ((arg1[13]) * (x28 * 0x2));
    x100 = ((arg1[12]) * (x2 * 0x2));
    x101 = ((arg1[12]) * (x5 * 0x2));
    x102 = ((arg1[12]) * (x8 * 0x2));
    x103 = ((arg1[12]) * x11);
    x104 = ((arg1[12]) * (x14 * 0x2));
    x105 = ((arg1[12]) * (x17 * 0x2));
    x106 = ((arg1[12]) * (x20 * 0x2));
    x107 = ((arg1[12]) * x23);
    x108 = ((arg1[12]) * (x26 * 0x2));
    x109 = ((arg1[12]) * (x29 * 0x2));
    x110 = ((arg1[12]) * (x31 * 0x2));
    x111 = ((arg1[11]) * x2);
    x112 = ((arg1[11]) * x5);
    x113 = ((arg1[11]) * x8);
    x114 = ((arg1[11]) * x11);
    x115 = ((arg1[11]) * x14);
    x116 = ((arg1[11]) * x17);
    x117 = ((arg1[11]) * x20);
    x118 = ((arg1[11]) * x23);
    x119 = ((arg1[11]) * x26);
    x120 = ((arg1[11]) * x29);
    x121 = ((arg1[11]) * (x32 * 0x2));
    x122 = ((uint64_t)(arg1[11]) * (arg1[11]));
    x123 = ((arg1[10]) * x2);
    x124 = ((arg1[10]) * x5);
    x125 = ((arg1[10]) * (x8 * 0x2));
    x126 = ((arg1[10]) * x11);
    x127 = ((arg1[10]) * x14);
    x128 = ((arg1[10]) * x17);
    x129 = ((arg1[10]) * (x20 * 0x2));
    x130 = ((arg1[10]) * x23);
    x131 = ((arg1[10]) * x26);
    x132 = ((arg1[10]) * (x29 * 0x2));
    x133 = ((uint64_t)(arg1[10]) * (x33 * 0x2));
    x134 = ((uint64_t)(arg1[10]) * x34);
    x135 = ((uint64_t)(arg1[10]) * (arg1[10]));
    x136 = ((arg1[9]) * x2);
    x137 = ((arg1[9]) * (x5 * 0x2));
    x138 = ((arg1[9]) * (x8 * 0x2));
    x139 = ((arg1[9]) * x11);
    x140 = ((arg1[9]) * x14);
    x141 = ((arg1[9]) * (x17 * 0x2));
    x142 = ((arg1[9]) * (x20 * 0x2));
    x143 = ((arg1[9]) * x23);
    x144 = ((arg1[9]) * (x26 * 0x2));
    x145 = ((uint64_t)(arg1[9]) * (x30 * 0x2));
    x146 = ((uint64_t)(arg1[9]) * (x33 * 0x2));
    x147 = ((uint64_t)(arg1[9]) * x34);
    x148 = ((uint64_t)(arg1[9]) * (x35 * 0x2));
    x149 = ((uint64_t)(arg1[9]) * ((arg1[9]) * 0x2));
    x150 = ((arg1[8]) * (x2 * 0x2));
    x151 = ((arg1[8]) * (x5 * 0x2));
    x152 = ((arg1[8]) * (x8 * 0x2));
    x153 = ((arg1[8]) * x11);
    x154 = ((arg1[8]) * (x14 * 0x2));
    x155 = ((arg1[8]) * (x17 * 0x2));
    x156 = ((arg1[8]) * (x20 * 0x2));
    x157 = ((arg1[8]) * (x23 * 0x2));
    x158 = ((uint64_t)(arg1[8]) * (x27 * 0x2));
    x159 = ((uint64_t)(arg1[8]) * (x30 * 0x2));
    x160 = ((uint64_t)(arg1[8]) * (x33 * 0x2));
    x161 = ((uint64_t)(arg1[8]) * (x34 * 0x2));
    x162 = ((uint64_t)(arg1[8]) * (x35 * 0x2));
    x163 = ((uint64_t)(arg1[8]) * (x36 * 0x2));
    x164 = ((uint64_t)(arg1[8]) * ((arg1[8]) * 0x2));
    x165 = ((arg1[7]) * x2);
    x166 = ((arg1[7]) * x5);
    x167 = ((arg1[7]) * x8);
    x168 = ((arg1[7]) * x11);
    x169 = ((arg1[7]) * x14);
    x170 = ((arg1[7]) * x17);
    x171 = ((arg1[7]) * (x20 * 0x2));
    x172 = ((uint64_t)(arg1[7]) * x24);
    x173 = ((uint64_t)(arg1[7]) * x27);
    x174 = ((uint64_t)(arg1[7]) * x30);
    x175 = ((uint64_t)(arg1[7]) * (x33 * 0x2));
    x176 = ((uint64_t)(arg1[7]) * x34);
    x177 = ((uint64_t)(arg1[7]) * x35);
    x178 = ((uint64_t)(arg1[7]) * x36);
    x179 = ((uint64_t)(arg1[7]) * (x37 * 0x2));
    x180 = ((uint64_t)(arg1[7]) * (arg1[7]));
    x181 = ((arg1[6]) * x2);
    x182 = ((arg1[6]) * x5);
    x183 = ((arg1[6]) * (x8 * 0x2));
    x184 = ((arg1[6]) * x11);
    x185 = ((arg1[6]) * x14);
    x186 = ((arg1[6]) * (x17 * 0x2));
    x187 = ((uint64_t)(arg1[6]) * (x21 * 0x2));
    x188 = ((uint64_t)(arg1[6]) * x24);
    x189 = ((uint64_t)(arg1[6]) * x27);
    x190 = ((uint64_t)(arg1[6]) * (x30 * 0x2));
    x191 = ((uint64_t)(arg1[6]) * (x33 * 0x2));
    x192 = ((uint64_t)(arg1[6]) * x34);
    x193 = ((uint64_t)(arg1[6]) * x35);
    x194 = ((uint64_t)(arg1[6]) * (x36 * 0x2));
    x195 = ((uint64_t)(arg1[6]) * (x37 * 0x2));
    x196 = ((uint64_t)(arg1[6]) * x38);
    x197 = ((uint64_t)(arg1[6]) * (arg1[6]));
    x198 = ((arg1[5]) * x2);
    x199 = ((arg1[5]) * (x5 * 0x2));
    x200 = ((arg1[5]) * (x8 * 0x2));
    x201 = ((arg1[5]) * x11);
    x202 = ((arg1[5]) * (x14 * 0x2));
    x203 = ((uint64_t)(arg1[5]) * (x18 * 0x2));
    x204 = ((uint64_t)(arg1[5]) * (x21 * 0x2));
    x205 = ((uint64_t)(arg1[5]) * x24);
    x206 = ((uint64_t)(arg1[5]) * (x27 * 0x2));
    x207 = ((uint64_t)(arg1[5]) * (x30 * 0x2));
    x208 = ((uint64_t)(arg1[5]) * (x33 * 0x2));
    x209 = ((uint64_t)(arg1[5]) * x34);
    x210 = ((uint64_t)(arg1[5]) * (x35 * 0x2));
    x211 = ((uint64_t)(arg1[5]) * (x36 * 0x2));
    x212 = ((uint64_t)(arg1[5]) * (x37 * 0x2));
    x213 = ((uint64_t)(arg1[5]) * x38);
    x214 = ((uint64_t)(arg1[5]) * (x39 * 0x2));
    x215 = ((uint64_t)(arg1[5]) * ((arg1[5]) * 0x2));
    x216 = ((arg1[4]) * (x2 * 0x2));
    x217 = ((arg1[4]) * (x5 * 0x2));
    x218 = ((arg1[4]) * (x8 * 0x2));
    x219 = ((arg1[4]) * (x11 * 0x2));
    x220 = ((uint64_t)(arg1[4]) * (x15 * 0x2));
    x221 = ((uint64_t)(arg1[4]) * (x18 * 0x2));
    x222 = ((uint64_t)(arg1[4]) * (x21 * 0x2));
    x223 = ((uint64_t)(arg1[4]) * (x24 * 0x2));
    x224 = ((uint64_t)(arg1[4]) * (x27 * 0x2));
    x225 = ((uint64_t)(arg1[4]) * (x30 * 0x2));
    x226 = ((uint64_t)(arg1[4]) * (x33 * 0x2));
    x227 = ((uint64_t)(arg1[4]) * (x34 * 0x2));
    x228 = ((uint64_t)(arg1[4]) * (x35 * 0x2));
    x229 = ((uint64_t)(arg1[4]) * (x36 * 0x2));
    x230 = ((uint64_t)(arg1[4]) * (x37 * 0x2));
    x231 = ((uint64_t)(arg1[4]) * (x38 * 0x2));
    x232 = ((uint64_t)(arg1[4]) * (x39 * 0x2));
    x233 = ((uint64_t)(arg1[4]) * (x40 * 0x2));
    x234 = ((uint64_t)(arg1[4]) * ((arg1[4]) * 0x2));
    x235 = ((arg1[3]) * x2);
    x236 = ((arg1[3]) * x5);
    x237 = ((arg1[3]) * (x8 * 0x2));
    x238 = ((uint64_t)(arg1[3]) * x12);
    x239 = ((uint64_t)(arg1[3]) * x15);
    x240 = ((uint64_t)(arg1[3]) * x18);
    x241 = ((uint64_t)(arg1[3]) * (x21 * 0x2));
    x242 = ((uint64_t)(arg1[3]) * x24);
    x243 = ((uint64_t)(arg1[3]) * x27);
    x244 = ((uint64_t)(arg1[3]) * x30);
    x245 = ((uint64_t)(arg1[3]) * (x33 * 0x2));
    x246 = ((uint64_t)(arg1[3]) * x34);
    x247 = ((uint64_t)(arg1[3]) * x35);
    x248 = ((uint64_t)(arg1[3]) * x36);
    x249 = ((uint64_t)(arg1[3]) * (x37 * 0x2));
    x250 = ((uint64_t)(arg1[3]) * x38);
    x251 = ((uint64_t)(arg1[3]) * x39);
    x252 = ((uint64_t)(arg1[3]) * x40);
    x253 = ((uint64_t)(arg1[3]) * (x41 * 0x2));
    x254 = ((uint64_t)(arg1[3]) * (arg1[3]));
    x255 = ((arg1[2]) * x2);
    x256 = ((arg1[2]) * (x5 * 0x2));
    x257 = ((uint64_t)(arg1[2]) * (x9 * 0x2));
    x258 = ((uint64_t)(arg1[2]) * x12);
    x259 = ((uint64_t)(arg1[2]) * x15);
    x260 = ((uint64_t)(arg1[2]) * (x18 * 0x2));
    x261 = ((uint64_t)(arg1[2]) * (x21 * 0x2));
    x262 = ((uint64_t)(arg1[2]) * x24);
    x263 = ((uint64_t)(arg1[2]) * x27);
    x264 = ((uint64_t)(arg1[2]) * (x30 * 0x2));
    x265 = ((uint64_t)(arg1[2]) * (x33 * 0x2));
    x266 = ((uint64_t)(arg1[2]) * x34);
    x267 = ((uint64_t)(arg1[2]) * x35);
    x268 = ((uint64_t)(arg1[2]) * (x36 * 0x2));
    x269 = ((uint64_t)(arg1[2]) * (x37 * 0x2));
    x270 = ((uint64_t)(arg1[2]) * x38);
    x271 = ((uint64_t)(arg1[2]) * x39);
    x272 = ((uint64_t)(arg1[2]) * (x40 * 0x2));
    x273 = ((uint64_t)(arg1[2]) * (x41 * 0x2));
    x274 = ((uint64_t)(arg1[2]) * x42);
    x275 = ((uint64_t)(arg1[2]) * (arg1[2]));
    x276 = ((arg1[1]) * (x2 * 0x2));
    x277 = ((uint64_t)(arg1[1]) * (x6 * 0x2));
    x278 = ((uint64_t)(arg1[1]) * (x9 * 0x2));
    x279 = ((uint64_t)(arg1[1]) * x12);
    x280 = ((uint64_t)(arg1[1]) * (x15 * 0x2));
    x281 = ((uint64_t)(arg1[1]) * (x18 * 0x2));
    x282 = ((uint64_t)(arg1[1]) * (x21 * 0x2));
    x283 = ((uint64_t)(arg1[1]) * x24);
    x284 = ((uint64_t)(arg1[1]) * (x27 * 0x2));
    x285 = ((uint64_t)(arg1[1]) * (x30 * 0x2));
    x286 = ((uint64_t)(arg1[1]) * (x33 * 0x2));
    x287 = ((uint64_t)(arg1[1]) * x34);
    x288 = ((uint64_t)(arg1[1]) * (x35 * 0x2));
    x289 = ((uint64_t)(arg1[1]) * (x36 * 0x2));
    x290 = ((uint64_t)(arg1[1]) * (x37 * 0x2));
    x291 = ((uint64_t)(arg1[1]) * x38);
    x292 = ((uint64_t)(arg1[1]) * (x39 * 0x2));
    x293 = ((uint64_t)(arg1[1]) * (x40 * 0x2));
    x294 = ((uint64_t)(arg1[1]) * (x41 * 0x2));
    x295 = ((uint64_t)(arg1[1]) * x42);
    x296 = ((uint64_t)(arg1[1]) * (x43 * 0x2));
    x297 = ((uint64_t)(arg1[1]) * ((arg1[1]) * 0x2));
    x298 = ((uint64_t)(arg1[0]) * x3);
    x299 = ((uint64_t)(arg1[0]) * x6);
    x300 = ((uint64_t)(arg1[0]) * x9);
    x301 = ((uint64_t)(arg1[0]) * x12);
    x302 = ((uint64_t)(arg1[0]) * x15);
    x303 = ((uint64_t)(arg1[0]) * x18);
    x304 = ((uint64_t)(arg1[0]) * x21);
    x305 = ((uint64_t)(arg1[0]) * x24);
    x306 = ((uint64_t)(arg1[0]) * x27);
    x307 = ((uint64_t)(arg1[0]) * x30);
    x308 = ((uint64_t)(arg1[0]) * x33);
    x309 = ((uint64_t)(arg1[0]) * x34);
    x310 = ((uint64_t)(arg1[0]) * x35);
    x311 = ((uint64_t)(arg1[0]) * x36);
    x312 = ((uint64_t)(arg1[0]) * x37);
    x313 = ((uint64_t)(arg1[0]) * x38);
    x314 = ((uint64_t)(arg1[0]) * x39);
    x315 = ((uint64_t)(arg1[0]) * x40);
    x316 = ((uint64_t)(arg1[0]) * x41);
    x317 = ((uint64_t)(arg1[0]) * x42);
    x318 = ((uint64_t)(arg1[0]) * x43);
    x319 = ((uint64_t)(arg1[0]) * x44);
    x320 = ((uint64_t)(arg1[0]) * (arg1[0]));
    x321 = (x320 +
            (x276 +
             (x256 +
              (x237 +
               (x219 +
                (x202 + (x186 + (x171 + (x157 + (x144 + (x132 + x121)))))))))));
    x322 = (x321 >> 23);
    x323 = (uint32_t)(x321 & UINT32_C(0x7fffff));
    x324 = (x298 +
            (x277 +
             (x257 +
              (x238 +
               (x220 +
                (x203 + (x187 + (x172 + (x158 + (x145 + (x133 + x122)))))))))));
    x325 = (x299 +
            (x278 +
             (x258 +
              (x239 +
               (x221 +
                (x204 + (x188 + (x173 + (x159 + (x146 + (x134 + x45)))))))))));
    x326 = (x300 +
            (x279 +
             (x259 +
              (x240 +
               (x222 +
                (x205 + (x189 + (x174 + (x160 + (x147 + (x135 + x46)))))))))));
    x327 = (x301 +
            (x280 +
             (x260 +
              (x241 +
               (x223 +
                (x206 + (x190 + (x175 + (x161 + (x148 + (x48 + x47)))))))))));
    x328 = (x302 +
            (x281 +
             (x261 +
              (x242 +
               (x224 +
                (x207 + (x191 + (x176 + (x162 + (x149 + (x51 + x49)))))))))));
    x329 = (x303 +
            (x282 +
             (x262 +
              (x243 +
               (x225 +
                (x208 + (x192 + (x177 + (x163 + (x55 + (x52 + x50)))))))))));
    x330 = (x304 +
            (x283 +
             (x263 +
              (x244 +
               (x226 +
                (x209 + (x193 + (x178 + (x164 + (x60 + (x56 + x53)))))))))));
    x331 =
        (x305 +
         (x284 +
          (x264 +
           (x245 +
            (x227 + (x210 + (x194 + (x179 + (x66 + (x61 + (x57 + x54)))))))))));
    x332 =
        (x306 +
         (x285 +
          (x265 +
           (x246 +
            (x228 + (x211 + (x195 + (x180 + (x73 + (x67 + (x62 + x58)))))))))));
    x333 =
        (x307 +
         (x286 +
          (x266 +
           (x247 +
            (x229 + (x212 + (x196 + (x81 + (x74 + (x68 + (x63 + x59)))))))))));
    x334 =
        (x308 +
         (x287 +
          (x267 +
           (x248 +
            (x230 + (x213 + (x197 + (x90 + (x82 + (x75 + (x69 + x64)))))))))));
    x335 =
        (x309 +
         (x288 +
          (x268 +
           (x249 +
            (x231 + (x214 + (x100 + (x91 + (x83 + (x76 + (x70 + x65)))))))))));
    x336 =
        (x310 +
         (x289 +
          (x269 +
           (x250 +
            (x232 + (x215 + (x111 + (x101 + (x92 + (x84 + (x77 + x71)))))))))));
    x337 =
        (x311 +
         (x290 +
          (x270 +
           (x251 +
            (x233 + (x123 + (x112 + (x102 + (x93 + (x85 + (x78 + x72)))))))))));
    x338 = (x312 +
            (x291 +
             (x271 +
              (x252 +
               (x234 +
                (x136 + (x124 + (x113 + (x103 + (x94 + (x86 + x79)))))))))));
    x339 = (x313 +
            (x292 +
             (x272 +
              (x253 +
               (x150 +
                (x137 + (x125 + (x114 + (x104 + (x95 + (x87 + x80)))))))))));
    x340 = (x314 +
            (x293 +
             (x273 +
              (x254 +
               (x165 +
                (x151 + (x138 + (x126 + (x115 + (x105 + (x96 + x88)))))))))));
    x341 = (x315 +
            (x294 +
             (x274 +
              (x181 +
               (x166 +
                (x152 + (x139 + (x127 + (x116 + (x106 + (x97 + x89)))))))))));
    x342 = (x316 +
            (x295 +
             (x275 +
              (x198 +
               (x182 +
                (x167 + (x153 + (x140 + (x128 + (x117 + (x107 + x98)))))))))));
    x343 = (x317 +
            (x296 +
             (x216 +
              (x199 +
               (x183 +
                (x168 + (x154 + (x141 + (x129 + (x118 + (x108 + x99)))))))))));
    x344 = (x318 +
            (x297 +
             (x235 +
              (x217 +
               (x200 +
                (x184 + (x169 + (x155 + (x142 + (x130 + (x119 + x109)))))))))));
    x345 = (x319 +
            (x255 +
             (x236 +
              (x218 +
               (x201 +
                (x185 + (x170 + (x156 + (x143 + (x131 + (x120 + x110)))))))))));
    x346 = (x322 + x345);
    x347 = (x346 >> 22);
    x348 = (uint32_t)(x346 & UINT32_C(0x3fffff));
    x349 = (x347 + x344);
    x350 = (x349 >> 22);
    x351 = (uint32_t)(x349 & UINT32_C(0x3fffff));
    x352 = (x350 + x343);
    x353 = (x352 >> 23);
    x354 = (uint32_t)(x352 & UINT32_C(0x7fffff));
    x355 = (x353 + x342);
    x356 = (x355 >> 22);
    x357 = (uint32_t)(x355 & UINT32_C(0x3fffff));
    x358 = (x356 + x341);
    x359 = (x358 >> 22);
    x360 = (uint32_t)(x358 & UINT32_C(0x3fffff));
    x361 = (x359 + x340);
    x362 = (x361 >> 22);
    x363 = (uint32_t)(x361 & UINT32_C(0x3fffff));
    x364 = (x362 + x339);
    x365 = (x364 >> 23);
    x366 = (uint32_t)(x364 & UINT32_C(0x7fffff));
    x367 = (x365 + x338);
    x368 = (x367 >> 22);
    x369 = (uint32_t)(x367 & UINT32_C(0x3fffff));
    x370 = (x368 + x337);
    x371 = (x370 >> 22);
    x372 = (uint32_t)(x370 & UINT32_C(0x3fffff));
    x373 = (x371 + x336);
    x374 = (x373 >> 22);
    x375 = (uint32_t)(x373 & UINT32_C(0x3fffff));
    x376 = (x374 + x335);
    x377 = (x376 >> 23);
    x378 = (uint32_t)(x376 & UINT32_C(0x7fffff));
    x379 = (x377 + x334);
    x380 = (x379 >> 22);
    x381 = (uint32_t)(x379 & UINT32_C(0x3fffff));
    x382 = (x380 + x333);
    x383 = (x382 >> 22);
    x384 = (uint32_t)(x382 & UINT32_C(0x3fffff));
    x385 = (x383 + x332);
    x386 = (x385 >> 22);
    x387 = (uint32_t)(x385 & UINT32_C(0x3fffff));
    x388 = (x386 + x331);
    x389 = (x388 >> 23);
    x390 = (uint32_t)(x388 & UINT32_C(0x7fffff));
    x391 = (x389 + x330);
    x392 = (x391 >> 22);
    x393 = (uint32_t)(x391 & UINT32_C(0x3fffff));
    x394 = (x392 + x329);
    x395 = (x394 >> 22);
    x396 = (uint32_t)(x394 & UINT32_C(0x3fffff));
    x397 = (x395 + x328);
    x398 = (x397 >> 22);
    x399 = (uint32_t)(x397 & UINT32_C(0x3fffff));
    x400 = (x398 + x327);
    x401 = (x400 >> 23);
    x402 = (uint32_t)(x400 & UINT32_C(0x7fffff));
    x403 = (x401 + x326);
    x404 = (x403 >> 22);
    x405 = (uint32_t)(x403 & UINT32_C(0x3fffff));
    x406 = (x404 + x325);
    x407 = (x406 >> 22);
    x408 = (uint32_t)(x406 & UINT32_C(0x3fffff));
    x409 = (x407 + x324);
    x410 = (uint32_t)(x409 >> 22);
    x411 = (uint32_t)(x409 & UINT32_C(0x3fffff));
    x412 = ((uint64_t)UINT16_C(0x239) * x410);
    x413 = (x323 + x412);
    x414 = (uint32_t)(x413 >> 23);
    x415 = (uint32_t)(x413 & UINT32_C(0x7fffff));
    x416 = (x414 + x348);
    x417 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x416 >> 22);
    x418 = (x416 & UINT32_C(0x3fffff));
    x419 = (x417 + x351);
    out1[0] = x415;
    out1[1] = x418;
    out1[2] = x419;
    out1[3] = x354;
    out1[4] = x357;
    out1[5] = x360;
    out1[6] = x363;
    out1[7] = x366;
    out1[8] = x369;
    out1[9] = x372;
    out1[10] = x375;
    out1[11] = x378;
    out1[12] = x381;
    out1[13] = x384;
    out1[14] = x387;
    out1[15] = x390;
    out1[16] = x393;
    out1[17] = x396;
    out1[18] = x399;
    out1[19] = x402;
    out1[20] = x405;
    out1[21] = x408;
    out1[22] = x411;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_carry reduces a field element.
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_carry(
    uint32_t out1[23], const uint32_t arg1[23]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    x1 = (arg1[0]);
    x2 = ((x1 >> 23) + (arg1[1]));
    x3 = ((x2 >> 22) + (arg1[2]));
    x4 = ((x3 >> 22) + (arg1[3]));
    x5 = ((x4 >> 23) + (arg1[4]));
    x6 = ((x5 >> 22) + (arg1[5]));
    x7 = ((x6 >> 22) + (arg1[6]));
    x8 = ((x7 >> 22) + (arg1[7]));
    x9 = ((x8 >> 23) + (arg1[8]));
    x10 = ((x9 >> 22) + (arg1[9]));
    x11 = ((x10 >> 22) + (arg1[10]));
    x12 = ((x11 >> 22) + (arg1[11]));
    x13 = ((x12 >> 23) + (arg1[12]));
    x14 = ((x13 >> 22) + (arg1[13]));
    x15 = ((x14 >> 22) + (arg1[14]));
    x16 = ((x15 >> 22) + (arg1[15]));
    x17 = ((x16 >> 23) + (arg1[16]));
    x18 = ((x17 >> 22) + (arg1[17]));
    x19 = ((x18 >> 22) + (arg1[18]));
    x20 = ((x19 >> 22) + (arg1[19]));
    x21 = ((x20 >> 23) + (arg1[20]));
    x22 = ((x21 >> 22) + (arg1[21]));
    x23 = ((x22 >> 22) + (arg1[22]));
    x24 = ((x1 & UINT32_C(0x7fffff)) + (UINT16_C(0x239) * (x23 >> 22)));
    x25 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x24 >> 23) +
           (x2 & UINT32_C(0x3fffff)));
    x26 = (x24 & UINT32_C(0x7fffff));
    x27 = (x25 & UINT32_C(0x3fffff));
    x28 = ((fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x25 >> 22) +
           (x3 & UINT32_C(0x3fffff)));
    x29 = (x4 & UINT32_C(0x7fffff));
    x30 = (x5 & UINT32_C(0x3fffff));
    x31 = (x6 & UINT32_C(0x3fffff));
    x32 = (x7 & UINT32_C(0x3fffff));
    x33 = (x8 & UINT32_C(0x7fffff));
    x34 = (x9 & UINT32_C(0x3fffff));
    x35 = (x10 & UINT32_C(0x3fffff));
    x36 = (x11 & UINT32_C(0x3fffff));
    x37 = (x12 & UINT32_C(0x7fffff));
    x38 = (x13 & UINT32_C(0x3fffff));
    x39 = (x14 & UINT32_C(0x3fffff));
    x40 = (x15 & UINT32_C(0x3fffff));
    x41 = (x16 & UINT32_C(0x7fffff));
    x42 = (x17 & UINT32_C(0x3fffff));
    x43 = (x18 & UINT32_C(0x3fffff));
    x44 = (x19 & UINT32_C(0x3fffff));
    x45 = (x20 & UINT32_C(0x7fffff));
    x46 = (x21 & UINT32_C(0x3fffff));
    x47 = (x22 & UINT32_C(0x3fffff));
    x48 = (x23 & UINT32_C(0x3fffff));
    out1[0] = x26;
    out1[1] = x27;
    out1[2] = x28;
    out1[3] = x29;
    out1[4] = x30;
    out1[5] = x31;
    out1[6] = x32;
    out1[7] = x33;
    out1[8] = x34;
    out1[9] = x35;
    out1[10] = x36;
    out1[11] = x37;
    out1[12] = x38;
    out1[13] = x39;
    out1[14] = x40;
    out1[15] = x41;
    out1[16] = x42;
    out1[17] = x43;
    out1[18] = x44;
    out1[19] = x45;
    out1[20] = x46;
    out1[21] = x47;
    out1[22] = x48;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_add adds two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 *   arg2: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_add(
    uint32_t out1[23], const uint32_t arg1[23], const uint32_t arg2[23]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    x1 = ((arg1[0]) + (arg2[0]));
    x2 = ((arg1[1]) + (arg2[1]));
    x3 = ((arg1[2]) + (arg2[2]));
    x4 = ((arg1[3]) + (arg2[3]));
    x5 = ((arg1[4]) + (arg2[4]));
    x6 = ((arg1[5]) + (arg2[5]));
    x7 = ((arg1[6]) + (arg2[6]));
    x8 = ((arg1[7]) + (arg2[7]));
    x9 = ((arg1[8]) + (arg2[8]));
    x10 = ((arg1[9]) + (arg2[9]));
    x11 = ((arg1[10]) + (arg2[10]));
    x12 = ((arg1[11]) + (arg2[11]));
    x13 = ((arg1[12]) + (arg2[12]));
    x14 = ((arg1[13]) + (arg2[13]));
    x15 = ((arg1[14]) + (arg2[14]));
    x16 = ((arg1[15]) + (arg2[15]));
    x17 = ((arg1[16]) + (arg2[16]));
    x18 = ((arg1[17]) + (arg2[17]));
    x19 = ((arg1[18]) + (arg2[18]));
    x20 = ((arg1[19]) + (arg2[19]));
    x21 = ((arg1[20]) + (arg2[20]));
    x22 = ((arg1[21]) + (arg2[21]));
    x23 = ((arg1[22]) + (arg2[22]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1[12] = x13;
    out1[13] = x14;
    out1[14] = x15;
    out1[15] = x16;
    out1[16] = x17;
    out1[17] = x18;
    out1[18] = x19;
    out1[19] = x20;
    out1[20] = x21;
    out1[21] = x22;
    out1[22] = x23;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_sub subtracts two field elements.
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 *   arg2: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_sub(
    uint32_t out1[23], const uint32_t arg1[23], const uint32_t arg2[23]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    x1 = ((UINT32_C(0xfffb8e) + (arg1[0])) - (arg2[0]));
    x2 = ((UINT32_C(0x7ffffe) + (arg1[1])) - (arg2[1]));
    x3 = ((UINT32_C(0x7ffffe) + (arg1[2])) - (arg2[2]));
    x4 = ((UINT32_C(0xfffffe) + (arg1[3])) - (arg2[3]));
    x5 = ((UINT32_C(0x7ffffe) + (arg1[4])) - (arg2[4]));
    x6 = ((UINT32_C(0x7ffffe) + (arg1[5])) - (arg2[5]));
    x7 = ((UINT32_C(0x7ffffe) + (arg1[6])) - (arg2[6]));
    x8 = ((UINT32_C(0xfffffe) + (arg1[7])) - (arg2[7]));
    x9 = ((UINT32_C(0x7ffffe) + (arg1[8])) - (arg2[8]));
    x10 = ((UINT32_C(0x7ffffe) + (arg1[9])) - (arg2[9]));
    x11 = ((UINT32_C(0x7ffffe) + (arg1[10])) - (arg2[10]));
    x12 = ((UINT32_C(0xfffffe) + (arg1[11])) - (arg2[11]));
    x13 = ((UINT32_C(0x7ffffe) + (arg1[12])) - (arg2[12]));
    x14 = ((UINT32_C(0x7ffffe) + (arg1[13])) - (arg2[13]));
    x15 = ((UINT32_C(0x7ffffe) + (arg1[14])) - (arg2[14]));
    x16 = ((UINT32_C(0xfffffe) + (arg1[15])) - (arg2[15]));
    x17 = ((UINT32_C(0x7ffffe) + (arg1[16])) - (arg2[16]));
    x18 = ((UINT32_C(0x7ffffe) + (arg1[17])) - (arg2[17]));
    x19 = ((UINT32_C(0x7ffffe) + (arg1[18])) - (arg2[18]));
    x20 = ((UINT32_C(0xfffffe) + (arg1[19])) - (arg2[19]));
    x21 = ((UINT32_C(0x7ffffe) + (arg1[20])) - (arg2[20]));
    x22 = ((UINT32_C(0x7ffffe) + (arg1[21])) - (arg2[21]));
    x23 = ((UINT32_C(0x7ffffe) + (arg1[22])) - (arg2[22]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1[12] = x13;
    out1[13] = x14;
    out1[14] = x15;
    out1[15] = x16;
    out1[16] = x17;
    out1[17] = x18;
    out1[18] = x19;
    out1[19] = x20;
    out1[20] = x21;
    out1[21] = x22;
    out1[22] = x23;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_opp negates a field element.
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0x1800000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000], [0x0 ~> 0xc00000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(
    uint32_t out1[23], const uint32_t arg1[23]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    x1 = (UINT32_C(0xfffb8e) - (arg1[0]));
    x2 = (UINT32_C(0x7ffffe) - (arg1[1]));
    x3 = (UINT32_C(0x7ffffe) - (arg1[2]));
    x4 = (UINT32_C(0xfffffe) - (arg1[3]));
    x5 = (UINT32_C(0x7ffffe) - (arg1[4]));
    x6 = (UINT32_C(0x7ffffe) - (arg1[5]));
    x7 = (UINT32_C(0x7ffffe) - (arg1[6]));
    x8 = (UINT32_C(0xfffffe) - (arg1[7]));
    x9 = (UINT32_C(0x7ffffe) - (arg1[8]));
    x10 = (UINT32_C(0x7ffffe) - (arg1[9]));
    x11 = (UINT32_C(0x7ffffe) - (arg1[10]));
    x12 = (UINT32_C(0xfffffe) - (arg1[11]));
    x13 = (UINT32_C(0x7ffffe) - (arg1[12]));
    x14 = (UINT32_C(0x7ffffe) - (arg1[13]));
    x15 = (UINT32_C(0x7ffffe) - (arg1[14]));
    x16 = (UINT32_C(0xfffffe) - (arg1[15]));
    x17 = (UINT32_C(0x7ffffe) - (arg1[16]));
    x18 = (UINT32_C(0x7ffffe) - (arg1[17]));
    x19 = (UINT32_C(0x7ffffe) - (arg1[18]));
    x20 = (UINT32_C(0xfffffe) - (arg1[19]));
    x21 = (UINT32_C(0x7ffffe) - (arg1[20]));
    x22 = (UINT32_C(0x7ffffe) - (arg1[21]));
    x23 = (UINT32_C(0x7ffffe) - (arg1[22]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1[12] = x13;
    out1[13] = x14;
    out1[14] = x15;
    out1[15] = x16;
    out1[16] = x17;
    out1[17] = x18;
    out1[18] = x19;
    out1[19] = x20;
    out1[20] = x21;
    out1[21] = x22;
    out1[22] = x23;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
    uint32_t out1[23], fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 arg1,
    const uint32_t arg2[23], const uint32_t arg3[23]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x1, arg1, (arg2[0]),
                                                          (arg3[0]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x2, arg1, (arg2[1]),
                                                          (arg3[1]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x3, arg1, (arg2[2]),
                                                          (arg3[2]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x4, arg1, (arg2[3]),
                                                          (arg3[3]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x5, arg1, (arg2[4]),
                                                          (arg3[4]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x6, arg1, (arg2[5]),
                                                          (arg3[5]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x7, arg1, (arg2[6]),
                                                          (arg3[6]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x8, arg1, (arg2[7]),
                                                          (arg3[7]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x9, arg1, (arg2[8]),
                                                          (arg3[8]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x10, arg1, (arg2[9]),
                                                          (arg3[9]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x11, arg1, (arg2[10]), (arg3[10]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x12, arg1, (arg2[11]), (arg3[11]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x13, arg1, (arg2[12]), (arg3[12]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x14, arg1, (arg2[13]), (arg3[13]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x15, arg1, (arg2[14]), (arg3[14]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x16, arg1, (arg2[15]), (arg3[15]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x17, arg1, (arg2[16]), (arg3[16]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x18, arg1, (arg2[17]), (arg3[17]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x19, arg1, (arg2[18]), (arg3[18]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x20, arg1, (arg2[19]), (arg3[19]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x21, arg1, (arg2[20]), (arg3[20]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x22, arg1, (arg2[21]), (arg3[21]));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(
        &x23, arg1, (arg2[22]), (arg3[22]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1[12] = x13;
    out1[13] = x14;
    out1[14] = x15;
    out1[15] = x16;
    out1[16] = x17;
    out1[17] = x18;
    out1[18] = x19;
    out1[19] = x20;
    out1[20] = x21;
    out1[21] = x22;
    out1[22] = x23;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes serializes a field element to bytes in little-endian order.
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..63]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(
    uint8_t out1[64], const uint32_t arg1[23]) {
    uint32_t x1;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x2;
    uint32_t x3;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x4;
    uint32_t x5;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x6;
    uint32_t x7;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x8;
    uint32_t x9;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x10;
    uint32_t x11;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x12;
    uint32_t x13;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x14;
    uint32_t x15;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x16;
    uint32_t x17;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x18;
    uint32_t x19;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x20;
    uint32_t x21;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x22;
    uint32_t x23;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x24;
    uint32_t x25;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x26;
    uint32_t x27;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x28;
    uint32_t x29;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x30;
    uint32_t x31;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x32;
    uint32_t x33;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x34;
    uint32_t x35;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x36;
    uint32_t x37;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x38;
    uint32_t x39;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x40;
    uint32_t x41;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x42;
    uint32_t x43;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x44;
    uint32_t x45;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x46;
    uint32_t x47;
    uint32_t x48;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x49;
    uint32_t x50;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x51;
    uint32_t x52;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x53;
    uint32_t x54;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x55;
    uint32_t x56;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x57;
    uint32_t x58;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x59;
    uint32_t x60;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x61;
    uint32_t x62;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x63;
    uint32_t x64;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x65;
    uint32_t x66;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x67;
    uint32_t x68;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x69;
    uint32_t x70;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x71;
    uint32_t x72;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x73;
    uint32_t x74;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x75;
    uint32_t x76;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x77;
    uint32_t x78;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x79;
    uint32_t x80;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x81;
    uint32_t x82;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x83;
    uint32_t x84;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x85;
    uint32_t x86;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x87;
    uint32_t x88;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x89;
    uint32_t x90;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x91;
    uint32_t x92;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x93;
    uint32_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint32_t x104;
    uint32_t x105;
    uint32_t x106;
    uint32_t x107;
    uint32_t x108;
    uint32_t x109;
    uint32_t x110;
    uint32_t x111;
    uint32_t x112;
    uint32_t x113;
    uint8_t x114;
    uint32_t x115;
    uint8_t x116;
    uint8_t x117;
    uint32_t x118;
    uint8_t x119;
    uint32_t x120;
    uint8_t x121;
    uint32_t x122;
    uint8_t x123;
    uint8_t x124;
    uint32_t x125;
    uint8_t x126;
    uint32_t x127;
    uint8_t x128;
    uint32_t x129;
    uint8_t x130;
    uint8_t x131;
    uint32_t x132;
    uint8_t x133;
    uint32_t x134;
    uint8_t x135;
    uint32_t x136;
    uint8_t x137;
    uint8_t x138;
    uint32_t x139;
    uint8_t x140;
    uint32_t x141;
    uint8_t x142;
    uint8_t x143;
    uint8_t x144;
    uint32_t x145;
    uint8_t x146;
    uint8_t x147;
    uint32_t x148;
    uint8_t x149;
    uint32_t x150;
    uint8_t x151;
    uint32_t x152;
    uint8_t x153;
    uint8_t x154;
    uint32_t x155;
    uint8_t x156;
    uint32_t x157;
    uint8_t x158;
    uint32_t x159;
    uint8_t x160;
    uint8_t x161;
    uint32_t x162;
    uint8_t x163;
    uint32_t x164;
    uint8_t x165;
    uint32_t x166;
    uint8_t x167;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x168;
    uint32_t x169;
    uint8_t x170;
    uint32_t x171;
    uint8_t x172;
    uint8_t x173;
    uint32_t x174;
    uint8_t x175;
    uint32_t x176;
    uint8_t x177;
    uint32_t x178;
    uint8_t x179;
    uint8_t x180;
    uint32_t x181;
    uint8_t x182;
    uint32_t x183;
    uint8_t x184;
    uint32_t x185;
    uint8_t x186;
    uint8_t x187;
    uint32_t x188;
    uint8_t x189;
    uint32_t x190;
    uint8_t x191;
    uint32_t x192;
    uint8_t x193;
    uint8_t x194;
    uint32_t x195;
    uint8_t x196;
    uint32_t x197;
    uint8_t x198;
    uint8_t x199;
    uint8_t x200;
    uint32_t x201;
    uint8_t x202;
    uint8_t x203;
    uint32_t x204;
    uint8_t x205;
    uint32_t x206;
    uint8_t x207;
    uint32_t x208;
    uint8_t x209;
    uint8_t x210;
    uint32_t x211;
    uint8_t x212;
    uint32_t x213;
    uint8_t x214;
    uint32_t x215;
    uint8_t x216;
    uint8_t x217;
    uint32_t x218;
    uint8_t x219;
    uint32_t x220;
    uint8_t x221;
    uint32_t x222;
    uint8_t x223;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x224;
    uint32_t x225;
    uint8_t x226;
    uint32_t x227;
    uint8_t x228;
    uint8_t x229;
    uint32_t x230;
    uint8_t x231;
    uint32_t x232;
    uint8_t x233;
    uint32_t x234;
    uint8_t x235;
    uint8_t x236;
    uint32_t x237;
    uint8_t x238;
    uint32_t x239;
    uint8_t x240;
    uint32_t x241;
    uint8_t x242;
    uint8_t x243;
    uint32_t x244;
    uint8_t x245;
    uint32_t x246;
    uint8_t x247;
    uint32_t x248;
    uint8_t x249;
    uint8_t x250;
    uint32_t x251;
    uint8_t x252;
    uint32_t x253;
    uint8_t x254;
    uint8_t x255;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x1, &x2, 0x0, (arg1[0]), UINT32_C(0x7ffdc7));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x3, &x4, x2, (arg1[1]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x5, &x6, x4, (arg1[2]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x7, &x8, x6, (arg1[3]), UINT32_C(0x7fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x9, &x10, x8, (arg1[4]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x11, &x12, x10, (arg1[5]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x13, &x14, x12, (arg1[6]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x15, &x16, x14, (arg1[7]), UINT32_C(0x7fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x17, &x18, x16, (arg1[8]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x19, &x20, x18, (arg1[9]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x21, &x22, x20, (arg1[10]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x23, &x24, x22, (arg1[11]), UINT32_C(0x7fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x25, &x26, x24, (arg1[12]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x27, &x28, x26, (arg1[13]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x29, &x30, x28, (arg1[14]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x31, &x32, x30, (arg1[15]), UINT32_C(0x7fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x33, &x34, x32, (arg1[16]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x35, &x36, x34, (arg1[17]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x37, &x38, x36, (arg1[18]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u23(
        &x39, &x40, x38, (arg1[19]), UINT32_C(0x7fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x41, &x42, x40, (arg1[20]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x43, &x44, x42, (arg1[21]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_subborrowx_u22(
        &x45, &x46, x44, (arg1[22]), UINT32_C(0x3fffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_cmovznz_u32(&x47, x46, 0x0,
                                                          UINT32_C(0xffffffff));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x48, &x49, 0x0, x1, (x47 & UINT32_C(0x7ffdc7)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x50, &x51, x49, x3, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x52, &x53, x51, x5, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x54, &x55, x53, x7, (x47 & UINT32_C(0x7fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x56, &x57, x55, x9, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x58, &x59, x57, x11, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x60, &x61, x59, x13, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x62, &x63, x61, x15, (x47 & UINT32_C(0x7fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x64, &x65, x63, x17, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x66, &x67, x65, x19, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x68, &x69, x67, x21, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x70, &x71, x69, x23, (x47 & UINT32_C(0x7fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x72, &x73, x71, x25, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x74, &x75, x73, x27, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x76, &x77, x75, x29, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x78, &x79, x77, x31, (x47 & UINT32_C(0x7fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x80, &x81, x79, x33, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x82, &x83, x81, x35, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x84, &x85, x83, x37, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u23(
        &x86, &x87, x85, x39, (x47 & UINT32_C(0x7fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x88, &x89, x87, x41, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x90, &x91, x89, x43, (x47 & UINT32_C(0x3fffff)));
    fiat_id_tc26_gost_3410_2012_512_paramSetA_addcarryx_u22(
        &x92, &x93, x91, x45, (x47 & UINT32_C(0x3fffff)));
    x94 = (x92 << 2);
    x95 = (x90 << 4);
    x96 = (x88 << 6);
    x97 = (x86 << 7);
    x98 = (x84 * (uint32_t)0x2);
    x99 = (x82 << 3);
    x100 = (x80 << 5);
    x101 = (x78 << 6);
    x102 = (x74 << 2);
    x103 = (x72 << 4);
    x104 = (x70 << 5);
    x105 = (x68 << 7);
    x106 = (x66 * (uint32_t)0x2);
    x107 = (x64 << 3);
    x108 = (x62 << 4);
    x109 = (x60 << 6);
    x110 = (x56 << 2);
    x111 = (x54 << 3);
    x112 = (x52 << 5);
    x113 = (x50 << 7);
    x114 = (uint8_t)(x48 & UINT8_C(0xff));
    x115 = (x48 >> 8);
    x116 = (uint8_t)(x115 & UINT8_C(0xff));
    x117 = (uint8_t)(x115 >> 8);
    x118 = (x113 + (uint32_t)x117);
    x119 = (uint8_t)(x118 & UINT8_C(0xff));
    x120 = (x118 >> 8);
    x121 = (uint8_t)(x120 & UINT8_C(0xff));
    x122 = (x120 >> 8);
    x123 = (uint8_t)(x122 & UINT8_C(0xff));
    x124 = (uint8_t)(x122 >> 8);
    x125 = (x112 + (uint32_t)x124);
    x126 = (uint8_t)(x125 & UINT8_C(0xff));
    x127 = (x125 >> 8);
    x128 = (uint8_t)(x127 & UINT8_C(0xff));
    x129 = (x127 >> 8);
    x130 = (uint8_t)(x129 & UINT8_C(0xff));
    x131 = (uint8_t)(x129 >> 8);
    x132 = (x111 + (uint32_t)x131);
    x133 = (uint8_t)(x132 & UINT8_C(0xff));
    x134 = (x132 >> 8);
    x135 = (uint8_t)(x134 & UINT8_C(0xff));
    x136 = (x134 >> 8);
    x137 = (uint8_t)(x136 & UINT8_C(0xff));
    x138 = (uint8_t)(x136 >> 8);
    x139 = (x110 + (uint32_t)x138);
    x140 = (uint8_t)(x139 & UINT8_C(0xff));
    x141 = (x139 >> 8);
    x142 = (uint8_t)(x141 & UINT8_C(0xff));
    x143 = (uint8_t)(x141 >> 8);
    x144 = (uint8_t)(x58 & UINT8_C(0xff));
    x145 = (x58 >> 8);
    x146 = (uint8_t)(x145 & UINT8_C(0xff));
    x147 = (uint8_t)(x145 >> 8);
    x148 = (x109 + (uint32_t)x147);
    x149 = (uint8_t)(x148 & UINT8_C(0xff));
    x150 = (x148 >> 8);
    x151 = (uint8_t)(x150 & UINT8_C(0xff));
    x152 = (x150 >> 8);
    x153 = (uint8_t)(x152 & UINT8_C(0xff));
    x154 = (uint8_t)(x152 >> 8);
    x155 = (x108 + (uint32_t)x154);
    x156 = (uint8_t)(x155 & UINT8_C(0xff));
    x157 = (x155 >> 8);
    x158 = (uint8_t)(x157 & UINT8_C(0xff));
    x159 = (x157 >> 8);
    x160 = (uint8_t)(x159 & UINT8_C(0xff));
    x161 = (uint8_t)(x159 >> 8);
    x162 = (x107 + (uint32_t)x161);
    x163 = (uint8_t)(x162 & UINT8_C(0xff));
    x164 = (x162 >> 8);
    x165 = (uint8_t)(x164 & UINT8_C(0xff));
    x166 = (x164 >> 8);
    x167 = (uint8_t)(x166 & UINT8_C(0xff));
    x168 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x166 >> 8);
    x169 = (x106 + (uint32_t)x168);
    x170 = (uint8_t)(x169 & UINT8_C(0xff));
    x171 = (x169 >> 8);
    x172 = (uint8_t)(x171 & UINT8_C(0xff));
    x173 = (uint8_t)(x171 >> 8);
    x174 = (x105 + (uint32_t)x173);
    x175 = (uint8_t)(x174 & UINT8_C(0xff));
    x176 = (x174 >> 8);
    x177 = (uint8_t)(x176 & UINT8_C(0xff));
    x178 = (x176 >> 8);
    x179 = (uint8_t)(x178 & UINT8_C(0xff));
    x180 = (uint8_t)(x178 >> 8);
    x181 = (x104 + (uint32_t)x180);
    x182 = (uint8_t)(x181 & UINT8_C(0xff));
    x183 = (x181 >> 8);
    x184 = (uint8_t)(x183 & UINT8_C(0xff));
    x185 = (x183 >> 8);
    x186 = (uint8_t)(x185 & UINT8_C(0xff));
    x187 = (uint8_t)(x185 >> 8);
    x188 = (x103 + (uint32_t)x187);
    x189 = (uint8_t)(x188 & UINT8_C(0xff));
    x190 = (x188 >> 8);
    x191 = (uint8_t)(x190 & UINT8_C(0xff));
    x192 = (x190 >> 8);
    x193 = (uint8_t)(x192 & UINT8_C(0xff));
    x194 = (uint8_t)(x192 >> 8);
    x195 = (x102 + (uint32_t)x194);
    x196 = (uint8_t)(x195 & UINT8_C(0xff));
    x197 = (x195 >> 8);
    x198 = (uint8_t)(x197 & UINT8_C(0xff));
    x199 = (uint8_t)(x197 >> 8);
    x200 = (uint8_t)(x76 & UINT8_C(0xff));
    x201 = (x76 >> 8);
    x202 = (uint8_t)(x201 & UINT8_C(0xff));
    x203 = (uint8_t)(x201 >> 8);
    x204 = (x101 + (uint32_t)x203);
    x205 = (uint8_t)(x204 & UINT8_C(0xff));
    x206 = (x204 >> 8);
    x207 = (uint8_t)(x206 & UINT8_C(0xff));
    x208 = (x206 >> 8);
    x209 = (uint8_t)(x208 & UINT8_C(0xff));
    x210 = (uint8_t)(x208 >> 8);
    x211 = (x100 + (uint32_t)x210);
    x212 = (uint8_t)(x211 & UINT8_C(0xff));
    x213 = (x211 >> 8);
    x214 = (uint8_t)(x213 & UINT8_C(0xff));
    x215 = (x213 >> 8);
    x216 = (uint8_t)(x215 & UINT8_C(0xff));
    x217 = (uint8_t)(x215 >> 8);
    x218 = (x99 + (uint32_t)x217);
    x219 = (uint8_t)(x218 & UINT8_C(0xff));
    x220 = (x218 >> 8);
    x221 = (uint8_t)(x220 & UINT8_C(0xff));
    x222 = (x220 >> 8);
    x223 = (uint8_t)(x222 & UINT8_C(0xff));
    x224 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x222 >> 8);
    x225 = (x98 + (uint32_t)x224);
    x226 = (uint8_t)(x225 & UINT8_C(0xff));
    x227 = (x225 >> 8);
    x228 = (uint8_t)(x227 & UINT8_C(0xff));
    x229 = (uint8_t)(x227 >> 8);
    x230 = (x97 + (uint32_t)x229);
    x231 = (uint8_t)(x230 & UINT8_C(0xff));
    x232 = (x230 >> 8);
    x233 = (uint8_t)(x232 & UINT8_C(0xff));
    x234 = (x232 >> 8);
    x235 = (uint8_t)(x234 & UINT8_C(0xff));
    x236 = (uint8_t)(x234 >> 8);
    x237 = (x96 + (uint32_t)x236);
    x238 = (uint8_t)(x237 & UINT8_C(0xff));
    x239 = (x237 >> 8);
    x240 = (uint8_t)(x239 & UINT8_C(0xff));
    x241 = (x239 >> 8);
    x242 = (uint8_t)(x241 & UINT8_C(0xff));
    x243 = (uint8_t)(x241 >> 8);
    x244 = (x95 + (uint32_t)x243);
    x245 = (uint8_t)(x244 & UINT8_C(0xff));
    x246 = (x244 >> 8);
    x247 = (uint8_t)(x246 & UINT8_C(0xff));
    x248 = (x246 >> 8);
    x249 = (uint8_t)(x248 & UINT8_C(0xff));
    x250 = (uint8_t)(x248 >> 8);
    x251 = (x94 + (uint32_t)x250);
    x252 = (uint8_t)(x251 & UINT8_C(0xff));
    x253 = (x251 >> 8);
    x254 = (uint8_t)(x253 & UINT8_C(0xff));
    x255 = (uint8_t)(x253 >> 8);
    out1[0] = x114;
    out1[1] = x116;
    out1[2] = x119;
    out1[3] = x121;
    out1[4] = x123;
    out1[5] = x126;
    out1[6] = x128;
    out1[7] = x130;
    out1[8] = x133;
    out1[9] = x135;
    out1[10] = x137;
    out1[11] = x140;
    out1[12] = x142;
    out1[13] = x143;
    out1[14] = x144;
    out1[15] = x146;
    out1[16] = x149;
    out1[17] = x151;
    out1[18] = x153;
    out1[19] = x156;
    out1[20] = x158;
    out1[21] = x160;
    out1[22] = x163;
    out1[23] = x165;
    out1[24] = x167;
    out1[25] = x170;
    out1[26] = x172;
    out1[27] = x175;
    out1[28] = x177;
    out1[29] = x179;
    out1[30] = x182;
    out1[31] = x184;
    out1[32] = x186;
    out1[33] = x189;
    out1[34] = x191;
    out1[35] = x193;
    out1[36] = x196;
    out1[37] = x198;
    out1[38] = x199;
    out1[39] = x200;
    out1[40] = x202;
    out1[41] = x205;
    out1[42] = x207;
    out1[43] = x209;
    out1[44] = x212;
    out1[45] = x214;
    out1[46] = x216;
    out1[47] = x219;
    out1[48] = x221;
    out1[49] = x223;
    out1[50] = x226;
    out1[51] = x228;
    out1[52] = x231;
    out1[53] = x233;
    out1[54] = x235;
    out1[55] = x238;
    out1[56] = x240;
    out1[57] = x242;
    out1[58] = x245;
    out1[59] = x247;
    out1[60] = x249;
    out1[61] = x252;
    out1[62] = x254;
    out1[63] = x255;
}

/*
 * The function fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes deserializes a field element from bytes in little-endian order.
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x800000], [0x0 ~> 0x400000], [0x0 ~> 0x400000], [0x0 ~> 0x400000]]
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(
    uint32_t out1[23], const uint8_t arg1[64]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint8_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint8_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint8_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint8_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint8_t x78;
    uint32_t x79;
    uint32_t x80;
    uint32_t x81;
    uint32_t x82;
    uint8_t x83;
    uint32_t x84;
    uint32_t x85;
    uint32_t x86;
    uint32_t x87;
    uint32_t x88;
    uint8_t x89;
    uint32_t x90;
    uint32_t x91;
    uint32_t x92;
    uint32_t x93;
    uint8_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint32_t x98;
    uint8_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint8_t x104;
    uint32_t x105;
    uint32_t x106;
    uint32_t x107;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x108;
    uint32_t x109;
    uint32_t x110;
    uint32_t x111;
    uint32_t x112;
    uint8_t x113;
    uint32_t x114;
    uint32_t x115;
    uint32_t x116;
    uint32_t x117;
    uint8_t x118;
    uint32_t x119;
    uint32_t x120;
    uint32_t x121;
    uint32_t x122;
    uint8_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    uint32_t x127;
    uint32_t x128;
    uint8_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint8_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint8_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint8_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1 x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint8_t x153;
    uint32_t x154;
    uint32_t x155;
    uint32_t x156;
    uint32_t x157;
    uint8_t x158;
    uint32_t x159;
    uint32_t x160;
    uint32_t x161;
    uint32_t x162;
    uint8_t x163;
    uint32_t x164;
    uint32_t x165;
    x1 = ((uint32_t)(arg1[63]) << 14);
    x2 = ((uint32_t)(arg1[62]) << 6);
    x3 = ((uint32_t)(arg1[61]) << 20);
    x4 = ((uint32_t)(arg1[60]) << 12);
    x5 = ((uint32_t)(arg1[59]) << 4);
    x6 = ((uint32_t)(arg1[58]) << 18);
    x7 = ((uint32_t)(arg1[57]) << 10);
    x8 = ((uint32_t)(arg1[56]) << 2);
    x9 = ((uint32_t)(arg1[55]) << 17);
    x10 = ((uint32_t)(arg1[54]) << 9);
    x11 = ((uint32_t)(arg1[53]) * 0x2);
    x12 = ((uint32_t)(arg1[52]) << 15);
    x13 = ((uint32_t)(arg1[51]) << 7);
    x14 = ((uint32_t)(arg1[50]) << 21);
    x15 = ((uint32_t)(arg1[49]) << 13);
    x16 = ((uint32_t)(arg1[48]) << 5);
    x17 = ((uint32_t)(arg1[47]) << 19);
    x18 = ((uint32_t)(arg1[46]) << 11);
    x19 = ((uint32_t)(arg1[45]) << 3);
    x20 = ((uint32_t)(arg1[44]) << 18);
    x21 = ((uint32_t)(arg1[43]) << 10);
    x22 = ((uint32_t)(arg1[42]) << 2);
    x23 = ((uint32_t)(arg1[41]) << 16);
    x24 = ((uint32_t)(arg1[40]) << 8);
    x25 = (arg1[39]);
    x26 = ((uint32_t)(arg1[38]) << 14);
    x27 = ((uint32_t)(arg1[37]) << 6);
    x28 = ((uint32_t)(arg1[36]) << 20);
    x29 = ((uint32_t)(arg1[35]) << 12);
    x30 = ((uint32_t)(arg1[34]) << 4);
    x31 = ((uint32_t)(arg1[33]) << 19);
    x32 = ((uint32_t)(arg1[32]) << 11);
    x33 = ((uint32_t)(arg1[31]) << 3);
    x34 = ((uint32_t)(arg1[30]) << 17);
    x35 = ((uint32_t)(arg1[29]) << 9);
    x36 = ((uint32_t)(arg1[28]) * 0x2);
    x37 = ((uint32_t)(arg1[27]) << 15);
    x38 = ((uint32_t)(arg1[26]) << 7);
    x39 = ((uint32_t)(arg1[25]) << 21);
    x40 = ((uint32_t)(arg1[24]) << 13);
    x41 = ((uint32_t)(arg1[23]) << 5);
    x42 = ((uint32_t)(arg1[22]) << 20);
    x43 = ((uint32_t)(arg1[21]) << 12);
    x44 = ((uint32_t)(arg1[20]) << 4);
    x45 = ((uint32_t)(arg1[19]) << 18);
    x46 = ((uint32_t)(arg1[18]) << 10);
    x47 = ((uint32_t)(arg1[17]) << 2);
    x48 = ((uint32_t)(arg1[16]) << 16);
    x49 = ((uint32_t)(arg1[15]) << 8);
    x50 = (arg1[14]);
    x51 = ((uint32_t)(arg1[13]) << 14);
    x52 = ((uint32_t)(arg1[12]) << 6);
    x53 = ((uint32_t)(arg1[11]) << 21);
    x54 = ((uint32_t)(arg1[10]) << 13);
    x55 = ((uint32_t)(arg1[9]) << 5);
    x56 = ((uint32_t)(arg1[8]) << 19);
    x57 = ((uint32_t)(arg1[7]) << 11);
    x58 = ((uint32_t)(arg1[6]) << 3);
    x59 = ((uint32_t)(arg1[5]) << 17);
    x60 = ((uint32_t)(arg1[4]) << 9);
    x61 = ((uint32_t)(arg1[3]) * 0x2);
    x62 = ((uint32_t)(arg1[2]) << 16);
    x63 = ((uint32_t)(arg1[1]) << 8);
    x64 = (arg1[0]);
    x65 = (x63 + (uint32_t)x64);
    x66 = (x62 + x65);
    x67 = (x66 & UINT32_C(0x7fffff));
    x68 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x66 >> 23);
    x69 = (x61 + (uint32_t)x68);
    x70 = (x60 + x69);
    x71 = (x59 + x70);
    x72 = (x71 & UINT32_C(0x3fffff));
    x73 = (uint8_t)(x71 >> 22);
    x74 = (x58 + (uint32_t)x73);
    x75 = (x57 + x74);
    x76 = (x56 + x75);
    x77 = (x76 & UINT32_C(0x3fffff));
    x78 = (uint8_t)(x76 >> 22);
    x79 = (x55 + (uint32_t)x78);
    x80 = (x54 + x79);
    x81 = (x53 + x80);
    x82 = (x81 & UINT32_C(0x7fffff));
    x83 = (uint8_t)(x81 >> 23);
    x84 = (x52 + (uint32_t)x83);
    x85 = (x51 + x84);
    x86 = (x49 + (uint32_t)x50);
    x87 = (x48 + x86);
    x88 = (x87 & UINT32_C(0x3fffff));
    x89 = (uint8_t)(x87 >> 22);
    x90 = (x47 + (uint32_t)x89);
    x91 = (x46 + x90);
    x92 = (x45 + x91);
    x93 = (x92 & UINT32_C(0x3fffff));
    x94 = (uint8_t)(x92 >> 22);
    x95 = (x44 + (uint32_t)x94);
    x96 = (x43 + x95);
    x97 = (x42 + x96);
    x98 = (x97 & UINT32_C(0x7fffff));
    x99 = (uint8_t)(x97 >> 23);
    x100 = (x41 + (uint32_t)x99);
    x101 = (x40 + x100);
    x102 = (x39 + x101);
    x103 = (x102 & UINT32_C(0x3fffff));
    x104 = (uint8_t)(x102 >> 22);
    x105 = (x38 + (uint32_t)x104);
    x106 = (x37 + x105);
    x107 = (x106 & UINT32_C(0x3fffff));
    x108 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x106 >> 22);
    x109 = (x36 + (uint32_t)x108);
    x110 = (x35 + x109);
    x111 = (x34 + x110);
    x112 = (x111 & UINT32_C(0x3fffff));
    x113 = (uint8_t)(x111 >> 22);
    x114 = (x33 + (uint32_t)x113);
    x115 = (x32 + x114);
    x116 = (x31 + x115);
    x117 = (x116 & UINT32_C(0x7fffff));
    x118 = (uint8_t)(x116 >> 23);
    x119 = (x30 + (uint32_t)x118);
    x120 = (x29 + x119);
    x121 = (x28 + x120);
    x122 = (x121 & UINT32_C(0x3fffff));
    x123 = (uint8_t)(x121 >> 22);
    x124 = (x27 + (uint32_t)x123);
    x125 = (x26 + x124);
    x126 = (x24 + (uint32_t)x25);
    x127 = (x23 + x126);
    x128 = (x127 & UINT32_C(0x3fffff));
    x129 = (uint8_t)(x127 >> 22);
    x130 = (x22 + (uint32_t)x129);
    x131 = (x21 + x130);
    x132 = (x20 + x131);
    x133 = (x132 & UINT32_C(0x7fffff));
    x134 = (uint8_t)(x132 >> 23);
    x135 = (x19 + (uint32_t)x134);
    x136 = (x18 + x135);
    x137 = (x17 + x136);
    x138 = (x137 & UINT32_C(0x3fffff));
    x139 = (uint8_t)(x137 >> 22);
    x140 = (x16 + (uint32_t)x139);
    x141 = (x15 + x140);
    x142 = (x14 + x141);
    x143 = (x142 & UINT32_C(0x3fffff));
    x144 = (uint8_t)(x142 >> 22);
    x145 = (x13 + (uint32_t)x144);
    x146 = (x12 + x145);
    x147 = (x146 & UINT32_C(0x3fffff));
    x148 = (fiat_id_tc26_gost_3410_2012_512_paramSetA_uint1)(x146 >> 22);
    x149 = (x11 + (uint32_t)x148);
    x150 = (x10 + x149);
    x151 = (x9 + x150);
    x152 = (x151 & UINT32_C(0x7fffff));
    x153 = (uint8_t)(x151 >> 23);
    x154 = (x8 + (uint32_t)x153);
    x155 = (x7 + x154);
    x156 = (x6 + x155);
    x157 = (x156 & UINT32_C(0x3fffff));
    x158 = (uint8_t)(x156 >> 22);
    x159 = (x5 + (uint32_t)x158);
    x160 = (x4 + x159);
    x161 = (x3 + x160);
    x162 = (x161 & UINT32_C(0x3fffff));
    x163 = (uint8_t)(x161 >> 22);
    x164 = (x2 + (uint32_t)x163);
    x165 = (x1 + x164);
    out1[0] = x67;
    out1[1] = x72;
    out1[2] = x77;
    out1[3] = x82;
    out1[4] = x85;
    out1[5] = x88;
    out1[6] = x93;
    out1[7] = x98;
    out1[8] = x103;
    out1[9] = x107;
    out1[10] = x112;
    out1[11] = x117;
    out1[12] = x122;
    out1[13] = x125;
    out1[14] = x128;
    out1[15] = x133;
    out1[16] = x138;
    out1[17] = x143;
    out1[18] = x147;
    out1[19] = x152;
    out1[20] = x157;
    out1[21] = x162;
    out1[22] = x165;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_tc26_gost_3410_2012_512_paramSetA/fe_inv.op3
 * custom repunit addition chain
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(fe_t output,
                                                          const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t102, t12, t198, t2, t200, t24, t3, t400, t48, t502, t6, t96;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, acc, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t3);
    for (i = 0; i < 2; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t6, acc, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t6);
    for (i = 0; i < 5; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t12, acc, t6);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t12);
    for (i = 0; i < 11; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t24, acc, t12);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t24);
    for (i = 0; i < 23; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t48, acc, t24);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t48);
    for (i = 0; i < 47; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t96, acc, t48);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t96);
    for (i = 0; i < 5; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t102, acc, t6);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t102);
    for (i = 0; i < 95; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t198, acc, t96);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t198);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t200, acc, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t200);
    for (i = 0; i < 199; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t400, acc, t200);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t400);
    for (i = 0; i < 101; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t502, acc, t102);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, t502);
    for (i = 0; i < 3; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(acc, acc, t3);
    for (i = 0; i < 4; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(acc, acc, t1);
    for (i = 0; i < 2; i++)
        fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(acc, acc);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(output, acc, t1);
}

/* curve coefficient constants */

static const limb_t const_one[23] = {
    UINT32_C(0x00000001), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000)};

static const limb_t const_b[23] = {
    UINT32_C(0x0071C760), UINT32_C(0x0020F0B4), UINT32_C(0x000A818C),
    UINT32_C(0x007DC8EC), UINT32_C(0x003E753A), UINT32_C(0x001D862E),
    UINT32_C(0x00036A43), UINT32_C(0x00457401), UINT32_C(0x002C2996),
    UINT32_C(0x00398693), UINT32_C(0x00396121), UINT32_C(0x00132F71),
    UINT32_C(0x000FD0B6), UINT32_C(0x002F4207), UINT32_C(0x0030E879),
    UINT32_C(0x0051D872), UINT32_C(0x0025C12B), UINT32_C(0x003E3B46),
    UINT32_C(0x0015B333), UINT32_C(0x00037A16), UINT32_C(0x00321B77),
    UINT32_C(0x0005DEDF), UINT32_C(0x003A3094)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[11][16] = {
    {
        {{UINT32_C(0x00000003), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000)},
         {UINT32_C(0x0015F2A4), UINT32_C(0x001396A4), UINT32_C(0x00044D2C),
          UINT32_C(0x0046BEB7), UINT32_C(0x003F97F0), UINT32_C(0x00298028),
          UINT32_C(0x0038E907), UINT32_C(0x005E6A50), UINT32_C(0x001D27AE),
          UINT32_C(0x0027E81B), UINT32_C(0x002C4D7C), UINT32_C(0x00490EF8),
          UINT32_C(0x001CBEFA), UINT32_C(0x0020193F), UINT32_C(0x002BC177),
          UINT32_C(0x004EB3C6), UINT32_C(0x0032F0E4), UINT32_C(0x000A1CD9),
          UINT32_C(0x000B712A), UINT32_C(0x004C3710), UINT32_C(0x000DAB8E),
          UINT32_C(0x003E87A8), UINT32_C(0x001D40F3)}},
        {{UINT32_C(0x004B87C3), UINT32_C(0x0028D0F9), UINT32_C(0x0020B709),
          UINT32_C(0x000A89D0), UINT32_C(0x0033EE84), UINT32_C(0x003AEC55),
          UINT32_C(0x000C2241), UINT32_C(0x0032F57B), UINT32_C(0x002BAEC9),
          UINT32_C(0x002696E9), UINT32_C(0x00250816), UINT32_C(0x005D2A1E),
          UINT32_C(0x001F488F), UINT32_C(0x0010A475), UINT32_C(0x0028A117),
          UINT32_C(0x00302585), UINT32_C(0x002D8AB6), UINT32_C(0x002CFF09),
          UINT32_C(0x002EDAD2), UINT32_C(0x006A726B), UINT32_C(0x002899FA),
          UINT32_C(0x002B2712), UINT32_C(0x00287FC6)},
         {UINT32_C(0x000D90D6), UINT32_C(0x002FD8A3), UINT32_C(0x003892E6),
          UINT32_C(0x0049F6D8), UINT32_C(0x001BDC46), UINT32_C(0x0014C636),
          UINT32_C(0x002531B7), UINT32_C(0x007AC2FE), UINT32_C(0x002DDD59),
          UINT32_C(0x0033E260), UINT32_C(0x00275EFC), UINT32_C(0x0075988E),
          UINT32_C(0x003333F7), UINT32_C(0x0020678F), UINT32_C(0x000FBFA3),
          UINT32_C(0x00235FE1), UINT32_C(0x0020F1D2), UINT32_C(0x00373098),
          UINT32_C(0x000C4DDA), UINT32_C(0x00606E9E), UINT32_C(0x00118DFC),
          UINT32_C(0x000417EC), UINT32_C(0x000F2D71)}},
        {{UINT32_C(0x007F1E5F), UINT32_C(0x001419C8), UINT32_C(0x002CF1D7),
          UINT32_C(0x000E5B8F), UINT32_C(0x00025B6A), UINT32_C(0x00099E5B),
          UINT32_C(0x001804DC), UINT32_C(0x002F7572), UINT32_C(0x002A640E),
          UINT32_C(0x000FB103), UINT32_C(0x00291840), UINT32_C(0x007FD916),
          UINT32_C(0x0005B8C9), UINT32_C(0x00131C59), UINT32_C(0x0031C148),
          UINT32_C(0x002BF81B), UINT32_C(0x00139B07), UINT32_C(0x002FF2FF),
          UINT32_C(0x00049C2D), UINT32_C(0x0011BB6C), UINT32_C(0x002B0A64),
          UINT32_C(0x001D12B8), UINT32_C(0x0015A2A0)},
         {UINT32_C(0x0006CBC6), UINT32_C(0x0027724E), UINT32_C(0x00302B5D),
          UINT32_C(0x001BC2F1), UINT32_C(0x003F55C0), UINT32_C(0x003AA25F),
          UINT32_C(0x00232F00), UINT32_C(0x0074A629), UINT32_C(0x00037B4E),
          UINT32_C(0x0024E8BE), UINT32_C(0x002A188A), UINT32_C(0x002CB205),
          UINT32_C(0x0003ED36), UINT32_C(0x001C4269), UINT32_C(0x002BD5C1),
          UINT32_C(0x0026AD6C), UINT32_C(0x001235FE), UINT32_C(0x001CF2C0),
          UINT32_C(0x0024E745), UINT32_C(0x0068766F), UINT32_C(0x002BE51F),
          UINT32_C(0x001B57A0), UINT32_C(0x001E35B3)}},
        {{UINT32_C(0x005256E0), UINT32_C(0x003F836F), UINT32_C(0x00373455),
          UINT32_C(0x0075BA3A), UINT32_C(0x002108B7), UINT32_C(0x001C82BE),
          UINT32_C(0x00267DD8), UINT32_C(0x004ECEBF), UINT32_C(0x002F62E6),
          UINT32_C(0x000A8F9E), UINT32_C(0x000CDAFA), UINT32_C(0x0043A073),
          UINT32_C(0x00313659), UINT32_C(0x00154A30), UINT32_C(0x0016402E),
          UINT32_C(0x001175DB), UINT32_C(0x000E2798), UINT32_C(0x001F5060),
          UINT32_C(0x0033E5EC), UINT32_C(0x001D0B54), UINT32_C(0x001ADD71),
          UINT32_C(0x0023DAD9), UINT32_C(0x001E1CA5)},
         {UINT32_C(0x00755E5A), UINT32_C(0x00183470), UINT32_C(0x0023F0D4),
          UINT32_C(0x00313928), UINT32_C(0x002DD729), UINT32_C(0x001D3E91),
          UINT32_C(0x0035AE71), UINT32_C(0x005318A6), UINT32_C(0x002F3EDB),
          UINT32_C(0x00289630), UINT32_C(0x0038D891), UINT32_C(0x007CF062),
          UINT32_C(0x0038EE6A), UINT32_C(0x0013AFF2), UINT32_C(0x002E68F8),
          UINT32_C(0x0064FAA0), UINT32_C(0x003BF0E8), UINT32_C(0x000AA0E7),
          UINT32_C(0x0002840F), UINT32_C(0x003DE33E), UINT32_C(0x0022D493),
          UINT32_C(0x003F570B), UINT32_C(0x002197B3)}},
        {{UINT32_C(0x003642A2), UINT32_C(0x00299DCA), UINT32_C(0x003D77E1),
          UINT32_C(0x00489D30), UINT32_C(0x0027522E), UINT32_C(0x00240D64),
          UINT32_C(0x002F9F74), UINT32_C(0x0019C938), UINT32_C(0x00296297),
          UINT32_C(0x001E1814), UINT32_C(0x0004E1B7), UINT32_C(0x0023D69C),
          UINT32_C(0x0003213C), UINT32_C(0x0004FF86), UINT32_C(0x001C3786),
          UINT32_C(0x00304EA3), UINT32_C(0x0014189F), UINT32_C(0x0006EA0F),
          UINT32_C(0x00069315), UINT32_C(0x0011E349), UINT32_C(0x00397B6C),
          UINT32_C(0x0000F3CD), UINT32_C(0x002183EC)},
         {UINT32_C(0x002E3C8E), UINT32_C(0x00250F3A), UINT32_C(0x003F23C0),
          UINT32_C(0x000E6089), UINT32_C(0x001AA647), UINT32_C(0x001449A0),
          UINT32_C(0x001EE430), UINT32_C(0x006EFFDC), UINT32_C(0x002D388D),
          UINT32_C(0x0019E36B), UINT32_C(0x001D016D), UINT32_C(0x000829C5),
          UINT32_C(0x00391C21), UINT32_C(0x00271FC6), UINT32_C(0x002F3A60),
          UINT32_C(0x0019B88F), UINT32_C(0x001CF454), UINT32_C(0x002B6D5C),
          UINT32_C(0x001DAE4B), UINT32_C(0x0014A040), UINT32_C(0x002920C3),
          UINT32_C(0x0017BC1F), UINT32_C(0x0019D5E3)}},
        {{UINT32_C(0x00135C5B), UINT32_C(0x001DC3CE), UINT32_C(0x0004C781),
          UINT32_C(0x00080E30), UINT32_C(0x0009851D), UINT32_C(0x00350569),
          UINT32_C(0x002E8442), UINT32_C(0x001051D8), UINT32_C(0x0004FD70),
          UINT32_C(0x00134424), UINT32_C(0x000F2B29), UINT32_C(0x00685F52),
          UINT32_C(0x002DDECE), UINT32_C(0x00008902), UINT32_C(0x002F4764),
          UINT32_C(0x000E5C3D), UINT32_C(0x0032A0B9), UINT32_C(0x001A6033),
          UINT32_C(0x0012A3E6), UINT32_C(0x006BF5EC), UINT32_C(0x003D93F8),
          UINT32_C(0x00360B6E), UINT32_C(0x0018B3FC)},
         {UINT32_C(0x004ECF79), UINT32_C(0x0000B2AA), UINT32_C(0x003FB9C2),
          UINT32_C(0x0078CE6D), UINT32_C(0x001215D4), UINT32_C(0x0038E3DD),
          UINT32_C(0x000C3346), UINT32_C(0x004C9060), UINT32_C(0x003D3143),
          UINT32_C(0x00243B10), UINT32_C(0x00259423), UINT32_C(0x006A2B73),
          UINT32_C(0x0028505D), UINT32_C(0x000AE48C), UINT32_C(0x0000C6EE),
          UINT32_C(0x00572490), UINT32_C(0x0027D956), UINT32_C(0x0014406A),
          UINT32_C(0x0033BE99), UINT32_C(0x0018C2FA), UINT32_C(0x002F3AF0),
          UINT32_C(0x001405C5), UINT32_C(0x00064B19)}},
        {{UINT32_C(0x001F2EBD), UINT32_C(0x000510C7), UINT32_C(0x0019AE41),
          UINT32_C(0x007CB53E), UINT32_C(0x003AB38E), UINT32_C(0x003266F9),
          UINT32_C(0x00208EB6), UINT32_C(0x006D10F3), UINT32_C(0x001D6C3A),
          UINT32_C(0x002D7D80), UINT32_C(0x000B3C9D), UINT32_C(0x0048BDA2),
          UINT32_C(0x0014CC2E), UINT32_C(0x00156682), UINT32_C(0x000BAEBC),
          UINT32_C(0x0032A9C9), UINT32_C(0x001FD4D5), UINT32_C(0x00323040),
          UINT32_C(0x00282E72), UINT32_C(0x003CE90A), UINT32_C(0x0007C3A6),
          UINT32_C(0x0004F672), UINT32_C(0x0019034A)},
         {UINT32_C(0x004DEA72), UINT32_C(0x00355CF9), UINT32_C(0x002BBD82),
          UINT32_C(0x004625D7), UINT32_C(0x0035A89F), UINT32_C(0x002CE049),
          UINT32_C(0x001D8906), UINT32_C(0x0000050C), UINT32_C(0x00357091),
          UINT32_C(0x001D1A1C), UINT32_C(0x001A15E2), UINT32_C(0x002C9AA7),
          UINT32_C(0x001B1721), UINT32_C(0x003B7772), UINT32_C(0x003075BA),
          UINT32_C(0x003ACE9C), UINT32_C(0x0018B5B9), UINT32_C(0x001483A0),
          UINT32_C(0x002B8443), UINT32_C(0x000D0833), UINT32_C(0x0011414E),
          UINT32_C(0x00377005), UINT32_C(0x001FE0BC)}},
        {{UINT32_C(0x00614D45), UINT32_C(0x000FACE1), UINT32_C(0x002E03FD),
          UINT32_C(0x00104582), UINT32_C(0x0027B6D8), UINT32_C(0x002E45CA),
          UINT32_C(0x003DC391), UINT32_C(0x000278F0), UINT32_C(0x00150F86),
          UINT32_C(0x002EDE47), UINT32_C(0x0025399C), UINT32_C(0x004DCCC4),
          UINT32_C(0x00186E7C), UINT32_C(0x000987AE), UINT32_C(0x00082ECC),
          UINT32_C(0x007B6EE3), UINT32_C(0x00097785), UINT32_C(0x003E0986),
          UINT32_C(0x001C91ED), UINT32_C(0x0061A3C8), UINT32_C(0x00291652),
          UINT32_C(0x00089F6C), UINT32_C(0x000C0F4E)},
         {UINT32_C(0x00341422), UINT32_C(0x0016F7F9), UINT32_C(0x002A2213),
          UINT32_C(0x000CC4C8), UINT32_C(0x002A5108), UINT32_C(0x0014C3FF),
          UINT32_C(0x002A84FF), UINT32_C(0x007C98C9), UINT32_C(0x001C8206),
          UINT32_C(0x0031B7CB), UINT32_C(0x0037BB04), UINT32_C(0x003E3334),
          UINT32_C(0x0029AEB3), UINT32_C(0x003E65DA), UINT32_C(0x0020EE26),
          UINT32_C(0x00779AF6), UINT32_C(0x00288AFE), UINT32_C(0x000D4B8D),
          UINT32_C(0x001DB51B), UINT32_C(0x003BF6A3), UINT32_C(0x00381A92),
          UINT32_C(0x0011D531), UINT32_C(0x00247F4E)}},
        {{UINT32_C(0x00709AE6), UINT32_C(0x00252549), UINT32_C(0x0007EE34),
          UINT32_C(0x005D8045), UINT32_C(0x0038367B), UINT32_C(0x0035CCF0),
          UINT32_C(0x0005CD45), UINT32_C(0x0072DFB7), UINT32_C(0x00059B58),
          UINT32_C(0x002BB6E5), UINT32_C(0x003546BA), UINT32_C(0x001567C4),
          UINT32_C(0x003C5F98), UINT32_C(0x002503E9), UINT32_C(0x003AB5A8),
          UINT32_C(0x002858EB), UINT32_C(0x001535BC), UINT32_C(0x002DC366),
          UINT32_C(0x0034ED0D), UINT32_C(0x00277DED), UINT32_C(0x00016E7E),
          UINT32_C(0x001A35D9), UINT32_C(0x00234EA3)},
         {UINT32_C(0x0003CF55), UINT32_C(0x0026EE0D), UINT32_C(0x0025529F),
          UINT32_C(0x0031335F), UINT32_C(0x00305D60), UINT32_C(0x00148F61),
          UINT32_C(0x00343772), UINT32_C(0x004BD619), UINT32_C(0x0012E0C0),
          UINT32_C(0x0013EA6E), UINT32_C(0x001A3BC0), UINT32_C(0x0069B10D),
          UINT32_C(0x002CCEED), UINT32_C(0x002B62B5), UINT32_C(0x003456E2),
          UINT32_C(0x0005151D), UINT32_C(0x00374FB6), UINT32_C(0x000F4CCC),
          UINT32_C(0x001978D4), UINT32_C(0x003FA7E6), UINT32_C(0x00266D24),
          UINT32_C(0x00248D2B), UINT32_C(0x00161AD6)}},
        {{UINT32_C(0x0032C9A3), UINT32_C(0x002C7C77), UINT32_C(0x000E3F02),
          UINT32_C(0x003E504E), UINT32_C(0x001351CC), UINT32_C(0x00177427),
          UINT32_C(0x0020C8E9), UINT32_C(0x0019A4C7), UINT32_C(0x000B0C5D),
          UINT32_C(0x001F549F), UINT32_C(0x003B0C1B), UINT32_C(0x0021F5DE),
          UINT32_C(0x000075B2), UINT32_C(0x0036927D), UINT32_C(0x00185855),
          UINT32_C(0x004BD125), UINT32_C(0x0014BBC7), UINT32_C(0x001C0CC6),
          UINT32_C(0x0022540C), UINT32_C(0x00552107), UINT32_C(0x002283DD),
          UINT32_C(0x0006BA78), UINT32_C(0x0013823D)},
         {UINT32_C(0x001F97DE), UINT32_C(0x0028B5D5), UINT32_C(0x0030F546),
          UINT32_C(0x0001A0B0), UINT32_C(0x0010CC6D), UINT32_C(0x001610C3),
          UINT32_C(0x00245BEB), UINT32_C(0x003016D1), UINT32_C(0x001B8316),
          UINT32_C(0x0016BA74), UINT32_C(0x002C99F7), UINT32_C(0x001CC511),
          UINT32_C(0x0017550A), UINT32_C(0x0002060A), UINT32_C(0x00256CB7),
          UINT32_C(0x0040BF9E), UINT32_C(0x0016677B), UINT32_C(0x0007D673),
          UINT32_C(0x00182B4F), UINT32_C(0x002E8ADB), UINT32_C(0x001CBED4),
          UINT32_C(0x002D048B), UINT32_C(0x000C037A)}},
        {{UINT32_C(0x005B2170), UINT32_C(0x002A20E5), UINT32_C(0x003A2CC9),
          UINT32_C(0x002D459D), UINT32_C(0x001DECC6), UINT32_C(0x0031C1FE),
          UINT32_C(0x000CE89C), UINT32_C(0x0028CB4A), UINT32_C(0x00228929),
          UINT32_C(0x000C455B), UINT32_C(0x00288443), UINT32_C(0x0019205F),
          UINT32_C(0x0023421A), UINT32_C(0x00352E01), UINT32_C(0x001E5137),
          UINT32_C(0x0074C0C9), UINT32_C(0x0003A0D7), UINT32_C(0x003A7F32),
          UINT32_C(0x002BDAAB), UINT32_C(0x0038CE1E), UINT32_C(0x000991A9),
          UINT32_C(0x0031AAF9), UINT32_C(0x0036FF6B)},
         {UINT32_C(0x006C89E0), UINT32_C(0x00256380), UINT32_C(0x001F7866),
          UINT32_C(0x000F7CD3), UINT32_C(0x001E0162), UINT32_C(0x001A7772),
          UINT32_C(0x000474B0), UINT32_C(0x001B3366), UINT32_C(0x0024C27D),
          UINT32_C(0x0033397C), UINT32_C(0x002DDFF7), UINT32_C(0x0003D06F),
          UINT32_C(0x003CE689), UINT32_C(0x00087AFA), UINT32_C(0x00135BED),
          UINT32_C(0x001E1302), UINT32_C(0x003FD153), UINT32_C(0x003F3F3D),
          UINT32_C(0x0005DB43), UINT32_C(0x006193C9), UINT32_C(0x00174036),
          UINT32_C(0x00258D52), UINT32_C(0x00046F1F)}},
        {{UINT32_C(0x0049FC14), UINT32_C(0x00007614), UINT32_C(0x001F7037),
          UINT32_C(0x00592750), UINT32_C(0x00290B61), UINT32_C(0x000960A8),
          UINT32_C(0x00194FF1), UINT32_C(0x00139CAC), UINT32_C(0x003E0952),
          UINT32_C(0x00270EC5), UINT32_C(0x00088B6C), UINT32_C(0x004C78F1),
          UINT32_C(0x001D53F4), UINT32_C(0x003170C1), UINT32_C(0x001BD840),
          UINT32_C(0x00705662), UINT32_C(0x0020DE92), UINT32_C(0x00128651),
          UINT32_C(0x003E0D7F), UINT32_C(0x007F2363), UINT32_C(0x00029F44),
          UINT32_C(0x001B5FCC), UINT32_C(0x0012DCB6)},
         {UINT32_C(0x00715C01), UINT32_C(0x003BA447), UINT32_C(0x0014B2CF),
          UINT32_C(0x000D0598), UINT32_C(0x0021BD5E), UINT32_C(0x003B2771),
          UINT32_C(0x001C4456), UINT32_C(0x000B7702), UINT32_C(0x0034AD46),
          UINT32_C(0x0020B4D4), UINT32_C(0x0034C10F), UINT32_C(0x00211BEE),
          UINT32_C(0x00229380), UINT32_C(0x000F7D2E), UINT32_C(0x001DCFEE),
          UINT32_C(0x00667394), UINT32_C(0x00181E9B), UINT32_C(0x000423C4),
          UINT32_C(0x001ECE77), UINT32_C(0x00170479), UINT32_C(0x0032353F),
          UINT32_C(0x00164DF6), UINT32_C(0x0016F1DE)}},
        {{UINT32_C(0x0075C5F8), UINT32_C(0x000385BF), UINT32_C(0x0031DD89),
          UINT32_C(0x006E52CD), UINT32_C(0x0007AB18), UINT32_C(0x001DB7D7),
          UINT32_C(0x00181DB9), UINT32_C(0x003116D9), UINT32_C(0x002F42C8),
          UINT32_C(0x001008A8), UINT32_C(0x000955A8), UINT32_C(0x0016157F),
          UINT32_C(0x00366962), UINT32_C(0x00374B18), UINT32_C(0x003DA6A4),
          UINT32_C(0x004DD8AE), UINT32_C(0x00303056), UINT32_C(0x000814A3),
          UINT32_C(0x001FD98E), UINT32_C(0x0054633B), UINT32_C(0x00196306),
          UINT32_C(0x0036BE52), UINT32_C(0x001CFF52)},
         {UINT32_C(0x006F6BD4), UINT32_C(0x00363198), UINT32_C(0x0027A4A2),
          UINT32_C(0x002E0CC3), UINT32_C(0x003815C9), UINT32_C(0x003F3192),
          UINT32_C(0x0037B67C), UINT32_C(0x0030F20C), UINT32_C(0x002A1B35),
          UINT32_C(0x0016C2B1), UINT32_C(0x0010040B), UINT32_C(0x006D50BA),
          UINT32_C(0x0015627B), UINT32_C(0x00236233), UINT32_C(0x002BD95D),
          UINT32_C(0x0068647C), UINT32_C(0x003DB8B8), UINT32_C(0x00090EB1),
          UINT32_C(0x001829ED), UINT32_C(0x003AA621), UINT32_C(0x00281854),
          UINT32_C(0x000579E2), UINT32_C(0x0027CDA0)}},
        {{UINT32_C(0x0056E4C3), UINT32_C(0x000E21FF), UINT32_C(0x0024F3B1),
          UINT32_C(0x002D126D), UINT32_C(0x00125D7C), UINT32_C(0x0011EF67),
          UINT32_C(0x000BD798), UINT32_C(0x00018629), UINT32_C(0x001299FE),
          UINT32_C(0x0016DCCD), UINT32_C(0x001DB60A), UINT32_C(0x002AB062),
          UINT32_C(0x003E7DDD), UINT32_C(0x002F1BF6), UINT32_C(0x000F1421),
          UINT32_C(0x007DDEFC), UINT32_C(0x0022F932), UINT32_C(0x00327FBB),
          UINT32_C(0x001E3684), UINT32_C(0x000F04E8), UINT32_C(0x0028B9F5),
          UINT32_C(0x0000AC17), UINT32_C(0x001B586E)},
         {UINT32_C(0x0029C581), UINT32_C(0x001F0CDD), UINT32_C(0x000C57C8),
          UINT32_C(0x005909C4), UINT32_C(0x003A26ED), UINT32_C(0x0032886A),
          UINT32_C(0x0002D003), UINT32_C(0x0047BC86), UINT32_C(0x0004B488),
          UINT32_C(0x0028EAC9), UINT32_C(0x00007E5F), UINT32_C(0x002AFB2F),
          UINT32_C(0x0029FDA2), UINT32_C(0x00161194), UINT32_C(0x0003E7BC),
          UINT32_C(0x000F8369), UINT32_C(0x000E94CC), UINT32_C(0x0037E9AD),
          UINT32_C(0x0007994D), UINT32_C(0x00620DA2), UINT32_C(0x001C54F1),
          UINT32_C(0x0003054F), UINT32_C(0x000F164E)}},
        {{UINT32_C(0x00485A6F), UINT32_C(0x0004577D), UINT32_C(0x003E3EB4),
          UINT32_C(0x006C4E40), UINT32_C(0x00032DFF), UINT32_C(0x0036D9C3),
          UINT32_C(0x003133C3), UINT32_C(0x003BD1C9), UINT32_C(0x002755D5),
          UINT32_C(0x00118134), UINT32_C(0x001160F0), UINT32_C(0x00059163),
          UINT32_C(0x003EB8FC), UINT32_C(0x00056FC9), UINT32_C(0x0028AED8),
          UINT32_C(0x003179B5), UINT32_C(0x003FBF05), UINT32_C(0x00011E59),
          UINT32_C(0x00011744), UINT32_C(0x003470B0), UINT32_C(0x00135BDE),
          UINT32_C(0x00158952), UINT32_C(0x0000E6DB)},
         {UINT32_C(0x00532F1F), UINT32_C(0x003906A8), UINT32_C(0x002A32FC),
          UINT32_C(0x00227E49), UINT32_C(0x00058EDF), UINT32_C(0x003D7DB2),
          UINT32_C(0x0023DC29), UINT32_C(0x0070553D), UINT32_C(0x0004329B),
          UINT32_C(0x003549B6), UINT32_C(0x003EC868), UINT32_C(0x000D7C98),
          UINT32_C(0x00368C50), UINT32_C(0x000F57E5), UINT32_C(0x00126458),
          UINT32_C(0x004D62F6), UINT32_C(0x0031CEF3), UINT32_C(0x00204DE0),
          UINT32_C(0x00072E81), UINT32_C(0x007DA6C8), UINT32_C(0x003D4C1E),
          UINT32_C(0x003FAAA5), UINT32_C(0x0018B7EB)}},
        {{UINT32_C(0x005B2BEF), UINT32_C(0x002EEA64), UINT32_C(0x0035ADEF),
          UINT32_C(0x00037B6A), UINT32_C(0x003D7F26), UINT32_C(0x003F7AE8),
          UINT32_C(0x0016082B), UINT32_C(0x004D0845), UINT32_C(0x003213FD),
          UINT32_C(0x002B907C), UINT32_C(0x0009D773), UINT32_C(0x0032EB9F),
          UINT32_C(0x000B9447), UINT32_C(0x000FF14B), UINT32_C(0x002CC862),
          UINT32_C(0x000EE902), UINT32_C(0x001A1E93), UINT32_C(0x003B5022),
          UINT32_C(0x0007EC85), UINT32_C(0x00773A1A), UINT32_C(0x001E3782),
          UINT32_C(0x001F2F23), UINT32_C(0x00371A25)},
         {UINT32_C(0x00500C90), UINT32_C(0x00012947), UINT32_C(0x00276B35),
          UINT32_C(0x00055EB4), UINT32_C(0x000B22A3), UINT32_C(0x001C3032),
          UINT32_C(0x0034B27D), UINT32_C(0x0058FC68), UINT32_C(0x001DB835),
          UINT32_C(0x0000E22D), UINT32_C(0x0026AF65), UINT32_C(0x005F11AC),
          UINT32_C(0x002AB077), UINT32_C(0x0016A2BF), UINT32_C(0x002DE969),
          UINT32_C(0x0014F0F9), UINT32_C(0x00142DA0), UINT32_C(0x00197B6C),
          UINT32_C(0x00098CD4), UINT32_C(0x0076AB0A), UINT32_C(0x003EDF05),
          UINT32_C(0x00165EF4), UINT32_C(0x002E8B63)}},
    },
    {
        {{UINT32_C(0x0043FF72), UINT32_C(0x00371016), UINT32_C(0x00088C3D),
          UINT32_C(0x003D3831), UINT32_C(0x0029E105), UINT32_C(0x000874C9),
          UINT32_C(0x0028AD35), UINT32_C(0x0050A745), UINT32_C(0x00129E17),
          UINT32_C(0x0006826F), UINT32_C(0x0003A7E7), UINT32_C(0x005A9957),
          UINT32_C(0x003F5A11), UINT32_C(0x001E0D75), UINT32_C(0x00132E4A),
          UINT32_C(0x001CACF1), UINT32_C(0x00106741), UINT32_C(0x0035B4A8),
          UINT32_C(0x0038B784), UINT32_C(0x007346F0), UINT32_C(0x003DB373),
          UINT32_C(0x001CED8B), UINT32_C(0x003B3CAB)},
         {UINT32_C(0x0005ACA1), UINT32_C(0x0003F976), UINT32_C(0x000C0B13),
          UINT32_C(0x007066AA), UINT32_C(0x0037D80F), UINT32_C(0x00150B30),
          UINT32_C(0x0022F326), UINT32_C(0x0034AEAA), UINT32_C(0x0008FECE),
          UINT32_C(0x0038E83F), UINT32_C(0x003A6384), UINT32_C(0x0015A868),
          UINT32_C(0x000D1591), UINT32_C(0x00111853), UINT32_C(0x0007CCDC),
          UINT32_C(0x00088671), UINT32_C(0x000325D9), UINT32_C(0x0030192A),
          UINT32_C(0x0001A7CA), UINT32_C(0x00363760), UINT32_C(0x001F97E8),
          UINT32_C(0x002C79F3), UINT32_C(0x001B4F8F)}},
        {{UINT32_C(0x006A80D4), UINT32_C(0x0039A871), UINT32_C(0x001DED13),
          UINT32_C(0x003F5D25), UINT32_C(0x0009BD11), UINT32_C(0x0015E36E),
          UINT32_C(0x000EE574), UINT32_C(0x006F2527), UINT32_C(0x0004BD44),
          UINT32_C(0x003A9039), UINT32_C(0x00158327), UINT32_C(0x0007B459),
          UINT32_C(0x002C3FC0), UINT32_C(0x002902E4), UINT32_C(0x002368B3),
          UINT32_C(0x0054306B), UINT32_C(0x002E6771), UINT32_C(0x0000025A),
          UINT32_C(0x00359E84), UINT32_C(0x00753A6D), UINT32_C(0x001F1043),
          UINT32_C(0x00198B2D), UINT32_C(0x001D7912)},
         {UINT32_C(0x007E5CCB), UINT32_C(0x000738A9), UINT32_C(0x00164BE0),
          UINT32_C(0x001D6B62), UINT32_C(0x000EF92E), UINT32_C(0x00280CB8),
          UINT32_C(0x0037C2AD), UINT32_C(0x00569D4A), UINT32_C(0x00279D0C),
          UINT32_C(0x002F59F7), UINT32_C(0x003DAC74), UINT32_C(0x0042978C),
          UINT32_C(0x0010DA80), UINT32_C(0x00217A9D), UINT32_C(0x00336498),
          UINT32_C(0x00239BFB), UINT32_C(0x00367CF4), UINT32_C(0x00002665),
          UINT32_C(0x0012FC23), UINT32_C(0x006B55F4), UINT32_C(0x0008389E),
          UINT32_C(0x0010C55C), UINT32_C(0x003917A5)}},
        {{UINT32_C(0x000B001B), UINT32_C(0x0036253F), UINT32_C(0x00364099),
          UINT32_C(0x00403910), UINT32_C(0x002FD274), UINT32_C(0x00240152),
          UINT32_C(0x002222A5), UINT32_C(0x00038A33), UINT32_C(0x0015B0C3),
          UINT32_C(0x001BA804), UINT32_C(0x000B91C9), UINT32_C(0x001E1D50),
          UINT32_C(0x002C6A3F), UINT32_C(0x0002DA6D), UINT32_C(0x0031CDE7),
          UINT32_C(0x005F8ABA), UINT32_C(0x0032F16C), UINT32_C(0x0005F59E),
          UINT32_C(0x0027FB7F), UINT32_C(0x003F4395), UINT32_C(0x0005567B),
          UINT32_C(0x00037388), UINT32_C(0x0031BC7C)},
         {UINT32_C(0x0021EB64), UINT32_C(0x000F56D8), UINT32_C(0x00063940),
          UINT32_C(0x007222D6), UINT32_C(0x002072C6), UINT32_C(0x002E61E2),
          UINT32_C(0x0016F379), UINT32_C(0x0027EADF), UINT32_C(0x003A6BD2),
          UINT32_C(0x002F0B3A), UINT32_C(0x002FFAE6), UINT32_C(0x007DBBB0),
          UINT32_C(0x00003399), UINT32_C(0x0015CF91), UINT32_C(0x00284363),
          UINT32_C(0x003DC09B), UINT32_C(0x00305937), UINT32_C(0x001A75E2),
          UINT32_C(0x0028D44C), UINT32_C(0x0052188E), UINT32_C(0x003F5117),
          UINT32_C(0x002A7B19), UINT32_C(0x000F38A9)}},
        {{UINT32_C(0x0068B2E0), UINT32_C(0x0017FFC5), UINT32_C(0x0027AFC3),
          UINT32_C(0x000A45A1), UINT32_C(0x001227B7), UINT32_C(0x000976FE),
          UINT32_C(0x003CC399), UINT32_C(0x00111C12), UINT32_C(0x0021CDEC),
          UINT32_C(0x000290FA), UINT32_C(0x000E0DC4), UINT32_C(0x004B8791),
          UINT32_C(0x003123B8), UINT32_C(0x00257E85), UINT32_C(0x0031095C),
          UINT32_C(0x00009042), UINT32_C(0x002E0671), UINT32_C(0x002EDE50),
          UINT32_C(0x002522AF), UINT32_C(0x002113DA), UINT32_C(0x002136C8),
          UINT32_C(0x003A4426), UINT32_C(0x00375E38)},
         {UINT32_C(0x004B72D7), UINT32_C(0x00317636), UINT32_C(0x002C6B14),
          UINT32_C(0x0023C200), UINT32_C(0x00229CA0), UINT32_C(0x0018AB4E),
          UINT32_C(0x0038DE7C), UINT32_C(0x0071C6F7), UINT32_C(0x0006D850),
          UINT32_C(0x0007F5A9), UINT32_C(0x001ADEAD), UINT32_C(0x00171F68),
          UINT32_C(0x0018927F), UINT32_C(0x001A4C5E), UINT32_C(0x0000DDCC),
          UINT32_C(0x0038263E), UINT32_C(0x003C1F7F), UINT32_C(0x001B3C9A),
          UINT32_C(0x003488F3), UINT32_C(0x0023C421), UINT32_C(0x002F2417),
          UINT32_C(0x00068EDA), UINT32_C(0x00073EC6)}},
        {{UINT32_C(0x00740829), UINT32_C(0x003BBE8D), UINT32_C(0x00073E98),
          UINT32_C(0x00356FAD), UINT32_C(0x003B7DDB), UINT32_C(0x002DC94B),
          UINT32_C(0x0030C9A3), UINT32_C(0x001B8A3C), UINT32_C(0x0023BCCD),
          UINT32_C(0x0003F076), UINT32_C(0x003A8A39), UINT32_C(0x0067C926),
          UINT32_C(0x00057C86), UINT32_C(0x0027A91E), UINT32_C(0x0006BFD0),
          UINT32_C(0x00268025), UINT32_C(0x0026C695), UINT32_C(0x0030F65C),
          UINT32_C(0x0007A146), UINT32_C(0x001C03BD), UINT32_C(0x001A48A6),
          UINT32_C(0x00327209), UINT32_C(0x00331030)},
         {UINT32_C(0x004BBAF6), UINT32_C(0x0014ED13), UINT32_C(0x00201E53),
          UINT32_C(0x0019209B), UINT32_C(0x0018CD1E), UINT32_C(0x000DEF6D),
          UINT32_C(0x00038012), UINT32_C(0x0045882E), UINT32_C(0x003736AB),
          UINT32_C(0x001E713A), UINT32_C(0x002C4DFB), UINT32_C(0x003F0EEF),
          UINT32_C(0x002CFF2D), UINT32_C(0x003250F5), UINT32_C(0x00078ABA),
          UINT32_C(0x00678753), UINT32_C(0x00056E90), UINT32_C(0x00198BB5),
          UINT32_C(0x003CE0AD), UINT32_C(0x007FA3C4), UINT32_C(0x00393AC2),
          UINT32_C(0x00207404), UINT32_C(0x001C83C6)}},
        {{UINT32_C(0x0006EF83), UINT32_C(0x0015F1B3), UINT32_C(0x0012AA0F),
          UINT32_C(0x0014518C), UINT32_C(0x002839B7), UINT32_C(0x000D1D3A),
          UINT32_C(0x0004C1BA), UINT32_C(0x005F75C2), UINT32_C(0x000D10B9),
          UINT32_C(0x0013D894), UINT32_C(0x000DB952), UINT32_C(0x000B1478),
          UINT32_C(0x000CB9AA), UINT32_C(0x0011AD2E), UINT32_C(0x002894C3),
          UINT32_C(0x0011DD4E), UINT32_C(0x000303E2), UINT32_C(0x001EEC21),
          UINT32_C(0x001A194B), UINT32_C(0x005970C2), UINT32_C(0x00271263),
          UINT32_C(0x0037CD83), UINT32_C(0x0000E91B)},
         {UINT32_C(0x0002F7FB), UINT32_C(0x0037D3D0), UINT32_C(0x00167E4D),
          UINT32_C(0x002B340E), UINT32_C(0x0029810C), UINT32_C(0x000F2744),
          UINT32_C(0x000500A9), UINT32_C(0x0077B334), UINT32_C(0x0033BBF3),
          UINT32_C(0x0035F681), UINT32_C(0x002A089F), UINT32_C(0x0005BD0A),
          UINT32_C(0x0034B55C), UINT32_C(0x001C94F6), UINT32_C(0x003E80FE),
          UINT32_C(0x0012E6AD), UINT32_C(0x002E5578), UINT32_C(0x000FCD23),
          UINT32_C(0x003D81BB), UINT32_C(0x000E9FC4), UINT32_C(0x002DCA2E),
          UINT32_C(0x00163735), UINT32_C(0x00331F02)}},
        {{UINT32_C(0x006924AC), UINT32_C(0x0035ADA0), UINT32_C(0x001100A8),
          UINT32_C(0x00267DEA), UINT32_C(0x00271C3D), UINT32_C(0x0028011C),
          UINT32_C(0x0033F146), UINT32_C(0x00380BD9), UINT32_C(0x001E9B99),
          UINT32_C(0x0038A9B3), UINT32_C(0x0023055C), UINT32_C(0x00402C40),
          UINT32_C(0x000E057B), UINT32_C(0x002F5047), UINT32_C(0x0030ABB8),
          UINT32_C(0x00177283), UINT32_C(0x00151E5A), UINT32_C(0x0026A491),
          UINT32_C(0x00346A9D), UINT32_C(0x006A2686), UINT32_C(0x0010AE09),
          UINT32_C(0x0031479F), UINT32_C(0x003F9361)},
         {UINT32_C(0x0022A729), UINT32_C(0x001A0AB6), UINT32_C(0x003A1834),
          UINT32_C(0x004ADEAE), UINT32_C(0x0025C51B), UINT32_C(0x00380B76),
          UINT32_C(0x00109BCA), UINT32_C(0x00326C1B), UINT32_C(0x002680D8),
          UINT32_C(0x003F48F6), UINT32_C(0x000DCE07), UINT32_C(0x000D0CDC),
          UINT32_C(0x0024513C), UINT32_C(0x001AAF42), UINT32_C(0x000F88A1),
          UINT32_C(0x007680CC), UINT32_C(0x00032E52), UINT32_C(0x00028B7A),
          UINT32_C(0x0028F444), UINT32_C(0x0013B5EA), UINT32_C(0x000BE2FE),
          UINT32_C(0x00382F79), UINT32_C(0x0026D469)}},
        {{UINT32_C(0x002EF810), UINT32_C(0x003D7CA9), UINT32_C(0x0012A7CA),
          UINT32_C(0x0066ED19), UINT32_C(0x003B6782), UINT32_C(0x001A688B),
          UINT32_C(0x00057236), UINT32_C(0x003AB1DD), UINT32_C(0x002DCA9F),
          UINT32_C(0x00318D65), UINT32_C(0x002C3201), UINT32_C(0x002651F2),
          UINT32_C(0x0002585A), UINT32_C(0x00110B33), UINT32_C(0x002FC48F),
          UINT32_C(0x0027FF7F), UINT32_C(0x000C314B), UINT32_C(0x00306B0F),
          UINT32_C(0x002BCD62), UINT32_C(0x000E5451), UINT32_C(0x00372C81),
          UINT32_C(0x0008B694), UINT32_C(0x001640E1)},
         {UINT32_C(0x005D5544), UINT32_C(0x00050CE4), UINT32_C(0x0017634F),
          UINT32_C(0x0013A04A), UINT32_C(0x00106FDB), UINT32_C(0x001DFA5D),
          UINT32_C(0x002B04EB), UINT32_C(0x0049FF7C), UINT32_C(0x0026E744),
          UINT32_C(0x003D42A5), UINT32_C(0x002B0FD6), UINT32_C(0x0076FAC0),
          UINT32_C(0x003ACF9E), UINT32_C(0x000B293A), UINT32_C(0x00120F10),
          UINT32_C(0x0056D4D7), UINT32_C(0x003229A1), UINT32_C(0x001C7884),
          UINT32_C(0x003CE57D), UINT32_C(0x003C86A7), UINT32_C(0x001588C1),
          UINT32_C(0x0000D548), UINT32_C(0x0011BB4A)}},
        {{UINT32_C(0x0036250B), UINT32_C(0x00274CE1), UINT32_C(0x003F5FE8),
          UINT32_C(0x00112AFF), UINT32_C(0x0004D6DD), UINT32_C(0x0037A903),
          UINT32_C(0x00211DC3), UINT32_C(0x0030C9D5), UINT32_C(0x003F5472),
          UINT32_C(0x00198593), UINT32_C(0x000093E8), UINT32_C(0x001F8BFF),
          UINT32_C(0x0000C9FF), UINT32_C(0x003D63D2), UINT32_C(0x00003D23),
          UINT32_C(0x00153CAB), UINT32_C(0x003CA8E7), UINT32_C(0x000F7F9C),
          UINT32_C(0x0017381E), UINT32_C(0x003B2121), UINT32_C(0x0006A36E),
          UINT32_C(0x0020DF0D), UINT32_C(0x002DCC34)},
         {UINT32_C(0x001DDE59), UINT32_C(0x00100B9E), UINT32_C(0x001387EC),
          UINT32_C(0x001F5F47), UINT32_C(0x0037E7AF), UINT32_C(0x00193274),
          UINT32_C(0x002F43DE), UINT32_C(0x0018E845), UINT32_C(0x002C7EEB),
          UINT32_C(0x0031E7AD), UINT32_C(0x0003754D), UINT32_C(0x00107B6F),
          UINT32_C(0x0006C7A7), UINT32_C(0x002EFA28), UINT32_C(0x00230679),
          UINT32_C(0x003BA29A), UINT32_C(0x003EB83E), UINT32_C(0x000E3477),
          UINT32_C(0x00312658), UINT32_C(0x006C10E6), UINT32_C(0x00372B67),
          UINT32_C(0x000F6596), UINT32_C(0x00380597)}},
        {{UINT32_C(0x00555AFE), UINT32_C(0x000C7849), UINT32_C(0x00042F9D),
          UINT32_C(0x0007EDFA), UINT32_C(0x000C752B), UINT32_C(0x00137CA0),
          UINT32_C(0x002A9FBE), UINT32_C(0x00565768), UINT32_C(0x00015078),
          UINT32_C(0x0037865E), UINT32_C(0x0022585A), UINT32_C(0x005C7329),
          UINT32_C(0x00230050), UINT32_C(0x002EAD2B), UINT32_C(0x001FFAB6),
          UINT32_C(0x007012D8), UINT32_C(0x00118E18), UINT32_C(0x0031CBE8),
          UINT32_C(0x0034B659), UINT32_C(0x000C9258), UINT32_C(0x00123325),
          UINT32_C(0x001F45F2), UINT32_C(0x002B0B5E)},
         {UINT32_C(0x0063E131), UINT32_C(0x002CEABB), UINT32_C(0x0003CF06),
          UINT32_C(0x005C2801), UINT32_C(0x0014448A), UINT32_C(0x001F4570),
          UINT32_C(0x001DE032), UINT32_C(0x007965E9), UINT32_C(0x001C2619),
          UINT32_C(0x001A84C4), UINT32_C(0x003CA51E), UINT32_C(0x005F8927),
          UINT32_C(0x001ED00E), UINT32_C(0x0018ABCE), UINT32_C(0x00282492),
          UINT32_C(0x002A4526), UINT32_C(0x001D6653), UINT32_C(0x000D9615),
          UINT32_C(0x0011E6F0), UINT32_C(0x00671D54), UINT32_C(0x00340830),
          UINT32_C(0x001EF0D7), UINT32_C(0x002FBB7B)}},
        {{UINT32_C(0x00348880), UINT32_C(0x0032B440), UINT32_C(0x003867FD),
          UINT32_C(0x0041325C), UINT32_C(0x000CDBC2), UINT32_C(0x00065444),
          UINT32_C(0x0028F475), UINT32_C(0x001DA4B4), UINT32_C(0x00109841),
          UINT32_C(0x003B0866), UINT32_C(0x001E6A77), UINT32_C(0x005D249E),
          UINT32_C(0x0039C59B), UINT32_C(0x003A6F13), UINT32_C(0x0038A7E4),
          UINT32_C(0x005AE286), UINT32_C(0x002F9473), UINT32_C(0x00023261),
          UINT32_C(0x003A0DB2), UINT32_C(0x001E7F01), UINT32_C(0x0036BF40),
          UINT32_C(0x000E2AEC), UINT32_C(0x000C8DE1)},
         {UINT32_C(0x0053791C), UINT32_C(0x0025ADBE), UINT32_C(0x001DF305),
          UINT32_C(0x005CB9A7), UINT32_C(0x002A8658), UINT32_C(0x00101F47),
          UINT32_C(0x00329A71), UINT32_C(0x006E7F78), UINT32_C(0x003CB686),
          UINT32_C(0x002818C0), UINT32_C(0x0013DEA8), UINT32_C(0x0001AD5E),
          UINT32_C(0x002F79EF), UINT32_C(0x002D66C0), UINT32_C(0x001DABD2),
          UINT32_C(0x00602B71), UINT32_C(0x002903C7), UINT32_C(0x00385466),
          UINT32_C(0x001CDB64), UINT32_C(0x0075CE9A), UINT32_C(0x002430BD),
          UINT32_C(0x00176946), UINT32_C(0x000E2BC5)}},
        {{UINT32_C(0x007C9263), UINT32_C(0x002D6DC4), UINT32_C(0x003D3ACD),
          UINT32_C(0x003EBF76), UINT32_C(0x003E1EFB), UINT32_C(0x002E4716),
          UINT32_C(0x000F0DD6), UINT32_C(0x003B4748), UINT32_C(0x00073A35),
          UINT32_C(0x003EB153), UINT32_C(0x003DBAE5), UINT32_C(0x00091752),
          UINT32_C(0x00152A69), UINT32_C(0x003A6B6D), UINT32_C(0x00190CE0),
          UINT32_C(0x000C4F96), UINT32_C(0x002AEE5B), UINT32_C(0x002D6E94),
          UINT32_C(0x00298B92), UINT32_C(0x002FC509), UINT32_C(0x000EA268),
          UINT32_C(0x000701E4), UINT32_C(0x003CBD22)},
         {UINT32_C(0x0068BB5F), UINT32_C(0x003E426A), UINT32_C(0x000ABA98),
          UINT32_C(0x0063696E), UINT32_C(0x000CA3AE), UINT32_C(0x0030D3D9),
          UINT32_C(0x000E9E5C), UINT32_C(0x0046B796), UINT32_C(0x00098D02),
          UINT32_C(0x001C097A), UINT32_C(0x00322587), UINT32_C(0x004192A0),
          UINT32_C(0x00117CF5), UINT32_C(0x0019B330), UINT32_C(0x001C614E),
          UINT32_C(0x007DC495), UINT32_C(0x0010F1B4), UINT32_C(0x00303802),
          UINT32_C(0x0039F211), UINT32_C(0x00330A82), UINT32_C(0x002DD8DA),
          UINT32_C(0x002D36F2), UINT32_C(0x00017BC2)}},
        {{UINT32_C(0x0049325F), UINT32_C(0x003DB33B), UINT32_C(0x0029EBF5),
          UINT32_C(0x001C7997), UINT32_C(0x0033F6E9), UINT32_C(0x0030C1AD),
          UINT32_C(0x00361DDF), UINT32_C(0x0034088E), UINT32_C(0x002A26DB),
          UINT32_C(0x00050A8F), UINT32_C(0x002D5CB6), UINT32_C(0x002B3ACD),
          UINT32_C(0x002F102C), UINT32_C(0x001D8F3E), UINT32_C(0x0036E06F),
          UINT32_C(0x005F6B74), UINT32_C(0x0003DC5F), UINT32_C(0x003135D7),
          UINT32_C(0x0038E39F), UINT32_C(0x007B5A1E), UINT32_C(0x000355D0),
          UINT32_C(0x0016256E), UINT32_C(0x00091FAA)},
         {UINT32_C(0x004EEA23), UINT32_C(0x002F50B1), UINT32_C(0x001CBFB6),
          UINT32_C(0x0077CA4A), UINT32_C(0x002E434E), UINT32_C(0x003F8B6D),
          UINT32_C(0x0033265D), UINT32_C(0x006DC04A), UINT32_C(0x0017B7FE),
          UINT32_C(0x00156470), UINT32_C(0x001C0AB3), UINT32_C(0x002B82A3),
          UINT32_C(0x0025ED15), UINT32_C(0x00345415), UINT32_C(0x00006AE3),
          UINT32_C(0x006A18D6), UINT32_C(0x000651B4), UINT32_C(0x00324AF0),
          UINT32_C(0x0019FD45), UINT32_C(0x00756504), UINT32_C(0x000D0EB8),
          UINT32_C(0x001080DF), UINT32_C(0x00117135)}},
        {{UINT32_C(0x0002201B), UINT32_C(0x002573D3), UINT32_C(0x002B796D),
          UINT32_C(0x000F77C6), UINT32_C(0x001FA05B), UINT32_C(0x0004EA6D),
          UINT32_C(0x003790D1), UINT32_C(0x004517CB), UINT32_C(0x003D97B6),
          UINT32_C(0x0015B191), UINT32_C(0x00311E57), UINT32_C(0x0037CE58),
          UINT32_C(0x00151409), UINT32_C(0x000D6BCF), UINT32_C(0x000C5CA5),
          UINT32_C(0x0063737A), UINT32_C(0x00299B77), UINT32_C(0x000C37E1),
          UINT32_C(0x000F27AA), UINT32_C(0x0057C9C2), UINT32_C(0x0030EDD0),
          UINT32_C(0x003C12B9), UINT32_C(0x003AE308)},
         {UINT32_C(0x00154AEB), UINT32_C(0x0008F6CC), UINT32_C(0x001668D8),
          UINT32_C(0x004663DD), UINT32_C(0x000D8D93), UINT32_C(0x001CE5F0),
          UINT32_C(0x0021BF83), UINT32_C(0x006BAE95), UINT32_C(0x002855B3),
          UINT32_C(0x00335B55), UINT32_C(0x001408AA), UINT32_C(0x0004E3E5),
          UINT32_C(0x0028E855), UINT32_C(0x0014E502), UINT32_C(0x0008E67D),
          UINT32_C(0x006EDAAA), UINT32_C(0x001D9F0F), UINT32_C(0x0009DC94),
          UINT32_C(0x003A18E2), UINT32_C(0x0007FA8E), UINT32_C(0x003E00BB),
          UINT32_C(0x002A56FF), UINT32_C(0x00038554)}},
        {{UINT32_C(0x007A0037), UINT32_C(0x003D491D), UINT32_C(0x003C391C),
          UINT32_C(0x006294C3), UINT32_C(0x00303F10), UINT32_C(0x0026A8E1),
          UINT32_C(0x0028D44A), UINT32_C(0x004CD241), UINT32_C(0x001AC12E),
          UINT32_C(0x0032802C), UINT32_C(0x0017518C), UINT32_C(0x004B7FF7),
          UINT32_C(0x00184785), UINT32_C(0x000C137F), UINT32_C(0x0020C5E6),
          UINT32_C(0x002E88CB), UINT32_C(0x00109C0D), UINT32_C(0x003AF23C),
          UINT32_C(0x0037A943), UINT32_C(0x00209953), UINT32_C(0x0015B4E0),
          UINT32_C(0x00069845), UINT32_C(0x00093EA8)},
         {UINT32_C(0x0004A991), UINT32_C(0x003F0551), UINT32_C(0x000D6C31),
          UINT32_C(0x006F47D6), UINT32_C(0x00007E9B), UINT32_C(0x0027E38C),
          UINT32_C(0x0033BB37), UINT32_C(0x0013496D), UINT32_C(0x001A3F2A),
          UINT32_C(0x0014FCBA), UINT32_C(0x002722F6), UINT32_C(0x005676F1),
          UINT32_C(0x00213E52), UINT32_C(0x003DF1C7), UINT32_C(0x00228B30),
          UINT32_C(0x006856C0), UINT32_C(0x0022A73D), UINT32_C(0x0000B650),
          UINT32_C(0x000EABEB), UINT32_C(0x00714726), UINT32_C(0x00128875),
          UINT32_C(0x000EB41C), UINT32_C(0x0018CA4B)}},
        {{UINT32_C(0x007BD9EC), UINT32_C(0x001763E0), UINT32_C(0x003A0DDC),
          UINT32_C(0x00731C43), UINT32_C(0x00293989), UINT32_C(0x00347EFA),
          UINT32_C(0x00115B21), UINT32_C(0x003B45B4), UINT32_C(0x000DA37F),
          UINT32_C(0x002C87D5), UINT32_C(0x001C53C2), UINT32_C(0x007822F8),
          UINT32_C(0x0008496E), UINT32_C(0x003D3CB7), UINT32_C(0x0008A383),
          UINT32_C(0x00735A84), UINT32_C(0x000876BD), UINT32_C(0x00141FF0),
          UINT32_C(0x003567B3), UINT32_C(0x00785465), UINT32_C(0x0030D346),
          UINT32_C(0x0032C983), UINT32_C(0x0016542B)},
         {UINT32_C(0x00175998), UINT32_C(0x00105962), UINT32_C(0x0027690D),
          UINT32_C(0x0053CEA1), UINT32_C(0x0027FE4A), UINT32_C(0x000377CE),
          UINT32_C(0x00029F12), UINT32_C(0x00791342), UINT32_C(0x001CD5D3),
          UINT32_C(0x0024804D), UINT32_C(0x00318CBD), UINT32_C(0x000AC20C),
          UINT32_C(0x002261A2), UINT32_C(0x00017C07), UINT32_C(0x0006AED6),
          UINT32_C(0x0001AE5E), UINT32_C(0x00230EA0), UINT32_C(0x00390D91),
          UINT32_C(0x0009C7FB), UINT32_C(0x002F102A), UINT32_C(0x00291350),
          UINT32_C(0x003DA578), UINT32_C(0x0013E6DE)}},
    },
    {
        {{UINT32_C(0x005C8DD6), UINT32_C(0x002A3738), UINT32_C(0x00365D8C),
          UINT32_C(0x0063DB9C), UINT32_C(0x00113081), UINT32_C(0x002F34E7),
          UINT32_C(0x003E646D), UINT32_C(0x0019B42D), UINT32_C(0x0006CC4B),
          UINT32_C(0x0037967A), UINT32_C(0x0037B63A), UINT32_C(0x00346973),
          UINT32_C(0x00175BB7), UINT32_C(0x001BAEA5), UINT32_C(0x002D90D6),
          UINT32_C(0x00235EC5), UINT32_C(0x0022B7D3), UINT32_C(0x0006C0A7),
          UINT32_C(0x000D9373), UINT32_C(0x003362B4), UINT32_C(0x00167362),
          UINT32_C(0x00228FA8), UINT32_C(0x002DC7CC)},
         {UINT32_C(0x00772F9B), UINT32_C(0x00383B30), UINT32_C(0x001FE31B),
          UINT32_C(0x0039283D), UINT32_C(0x0030E99D), UINT32_C(0x0019398C),
          UINT32_C(0x000E05D7), UINT32_C(0x001CB0B3), UINT32_C(0x0031A3E1),
          UINT32_C(0x00335E57), UINT32_C(0x003D185F), UINT32_C(0x004F30A8),
          UINT32_C(0x002CC2DA), UINT32_C(0x003CB4EE), UINT32_C(0x000D7F61),
          UINT32_C(0x006B8EDA), UINT32_C(0x0020C99D), UINT32_C(0x00342D58),
          UINT32_C(0x003BCF21), UINT32_C(0x00043EE8), UINT32_C(0x003937C7),
          UINT32_C(0x002B2687), UINT32_C(0x003099B7)}},
        {{UINT32_C(0x006F3863), UINT32_C(0x00216888), UINT32_C(0x00117F80),
          UINT32_C(0x003AECB0), UINT32_C(0x003CB3C3), UINT32_C(0x0009172C),
          UINT32_C(0x00351EE1), UINT32_C(0x000AD459), UINT32_C(0x00342449),
          UINT32_C(0x000A95A1), UINT32_C(0x00362F69), UINT32_C(0x0044683C),
          UINT32_C(0x0012100A), UINT32_C(0x000038C6), UINT32_C(0x0003DA8C),
          UINT32_C(0x004920F7), UINT32_C(0x001F5E72), UINT32_C(0x003F8B01),
          UINT32_C(0x001B2E28), UINT32_C(0x007828AE), UINT32_C(0x003B1AA3),
          UINT32_C(0x002304AF), UINT32_C(0x002983E5)},
         {UINT32_C(0x0059F3AD), UINT32_C(0x0005EBDB), UINT32_C(0x0038F715),
          UINT32_C(0x007427DF), UINT32_C(0x0035EE7F), UINT32_C(0x001A4B0D),
          UINT32_C(0x0014E6C7), UINT32_C(0x00699A32), UINT32_C(0x00015674),
          UINT32_C(0x003DC67D), UINT32_C(0x0001CDA8), UINT32_C(0x003C45B2),
          UINT32_C(0x001BE065), UINT32_C(0x000C2772), UINT32_C(0x002184E2),
          UINT32_C(0x005C0469), UINT32_C(0x0024F0B3), UINT32_C(0x002374A4),
          UINT32_C(0x0031DE85), UINT32_C(0x006B53DE), UINT32_C(0x000F651C),
          UINT32_C(0x003071EB), UINT32_C(0x0029A433)}},
        {{UINT32_C(0x0030A82F), UINT32_C(0x000EF962), UINT32_C(0x00227761),
          UINT32_C(0x006D7F9E), UINT32_C(0x000081BE), UINT32_C(0x000FEE69),
          UINT32_C(0x000752C8), UINT32_C(0x00748DEE), UINT32_C(0x00387116),
          UINT32_C(0x00287C41), UINT32_C(0x00027434), UINT32_C(0x00664A85),
          UINT32_C(0x001D3DE1), UINT32_C(0x003D565F), UINT32_C(0x003B7ED9),
          UINT32_C(0x0065C3BB), UINT32_C(0x0023180A), UINT32_C(0x000E41D1),
          UINT32_C(0x001016CD), UINT32_C(0x0065F0C5), UINT32_C(0x0017A834),
          UINT32_C(0x0000A4AB), UINT32_C(0x001FC477)},
         {UINT32_C(0x004855D4), UINT32_C(0x001D815B), UINT32_C(0x00366682),
          UINT32_C(0x004FEE42), UINT32_C(0x001DD612), UINT32_C(0x0025BA93),
          UINT32_C(0x000E1804), UINT32_C(0x0007B46D), UINT32_C(0x00079E19),
          UINT32_C(0x00263779), UINT32_C(0x001FDFA2), UINT32_C(0x0078741F),
          UINT32_C(0x0037B69E), UINT32_C(0x0018E0A2), UINT32_C(0x0037F5D9),
          UINT32_C(0x000C71E4), UINT32_C(0x001F6109), UINT32_C(0x0002A965),
          UINT32_C(0x00358A62), UINT32_C(0x00790CBB), UINT32_C(0x001FC664),
          UINT32_C(0x00027F06), UINT32_C(0x0026A40A)}},
        {{UINT32_C(0x0060807F), UINT32_C(0x003DF3AE), UINT32_C(0x000BE26F),
          UINT32_C(0x005110E1), UINT32_C(0x003B1A48), UINT32_C(0x00326EEB),
          UINT32_C(0x001E337A), UINT32_C(0x0030A675), UINT32_C(0x003F5F8B),
          UINT32_C(0x000CD0BA), UINT32_C(0x002297FB), UINT32_C(0x000379BD),
          UINT32_C(0x0015C430), UINT32_C(0x003FE28A), UINT32_C(0x00280CE2),
          UINT32_C(0x0010A09A), UINT32_C(0x000BB43D), UINT32_C(0x003BF3E8),
          UINT32_C(0x000D2A25), UINT32_C(0x00553C3D), UINT32_C(0x003A4814),
          UINT32_C(0x0023D406), UINT32_C(0x00130434)},
         {UINT32_C(0x00012725), UINT32_C(0x00034675), UINT32_C(0x0030625E),
          UINT32_C(0x0068204C), UINT32_C(0x00007FF0), UINT32_C(0x000353D6),
          UINT32_C(0x00374D41), UINT32_C(0x002B0AEC), UINT32_C(0x002D4C90),
          UINT32_C(0x0023B516), UINT32_C(0x003D5FE1), UINT32_C(0x001BF1AF),
          UINT32_C(0x0026188F), UINT32_C(0x000277E9), UINT32_C(0x0009EDC0),
          UINT32_C(0x00419F60), UINT32_C(0x003B901E), UINT32_C(0x00036C9A),
          UINT32_C(0x001C2868), UINT32_C(0x0039BD67), UINT32_C(0x001E1FAC),
          UINT32_C(0x0018E5C8), UINT32_C(0x000D5B85)}},
        {{UINT32_C(0x000B4E46), UINT32_C(0x001C91BB), UINT32_C(0x000E149E),
          UINT32_C(0x000CF26B), UINT32_C(0x00239A61), UINT32_C(0x001413C1),
          UINT32_C(0x0039D982), UINT32_C(0x0031DC48), UINT32_C(0x000CB5E3),
          UINT32_C(0x00177633), UINT32_C(0x003594BF), UINT32_C(0x00220B88),
          UINT32_C(0x003EE0E1), UINT32_C(0x0001C29C), UINT32_C(0x00332288),
          UINT32_C(0x001AC903), UINT32_C(0x002EA788), UINT32_C(0x002CF324),
          UINT32_C(0x000A068A), UINT32_C(0x00192C4F), UINT32_C(0x003620B1),
          UINT32_C(0x003A15B7), UINT32_C(0x001846FF)},
         {UINT32_C(0x0037EA0F), UINT32_C(0x000E365F), UINT32_C(0x000AB7DB),
          UINT32_C(0x0073FC69), UINT32_C(0x0030E576), UINT32_C(0x001F51C5),
          UINT32_C(0x003E4C0F), UINT32_C(0x007734A2), UINT32_C(0x000B6D61),
          UINT32_C(0x0007F20A), UINT32_C(0x0016676C), UINT32_C(0x000742AB),
          UINT32_C(0x0024CACD), UINT32_C(0x00263F7C), UINT32_C(0x001FBB60),
          UINT32_C(0x005126DE), UINT32_C(0x001B0843), UINT32_C(0x0027E640),
          UINT32_C(0x002B6416), UINT32_C(0x000E461C), UINT32_C(0x0035712F),
          UINT32_C(0x00021FD4), UINT32_C(0x003DFB53)}},
        {{UINT32_C(0x0078AFC0), UINT32_C(0x00344524), UINT32_C(0x00032570),
          UINT32_C(0x005274D4), UINT32_C(0x001BE8C7), UINT32_C(0x0000F7FC),
          UINT32_C(0x003A3CD2), UINT32_C(0x00224B02), UINT32_C(0x003CB849),
          UINT32_C(0x00318F23), UINT32_C(0x000B31C5), UINT32_C(0x00172883),
          UINT32_C(0x000E290F), UINT32_C(0x00058FCA), UINT32_C(0x0029D5B9),
          UINT32_C(0x000EE887), UINT32_C(0x0008C23A), UINT32_C(0x000B4641),
          UINT32_C(0x0019F308), UINT32_C(0x00368406), UINT32_C(0x003235C5),
          UINT32_C(0x000F6048), UINT32_C(0x00334FC7)},
         {UINT32_C(0x00721229), UINT32_C(0x0028E47C), UINT32_C(0x0006F2DC),
          UINT32_C(0x006E7CFF), UINT32_C(0x00184C72), UINT32_C(0x003AF41E),
          UINT32_C(0x000EC9A0), UINT32_C(0x0008E682), UINT32_C(0x00294028),
          UINT32_C(0x0010CBE0), UINT32_C(0x00325E8D), UINT32_C(0x00229C6E),
          UINT32_C(0x0007AE13), UINT32_C(0x0012B92A), UINT32_C(0x001A6F8B),
          UINT32_C(0x00445E9E), UINT32_C(0x0038E62B), UINT32_C(0x000CCE4E),
          UINT32_C(0x0016D227), UINT32_C(0x005AEC2B), UINT32_C(0x002CB9C3),
          UINT32_C(0x000E9EE2), UINT32_C(0x00151064)}},
        {{UINT32_C(0x00219F11), UINT32_C(0x000EEE99), UINT32_C(0x000F0E81),
          UINT32_C(0x0014202D), UINT32_C(0x0017D47D), UINT32_C(0x0013E996),
          UINT32_C(0x001FC4D3), UINT32_C(0x007153BF), UINT32_C(0x003B0646),
          UINT32_C(0x003CCDA8), UINT32_C(0x002DB80C), UINT32_C(0x005A6567),
          UINT32_C(0x00301938), UINT32_C(0x000B2A1D), UINT32_C(0x002C1CD4),
          UINT32_C(0x0036D153), UINT32_C(0x00002DE7), UINT32_C(0x001C0718),
          UINT32_C(0x001398D4), UINT32_C(0x001C18B0), UINT32_C(0x000531C6),
          UINT32_C(0x00270891), UINT32_C(0x001D12C0)},
         {UINT32_C(0x006BF552), UINT32_C(0x00379C8C), UINT32_C(0x00124703),
          UINT32_C(0x001685D6), UINT32_C(0x000B4D76), UINT32_C(0x00354333),
          UINT32_C(0x003FD16E), UINT32_C(0x0078F567), UINT32_C(0x00228610),
          UINT32_C(0x002410D3), UINT32_C(0x0037EE2A), UINT32_C(0x002FF2A5),
          UINT32_C(0x001EA65B), UINT32_C(0x003FE56C), UINT32_C(0x00086D94),
          UINT32_C(0x0016F8D9), UINT32_C(0x00253D0C), UINT32_C(0x00110729),
          UINT32_C(0x00251056), UINT32_C(0x00771AF9), UINT32_C(0x00330BB2),
          UINT32_C(0x0030D723), UINT32_C(0x0010B52C)}},
        {{UINT32_C(0x0059EEDD), UINT32_C(0x00224DDB), UINT32_C(0x00224843),
          UINT32_C(0x00062307), UINT32_C(0x001C385D), UINT32_C(0x00214646),
          UINT32_C(0x002E9EF9), UINT32_C(0x00069FC2), UINT32_C(0x0034E86C),
          UINT32_C(0x002DE7F8), UINT32_C(0x0011547F), UINT32_C(0x00592112),
          UINT32_C(0x003BA86D), UINT32_C(0x003E5946), UINT32_C(0x001999D6),
          UINT32_C(0x0019972E), UINT32_C(0x000BEC90), UINT32_C(0x001A2575),
          UINT32_C(0x000C3FB3), UINT32_C(0x0016B2B8), UINT32_C(0x000F91C3),
          UINT32_C(0x003BE22B), UINT32_C(0x00259437)},
         {UINT32_C(0x00511BD4), UINT32_C(0x00114679), UINT32_C(0x003320B0),
          UINT32_C(0x006912DE), UINT32_C(0x00209607), UINT32_C(0x0010EA82),
          UINT32_C(0x001756FD), UINT32_C(0x0067C9A7), UINT32_C(0x00386F00),
          UINT32_C(0x0019C5A2), UINT32_C(0x000C1F54), UINT32_C(0x0060CBC7),
          UINT32_C(0x001DA7B9), UINT32_C(0x00063F18), UINT32_C(0x003D8253),
          UINT32_C(0x006757E9), UINT32_C(0x001F28E4), UINT32_C(0x003F4512),
          UINT32_C(0x0015BA1B), UINT32_C(0x00296BBE), UINT32_C(0x001E7448),
          UINT32_C(0x0027173C), UINT32_C(0x00385C41)}},
        {{UINT32_C(0x001A30EE), UINT32_C(0x003F8DAD), UINT32_C(0x000A157B),
          UINT32_C(0x002E76B6), UINT32_C(0x0003B33B), UINT32_C(0x00067B4F),
          UINT32_C(0x00338572), UINT32_C(0x004A7886), UINT32_C(0x000AF814),
          UINT32_C(0x00231F5B), UINT32_C(0x003A7866), UINT32_C(0x001BC9D8),
          UINT32_C(0x002EC718), UINT32_C(0x000F7210), UINT32_C(0x0038A200),
          UINT32_C(0x0024BD8B), UINT32_C(0x0025403D), UINT32_C(0x002338A0),
          UINT32_C(0x00197FC8), UINT32_C(0x007EFFC4), UINT32_C(0x002C8ED2),
          UINT32_C(0x002F359C), UINT32_C(0x0007199C)},
         {UINT32_C(0x003AA840), UINT32_C(0x001FEBA5), UINT32_C(0x00204035),
          UINT32_C(0x001437DE), UINT32_C(0x0030877E), UINT32_C(0x001DC9D8),
          UINT32_C(0x0022F529), UINT32_C(0x004AA308), UINT32_C(0x0008CF16),
          UINT32_C(0x00227F26), UINT32_C(0x0030EA93), UINT32_C(0x00444D20),
          UINT32_C(0x000FC049), UINT32_C(0x0025FECC), UINT32_C(0x00366A3B),
          UINT32_C(0x0075F2C6), UINT32_C(0x002D58DE), UINT32_C(0x00037A47),
          UINT32_C(0x001143E7), UINT32_C(0x0066F889), UINT32_C(0x001AA585),
          UINT32_C(0x0008637C), UINT32_C(0x00285D24)}},
        {{UINT32_C(0x001684FD), UINT32_C(0x0026202E), UINT32_C(0x00229298),
          UINT32_C(0x0038BA17), UINT32_C(0x001143E4), UINT32_C(0x0004C67B),
          UINT32_C(0x0009A1D3), UINT32_C(0x00359003), UINT32_C(0x0000CF20),
          UINT32_C(0x003C8E67), UINT32_C(0x0025DDF6), UINT32_C(0x00167020),
          UINT32_C(0x000C3320), UINT32_C(0x0032FD4F), UINT32_C(0x001D4DDD),
          UINT32_C(0x002ABE07), UINT32_C(0x0015D694), UINT32_C(0x002025E4),
          UINT32_C(0x0024B490), UINT32_C(0x00237C45), UINT32_C(0x000F2232),
          UINT32_C(0x00172623), UINT32_C(0x003F2420)},
         {UINT32_C(0x0031C43A), UINT32_C(0x002504F9), UINT32_C(0x002A5346),
          UINT32_C(0x00085709), UINT32_C(0x00181464), UINT32_C(0x0016AE98),
          UINT32_C(0x0005937D), UINT32_C(0x007E227E), UINT32_C(0x0021E344),
          UINT32_C(0x002D37F2), UINT32_C(0x003BABA8), UINT32_C(0x0076BA1E),
          UINT32_C(0x001E9354), UINT32_C(0x001FB1CD), UINT32_C(0x002FA365),
          UINT32_C(0x0037F2A0), UINT32_C(0x00150FF4), UINT32_C(0x0001D5DC),
          UINT32_C(0x003D537E), UINT32_C(0x003F0F28), UINT32_C(0x002C7BEA),
          UINT32_C(0x003C8613), UINT32_C(0x0032181B)}},
        {{UINT32_C(0x004FDBFF), UINT32_C(0x00279110), UINT32_C(0x0014218E),
          UINT32_C(0x006FF570), UINT32_C(0x000BEE6D), UINT32_C(0x001AC4BF),
          UINT32_C(0x00168284), UINT32_C(0x00204FD9), UINT32_C(0x0009E49A),
          UINT32_C(0x00375F6C), UINT32_C(0x00188591), UINT32_C(0x00711953),
          UINT32_C(0x003F4432), UINT32_C(0x00196529), UINT32_C(0x00394538),
          UINT32_C(0x0018F2F6), UINT32_C(0x002CA7B0), UINT32_C(0x00013757),
          UINT32_C(0x001F2763), UINT32_C(0x001F675A), UINT32_C(0x002051A1),
          UINT32_C(0x003E27EB), UINT32_C(0x001862D5)},
         {UINT32_C(0x00762CA4), UINT32_C(0x0008C476), UINT32_C(0x00324E43),
          UINT32_C(0x002A5BED), UINT32_C(0x002FCB16), UINT32_C(0x003A2EC2),
          UINT32_C(0x000DAC89), UINT32_C(0x001B1EA8), UINT32_C(0x00270A0C),
          UINT32_C(0x000F92C4), UINT32_C(0x00137059), UINT32_C(0x0002C67B),
          UINT32_C(0x001DE35A), UINT32_C(0x0003AEB0), UINT32_C(0x0032086D),
          UINT32_C(0x00622727), UINT32_C(0x003663F6), UINT32_C(0x00143F44),
          UINT32_C(0x0007E1A6), UINT32_C(0x0052B971), UINT32_C(0x002A4520),
          UINT32_C(0x003B35C1), UINT32_C(0x000E5F13)}},
        {{UINT32_C(0x00377631), UINT32_C(0x00160066), UINT32_C(0x003F8625),
          UINT32_C(0x0008A975), UINT32_C(0x0011C7DC), UINT32_C(0x002AC5AE),
          UINT32_C(0x001D6AD4), UINT32_C(0x00457D6D), UINT32_C(0x000D9162),
          UINT32_C(0x0029BE2C), UINT32_C(0x0023E49C), UINT32_C(0x003CE982),
          UINT32_C(0x0029BD3F), UINT32_C(0x002FA98A), UINT32_C(0x000AAF8F),
          UINT32_C(0x0051BA4C), UINT32_C(0x000AAA3A), UINT32_C(0x00035AC4),
          UINT32_C(0x00326C9D), UINT32_C(0x0001BBF9), UINT32_C(0x00259EE8),
          UINT32_C(0x00363291), UINT32_C(0x00354D7C)},
         {UINT32_C(0x0004BACF), UINT32_C(0x00021298), UINT32_C(0x000BD9F4),
          UINT32_C(0x0043D1FD), UINT32_C(0x00144099), UINT32_C(0x0031DC66),
          UINT32_C(0x0038FF58), UINT32_C(0x001EDFDE), UINT32_C(0x000CDE37),
          UINT32_C(0x0011D4F2), UINT32_C(0x001830F3), UINT32_C(0x0066B396),
          UINT32_C(0x002B5740), UINT32_C(0x0000FE1B), UINT32_C(0x0018CA75),
          UINT32_C(0x000543A1), UINT32_C(0x0001F8BB), UINT32_C(0x003AD189),
          UINT32_C(0x002324CF), UINT32_C(0x004D2C11), UINT32_C(0x002F4CEB),
          UINT32_C(0x00158CE7), UINT32_C(0x000CC8E6)}},
        {{UINT32_C(0x0001F545), UINT32_C(0x000BAFC9), UINT32_C(0x00256984),
          UINT32_C(0x005BA1BD), UINT32_C(0x00186CC4), UINT32_C(0x00354258),
          UINT32_C(0x002C995A), UINT32_C(0x00634432), UINT32_C(0x001C8DFD),
          UINT32_C(0x0006A9F8), UINT32_C(0x003413FA), UINT32_C(0x00407583),
          UINT32_C(0x00364359), UINT32_C(0x00360343), UINT32_C(0x0004E81D),
          UINT32_C(0x0023B9E2), UINT32_C(0x00044AAC), UINT32_C(0x003E4F02),
          UINT32_C(0x000253E4), UINT32_C(0x004E1D95), UINT32_C(0x0008B230),
          UINT32_C(0x00045AB3), UINT32_C(0x00036815)},
         {UINT32_C(0x003912F5), UINT32_C(0x0038574B), UINT32_C(0x0004AD86),
          UINT32_C(0x00463316), UINT32_C(0x000037D8), UINT32_C(0x001023FC),
          UINT32_C(0x00031DE0), UINT32_C(0x007EC789), UINT32_C(0x000081EF),
          UINT32_C(0x002ABA70), UINT32_C(0x00355BFB), UINT32_C(0x00306CB6),
          UINT32_C(0x00146C52), UINT32_C(0x000D5AD0), UINT32_C(0x003681F1),
          UINT32_C(0x0063A37A), UINT32_C(0x001B646E), UINT32_C(0x000A931F),
          UINT32_C(0x0023DD86), UINT32_C(0x006F9AFA), UINT32_C(0x0008A0BB),
          UINT32_C(0x0011BD6F), UINT32_C(0x00169519)}},
        {{UINT32_C(0x00183D98), UINT32_C(0x003953F2), UINT32_C(0x00003F5C),
          UINT32_C(0x001D61CC), UINT32_C(0x0029E894), UINT32_C(0x0008FD62),
          UINT32_C(0x00124F02), UINT32_C(0x005D5510), UINT32_C(0x002CBB48),
          UINT32_C(0x0027C8EC), UINT32_C(0x002DA8A4), UINT32_C(0x00506092),
          UINT32_C(0x000D2ECA), UINT32_C(0x00080CB3), UINT32_C(0x00370B1F),
          UINT32_C(0x00264230), UINT32_C(0x00254B5D), UINT32_C(0x0030D35B),
          UINT32_C(0x00237E95), UINT32_C(0x003D3219), UINT32_C(0x000F1EE0),
          UINT32_C(0x0016F356), UINT32_C(0x000433B4)},
         {UINT32_C(0x002EDDFD), UINT32_C(0x0028836F), UINT32_C(0x0004B480),
          UINT32_C(0x00268786), UINT32_C(0x002F536C), UINT32_C(0x002AF788),
          UINT32_C(0x003B32BC), UINT32_C(0x003B16D5), UINT32_C(0x002C983E),
          UINT32_C(0x00009C26), UINT32_C(0x00267D08), UINT32_C(0x0020E60C),
          UINT32_C(0x000ECF45), UINT32_C(0x00278142), UINT32_C(0x001746F3),
          UINT32_C(0x0054A790), UINT32_C(0x0035C6AA), UINT32_C(0x00272DAC),
          UINT32_C(0x002BA52D), UINT32_C(0x0038B5A4), UINT32_C(0x003725B3),
          UINT32_C(0x003565DC), UINT32_C(0x001FF559)}},
        {{UINT32_C(0x0065D9D6), UINT32_C(0x00344FC2), UINT32_C(0x0000870B),
          UINT32_C(0x00699985), UINT32_C(0x002A5C08), UINT32_C(0x002D5249),
          UINT32_C(0x002CB5FE), UINT32_C(0x007C94CD), UINT32_C(0x001208B8),
          UINT32_C(0x00034BB9), UINT32_C(0x000F21F9), UINT32_C(0x0010B487),
          UINT32_C(0x001D773A), UINT32_C(0x0037E3B0), UINT32_C(0x002176D0),
          UINT32_C(0x0052166E), UINT32_C(0x002F70E0), UINT32_C(0x001BED82),
          UINT32_C(0x00286120), UINT32_C(0x007331ED), UINT32_C(0x001507E2),
          UINT32_C(0x003FD862), UINT32_C(0x000A5BC5)},
         {UINT32_C(0x00763783), UINT32_C(0x0011EC7B), UINT32_C(0x0006ECDB),
          UINT32_C(0x00596D37), UINT32_C(0x002D6D59), UINT32_C(0x001FB1F1),
          UINT32_C(0x0010DD1F), UINT32_C(0x003F277E), UINT32_C(0x00091B7A),
          UINT32_C(0x003FFE47), UINT32_C(0x0003D49D), UINT32_C(0x0071AF1E),
          UINT32_C(0x00173FA2), UINT32_C(0x001B76EC), UINT32_C(0x001D5248),
          UINT32_C(0x0059BE83), UINT32_C(0x003F4D6A), UINT32_C(0x001CE0D3),
          UINT32_C(0x003FDBAF), UINT32_C(0x00554CAA), UINT32_C(0x002FAF76),
          UINT32_C(0x0004DD7D), UINT32_C(0x0025BFE6)}},
        {{UINT32_C(0x0078E507), UINT32_C(0x003B0516), UINT32_C(0x00239513),
          UINT32_C(0x0026B945), UINT32_C(0x002F7EA4), UINT32_C(0x00258DAA),
          UINT32_C(0x002CA54E), UINT32_C(0x0038F70D), UINT32_C(0x0000EA33),
          UINT32_C(0x002CC019), UINT32_C(0x00322C57), UINT32_C(0x007E5F7D),
          UINT32_C(0x001BD5E1), UINT32_C(0x002300D9), UINT32_C(0x000A82FB),
          UINT32_C(0x007B959B), UINT32_C(0x00200D1E), UINT32_C(0x001F252C),
          UINT32_C(0x0021984A), UINT32_C(0x0015C036), UINT32_C(0x0016A72F),
          UINT32_C(0x00003E13), UINT32_C(0x0015AA73)},
         {UINT32_C(0x007C9D6A), UINT32_C(0x003E1441), UINT32_C(0x0011A00F),
          UINT32_C(0x0079A490), UINT32_C(0x0012D007), UINT32_C(0x003C8625),
          UINT32_C(0x001E5649), UINT32_C(0x004491D7), UINT32_C(0x00076136),
          UINT32_C(0x003E7528), UINT32_C(0x00353C0B), UINT32_C(0x0008E4BD),
          UINT32_C(0x003422E8), UINT32_C(0x00338BFD), UINT32_C(0x0027F2D6),
          UINT32_C(0x00772362), UINT32_C(0x00359B33), UINT32_C(0x003A501D),
          UINT32_C(0x00154AFF), UINT32_C(0x0049526D), UINT32_C(0x002761DE),
          UINT32_C(0x00309735), UINT32_C(0x00060B95)}},
    },
    {
        {{UINT32_C(0x00523B9F), UINT32_C(0x001A6BE6), UINT32_C(0x00036EDD),
          UINT32_C(0x0076AA2F), UINT32_C(0x003FD0E2), UINT32_C(0x00385A57),
          UINT32_C(0x00098667), UINT32_C(0x0013DD67), UINT32_C(0x0012B434),
          UINT32_C(0x00000973), UINT32_C(0x003CF995), UINT32_C(0x0045926B),
          UINT32_C(0x0002CF3D), UINT32_C(0x001B1027), UINT32_C(0x003876F6),
          UINT32_C(0x0039998A), UINT32_C(0x00398D3B), UINT32_C(0x000598D3),
          UINT32_C(0x0009E59F), UINT32_C(0x003DA91C), UINT32_C(0x0027F8FE),
          UINT32_C(0x001992EF), UINT32_C(0x001BD1E4)},
         {UINT32_C(0x005E09D8), UINT32_C(0x0027291C), UINT32_C(0x00042E2C),
          UINT32_C(0x005186A7), UINT32_C(0x00151430), UINT32_C(0x002A705A),
          UINT32_C(0x00312685), UINT32_C(0x001C5CD7), UINT32_C(0x002BC485),
          UINT32_C(0x0006B1B4), UINT32_C(0x003ED133), UINT32_C(0x006BA1BB),
          UINT32_C(0x0012B561), UINT32_C(0x001C6829), UINT32_C(0x0038F88D),
          UINT32_C(0x000FAFDF), UINT32_C(0x003A8F9C), UINT32_C(0x003B8278),
          UINT32_C(0x00075330), UINT32_C(0x00723D70), UINT32_C(0x0013971C),
          UINT32_C(0x0002A3A0), UINT32_C(0x0032D46E)}},
        {{UINT32_C(0x004A84E3), UINT32_C(0x000F993B), UINT32_C(0x0038E50F),
          UINT32_C(0x006F9D6C), UINT32_C(0x00222DDA), UINT32_C(0x00201C17),
          UINT32_C(0x003D690B), UINT32_C(0x00685E56), UINT32_C(0x003AE821),
          UINT32_C(0x00160832), UINT32_C(0x00267374), UINT32_C(0x0014A440),
          UINT32_C(0x00286466), UINT32_C(0x0037B81C), UINT32_C(0x0034FB56),
          UINT32_C(0x000A60A9), UINT32_C(0x00361F71), UINT32_C(0x002768E5),
          UINT32_C(0x002D9ADF), UINT32_C(0x00351ED3), UINT32_C(0x0026B155),
          UINT32_C(0x002ACF8B), UINT32_C(0x000CAB49)},
         {UINT32_C(0x002E7818), UINT32_C(0x00050DDB), UINT32_C(0x002F8281),
          UINT32_C(0x000426DB), UINT32_C(0x003BF6C0), UINT32_C(0x002F18B3),
          UINT32_C(0x000FDF15), UINT32_C(0x004326C8), UINT32_C(0x0034A233),
          UINT32_C(0x003F8BB5), UINT32_C(0x00252744), UINT32_C(0x005D0622),
          UINT32_C(0x000600E0), UINT32_C(0x000C538E), UINT32_C(0x002B9B96),
          UINT32_C(0x00240977), UINT32_C(0x00266E45), UINT32_C(0x000ED85F),
          UINT32_C(0x0016D56E), UINT32_C(0x005934A8), UINT32_C(0x000DE008),
          UINT32_C(0x000B7A70), UINT32_C(0x00333A6E)}},
        {{UINT32_C(0x0062AA91), UINT32_C(0x0004AD0D), UINT32_C(0x00290514),
          UINT32_C(0x0035EF4E), UINT32_C(0x003F0059), UINT32_C(0x0036F603),
          UINT32_C(0x001E8A95), UINT32_C(0x004E5E21), UINT32_C(0x003AAAD3),
          UINT32_C(0x001864B4), UINT32_C(0x00314695), UINT32_C(0x0061F315),
          UINT32_C(0x003E5320), UINT32_C(0x000A6A70), UINT32_C(0x00312DDA),
          UINT32_C(0x000CA432), UINT32_C(0x00089AF4), UINT32_C(0x0027EE81),
          UINT32_C(0x003314B2), UINT32_C(0x00569617), UINT32_C(0x00369C83),
          UINT32_C(0x00333762), UINT32_C(0x0004C25B)},
         {UINT32_C(0x0029163B), UINT32_C(0x0010F6C4), UINT32_C(0x003CFA87),
          UINT32_C(0x00413607), UINT32_C(0x0004D631), UINT32_C(0x0029CC9A),
          UINT32_C(0x0009B191), UINT32_C(0x0012E650), UINT32_C(0x0007576E),
          UINT32_C(0x002FAEF9), UINT32_C(0x001E71A7), UINT32_C(0x006D93A4),
          UINT32_C(0x00110BDB), UINT32_C(0x003C8A96), UINT32_C(0x000AB70A),
          UINT32_C(0x00161FF3), UINT32_C(0x00309EAC), UINT32_C(0x000887FB),
          UINT32_C(0x00199FC7), UINT32_C(0x007B0C04), UINT32_C(0x00030951),
          UINT32_C(0x00138445), UINT32_C(0x002C19E3)}},
        {{UINT32_C(0x001D9920), UINT32_C(0x0035A7F8), UINT32_C(0x0026F037),
          UINT32_C(0x00352EE6), UINT32_C(0x0036FF52), UINT32_C(0x000DA4B7),
          UINT32_C(0x000D5800), UINT32_C(0x0012D75B), UINT32_C(0x001E4378),
          UINT32_C(0x0006FB97), UINT32_C(0x003489D8), UINT32_C(0x007291B9),
          UINT32_C(0x002611FF), UINT32_C(0x0029220F), UINT32_C(0x003180AF),
          UINT32_C(0x003B64F1), UINT32_C(0x0029D493), UINT32_C(0x0029061E),
          UINT32_C(0x00287F20), UINT32_C(0x000A8410), UINT32_C(0x003B766F),
          UINT32_C(0x00194E12), UINT32_C(0x001C9672)},
         {UINT32_C(0x002BEBD9), UINT32_C(0x0034C959), UINT32_C(0x00372BCE),
          UINT32_C(0x0077E3FE), UINT32_C(0x002A76EF), UINT32_C(0x003B1215),
          UINT32_C(0x0017D01E), UINT32_C(0x001F6D6E), UINT32_C(0x001AF581),
          UINT32_C(0x002135B9), UINT32_C(0x0023AE9B), UINT32_C(0x00643EE2),
          UINT32_C(0x00309B0B), UINT32_C(0x00149E24), UINT32_C(0x002B829C),
          UINT32_C(0x0014D460), UINT32_C(0x0035AAB8), UINT32_C(0x001D64A4),
          UINT32_C(0x003C4123), UINT32_C(0x005FD0BE), UINT32_C(0x002680CE),
          UINT32_C(0x0032FC91), UINT32_C(0x000D5EFA)}},
        {{UINT32_C(0x0042107B), UINT32_C(0x002D79CB), UINT32_C(0x000E25C7),
          UINT32_C(0x0015D835), UINT32_C(0x0025EACC), UINT32_C(0x0038E784),
          UINT32_C(0x00133C3A), UINT32_C(0x0009780F), UINT32_C(0x0007A2B3),
          UINT32_C(0x003A0803), UINT32_C(0x00381D55), UINT32_C(0x00282268),
          UINT32_C(0x0020B921), UINT32_C(0x0037F7AC), UINT32_C(0x0013B76D),
          UINT32_C(0x003CE92F), UINT32_C(0x0025ECD4), UINT32_C(0x0030B106),
          UINT32_C(0x001D9F81), UINT32_C(0x006798C4), UINT32_C(0x000CF158),
          UINT32_C(0x003CAF9C), UINT32_C(0x003824DB)},
         {UINT32_C(0x007F6848), UINT32_C(0x0034A534), UINT32_C(0x0001B343),
          UINT32_C(0x006BF10C), UINT32_C(0x0008FCF1), UINT32_C(0x000025F0),
          UINT32_C(0x00105280), UINT32_C(0x0058FEE9), UINT32_C(0x0006B688),
          UINT32_C(0x001BEC79), UINT32_C(0x003D6BC7), UINT32_C(0x001DBC3E),
          UINT32_C(0x00298412), UINT32_C(0x002CAF5F), UINT32_C(0x003C0536),
          UINT32_C(0x006D0ED6), UINT32_C(0x002790F7), UINT32_C(0x0016B380),
          UINT32_C(0x000EA2CC), UINT32_C(0x007F2385), UINT32_C(0x001FC33E),
          UINT32_C(0x0001295D), UINT32_C(0x002EC02F)}},
        {{UINT32_C(0x001F7939), UINT32_C(0x002AC3E2), UINT32_C(0x001660F9),
          UINT32_C(0x00663A40), UINT32_C(0x001A8A13), UINT32_C(0x0023C8EF),
          UINT32_C(0x003AB7B7), UINT32_C(0x0039E16F), UINT32_C(0x001FA47B),
          UINT32_C(0x0025AB8D), UINT32_C(0x00384015), UINT32_C(0x003CE1A6),
          UINT32_C(0x0005F145), UINT32_C(0x000C1E4B), UINT32_C(0x001A72DB),
          UINT32_C(0x00203492), UINT32_C(0x003DE59E), UINT32_C(0x0010CD81),
          UINT32_C(0x002D2FAE), UINT32_C(0x0021F48A), UINT32_C(0x001C1285),
          UINT32_C(0x002EC41B), UINT32_C(0x001E8B07)},
         {UINT32_C(0x0018D1F3), UINT32_C(0x002EC53A), UINT32_C(0x00190D62),
          UINT32_C(0x0018FCFD), UINT32_C(0x000A3EE7), UINT32_C(0x0039D235),
          UINT32_C(0x00217FF2), UINT32_C(0x00142817), UINT32_C(0x002FB4F7),
          UINT32_C(0x001BB01D), UINT32_C(0x000BF067), UINT32_C(0x0052C1A1),
          UINT32_C(0x001029DF), UINT32_C(0x003B77AC), UINT32_C(0x001C5446),
          UINT32_C(0x000A8528), UINT32_C(0x00076849), UINT32_C(0x0024957C),
          UINT32_C(0x00255F16), UINT32_C(0x00464713), UINT32_C(0x0014A68E),
          UINT32_C(0x002A0E25), UINT32_C(0x0027874C)}},
        {{UINT32_C(0x00165C60), UINT32_C(0x000F1947), UINT32_C(0x00358DAC),
          UINT32_C(0x003112AB), UINT32_C(0x003CED7D), UINT32_C(0x0007D95D),
          UINT32_C(0x001BFB25), UINT32_C(0x0038039B), UINT32_C(0x002C49B9),
          UINT32_C(0x00226B1D), UINT32_C(0x00307B50), UINT32_C(0x002A8A6B),
          UINT32_C(0x003A8D6F), UINT32_C(0x002D72F9), UINT32_C(0x002F321D),
          UINT32_C(0x00530076), UINT32_C(0x002D8361), UINT32_C(0x002D2B58),
          UINT32_C(0x0032030C), UINT32_C(0x0032F5E5), UINT32_C(0x00164CE3),
          UINT32_C(0x0026D5D1), UINT32_C(0x0020444C)},
         {UINT32_C(0x002ABBE4), UINT32_C(0x003519D8), UINT32_C(0x00151482),
          UINT32_C(0x00773260), UINT32_C(0x0034B1AD), UINT32_C(0x00250B9E),
          UINT32_C(0x00302049), UINT32_C(0x00385164), UINT32_C(0x003E74F7),
          UINT32_C(0x0023B51F), UINT32_C(0x001A3158), UINT32_C(0x00527F9C),
          UINT32_C(0x003CABD3), UINT32_C(0x002F9178), UINT32_C(0x0006BAE5),
          UINT32_C(0x00600F3B), UINT32_C(0x002DF1B8), UINT32_C(0x000D590F),
          UINT32_C(0x00194149), UINT32_C(0x005DE8B8), UINT32_C(0x002325D5),
          UINT32_C(0x003EDBFF), UINT32_C(0x000AAFE1)}},
        {{UINT32_C(0x001A50FC), UINT32_C(0x00280217), UINT32_C(0x003A5F1B),
          UINT32_C(0x00412D41), UINT32_C(0x00285345), UINT32_C(0x002DBBAD),
          UINT32_C(0x000FF377), UINT32_C(0x0059899D), UINT32_C(0x0029B472),
          UINT32_C(0x00072A4A), UINT32_C(0x0028DC22), UINT32_C(0x001611B6),
          UINT32_C(0x003C3760), UINT32_C(0x0001466B), UINT32_C(0x003D8FA9),
          UINT32_C(0x00573081), UINT32_C(0x0013FB11), UINT32_C(0x00203758),
          UINT32_C(0x002E6367), UINT32_C(0x00482CF9), UINT32_C(0x003178F6),
          UINT32_C(0x001073E8), UINT32_C(0x001997C3)},
         {UINT32_C(0x0073FDFD), UINT32_C(0x002EFF90), UINT32_C(0x0014EBAD),
          UINT32_C(0x000F3618), UINT32_C(0x00162A1A), UINT32_C(0x00270E47),
          UINT32_C(0x0010A3E7), UINT32_C(0x00345497), UINT32_C(0x002C126D),
          UINT32_C(0x0036F8A6), UINT32_C(0x00166505), UINT32_C(0x0005C77A),
          UINT32_C(0x00197ED6), UINT32_C(0x00192ECC), UINT32_C(0x00233375),
          UINT32_C(0x003E0030), UINT32_C(0x000D5706), UINT32_C(0x0009709A),
          UINT32_C(0x003D8884), UINT32_C(0x00244795), UINT32_C(0x000B3F0C),
          UINT32_C(0x002420C0), UINT32_C(0x00286796)}},
        {{UINT32_C(0x000CAAE5), UINT32_C(0x00094457), UINT32_C(0x00152528),
          UINT32_C(0x001E3DB2), UINT32_C(0x0005EC25), UINT32_C(0x000BF941),
          UINT32_C(0x002A007F), UINT32_C(0x00504FD8), UINT32_C(0x003ED863),
          UINT32_C(0x003A902A), UINT32_C(0x0014F2EA), UINT32_C(0x0015DB81),
          UINT32_C(0x00280472), UINT32_C(0x003D790F), UINT32_C(0x00349779),
          UINT32_C(0x006EB09F), UINT32_C(0x00209701), UINT32_C(0x00377E4F),
          UINT32_C(0x002E600B), UINT32_C(0x00152371), UINT32_C(0x000BA435),
          UINT32_C(0x001FEF62), UINT32_C(0x0027E7F6)},
         {UINT32_C(0x00599CB9), UINT32_C(0x001549AA), UINT32_C(0x0013AF70),
          UINT32_C(0x00234B56), UINT32_C(0x00248CC3), UINT32_C(0x0032259C),
          UINT32_C(0x00203D97), UINT32_C(0x006AA891), UINT32_C(0x0005CEFE),
          UINT32_C(0x00199005), UINT32_C(0x001990D3), UINT32_C(0x00334DF5),
          UINT32_C(0x001B0BB0), UINT32_C(0x0011DD6C), UINT32_C(0x0038F1E0),
          UINT32_C(0x004EE490), UINT32_C(0x003C3321), UINT32_C(0x001F139B),
          UINT32_C(0x0006C59B), UINT32_C(0x00195C36), UINT32_C(0x00013ED7),
          UINT32_C(0x00020142), UINT32_C(0x0034FF5C)}},
        {{UINT32_C(0x002C93FF), UINT32_C(0x000319F9), UINT32_C(0x00002CB9),
          UINT32_C(0x002D18F3), UINT32_C(0x001DCA23), UINT32_C(0x000C5093),
          UINT32_C(0x001EFF04), UINT32_C(0x0075CFF0), UINT32_C(0x00064EA8),
          UINT32_C(0x0004571C), UINT32_C(0x0019B187), UINT32_C(0x0053F3E7),
          UINT32_C(0x002BFCD9), UINT32_C(0x00100147), UINT32_C(0x00381877),
          UINT32_C(0x0032E5D6), UINT32_C(0x002EC006), UINT32_C(0x00238ED2),
          UINT32_C(0x0032C67B), UINT32_C(0x00001663), UINT32_C(0x003C176A),
          UINT32_C(0x0014E21C), UINT32_C(0x00399D5E)},
         {UINT32_C(0x004E0B57), UINT32_C(0x001C2F95), UINT32_C(0x00363DC0),
          UINT32_C(0x0009DC71), UINT32_C(0x00151A34), UINT32_C(0x003159C5),
          UINT32_C(0x00201355), UINT32_C(0x00455C7C), UINT32_C(0x00070906),
          UINT32_C(0x002195FD), UINT32_C(0x001CE30A), UINT32_C(0x0073CADB),
          UINT32_C(0x0005C318), UINT32_C(0x00037022), UINT32_C(0x00053E6C),
          UINT32_C(0x0078D811), UINT32_C(0x002D5455), UINT32_C(0x000B37E3),
          UINT32_C(0x003A1081), UINT32_C(0x005948E6), UINT32_C(0x0032F5E3),
          UINT32_C(0x003F1006), UINT32_C(0x0029C6C7)}},
        {{UINT32_C(0x006A53F5), UINT32_C(0x00234585), UINT32_C(0x003B1248),
          UINT32_C(0x0031E22D), UINT32_C(0x0014C277), UINT32_C(0x001E4E41),
          UINT32_C(0x000C1028), UINT32_C(0x004CFB54), UINT32_C(0x000EA3E8),
          UINT32_C(0x00091AA9), UINT32_C(0x0026A9C7), UINT32_C(0x003266E7),
          UINT32_C(0x002E72A8), UINT32_C(0x002340FE), UINT32_C(0x00306573),
          UINT32_C(0x006B9E9A), UINT32_C(0x0035D59F), UINT32_C(0x001DB09E),
          UINT32_C(0x0005F131), UINT32_C(0x0002A91F), UINT32_C(0x003D10FA),
          UINT32_C(0x002D44C4), UINT32_C(0x001A9029)},
         {UINT32_C(0x004DC2D6), UINT32_C(0x000485AA), UINT32_C(0x00357F02),
          UINT32_C(0x00109ABD), UINT32_C(0x00277446), UINT32_C(0x002B2567),
          UINT32_C(0x003C69A7), UINT32_C(0x0031AA5D), UINT32_C(0x00308E0D),
          UINT32_C(0x000CDB91), UINT32_C(0x001A3AB7), UINT32_C(0x0043A830),
          UINT32_C(0x002FC1D1), UINT32_C(0x001FA04C), UINT32_C(0x002B3C22),
          UINT32_C(0x00400E6C), UINT32_C(0x00088655), UINT32_C(0x000D2E38),
          UINT32_C(0x002BEDE7), UINT32_C(0x0041F67A), UINT32_C(0x002EB40A),
          UINT32_C(0x00263E54), UINT32_C(0x000736A8)}},
        {{UINT32_C(0x00524DB7), UINT32_C(0x00329BD6), UINT32_C(0x002BC43F),
          UINT32_C(0x00407E56), UINT32_C(0x0006BA61), UINT32_C(0x001A5FC7),
          UINT32_C(0x000FC681), UINT32_C(0x001A5E17), UINT32_C(0x002AD8E2),
          UINT32_C(0x003C1B1E), UINT32_C(0x003028BA), UINT32_C(0x002CE10A),
          UINT32_C(0x0013F30E), UINT32_C(0x001966B5), UINT32_C(0x001C1DF1),
          UINT32_C(0x00540907), UINT32_C(0x0029361C), UINT32_C(0x000E7B5C),
          UINT32_C(0x00303DDE), UINT32_C(0x0059FB60), UINT32_C(0x00151554),
          UINT32_C(0x002838BD), UINT32_C(0x003D9CFA)},
         {UINT32_C(0x002063F9), UINT32_C(0x002731CA), UINT32_C(0x002003F0),
          UINT32_C(0x0079F9F9), UINT32_C(0x00347AC8), UINT32_C(0x0021973A),
          UINT32_C(0x001280CE), UINT32_C(0x00323A60), UINT32_C(0x00098D3C),
          UINT32_C(0x00306D49), UINT32_C(0x000109EC), UINT32_C(0x00511419),
          UINT32_C(0x0010C7B4), UINT32_C(0x001D2E21), UINT32_C(0x003991C3),
          UINT32_C(0x003C5990), UINT32_C(0x001DB860), UINT32_C(0x0014EC41),
          UINT32_C(0x00088BAC), UINT32_C(0x00448C44), UINT32_C(0x00084966),
          UINT32_C(0x0031E904), UINT32_C(0x000524F2)}},
        {{UINT32_C(0x0049E3D3), UINT32_C(0x00181A3B), UINT32_C(0x0011AA50),
          UINT32_C(0x007021E5), UINT32_C(0x00316EC7), UINT32_C(0x0029A769),
          UINT32_C(0x003F4C5A), UINT32_C(0x006AA0ED), UINT32_C(0x003E7379),
          UINT32_C(0x00150459), UINT32_C(0x0035CBC7), UINT32_C(0x005DEBB1),
          UINT32_C(0x00053C63), UINT32_C(0x000AA5E3), UINT32_C(0x0013545F),
          UINT32_C(0x00019A93), UINT32_C(0x0029934B), UINT32_C(0x000A94D0),
          UINT32_C(0x00260B29), UINT32_C(0x00298F53), UINT32_C(0x00377D15),
          UINT32_C(0x0029F246), UINT32_C(0x002F33B2)},
         {UINT32_C(0x0066FE62), UINT32_C(0x001037AD), UINT32_C(0x00370077),
          UINT32_C(0x00421175), UINT32_C(0x001E861C), UINT32_C(0x00033773),
          UINT32_C(0x002BFEA4), UINT32_C(0x0000380F), UINT32_C(0x0001544C),
          UINT32_C(0x00272751), UINT32_C(0x003FB134), UINT32_C(0x0039C926),
          UINT32_C(0x002CAB64), UINT32_C(0x0026F1D5), UINT32_C(0x00273824),
          UINT32_C(0x004BDF14), UINT32_C(0x001E4097), UINT32_C(0x00281D77),
          UINT32_C(0x00273464), UINT32_C(0x0005EB84), UINT32_C(0x002942CD),
          UINT32_C(0x003938B5), UINT32_C(0x00333CCF)}},
        {{UINT32_C(0x000B8466), UINT32_C(0x00335B47), UINT32_C(0x001C7C5F),
          UINT32_C(0x00130B87), UINT32_C(0x0002C697), UINT32_C(0x0011F099),
          UINT32_C(0x001909FC), UINT32_C(0x007C440B), UINT32_C(0x0006E6CD),
          UINT32_C(0x003604F5), UINT32_C(0x000A3664), UINT32_C(0x000E9448),
          UINT32_C(0x00375564), UINT32_C(0x00100ABB), UINT32_C(0x000A2BD1),
          UINT32_C(0x00610611), UINT32_C(0x000B0919), UINT32_C(0x00192DA1),
          UINT32_C(0x000CA6A0), UINT32_C(0x0022EC21), UINT32_C(0x0010021B),
          UINT32_C(0x0014AC0F), UINT32_C(0x003C3561)},
         {UINT32_C(0x001DE844), UINT32_C(0x000339F0), UINT32_C(0x00338277),
          UINT32_C(0x0039E865), UINT32_C(0x000C918F), UINT32_C(0x001B9202),
          UINT32_C(0x0039DB51), UINT32_C(0x0035E972), UINT32_C(0x00269806),
          UINT32_C(0x001A4703), UINT32_C(0x00128E3F), UINT32_C(0x0059736B),
          UINT32_C(0x0009133A), UINT32_C(0x000988FA), UINT32_C(0x003F5D17),
          UINT32_C(0x0075D549), UINT32_C(0x0035AF8B), UINT32_C(0x000EBF87),
          UINT32_C(0x002B5241), UINT32_C(0x001A47E1), UINT32_C(0x003FAD0B),
          UINT32_C(0x003F031A), UINT32_C(0x0000856D)}},
        {{UINT32_C(0x007BA242), UINT32_C(0x003F139F), UINT32_C(0x0011DEFD),
          UINT32_C(0x0023DE43), UINT32_C(0x00295AA0), UINT32_C(0x003AB6CE),
          UINT32_C(0x0000492A), UINT32_C(0x00038F1C), UINT32_C(0x001F3BEB),
          UINT32_C(0x000DEADE), UINT32_C(0x003039CC), UINT32_C(0x00546C46),
          UINT32_C(0x000F8C59), UINT32_C(0x00364F5D), UINT32_C(0x00278A38),
          UINT32_C(0x0003D22C), UINT32_C(0x000FDC4B), UINT32_C(0x0001BEAF),
          UINT32_C(0x00025B08), UINT32_C(0x0008F72C), UINT32_C(0x0027C5E7),
          UINT32_C(0x00252A05), UINT32_C(0x00107A50)},
         {UINT32_C(0x000EBA8F), UINT32_C(0x0027A1D4), UINT32_C(0x003EF3A3),
          UINT32_C(0x007BCF49), UINT32_C(0x003D3105), UINT32_C(0x0023E6FD),
          UINT32_C(0x00359B97), UINT32_C(0x0028F42A), UINT32_C(0x003E23D6),
          UINT32_C(0x00178851), UINT32_C(0x0037642F), UINT32_C(0x0042E04B),
          UINT32_C(0x00376AFD), UINT32_C(0x00198F42), UINT32_C(0x002F89CF),
          UINT32_C(0x000E495C), UINT32_C(0x002116C6), UINT32_C(0x00369883),
          UINT32_C(0x0005445E), UINT32_C(0x0028D909), UINT32_C(0x001123BE),
          UINT32_C(0x00395238), UINT32_C(0x000BDBC0)}},
        {{UINT32_C(0x0079A5E7), UINT32_C(0x001C3E7B), UINT32_C(0x00184F53),
          UINT32_C(0x003BBC86), UINT32_C(0x0010D687), UINT32_C(0x00038850),
          UINT32_C(0x0038E20E), UINT32_C(0x003E53AE), UINT32_C(0x0004A94C),
          UINT32_C(0x002AEB4D), UINT32_C(0x003AEB1A), UINT32_C(0x00448BCC),
          UINT32_C(0x0004DB71), UINT32_C(0x0003778D), UINT32_C(0x003944F0),
          UINT32_C(0x000CC500), UINT32_C(0x00008E46), UINT32_C(0x000F5C40),
          UINT32_C(0x00110507), UINT32_C(0x001F1E48), UINT32_C(0x003628D5),
          UINT32_C(0x00052A96), UINT32_C(0x003B94D2)},
         {UINT32_C(0x0004ABCF), UINT32_C(0x000A3BC2), UINT32_C(0x0001C80A),
          UINT32_C(0x007BDA93), UINT32_C(0x000ECD4F), UINT32_C(0x003F215D),
          UINT32_C(0x000EBBE2), UINT32_C(0x005395FC), UINT32_C(0x00074168),
          UINT32_C(0x0022A24A), UINT32_C(0x001A1B35), UINT32_C(0x0077FFE0),
          UINT32_C(0x003C9950), UINT32_C(0x0028A73C), UINT32_C(0x001AC592),
          UINT32_C(0x0023CB0D), UINT32_C(0x003F12D3), UINT32_C(0x0030ED1B),
          UINT32_C(0x002E878C), UINT32_C(0x003BA03C), UINT32_C(0x003CDBA8),
          UINT32_C(0x0021E634), UINT32_C(0x000F8610)}},
    },
    {
        {{UINT32_C(0x00374EA0), UINT32_C(0x003D49A3), UINT32_C(0x001F7E76),
          UINT32_C(0x001D6B9E), UINT32_C(0x002592C5), UINT32_C(0x000E14A2),
          UINT32_C(0x00190C56), UINT32_C(0x0063DAE2), UINT32_C(0x0039CB00),
          UINT32_C(0x001A96B0), UINT32_C(0x001112B0), UINT32_C(0x00125D57),
          UINT32_C(0x003E073B), UINT32_C(0x003BA300), UINT32_C(0x0010434F),
          UINT32_C(0x00584798), UINT32_C(0x00328C4D), UINT32_C(0x002C908E),
          UINT32_C(0x003F37C6), UINT32_C(0x0050852E), UINT32_C(0x000E2E46),
          UINT32_C(0x003A1A63), UINT32_C(0x001C643D)},
         {UINT32_C(0x00147D83), UINT32_C(0x000590DE), UINT32_C(0x001A30E1),
          UINT32_C(0x003223D8), UINT32_C(0x00092F2B), UINT32_C(0x002B60EE),
          UINT32_C(0x00044972), UINT32_C(0x0024B04F), UINT32_C(0x000F8784),
          UINT32_C(0x00015A35), UINT32_C(0x001E5404), UINT32_C(0x003B76C0),
          UINT32_C(0x0024ECFE), UINT32_C(0x00101933), UINT32_C(0x0029FDFB),
          UINT32_C(0x00224043), UINT32_C(0x00059771), UINT32_C(0x0035FA07),
          UINT32_C(0x00044AFE), UINT32_C(0x00168A97), UINT32_C(0x001D4795),
          UINT32_C(0x0016C054), UINT32_C(0x00202B01)}},
        {{UINT32_C(0x0063E7A6), UINT32_C(0x0034C8D6), UINT32_C(0x00280787),
          UINT32_C(0x001A7385), UINT32_C(0x003ABD2E), UINT32_C(0x00185E3E),
          UINT32_C(0x0000C346), UINT32_C(0x0075FF68), UINT32_C(0x00117390),
          UINT32_C(0x00234323), UINT32_C(0x00327433), UINT32_C(0x003FED4A),
          UINT32_C(0x003946EE), UINT32_C(0x00036FEB), UINT32_C(0x000C0F57),
          UINT32_C(0x00359C4A), UINT32_C(0x00092D1D), UINT32_C(0x0001A134),
          UINT32_C(0x002AD6D7), UINT32_C(0x0012395F), UINT32_C(0x003F988A),
          UINT32_C(0x001ACCFF), UINT32_C(0x002123C1)},
         {UINT32_C(0x002D5A19), UINT32_C(0x00156939), UINT32_C(0x00222C1A),
          UINT32_C(0x00619366), UINT32_C(0x0016036D), UINT32_C(0x0033459B),
          UINT32_C(0x00062D47), UINT32_C(0x004B8C12), UINT32_C(0x001B95CF),
          UINT32_C(0x00117F5F), UINT32_C(0x003F80DA), UINT32_C(0x00050A50),
          UINT32_C(0x003942D5), UINT32_C(0x00385EAE), UINT32_C(0x0033AB22),
          UINT32_C(0x00537468), UINT32_C(0x000DFF4B), UINT32_C(0x001879D6),
          UINT32_C(0x002388A7), UINT32_C(0x000FCEA6), UINT32_C(0x00375E35),
          UINT32_C(0x003398B3), UINT32_C(0x003F30BA)}},
        {{UINT32_C(0x003598D4), UINT32_C(0x0019A9A3), UINT32_C(0x003A267B),
          UINT32_C(0x002B12CC), UINT32_C(0x003839D5), UINT32_C(0x003B8D33),
          UINT32_C(0x0025BF3A), UINT32_C(0x00438430), UINT32_C(0x00189C5B),
          UINT32_C(0x003F2C8B), UINT32_C(0x003A8177), UINT32_C(0x007055A3),
          UINT32_C(0x002E6730), UINT32_C(0x00341821), UINT32_C(0x002142DE),
          UINT32_C(0x0010BC51), UINT32_C(0x000D1EA0), UINT32_C(0x0015FEF0),
          UINT32_C(0x00329B9B), UINT32_C(0x000508A4), UINT32_C(0x0001C1B9),
          UINT32_C(0x001FF600), UINT32_C(0x00328E8E)},
         {UINT32_C(0x00717603), UINT32_C(0x0033F89C), UINT32_C(0x0025C76B),
          UINT32_C(0x0018607B), UINT32_C(0x001303E9), UINT32_C(0x000F2CB5),
          UINT32_C(0x000F8CE4), UINT32_C(0x0011128F), UINT32_C(0x00216CE5),
          UINT32_C(0x003B4AEC), UINT32_C(0x0027F704), UINT32_C(0x005A2623),
          UINT32_C(0x002A1412), UINT32_C(0x0037E07D), UINT32_C(0x0007F5BF),
          UINT32_C(0x006BFF5F), UINT32_C(0x0000D2EA), UINT32_C(0x0028D09E),
          UINT32_C(0x0030FECE), UINT32_C(0x007CE886), UINT32_C(0x00163AD8),
          UINT32_C(0x00007318), UINT32_C(0x002C4F8D)}},
        {{UINT32_C(0x0022EF26), UINT32_C(0x0011DF21), UINT32_C(0x001A21E7),
          UINT32_C(0x0067A5B1), UINT32_C(0x00327468), UINT32_C(0x0031BA5C),
          UINT32_C(0x00156DC9), UINT32_C(0x001E7E4E), UINT32_C(0x003FB583),
          UINT32_C(0x001EB61F), UINT32_C(0x002ABBA4), UINT32_C(0x0040FEC8),
          UINT32_C(0x0004C5FF), UINT32_C(0x0010F939), UINT32_C(0x003D4DA2),
          UINT32_C(0x005C0941), UINT32_C(0x0013C311), UINT32_C(0x000BA027),
          UINT32_C(0x001845CC), UINT32_C(0x006FF264), UINT32_C(0x0038AC88),
          UINT32_C(0x003463D6), UINT32_C(0x000EADB9)},
         {UINT32_C(0x000B056C), UINT32_C(0x00288DB2), UINT32_C(0x001C02CF),
          UINT32_C(0x000BB175), UINT32_C(0x0018F094), UINT32_C(0x0027806D),
          UINT32_C(0x00355563), UINT32_C(0x0054C2AD), UINT32_C(0x001CCE8E),
          UINT32_C(0x002E2B85), UINT32_C(0x00073F85), UINT32_C(0x006D02CB),
          UINT32_C(0x0033434A), UINT32_C(0x003DA80B), UINT32_C(0x001550B8),
          UINT32_C(0x0053A65C), UINT32_C(0x003624AD), UINT32_C(0x00078142),
          UINT32_C(0x0017BFE5), UINT32_C(0x002EF056), UINT32_C(0x00126C8F),
          UINT32_C(0x00377035), UINT32_C(0x003C5FD9)}},
        {{UINT32_C(0x00692F52), UINT32_C(0x002D345A), UINT32_C(0x001014B5),
          UINT32_C(0x004A6F1C), UINT32_C(0x00279FEB), UINT32_C(0x00057359),
          UINT32_C(0x0005EE89), UINT32_C(0x000B0567), UINT32_C(0x002B38D3),
          UINT32_C(0x00243C26), UINT32_C(0x0000FE1B), UINT32_C(0x001499CE),
          UINT32_C(0x00326C87), UINT32_C(0x003808D0), UINT32_C(0x0024E577),
          UINT32_C(0x00559968), UINT32_C(0x0014EF5F), UINT32_C(0x00091017),
          UINT32_C(0x000A4B95), UINT32_C(0x0079EB0D), UINT32_C(0x000498F0),
          UINT32_C(0x002F7F3A), UINT32_C(0x00024E38)},
         {UINT32_C(0x000590D7), UINT32_C(0x000C5AFF), UINT32_C(0x0021F7AF),
          UINT32_C(0x00667CCB), UINT32_C(0x0038AC0E), UINT32_C(0x0023A769),
          UINT32_C(0x003E7C3D), UINT32_C(0x0052FB04), UINT32_C(0x002DE7EC),
          UINT32_C(0x002F29F5), UINT32_C(0x0023207B), UINT32_C(0x000CDF9D),
          UINT32_C(0x002B4365), UINT32_C(0x003A2FBF), UINT32_C(0x0011FB18),
          UINT32_C(0x0063AFCF), UINT32_C(0x0015B1DD), UINT32_C(0x0033B40C),
          UINT32_C(0x00012F31), UINT32_C(0x00087C46), UINT32_C(0x00099C9E),
          UINT32_C(0x0016BC64), UINT32_C(0x0032AD86)}},
        {{UINT32_C(0x00483715), UINT32_C(0x00368333), UINT32_C(0x00246073),
          UINT32_C(0x005FB045), UINT32_C(0x003A117A), UINT32_C(0x002FBC81),
          UINT32_C(0x0009FFFF), UINT32_C(0x003826CF), UINT32_C(0x00040665),
          UINT32_C(0x00248D34), UINT32_C(0x0020F6F7), UINT32_C(0x0064C39E),
          UINT32_C(0x000DDC2A), UINT32_C(0x0027F7AD), UINT32_C(0x002A0468),
          UINT32_C(0x004233A3), UINT32_C(0x0039012C), UINT32_C(0x001733DF),
          UINT32_C(0x002EFFEF), UINT32_C(0x00799097), UINT32_C(0x001FF171),
          UINT32_C(0x0018ED19), UINT32_C(0x0026CCEE)},
         {UINT32_C(0x0046E82C), UINT32_C(0x003D6F41), UINT32_C(0x001B2A06),
          UINT32_C(0x001FF2C3), UINT32_C(0x003F0F50), UINT32_C(0x0001A930),
          UINT32_C(0x003BF063), UINT32_C(0x002EE18D), UINT32_C(0x001CCFE3),
          UINT32_C(0x0036F969), UINT32_C(0x00149AD4), UINT32_C(0x0016E5BE),
          UINT32_C(0x001F9762), UINT32_C(0x0022D061), UINT32_C(0x0012E3B7),
          UINT32_C(0x0003E984), UINT32_C(0x003B3250), UINT32_C(0x0038C6B2),
          UINT32_C(0x00159530), UINT32_C(0x0073861F), UINT32_C(0x00251136),
          UINT32_C(0x00123D52), UINT32_C(0x0027A418)}},
        {{UINT32_C(0x003F3D56), UINT32_C(0x0035580A), UINT32_C(0x00315B32),
          UINT32_C(0x00683B54), UINT32_C(0x002E6B1B), UINT32_C(0x0030E284),
          UINT32_C(0x001A147C), UINT32_C(0x0057017E), UINT32_C(0x003F1CE4),
          UINT32_C(0x000739F3), UINT32_C(0x000BE2D0), UINT32_C(0x00237229),
          UINT32_C(0x0035DB98), UINT32_C(0x00013B31), UINT32_C(0x000885D5),
          UINT32_C(0x00734416), UINT32_C(0x002BCB46), UINT32_C(0x0025B709),
          UINT32_C(0x001F5588), UINT32_C(0x007AFB72), UINT32_C(0x000A3B67),
          UINT32_C(0x002F51E5), UINT32_C(0x0037F6D4)},
         {UINT32_C(0x0058DC2B), UINT32_C(0x003BC578), UINT32_C(0x003EFB94),
          UINT32_C(0x007AB5C0), UINT32_C(0x0033698C), UINT32_C(0x00384E73),
          UINT32_C(0x0018C54E), UINT32_C(0x0006017C), UINT32_C(0x00169895),
          UINT32_C(0x0032C34C), UINT32_C(0x001B77D2), UINT32_C(0x00668DCD),
          UINT32_C(0x0029D00C), UINT32_C(0x0035521D), UINT32_C(0x000871E7),
          UINT32_C(0x000881E9), UINT32_C(0x003F9CC2), UINT32_C(0x00273AEA),
          UINT32_C(0x000AFA2B), UINT32_C(0x00519C25), UINT32_C(0x00284813),
          UINT32_C(0x002F3204), UINT32_C(0x003A63D7)}},
        {{UINT32_C(0x00024391), UINT32_C(0x003BA776), UINT32_C(0x00033874),
          UINT32_C(0x0034FBCF), UINT32_C(0x00303978), UINT32_C(0x00022D87),
          UINT32_C(0x0005FC7A), UINT32_C(0x004D7ABB), UINT32_C(0x003F68E7),
          UINT32_C(0x0017EC8C), UINT32_C(0x00051303), UINT32_C(0x006259DA),
          UINT32_C(0x0021F4E5), UINT32_C(0x00121632), UINT32_C(0x0031BBFE),
          UINT32_C(0x0079B8A1), UINT32_C(0x003AE333), UINT32_C(0x0006A0FC),
          UINT32_C(0x00055308), UINT32_C(0x00601907), UINT32_C(0x002EA623),
          UINT32_C(0x003B33BA), UINT32_C(0x00349F3F)},
         {UINT32_C(0x0001E557), UINT32_C(0x000C8304), UINT32_C(0x0002EDBE),
          UINT32_C(0x001EFF0A), UINT32_C(0x003B6349), UINT32_C(0x00228976),
          UINT32_C(0x00317095), UINT32_C(0x00482B44), UINT32_C(0x002287BF),
          UINT32_C(0x00244B82), UINT32_C(0x003CFA63), UINT32_C(0x001D099B),
          UINT32_C(0x0023EB12), UINT32_C(0x00188057), UINT32_C(0x000D5E10),
          UINT32_C(0x005205C6), UINT32_C(0x002A8F5F), UINT32_C(0x002AB102),
          UINT32_C(0x00151E7A), UINT32_C(0x0031464E), UINT32_C(0x0016ACF5),
          UINT32_C(0x003C570E), UINT32_C(0x003D5498)}},
        {{UINT32_C(0x00528A5E), UINT32_C(0x001D1A41), UINT32_C(0x001D0B03),
          UINT32_C(0x006E975C), UINT32_C(0x000C8044), UINT32_C(0x0026C6AB),
          UINT32_C(0x001E178A), UINT32_C(0x0066B411), UINT32_C(0x00047104),
          UINT32_C(0x00204D14), UINT32_C(0x00228536), UINT32_C(0x000D099C),
          UINT32_C(0x000838AB), UINT32_C(0x001BC3DC), UINT32_C(0x0029FCE8),
          UINT32_C(0x00029FD9), UINT32_C(0x002E687A), UINT32_C(0x003E8AE4),
          UINT32_C(0x002DD424), UINT32_C(0x00432788), UINT32_C(0x0008979F),
          UINT32_C(0x0039EDD9), UINT32_C(0x001751D6)},
         {UINT32_C(0x00492D65), UINT32_C(0x001A7DE1), UINT32_C(0x0014FD58),
          UINT32_C(0x000C2887), UINT32_C(0x00170FFC), UINT32_C(0x0002CD82),
          UINT32_C(0x000C7EB0), UINT32_C(0x007BC59A), UINT32_C(0x00027399),
          UINT32_C(0x0007595A), UINT32_C(0x0006B074), UINT32_C(0x00362BD4),
          UINT32_C(0x001D090F), UINT32_C(0x0005CC42), UINT32_C(0x00350E6D),
          UINT32_C(0x000520BA), UINT32_C(0x003511C8), UINT32_C(0x00263B84),
          UINT32_C(0x0012CB4B), UINT32_C(0x00395148), UINT32_C(0x001557BE),
          UINT32_C(0x001A47CB), UINT32_C(0x00314464)}},
        {{UINT32_C(0x0043F2F2), UINT32_C(0x00194797), UINT32_C(0x00164AF2),
          UINT32_C(0x0039D872), UINT32_C(0x000104A3), UINT32_C(0x0016929A),
          UINT32_C(0x00282C81), UINT32_C(0x005F9C2C), UINT32_C(0x002A5D4B),
          UINT32_C(0x003192B8), UINT32_C(0x002E15CB), UINT32_C(0x004F6E26),
          UINT32_C(0x001DBE42), UINT32_C(0x0011C09D), UINT32_C(0x0036F64F),
          UINT32_C(0x004483FB), UINT32_C(0x00060CCE), UINT32_C(0x003148C2),
          UINT32_C(0x001EE90A), UINT32_C(0x003E6042), UINT32_C(0x002E64B1),
          UINT32_C(0x002C44F1), UINT32_C(0x002F2B60)},
         {UINT32_C(0x005DC792), UINT32_C(0x00397CAD), UINT32_C(0x0018311A),
          UINT32_C(0x000DB83D), UINT32_C(0x003A7FE0), UINT32_C(0x0036E2B7),
          UINT32_C(0x00208A0B), UINT32_C(0x00725417), UINT32_C(0x00055265),
          UINT32_C(0x0028A5C2), UINT32_C(0x002D7738), UINT32_C(0x0008626D),
          UINT32_C(0x00267142), UINT32_C(0x00335A17), UINT32_C(0x003E2E6A),
          UINT32_C(0x0023C202), UINT32_C(0x001CEC16), UINT32_C(0x0007C3CA),
          UINT32_C(0x0026178F), UINT32_C(0x007AF6B1), UINT32_C(0x003EC4B0),
          UINT32_C(0x000A5C59), UINT32_C(0x0005CC1B)}},
        {{UINT32_C(0x006D6CE3), UINT32_C(0x003CDDFA), UINT32_C(0x003536DB),
          UINT32_C(0x003AFD9F), UINT32_C(0x00097B34), UINT32_C(0x0005ECD4),
          UINT32_C(0x0034AA4D), UINT32_C(0x003B05FC), UINT32_C(0x0009BBAD),
          UINT32_C(0x003FDCEE), UINT32_C(0x0033D997), UINT32_C(0x0003C160),
          UINT32_C(0x003B6D37), UINT32_C(0x00315C67), UINT32_C(0x002362F6),
          UINT32_C(0x001A9401), UINT32_C(0x0014E9AD), UINT32_C(0x0033DA3E),
          UINT32_C(0x001BCD3C), UINT32_C(0x002D9F1B), UINT32_C(0x0030DD6A),
          UINT32_C(0x003EC5E7), UINT32_C(0x00308176)},
         {UINT32_C(0x003069BB), UINT32_C(0x0021C759), UINT32_C(0x0015A982),
          UINT32_C(0x000433F9), UINT32_C(0x000F0415), UINT32_C(0x0019193B),
          UINT32_C(0x000CB74A), UINT32_C(0x00550A79), UINT32_C(0x002D6049),
          UINT32_C(0x00207DAA), UINT32_C(0x000496F6), UINT32_C(0x00492EB6),
          UINT32_C(0x003490BF), UINT32_C(0x003D7E1A), UINT32_C(0x0029D71A),
          UINT32_C(0x001A99C6), UINT32_C(0x003442EC), UINT32_C(0x001FE876),
          UINT32_C(0x00307A44), UINT32_C(0x005B4A4F), UINT32_C(0x000DC29C),
          UINT32_C(0x0038C4EF), UINT32_C(0x002E915D)}},
        {{UINT32_C(0x000BEB8C), UINT32_C(0x00061A56), UINT32_C(0x000D8268),
          UINT32_C(0x00421E9B), UINT32_C(0x001AD305), UINT32_C(0x002C0C54),
          UINT32_C(0x002B4A5F), UINT32_C(0x003DF358), UINT32_C(0x001523F3),
          UINT32_C(0x0028B368), UINT32_C(0x00276FD0), UINT32_C(0x00442093),
          UINT32_C(0x000817D3), UINT32_C(0x002AE36B), UINT32_C(0x003C22DE),
          UINT32_C(0x0058669C), UINT32_C(0x000D7F6C), UINT32_C(0x00279A1A),
          UINT32_C(0x000D107C), UINT32_C(0x0021DE92), UINT32_C(0x00246CC9),
          UINT32_C(0x0034B4A4), UINT32_C(0x000EFACA)},
         {UINT32_C(0x00694EEC), UINT32_C(0x003C5044), UINT32_C(0x0016ECB7),
          UINT32_C(0x00412A48), UINT32_C(0x0017E21D), UINT32_C(0x001C1E82),
          UINT32_C(0x002BA6CD), UINT32_C(0x001CF647), UINT32_C(0x00306F34),
          UINT32_C(0x00146470), UINT32_C(0x00196674), UINT32_C(0x001418A3),
          UINT32_C(0x002CFE68), UINT32_C(0x0026B0A5), UINT32_C(0x000747E1),
          UINT32_C(0x0000076E), UINT32_C(0x002C52FE), UINT32_C(0x00381158),
          UINT32_C(0x003CB4BD), UINT32_C(0x000E909B), UINT32_C(0x0009F542),
          UINT32_C(0x000CB347), UINT32_C(0x0016D579)}},
        {{UINT32_C(0x0069D866), UINT32_C(0x0027D233), UINT32_C(0x0035A8F4),
          UINT32_C(0x006BC550), UINT32_C(0x0018DA15), UINT32_C(0x0030CE9E),
          UINT32_C(0x0015D2E1), UINT32_C(0x005388CB), UINT32_C(0x0032AC42),
          UINT32_C(0x001EDFA9), UINT32_C(0x00041ADC), UINT32_C(0x000232D9),
          UINT32_C(0x00278158), UINT32_C(0x003B9C91), UINT32_C(0x001DD2A0),
          UINT32_C(0x0033F780), UINT32_C(0x003E5C50), UINT32_C(0x00075CF3),
          UINT32_C(0x0015E7C2), UINT32_C(0x00440ADA), UINT32_C(0x0016D15D),
          UINT32_C(0x000586C1), UINT32_C(0x002A016C)},
         {UINT32_C(0x004AE04A), UINT32_C(0x003E7BC9), UINT32_C(0x00096110),
          UINT32_C(0x00066932), UINT32_C(0x001B3038), UINT32_C(0x001A7311),
          UINT32_C(0x002F1AEF), UINT32_C(0x0068EA21), UINT32_C(0x00095E5D),
          UINT32_C(0x0009883B), UINT32_C(0x00033990), UINT32_C(0x0024C0B3),
          UINT32_C(0x0029A84D), UINT32_C(0x0005EBA4), UINT32_C(0x00311E64),
          UINT32_C(0x0013FEAE), UINT32_C(0x0008156B), UINT32_C(0x002F4EE6),
          UINT32_C(0x000DF329), UINT32_C(0x001AE70A), UINT32_C(0x002847DD),
          UINT32_C(0x0018E0D7), UINT32_C(0x002BD42E)}},
        {{UINT32_C(0x000B9710), UINT32_C(0x001F475F), UINT32_C(0x000999F5),
          UINT32_C(0x0032B55C), UINT32_C(0x002E7C12), UINT32_C(0x00264CED),
          UINT32_C(0x00094F0A), UINT32_C(0x005A4E16), UINT32_C(0x000BECA0),
          UINT32_C(0x00349B97), UINT32_C(0x003CE972), UINT32_C(0x002B59D3),
          UINT32_C(0x002F203F), UINT32_C(0x000F211F), UINT32_C(0x003B07F1),
          UINT32_C(0x00786C83), UINT32_C(0x0001D952), UINT32_C(0x002B793E),
          UINT32_C(0x0033C2B1), UINT32_C(0x005E8A36), UINT32_C(0x0036E5E2),
          UINT32_C(0x00156A46), UINT32_C(0x00362C8F)},
         {UINT32_C(0x00317544), UINT32_C(0x000AEC08), UINT32_C(0x003109AC),
          UINT32_C(0x004EC46A), UINT32_C(0x00214545), UINT32_C(0x00338B7B),
          UINT32_C(0x0016C802), UINT32_C(0x004E4271), UINT32_C(0x003A07D9),
          UINT32_C(0x00019D25), UINT32_C(0x00198775), UINT32_C(0x0049A8C4),
          UINT32_C(0x00215656), UINT32_C(0x0009570A), UINT32_C(0x0004BCC8),
          UINT32_C(0x006ED97E), UINT32_C(0x003721B2), UINT32_C(0x001AB6C7),
          UINT32_C(0x00219EDF), UINT32_C(0x004291B1), UINT32_C(0x0021788D),
          UINT32_C(0x003CA653), UINT32_C(0x002C51F0)}},
        {{UINT32_C(0x00549A73), UINT32_C(0x001585E0), UINT32_C(0x001219AF),
          UINT32_C(0x00278B73), UINT32_C(0x000AB916), UINT32_C(0x003FB445),
          UINT32_C(0x003FC327), UINT32_C(0x00487904), UINT32_C(0x0008835A),
          UINT32_C(0x0013EBDD), UINT32_C(0x002B6722), UINT32_C(0x005F61F3),
          UINT32_C(0x0033C0B6), UINT32_C(0x00387E43), UINT32_C(0x000DC4FF),
          UINT32_C(0x00220AA8), UINT32_C(0x002411BD), UINT32_C(0x002D9844),
          UINT32_C(0x003BD35D), UINT32_C(0x000878BC), UINT32_C(0x001548F6),
          UINT32_C(0x003F932E), UINT32_C(0x00189EAF)},
         {UINT32_C(0x00243BBC), UINT32_C(0x00080398), UINT32_C(0x0010A82F),
          UINT32_C(0x006AB89B), UINT32_C(0x00021339), UINT32_C(0x00291FC3),
          UINT32_C(0x00145BA0), UINT32_C(0x005378D0), UINT32_C(0x0015B299),
          UINT32_C(0x00057581), UINT32_C(0x002112C0), UINT32_C(0x00642C8E),
          UINT32_C(0x003981D5), UINT32_C(0x0020F113), UINT32_C(0x00354642),
          UINT32_C(0x007C7721), UINT32_C(0x000CEDDA), UINT32_C(0x00220C78),
          UINT32_C(0x000FA861), UINT32_C(0x004B62AA), UINT32_C(0x000C4398),
          UINT32_C(0x001A528A), UINT32_C(0x001FA9C0)}},
        {{UINT32_C(0x00213FA6), UINT32_C(0x00303120), UINT32_C(0x002AB912),
          UINT32_C(0x00604140), UINT32_C(0x0025C250), UINT32_C(0x003C2A6C),
          UINT32_C(0x00322291), UINT32_C(0x0013477E), UINT32_C(0x001F06C8),
          UINT32_C(0x003B3F6A), UINT32_C(0x00283A23), UINT32_C(0x0038B2D8),
          UINT32_C(0x0029DD45), UINT32_C(0x002EBAA8), UINT32_C(0x001B3724),
          UINT32_C(0x00678E35), UINT32_C(0x00096D14), UINT32_C(0x0027B787),
          UINT32_C(0x0007AA23), UINT32_C(0x0025F092), UINT32_C(0x002170F1),
          UINT32_C(0x001BC371), UINT32_C(0x003AED1A)},
         {UINT32_C(0x00425B32), UINT32_C(0x00286AA0), UINT32_C(0x00023581),
          UINT32_C(0x006EE73F), UINT32_C(0x001E5A3B), UINT32_C(0x0030D82F),
          UINT32_C(0x002D1CA8), UINT32_C(0x006A5FF6), UINT32_C(0x001470F9),
          UINT32_C(0x00161816), UINT32_C(0x002350CB), UINT32_C(0x00113D17),
          UINT32_C(0x003F9A5E), UINT32_C(0x003C7C27), UINT32_C(0x00276EA7),
          UINT32_C(0x000CC5E8), UINT32_C(0x003022F0), UINT32_C(0x00293E6C),
          UINT32_C(0x001948B1), UINT32_C(0x00043775), UINT32_C(0x003051DB),
          UINT32_C(0x003D4E8F), UINT32_C(0x0016EAD0)}},
    },
    {
        {{UINT32_C(0x000E7229), UINT32_C(0x001A6628), UINT32_C(0x003C1B89),
          UINT32_C(0x001DEF3A), UINT32_C(0x0005F8AB), UINT32_C(0x00178896),
          UINT32_C(0x00120D1F), UINT32_C(0x00035812), UINT32_C(0x002204C7),
          UINT32_C(0x0025B252), UINT32_C(0x002627D9), UINT32_C(0x00295A6A),
          UINT32_C(0x00064F84), UINT32_C(0x002DD46E), UINT32_C(0x0018C55B),
          UINT32_C(0x0076AC5A), UINT32_C(0x0024BECB), UINT32_C(0x000D610A),
          UINT32_C(0x003CF93D), UINT32_C(0x0025BA10), UINT32_C(0x0001D8FF),
          UINT32_C(0x00111DC7), UINT32_C(0x001BA971)},
         {UINT32_C(0x00079874), UINT32_C(0x002A9BC0), UINT32_C(0x000AE07A),
          UINT32_C(0x002B976D), UINT32_C(0x0037698A), UINT32_C(0x001EFD5D),
          UINT32_C(0x00355FBE), UINT32_C(0x000FC35F), UINT32_C(0x003A64A2),
          UINT32_C(0x0037BE03), UINT32_C(0x002E85B5), UINT32_C(0x001D3118),
          UINT32_C(0x0027921A), UINT32_C(0x000C7471), UINT32_C(0x002BCAB5),
          UINT32_C(0x0033AB97), UINT32_C(0x0001C915), UINT32_C(0x0019A901),
          UINT32_C(0x001D2E71), UINT32_C(0x002A197E), UINT32_C(0x00115A8D),
          UINT32_C(0x0024BF73), UINT32_C(0x0003CC85)}},
        {{UINT32_C(0x002895B2), UINT32_C(0x00320735), UINT32_C(0x000CFB47),
          UINT32_C(0x003DB761), UINT32_C(0x0024C433), UINT32_C(0x0013E23C),
          UINT32_C(0x002BF3DF), UINT32_C(0x0050A160), UINT32_C(0x000ED8DF),
          UINT32_C(0x00023DC8), UINT32_C(0x0022ADA6), UINT32_C(0x0055A62F),
          UINT32_C(0x00118219), UINT32_C(0x00055FC7), UINT32_C(0x0016FC9A),
          UINT32_C(0x0019CDAC), UINT32_C(0x001F6533), UINT32_C(0x0039DEF8),
          UINT32_C(0x00365EB0), UINT32_C(0x001DE6A4), UINT32_C(0x002EC097),
          UINT32_C(0x0014ABA8), UINT32_C(0x003B186E)},
         {UINT32_C(0x0076F84F), UINT32_C(0x000A6360), UINT32_C(0x00389AFC),
          UINT32_C(0x007F347C), UINT32_C(0x0010F3A6), UINT32_C(0x0020172F),
          UINT32_C(0x002456C5), UINT32_C(0x0074D6FD), UINT32_C(0x003EBC5A),
          UINT32_C(0x0015702D), UINT32_C(0x002C322D), UINT32_C(0x0062EC4A),
          UINT32_C(0x001C6321), UINT32_C(0x001ECEE0), UINT32_C(0x000C4DCD),
          UINT32_C(0x00385F54), UINT32_C(0x0015A2F6), UINT32_C(0x003EA398),
          UINT32_C(0x00154A9E), UINT32_C(0x0035549D), UINT32_C(0x002902A3),
          UINT32_C(0x000E87D8), UINT32_C(0x002197A4)}},
        {{UINT32_C(0x000E5E61), UINT32_C(0x0004D26C), UINT32_C(0x0006E668),
          UINT32_C(0x00001B95), UINT32_C(0x0022CEB8), UINT32_C(0x002AD340),
          UINT32_C(0x00178FFF), UINT32_C(0x0068E92D), UINT32_C(0x001CE560),
          UINT32_C(0x00314785), UINT32_C(0x003C340C), UINT32_C(0x000E0359),
          UINT32_C(0x0012093F), UINT32_C(0x00126D05), UINT32_C(0x0001A73F),
          UINT32_C(0x006AADBB), UINT32_C(0x002D01CE), UINT32_C(0x001E4C4C),
          UINT32_C(0x0019B1E1), UINT32_C(0x001E252E), UINT32_C(0x0027C32F),
          UINT32_C(0x0027F7C8), UINT32_C(0x00274554)},
         {UINT32_C(0x0047C011), UINT32_C(0x0016AC83), UINT32_C(0x001C5FD0),
          UINT32_C(0x002B42DE), UINT32_C(0x00108C9B), UINT32_C(0x003E5C82),
          UINT32_C(0x001F47C2), UINT32_C(0x0067643D), UINT32_C(0x00253B0C),
          UINT32_C(0x003B23F4), UINT32_C(0x00285E6A), UINT32_C(0x0000127F),
          UINT32_C(0x001AFEDD), UINT32_C(0x001639C8), UINT32_C(0x0035C65D),
          UINT32_C(0x003890F9), UINT32_C(0x0026D0AD), UINT32_C(0x0024695D),
          UINT32_C(0x0033FF31), UINT32_C(0x00166142), UINT32_C(0x0032EBDF),
          UINT32_C(0x000D509E), UINT32_C(0x00190DE4)}},
        {{UINT32_C(0x005E3F2E), UINT32_C(0x0010C08C), UINT32_C(0x0010E26F),
          UINT32_C(0x0025A315), UINT32_C(0x0009E64F), UINT32_C(0x00002605),
          UINT32_C(0x003601E3), UINT32_C(0x00634D76), UINT32_C(0x003BFCD4),
          UINT32_C(0x00123253), UINT32_C(0x001D94E0), UINT32_C(0x003E9F61),
          UINT32_C(0x0025A1E6), UINT32_C(0x00075853), UINT32_C(0x001EC114),
          UINT32_C(0x00470547), UINT32_C(0x003E437A), UINT32_C(0x0019ED05),
          UINT32_C(0x00061623), UINT32_C(0x0038D391), UINT32_C(0x0031CCDE),
          UINT32_C(0x003374B4), UINT32_C(0x0007C7B9)},
         {UINT32_C(0x00512F62), UINT32_C(0x002E17FE), UINT32_C(0x0036CB08),
          UINT32_C(0x001BDB9E), UINT32_C(0x00394D71), UINT32_C(0x002A7EF7),
          UINT32_C(0x002E6818), UINT32_C(0x005F5A88), UINT32_C(0x00311E36),
          UINT32_C(0x002A6BB1), UINT32_C(0x0019CD43), UINT32_C(0x0045542F),
          UINT32_C(0x002B8CEA), UINT32_C(0x000FA346), UINT32_C(0x002E1A7A),
          UINT32_C(0x000BD16F), UINT32_C(0x00245C8D), UINT32_C(0x00314F13),
          UINT32_C(0x000FFBE8), UINT32_C(0x0056B54A), UINT32_C(0x00382922),
          UINT32_C(0x0035F251), UINT32_C(0x003ACEB3)}},
        {{UINT32_C(0x003E11B5), UINT32_C(0x0002716B), UINT32_C(0x002750E4),
          UINT32_C(0x003740A5), UINT32_C(0x00338906), UINT32_C(0x0013B5F0),
          UINT32_C(0x0027CFAE), UINT32_C(0x004AA6D3), UINT32_C(0x0039E3B9),
          UINT32_C(0x002D1B9F), UINT32_C(0x000035D9), UINT32_C(0x001E459B),
          UINT32_C(0x000CF781), UINT32_C(0x0020167F), UINT32_C(0x001BB777),
          UINT32_C(0x0038BA4C), UINT32_C(0x0028F2E3), UINT32_C(0x0037D8D5),
          UINT32_C(0x001ECF87), UINT32_C(0x004E758A), UINT32_C(0x002AA667),
          UINT32_C(0x002E97A6), UINT32_C(0x00352507)},
         {UINT32_C(0x00283BBD), UINT32_C(0x00263775), UINT32_C(0x000C63C9),
          UINT32_C(0x00001EE4), UINT32_C(0x003ACBBF), UINT32_C(0x00162A58),
          UINT32_C(0x0007B4FE), UINT32_C(0x00351728), UINT32_C(0x001973F1),
          UINT32_C(0x002770E0), UINT32_C(0x003116FA), UINT32_C(0x0046EBBD),
          UINT32_C(0x002C2896), UINT32_C(0x0036E872), UINT32_C(0x0013137C),
          UINT32_C(0x002F444F), UINT32_C(0x003B3375), UINT32_C(0x0003C6AB),
          UINT32_C(0x000FCBE7), UINT32_C(0x006D9063), UINT32_C(0x0020E15A),
          UINT32_C(0x000D5454), UINT32_C(0x0037BDB0)}},
        {{UINT32_C(0x00439E00), UINT32_C(0x001E43D1), UINT32_C(0x003DE476),
          UINT32_C(0x00148953), UINT32_C(0x0025C9E8), UINT32_C(0x001B6D92),
          UINT32_C(0x000AA405), UINT32_C(0x0040CB85), UINT32_C(0x00310A15),
          UINT32_C(0x003D0034), UINT32_C(0x001ACFB7), UINT32_C(0x00171502),
          UINT32_C(0x0034B2C2), UINT32_C(0x0027FB5D), UINT32_C(0x003B0085),
          UINT32_C(0x00344898), UINT32_C(0x003CA33C), UINT32_C(0x001BAF56),
          UINT32_C(0x00021B32), UINT32_C(0x00448603), UINT32_C(0x00091BA6),
          UINT32_C(0x000BAFC4), UINT32_C(0x0013D5A4)},
         {UINT32_C(0x00780D50), UINT32_C(0x0004D808), UINT32_C(0x002F1F9D),
          UINT32_C(0x006E9B4E), UINT32_C(0x001EDD73), UINT32_C(0x000A2602),
          UINT32_C(0x0032564D), UINT32_C(0x000A5962), UINT32_C(0x002D65F0),
          UINT32_C(0x001FF6E8), UINT32_C(0x00263DE7), UINT32_C(0x0028B02D),
          UINT32_C(0x000E0A8D), UINT32_C(0x002AE55E), UINT32_C(0x002EAA0B),
          UINT32_C(0x00508B9C), UINT32_C(0x002CA2CC), UINT32_C(0x0039B8A4),
          UINT32_C(0x000CF2D9), UINT32_C(0x002B0C05), UINT32_C(0x0036C4C9),
          UINT32_C(0x00115406), UINT32_C(0x003A4458)}},
        {{UINT32_C(0x001A9FEF), UINT32_C(0x0017C5B8), UINT32_C(0x0014F927),
          UINT32_C(0x0033E7CA), UINT32_C(0x001DE04B), UINT32_C(0x0021489F),
          UINT32_C(0x003223E7), UINT32_C(0x007F4816), UINT32_C(0x0016233A),
          UINT32_C(0x000E408A), UINT32_C(0x0025911C), UINT32_C(0x006CFEEF),
          UINT32_C(0x00162D98), UINT32_C(0x001FB3B2), UINT32_C(0x000CAFE2),
          UINT32_C(0x00140C69), UINT32_C(0x00373513), UINT32_C(0x0005EFAF),
          UINT32_C(0x00318C8D), UINT32_C(0x001ED26D), UINT32_C(0x0023E013),
          UINT32_C(0x000E235E), UINT32_C(0x002D6FB0)},
         {UINT32_C(0x004D9693), UINT32_C(0x0018038F), UINT32_C(0x001CF661),
          UINT32_C(0x002F57EB), UINT32_C(0x001E346F), UINT32_C(0x0030F7B0),
          UINT32_C(0x001DD4F8), UINT32_C(0x002D4964), UINT32_C(0x003D7230),
          UINT32_C(0x000FA730), UINT32_C(0x001D142C), UINT32_C(0x002276EA),
          UINT32_C(0x001BA178), UINT32_C(0x001466BF), UINT32_C(0x000BF8C5),
          UINT32_C(0x0040D605), UINT32_C(0x002D85AB), UINT32_C(0x001F11D4),
          UINT32_C(0x0016C7D7), UINT32_C(0x000AA5D0), UINT32_C(0x00359550),
          UINT32_C(0x0029A075), UINT32_C(0x00122CA4)}},
        {{UINT32_C(0x0072B845), UINT32_C(0x001BEE64), UINT32_C(0x0030577D),
          UINT32_C(0x006BAF51), UINT32_C(0x0024885D), UINT32_C(0x002BA5B1),
          UINT32_C(0x00236704), UINT32_C(0x000346DC), UINT32_C(0x002A639E),
          UINT32_C(0x003AF226), UINT32_C(0x002EA89E), UINT32_C(0x0026AF84),
          UINT32_C(0x00004D4C), UINT32_C(0x0003640E), UINT32_C(0x001D8986),
          UINT32_C(0x000E2826), UINT32_C(0x000D1018), UINT32_C(0x002CB972),
          UINT32_C(0x0009688A), UINT32_C(0x000489A0), UINT32_C(0x002E4F56),
          UINT32_C(0x003DD33C), UINT32_C(0x003609BA)},
         {UINT32_C(0x001692AF), UINT32_C(0x002C1F96), UINT32_C(0x003792D8),
          UINT32_C(0x00069079), UINT32_C(0x0016ED4A), UINT32_C(0x003B5304),
          UINT32_C(0x000FA6CC), UINT32_C(0x0018593E), UINT32_C(0x0000C409),
          UINT32_C(0x0004E36E), UINT32_C(0x0003E4B0), UINT32_C(0x0018A207),
          UINT32_C(0x00146BF4), UINT32_C(0x001CBDA5), UINT32_C(0x0011B878),
          UINT32_C(0x0062A10E), UINT32_C(0x0002D181), UINT32_C(0x001D3599),
          UINT32_C(0x00185943), UINT32_C(0x00609AB4), UINT32_C(0x002218D4),
          UINT32_C(0x003653F8), UINT32_C(0x0019F9FD)}},
        {{UINT32_C(0x002ED6C7), UINT32_C(0x003C5236), UINT32_C(0x00186569),
          UINT32_C(0x00428772), UINT32_C(0x003A69E3), UINT32_C(0x00087BF9),
          UINT32_C(0x003E9E5F), UINT32_C(0x003AE8B4), UINT32_C(0x003504F3),
          UINT32_C(0x000A8276), UINT32_C(0x003C584F), UINT32_C(0x0069143D),
          UINT32_C(0x002C8325), UINT32_C(0x000FFE9F), UINT32_C(0x00191129),
          UINT32_C(0x00319B36), UINT32_C(0x00115E02), UINT32_C(0x0016E07A),
          UINT32_C(0x002FA414), UINT32_C(0x0014619E), UINT32_C(0x0012CD22),
          UINT32_C(0x002D0E0D), UINT32_C(0x00125784)},
         {UINT32_C(0x00642A65), UINT32_C(0x00203D55), UINT32_C(0x0016C315),
          UINT32_C(0x003CF7A9), UINT32_C(0x003071DE), UINT32_C(0x00106DAE),
          UINT32_C(0x000B2C7D), UINT32_C(0x0047BA31), UINT32_C(0x002CA388),
          UINT32_C(0x0029FBFC), UINT32_C(0x00390EAC), UINT32_C(0x0057CD61),
          UINT32_C(0x0021CF36), UINT32_C(0x0034A05C), UINT32_C(0x00008B13),
          UINT32_C(0x00793DB5), UINT32_C(0x0017E8E7), UINT32_C(0x0035D12F),
          UINT32_C(0x003D6716), UINT32_C(0x004C990F), UINT32_C(0x003B6448),
          UINT32_C(0x000A7F2C), UINT32_C(0x0025B5C5)}},
        {{UINT32_C(0x005E98D9), UINT32_C(0x0026DFA6), UINT32_C(0x000864C2),
          UINT32_C(0x002E69DF), UINT32_C(0x00364C2C), UINT32_C(0x000D5FD3),
          UINT32_C(0x001356CE), UINT32_C(0x00454A4C), UINT32_C(0x003B0302),
          UINT32_C(0x0016D23C), UINT32_C(0x000B4AAA), UINT32_C(0x0057F380),
          UINT32_C(0x0007CFAC), UINT32_C(0x0027103B), UINT32_C(0x000CAA2B),
          UINT32_C(0x005B3BDE), UINT32_C(0x000D252E), UINT32_C(0x002FC387),
          UINT32_C(0x001B39E0), UINT32_C(0x003C0113), UINT32_C(0x0009ADA1),
          UINT32_C(0x002D5182), UINT32_C(0x00029B37)},
         {UINT32_C(0x003B5C86), UINT32_C(0x002985B6), UINT32_C(0x00193F46),
          UINT32_C(0x007D3FF4), UINT32_C(0x0017EA07), UINT32_C(0x003167A4),
          UINT32_C(0x0028ECD5), UINT32_C(0x00102560), UINT32_C(0x0014D8CD),
          UINT32_C(0x0009D70A), UINT32_C(0x0036C65B), UINT32_C(0x0077810C),
          UINT32_C(0x0038B843), UINT32_C(0x000AAA4F), UINT32_C(0x000423CC),
          UINT32_C(0x00609B5A), UINT32_C(0x000B047D), UINT32_C(0x0032FCF2),
          UINT32_C(0x00341089), UINT32_C(0x002F82CA), UINT32_C(0x0012D7A7),
          UINT32_C(0x002D3F89), UINT32_C(0x00189DD5)}},
        {{UINT32_C(0x0066582F), UINT32_C(0x00257453), UINT32_C(0x00210314),
          UINT32_C(0x0062A225), UINT32_C(0x00165C3B), UINT32_C(0x002E6592),
          UINT32_C(0x002F1436), UINT32_C(0x005EE3F8), UINT32_C(0x0007F555),
          UINT32_C(0x0020F441), UINT32_C(0x0034ED55), UINT32_C(0x00308313),
          UINT32_C(0x0034A8DF), UINT32_C(0x0019301D), UINT32_C(0x00173FDB),
          UINT32_C(0x00144214), UINT32_C(0x0019892A), UINT32_C(0x0027897A),
          UINT32_C(0x0021A061), UINT32_C(0x007D24B8), UINT32_C(0x0037F3B1),
          UINT32_C(0x00248CC2), UINT32_C(0x00373DB3)},
         {UINT32_C(0x000BF27A), UINT32_C(0x0039D46B), UINT32_C(0x001AD6FE),
          UINT32_C(0x00475AC8), UINT32_C(0x00063B06), UINT32_C(0x00233FD2),
          UINT32_C(0x0035C0AF), UINT32_C(0x006C6594), UINT32_C(0x002F3CD2),
          UINT32_C(0x0015DF1B), UINT32_C(0x002DF565), UINT32_C(0x0022D72E),
          UINT32_C(0x0004B112), UINT32_C(0x00022C9B), UINT32_C(0x00217D30),
          UINT32_C(0x00586404), UINT32_C(0x00175C8A), UINT32_C(0x003CD70E),
          UINT32_C(0x003F9D96), UINT32_C(0x007351B7), UINT32_C(0x00328F89),
          UINT32_C(0x00339645), UINT32_C(0x00147D37)}},
        {{UINT32_C(0x0006ACC7), UINT32_C(0x0017F7BC), UINT32_C(0x00043BCE),
          UINT32_C(0x00259C1D), UINT32_C(0x002CDB37), UINT32_C(0x0007238C),
          UINT32_C(0x00375E6F), UINT32_C(0x00022971), UINT32_C(0x001B4942),
          UINT32_C(0x003E301A), UINT32_C(0x00389E0C), UINT32_C(0x0014070B),
          UINT32_C(0x0029DEFC), UINT32_C(0x002DDAC4), UINT32_C(0x00236616),
          UINT32_C(0x0000A23A), UINT32_C(0x003BA71B), UINT32_C(0x00230957),
          UINT32_C(0x002229EB), UINT32_C(0x0073C8F9), UINT32_C(0x0025DF6A),
          UINT32_C(0x002BADCB), UINT32_C(0x000F1344)},
         {UINT32_C(0x001BEE3F), UINT32_C(0x001FA015), UINT32_C(0x000CFE6E),
          UINT32_C(0x006FB0F7), UINT32_C(0x003C54F5), UINT32_C(0x003503D8),
          UINT32_C(0x000B28FC), UINT32_C(0x0001F5C0), UINT32_C(0x00104298),
          UINT32_C(0x003AF43A), UINT32_C(0x003A5408), UINT32_C(0x0018DAC0),
          UINT32_C(0x0032EE35), UINT32_C(0x0031C65F), UINT32_C(0x000B31F5),
          UINT32_C(0x0018B829), UINT32_C(0x000133FD), UINT32_C(0x00280CF1),
          UINT32_C(0x00206DF2), UINT32_C(0x0009D76F), UINT32_C(0x001DC987),
          UINT32_C(0x00365635), UINT32_C(0x0014E280)}},
        {{UINT32_C(0x0052A016), UINT32_C(0x0006F577), UINT32_C(0x001C0241),
          UINT32_C(0x005E5024), UINT32_C(0x000DA944), UINT32_C(0x000855A1),
          UINT32_C(0x002A89F3), UINT32_C(0x000E86B5), UINT32_C(0x000CEF59),
          UINT32_C(0x003E508E), UINT32_C(0x00384B7E), UINT32_C(0x0032AAA5),
          UINT32_C(0x0018FF8F), UINT32_C(0x002CD18E), UINT32_C(0x00040821),
          UINT32_C(0x00189644), UINT32_C(0x002DEB40), UINT32_C(0x00132C27),
          UINT32_C(0x000B3030), UINT32_C(0x0054A603), UINT32_C(0x0006BBED),
          UINT32_C(0x0031D103), UINT32_C(0x002F003F)},
         {UINT32_C(0x001E656D), UINT32_C(0x002FF583), UINT32_C(0x0012A61F),
          UINT32_C(0x00346DBE), UINT32_C(0x002A6FB1), UINT32_C(0x0011FD3B),
          UINT32_C(0x0001276C), UINT32_C(0x006148C0), UINT32_C(0x00016501),
          UINT32_C(0x000C96D4), UINT32_C(0x003DB630), UINT32_C(0x00492C8D),
          UINT32_C(0x00057FDE), UINT32_C(0x000CF96C), UINT32_C(0x000164CA),
          UINT32_C(0x004FCB96), UINT32_C(0x00385504), UINT32_C(0x003E5188),
          UINT32_C(0x00286382), UINT32_C(0x0041E093), UINT32_C(0x0002DAB5),
          UINT32_C(0x0010BB0F), UINT32_C(0x0000784C)}},
        {{UINT32_C(0x0075746D), UINT32_C(0x003F9D7D), UINT32_C(0x002D54D0),
          UINT32_C(0x000CA2BA), UINT32_C(0x0034E004), UINT32_C(0x00145EDC),
          UINT32_C(0x0024946A), UINT32_C(0x002B2267), UINT32_C(0x0029D5D7),
          UINT32_C(0x001BD561), UINT32_C(0x00040FF1), UINT32_C(0x007A8818),
          UINT32_C(0x000347CA), UINT32_C(0x00368968), UINT32_C(0x003DFBFD),
          UINT32_C(0x0045E779), UINT32_C(0x0028CB15), UINT32_C(0x0006FE47),
          UINT32_C(0x002AE3AD), UINT32_C(0x000C1917), UINT32_C(0x001A6E74),
          UINT32_C(0x000C0AAF), UINT32_C(0x001EAD78)},
         {UINT32_C(0x0013957A), UINT32_C(0x000B13A3), UINT32_C(0x002FC29D),
          UINT32_C(0x00318258), UINT32_C(0x000316AF), UINT32_C(0x00159186),
          UINT32_C(0x002F9ACE), UINT32_C(0x002617A1), UINT32_C(0x002DA110),
          UINT32_C(0x0024827F), UINT32_C(0x0014B7E3), UINT32_C(0x005A1108),
          UINT32_C(0x002AD5AB), UINT32_C(0x001F8CD8), UINT32_C(0x00280CBB),
          UINT32_C(0x000F3352), UINT32_C(0x0021699D), UINT32_C(0x003D79ED),
          UINT32_C(0x000F2342), UINT32_C(0x000A46DF), UINT32_C(0x000765C5),
          UINT32_C(0x001562AA), UINT32_C(0x001933BE)}},
        {{UINT32_C(0x00771DC4), UINT32_C(0x00105963), UINT32_C(0x0013309E),
          UINT32_C(0x002D5F9C), UINT32_C(0x003816E4), UINT32_C(0x00183FD1),
          UINT32_C(0x0024CC65), UINT32_C(0x004C32C8), UINT32_C(0x00023344),
          UINT32_C(0x00127581), UINT32_C(0x00170A08), UINT32_C(0x003E271B),
          UINT32_C(0x00376C4A), UINT32_C(0x00378FA8), UINT32_C(0x0038BD67),
          UINT32_C(0x006DD9F1), UINT32_C(0x0013CB77), UINT32_C(0x00110A9A),
          UINT32_C(0x0011B015), UINT32_C(0x003AB2F7), UINT32_C(0x00203C14),
          UINT32_C(0x0037D1D9), UINT32_C(0x0017F513)},
         {UINT32_C(0x00383DC1), UINT32_C(0x0032B2DC), UINT32_C(0x003F0168),
          UINT32_C(0x00279081), UINT32_C(0x001E4F82), UINT32_C(0x00183A42),
          UINT32_C(0x000BFB80), UINT32_C(0x005A12C9), UINT32_C(0x00186FCD),
          UINT32_C(0x002E7365), UINT32_C(0x0026CDDE), UINT32_C(0x007856A6),
          UINT32_C(0x00241080), UINT32_C(0x000BB921), UINT32_C(0x003E1A85),
          UINT32_C(0x0062D604), UINT32_C(0x000BB5D8), UINT32_C(0x0026B482),
          UINT32_C(0x0019F5D5), UINT32_C(0x0028F3DC), UINT32_C(0x00143FEB),
          UINT32_C(0x003E5ADA), UINT32_C(0x00253DEF)}},
        {{UINT32_C(0x006BA123), UINT32_C(0x000A781D), UINT32_C(0x000B7D51),
          UINT32_C(0x00740F38), UINT32_C(0x002940F6), UINT32_C(0x00157C6F),
          UINT32_C(0x003E02CE), UINT32_C(0x007207C6), UINT32_C(0x001B64BC),
          UINT32_C(0x00372F37), UINT32_C(0x003A87CB), UINT32_C(0x002D7712),
          UINT32_C(0x001B97D4), UINT32_C(0x00391CB2), UINT32_C(0x003AB655),
          UINT32_C(0x00002E6F), UINT32_C(0x002C7D2F), UINT32_C(0x002AA52F),
          UINT32_C(0x0032378F), UINT32_C(0x0072D63D), UINT32_C(0x0038FA33),
          UINT32_C(0x003C9DB3), UINT32_C(0x0008013D)},
         {UINT32_C(0x0002066C), UINT32_C(0x0035DFEF), UINT32_C(0x001BC43F),
          UINT32_C(0x0029FB46), UINT32_C(0x0013F28B), UINT32_C(0x002A9E1C),
          UINT32_C(0x00316CE9), UINT32_C(0x002537F0), UINT32_C(0x002F07AC),
          UINT32_C(0x0037B3FA), UINT32_C(0x000BB76B), UINT32_C(0x0049349E),
          UINT32_C(0x00330713), UINT32_C(0x002755E1), UINT32_C(0x002928A9),
          UINT32_C(0x00636D8A), UINT32_C(0x0036549D), UINT32_C(0x00119414),
          UINT32_C(0x002CF725), UINT32_C(0x0037181E), UINT32_C(0x0001A2BC),
          UINT32_C(0x0019DA46), UINT32_C(0x003B690A)}},
    },
    {
        {{UINT32_C(0x0032A280), UINT32_C(0x001CB2CC), UINT32_C(0x000F9796),
          UINT32_C(0x00007D75), UINT32_C(0x001AF2EB), UINT32_C(0x003C758A),
          UINT32_C(0x003A6728), UINT32_C(0x0043B3E9), UINT32_C(0x00188CE5),
          UINT32_C(0x0029D0A4), UINT32_C(0x000113A0), UINT32_C(0x0022343F),
          UINT32_C(0x000890D8), UINT32_C(0x0012176A), UINT32_C(0x002971B0),
          UINT32_C(0x00785A55), UINT32_C(0x0001C0B7), UINT32_C(0x00273262),
          UINT32_C(0x002D06D6), UINT32_C(0x0006C271), UINT32_C(0x001E07EA),
          UINT32_C(0x003A1542), UINT32_C(0x0026C181)},
         {UINT32_C(0x00414498), UINT32_C(0x0014CB47), UINT32_C(0x000FFCA6),
          UINT32_C(0x002D51CC), UINT32_C(0x000008D4), UINT32_C(0x00244EA0),
          UINT32_C(0x002F062C), UINT32_C(0x000336A8), UINT32_C(0x00150722),
          UINT32_C(0x0019F588), UINT32_C(0x000CB860), UINT32_C(0x00604BC3),
          UINT32_C(0x0008902B), UINT32_C(0x003D5ADC), UINT32_C(0x00088D53),
          UINT32_C(0x000A2728), UINT32_C(0x003852C8), UINT32_C(0x001CE562),
          UINT32_C(0x003D7474), UINT32_C(0x000E17F9), UINT32_C(0x000ADBDE),
          UINT32_C(0x0002F321), UINT32_C(0x002B5370)}},
        {{UINT32_C(0x00720956), UINT32_C(0x0012FE7D), UINT32_C(0x003A4010),
          UINT32_C(0x0005E1F1), UINT32_C(0x002FCF68), UINT32_C(0x0001CA0D),
          UINT32_C(0x001F9A09), UINT32_C(0x00476576), UINT32_C(0x001BBE6F),
          UINT32_C(0x00157A43), UINT32_C(0x00041B45), UINT32_C(0x0069B21A),
          UINT32_C(0x0011A874), UINT32_C(0x00237329), UINT32_C(0x0010ABF2),
          UINT32_C(0x004A1BCF), UINT32_C(0x00248B43), UINT32_C(0x0039B567),
          UINT32_C(0x00162490), UINT32_C(0x002F2BDB), UINT32_C(0x00296C0C),
          UINT32_C(0x000A4FEE), UINT32_C(0x0004AD98)},
         {UINT32_C(0x004454EB), UINT32_C(0x002C8099), UINT32_C(0x0010E84D),
          UINT32_C(0x002E2241), UINT32_C(0x003207CA), UINT32_C(0x000F5910),
          UINT32_C(0x0003F04F), UINT32_C(0x00392613), UINT32_C(0x000ADE9F),
          UINT32_C(0x003DBD57), UINT32_C(0x0030B86D), UINT32_C(0x0009CC16),
          UINT32_C(0x000A209A), UINT32_C(0x003C2AFA), UINT32_C(0x00035E76),
          UINT32_C(0x005F940A), UINT32_C(0x002B2161), UINT32_C(0x000C7D9D),
          UINT32_C(0x00363B77), UINT32_C(0x0077A201), UINT32_C(0x00399B44),
          UINT32_C(0x0008E94D), UINT32_C(0x00008286)}},
        {{UINT32_C(0x002B92BC), UINT32_C(0x0006153E), UINT32_C(0x0000F8C6),
          UINT32_C(0x005F1B6C), UINT32_C(0x0003BA49), UINT32_C(0x001A925E),
          UINT32_C(0x000F9BBA), UINT32_C(0x00055F92), UINT32_C(0x002FBD92),
          UINT32_C(0x002177A5), UINT32_C(0x003FB8F5), UINT32_C(0x005D4BF2),
          UINT32_C(0x002146D4), UINT32_C(0x0036976B), UINT32_C(0x0022B1BA),
          UINT32_C(0x0032F949), UINT32_C(0x000965FD), UINT32_C(0x001E9F3E),
          UINT32_C(0x002DA23B), UINT32_C(0x00107070), UINT32_C(0x00398A1E),
          UINT32_C(0x00069BFE), UINT32_C(0x002FDDC0)},
         {UINT32_C(0x0072B741), UINT32_C(0x003D395C), UINT32_C(0x003A9B25),
          UINT32_C(0x00294646), UINT32_C(0x00021148), UINT32_C(0x0015DA45),
          UINT32_C(0x00113C40), UINT32_C(0x00419E05), UINT32_C(0x003F3B62),
          UINT32_C(0x001F8475), UINT32_C(0x0006EE22), UINT32_C(0x0066BC79),
          UINT32_C(0x0008B7CC), UINT32_C(0x00023931), UINT32_C(0x00167FA8),
          UINT32_C(0x003BD93E), UINT32_C(0x0039EE3D), UINT32_C(0x001DFEEA),
          UINT32_C(0x001FDCFE), UINT32_C(0x00613DB2), UINT32_C(0x00160B1F),
          UINT32_C(0x001970FE), UINT32_C(0x0023B0DD)}},
        {{UINT32_C(0x0023C1BA), UINT32_C(0x002E5121), UINT32_C(0x002C52E9),
          UINT32_C(0x007811E3), UINT32_C(0x0001A384), UINT32_C(0x002EABE1),
          UINT32_C(0x0024FBC8), UINT32_C(0x0045D98F), UINT32_C(0x001C8207),
          UINT32_C(0x0033DA7A), UINT32_C(0x0030B201), UINT32_C(0x0023DFB3),
          UINT32_C(0x0014CD7A), UINT32_C(0x000B9A13), UINT32_C(0x0029ED72),
          UINT32_C(0x003FDD61), UINT32_C(0x002FAEDB), UINT32_C(0x0016FDA9),
          UINT32_C(0x0006A7E0), UINT32_C(0x003CCE59), UINT32_C(0x00059683),
          UINT32_C(0x0034B4B3), UINT32_C(0x00344F10)},
         {UINT32_C(0x0064F192), UINT32_C(0x00121A7B), UINT32_C(0x001023D3),
          UINT32_C(0x004802FA), UINT32_C(0x000C0C74), UINT32_C(0x003436B0),
          UINT32_C(0x0028F327), UINT32_C(0x00104D43), UINT32_C(0x000B6D47),
          UINT32_C(0x003D9F11), UINT32_C(0x0038A86E), UINT32_C(0x0024B31C),
          UINT32_C(0x000D71F6), UINT32_C(0x0001075B), UINT32_C(0x00131E0B),
          UINT32_C(0x006451D8), UINT32_C(0x0023646D), UINT32_C(0x00185996),
          UINT32_C(0x00143B48), UINT32_C(0x0076F1C1), UINT32_C(0x000E8DA3),
          UINT32_C(0x002EB768), UINT32_C(0x003FBF6F)}},
        {{UINT32_C(0x004D2204), UINT32_C(0x002A5EA9), UINT32_C(0x00019369),
          UINT32_C(0x0070CD74), UINT32_C(0x001A76B1), UINT32_C(0x003815C4),
          UINT32_C(0x002E68F7), UINT32_C(0x005398A8), UINT32_C(0x0020AB8F),
          UINT32_C(0x00185D53), UINT32_C(0x00168C1D), UINT32_C(0x00274E1A),
          UINT32_C(0x000524F2), UINT32_C(0x003D9B1A), UINT32_C(0x0012E5AB),
          UINT32_C(0x004C1050), UINT32_C(0x0032ABC0), UINT32_C(0x0025971D),
          UINT32_C(0x003AC08F), UINT32_C(0x002F1AFC), UINT32_C(0x001407B9),
          UINT32_C(0x00277B2E), UINT32_C(0x001B1F71)},
         {UINT32_C(0x000D2E98), UINT32_C(0x0030B33B), UINT32_C(0x003037E7),
          UINT32_C(0x00425F13), UINT32_C(0x002EBDC3), UINT32_C(0x001D9BE6),
          UINT32_C(0x00111CD4), UINT32_C(0x007D7418), UINT32_C(0x001F1C08),
          UINT32_C(0x0027B843), UINT32_C(0x002D41E6), UINT32_C(0x004D0FDD),
          UINT32_C(0x00162312), UINT32_C(0x000A0EB8), UINT32_C(0x0004819A),
          UINT32_C(0x001E097B), UINT32_C(0x0000A336), UINT32_C(0x000C49B4),
          UINT32_C(0x001F6549), UINT32_C(0x0065532D), UINT32_C(0x00175C84),
          UINT32_C(0x0008B3CF), UINT32_C(0x001D68D8)}},
        {{UINT32_C(0x007E2EF2), UINT32_C(0x000CB9A8), UINT32_C(0x000968E6),
          UINT32_C(0x00367210), UINT32_C(0x00079EA4), UINT32_C(0x00115BCE),
          UINT32_C(0x002F228C), UINT32_C(0x007BE5BF), UINT32_C(0x003C8A27),
          UINT32_C(0x000C8607), UINT32_C(0x00319827), UINT32_C(0x006BF356),
          UINT32_C(0x00222BCA), UINT32_C(0x002D52EC), UINT32_C(0x001634C9),
          UINT32_C(0x00422BB5), UINT32_C(0x0020B569), UINT32_C(0x002745C9),
          UINT32_C(0x002547E2), UINT32_C(0x00692CC6), UINT32_C(0x00366369),
          UINT32_C(0x000C2F45), UINT32_C(0x002DCB38)},
         {UINT32_C(0x00432E57), UINT32_C(0x003BCE51), UINT32_C(0x002F50A1),
          UINT32_C(0x00010E21), UINT32_C(0x000B5704), UINT32_C(0x003603EC),
          UINT32_C(0x003DC6B0), UINT32_C(0x001D3C66), UINT32_C(0x003E876A),
          UINT32_C(0x001D2475), UINT32_C(0x003D0CFE), UINT32_C(0x00752FD6),
          UINT32_C(0x001389EE), UINT32_C(0x002682A3), UINT32_C(0x00006DE0),
          UINT32_C(0x00466661), UINT32_C(0x0025CA0B), UINT32_C(0x003A47DE),
          UINT32_C(0x001DBDDD), UINT32_C(0x00584C8D), UINT32_C(0x00097729),
          UINT32_C(0x003A3D36), UINT32_C(0x0026D79A)}},
        {{UINT32_C(0x0046DC32), UINT32_C(0x0039E30E), UINT32_C(0x001A553F),
          UINT32_C(0x00631635), UINT32_C(0x00137523), UINT32_C(0x0011F122),
          UINT32_C(0x0002887F), UINT32_C(0x0039C6A2), UINT32_C(0x003D3F52),
          UINT32_C(0x000E5C16), UINT32_C(0x001B4338), UINT32_C(0x001104AD),
          UINT32_C(0x0026AD2E), UINT32_C(0x000C1BE9), UINT32_C(0x000082A2),
          UINT32_C(0x0036D7B0), UINT32_C(0x003E62E1), UINT32_C(0x002AC82D),
          UINT32_C(0x00354EEE), UINT32_C(0x001B7162), UINT32_C(0x002F1507),
          UINT32_C(0x00064946), UINT32_C(0x002B777F)},
         {UINT32_C(0x00755CF4), UINT32_C(0x002F3F9D), UINT32_C(0x0027FBE0),
          UINT32_C(0x00250D1C), UINT32_C(0x003AD66C), UINT32_C(0x00220A36),
          UINT32_C(0x00324DD9), UINT32_C(0x000FD4E3), UINT32_C(0x002FB653),
          UINT32_C(0x001407E0), UINT32_C(0x0007BD23), UINT32_C(0x001BCA1B),
          UINT32_C(0x0023529D), UINT32_C(0x000512E2), UINT32_C(0x00322089),
          UINT32_C(0x0052FB0B), UINT32_C(0x00159218), UINT32_C(0x000A2629),
          UINT32_C(0x001ECC37), UINT32_C(0x000D691D), UINT32_C(0x001CDC35),
          UINT32_C(0x0025DECE), UINT32_C(0x0008B229)}},
        {{UINT32_C(0x00042A2E), UINT32_C(0x0002BECD), UINT32_C(0x000CE644),
          UINT32_C(0x007EB2C8), UINT32_C(0x000CDB86), UINT32_C(0x0038243C),
          UINT32_C(0x0013980F), UINT32_C(0x007DB14B), UINT32_C(0x003AF52F),
          UINT32_C(0x0034D34E), UINT32_C(0x00328903), UINT32_C(0x0012E910),
          UINT32_C(0x002F165C), UINT32_C(0x001F951B), UINT32_C(0x003DCC69),
          UINT32_C(0x006A2790), UINT32_C(0x001419B1), UINT32_C(0x003CD6D6),
          UINT32_C(0x000A88DC), UINT32_C(0x0065E513), UINT32_C(0x00038EAB),
          UINT32_C(0x000DA64E), UINT32_C(0x001E4802)},
         {UINT32_C(0x00411E28), UINT32_C(0x0038A31B), UINT32_C(0x000EA13F),
          UINT32_C(0x00692375), UINT32_C(0x003972E4), UINT32_C(0x003C7618),
          UINT32_C(0x0030675C), UINT32_C(0x000471A7), UINT32_C(0x001EAA31),
          UINT32_C(0x000332B8), UINT32_C(0x000BA219), UINT32_C(0x005949F6),
          UINT32_C(0x000721E9), UINT32_C(0x000B0539), UINT32_C(0x00351BFD),
          UINT32_C(0x006AF8C8), UINT32_C(0x001749B7), UINT32_C(0x001B4221),
          UINT32_C(0x00346E9F), UINT32_C(0x001D138C), UINT32_C(0x00315C0E),
          UINT32_C(0x003AE1BD), UINT32_C(0x001E5845)}},
        {{UINT32_C(0x0073DD11), UINT32_C(0x0038D066), UINT32_C(0x003B6E1E),
          UINT32_C(0x0058D879), UINT32_C(0x003FC188), UINT32_C(0x0026EA01),
          UINT32_C(0x003A5E72), UINT32_C(0x003EAE27), UINT32_C(0x0017EC7B),
          UINT32_C(0x0021435A), UINT32_C(0x0030A0EF), UINT32_C(0x00226F77),
          UINT32_C(0x00319511), UINT32_C(0x000EECC9), UINT32_C(0x00184FB1),
          UINT32_C(0x00485367), UINT32_C(0x0012DBCE), UINT32_C(0x00296D94),
          UINT32_C(0x001ECEF1), UINT32_C(0x0048A6EF), UINT32_C(0x000C1378),
          UINT32_C(0x000486F3), UINT32_C(0x00294CB6)},
         {UINT32_C(0x00659E15), UINT32_C(0x0021AFE5), UINT32_C(0x00035B7D),
          UINT32_C(0x0014905A), UINT32_C(0x00190940), UINT32_C(0x0028A11C),
          UINT32_C(0x003C2EC5), UINT32_C(0x0061D9FF), UINT32_C(0x003C91F9),
          UINT32_C(0x000C24F9), UINT32_C(0x0021D20C), UINT32_C(0x0069147F),
          UINT32_C(0x002C2485), UINT32_C(0x001F02A6), UINT32_C(0x001E436B),
          UINT32_C(0x0070B5EC), UINT32_C(0x003C8887), UINT32_C(0x000479C4),
          UINT32_C(0x00329212), UINT32_C(0x00023848), UINT32_C(0x000FD9D8),
          UINT32_C(0x001CA129), UINT32_C(0x002842CB)}},
        {{UINT32_C(0x007B92F5), UINT32_C(0x0037A067), UINT32_C(0x000074AF),
          UINT32_C(0x005B2F28), UINT32_C(0x000CBF5F), UINT32_C(0x00077719),
          UINT32_C(0x0015F2E0), UINT32_C(0x0016A3E7), UINT32_C(0x001CEB10),
          UINT32_C(0x0022F6C6), UINT32_C(0x003D1FA9), UINT32_C(0x004CD931),
          UINT32_C(0x001D7522), UINT32_C(0x001781A9), UINT32_C(0x003443CE),
          UINT32_C(0x006FA88B), UINT32_C(0x001564BA), UINT32_C(0x00110D1F),
          UINT32_C(0x0012896B), UINT32_C(0x000B6064), UINT32_C(0x00253009),
          UINT32_C(0x0007C604), UINT32_C(0x003E79C8)},
         {UINT32_C(0x0022EAC3), UINT32_C(0x001D3CBB), UINT32_C(0x001660EB),
          UINT32_C(0x00530D25), UINT32_C(0x001DDD46), UINT32_C(0x0038675B),
          UINT32_C(0x00270FCB), UINT32_C(0x0070D781), UINT32_C(0x0036DB98),
          UINT32_C(0x0010E11B), UINT32_C(0x0019CA07), UINT32_C(0x004B0308),
          UINT32_C(0x003E92E0), UINT32_C(0x00039F79), UINT32_C(0x002FAD1D),
          UINT32_C(0x0017B8FE), UINT32_C(0x001C8122), UINT32_C(0x0013FAE1),
          UINT32_C(0x00095301), UINT32_C(0x003B1103), UINT32_C(0x00031A89),
          UINT32_C(0x001447C4), UINT32_C(0x0009D34F)}},
        {{UINT32_C(0x007C8A6B), UINT32_C(0x002A2FE8), UINT32_C(0x0035E593),
          UINT32_C(0x004E1D4D), UINT32_C(0x0015A0B8), UINT32_C(0x0020842D),
          UINT32_C(0x0018D50D), UINT32_C(0x001081D4), UINT32_C(0x00126A85),
          UINT32_C(0x0005E191), UINT32_C(0x001BEF59), UINT32_C(0x005AA8B6),
          UINT32_C(0x003A3A60), UINT32_C(0x000ABF90), UINT32_C(0x0006196E),
          UINT32_C(0x00150E95), UINT32_C(0x000CB2DC), UINT32_C(0x000DDCD3),
          UINT32_C(0x003E2A72), UINT32_C(0x00582EAB), UINT32_C(0x0035F095),
          UINT32_C(0x0010E8B9), UINT32_C(0x002F9603)},
         {UINT32_C(0x00381ED7), UINT32_C(0x000655D9), UINT32_C(0x00270A8E),
          UINT32_C(0x00048245), UINT32_C(0x00309CD3), UINT32_C(0x0017ED44),
          UINT32_C(0x001D450E), UINT32_C(0x000312BA), UINT32_C(0x0005985D),
          UINT32_C(0x00358C0C), UINT32_C(0x002A7087), UINT32_C(0x0072F6C5),
          UINT32_C(0x00198D4B), UINT32_C(0x00266DA7), UINT32_C(0x0030D13D),
          UINT32_C(0x00164FAF), UINT32_C(0x001B3D2A), UINT32_C(0x00054328),
          UINT32_C(0x00297C8D), UINT32_C(0x0024974D), UINT32_C(0x000C4C24),
          UINT32_C(0x00233778), UINT32_C(0x000A3C4F)}},
        {{UINT32_C(0x0019EECE), UINT32_C(0x00162127), UINT32_C(0x001040AF),
          UINT32_C(0x001C475E), UINT32_C(0x00239506), UINT32_C(0x0009AF50),
          UINT32_C(0x001C9807), UINT32_C(0x003FA8CC), UINT32_C(0x003128F6),
          UINT32_C(0x00045734), UINT32_C(0x001442AC), UINT32_C(0x0047E27E),
          UINT32_C(0x003215CF), UINT32_C(0x00140684), UINT32_C(0x0023566D),
          UINT32_C(0x0062EA4E), UINT32_C(0x0026B67A), UINT32_C(0x00295AF8),
          UINT32_C(0x0006E548), UINT32_C(0x0040F0F6), UINT32_C(0x003FA25A),
          UINT32_C(0x003841B6), UINT32_C(0x0034374F)},
         {UINT32_C(0x0011DBC4), UINT32_C(0x001EE6DB), UINT32_C(0x00351C56),
          UINT32_C(0x003D4083), UINT32_C(0x001009D6), UINT32_C(0x003E9349),
          UINT32_C(0x00010A11), UINT32_C(0x00382D27), UINT32_C(0x003D7132),
          UINT32_C(0x001999FC), UINT32_C(0x003911D4), UINT32_C(0x0045D805),
          UINT32_C(0x0001B235), UINT32_C(0x00258644), UINT32_C(0x001B1DA8),
          UINT32_C(0x007D367D), UINT32_C(0x002106B2), UINT32_C(0x00096B2D),
          UINT32_C(0x001A078D), UINT32_C(0x007CE535), UINT32_C(0x003C6BB8),
          UINT32_C(0x0021FC86), UINT32_C(0x00388E7F)}},
        {{UINT32_C(0x003C849A), UINT32_C(0x00339DA9), UINT32_C(0x0001B56C),
          UINT32_C(0x0018B48F), UINT32_C(0x0036B241), UINT32_C(0x001C3E99),
          UINT32_C(0x001DC79F), UINT32_C(0x006E4794), UINT32_C(0x0014AD70),
          UINT32_C(0x0020AF6F), UINT32_C(0x00286589), UINT32_C(0x0000AA9B),
          UINT32_C(0x00287B90), UINT32_C(0x0036D3BA), UINT32_C(0x002CB788),
          UINT32_C(0x0036DAF5), UINT32_C(0x000DA427), UINT32_C(0x0003CD59),
          UINT32_C(0x00026B18), UINT32_C(0x002DA542), UINT32_C(0x0010AEF9),
          UINT32_C(0x003EA11A), UINT32_C(0x003453B3)},
         {UINT32_C(0x001D0091), UINT32_C(0x0020390C), UINT32_C(0x002D251A),
          UINT32_C(0x0043EFFA), UINT32_C(0x00284188), UINT32_C(0x00326C4E),
          UINT32_C(0x001965D5), UINT32_C(0x0052E6EE), UINT32_C(0x0000616F),
          UINT32_C(0x002561A4), UINT32_C(0x003AD411), UINT32_C(0x0036D206),
          UINT32_C(0x000E1BD3), UINT32_C(0x001392B2), UINT32_C(0x002A8475),
          UINT32_C(0x0066EFA5), UINT32_C(0x0037E866), UINT32_C(0x001BBD62),
          UINT32_C(0x001D1550), UINT32_C(0x0032E625), UINT32_C(0x00302306),
          UINT32_C(0x001E0DDA), UINT32_C(0x001CF60C)}},
        {{UINT32_C(0x0023F415), UINT32_C(0x0034D9CF), UINT32_C(0x0024E53D),
          UINT32_C(0x000875AF), UINT32_C(0x00052504), UINT32_C(0x003FD275),
          UINT32_C(0x0030C106), UINT32_C(0x006F3F46), UINT32_C(0x000B6725),
          UINT32_C(0x001DB8D9), UINT32_C(0x0028E8F0), UINT32_C(0x00172728),
          UINT32_C(0x0028DA5A), UINT32_C(0x0032E926), UINT32_C(0x002D0A85),
          UINT32_C(0x000530D4), UINT32_C(0x0035DC87), UINT32_C(0x002D07D2),
          UINT32_C(0x003F882E), UINT32_C(0x005C838F), UINT32_C(0x0026F2BF),
          UINT32_C(0x003EEE58), UINT32_C(0x00071443)},
         {UINT32_C(0x002CB0FF), UINT32_C(0x003E64EA), UINT32_C(0x0018EDB8),
          UINT32_C(0x003B4182), UINT32_C(0x001FC937), UINT32_C(0x002AAFB7),
          UINT32_C(0x002EA0F1), UINT32_C(0x0049D653), UINT32_C(0x000F4A39),
          UINT32_C(0x000B926E), UINT32_C(0x0010CA2F), UINT32_C(0x002208C8),
          UINT32_C(0x0039DE49), UINT32_C(0x000161ED), UINT32_C(0x0007EAFC),
          UINT32_C(0x00514FED), UINT32_C(0x00039404), UINT32_C(0x0018883A),
          UINT32_C(0x00023262), UINT32_C(0x0016E9C1), UINT32_C(0x003C573A),
          UINT32_C(0x002FB6FD), UINT32_C(0x00386202)}},
        {{UINT32_C(0x005D99DB), UINT32_C(0x00001D29), UINT32_C(0x000AF82D),
          UINT32_C(0x00444767), UINT32_C(0x0015C5E2), UINT32_C(0x002A81B3),
          UINT32_C(0x0024A5EF), UINT32_C(0x006F6AF5), UINT32_C(0x001EBBCB),
          UINT32_C(0x00305276), UINT32_C(0x001A7F7A), UINT32_C(0x006B1587),
          UINT32_C(0x0010BC41), UINT32_C(0x00233733), UINT32_C(0x0015633F),
          UINT32_C(0x006476A7), UINT32_C(0x00104F63), UINT32_C(0x001F393B),
          UINT32_C(0x00255507), UINT32_C(0x00708297), UINT32_C(0x000DB54C),
          UINT32_C(0x001A8A1D), UINT32_C(0x001A9756)},
         {UINT32_C(0x0033896F), UINT32_C(0x00011688), UINT32_C(0x001FBDA0),
          UINT32_C(0x002D7B5B), UINT32_C(0x00345043), UINT32_C(0x000409DD),
          UINT32_C(0x0023A47B), UINT32_C(0x0018CE42), UINT32_C(0x00005C57),
          UINT32_C(0x0010E46C), UINT32_C(0x0016395D), UINT32_C(0x0029A5E5),
          UINT32_C(0x00063854), UINT32_C(0x002F12A1), UINT32_C(0x00013E1B),
          UINT32_C(0x00407727), UINT32_C(0x001EEAAC), UINT32_C(0x0039D044),
          UINT32_C(0x0023C5C8), UINT32_C(0x003BB777), UINT32_C(0x00206B48),
          UINT32_C(0x0020CD62), UINT32_C(0x002C7DE1)}},
        {{UINT32_C(0x00431425), UINT32_C(0x003E66AF), UINT32_C(0x0039AA06),
          UINT32_C(0x0061F4D9), UINT32_C(0x001789C9), UINT32_C(0x002ECAAC),
          UINT32_C(0x0003F0C7), UINT32_C(0x0019C0FC), UINT32_C(0x00131E10),
          UINT32_C(0x001FDEC5), UINT32_C(0x00375C20), UINT32_C(0x0038CDA3),
          UINT32_C(0x0019FA41), UINT32_C(0x00339E14), UINT32_C(0x002C2643),
          UINT32_C(0x0060E1EB), UINT32_C(0x001F88C5), UINT32_C(0x002C520C),
          UINT32_C(0x000ED4A1), UINT32_C(0x0009B12C), UINT32_C(0x003385E8),
          UINT32_C(0x0007CEC0), UINT32_C(0x0025145A)},
         {UINT32_C(0x000C4BBC), UINT32_C(0x001CA76E), UINT32_C(0x00053791),
          UINT32_C(0x0071B24B), UINT32_C(0x002AEE0E), UINT32_C(0x003D38BC),
          UINT32_C(0x0014DF23), UINT32_C(0x00714100), UINT32_C(0x002621B3),
          UINT32_C(0x003EA6E9), UINT32_C(0x003351FD), UINT32_C(0x002F67A6),
          UINT32_C(0x003DD342), UINT32_C(0x002B6916), UINT32_C(0x0018E95C),
          UINT32_C(0x004F0EF0), UINT32_C(0x00063803), UINT32_C(0x0031C884),
          UINT32_C(0x0029F497), UINT32_C(0x0076FCD3), UINT32_C(0x0008E8DE),
          UINT32_C(0x00375097), UINT32_C(0x0034BF55)}},
    },
    {
        {{UINT32_C(0x00101002), UINT32_C(0x003E5E72), UINT32_C(0x0008B02E),
          UINT32_C(0x0050FB59), UINT32_C(0x0018AB92), UINT32_C(0x003EE716),
          UINT32_C(0x00097228), UINT32_C(0x0049BDB3), UINT32_C(0x003AF4F6),
          UINT32_C(0x003EC3F2), UINT32_C(0x000A2168), UINT32_C(0x002E9535),
          UINT32_C(0x001B90E4), UINT32_C(0x002BA88C), UINT32_C(0x00326E95),
          UINT32_C(0x003FEB7E), UINT32_C(0x002017BC), UINT32_C(0x000D0EEE),
          UINT32_C(0x0014761F), UINT32_C(0x0047526E), UINT32_C(0x00180227),
          UINT32_C(0x000611B5), UINT32_C(0x0035BCC9)},
         {UINT32_C(0x0065BB6C), UINT32_C(0x00254EB1), UINT32_C(0x00213662),
          UINT32_C(0x000C625D), UINT32_C(0x00291EF8), UINT32_C(0x00123964),
          UINT32_C(0x003C6A2D), UINT32_C(0x003CEFF9), UINT32_C(0x00263687),
          UINT32_C(0x0011917B), UINT32_C(0x000E22CF), UINT32_C(0x002846F8),
          UINT32_C(0x0034AE34), UINT32_C(0x001EA233), UINT32_C(0x001EA70A),
          UINT32_C(0x001C002F), UINT32_C(0x0008295D), UINT32_C(0x00358F85),
          UINT32_C(0x001292A5), UINT32_C(0x006FF9AD), UINT32_C(0x0006C51D),
          UINT32_C(0x0010C570), UINT32_C(0x003F9016)}},
        {{UINT32_C(0x00520C83), UINT32_C(0x0011B38F), UINT32_C(0x003659FA),
          UINT32_C(0x004B70A4), UINT32_C(0x002D7D78), UINT32_C(0x00317E0C),
          UINT32_C(0x002BCC8A), UINT32_C(0x00170479), UINT32_C(0x003049C8),
          UINT32_C(0x0035330F), UINT32_C(0x00292CAC), UINT32_C(0x00659C79),
          UINT32_C(0x000953DA), UINT32_C(0x002839AC), UINT32_C(0x000EEC75),
          UINT32_C(0x0034FE7A), UINT32_C(0x003DA567), UINT32_C(0x003E416C),
          UINT32_C(0x00007AD5), UINT32_C(0x00787665), UINT32_C(0x0023F8AC),
          UINT32_C(0x0022688F), UINT32_C(0x002F4735)},
         {UINT32_C(0x0048FDB2), UINT32_C(0x001EC71C), UINT32_C(0x003D8930),
          UINT32_C(0x00650536), UINT32_C(0x0022A057), UINT32_C(0x0034D941),
          UINT32_C(0x0033DA64), UINT32_C(0x002D8AF7), UINT32_C(0x0015A74D),
          UINT32_C(0x0002EE4D), UINT32_C(0x0020F500), UINT32_C(0x00050ADE),
          UINT32_C(0x0021DCE1), UINT32_C(0x00006CC2), UINT32_C(0x00004AF7),
          UINT32_C(0x00385379), UINT32_C(0x0014D7FD), UINT32_C(0x0035F5DC),
          UINT32_C(0x002CE71C), UINT32_C(0x004F1273), UINT32_C(0x00235AF5),
          UINT32_C(0x00073649), UINT32_C(0x001C5B77)}},
        {{UINT32_C(0x002D1D21), UINT32_C(0x003D3AFA), UINT32_C(0x003484FE),
          UINT32_C(0x003B8AEF), UINT32_C(0x0028E325), UINT32_C(0x00180681),
          UINT32_C(0x0008D952), UINT32_C(0x0004222B), UINT32_C(0x002EC06C),
          UINT32_C(0x00196929), UINT32_C(0x0003F38C), UINT32_C(0x004A5049),
          UINT32_C(0x000D9B6D), UINT32_C(0x001C481B), UINT32_C(0x003A16BA),
          UINT32_C(0x007F7383), UINT32_C(0x0016E539), UINT32_C(0x003CB657),
          UINT32_C(0x000CB3E0), UINT32_C(0x0017CB6E), UINT32_C(0x00282B60),
          UINT32_C(0x00168672), UINT32_C(0x0021396D)},
         {UINT32_C(0x00230B59), UINT32_C(0x002A3F7A), UINT32_C(0x002CEDD4),
          UINT32_C(0x0046B9E4), UINT32_C(0x0010DAFC), UINT32_C(0x0030ED59),
          UINT32_C(0x0034B350), UINT32_C(0x004C3909), UINT32_C(0x000D0E93),
          UINT32_C(0x003A3458), UINT32_C(0x00030157), UINT32_C(0x003E191D),
          UINT32_C(0x002A17A1), UINT32_C(0x001C795E), UINT32_C(0x00019E14),
          UINT32_C(0x00448635), UINT32_C(0x00364727), UINT32_C(0x002B17DB),
          UINT32_C(0x00013693), UINT32_C(0x0050F600), UINT32_C(0x0013ADED),
          UINT32_C(0x00267B88), UINT32_C(0x0012E874)}},
        {{UINT32_C(0x00491237), UINT32_C(0x000A3228), UINT32_C(0x0006A16F),
          UINT32_C(0x002BCC52), UINT32_C(0x002A58B0), UINT32_C(0x00223C2F),
          UINT32_C(0x000ECF49), UINT32_C(0x00310D98), UINT32_C(0x000E07C8),
          UINT32_C(0x0027A178), UINT32_C(0x002F51C1), UINT32_C(0x001D757E),
          UINT32_C(0x003D1406), UINT32_C(0x003F45BF), UINT32_C(0x003C049A),
          UINT32_C(0x00247F57), UINT32_C(0x001B4EA7), UINT32_C(0x002C3AA4),
          UINT32_C(0x0000C59A), UINT32_C(0x002C0BF5), UINT32_C(0x0004E1EC),
          UINT32_C(0x003B5C4F), UINT32_C(0x002ED5BD)},
         {UINT32_C(0x000DA809), UINT32_C(0x003F3B14), UINT32_C(0x00317876),
          UINT32_C(0x004FBBD1), UINT32_C(0x00145987), UINT32_C(0x0034043D),
          UINT32_C(0x0004E8DF), UINT32_C(0x0040B9A8), UINT32_C(0x003FB500),
          UINT32_C(0x00102180), UINT32_C(0x00002AD5), UINT32_C(0x000948B6),
          UINT32_C(0x0024E856), UINT32_C(0x001346B2), UINT32_C(0x001224DE),
          UINT32_C(0x00780CFE), UINT32_C(0x003527A8), UINT32_C(0x0015A63D),
          UINT32_C(0x00350B6B), UINT32_C(0x0019D0B1), UINT32_C(0x00125F42),
          UINT32_C(0x000C970B), UINT32_C(0x0030D16C)}},
        {{UINT32_C(0x005B8DD0), UINT32_C(0x002EFE9A), UINT32_C(0x002160B2),
          UINT32_C(0x006C25E9), UINT32_C(0x003648EE), UINT32_C(0x000F0498),
          UINT32_C(0x002E36A5), UINT32_C(0x0048709D), UINT32_C(0x003F3212),
          UINT32_C(0x0032A4D7), UINT32_C(0x0037EA02), UINT32_C(0x003554EF),
          UINT32_C(0x00080AFA), UINT32_C(0x0009F4D8), UINT32_C(0x000A370E),
          UINT32_C(0x0074C856), UINT32_C(0x00302B5C), UINT32_C(0x000F4BED),
          UINT32_C(0x00286A2A), UINT32_C(0x001B7967), UINT32_C(0x001EA28E),
          UINT32_C(0x0005C511), UINT32_C(0x0036A76A)},
         {UINT32_C(0x00470560), UINT32_C(0x002A01F5), UINT32_C(0x0000571A),
          UINT32_C(0x0049D849), UINT32_C(0x001EC4A9), UINT32_C(0x0032B83B),
          UINT32_C(0x001A8DF4), UINT32_C(0x00495FB3), UINT32_C(0x000BD33C),
          UINT32_C(0x000857FC), UINT32_C(0x00128475), UINT32_C(0x003B8705),
          UINT32_C(0x00243166), UINT32_C(0x001BCEBA), UINT32_C(0x0028F42F),
          UINT32_C(0x00530ED6), UINT32_C(0x001D8A5C), UINT32_C(0x001FC74F),
          UINT32_C(0x002D4804), UINT32_C(0x000367B6), UINT32_C(0x000327AF),
          UINT32_C(0x002863D0), UINT32_C(0x000900E7)}},
        {{UINT32_C(0x00780229), UINT32_C(0x001EF630), UINT32_C(0x000510ED),
          UINT32_C(0x006460B5), UINT32_C(0x000A8636), UINT32_C(0x00358DE6),
          UINT32_C(0x001EAE5F), UINT32_C(0x0054B5EB), UINT32_C(0x0024DDD6),
          UINT32_C(0x003EDDBF), UINT32_C(0x00373B40), UINT32_C(0x0026ABAC),
          UINT32_C(0x003A5597), UINT32_C(0x002BE3A2), UINT32_C(0x00167777),
          UINT32_C(0x0045D31B), UINT32_C(0x0032440D), UINT32_C(0x0015429F),
          UINT32_C(0x003A681A), UINT32_C(0x001D0AA3), UINT32_C(0x0036BA5B),
          UINT32_C(0x0025EA57), UINT32_C(0x00343F81)},
         {UINT32_C(0x0013FCD6), UINT32_C(0x0032B515), UINT32_C(0x00205A39),
          UINT32_C(0x006417AA), UINT32_C(0x00188962), UINT32_C(0x0030F077),
          UINT32_C(0x0030D896), UINT32_C(0x00618839), UINT32_C(0x000924CE),
          UINT32_C(0x00313575), UINT32_C(0x002445E3), UINT32_C(0x0004EECA),
          UINT32_C(0x002B4A7C), UINT32_C(0x0009D939), UINT32_C(0x0013DD92),
          UINT32_C(0x0023A94B), UINT32_C(0x0022A525), UINT32_C(0x002EC641),
          UINT32_C(0x000F31A9), UINT32_C(0x001D3493), UINT32_C(0x003DF626),
          UINT32_C(0x003C1521), UINT32_C(0x000E392E)}},
        {{UINT32_C(0x0066600B), UINT32_C(0x0004FDF8), UINT32_C(0x0007D4BD),
          UINT32_C(0x0026B138), UINT32_C(0x002EA81D), UINT32_C(0x00333EF4),
          UINT32_C(0x0015A59C), UINT32_C(0x0051B0C0), UINT32_C(0x0035D122),
          UINT32_C(0x003DA6C3), UINT32_C(0x003E2C86), UINT32_C(0x003CB4B4),
          UINT32_C(0x00044B44), UINT32_C(0x003424DE), UINT32_C(0x001D32E6),
          UINT32_C(0x002521D8), UINT32_C(0x003CCEC2), UINT32_C(0x000276F5),
          UINT32_C(0x00220217), UINT32_C(0x00008BA1), UINT32_C(0x000321CB),
          UINT32_C(0x00286E09), UINT32_C(0x0004C3E0)},
         {UINT32_C(0x002B8D50), UINT32_C(0x002E3BC1), UINT32_C(0x000F2753),
          UINT32_C(0x007FCE93), UINT32_C(0x003EF16C), UINT32_C(0x0035426B),
          UINT32_C(0x00206746), UINT32_C(0x007FCFC3), UINT32_C(0x003C1D6C),
          UINT32_C(0x0037F851), UINT32_C(0x0014034B), UINT32_C(0x005C71B5),
          UINT32_C(0x002AA534), UINT32_C(0x003695A5), UINT32_C(0x001CC377),
          UINT32_C(0x004B40F1), UINT32_C(0x003B0DD3), UINT32_C(0x0003CC25),
          UINT32_C(0x00296BD9), UINT32_C(0x0076050E), UINT32_C(0x0030853C),
          UINT32_C(0x0023CDDF), UINT32_C(0x0005051F)}},
        {{UINT32_C(0x001FAC05), UINT32_C(0x0038BF66), UINT32_C(0x00106AE1),
          UINT32_C(0x005F6C39), UINT32_C(0x002BCFD1), UINT32_C(0x0012C446),
          UINT32_C(0x002014B7), UINT32_C(0x0022CDD4), UINT32_C(0x002C0E46),
          UINT32_C(0x000068BA), UINT32_C(0x0009B619), UINT32_C(0x00112EBA),
          UINT32_C(0x001134DE), UINT32_C(0x00382BD9), UINT32_C(0x0038AB24),
          UINT32_C(0x003EFC51), UINT32_C(0x00125A98), UINT32_C(0x00166AE1),
          UINT32_C(0x001204D8), UINT32_C(0x00395F99), UINT32_C(0x0022EC93),
          UINT32_C(0x000C2334), UINT32_C(0x000F0DB3)},
         {UINT32_C(0x0065FB58), UINT32_C(0x0026949F), UINT32_C(0x00284E96),
          UINT32_C(0x000E9B6C), UINT32_C(0x003DCCC0), UINT32_C(0x00276266),
          UINT32_C(0x0011C074), UINT32_C(0x0006165B), UINT32_C(0x003618B9),
          UINT32_C(0x000C1873), UINT32_C(0x00210655), UINT32_C(0x0068168F),
          UINT32_C(0x002A5321), UINT32_C(0x00130FA1), UINT32_C(0x00288227),
          UINT32_C(0x00405D32), UINT32_C(0x002C76A2), UINT32_C(0x003544A1),
          UINT32_C(0x0021FFEE), UINT32_C(0x00372D2B), UINT32_C(0x001A438E),
          UINT32_C(0x002F5590), UINT32_C(0x001BBD78)}},
        {{UINT32_C(0x000324B7), UINT32_C(0x0005A62F), UINT32_C(0x003F767B),
          UINT32_C(0x006E0320), UINT32_C(0x0000FF7D), UINT32_C(0x001365D4),
          UINT32_C(0x0034C36F), UINT32_C(0x000AC0F4), UINT32_C(0x00037C47),
          UINT32_C(0x00022A9D), UINT32_C(0x001C6BCF), UINT32_C(0x000C25F1),
          UINT32_C(0x0019449E), UINT32_C(0x00272780), UINT32_C(0x00107BA2),
          UINT32_C(0x003A5F5D), UINT32_C(0x0010F210), UINT32_C(0x001A8365),
          UINT32_C(0x000FA62A), UINT32_C(0x000EEFAD), UINT32_C(0x00080B72),
          UINT32_C(0x003ABCCF), UINT32_C(0x00019B10)},
         {UINT32_C(0x0076B572), UINT32_C(0x003D6F9E), UINT32_C(0x000ADEC4),
          UINT32_C(0x00516D49), UINT32_C(0x003E0BD1), UINT32_C(0x00139E71),
          UINT32_C(0x00339678), UINT32_C(0x006ABDF0), UINT32_C(0x0038E886),
          UINT32_C(0x002299CE), UINT32_C(0x00367195), UINT32_C(0x0043A05B),
          UINT32_C(0x00361D28), UINT32_C(0x000796D9), UINT32_C(0x00373012),
          UINT32_C(0x001EC4D3), UINT32_C(0x001008A0), UINT32_C(0x002E74DD),
          UINT32_C(0x003C82F9), UINT32_C(0x004054A4), UINT32_C(0x0032570C),
          UINT32_C(0x00101897), UINT32_C(0x00118C2D)}},
        {{UINT32_C(0x00462F42), UINT32_C(0x00057E48), UINT32_C(0x001278B3),
          UINT32_C(0x0026CC97), UINT32_C(0x001E327A), UINT32_C(0x001598F9),
          UINT32_C(0x003DEF1B), UINT32_C(0x00079209), UINT32_C(0x0033F716),
          UINT32_C(0x003B919D), UINT32_C(0x003706F3), UINT32_C(0x00399A35),
          UINT32_C(0x0036C21D), UINT32_C(0x00323DF4), UINT32_C(0x000A940E),
          UINT32_C(0x000D518E), UINT32_C(0x000D882E), UINT32_C(0x003C191A),
          UINT32_C(0x00244FC8), UINT32_C(0x0005C226), UINT32_C(0x000509F7),
          UINT32_C(0x000F698A), UINT32_C(0x00007583)},
         {UINT32_C(0x007336DD), UINT32_C(0x002AE10E), UINT32_C(0x00262EEC),
          UINT32_C(0x0040454E), UINT32_C(0x003352A6), UINT32_C(0x002A34DE),
          UINT32_C(0x0033BCE4), UINT32_C(0x0024FD39), UINT32_C(0x001319FB),
          UINT32_C(0x001AE5AA), UINT32_C(0x00315D5B), UINT32_C(0x002C46BE),
          UINT32_C(0x001DF5A0), UINT32_C(0x002C4B31), UINT32_C(0x0034A43A),
          UINT32_C(0x004D4DD6), UINT32_C(0x000116D9), UINT32_C(0x000E599A),
          UINT32_C(0x0033B481), UINT32_C(0x0072C084), UINT32_C(0x003602A6),
          UINT32_C(0x000FA6A0), UINT32_C(0x00193096)}},
        {{UINT32_C(0x001FA23E), UINT32_C(0x0017DD44), UINT32_C(0x002B9851),
          UINT32_C(0x0078D9BF), UINT32_C(0x00300461), UINT32_C(0x000E650F),
          UINT32_C(0x0003235A), UINT32_C(0x001E10FD), UINT32_C(0x00191997),
          UINT32_C(0x00347E5B), UINT32_C(0x000EF26D), UINT32_C(0x00722710),
          UINT32_C(0x00091296), UINT32_C(0x0000DAC3), UINT32_C(0x00364C90),
          UINT32_C(0x00153FD5), UINT32_C(0x00386DE4), UINT32_C(0x0010D8C8),
          UINT32_C(0x001F9824), UINT32_C(0x000ADEC8), UINT32_C(0x003F9D31),
          UINT32_C(0x0022F161), UINT32_C(0x000FB294)},
         {UINT32_C(0x007CFE80), UINT32_C(0x002929EF), UINT32_C(0x001E66B0),
          UINT32_C(0x003A9598), UINT32_C(0x00040870), UINT32_C(0x00110507),
          UINT32_C(0x0002B8C7), UINT32_C(0x00218FE2), UINT32_C(0x0024A402),
          UINT32_C(0x00082D52), UINT32_C(0x0014DAF9), UINT32_C(0x003244A6),
          UINT32_C(0x000583BF), UINT32_C(0x00215F1C), UINT32_C(0x0035F85B),
          UINT32_C(0x000DE2B3), UINT32_C(0x0004BC8F), UINT32_C(0x000E7228),
          UINT32_C(0x002E9933), UINT32_C(0x0007BDB8), UINT32_C(0x001F7F0F),
          UINT32_C(0x003332AF), UINT32_C(0x00156268)}},
        {{UINT32_C(0x0002E3E7), UINT32_C(0x0025FA60), UINT32_C(0x001FB4E6),
          UINT32_C(0x0016C3C6), UINT32_C(0x00247D0E), UINT32_C(0x002D8D5E),
          UINT32_C(0x0006A675), UINT32_C(0x00149DD3), UINT32_C(0x0014833C),
          UINT32_C(0x002071D1), UINT32_C(0x00267269), UINT32_C(0x005E8399),
          UINT32_C(0x0015D1BF), UINT32_C(0x002573DB), UINT32_C(0x000E94C4),
          UINT32_C(0x0053F0CB), UINT32_C(0x000E6C01), UINT32_C(0x002C9873),
          UINT32_C(0x0003E40E), UINT32_C(0x002DC625), UINT32_C(0x000EE009),
          UINT32_C(0x0037B3C1), UINT32_C(0x00314D3B)},
         {UINT32_C(0x0012F52A), UINT32_C(0x00212A59), UINT32_C(0x0039A45C),
          UINT32_C(0x000237A1), UINT32_C(0x0002467E), UINT32_C(0x003AD286),
          UINT32_C(0x0014E2EE), UINT32_C(0x0079D3D0), UINT32_C(0x001D7205),
          UINT32_C(0x0019A1C3), UINT32_C(0x001A753E), UINT32_C(0x00648E5B),
          UINT32_C(0x001DA22B), UINT32_C(0x0032CBC7), UINT32_C(0x001A0350),
          UINT32_C(0x0051025A), UINT32_C(0x003A3047), UINT32_C(0x001814DC),
          UINT32_C(0x0015F660), UINT32_C(0x00384509), UINT32_C(0x0028C315),
          UINT32_C(0x0014D207), UINT32_C(0x001BFC3C)}},
        {{UINT32_C(0x000BF619), UINT32_C(0x001B0A4A), UINT32_C(0x002F5B04),
          UINT32_C(0x00066718), UINT32_C(0x000F956B), UINT32_C(0x00148057),
          UINT32_C(0x003D7C40), UINT32_C(0x002D779F), UINT32_C(0x000D96BA),
          UINT32_C(0x0034F9E9), UINT32_C(0x000ABC81), UINT32_C(0x00612100),
          UINT32_C(0x00094453), UINT32_C(0x001A7A84), UINT32_C(0x00395C2A),
          UINT32_C(0x001CCF9C), UINT32_C(0x001909AB), UINT32_C(0x000127F4),
          UINT32_C(0x003CC47F), UINT32_C(0x0053B36F), UINT32_C(0x001168B8),
          UINT32_C(0x003E681B), UINT32_C(0x0033586A)},
         {UINT32_C(0x003405C5), UINT32_C(0x0014C1F8), UINT32_C(0x00217C04),
          UINT32_C(0x0044F686), UINT32_C(0x003B975D), UINT32_C(0x001566BE),
          UINT32_C(0x000C3966), UINT32_C(0x00442F22), UINT32_C(0x002EEC1C),
          UINT32_C(0x001FBB59), UINT32_C(0x002C7F08), UINT32_C(0x005C2547),
          UINT32_C(0x002E399A), UINT32_C(0x00357E26), UINT32_C(0x00182B2F),
          UINT32_C(0x00428509), UINT32_C(0x0001036A), UINT32_C(0x000C10BF),
          UINT32_C(0x0038CF9D), UINT32_C(0x0037AD35), UINT32_C(0x000ED96E),
          UINT32_C(0x001A6435), UINT32_C(0x003E4F02)}},
        {{UINT32_C(0x0041EB8E), UINT32_C(0x000024BF), UINT32_C(0x003694DF),
          UINT32_C(0x00511BE5), UINT32_C(0x000A954F), UINT32_C(0x00206AB1),
          UINT32_C(0x003CF939), UINT32_C(0x00513701), UINT32_C(0x000E6080),
          UINT32_C(0x002108CE), UINT32_C(0x0020017E), UINT32_C(0x00105B07),
          UINT32_C(0x0011EE5F), UINT32_C(0x003E26E6), UINT32_C(0x000DCD93),
          UINT32_C(0x0008016D), UINT32_C(0x003FE138), UINT32_C(0x0003D710),
          UINT32_C(0x002881A3), UINT32_C(0x002E6638), UINT32_C(0x0013554C),
          UINT32_C(0x001A9737), UINT32_C(0x002F29B7)},
         {UINT32_C(0x0072FA30), UINT32_C(0x003860AB), UINT32_C(0x002A3A9B),
          UINT32_C(0x0046D4D4), UINT32_C(0x002C8E1C), UINT32_C(0x000B27C5),
          UINT32_C(0x002FB5F3), UINT32_C(0x006E389E), UINT32_C(0x0032BF68),
          UINT32_C(0x002F2032), UINT32_C(0x003D0E8B), UINT32_C(0x005EFF1B),
          UINT32_C(0x000E77F7), UINT32_C(0x0032D4D9), UINT32_C(0x000EE3B7),
          UINT32_C(0x002DD781), UINT32_C(0x002C515F), UINT32_C(0x001196A0),
          UINT32_C(0x003C1961), UINT32_C(0x00484EBE), UINT32_C(0x0007BCF4),
          UINT32_C(0x002FA36A), UINT32_C(0x00385130)}},
        {{UINT32_C(0x000B2CC6), UINT32_C(0x000E1DAF), UINT32_C(0x003ADA49),
          UINT32_C(0x0067C22D), UINT32_C(0x002135BF), UINT32_C(0x0034F418),
          UINT32_C(0x002F97CB), UINT32_C(0x003D4E4F), UINT32_C(0x00389246),
          UINT32_C(0x000605C0), UINT32_C(0x0005A49F), UINT32_C(0x00289A5C),
          UINT32_C(0x0019305F), UINT32_C(0x002BDB2B), UINT32_C(0x0037F1CC),
          UINT32_C(0x007C489D), UINT32_C(0x001CC3B8), UINT32_C(0x0022BE49),
          UINT32_C(0x0004F6FE), UINT32_C(0x004CDB36), UINT32_C(0x001ECD22),
          UINT32_C(0x00347FCC), UINT32_C(0x00121B6E)},
         {UINT32_C(0x0038250C), UINT32_C(0x003A9B9A), UINT32_C(0x0031B884),
          UINT32_C(0x0038B4E2), UINT32_C(0x002903F8), UINT32_C(0x000D4406),
          UINT32_C(0x0003337E), UINT32_C(0x000571CA), UINT32_C(0x0020FC99),
          UINT32_C(0x002BEC49), UINT32_C(0x0004A324), UINT32_C(0x0063E39A),
          UINT32_C(0x00248D5A), UINT32_C(0x0034EE85), UINT32_C(0x0012C541),
          UINT32_C(0x0036DF11), UINT32_C(0x001A9D56), UINT32_C(0x00114AD8),
          UINT32_C(0x002B0978), UINT32_C(0x004376FE), UINT32_C(0x0019DA75),
          UINT32_C(0x0036CC96), UINT32_C(0x002821E1)}},
        {{UINT32_C(0x003C6DB0), UINT32_C(0x00394096), UINT32_C(0x0015D4D8),
          UINT32_C(0x00624F58), UINT32_C(0x003A01CB), UINT32_C(0x002C9112),
          UINT32_C(0x003A878F), UINT32_C(0x00184B32), UINT32_C(0x001888A3),
          UINT32_C(0x00026E10), UINT32_C(0x000E5D54), UINT32_C(0x0055695D),
          UINT32_C(0x0004DC05), UINT32_C(0x001B0A95), UINT32_C(0x00230372),
          UINT32_C(0x000B124E), UINT32_C(0x0011DE6A), UINT32_C(0x000F2458),
          UINT32_C(0x002C9259), UINT32_C(0x00290AC1), UINT32_C(0x0020440B),
          UINT32_C(0x00114828), UINT32_C(0x002B166A)},
         {UINT32_C(0x0032B46D), UINT32_C(0x00207B45), UINT32_C(0x000473C9),
          UINT32_C(0x007FBBBF), UINT32_C(0x0015AFF8), UINT32_C(0x0039EB60),
          UINT32_C(0x0035D816), UINT32_C(0x000B1D9F), UINT32_C(0x0037A1A2),
          UINT32_C(0x000D8711), UINT32_C(0x0002DFDE), UINT32_C(0x001CBEC4),
          UINT32_C(0x002A1716), UINT32_C(0x003B7011), UINT32_C(0x002CED5F),
          UINT32_C(0x006BA8F2), UINT32_C(0x0002B544), UINT32_C(0x000C2201),
          UINT32_C(0x001B97B2), UINT32_C(0x0068B05E), UINT32_C(0x002ECFAD),
          UINT32_C(0x0014D41E), UINT32_C(0x00319D72)}},
    },
    {
        {{UINT32_C(0x00000297), UINT32_C(0x0028EE9D), UINT32_C(0x0025F457),
          UINT32_C(0x003A1C7F), UINT32_C(0x003D187E), UINT32_C(0x0016AAC2),
          UINT32_C(0x0018DA90), UINT32_C(0x0032CC34), UINT32_C(0x0000C9FE),
          UINT32_C(0x00083A39), UINT32_C(0x000ABFD1), UINT32_C(0x00056518),
          UINT32_C(0x0020E915), UINT32_C(0x0037F36C), UINT32_C(0x001C3CE8),
          UINT32_C(0x0016154B), UINT32_C(0x000D8F76), UINT32_C(0x001349C7),
          UINT32_C(0x002C5B2D), UINT32_C(0x00302ADF), UINT32_C(0x00347C0F),
          UINT32_C(0x001AD83E), UINT32_C(0x00337C01)},
         {UINT32_C(0x0044DBD8), UINT32_C(0x00161F8E), UINT32_C(0x003A4EAF),
          UINT32_C(0x007E41EE), UINT32_C(0x0020D593), UINT32_C(0x002B1752),
          UINT32_C(0x0008C520), UINT32_C(0x000F746C), UINT32_C(0x00251428),
          UINT32_C(0x00336F1A), UINT32_C(0x002F850D), UINT32_C(0x00363B2F),
          UINT32_C(0x003C91B4), UINT32_C(0x00373CAD), UINT32_C(0x00114941),
          UINT32_C(0x007F0C1B), UINT32_C(0x000AB3AA), UINT32_C(0x000B5CDA),
          UINT32_C(0x003A4CD6), UINT32_C(0x0013C09D), UINT32_C(0x003CFDAB),
          UINT32_C(0x0030F023), UINT32_C(0x002F9D40)}},
        {{UINT32_C(0x0016AB0F), UINT32_C(0x0002549A), UINT32_C(0x00324067),
          UINT32_C(0x001CAA0D), UINT32_C(0x001D43DA), UINT32_C(0x002D4798),
          UINT32_C(0x002FABBD), UINT32_C(0x00524E09), UINT32_C(0x003E65A7),
          UINT32_C(0x000E6579), UINT32_C(0x0006B2BA), UINT32_C(0x007B52B6),
          UINT32_C(0x0017769B), UINT32_C(0x0013CA17), UINT32_C(0x00179C6F),
          UINT32_C(0x005068DF), UINT32_C(0x00329383), UINT32_C(0x001C707E),
          UINT32_C(0x001906BF), UINT32_C(0x0076817B), UINT32_C(0x0010ED4F),
          UINT32_C(0x00185468), UINT32_C(0x003C4A19)},
         {UINT32_C(0x003A29A3), UINT32_C(0x0007D7E2), UINT32_C(0x000C6BC2),
          UINT32_C(0x007A5479), UINT32_C(0x0001F1CF), UINT32_C(0x0039F9E1),
          UINT32_C(0x00044B37), UINT32_C(0x005AA886), UINT32_C(0x002CDE04),
          UINT32_C(0x002B1FD3), UINT32_C(0x003036AE), UINT32_C(0x004BC454),
          UINT32_C(0x000E6063), UINT32_C(0x003E513C), UINT32_C(0x00142E11),
          UINT32_C(0x006EB792), UINT32_C(0x002A88A8), UINT32_C(0x003EE121),
          UINT32_C(0x000CAFA1), UINT32_C(0x0069BADD), UINT32_C(0x003F3982),
          UINT32_C(0x001A3478), UINT32_C(0x00051F0B)}},
        {{UINT32_C(0x0065CD56), UINT32_C(0x002C822B), UINT32_C(0x002F6B9C),
          UINT32_C(0x000A1BB8), UINT32_C(0x000AAF79), UINT32_C(0x000EA4D3),
          UINT32_C(0x00077BC8), UINT32_C(0x004E72DE), UINT32_C(0x00344B0B),
          UINT32_C(0x001E3ED5), UINT32_C(0x0038E0C9), UINT32_C(0x00798666),
          UINT32_C(0x002C7240), UINT32_C(0x00033538), UINT32_C(0x003C3C44),
          UINT32_C(0x00400702), UINT32_C(0x00200573), UINT32_C(0x003E2A4D),
          UINT32_C(0x0004ADF5), UINT32_C(0x007BCBC6), UINT32_C(0x001D81E3),
          UINT32_C(0x000E60C8), UINT32_C(0x0033E777)},
         {UINT32_C(0x0034AD00), UINT32_C(0x001B4772), UINT32_C(0x0003423A),
          UINT32_C(0x003B4DC7), UINT32_C(0x0020F3E4), UINT32_C(0x0039B171),
          UINT32_C(0x00127CDB), UINT32_C(0x003DCC1F), UINT32_C(0x002BC848),
          UINT32_C(0x00370405), UINT32_C(0x00012BF7), UINT32_C(0x002C5599),
          UINT32_C(0x0014AB0C), UINT32_C(0x00103733), UINT32_C(0x0002C167),
          UINT32_C(0x0072597A), UINT32_C(0x001A940B), UINT32_C(0x000AA67E),
          UINT32_C(0x0027936D), UINT32_C(0x006B2D36), UINT32_C(0x00236515),
          UINT32_C(0x003318C3), UINT32_C(0x0000665D)}},
        {{UINT32_C(0x007BF246), UINT32_C(0x0038A54E), UINT32_C(0x0017A2C6),
          UINT32_C(0x002DF25B), UINT32_C(0x0022DEB2), UINT32_C(0x003B118A),
          UINT32_C(0x00285430), UINT32_C(0x007EDA78), UINT32_C(0x0020F2EC),
          UINT32_C(0x002DC0F9), UINT32_C(0x000824DC), UINT32_C(0x0035CC91),
          UINT32_C(0x002C8632), UINT32_C(0x001D44DC), UINT32_C(0x0018CA86),
          UINT32_C(0x004A0FAD), UINT32_C(0x002945F8), UINT32_C(0x0002D0D5),
          UINT32_C(0x001B8CB7), UINT32_C(0x002990A6), UINT32_C(0x0019DEB1),
          UINT32_C(0x0025B0F2), UINT32_C(0x000568B1)},
         {UINT32_C(0x001B65CD), UINT32_C(0x000CDCF7), UINT32_C(0x000C0170),
          UINT32_C(0x00180F0B), UINT32_C(0x0016BD33), UINT32_C(0x002FFA3C),
          UINT32_C(0x00040868), UINT32_C(0x005D604E), UINT32_C(0x00100FF9),
          UINT32_C(0x00336B67), UINT32_C(0x003FF1A5), UINT32_C(0x0066724B),
          UINT32_C(0x003B381E), UINT32_C(0x002868B1), UINT32_C(0x0010D47B),
          UINT32_C(0x00776DC4), UINT32_C(0x00246BA9), UINT32_C(0x002AD2CD),
          UINT32_C(0x002AAF38), UINT32_C(0x000D0446), UINT32_C(0x002F27BB),
          UINT32_C(0x002943E1), UINT32_C(0x000F4F81)}},
        {{UINT32_C(0x003D4A9C), UINT32_C(0x00024A6D), UINT32_C(0x0014B9E1),
          UINT32_C(0x0052698E), UINT32_C(0x0030AB88), UINT32_C(0x003B378D),
          UINT32_C(0x003E866C), UINT32_C(0x006C9349), UINT32_C(0x00290E01),
          UINT32_C(0x001477AD), UINT32_C(0x0000E581), UINT32_C(0x001E06CC),
          UINT32_C(0x00310918), UINT32_C(0x003193C5), UINT32_C(0x002B6332),
          UINT32_C(0x005EA944), UINT32_C(0x001F5E4B), UINT32_C(0x0014F9B3),
          UINT32_C(0x000E2522), UINT32_C(0x004FCF6F), UINT32_C(0x002A3D76),
          UINT32_C(0x00048DB9), UINT32_C(0x001D02E8)},
         {UINT32_C(0x0037AF28), UINT32_C(0x0029FE6C), UINT32_C(0x0009EDFC),
          UINT32_C(0x0027B89F), UINT32_C(0x00301D20), UINT32_C(0x0032442E),
          UINT32_C(0x00200E28), UINT32_C(0x002D5E74), UINT32_C(0x0012B052),
          UINT32_C(0x003A45F3), UINT32_C(0x00317F8E), UINT32_C(0x001621A4),
          UINT32_C(0x0017C898), UINT32_C(0x00337293), UINT32_C(0x0017DFB5),
          UINT32_C(0x0071E94B), UINT32_C(0x001F139A), UINT32_C(0x001769A4),
          UINT32_C(0x003BA6FF), UINT32_C(0x005D3122), UINT32_C(0x002F863F),
          UINT32_C(0x000395F4), UINT32_C(0x00259438)}},
        {{UINT32_C(0x00698800), UINT32_C(0x003C6A37), UINT32_C(0x0021F1BB),
          UINT32_C(0x004E8C9D), UINT32_C(0x00033DB6), UINT32_C(0x000A7B27),
          UINT32_C(0x000E7C3D), UINT32_C(0x00611E5A), UINT32_C(0x0008E6DC),
          UINT32_C(0x001B99B7), UINT32_C(0x00011169), UINT32_C(0x000C1DEC),
          UINT32_C(0x002423CA), UINT32_C(0x00017B20), UINT32_C(0x000AB665),
          UINT32_C(0x002626D4), UINT32_C(0x0023799A), UINT32_C(0x002806DE),
          UINT32_C(0x003692DB), UINT32_C(0x002B1EC8), UINT32_C(0x000E1414),
          UINT32_C(0x0026B167), UINT32_C(0x00169029)},
         {UINT32_C(0x0013B973), UINT32_C(0x003B4AF9), UINT32_C(0x0031ACC0),
          UINT32_C(0x00393363), UINT32_C(0x000B4D81), UINT32_C(0x0015A3AE),
          UINT32_C(0x002B3D90), UINT32_C(0x001BCC23), UINT32_C(0x000CC79D),
          UINT32_C(0x003E07EC), UINT32_C(0x002EE5FF), UINT32_C(0x0045B99C),
          UINT32_C(0x0001C279), UINT32_C(0x001A54B4), UINT32_C(0x00175534),
          UINT32_C(0x004FEA24), UINT32_C(0x0010F58E), UINT32_C(0x00343EB1),
          UINT32_C(0x0039ED8E), UINT32_C(0x0022AE96), UINT32_C(0x0023467E),
          UINT32_C(0x00318A7F), UINT32_C(0x0029E05C)}},
        {{UINT32_C(0x006B581B), UINT32_C(0x002F4135), UINT32_C(0x0007FED7),
          UINT32_C(0x0060C57B), UINT32_C(0x003393FD), UINT32_C(0x00093667),
          UINT32_C(0x0004FA1F), UINT32_C(0x0054919F), UINT32_C(0x00229F53),
          UINT32_C(0x001AB18E), UINT32_C(0x0011D07D), UINT32_C(0x0002443C),
          UINT32_C(0x002AA483), UINT32_C(0x0008DA57), UINT32_C(0x0038A821),
          UINT32_C(0x007861E9), UINT32_C(0x0024D8C3), UINT32_C(0x00309579),
          UINT32_C(0x002A1002), UINT32_C(0x007B324A), UINT32_C(0x00291FD3),
          UINT32_C(0x002937C2), UINT32_C(0x00310CCC)},
         {UINT32_C(0x007B71A6), UINT32_C(0x003EB7A5), UINT32_C(0x00395509),
          UINT32_C(0x003F58C6), UINT32_C(0x002932CB), UINT32_C(0x003417F8),
          UINT32_C(0x000AD82F), UINT32_C(0x00251085), UINT32_C(0x0006F21E),
          UINT32_C(0x001588B0), UINT32_C(0x000C136A), UINT32_C(0x004E6BB6),
          UINT32_C(0x000C7C60), UINT32_C(0x0015A2FF), UINT32_C(0x001965F4),
          UINT32_C(0x006B3224), UINT32_C(0x00280D4B), UINT32_C(0x000374E1),
          UINT32_C(0x00187558), UINT32_C(0x007A1057), UINT32_C(0x0001A4DB),
          UINT32_C(0x00392A05), UINT32_C(0x002B7342)}},
        {{UINT32_C(0x00102D12), UINT32_C(0x00157E1D), UINT32_C(0x003819E1),
          UINT32_C(0x000436EA), UINT32_C(0x0033F4FE), UINT32_C(0x0004D63C),
          UINT32_C(0x003A559C), UINT32_C(0x005758F8), UINT32_C(0x0032A48C),
          UINT32_C(0x0036F300), UINT32_C(0x003C06D5), UINT32_C(0x004AC77E),
          UINT32_C(0x0012DD43), UINT32_C(0x001CDBEB), UINT32_C(0x000CBE11),
          UINT32_C(0x0003CB34), UINT32_C(0x003F6859), UINT32_C(0x00144DCF),
          UINT32_C(0x000BDC01), UINT32_C(0x0038921F), UINT32_C(0x00161041),
          UINT32_C(0x000B8BE6), UINT32_C(0x002AC248)},
         {UINT32_C(0x0067DD3E), UINT32_C(0x0036DB63), UINT32_C(0x0037BA32),
          UINT32_C(0x000AF959), UINT32_C(0x0025B293), UINT32_C(0x0010059F),
          UINT32_C(0x0035780D), UINT32_C(0x0046380C), UINT32_C(0x0018452D),
          UINT32_C(0x002B5B67), UINT32_C(0x0016B7B2), UINT32_C(0x007AF664),
          UINT32_C(0x003C1F41), UINT32_C(0x00097E6F), UINT32_C(0x003205A1),
          UINT32_C(0x00725EFF), UINT32_C(0x003E2E86), UINT32_C(0x0038F16D),
          UINT32_C(0x000B458E), UINT32_C(0x00385D51), UINT32_C(0x00006670),
          UINT32_C(0x0008BCC1), UINT32_C(0x00098C17)}},
        {{UINT32_C(0x006DBF88), UINT32_C(0x002D6BB0), UINT32_C(0x003DFE61),
          UINT32_C(0x003DF76A), UINT32_C(0x00035BAA), UINT32_C(0x000984CF),
          UINT32_C(0x00054134), UINT32_C(0x00556ECD), UINT32_C(0x001F1973),
          UINT32_C(0x0006D2EA), UINT32_C(0x002F57DA), UINT32_C(0x0024A56A),
          UINT32_C(0x002A7755), UINT32_C(0x000305FD), UINT32_C(0x001C8FD6),
          UINT32_C(0x00481CAF), UINT32_C(0x003D0B45), UINT32_C(0x000D68BC),
          UINT32_C(0x0039248B), UINT32_C(0x00290881), UINT32_C(0x001C8DB5),
          UINT32_C(0x000250CE), UINT32_C(0x000A5C50)},
         {UINT32_C(0x005313E5), UINT32_C(0x002F268C), UINT32_C(0x001D3B3E),
          UINT32_C(0x001FE5D2), UINT32_C(0x0006955A), UINT32_C(0x00336B39),
          UINT32_C(0x00290B6C), UINT32_C(0x00183F14), UINT32_C(0x0025ED57),
          UINT32_C(0x0006E18E), UINT32_C(0x00245AB9), UINT32_C(0x000AFADF),
          UINT32_C(0x001B239A), UINT32_C(0x003D1824), UINT32_C(0x00286527),
          UINT32_C(0x00619C72), UINT32_C(0x00341914), UINT32_C(0x00191683),
          UINT32_C(0x00365835), UINT32_C(0x006A9C8D), UINT32_C(0x000DCB56),
          UINT32_C(0x003D7D6F), UINT32_C(0x00312DA6)}},
        {{UINT32_C(0x002A34A8), UINT32_C(0x0011A273), UINT32_C(0x002EF0E7),
          UINT32_C(0x0056ED5F), UINT32_C(0x0022B29F), UINT32_C(0x003BC53B),
          UINT32_C(0x00374AF6), UINT32_C(0x001209F7), UINT32_C(0x00087894),
          UINT32_C(0x001D51AC), UINT32_C(0x001C55D9), UINT32_C(0x0007EA51),
          UINT32_C(0x0027A416), UINT32_C(0x002199BF), UINT32_C(0x00398181),
          UINT32_C(0x0050725A), UINT32_C(0x00016D8B), UINT32_C(0x00185F36),
          UINT32_C(0x0022B389), UINT32_C(0x00670F14), UINT32_C(0x003EE89C),
          UINT32_C(0x00208598), UINT32_C(0x0037FA4E)},
         {UINT32_C(0x002CBD11), UINT32_C(0x0025CA10), UINT32_C(0x0025A5C4),
          UINT32_C(0x0073CCEA), UINT32_C(0x001D4A0C), UINT32_C(0x003E1189),
          UINT32_C(0x0012D18F), UINT32_C(0x00202D6B), UINT32_C(0x0005142A),
          UINT32_C(0x000673EF), UINT32_C(0x00230DED), UINT32_C(0x005C9EF1),
          UINT32_C(0x00199F43), UINT32_C(0x000951F1), UINT32_C(0x0001FA9B),
          UINT32_C(0x0042FDCE), UINT32_C(0x003CF250), UINT32_C(0x00333B05),
          UINT32_C(0x003487E6), UINT32_C(0x001A46EF), UINT32_C(0x0009221A),
          UINT32_C(0x001601FA), UINT32_C(0x000A8F97)}},
        {{UINT32_C(0x0029B1A4), UINT32_C(0x001A205E), UINT32_C(0x0010D45B),
          UINT32_C(0x00009969), UINT32_C(0x003B86E1), UINT32_C(0x00263695),
          UINT32_C(0x0038303F), UINT32_C(0x000F276E), UINT32_C(0x003DD7EE),
          UINT32_C(0x0003D7B5), UINT32_C(0x0019C4B1), UINT32_C(0x003248D5),
          UINT32_C(0x0021E8FE), UINT32_C(0x000FC768), UINT32_C(0x001F35EC),
          UINT32_C(0x002FB73B), UINT32_C(0x001B945A), UINT32_C(0x00164C1B),
          UINT32_C(0x002F277F), UINT32_C(0x005EAE78), UINT32_C(0x00071711),
          UINT32_C(0x000C61BB), UINT32_C(0x000AB2C0)},
         {UINT32_C(0x0016DF7A), UINT32_C(0x0015DC01), UINT32_C(0x002BA091),
          UINT32_C(0x0011F44E), UINT32_C(0x000B08D7), UINT32_C(0x002E9923),
          UINT32_C(0x00092787), UINT32_C(0x002ADBB4), UINT32_C(0x003D7AA5),
          UINT32_C(0x0009E226), UINT32_C(0x002384F8), UINT32_C(0x003614F7),
          UINT32_C(0x003BEA0C), UINT32_C(0x002456BB), UINT32_C(0x00107C57),
          UINT32_C(0x004A575C), UINT32_C(0x000760C6), UINT32_C(0x0034DEA3),
          UINT32_C(0x002C29AE), UINT32_C(0x007702EC), UINT32_C(0x000797DD),
          UINT32_C(0x002C2EC2), UINT32_C(0x000B53B4)}},
        {{UINT32_C(0x004E14DC), UINT32_C(0x000DCCE7), UINT32_C(0x00268B67),
          UINT32_C(0x00671423), UINT32_C(0x000C36E7), UINT32_C(0x002EF482),
          UINT32_C(0x0002A811), UINT32_C(0x004F450D), UINT32_C(0x0019D6E8),
          UINT32_C(0x00379047), UINT32_C(0x0024CF74), UINT32_C(0x0017F363),
          UINT32_C(0x00242D1C), UINT32_C(0x000034DF), UINT32_C(0x002AEC5D),
          UINT32_C(0x0016D8E1), UINT32_C(0x0015B2FA), UINT32_C(0x00347EF8),
          UINT32_C(0x00075A03), UINT32_C(0x006AFAC1), UINT32_C(0x0010C4CC),
          UINT32_C(0x00216803), UINT32_C(0x001AA96E)},
         {UINT32_C(0x0057B948), UINT32_C(0x002E3492), UINT32_C(0x002E8BEB),
          UINT32_C(0x00500CA7), UINT32_C(0x002A1860), UINT32_C(0x001B6814),
          UINT32_C(0x0019C85F), UINT32_C(0x0061C4ED), UINT32_C(0x002EF6B7),
          UINT32_C(0x0038C2BF), UINT32_C(0x003C380D), UINT32_C(0x0011C0C0),
          UINT32_C(0x0011337C), UINT32_C(0x0015C779), UINT32_C(0x00136724),
          UINT32_C(0x00050BF7), UINT32_C(0x0005558D), UINT32_C(0x002EC289),
          UINT32_C(0x003637CA), UINT32_C(0x004B8113), UINT32_C(0x001A69CC),
          UINT32_C(0x00301379), UINT32_C(0x003F1AD7)}},
        {{UINT32_C(0x0012C055), UINT32_C(0x000EB55E), UINT32_C(0x000D7834),
          UINT32_C(0x0027B02C), UINT32_C(0x003B78F0), UINT32_C(0x0010001F),
          UINT32_C(0x002DD1EC), UINT32_C(0x0044CC9D), UINT32_C(0x003F406F),
          UINT32_C(0x002BBD9B), UINT32_C(0x003D495E), UINT32_C(0x002D8896),
          UINT32_C(0x0030CB6A), UINT32_C(0x001B5E53), UINT32_C(0x002AD9F8),
          UINT32_C(0x001E75BF), UINT32_C(0x000F94EA), UINT32_C(0x00057B4C),
          UINT32_C(0x00370072), UINT32_C(0x0014B385), UINT32_C(0x0005ACED),
          UINT32_C(0x002C28F0), UINT32_C(0x003AB7D9)},
         {UINT32_C(0x0020CF13), UINT32_C(0x00225C38), UINT32_C(0x002B6293),
          UINT32_C(0x0013F808), UINT32_C(0x00344CB9), UINT32_C(0x0033719D),
          UINT32_C(0x002FE2B6), UINT32_C(0x00282CB5), UINT32_C(0x00175559),
          UINT32_C(0x000403EA), UINT32_C(0x00359279), UINT32_C(0x005D8812),
          UINT32_C(0x000B1A40), UINT32_C(0x003EE682), UINT32_C(0x0016E724),
          UINT32_C(0x002FB1C5), UINT32_C(0x002F6BEE), UINT32_C(0x0022778B),
          UINT32_C(0x0019AEA3), UINT32_C(0x003D80A9), UINT32_C(0x0032D9D1),
          UINT32_C(0x003BF23F), UINT32_C(0x002DBA08)}},
        {{UINT32_C(0x00475A5B), UINT32_C(0x000AF126), UINT32_C(0x000E8D05),
          UINT32_C(0x0037AAD9), UINT32_C(0x003350FF), UINT32_C(0x003B6DF1),
          UINT32_C(0x000C70D2), UINT32_C(0x0031341A), UINT32_C(0x00166A1F),
          UINT32_C(0x003D3DBE), UINT32_C(0x0021F7E8), UINT32_C(0x006D14A1),
          UINT32_C(0x0039D159), UINT32_C(0x001EFA80), UINT32_C(0x0032B317),
          UINT32_C(0x0024939B), UINT32_C(0x001C82DD), UINT32_C(0x00061D7A),
          UINT32_C(0x00147571), UINT32_C(0x004FFE3E), UINT32_C(0x000965DE),
          UINT32_C(0x0028C381), UINT32_C(0x000DFE6C)},
         {UINT32_C(0x0035EAA0), UINT32_C(0x0009123B), UINT32_C(0x0032E9E6),
          UINT32_C(0x00084111), UINT32_C(0x0000F226), UINT32_C(0x003CD924),
          UINT32_C(0x000ABC8B), UINT32_C(0x00538B5D), UINT32_C(0x00023291),
          UINT32_C(0x000DB4A0), UINT32_C(0x00010030), UINT32_C(0x00328332),
          UINT32_C(0x001A2589), UINT32_C(0x00233EA0), UINT32_C(0x0017BE31),
          UINT32_C(0x00586460), UINT32_C(0x0012777E), UINT32_C(0x002D359E),
          UINT32_C(0x000D0BCC), UINT32_C(0x00245915), UINT32_C(0x000F3FAB),
          UINT32_C(0x00232DCC), UINT32_C(0x0026CC0F)}},
        {{UINT32_C(0x006107A0), UINT32_C(0x00348213), UINT32_C(0x001DB8EE),
          UINT32_C(0x003152F3), UINT32_C(0x0029336E), UINT32_C(0x001572BD),
          UINT32_C(0x002314E4), UINT32_C(0x0050D309), UINT32_C(0x002101EA),
          UINT32_C(0x0000EDBA), UINT32_C(0x0011643A), UINT32_C(0x002A8161),
          UINT32_C(0x00169D2D), UINT32_C(0x00105B84), UINT32_C(0x0007A268),
          UINT32_C(0x00602253), UINT32_C(0x000EAF07), UINT32_C(0x000BF9C0),
          UINT32_C(0x001F44D9), UINT32_C(0x0000BADF), UINT32_C(0x000B6708),
          UINT32_C(0x000F4EDA), UINT32_C(0x0027E80B)},
         {UINT32_C(0x0079EA50), UINT32_C(0x0012030F), UINT32_C(0x00175D43),
          UINT32_C(0x005CD824), UINT32_C(0x00334D4F), UINT32_C(0x002AEE35),
          UINT32_C(0x0021CFB0), UINT32_C(0x00199622), UINT32_C(0x000CA221),
          UINT32_C(0x0007BC44), UINT32_C(0x0029CBBF), UINT32_C(0x0019F06C),
          UINT32_C(0x0034ECA6), UINT32_C(0x0027BE0E), UINT32_C(0x002FE495),
          UINT32_C(0x00705DBB), UINT32_C(0x002F6511), UINT32_C(0x000D66C8),
          UINT32_C(0x000C392A), UINT32_C(0x0014BBEE), UINT32_C(0x0007F420),
          UINT32_C(0x0020EF1F), UINT32_C(0x002DD2C3)}},
        {{UINT32_C(0x001F311E), UINT32_C(0x0035E164), UINT32_C(0x000D7E33),
          UINT32_C(0x004EE0A2), UINT32_C(0x001B027B), UINT32_C(0x003AF8A9),
          UINT32_C(0x000897E1), UINT32_C(0x004E7636), UINT32_C(0x002CFEBD),
          UINT32_C(0x00349E23), UINT32_C(0x003A2005), UINT32_C(0x0033A740),
          UINT32_C(0x000273B7), UINT32_C(0x00018397), UINT32_C(0x0002783F),
          UINT32_C(0x00201E98), UINT32_C(0x0009D39F), UINT32_C(0x000A5722),
          UINT32_C(0x002D49F8), UINT32_C(0x00798C09), UINT32_C(0x000C4014),
          UINT32_C(0x0007D8C3), UINT32_C(0x002F570F)},
         {UINT32_C(0x00477116), UINT32_C(0x00161163), UINT32_C(0x002DF7BB),
          UINT32_C(0x001DD1D7), UINT32_C(0x003A92DB), UINT32_C(0x0036ACFC),
          UINT32_C(0x00211278), UINT32_C(0x0055790C), UINT32_C(0x000B98E9),
          UINT32_C(0x002EB711), UINT32_C(0x0009D7B7), UINT32_C(0x003CD366),
          UINT32_C(0x000622E0), UINT32_C(0x000D9307), UINT32_C(0x0001BD5F),
          UINT32_C(0x0073A35F), UINT32_C(0x003FC1C3), UINT32_C(0x0025C15B),
          UINT32_C(0x00359419), UINT32_C(0x006A6138), UINT32_C(0x002A142D),
          UINT32_C(0x000BBEDD), UINT32_C(0x0008A742)}},
    },
    {
        {{UINT32_C(0x00020495), UINT32_C(0x0029C46F), UINT32_C(0x0015C863),
          UINT32_C(0x001A9BE1), UINT32_C(0x002541BC), UINT32_C(0x003083D6),
          UINT32_C(0x000E2B6E), UINT32_C(0x004DEA6D), UINT32_C(0x00233C05),
          UINT32_C(0x00093178), UINT32_C(0x00300C16), UINT32_C(0x0047A8A8),
          UINT32_C(0x003EEE62), UINT32_C(0x003A3FFE), UINT32_C(0x002D8A6E),
          UINT32_C(0x003747DF), UINT32_C(0x0023EBEC), UINT32_C(0x003A703F),
          UINT32_C(0x00057635), UINT32_C(0x004C2FF0), UINT32_C(0x0013DB65),
          UINT32_C(0x0028F19D), UINT32_C(0x00333AB2)},
         {UINT32_C(0x0000A454), UINT32_C(0x0003242C), UINT32_C(0x00263770),
          UINT32_C(0x0070C7F5), UINT32_C(0x0007B940), UINT32_C(0x00062CBB),
          UINT32_C(0x000BB7CC), UINT32_C(0x00001E3F), UINT32_C(0x00107BEF),
          UINT32_C(0x0024BD77), UINT32_C(0x0003307A), UINT32_C(0x003C6EC5),
          UINT32_C(0x00357523), UINT32_C(0x003FE203), UINT32_C(0x002F4B77),
          UINT32_C(0x0039AB29), UINT32_C(0x00009871), UINT32_C(0x003024E6),
          UINT32_C(0x001EAE16), UINT32_C(0x003F3D08), UINT32_C(0x0029A969),
          UINT32_C(0x001642E9), UINT32_C(0x003925FE)}},
        {{UINT32_C(0x000C8333), UINT32_C(0x00134BA7), UINT32_C(0x0009B871),
          UINT32_C(0x0004CDC4), UINT32_C(0x00289CA0), UINT32_C(0x001FC8D2),
          UINT32_C(0x0039D91B), UINT32_C(0x0038FC3D), UINT32_C(0x0019773B),
          UINT32_C(0x0006D4DF), UINT32_C(0x0006221A), UINT32_C(0x004F1A1C),
          UINT32_C(0x0010AF9E), UINT32_C(0x0018553A), UINT32_C(0x00130550),
          UINT32_C(0x00111A01), UINT32_C(0x003C7519), UINT32_C(0x00287566),
          UINT32_C(0x001644E8), UINT32_C(0x0041602D), UINT32_C(0x0032CDC1),
          UINT32_C(0x001C2B40), UINT32_C(0x0030A48F)},
         {UINT32_C(0x0042DCF0), UINT32_C(0x0008B28F), UINT32_C(0x003EC6F9),
          UINT32_C(0x006A8D26), UINT32_C(0x0034DBA9), UINT32_C(0x002BD050),
          UINT32_C(0x003FE19C), UINT32_C(0x0030096C), UINT32_C(0x0013965D),
          UINT32_C(0x00010C86), UINT32_C(0x003C6698), UINT32_C(0x00731549),
          UINT32_C(0x000AAA24), UINT32_C(0x0010C344), UINT32_C(0x003F7448),
          UINT32_C(0x000C5964), UINT32_C(0x0019616E), UINT32_C(0x0035336F),
          UINT32_C(0x000723D5), UINT32_C(0x00244786), UINT32_C(0x002452D1),
          UINT32_C(0x001F0B6A), UINT32_C(0x0031D0BC)}},
        {{UINT32_C(0x001ABEAE), UINT32_C(0x00140094), UINT32_C(0x0025F718),
          UINT32_C(0x001FFB06), UINT32_C(0x002CE72A), UINT32_C(0x000678CF),
          UINT32_C(0x0007D404), UINT32_C(0x0073CB92), UINT32_C(0x000A9FC4),
          UINT32_C(0x000668BB), UINT32_C(0x0027BD0D), UINT32_C(0x002BDE2E),
          UINT32_C(0x003EDD2C), UINT32_C(0x00154AE6), UINT32_C(0x00290863),
          UINT32_C(0x00334512), UINT32_C(0x001E546A), UINT32_C(0x002467D8),
          UINT32_C(0x0006CBDB), UINT32_C(0x002139AD), UINT32_C(0x001CED3F),
          UINT32_C(0x00217DC2), UINT32_C(0x001F626B)},
         {UINT32_C(0x00390DFD), UINT32_C(0x0002F8B3), UINT32_C(0x000E30AF),
          UINT32_C(0x0005D7A3), UINT32_C(0x001EFA22), UINT32_C(0x002CAFDB),
          UINT32_C(0x00004971), UINT32_C(0x002EFBEA), UINT32_C(0x001F4ACB),
          UINT32_C(0x00302B99), UINT32_C(0x001DFC66), UINT32_C(0x007364F2),
          UINT32_C(0x00371C65), UINT32_C(0x0028108D), UINT32_C(0x003C66ED),
          UINT32_C(0x005D7568), UINT32_C(0x00212DC4), UINT32_C(0x0011A56E),
          UINT32_C(0x0034EE5A), UINT32_C(0x0031E1D4), UINT32_C(0x003CF9C2),
          UINT32_C(0x003EB41F), UINT32_C(0x003C84A7)}},
        {{UINT32_C(0x007FF718), UINT32_C(0x00032692), UINT32_C(0x002F052E),
          UINT32_C(0x00755B72), UINT32_C(0x003D2345), UINT32_C(0x0038E6DD),
          UINT32_C(0x0025DC5A), UINT32_C(0x0065158E), UINT32_C(0x0035F9E0),
          UINT32_C(0x0019A28C), UINT32_C(0x00178B35), UINT32_C(0x0044D5B8),
          UINT32_C(0x0039CE59), UINT32_C(0x00379216), UINT32_C(0x00098649),
          UINT32_C(0x00105E9E), UINT32_C(0x0037A436), UINT32_C(0x0035A4A6),
          UINT32_C(0x00087244), UINT32_C(0x002AA631), UINT32_C(0x001E9EDB),
          UINT32_C(0x000A2622), UINT32_C(0x001D1531)},
         {UINT32_C(0x003C8CB9), UINT32_C(0x003D6118), UINT32_C(0x00179E49),
          UINT32_C(0x002B0C0C), UINT32_C(0x0039C364), UINT32_C(0x002CA57A),
          UINT32_C(0x003F8C54), UINT32_C(0x001FB453), UINT32_C(0x003C0C82),
          UINT32_C(0x003B2FF0), UINT32_C(0x003A2B7F), UINT32_C(0x0058C732),
          UINT32_C(0x000C6E03), UINT32_C(0x0030EAAB), UINT32_C(0x002A43FC),
          UINT32_C(0x0029DF25), UINT32_C(0x00002B4F), UINT32_C(0x0022A3CA),
          UINT32_C(0x00104844), UINT32_C(0x004A0B3B), UINT32_C(0x001849CB),
          UINT32_C(0x001C4653), UINT32_C(0x002F1596)}},
        {{UINT32_C(0x001D4A19), UINT32_C(0x0035FDF4), UINT32_C(0x000F8F5B),
          UINT32_C(0x003FF4B0), UINT32_C(0x00157527), UINT32_C(0x0015F4FF),
          UINT32_C(0x00337DA4), UINT32_C(0x002BC44F), UINT32_C(0x00223C67),
          UINT32_C(0x001B663C), UINT32_C(0x00281B4B), UINT32_C(0x0078BDF6),
          UINT32_C(0x000D0B3B), UINT32_C(0x00099BBB), UINT32_C(0x002A4438),
          UINT32_C(0x00512DEC), UINT32_C(0x0007055E), UINT32_C(0x002AF2F0),
          UINT32_C(0x002C9105), UINT32_C(0x0023E635), UINT32_C(0x001CB35B),
          UINT32_C(0x0028C1C2), UINT32_C(0x002DE4D1)},
         {UINT32_C(0x00140ADA), UINT32_C(0x0011EC68), UINT32_C(0x0018DFDD),
          UINT32_C(0x006F5E0E), UINT32_C(0x00185618), UINT32_C(0x000B38F8),
          UINT32_C(0x0003AC86), UINT32_C(0x00345A9C), UINT32_C(0x0018811B),
          UINT32_C(0x0034EF90), UINT32_C(0x00309FA7), UINT32_C(0x002657B1),
          UINT32_C(0x0026A02F), UINT32_C(0x003FB112), UINT32_C(0x003E8E9A),
          UINT32_C(0x004E6284), UINT32_C(0x00310F7A), UINT32_C(0x0013E7DA),
          UINT32_C(0x0014C174), UINT32_C(0x0038C1FC), UINT32_C(0x0026EC4A),
          UINT32_C(0x0018C688), UINT32_C(0x002A438F)}},
        {{UINT32_C(0x004F0ACF), UINT32_C(0x001C15FB), UINT32_C(0x003CD5C1),
          UINT32_C(0x000D2292), UINT32_C(0x0025B6A8), UINT32_C(0x00221999),
          UINT32_C(0x0016BA08), UINT32_C(0x00792A56), UINT32_C(0x00215FF2),
          UINT32_C(0x002B39F1), UINT32_C(0x000F2F96), UINT32_C(0x00025D28),
          UINT32_C(0x0029609E), UINT32_C(0x00351C7F), UINT32_C(0x000A603D),
          UINT32_C(0x003F3CD9), UINT32_C(0x00024C3B), UINT32_C(0x000C25E9),
          UINT32_C(0x002157FF), UINT32_C(0x003E3F6F), UINT32_C(0x0015898B),
          UINT32_C(0x0007923F), UINT32_C(0x0011A75F)},
         {UINT32_C(0x001B8989), UINT32_C(0x0036B95E), UINT32_C(0x000B28EB),
          UINT32_C(0x006F0F0E), UINT32_C(0x001BB501), UINT32_C(0x0029744C),
          UINT32_C(0x002C2A82), UINT32_C(0x006278D2), UINT32_C(0x0006D540),
          UINT32_C(0x00338072), UINT32_C(0x0023F135), UINT32_C(0x006B3C7F),
          UINT32_C(0x003F9CA2), UINT32_C(0x003069ED), UINT32_C(0x001454A7),
          UINT32_C(0x001CEA39), UINT32_C(0x000EDAE9), UINT32_C(0x002BF356),
          UINT32_C(0x003B1BD9), UINT32_C(0x00073EF3), UINT32_C(0x003041D7),
          UINT32_C(0x00096064), UINT32_C(0x00142C76)}},
        {{UINT32_C(0x0068FFC6), UINT32_C(0x003C11C5), UINT32_C(0x0031DD2F),
          UINT32_C(0x002086BC), UINT32_C(0x00213A20), UINT32_C(0x000198C3),
          UINT32_C(0x003C70AA), UINT32_C(0x0064A691), UINT32_C(0x003F88A6),
          UINT32_C(0x0010B222), UINT32_C(0x001133AE), UINT32_C(0x0000D81A),
          UINT32_C(0x0008B4F2), UINT32_C(0x0037B644), UINT32_C(0x0020B08F),
          UINT32_C(0x002B77A7), UINT32_C(0x000AEF1B), UINT32_C(0x002AB9A7),
          UINT32_C(0x001FFD9C), UINT32_C(0x002D2887), UINT32_C(0x001829D4),
          UINT32_C(0x00291E60), UINT32_C(0x0024DD09)},
         {UINT32_C(0x005A1EE9), UINT32_C(0x000858BD), UINT32_C(0x0006666A),
          UINT32_C(0x00665E27), UINT32_C(0x001E2D76), UINT32_C(0x00151594),
          UINT32_C(0x003CBB31), UINT32_C(0x00274D76), UINT32_C(0x00385369),
          UINT32_C(0x002D97F4), UINT32_C(0x00213614), UINT32_C(0x005429E7),
          UINT32_C(0x001A6A17), UINT32_C(0x00022689), UINT32_C(0x0007C22E),
          UINT32_C(0x000CB237), UINT32_C(0x003B33BC), UINT32_C(0x003A2CF2),
          UINT32_C(0x001014A7), UINT32_C(0x004AFB82), UINT32_C(0x003DB97C),
          UINT32_C(0x0016FCCC), UINT32_C(0x001D22CE)}},
        {{UINT32_C(0x00583D1F), UINT32_C(0x001CAB29), UINT32_C(0x0021DFFC),
          UINT32_C(0x00579859), UINT32_C(0x00239960), UINT32_C(0x00287022),
          UINT32_C(0x000FBF8A), UINT32_C(0x00522225), UINT32_C(0x00084A9F),
          UINT32_C(0x0024948B), UINT32_C(0x002CC83C), UINT32_C(0x0067C4AC),
          UINT32_C(0x0034836D), UINT32_C(0x00216546), UINT32_C(0x00364159),
          UINT32_C(0x003ADB5A), UINT32_C(0x0003CEB5), UINT32_C(0x00345B44),
          UINT32_C(0x002138FD), UINT32_C(0x001743CA), UINT32_C(0x00069ABD),
          UINT32_C(0x0023EC4A), UINT32_C(0x00050B88)},
         {UINT32_C(0x006438C3), UINT32_C(0x00369425), UINT32_C(0x00279B67),
          UINT32_C(0x000D0143), UINT32_C(0x001F364D), UINT32_C(0x00177C5D),
          UINT32_C(0x00095B66), UINT32_C(0x002B4C4F), UINT32_C(0x002C159D),
          UINT32_C(0x0004AD5B), UINT32_C(0x00177C82), UINT32_C(0x0033A0E4),
          UINT32_C(0x003ACCD6), UINT32_C(0x0034623F), UINT32_C(0x000F5D74),
          UINT32_C(0x00680AEF), UINT32_C(0x002D31E0), UINT32_C(0x000BB398),
          UINT32_C(0x00233354), UINT32_C(0x00253484), UINT32_C(0x00385E50),
          UINT32_C(0x000F78CF), UINT32_C(0x000322BA)}},
        {{UINT32_C(0x00724124), UINT32_C(0x0030C69A), UINT32_C(0x00310E26),
          UINT32_C(0x00278477), UINT32_C(0x0012FFD4), UINT32_C(0x0005570F),
          UINT32_C(0x003EBD03), UINT32_C(0x006F51F4), UINT32_C(0x00043A21),
          UINT32_C(0x001A4CEA), UINT32_C(0x00172D44), UINT32_C(0x00696C4A),
          UINT32_C(0x003FA9A1), UINT32_C(0x0026633B), UINT32_C(0x0005F2B7),
          UINT32_C(0x0002C7C4), UINT32_C(0x0003A452), UINT32_C(0x003F240B),
          UINT32_C(0x003CBC7E), UINT32_C(0x00074F43), UINT32_C(0x002F68A2),
          UINT32_C(0x000623F6), UINT32_C(0x001D4282)},
         {UINT32_C(0x0014B428), UINT32_C(0x003E7D33), UINT32_C(0x002520C7),
          UINT32_C(0x0041CCF2), UINT32_C(0x00233BAB), UINT32_C(0x001589F9),
          UINT32_C(0x000D2E6E), UINT32_C(0x001FFD7C), UINT32_C(0x001DCFD2),
          UINT32_C(0x00390FFE), UINT32_C(0x00031026), UINT32_C(0x00772372),
          UINT32_C(0x0010F507), UINT32_C(0x0039D935), UINT32_C(0x0011504F),
          UINT32_C(0x0041B316), UINT32_C(0x001B31F1), UINT32_C(0x00309FCB),
          UINT32_C(0x002D1468), UINT32_C(0x00238297), UINT32_C(0x001B6605),
          UINT32_C(0x001B59F9), UINT32_C(0x000B6C96)}},
        {{UINT32_C(0x0043F6C2), UINT32_C(0x000763DF), UINT32_C(0x00308091),
          UINT32_C(0x006DDCFF), UINT32_C(0x002FC758), UINT32_C(0x001EFF60),
          UINT32_C(0x0018180E), UINT32_C(0x005F0A71), UINT32_C(0x001E4437),
          UINT32_C(0x000EADD7), UINT32_C(0x0012CA06), UINT32_C(0x0024EF90),
          UINT32_C(0x00188475), UINT32_C(0x0018B6D9), UINT32_C(0x001DEA6E),
          UINT32_C(0x0044FC14), UINT32_C(0x003D1458), UINT32_C(0x0031E96A),
          UINT32_C(0x000E2DAF), UINT32_C(0x00628BB3), UINT32_C(0x002A2193),
          UINT32_C(0x00011F06), UINT32_C(0x000C91E9)},
         {UINT32_C(0x00482FED), UINT32_C(0x002528F8), UINT32_C(0x002FD25C),
          UINT32_C(0x00261308), UINT32_C(0x00139233), UINT32_C(0x00302E3F),
          UINT32_C(0x002A13B0), UINT32_C(0x007DEDA6), UINT32_C(0x0011FB4F),
          UINT32_C(0x0008FBA1), UINT32_C(0x00196CC9), UINT32_C(0x0051E7E4),
          UINT32_C(0x0005A421), UINT32_C(0x003784E4), UINT32_C(0x00174AFF),
          UINT32_C(0x004725BC), UINT32_C(0x0004CD05), UINT32_C(0x0026FA6B),
          UINT32_C(0x001805BF), UINT32_C(0x0017519D), UINT32_C(0x001A7B71),
          UINT32_C(0x00280018), UINT32_C(0x0026EC17)}},
        {{UINT32_C(0x001C205B), UINT32_C(0x002CCC69), UINT32_C(0x0030F0E5),
          UINT32_C(0x00192A4E), UINT32_C(0x003D1B67), UINT32_C(0x0020DAE2),
          UINT32_C(0x000769DE), UINT32_C(0x001BFA4D), UINT32_C(0x000B7649),
          UINT32_C(0x000C1B2B), UINT32_C(0x0038C90F), UINT32_C(0x001D0BF8),
          UINT32_C(0x000577CB), UINT32_C(0x00190B4F), UINT32_C(0x003E238F),
          UINT32_C(0x0052DFF8), UINT32_C(0x0010D0F0), UINT32_C(0x000218C9),
          UINT32_C(0x0013F89C), UINT32_C(0x00714803), UINT32_C(0x003A6F8C),
          UINT32_C(0x00353B6D), UINT32_C(0x002FFEEA)},
         {UINT32_C(0x0030C7D2), UINT32_C(0x000CA103), UINT32_C(0x0021611C),
          UINT32_C(0x00188899), UINT32_C(0x001F54E9), UINT32_C(0x00010620),
          UINT32_C(0x000AE01A), UINT32_C(0x007A2DB9), UINT32_C(0x002A9401),
          UINT32_C(0x00209C63), UINT32_C(0x00389F5D), UINT32_C(0x00196FFF),
          UINT32_C(0x002CE291), UINT32_C(0x00340A01), UINT32_C(0x003FF906),
          UINT32_C(0x002C42FC), UINT32_C(0x0037C6A3), UINT32_C(0x001146A7),
          UINT32_C(0x00044BAD), UINT32_C(0x0063D883), UINT32_C(0x000BAB16),
          UINT32_C(0x001FF085), UINT32_C(0x00140B79)}},
        {{UINT32_C(0x0032C0E7), UINT32_C(0x00208DFF), UINT32_C(0x002F6660),
          UINT32_C(0x0070C915), UINT32_C(0x002D9AF5), UINT32_C(0x0012AB64),
          UINT32_C(0x0015326E), UINT32_C(0x001E8920), UINT32_C(0x0031383C),
          UINT32_C(0x000E45C6), UINT32_C(0x003FF494), UINT32_C(0x00792407),
          UINT32_C(0x0021A39A), UINT32_C(0x003EFC30), UINT32_C(0x0008C932),
          UINT32_C(0x0031D0D5), UINT32_C(0x0013E9B1), UINT32_C(0x0016F25F),
          UINT32_C(0x00251F58), UINT32_C(0x001D0CCC), UINT32_C(0x00189479),
          UINT32_C(0x001E2A1D), UINT32_C(0x001548E8)},
         {UINT32_C(0x007ED4E4), UINT32_C(0x003831E3), UINT32_C(0x0036B65B),
          UINT32_C(0x00173DB0), UINT32_C(0x0030B4B3), UINT32_C(0x003B0A38),
          UINT32_C(0x00176695), UINT32_C(0x0022F024), UINT32_C(0x002DC536),
          UINT32_C(0x0026D641), UINT32_C(0x003845E6), UINT32_C(0x006AE213),
          UINT32_C(0x000F1253), UINT32_C(0x0035B8B4), UINT32_C(0x002D1D2C),
          UINT32_C(0x0026072B), UINT32_C(0x000C4DFF), UINT32_C(0x00098C06),
          UINT32_C(0x003973E5), UINT32_C(0x006E815F), UINT32_C(0x0035E739),
          UINT32_C(0x0004E25A), UINT32_C(0x00323E06)}},
        {{UINT32_C(0x0018218E), UINT32_C(0x001C5A05), UINT32_C(0x00156FEA),
          UINT32_C(0x000DEF36), UINT32_C(0x003405AB), UINT32_C(0x000C8D8A),
          UINT32_C(0x003D4CE6), UINT32_C(0x0036C6B1), UINT32_C(0x0026347B),
          UINT32_C(0x002BEC62), UINT32_C(0x00135B49), UINT32_C(0x004ED20D),
          UINT32_C(0x002BCE15), UINT32_C(0x000A503C), UINT32_C(0x0030279F),
          UINT32_C(0x00124E30), UINT32_C(0x003AF38A), UINT32_C(0x0008EB83),
          UINT32_C(0x00141065), UINT32_C(0x004DF4DC), UINT32_C(0x00176DD3),
          UINT32_C(0x000FCB73), UINT32_C(0x000229CD)},
         {UINT32_C(0x0004041C), UINT32_C(0x003CAB13), UINT32_C(0x0029B3E4),
          UINT32_C(0x001B70DE), UINT32_C(0x00009B3A), UINT32_C(0x002C70AC),
          UINT32_C(0x00272EDA), UINT32_C(0x0010407E), UINT32_C(0x000645F0),
          UINT32_C(0x001E2E70), UINT32_C(0x000502A8), UINT32_C(0x00794831),
          UINT32_C(0x003AE5DE), UINT32_C(0x002799EA), UINT32_C(0x001CAFA4),
          UINT32_C(0x006E7B51), UINT32_C(0x0008984E), UINT32_C(0x0012EF3F),
          UINT32_C(0x000025E7), UINT32_C(0x000DDA10), UINT32_C(0x00119536),
          UINT32_C(0x003D6D8D), UINT32_C(0x0006C12F)}},
        {{UINT32_C(0x00435EE4), UINT32_C(0x000163D6), UINT32_C(0x00377C11),
          UINT32_C(0x003BD7D6), UINT32_C(0x002E05F5), UINT32_C(0x001FBA80),
          UINT32_C(0x00107C07), UINT32_C(0x00681A61), UINT32_C(0x0005189C),
          UINT32_C(0x0002C249), UINT32_C(0x003607CD), UINT32_C(0x000957D6),
          UINT32_C(0x003F952A), UINT32_C(0x0008ECBA), UINT32_C(0x001E29E1),
          UINT32_C(0x0033462B), UINT32_C(0x0022898D), UINT32_C(0x001AABD5),
          UINT32_C(0x002E885C), UINT32_C(0x000A2647), UINT32_C(0x0037A37C),
          UINT32_C(0x00297E79), UINT32_C(0x002A2CA3)},
         {UINT32_C(0x002C1A17), UINT32_C(0x00158B61), UINT32_C(0x0016816F),
          UINT32_C(0x0053A5A8), UINT32_C(0x001547B2), UINT32_C(0x0030AC66),
          UINT32_C(0x00202C4C), UINT32_C(0x00274C07), UINT32_C(0x000D322E),
          UINT32_C(0x0004A3E0), UINT32_C(0x000F7BC7), UINT32_C(0x00102196),
          UINT32_C(0x000C81FB), UINT32_C(0x00358316), UINT32_C(0x00063F2B),
          UINT32_C(0x007FF11C), UINT32_C(0x0025FFE3), UINT32_C(0x00256744),
          UINT32_C(0x002E91A0), UINT32_C(0x0064976E), UINT32_C(0x0038C948),
          UINT32_C(0x00396FAC), UINT32_C(0x0037CF6E)}},
        {{UINT32_C(0x00794F1D), UINT32_C(0x002B6A50), UINT32_C(0x00120AE4),
          UINT32_C(0x001CEC0F), UINT32_C(0x00383F87), UINT32_C(0x00216277),
          UINT32_C(0x00286CEA), UINT32_C(0x00103D5A), UINT32_C(0x002AA574),
          UINT32_C(0x003D3491), UINT32_C(0x0022931D), UINT32_C(0x00489498),
          UINT32_C(0x0032EEF4), UINT32_C(0x000CA2AA), UINT32_C(0x00080A27),
          UINT32_C(0x007FA661), UINT32_C(0x00094E9A), UINT32_C(0x003EE29E),
          UINT32_C(0x002AC21C), UINT32_C(0x001CE359), UINT32_C(0x003330FC),
          UINT32_C(0x001C6ADE), UINT32_C(0x00187790)},
         {UINT32_C(0x00340EF5), UINT32_C(0x000BDD62), UINT32_C(0x00333909),
          UINT32_C(0x0039146A), UINT32_C(0x0038BB2E), UINT32_C(0x00030F37),
          UINT32_C(0x00143B07), UINT32_C(0x0031CC3D), UINT32_C(0x002B5B5C),
          UINT32_C(0x00005892), UINT32_C(0x00052BD0), UINT32_C(0x000A282B),
          UINT32_C(0x0030D9C5), UINT32_C(0x001004FC), UINT32_C(0x0038922A),
          UINT32_C(0x000241A2), UINT32_C(0x000053C3), UINT32_C(0x002C02CA),
          UINT32_C(0x002D4F8F), UINT32_C(0x004AB17B), UINT32_C(0x003667C0),
          UINT32_C(0x0004EF7E), UINT32_C(0x000080E4)}},
        {{UINT32_C(0x005FA89B), UINT32_C(0x001D2F7D), UINT32_C(0x0019B385),
          UINT32_C(0x0053B863), UINT32_C(0x0022E414), UINT32_C(0x0011C620),
          UINT32_C(0x001F0CA5), UINT32_C(0x001B475A), UINT32_C(0x003E5B07),
          UINT32_C(0x0020C305), UINT32_C(0x0018A591), UINT32_C(0x007DE564),
          UINT32_C(0x001F654F), UINT32_C(0x003F1044), UINT32_C(0x000D7B16),
          UINT32_C(0x004E51E7), UINT32_C(0x00267972), UINT32_C(0x002A42F3),
          UINT32_C(0x000159C2), UINT32_C(0x0016007C), UINT32_C(0x000F9CA8),
          UINT32_C(0x00021184), UINT32_C(0x0007FCE7)},
         {UINT32_C(0x00045B0F), UINT32_C(0x000002C5), UINT32_C(0x0033642B),
          UINT32_C(0x0038378F), UINT32_C(0x001F29A8), UINT32_C(0x0018130B),
          UINT32_C(0x00340B0B), UINT32_C(0x007667B7), UINT32_C(0x0038B986),
          UINT32_C(0x00218A5C), UINT32_C(0x0020D3E4), UINT32_C(0x002B84EB),
          UINT32_C(0x001DBF61), UINT32_C(0x0006E45C), UINT32_C(0x000C2528),
          UINT32_C(0x003D5B87), UINT32_C(0x003B9631), UINT32_C(0x0016FFC9),
          UINT32_C(0x002577D8), UINT32_C(0x00084014), UINT32_C(0x00326179),
          UINT32_C(0x002B97FC), UINT32_C(0x0017D9B9)}},
    },
    {
        {{UINT32_C(0x0024FC6B), UINT32_C(0x00260048), UINT32_C(0x0027A39B),
          UINT32_C(0x004A6771), UINT32_C(0x002F8996), UINT32_C(0x00250571),
          UINT32_C(0x0022BD5A), UINT32_C(0x0016BA95), UINT32_C(0x00177752),
          UINT32_C(0x003AAE54), UINT32_C(0x000382BC), UINT32_C(0x002DBDCA),
          UINT32_C(0x00175D11), UINT32_C(0x000485AB), UINT32_C(0x00263BCC),
          UINT32_C(0x002CA217), UINT32_C(0x0033AA31), UINT32_C(0x001EB58F),
          UINT32_C(0x001CAA07), UINT32_C(0x00439150), UINT32_C(0x003350D2),
          UINT32_C(0x002E0A1C), UINT32_C(0x000B60E4)},
         {UINT32_C(0x006AFAB6), UINT32_C(0x001979BD), UINT32_C(0x00206F5D),
          UINT32_C(0x004F0B02), UINT32_C(0x001DC842), UINT32_C(0x0032D59A),
          UINT32_C(0x001DC451), UINT32_C(0x0022D419), UINT32_C(0x00003471),
          UINT32_C(0x00178E67), UINT32_C(0x002D0057), UINT32_C(0x006162BD),
          UINT32_C(0x000E5A47), UINT32_C(0x00139F7C), UINT32_C(0x0006E056),
          UINT32_C(0x00245E47), UINT32_C(0x0000179C), UINT32_C(0x0028BA82),
          UINT32_C(0x00229B1F), UINT32_C(0x003B6E93), UINT32_C(0x0012AE29),
          UINT32_C(0x0017CD91), UINT32_C(0x0014F8C1)}},
        {{UINT32_C(0x00340D60), UINT32_C(0x00077299), UINT32_C(0x003D596C),
          UINT32_C(0x005CAB48), UINT32_C(0x0018060B), UINT32_C(0x00108F8B),
          UINT32_C(0x00155345), UINT32_C(0x00555740), UINT32_C(0x0006639B),
          UINT32_C(0x000966BA), UINT32_C(0x0028B692), UINT32_C(0x000E0989),
          UINT32_C(0x000E36E6), UINT32_C(0x003EA5CF), UINT32_C(0x003E7233),
          UINT32_C(0x002BCE85), UINT32_C(0x003B53C6), UINT32_C(0x000B6428),
          UINT32_C(0x000CEB17), UINT32_C(0x001439C1), UINT32_C(0x003E1768),
          UINT32_C(0x00182028), UINT32_C(0x00063591)},
         {UINT32_C(0x004C6A3E), UINT32_C(0x0003B6B4), UINT32_C(0x00308620),
          UINT32_C(0x0042D6E7), UINT32_C(0x000688FB), UINT32_C(0x00242205),
          UINT32_C(0x0015FD4B), UINT32_C(0x006548A0), UINT32_C(0x00073894),
          UINT32_C(0x00059483), UINT32_C(0x00070BE7), UINT32_C(0x005EC1A3),
          UINT32_C(0x00138AF9), UINT32_C(0x00059A16), UINT32_C(0x000721C1),
          UINT32_C(0x003D327D), UINT32_C(0x000AC881), UINT32_C(0x0008254B),
          UINT32_C(0x00291DB6), UINT32_C(0x00202301), UINT32_C(0x002587BC),
          UINT32_C(0x002F4480), UINT32_C(0x000BB989)}},
        {{UINT32_C(0x0044D64A), UINT32_C(0x00169A22), UINT32_C(0x00198EE3),
          UINT32_C(0x001C1CF3), UINT32_C(0x001ABB64), UINT32_C(0x0002B70C),
          UINT32_C(0x000D1B40), UINT32_C(0x0000B41C), UINT32_C(0x001A07BF),
          UINT32_C(0x0031380A), UINT32_C(0x0037E0A3), UINT32_C(0x005959D5),
          UINT32_C(0x00195DCD), UINT32_C(0x00318DBC), UINT32_C(0x00014119),
          UINT32_C(0x0039F9F8), UINT32_C(0x002F8B00), UINT32_C(0x00035A9F),
          UINT32_C(0x001F77ED), UINT32_C(0x0042F50F), UINT32_C(0x0010F6EB),
          UINT32_C(0x00018D31), UINT32_C(0x00115505)},
         {UINT32_C(0x004A9CF0), UINT32_C(0x00396AE3), UINT32_C(0x002F36DC),
          UINT32_C(0x0059C454), UINT32_C(0x002372E1), UINT32_C(0x0017C289),
          UINT32_C(0x001DC88C), UINT32_C(0x00568BBB), UINT32_C(0x0038AAF3),
          UINT32_C(0x000AC735), UINT32_C(0x001D93C9), UINT32_C(0x0079763F),
          UINT32_C(0x000474DE), UINT32_C(0x001FFEA5), UINT32_C(0x0032E7A4),
          UINT32_C(0x00286D83), UINT32_C(0x001C592E), UINT32_C(0x002E08D4),
          UINT32_C(0x003C918F), UINT32_C(0x00635953), UINT32_C(0x00125ECD),
          UINT32_C(0x00218E30), UINT32_C(0x0038E348)}},
        {{UINT32_C(0x001F97CB), UINT32_C(0x00027C45), UINT32_C(0x0004CBBC),
          UINT32_C(0x003C768C), UINT32_C(0x002150EB), UINT32_C(0x00309BAC),
          UINT32_C(0x001BD192), UINT32_C(0x00449D0C), UINT32_C(0x00027761),
          UINT32_C(0x00334EC9), UINT32_C(0x0004B563), UINT32_C(0x0063BBA5),
          UINT32_C(0x0022D5EC), UINT32_C(0x0036D1DC), UINT32_C(0x0022C410),
          UINT32_C(0x005B8D6B), UINT32_C(0x00182967), UINT32_C(0x002A4F38),
          UINT32_C(0x00111A50), UINT32_C(0x00211F1F), UINT32_C(0x001EDAD2),
          UINT32_C(0x0018C6ED), UINT32_C(0x00195251)},
         {UINT32_C(0x002C575A), UINT32_C(0x00368BF8), UINT32_C(0x001817CE),
          UINT32_C(0x0023D30F), UINT32_C(0x00335F3C), UINT32_C(0x003D8B6B),
          UINT32_C(0x0036535C), UINT32_C(0x006E800F), UINT32_C(0x001D0FEE),
          UINT32_C(0x001D0E1D), UINT32_C(0x001030F4), UINT32_C(0x00575F2F),
          UINT32_C(0x000272DE), UINT32_C(0x0012885A), UINT32_C(0x001E98BE),
          UINT32_C(0x0002CEF1), UINT32_C(0x00343652), UINT32_C(0x0026244E),
          UINT32_C(0x00112950), UINT32_C(0x000CF99B), UINT32_C(0x0039E10D),
          UINT32_C(0x0019A48E), UINT32_C(0x000F62D8)}},
        {{UINT32_C(0x007F47CB), UINT32_C(0x000DB92B), UINT32_C(0x001CFE89),
          UINT32_C(0x00438C82), UINT32_C(0x002F9B60), UINT32_C(0x0029F531),
          UINT32_C(0x0036DACC), UINT32_C(0x000B743F), UINT32_C(0x0014BFCA),
          UINT32_C(0x003076AB), UINT32_C(0x00061C92), UINT32_C(0x00402803),
          UINT32_C(0x001F9BBE), UINT32_C(0x002BB4F0), UINT32_C(0x001D49FC),
          UINT32_C(0x0039DA58), UINT32_C(0x001B9F65), UINT32_C(0x001A4032),
          UINT32_C(0x001853D6), UINT32_C(0x0077F83B), UINT32_C(0x000BA641),
          UINT32_C(0x0028F440), UINT32_C(0x00036529)},
         {UINT32_C(0x00469CBC), UINT32_C(0x000ECB6B), UINT32_C(0x003ED688),
          UINT32_C(0x00448228), UINT32_C(0x000125E0), UINT32_C(0x001294BB),
          UINT32_C(0x003209CD), UINT32_C(0x00431140), UINT32_C(0x0024ADFE),
          UINT32_C(0x000A297C), UINT32_C(0x00343443), UINT32_C(0x003DC6B9),
          UINT32_C(0x003A8F4A), UINT32_C(0x003CD200), UINT32_C(0x0027F94A),
          UINT32_C(0x0026C683), UINT32_C(0x001010D7), UINT32_C(0x00291317),
          UINT32_C(0x001C01DB), UINT32_C(0x00323A9C), UINT32_C(0x0018F9E1),
          UINT32_C(0x000FB990), UINT32_C(0x001C0FD8)}},
        {{UINT32_C(0x002529B0), UINT32_C(0x00047C33), UINT32_C(0x00105D03),
          UINT32_C(0x00668833), UINT32_C(0x001D8A87), UINT32_C(0x001BE267),
          UINT32_C(0x002E8A17), UINT32_C(0x001BA406), UINT32_C(0x0012683B),
          UINT32_C(0x0032EFBE), UINT32_C(0x0033C9C9), UINT32_C(0x003816FD),
          UINT32_C(0x001E2856), UINT32_C(0x001FA678), UINT32_C(0x0034CF0E),
          UINT32_C(0x002BC6D4), UINT32_C(0x0021D8C3), UINT32_C(0x00138A8F),
          UINT32_C(0x00301A91), UINT32_C(0x007BA5BF), UINT32_C(0x0027ADBF),
          UINT32_C(0x00084950), UINT32_C(0x003344F2)},
         {UINT32_C(0x001D7DDB), UINT32_C(0x000B9FBD), UINT32_C(0x003A23D1),
          UINT32_C(0x000DAA8E), UINT32_C(0x0015296C), UINT32_C(0x00378879),
          UINT32_C(0x00080207), UINT32_C(0x006DACFA), UINT32_C(0x002C4D0C),
          UINT32_C(0x0003E240), UINT32_C(0x0005CDBB), UINT32_C(0x004B5100),
          UINT32_C(0x0024673C), UINT32_C(0x003EDDC4), UINT32_C(0x001C3104),
          UINT32_C(0x004EC191), UINT32_C(0x001B0572), UINT32_C(0x002EE934),
          UINT32_C(0x001E439A), UINT32_C(0x0008B8BC), UINT32_C(0x001D336D),
          UINT32_C(0x000C0450), UINT32_C(0x00264399)}},
        {{UINT32_C(0x0063BA75), UINT32_C(0x000E5577), UINT32_C(0x002D84D8),
          UINT32_C(0x0011F137), UINT32_C(0x003C0568), UINT32_C(0x001FCF04),
          UINT32_C(0x00369E84), UINT32_C(0x0026107B), UINT32_C(0x003793D0),
          UINT32_C(0x002FF753), UINT32_C(0x00080D0D), UINT32_C(0x0009FE5B),
          UINT32_C(0x000D568B), UINT32_C(0x00306219), UINT32_C(0x00057FB4),
          UINT32_C(0x00251274), UINT32_C(0x0028F357), UINT32_C(0x001868A6),
          UINT32_C(0x00245601), UINT32_C(0x00694DDA), UINT32_C(0x001BF932),
          UINT32_C(0x00291545), UINT32_C(0x000834DF)},
         {UINT32_C(0x005DE7C7), UINT32_C(0x00043FB9), UINT32_C(0x002022F7),
          UINT32_C(0x006DD20B), UINT32_C(0x0034DB2B), UINT32_C(0x0009812A),
          UINT32_C(0x000634E5), UINT32_C(0x00529BDD), UINT32_C(0x0037E7AF),
          UINT32_C(0x0020131E), UINT32_C(0x0028145E), UINT32_C(0x007D781A),
          UINT32_C(0x003F2E11), UINT32_C(0x00090377), UINT32_C(0x001FF3F0),
          UINT32_C(0x0029544B), UINT32_C(0x0004B34A), UINT32_C(0x00308A92),
          UINT32_C(0x00230957), UINT32_C(0x0030849F), UINT32_C(0x003BD197),
          UINT32_C(0x0036543D), UINT32_C(0x0013DB50)}},
        {{UINT32_C(0x006DBC4E), UINT32_C(0x000B8C36), UINT32_C(0x0033C975),
          UINT32_C(0x001B98FA), UINT32_C(0x000E1469), UINT32_C(0x003F57BB),
          UINT32_C(0x00366AF6), UINT32_C(0x002940D4), UINT32_C(0x002A7401),
          UINT32_C(0x000B24FA), UINT32_C(0x003D079C), UINT32_C(0x000BBF2B),
          UINT32_C(0x001C8DA1), UINT32_C(0x00281279), UINT32_C(0x003FD16B),
          UINT32_C(0x005F172D), UINT32_C(0x003BC575), UINT32_C(0x0003F2EE),
          UINT32_C(0x000EB6E0), UINT32_C(0x0025AA43), UINT32_C(0x0019146D),
          UINT32_C(0x000E2FCD), UINT32_C(0x000708D1)},
         {UINT32_C(0x00188A0A), UINT32_C(0x003280E1), UINT32_C(0x00375AE3),
          UINT32_C(0x005DEF79), UINT32_C(0x0030CA8C), UINT32_C(0x0011A4E2),
          UINT32_C(0x001A18EE), UINT32_C(0x0015160F), UINT32_C(0x003D4633),
          UINT32_C(0x00210DF1), UINT32_C(0x0039513D), UINT32_C(0x00032B85),
          UINT32_C(0x0000562C), UINT32_C(0x002B09DE), UINT32_C(0x0012E5D7),
          UINT32_C(0x00343965), UINT32_C(0x002482BA), UINT32_C(0x00358D60),
          UINT32_C(0x00210688), UINT32_C(0x001DE534), UINT32_C(0x0037E47D),
          UINT32_C(0x00306432), UINT32_C(0x00331A00)}},
        {{UINT32_C(0x000E3961), UINT32_C(0x00136E2C), UINT32_C(0x00396117),
          UINT32_C(0x003A4EA9), UINT32_C(0x002B633F), UINT32_C(0x00331384),
          UINT32_C(0x000E6FDA), UINT32_C(0x00110B81), UINT32_C(0x00083F56),
          UINT32_C(0x0010E231), UINT32_C(0x00377F5B), UINT32_C(0x00777CBF),
          UINT32_C(0x0027D587), UINT32_C(0x0016725E), UINT32_C(0x0022FAFB),
          UINT32_C(0x0050FCA0), UINT32_C(0x0035E866), UINT32_C(0x001F6AF5),
          UINT32_C(0x00131AFF), UINT32_C(0x0031B90B), UINT32_C(0x003D8FC9),
          UINT32_C(0x003CCAEF), UINT32_C(0x000BCF90)},
         {UINT32_C(0x0037CE7B), UINT32_C(0x003B57EC), UINT32_C(0x00161E92),
          UINT32_C(0x0065355B), UINT32_C(0x0024637B), UINT32_C(0x0008B2C0),
          UINT32_C(0x0002E6FD), UINT32_C(0x001ED2F1), UINT32_C(0x0024A016),
          UINT32_C(0x0022B354), UINT32_C(0x0019306E), UINT32_C(0x003009F9),
          UINT32_C(0x00130478), UINT32_C(0x0039951C), UINT32_C(0x003B9F26),
          UINT32_C(0x00129D8E), UINT32_C(0x0028EAE8), UINT32_C(0x002E0532),
          UINT32_C(0x002312B7), UINT32_C(0x001904D9), UINT32_C(0x001F8FB7),
          UINT32_C(0x00306139), UINT32_C(0x00191E58)}},
        {{UINT32_C(0x00315B6B), UINT32_C(0x0006110B), UINT32_C(0x002D0F7A),
          UINT32_C(0x000B35D8), UINT32_C(0x0039DD74), UINT32_C(0x0013BF7F),
          UINT32_C(0x00088A74), UINT32_C(0x00678A54), UINT32_C(0x0027C11E),
          UINT32_C(0x0039299C), UINT32_C(0x0009E852), UINT32_C(0x003A9738),
          UINT32_C(0x003BA90B), UINT32_C(0x003C704C), UINT32_C(0x00031EAD),
          UINT32_C(0x003F9F6D), UINT32_C(0x00060C99), UINT32_C(0x00210078),
          UINT32_C(0x000A43CC), UINT32_C(0x001D2C3A), UINT32_C(0x0016F165),
          UINT32_C(0x002CBE20), UINT32_C(0x003CBD2A)},
         {UINT32_C(0x006EA72C), UINT32_C(0x0019FAA9), UINT32_C(0x0027119B),
          UINT32_C(0x00002DB4), UINT32_C(0x003FC202), UINT32_C(0x00258426),
          UINT32_C(0x0017A426), UINT32_C(0x00591EA2), UINT32_C(0x000DAAC0),
          UINT32_C(0x00160BB2), UINT32_C(0x002B5C9B), UINT32_C(0x0034552F),
          UINT32_C(0x00354208), UINT32_C(0x003F73F6), UINT32_C(0x001D329F),
          UINT32_C(0x00541523), UINT32_C(0x001D2733), UINT32_C(0x003E6DA0),
          UINT32_C(0x00058267), UINT32_C(0x002FD1CD), UINT32_C(0x003085B8),
          UINT32_C(0x0037B13E), UINT32_C(0x0011D71D)}},
        {{UINT32_C(0x004EF58F), UINT32_C(0x00111078), UINT32_C(0x002A7D65),
          UINT32_C(0x0032333E), UINT32_C(0x0011BB9D), UINT32_C(0x0033FA14),
          UINT32_C(0x001ABD10), UINT32_C(0x007F9C0D), UINT32_C(0x0012F21C),
          UINT32_C(0x003C4D14), UINT32_C(0x003A59E2), UINT32_C(0x0017140E),
          UINT32_C(0x003EC05A), UINT32_C(0x002B8323), UINT32_C(0x0013D487),
          UINT32_C(0x0061B630), UINT32_C(0x000C1262), UINT32_C(0x0034A7E5),
          UINT32_C(0x0018DA22), UINT32_C(0x000DA70C), UINT32_C(0x001E1E78),
          UINT32_C(0x0037CE10), UINT32_C(0x000BEBB1)},
         {UINT32_C(0x004F54F0), UINT32_C(0x000A220B), UINT32_C(0x00161352),
          UINT32_C(0x007E4EA4), UINT32_C(0x002878DE), UINT32_C(0x001C80E5),
          UINT32_C(0x000C0855), UINT32_C(0x0075DF3B), UINT32_C(0x0039D0AB),
          UINT32_C(0x001D0301), UINT32_C(0x001594B9), UINT32_C(0x0078140B),
          UINT32_C(0x001A2C01), UINT32_C(0x0028FCE5), UINT32_C(0x003C573C),
          UINT32_C(0x0006E543), UINT32_C(0x003A90E6), UINT32_C(0x002D4FDD),
          UINT32_C(0x0022B1F7), UINT32_C(0x0062CB04), UINT32_C(0x002C12CA),
          UINT32_C(0x00389E83), UINT32_C(0x0007631E)}},
        {{UINT32_C(0x0023C68B), UINT32_C(0x000F609A), UINT32_C(0x000D7E01),
          UINT32_C(0x0069E56B), UINT32_C(0x0003D496), UINT32_C(0x001BC8DC),
          UINT32_C(0x00328E76), UINT32_C(0x00316565), UINT32_C(0x0011A340),
          UINT32_C(0x00374048), UINT32_C(0x0016C79E), UINT32_C(0x0014449B),
          UINT32_C(0x002EE9B6), UINT32_C(0x00032A11), UINT32_C(0x001212A3),
          UINT32_C(0x003D35C1), UINT32_C(0x003485FD), UINT32_C(0x001199A6),
          UINT32_C(0x001C3F0D), UINT32_C(0x0017F8CF), UINT32_C(0x0014AC02),
          UINT32_C(0x001E0EB1), UINT32_C(0x001ACA7C)},
         {UINT32_C(0x0031C47A), UINT32_C(0x00102E12), UINT32_C(0x002F6F4B),
          UINT32_C(0x005B2D93), UINT32_C(0x000A9886), UINT32_C(0x001CC034),
          UINT32_C(0x0023E81B), UINT32_C(0x0001A7CE), UINT32_C(0x0029ABC3),
          UINT32_C(0x0004048C), UINT32_C(0x002BC25D), UINT32_C(0x00368ABA),
          UINT32_C(0x0002746C), UINT32_C(0x00373868), UINT32_C(0x00061AA2),
          UINT32_C(0x0056401C), UINT32_C(0x00207F34), UINT32_C(0x001FCA2D),
          UINT32_C(0x00169B9E), UINT32_C(0x0064FDA3), UINT32_C(0x0028C18A),
          UINT32_C(0x000C0847), UINT32_C(0x001845F0)}},
        {{UINT32_C(0x002F9AD9), UINT32_C(0x0009590F), UINT32_C(0x00130486),
          UINT32_C(0x0059CC83), UINT32_C(0x0039A337), UINT32_C(0x0022C7C7),
          UINT32_C(0x0003C259), UINT32_C(0x00602650), UINT32_C(0x0008510C),
          UINT32_C(0x00384F8A), UINT32_C(0x001F3AA0), UINT32_C(0x003706DA),
          UINT32_C(0x00069456), UINT32_C(0x0002AD7C), UINT32_C(0x00003A14),
          UINT32_C(0x007327BA), UINT32_C(0x002F7478), UINT32_C(0x001FBB28),
          UINT32_C(0x0023BC3E), UINT32_C(0x007F5AB5), UINT32_C(0x001FFF4E),
          UINT32_C(0x00188D11), UINT32_C(0x0013BC8B)},
         {UINT32_C(0x0000C111), UINT32_C(0x0006AA72), UINT32_C(0x0012A2E9),
          UINT32_C(0x0055127A), UINT32_C(0x003C8991), UINT32_C(0x0036CFBC),
          UINT32_C(0x0037F0BB), UINT32_C(0x00655B21), UINT32_C(0x002B75E3),
          UINT32_C(0x00336687), UINT32_C(0x00210878), UINT32_C(0x00089C2C),
          UINT32_C(0x003CEE92), UINT32_C(0x00143383), UINT32_C(0x00371D45),
          UINT32_C(0x000BCDFE), UINT32_C(0x00238367), UINT32_C(0x001C2D8B),
          UINT32_C(0x003E06AD), UINT32_C(0x0053DBC8), UINT32_C(0x002A9F89),
          UINT32_C(0x002955F8), UINT32_C(0x00137029)}},
        {{UINT32_C(0x0002FB5B), UINT32_C(0x0032BB27), UINT32_C(0x001EE694),
          UINT32_C(0x002E2965), UINT32_C(0x00395F01), UINT32_C(0x003FEC08),
          UINT32_C(0x003ABDFB), UINT32_C(0x0068B88B), UINT32_C(0x00221DB7),
          UINT32_C(0x000F72D1), UINT32_C(0x0003F9DC), UINT32_C(0x005C1B93),
          UINT32_C(0x00073A9E), UINT32_C(0x00160BD0), UINT32_C(0x00053416),
          UINT32_C(0x0023242A), UINT32_C(0x0010FAB9), UINT32_C(0x0006D2C5),
          UINT32_C(0x00236E83), UINT32_C(0x0054747B), UINT32_C(0x00063F98),
          UINT32_C(0x001A8789), UINT32_C(0x003DC7DA)},
         {UINT32_C(0x00463909), UINT32_C(0x0029E3B4), UINT32_C(0x0002F0E2),
          UINT32_C(0x00593390), UINT32_C(0x0034320B), UINT32_C(0x003F6A3B),
          UINT32_C(0x002603E4), UINT32_C(0x00016676), UINT32_C(0x00254C99),
          UINT32_C(0x0023EB7B), UINT32_C(0x00119D88), UINT32_C(0x003D63F8),
          UINT32_C(0x00350BC8), UINT32_C(0x00140757), UINT32_C(0x002473C4),
          UINT32_C(0x0034D831), UINT32_C(0x0017BDB7), UINT32_C(0x003E24EB),
          UINT32_C(0x00231FE3), UINT32_C(0x0070EC64), UINT32_C(0x00043E18),
          UINT32_C(0x002A4D4F), UINT32_C(0x0005D554)}},
        {{UINT32_C(0x006FC15D), UINT32_C(0x001F5830), UINT32_C(0x0008AD9E),
          UINT32_C(0x002845F0), UINT32_C(0x001CD01E), UINT32_C(0x0000CFC1),
          UINT32_C(0x0032AE8B), UINT32_C(0x0019E673), UINT32_C(0x0030C5E5),
          UINT32_C(0x00050166), UINT32_C(0x00372FAC), UINT32_C(0x00057147),
          UINT32_C(0x0004060F), UINT32_C(0x00163807), UINT32_C(0x002BCADD),
          UINT32_C(0x00376726), UINT32_C(0x0028315B), UINT32_C(0x0009418F),
          UINT32_C(0x001E2957), UINT32_C(0x006D28BE), UINT32_C(0x001BCADE),
          UINT32_C(0x0031A352), UINT32_C(0x00052575)},
         {UINT32_C(0x00404C1D), UINT32_C(0x0024FA31), UINT32_C(0x0012C7A3),
          UINT32_C(0x007D71A8), UINT32_C(0x0028D167), UINT32_C(0x0020B8E9),
          UINT32_C(0x0032697E), UINT32_C(0x00202C6B), UINT32_C(0x00032212),
          UINT32_C(0x003AB37D), UINT32_C(0x0029EEED), UINT32_C(0x00239F39),
          UINT32_C(0x0007DC00), UINT32_C(0x003BD86F), UINT32_C(0x003B948C),
          UINT32_C(0x005D1965), UINT32_C(0x003C74AD), UINT32_C(0x001EAB46),
          UINT32_C(0x00255C49), UINT32_C(0x002402DB), UINT32_C(0x0004833F),
          UINT32_C(0x00181728), UINT32_C(0x002C23A4)}},
        {{UINT32_C(0x00069003), UINT32_C(0x001493A6), UINT32_C(0x003F6B49),
          UINT32_C(0x001B15E2), UINT32_C(0x003CB610), UINT32_C(0x003AC0D8),
          UINT32_C(0x0012E96D), UINT32_C(0x004C065C), UINT32_C(0x00318C4E),
          UINT32_C(0x00151ED2), UINT32_C(0x002348E6), UINT32_C(0x006AE001),
          UINT32_C(0x0012C641), UINT32_C(0x00126DF2), UINT32_C(0x001D6E0A),
          UINT32_C(0x00227223), UINT32_C(0x003493D1), UINT32_C(0x0027ED79),
          UINT32_C(0x00097233), UINT32_C(0x0004AB1D), UINT32_C(0x002E7F5A),
          UINT32_C(0x003ED69A), UINT32_C(0x003D2512)},
         {UINT32_C(0x002D81D0), UINT32_C(0x0012CD40), UINT32_C(0x00296981),
          UINT32_C(0x007D52C8), UINT32_C(0x002B5E71), UINT32_C(0x0018553C),
          UINT32_C(0x003F8695), UINT32_C(0x00730395), UINT32_C(0x00050DAB),
          UINT32_C(0x0015BCBA), UINT32_C(0x00220A46), UINT32_C(0x00762FDE),
          UINT32_C(0x0029B8D0), UINT32_C(0x0025890A), UINT32_C(0x002D307D),
          UINT32_C(0x0077543E), UINT32_C(0x001F282E), UINT32_C(0x00300B63),
          UINT32_C(0x000F826D), UINT32_C(0x00344F5F), UINT32_C(0x0017B455),
          UINT32_C(0x000FA526), UINT32_C(0x0013C162)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t0, X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t1, Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_square(t2, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, X, Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, Y, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, X, Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, X3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t2, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t2, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, Z3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, Z3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, t0, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t4, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t0, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, Z3);
}

/*-
 * out1 = (arg1 == 0) ? 0 : nz
 * NB: this is not a "mod p equiv" 0, but literal 0
 * NB: this is not a real Fiat function, just named that way for consistency.
 */
static void fiat_id_tc26_gost_3410_2012_512_paramSetA_nonzero(limb_t *out1,
                                                              const fe_t arg1) {
    limb_t x1 = 0;
    int i;

    for (i = 0; i < LIMB_CNT; i++) x1 |= arg1[i];
    *out1 = x1;
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, X1, X2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, Y1, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, X2, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, X1, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, Y2, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t4, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X2, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, X1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, X3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Z1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t1, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t4, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, t0, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, t3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t4, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->X, nz, Q->X, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t0, X1, X2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, Y1, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, Z1, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t3, X1, Y1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, X2, Y2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, t0, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t3, t3, t4);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t4, Y1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t5, Y2, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t4, t4, t5);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t5, t1, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t4, t4, t5);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X1, Z1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, X2, Z2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, X3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, b, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, Y3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, X3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Z3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(X3, t1, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, b, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t2, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t2, t1, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(Y3, Y3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, Y3, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, t1, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t1, t0, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(t0, t1, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(t0, t0, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t4, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t2, t0, Y3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Y3, X3, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Y3, Y3, t2);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(X3, t3, X3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_sub(X3, X3, t1);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(Z3, t4, Z3);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(t1, t3, t0);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[64], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 64) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[103], const unsigned char in[64]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 102; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[513], const unsigned char in[64]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 513; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[64],
                              const unsigned char b[64], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[513] = {0};
    int8_t bnaf[513] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 512; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[64],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[103] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[102] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, diff, Q.X,
                                                            precomp[j].X);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, diff, Q.Y,
                                                            precomp[j].Y);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, diff, Q.Z,
                                                            precomp[j].Z);
    }

    for (i = 101; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(out->Y, lut.Y);
        fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(lut.Y, is_neg,
                                                            lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, scalar[0] & 1,
                                                        lut.X, Q.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, scalar[0] & 1,
                                                        lut.Y, Q.Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, scalar[0] & 1,
                                                        lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[64]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[103] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 10; i >= 0; i--) {
        for (j = 0; i != 10 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 11; j++) {
            if (j * 11 + i > 102) continue;
            d = rnaf[j * 11 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(out->Y, lut.Y);
            fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(lut.Y, is_neg,
                                                                lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.X, scalar[0] & 1, R.X,
                                                        Q.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Y, scalar[0] & 1, R.Y,
                                                        Q.Y);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_selectznz(Q.Z, scalar[0] & 1, R.Z,
                                                        Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_tc26_gost_3410_2012_512_paramSetA_inv(Q.Z, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->X, Q.X, Q.Z);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_carry_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[64], unsigned char outy[64],
                          const unsigned char a[64], const unsigned char b[64],
                          const unsigned char inx[64],
                          const unsigned char iny[64]) {
    pt_aff_t P;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.X, inx);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.Y, iny);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[64], unsigned char outy[64],
                        const unsigned char scalar[64]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[64], unsigned char outy[64],
                      const unsigned char scalar[64],
                      const unsigned char inx[64],
                      const unsigned char iny[64]) {
    pt_aff_t P;

    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.X, inx);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_from_bytes(P.Y, iny);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outx, P.X);
    fiat_id_tc26_gost_3410_2012_512_paramSetA_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[64] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_tc26_gost_3410_2012_512_paramSetA(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_n[64];
    unsigned char b_m[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 64) != 64 || BN_bn2lebinpad(y, b_y, 64) != 64 ||
        BN_bn2lebinpad(n, b_n, 64) != 64 || BN_bn2lebinpad(m, b_m, 64) != 64)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_tc26_gost_3410_2012_512_paramSetA(const EC_GROUP *group,
                                                   EC_POINT *r,
                                                   const EC_POINT *q,
                                                   const BIGNUM *m,
                                                   BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_m[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 64) != 64 || BN_bn2lebinpad(y, b_y, 64) != 64 ||
        BN_bn2lebinpad(m, b_m, 64) != 64)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_tc26_gost_3410_2012_512_paramSetA(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const BIGNUM *n,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[64];
    unsigned char b_y[64];
    unsigned char b_n[64];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 64) != 64)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 64) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 64) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 64, x) == NULL ||
            BN_lebin2bn(b_y, 64, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#endif /* __SIZEOF_INT128__ */
