#if   !defined(__ROOM_HPP)
#define __ROOM_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAPSITE_HPP)
#include <MapSite.hpp>
#endif

DECLARE_TYPE( CORELINUX(Dword), RoomNumber );

DECLARE_CLASS( Room );


/**
Room is a concrete subclass of MapSite that defines a 
key relationship between components in the maze. It also
contains a identifier for rooms in the maze RoomNumber.
As rooms go, this one has four walls only.
*/

class Room : public MapSite
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor
                  
                        Room( void );

                        /// Default with RoomNumber

                        Room( RoomNumberCref aRoomNumber );

                        /// Copy constructor

                        Room( RoomCref ) throw( CORELINUX(Assertion) );

                        /// Virtual destructor

   virtual              ~Room( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            RoomRef  operator=( RoomCref aRef ) 
                        throw( CORELINUX(Assertion) );

            /// Equality operator returns true 
            /// if instances are the same

            bool  operator==( RoomCref aRef ) const;

   //
   // Accessors
   //
            /// Gets the room number

            RoomNumberCref getRoomNumber( void ) const;

            /// Retrieve the MapSite object given a direction

            MapSitePtr  getSide( Direction ) const;

   //
   // Mutator
   //

            /// Sets the room number

            void  setRoomNumber( RoomNumberCref aRef );

            /// Sets a object for the given direction side

            void  setSide( Direction, MapSitePtr );

   //
   // Pure virtual definition
   //
            /**
            The one operation "enter", the meaning
            depends on the derivation, or what it
            is you are entering
            */

   virtual  void  enter( void );

protected:

private:

            /// Our walls, windows, etc.

            MapSitePtr  theSides[4];

            /// Our room number

            RoomNumber  theRoomNumber;

};


#endif // if !defined(__ROOM_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/


