#if   !defined(__HARDDRIVE_HPP)
#define  __HARDDRIVE_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__EQUIPMENT_HPP)
#include <Equipment.hpp>
#endif

/**
HardDrive is a leaf component. 
*/

DECLARE_CLASS( HardDrive );

class HardDrive : public Equipment 
{
public:

   //
   // Constructors and Destructors
   //
                  /// Always requires a name in derivations
               
                  HardDrive( NameCref );

                  /// Copy constructor

                  HardDrive( HardDriveCref );

                  /// Virtual destructor

   virtual        ~HardDrive( void );

   //
   // Operators
   //
            /// Equal if theName == theName

            bool        operator==( HardDriveCref ) const;

   //
   // Accessors
   //

            /// Return the power requirement

   virtual  Watt        getPower( void );


protected:
                        /// Default constructor not allowed

                        HardDrive( void ) 
                           throw(CORELINUX(CompositeException));


            /// Assignment operator can't overwrite name

            HardDriveRef   operator=( HardDriveCref )
                              throw(CORELINUX(CompositeException));
};

#endif // if !defined(__HARDDRIVE_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:21 $
   $Locker:  $
*/


