/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__RESTRICTEDACCOUNTPROXY_HPP)
#include <RestrictedAccountProxy.hpp>
#endif

using namespace corelinux;

//
// Default constructor
//

RestrictedAccountProxy::RestrictedAccountProxy( void )
   :
   AccountProxy()
{
   ;  // do nothing
}

//
// Initializing constructor
//

RestrictedAccountProxy::RestrictedAccountProxy( AbstractBankAccountPtr aSubject )
   :
   AccountProxy( aSubject )
{
   ;  // do nothing
}

//
// Copy constructor
//

RestrictedAccountProxy::RestrictedAccountProxy( RestrictedAccountProxyCref aProxy )
   :
   AccountProxy( aProxy )
{
   ;  // do nothing
}

//
// Destructor
//

RestrictedAccountProxy::~RestrictedAccountProxy( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

RestrictedAccountProxyRef   RestrictedAccountProxy::operator=
   ( 
      RestrictedAccountProxyCref aProxy 
   )
{
   AccountProxy::operator=( aProxy );
   return ( *this );
}

//
// Equality overload
//

bool RestrictedAccountProxy::operator==( RestrictedAccountProxyCref aProxy ) const
{
   return ( AccountProxy::operator==( aProxy ) );
}

void  RestrictedAccountProxy::withdrawFunds( Amount )
                                 throw( InsufficientFundsException )
{
   throw InsufficientFundsException
      (
         "You are not authorized to access this method!", 
         LOCATION 
      );
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/02/08 13:13:17 $
   $Locker:  $
*/

