#if   !defined(__ITERATOR_HPP)
#define  __ITERATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#include <IteratorBoundsException.hpp>

namespace   corelinux
{

   DECLARE_CLASS( IteratorBoundsException );
   DECLARE_CLASS( InvalidIteratorException );

   /**
   The Iterator provides a way to access the elements of an
   collection type sequentially without exposing its underlying
   representation. The implementation requires a template argument
   that describes the ElementType being iterated over.
   */

   template< class ElementType >
      class Iterator : public CoreLinuxObject
      {
      public:

         //
         // Constructors and destructor
         //

                     /// Default constructor

                     Iterator( void )
                        :
                        CoreLinuxObject()
                     {
                        ;  // do nothing
                     }

                     /**
                     Copy constructor
                     @param Iterator const reference
                     */

                     Iterator( const Iterator &aRef )
                        :
                        CoreLinuxObject( aRef )
                     {
                        ;  // do nothing
                     }

                     /// Destructor

         virtual     ~Iterator( void )
         {
            ;  // do nothing
         }

         //
         // Operator overloads
         //

                  /**
                  Assignment operator
                  @param Iterator const reference
                  @return Iterator reference
                  */

                  Iterator & operator=( const Iterator & )
                  {
                     return (*this);
                  }

                  /**
                  Equality operator
                  @param Iterator const reference
                  @return bool - true if instances are equal
                  */

                  bool  operator==( const Iterator & aRef ) const
                  {
                     return (this == &aRef);
                  }
                  

         //
         // Accessors
         //
                  /**
                  isValid abstract interface for implementation
                  to determine if the current position points
                  to a valid EntityType instance
                  @return bool true if valid, false otherwise
                  */

         virtual  bool  isValid( void ) const = 0;

                  /**
                  getElement returns the ElementType instance
                  that is currently pointed to by the Iterator
                  @return ElementType 
                  @exception IteratorBoundsException if the Iterator
                  is not positioned correctley.
                  */

         virtual  ElementType  getElement( void ) 
                         const throw(IteratorBoundsException) = 0;

         //
         // Mutators
         //

                  /// Set iterator to first element

         virtual  void  setFirst( void ) = 0;

                  /**
                  Set iterator to next element
                  @exception IteratorBoundsException if attempt
                  to position past end of elements
                  */

         virtual  void  setNext( void ) 
                           throw(IteratorBoundsException) = 0;

                  /**
                  Set iterator to previous element
                  @exception IteratorBoundsException if attempt
                  to position before begining of elements
                  */

         virtual  void  setPrevious( void ) 
                           throw(IteratorBoundsException) = 0;

                  /**
                  Set iterator to last element
                  @exception IteratorBoundsException if it
                  is the iterator is over an empty collection
                  */

         virtual  void  setLast( void ) 
                           throw(IteratorBoundsException) = 0;

   
      };
}

#endif   // if !defined(__ITERATOR_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/

