package org.apache.commons.openpgp;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;

/**
 * Interface describing a key ring for use in signing or verifying data.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 */
public interface KeyRing
{
    String ROLE = KeyRing.class.getName();

    /**
     * @return
     * @todo seems like the wrong place
     */
    char[] getPassword();

    /**
     * @param keyId
     * @return
     * @todo remove BC specifics
     */
    PGPSecretKey getSecretKey( String keyId );

    /**
     * @param keyId
     * @return
     * @todo remove BC specifics
     */
    PGPPublicKey getPublicKey( String keyId );

    /**
     * @param keyId
     * @return
     * @todo remove BC specifics
     */
    PGPSecretKey getSecretKey( long keyId );

    /**
     * @param keyId
     * @return
     * @todo remove BC specifics
     */
    PGPPublicKey getPublicKey( long keyId );
}
