/* WARNING: auto-generated (by autogen/test); do not edit */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <assert.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <sys/resource.h>
#include "crypto_uint8.h"
#include "crypto_uint32.h"
#include "crypto_uint64.h"
#include "lib25519.h" /* -l25519 */
#include "randombytes.h"

static const char *targeto = 0;
static const char *targetp = 0;
static const char *targeti = 0;

static int ok = 1;

#define fail ((ok = 0),printf)

/* ----- kernelrandombytes */

static int kernelrandombytes_fd = -1;

static void kernelrandombytes_setup(void)
{
  kernelrandombytes_fd = open("/dev/urandom",O_RDONLY);
  if (kernelrandombytes_fd == -1) {
    fprintf(stderr,"lib25519-test: fatal: unable to open /dev/urandom: %s",strerror(errno));
    exit(111);
  }
}

static void kernelrandombytes(unsigned char *x,long long xlen)
{
  int i;

  while (xlen > 0) {
    if (xlen < 1048576) i = xlen; else i = 1048576;

    i = read(kernelrandombytes_fd,x,i);
    if (i < 1) {
      sleep(1);
      continue;
    }

    x += i;
    xlen -= i;
  }
}

/* ----- rng and hash, from supercop/try-anything.c */

typedef crypto_uint8 u8;
typedef crypto_uint32 u32;
typedef crypto_uint64 u64;

#define FOR(i,n) for (i = 0;i < n;++i)

static u32 L32(u32 x,int c) { return (x << c) | ((x&0xffffffff) >> (32 - c)); }

static u32 ld32(const u8 *x)
{
  u32 u = x[3];
  u = (u<<8)|x[2];
  u = (u<<8)|x[1];
  return (u<<8)|x[0];
}

static void st32(u8 *x,u32 u)
{
  int i;
  FOR(i,4) { x[i] = u; u >>= 8; }
}

static const u8 sigma[17] = "expand 32-byte k";

static void core_salsa(u8 *out,const u8 *in,const u8 *k)
{
  u32 w[16],x[16],y[16],t[4];
  int i,j,m;

  FOR(i,4) {
    x[5*i] = ld32(sigma+4*i);
    x[1+i] = ld32(k+4*i);
    x[6+i] = ld32(in+4*i);
    x[11+i] = ld32(k+16+4*i);
  }

  FOR(i,16) y[i] = x[i];

  FOR(i,20) {
    FOR(j,4) {
      FOR(m,4) t[m] = x[(5*j+4*m)%16];
      t[1] ^= L32(t[0]+t[3], 7);
      t[2] ^= L32(t[1]+t[0], 9);
      t[3] ^= L32(t[2]+t[1],13);
      t[0] ^= L32(t[3]+t[2],18);
      FOR(m,4) w[4*j+(j+m)%4] = t[m];
    }
    FOR(m,16) x[m] = w[m];
  }

  FOR(i,16) st32(out + 4 * i,x[i] + y[i]);
}

static void salsa20(u8 *c,u64 b,const u8 *n,const u8 *k)
{
  u8 z[16],x[64];
  u32 u,i;
  if (!b) return;
  FOR(i,16) z[i] = 0;
  FOR(i,8) z[i] = n[i];
  while (b >= 64) {
    core_salsa(x,z,k);
    FOR(i,64) c[i] = x[i];
    u = 1;
    for (i = 8;i < 16;++i) {
      u += (u32) z[i];
      z[i] = u;
      u >>= 8;
    }
    b -= 64;
    c += 64;
  }
  if (b) {
    core_salsa(x,z,k);
    FOR(i,b) c[i] = x[i];
  }
}

static void increment(u8 *n)
{
  if (!++n[0])
    if (!++n[1])
      if (!++n[2])
        if (!++n[3])
          if (!++n[4])
            if (!++n[5])
              if (!++n[6])
                if (!++n[7])
                  ;
}

static unsigned char testvector_n[8];

static void testvector_clear(void)
{
  memset(testvector_n,0,sizeof testvector_n);
}

static void testvector(unsigned char *x,unsigned long long xlen)
{
  const static unsigned char testvector_k[33] = "generate inputs for test vectors";
  salsa20(x,xlen,testvector_n,testvector_k);
  increment(testvector_n);
}

static unsigned long long myrandom(void)
{
  unsigned char x[8];
  unsigned long long result;
  testvector(x,8);
  result = x[7];
  result = (result<<8)|x[6];
  result = (result<<8)|x[5];
  result = (result<<8)|x[4];
  result = (result<<8)|x[3];
  result = (result<<8)|x[2];
  result = (result<<8)|x[1];
  result = (result<<8)|x[0];
  return result;
}

static unsigned char canary_n[8];

static void canary(unsigned char *x,unsigned long long xlen)
{
  const static unsigned char canary_k[33] = "generate pad to catch overwrites";
  salsa20(x,xlen,canary_n,canary_k);
  increment(canary_n);
}

static void double_canary(unsigned char *x2,unsigned char *x,unsigned long long xlen)
{
  canary(x - 16,16);
  canary(x + xlen,16);
  memcpy(x2 - 16,x - 16,16);
  memcpy(x2 + xlen,x + xlen,16);
}

static void input_prepare(unsigned char *x2,unsigned char *x,unsigned long long xlen)
{
  testvector(x,xlen);
  canary(x - 16,16);
  canary(x + xlen,16);
  memcpy(x2 - 16,x - 16,xlen + 32);
}

static void input_compare(const unsigned char *x2,const unsigned char *x,unsigned long long xlen,const char *fun)
{
  if (memcmp(x2 - 16,x - 16,xlen + 32)) {
    fail("failure: %s overwrites input\n",fun);
  }
}

static void output_prepare(unsigned char *x2,unsigned char *x,unsigned long long xlen)
{
  canary(x - 16,xlen + 32);
  memcpy(x2 - 16,x - 16,xlen + 32);
}

static void output_compare(const unsigned char *x2,const unsigned char *x,unsigned long long xlen,const char *fun)
{
  if (memcmp(x2 - 16,x - 16,16)) {
    fail("failure: %s writes before output\n",fun);
  }
  if (memcmp(x2 + xlen,x + xlen,16)) {
    fail("failure: %s writes after output\n",fun);
  }
}

/* ----- knownrandombytes */

static const int knownrandombytes_is_only_for_testing_not_for_cryptographic_use = 1;
#define knownrandombytes randombytes

#define QUARTERROUND(a,b,c,d) \
  a += b; d = L32(d^a,16); \
  c += d; b = L32(b^c,12); \
  a += b; d = L32(d^a, 8); \
  c += d; b = L32(b^c, 7);

static void core_chacha(u8 *out,const u8 *in,const u8 *k)
{
  u32 x[16],y[16];
  int i,j;
  FOR(i,4) {
    x[i] = ld32(sigma+4*i);
    x[12+i] = ld32(in+4*i);
  }
  FOR(i,8) x[4+i] = ld32(k+4*i);
  FOR(i,16) y[i] = x[i];
  FOR(i,10) {
    FOR(j,4) { QUARTERROUND(x[j],x[j+4],x[j+8],x[j+12]) }
    FOR(j,4) { QUARTERROUND(x[j],x[((j+1)&3)+4],x[((j+2)&3)+8],x[((j+3)&3)+12]) }
  }
  FOR(i,16) st32(out+4*i,x[i]+y[i]);
}

static void chacha20(u8 *c,u64 b,const u8 *n,const u8 *k)
{
  u8 z[16],x[64];
  u32 u,i;
  if (!b) return;
  FOR(i,16) z[i] = 0;
  FOR(i,8) z[i+8] = n[i];
  while (b >= 64) {
    core_chacha(x,z,k);
    FOR(i,64) c[i] = x[i];
    u = 1;
    FOR(i,8) {
      u += (u32) z[i];
      z[i] = u;
      u >>= 8;
    }
    b -= 64;
    c += 64;
  }
  if (b) {
    core_chacha(x,z,k);
    FOR(i,b) c[i] = x[i];
  }
}

#define crypto_rng_OUTPUTBYTES 736

static int crypto_rng(
        unsigned char *r, /* random output */
        unsigned char *n, /* new key */
  const unsigned char *g  /* old key */
)
{
  static const unsigned char nonce[8] = {0};
  unsigned char x[32+crypto_rng_OUTPUTBYTES];
  chacha20(x,sizeof x,nonce,g);
  memcpy(n,x,32);
  memcpy(r,x+32,crypto_rng_OUTPUTBYTES);
  return 0;
}

static unsigned char knownrandombytes_g[32];
static unsigned char knownrandombytes_r[crypto_rng_OUTPUTBYTES];
static unsigned long long knownrandombytes_pos = crypto_rng_OUTPUTBYTES;

static void knownrandombytes_clear(void)
{
  memset(knownrandombytes_g,0,sizeof knownrandombytes_g);
  memset(knownrandombytes_r,0,sizeof knownrandombytes_r);
  knownrandombytes_pos = crypto_rng_OUTPUTBYTES;
}

void knownrandombytes(void *xvoid,long long xlen)
{
  unsigned char *x = xvoid;
  assert(knownrandombytes_is_only_for_testing_not_for_cryptographic_use);

  while (xlen > 0) {
    if (knownrandombytes_pos == crypto_rng_OUTPUTBYTES) {
      crypto_rng(knownrandombytes_r,knownrandombytes_g,knownrandombytes_g);
      knownrandombytes_pos = 0;
    }
    *x++ = knownrandombytes_r[knownrandombytes_pos]; xlen -= 1;
    knownrandombytes_r[knownrandombytes_pos++] = 0;
  }
}

/* ----- checksums */

static unsigned char checksum_state[64];
static char checksum_hex[65];

static void checksum_expected(const char *expected)
{
  long long i;
  for (i = 0;i < 32;++i) {
    checksum_hex[2 * i] = "0123456789abcdef"[15 & (checksum_state[i] >> 4)];
    checksum_hex[2 * i + 1] = "0123456789abcdef"[15 & checksum_state[i]];
  }
  checksum_hex[2 * i] = 0;

  if (strcmp(checksum_hex,expected))
    fail("failure: checksum mismatch: %s expected %s\n",checksum_hex,expected);
}

static void checksum_clear(void)
{
  memset(checksum_state,0,sizeof checksum_state);
  knownrandombytes_clear();
  testvector_clear();
  /* not necessary to clear canary */
}

static void checksum(const unsigned char *x,unsigned long long xlen)
{
  u8 block[16];
  int i;
  while (xlen >= 16) {
    core_salsa(checksum_state,x,checksum_state);
    x += 16;
    xlen -= 16;
  }
  FOR(i,16) block[i] = 0;
  FOR(i,xlen) block[i] = x[i];
  block[xlen] = 1;
  checksum_state[0] ^= 1;
  core_salsa(checksum_state,block,checksum_state);
}

#include "limits.inc"

static unsigned char *alignedcalloc(unsigned long long len)
{
  unsigned char *x = (unsigned char *) calloc(1,len + 256);
  long long i;
  if (!x) abort();
  /* will never deallocate so shifting is ok */
  for (i = 0;i < len + 256;++i) x[i] = random();
  x += 64;
  x += 63 & (-(unsigned long) x);
  for (i = 0;i < len;++i) x[i] = 0;
  return x;
}

/* ----- catching SIGILL, SIGBUS, SIGSEGV, etc. */

static void forked(void (*test)(long long),long long impl)
{
  fflush(stdout);
  pid_t child = fork();
  int childstatus = -1;
  if (child == -1) {
    fprintf(stderr,"fatal: fork failed: %s",strerror(errno));
    exit(111);
  }
  if (child == 0) {
    ok = 1;
    limits();
    test(impl);
    if (!ok) exit(100);
    exit(0);
  }
  if (waitpid(child,&childstatus,0) != child) {
    fprintf(stderr,"fatal: wait failed: %s",strerror(errno));
    exit(111);
  }
  if (childstatus)
    fail("failure: process failed, status %d\n",childstatus);
  fflush(stdout);
}

/* ----- verify, derived from supercop/crypto_verify/try.c */

static int (*crypto_verify)(const unsigned char *,const unsigned char *);
#define crypto_verify_BYTES lib25519_verify_BYTES

static unsigned char *test_verify_x;
static unsigned char *test_verify_y;

static void test_verify_check(void)
{
  unsigned char *x = test_verify_x;
  unsigned char *y = test_verify_y;
  int r = crypto_verify(x,y);

  if (r == 0) {
    if (memcmp(x,y,crypto_verify_BYTES))
      fail("failure: different strings pass verify\n");
  } else if (r == -1) {
    if (!memcmp(x,y,crypto_verify_BYTES))
      fail("failure: equal strings fail verify\n");
  } else {
    fail("failure: weird return value\n");
  }
}

void test_verify_impl(long long impl)
{
  unsigned char *x = test_verify_x;
  unsigned char *y = test_verify_y;

  if (targeti && strcmp(targeti,lib25519_dispatch_verify_implementation(impl))) return;
  if (impl >= 0) {
    crypto_verify = lib25519_dispatch_verify(impl);
    printf("verify %lld implementation %s compiler %s\n",impl,lib25519_dispatch_verify_implementation(impl),lib25519_dispatch_verify_compiler(impl));
  } else {
    crypto_verify = lib25519_verify;
    printf("verify selected implementation %s compiler %s\n",lib25519_verify_implementation(),lib25519_verify_compiler());
  }

  kernelrandombytes(x,crypto_verify_BYTES);
  kernelrandombytes(y,crypto_verify_BYTES);
  test_verify_check();
  memcpy(y,x,crypto_verify_BYTES);
  test_verify_check();
  y[myrandom() % crypto_verify_BYTES] = myrandom();
  test_verify_check();
  y[myrandom() % crypto_verify_BYTES] = myrandom();
  test_verify_check();
  y[myrandom() % crypto_verify_BYTES] = myrandom();
  test_verify_check();
}

static void test_verify(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"32")) return;

  test_verify_x = alignedcalloc(crypto_verify_BYTES);
  test_verify_y = alignedcalloc(crypto_verify_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("verify offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_verify();++impl)
      forked(test_verify_impl,impl);
    ++test_verify_x;
    ++test_verify_y;
  }
}

/* ----- hashblocks, derived from supercop/crypto_hashblocks/try.c */
static const char *hashblocks_sha512_checksums[] = {
  "f0bc623a9033f9f648336540e11e85be21aeb60905c7d8808d10ea20b39d58d1",
  "f1a2c46c9ce7fa4cd22f180907d77b6f7189badef4b9a1b5284d6fb9db859b76",
} ;

static int (*crypto_hashblocks)(unsigned char *,const unsigned char *,long long);
#define crypto_hashblocks_STATEBYTES lib25519_hashblocks_sha512_STATEBYTES
#define crypto_hashblocks_BLOCKBYTES lib25519_hashblocks_sha512_BLOCKBYTES

static unsigned char *test_hashblocks_sha512_h;
static unsigned char *test_hashblocks_sha512_m;
static unsigned char *test_hashblocks_sha512_h2;
static unsigned char *test_hashblocks_sha512_m2;

static void test_hashblocks_sha512_impl(long long impl)
{
  unsigned char *h = test_hashblocks_sha512_h;
  unsigned char *m = test_hashblocks_sha512_m;
  unsigned char *h2 = test_hashblocks_sha512_h2;
  unsigned char *m2 = test_hashblocks_sha512_m2;
  long long hlen = crypto_hashblocks_STATEBYTES;
  long long mlen;

  if (targeti && strcmp(targeti,lib25519_dispatch_hashblocks_sha512_implementation(impl))) return;
  if (impl >= 0) {
    crypto_hashblocks = lib25519_dispatch_hashblocks_sha512(impl);
    printf("hashblocks_sha512 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_hashblocks_sha512_implementation(impl),lib25519_dispatch_hashblocks_sha512_compiler(impl));
  } else {
    crypto_hashblocks = lib25519_hashblocks_sha512;
    printf("hashblocks_sha512 selected implementation %s compiler %s\n",lib25519_hashblocks_sha512_implementation(),lib25519_hashblocks_sha512_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 32768 : 4096;
    long long maxtest = checksumbig ? 4096 : 128;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      int result;
      mlen = myrandom() % (maxtest + 1);

      input_prepare(m2,m,mlen);
      input_prepare(h2,h,hlen);
      result = crypto_hashblocks(h,m,mlen);
      if (result != mlen % crypto_hashblocks_BLOCKBYTES) fail("failure: crypto_hashblocks returns unexpected value\n");
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_hashblocks");
      input_compare(m2,m,mlen,"crypto_hashblocks");

      double_canary(h2,h,hlen);
      double_canary(m2,m,mlen);
      result = crypto_hashblocks(h2,m2,mlen);
      if (result != mlen % crypto_hashblocks_BLOCKBYTES) fail("failure: crypto_hashblocks returns unexpected value\n");
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_hashblocks is nondeterministic\n");
    }
    checksum_expected(hashblocks_sha512_checksums[checksumbig]);
  }
}

static void test_hashblocks_sha512(void)
{
  if (targeto && strcmp(targeto,"hashblocks")) return;
  if (targetp && strcmp(targetp,"sha512")) return;
  test_hashblocks_sha512_h = alignedcalloc(crypto_hashblocks_STATEBYTES);
  test_hashblocks_sha512_m = alignedcalloc(4096);
  test_hashblocks_sha512_h2 = alignedcalloc(crypto_hashblocks_STATEBYTES);
  test_hashblocks_sha512_m2 = alignedcalloc(4096);

  for (long long offset = 0;offset < 2;++offset) {
    printf("hashblocks_sha512 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_hashblocks_sha512();++impl)
      forked(test_hashblocks_sha512_impl,impl);
    ++test_hashblocks_sha512_h;
    ++test_hashblocks_sha512_m;
    ++test_hashblocks_sha512_h2;
    ++test_hashblocks_sha512_m2;
  }
}
#undef crypto_hashblocks_STATEBYTES
#undef crypto_hashblocks_BLOCKBYTES


/* ----- hash, derived from supercop/crypto_hash/try.c */
static const char *hash_sha512_checksums[] = {
  "8220572f58bd4730be165c9739d8d4b0fd2e0229dbe01e25b4aed23f00f23b70",
  "c1e322b7cbfc941260c5508967ba05bce22eeee94d425e708b7c3301ea1d5e2e",
} ;

static void (*crypto_hash)(unsigned char *,const unsigned char *,long long);
#define crypto_hash_BYTES lib25519_hash_sha512_BYTES

static unsigned char *test_hash_sha512_h;
static unsigned char *test_hash_sha512_m;
static unsigned char *test_hash_sha512_h2;
static unsigned char *test_hash_sha512_m2;

static void test_hash_sha512_impl(long long impl)
{
  unsigned char *h = test_hash_sha512_h;
  unsigned char *m = test_hash_sha512_m;
  unsigned char *h2 = test_hash_sha512_h2;
  unsigned char *m2 = test_hash_sha512_m2;
  long long hlen = crypto_hash_BYTES;
  long long mlen;

  if (targeti && strcmp(targeti,lib25519_dispatch_hash_sha512_implementation(impl))) return;
  if (impl >= 0) {
    crypto_hash = lib25519_dispatch_hash_sha512(impl);
    printf("hash_sha512 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_hash_sha512_implementation(impl),lib25519_dispatch_hash_sha512_compiler(impl));
  } else {
    crypto_hash = lib25519_hash_sha512;
    printf("hash_sha512 selected implementation %s compiler %s\n",lib25519_hash_sha512_implementation(),lib25519_hash_sha512_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;
    long long maxtest = checksumbig ? 4096 : 128;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      output_prepare(h2,h,hlen);
      input_prepare(m2,m,mlen);
      crypto_hash(h,m,mlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_hash");
      input_compare(m2,m,mlen,"crypto_hash");

      double_canary(h2,h,hlen);
      double_canary(m2,m,mlen);
      crypto_hash(h2,m2,mlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_hash is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(m2,m,mlen);
      crypto_hash(m2,m2,mlen);
      if (memcmp(m2,h,hlen) != 0) fail("failure: crypto_hash does not handle m=h overlap\n");
      memcpy(m2,m,mlen);
    }
    checksum_expected(hash_sha512_checksums[checksumbig]);
  }
}

static void test_hash_sha512(void)
{
  if (targeto && strcmp(targeto,"hash")) return;
  if (targetp && strcmp(targetp,"sha512")) return;
  test_hash_sha512_h = alignedcalloc(crypto_hash_BYTES);
  test_hash_sha512_m = alignedcalloc(4096+crypto_hash_BYTES);
  test_hash_sha512_h2 = alignedcalloc(crypto_hash_BYTES);
  test_hash_sha512_m2 = alignedcalloc(4096+crypto_hash_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("hash_sha512 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_hash_sha512();++impl)
      forked(test_hash_sha512_impl,impl);
    ++test_hash_sha512_h;
    ++test_hash_sha512_m;
    ++test_hash_sha512_h2;
    ++test_hash_sha512_m2;
  }
}
#undef crypto_hash_BYTES


/* ----- pow, derived from supercop/crypto_pow/try.c */
static const char *pow_inv25519_checksums[] = {
  "ad2062946e82718da820226504991a85c5fe56bdbff959c1313f837ee13b37be",
  "59b3045a01e1fca2a86a0280aee8b985c5e040afdc0d3e85ed87eb97a46a4dd6",
} ;

static void (*crypto_pow)(unsigned char *,const unsigned char *);
#define crypto_pow_BYTES lib25519_pow_inv25519_BYTES

static unsigned char *test_pow_inv25519_q;
static unsigned char *test_pow_inv25519_p;
static unsigned char *test_pow_inv25519_q2;
static unsigned char *test_pow_inv25519_p2;

#define precomputed_pow_inv25519_NUM 296

static const unsigned char precomputed_pow_inv25519_q_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_2[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_2[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_3[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_3[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_4[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_4[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_5[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_5[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_6[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_6[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_7[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_7[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_8[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_8[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_9[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_9[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_10[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_10[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_11[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_11[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_12[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_12[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_13[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_13[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_14[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_14[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_15[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_15[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_16[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_16[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_17[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_17[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_18[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_18[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_19[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47};
static const unsigned char precomputed_pow_inv25519_p_19[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_20[] = {92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70};
static const unsigned char precomputed_pow_inv25519_p_20[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_21[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_pow_inv25519_p_21[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_22[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_pow_inv25519_p_22[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_23[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_pow_inv25519_p_23[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_24[] = {162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_pow_inv25519_p_24[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_25[] = {30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5};
static const unsigned char precomputed_pow_inv25519_p_25[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_26[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_pow_inv25519_p_26[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_27[] = {6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_pow_inv25519_p_27[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_28[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_pow_inv25519_p_28[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_29[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_pow_inv25519_p_29[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_30[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_pow_inv25519_p_30[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_31[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_pow_inv25519_p_31[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_32[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_pow_inv25519_p_32[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_pow_inv25519_q_33[] = {38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127};
static const unsigned char precomputed_pow_inv25519_p_33[] = {93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3};
static const unsigned char precomputed_pow_inv25519_q_34[] = {31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37};
static const unsigned char precomputed_pow_inv25519_p_34[] = {129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5};
static const unsigned char precomputed_pow_inv25519_q_35[] = {19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73};
static const unsigned char precomputed_pow_inv25519_p_35[] = {38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5};
static const unsigned char precomputed_pow_inv25519_q_36[] = {166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7};
static const unsigned char precomputed_pow_inv25519_p_36[] = {241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6};
static const unsigned char precomputed_pow_inv25519_q_37[] = {64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76};
static const unsigned char precomputed_pow_inv25519_p_37[] = {18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7};
static const unsigned char precomputed_pow_inv25519_q_38[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102};
static const unsigned char precomputed_pow_inv25519_p_38[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8};
static const unsigned char precomputed_pow_inv25519_q_39[] = {79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104};
static const unsigned char precomputed_pow_inv25519_p_39[] = {147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14};
static const unsigned char precomputed_pow_inv25519_q_40[] = {185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122};
static const unsigned char precomputed_pow_inv25519_p_40[] = {89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14};
static const unsigned char precomputed_pow_inv25519_q_41[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1};
static const unsigned char precomputed_pow_inv25519_p_41[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16};
static const unsigned char precomputed_pow_inv25519_q_42[] = {8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_pow_inv25519_p_42[] = {226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_pow_inv25519_q_43[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46};
static const unsigned char precomputed_pow_inv25519_p_43[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16};
static const unsigned char precomputed_pow_inv25519_q_44[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_pow_inv25519_p_44[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_pow_inv25519_q_45[] = {57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57};
static const unsigned char precomputed_pow_inv25519_p_45[] = {147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26};
static const unsigned char precomputed_pow_inv25519_q_46[] = {123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125};
static const unsigned char precomputed_pow_inv25519_p_46[] = {74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28};
static const unsigned char precomputed_pow_inv25519_q_47[] = {86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43};
static const unsigned char precomputed_pow_inv25519_p_47[] = {160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30};
static const unsigned char precomputed_pow_inv25519_q_48[] = {222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28};
static const unsigned char precomputed_pow_inv25519_p_48[] = {102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30};
static const unsigned char precomputed_pow_inv25519_q_49[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_pow_inv25519_p_49[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_pow_inv25519_q_50[] = {137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69};
static const unsigned char precomputed_pow_inv25519_p_50[] = {222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36};
static const unsigned char precomputed_pow_inv25519_q_51[] = {163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49};
static const unsigned char precomputed_pow_inv25519_p_51[] = {71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40};
static const unsigned char precomputed_pow_inv25519_q_52[] = {56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8};
static const unsigned char precomputed_pow_inv25519_p_52[] = {99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41};
static const unsigned char precomputed_pow_inv25519_q_53[] = {223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22};
static const unsigned char precomputed_pow_inv25519_p_53[] = {147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44};
static const unsigned char precomputed_pow_inv25519_q_54[] = {101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32};
static const unsigned char precomputed_pow_inv25519_p_54[] = {182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50};
static const unsigned char precomputed_pow_inv25519_q_55[] = {60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44};
static const unsigned char precomputed_pow_inv25519_p_55[] = {114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51};
static const unsigned char precomputed_pow_inv25519_q_56[] = {120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41};
static const unsigned char precomputed_pow_inv25519_p_56[] = {129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52};
static const unsigned char precomputed_pow_inv25519_q_57[] = {26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102};
static const unsigned char precomputed_pow_inv25519_p_57[] = {14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52};
static const unsigned char precomputed_pow_inv25519_q_58[] = {87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123};
static const unsigned char precomputed_pow_inv25519_p_58[] = {97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53};
static const unsigned char precomputed_pow_inv25519_q_59[] = {247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120};
static const unsigned char precomputed_pow_inv25519_p_59[] = {80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53};
static const unsigned char precomputed_pow_inv25519_q_60[] = {25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67};
static const unsigned char precomputed_pow_inv25519_p_60[] = {15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54};
static const unsigned char precomputed_pow_inv25519_q_61[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26};
static const unsigned char precomputed_pow_inv25519_p_61[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55};
static const unsigned char precomputed_pow_inv25519_q_62[] = {44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46};
static const unsigned char precomputed_pow_inv25519_p_62[] = {33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56};
static const unsigned char precomputed_pow_inv25519_q_63[] = {246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37};
static const unsigned char precomputed_pow_inv25519_p_63[] = {82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58};
static const unsigned char precomputed_pow_inv25519_q_64[] = {233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14};
static const unsigned char precomputed_pow_inv25519_p_64[] = {78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61};
static const unsigned char precomputed_pow_inv25519_q_65[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66};
static const unsigned char precomputed_pow_inv25519_p_65[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67};
static const unsigned char precomputed_pow_inv25519_q_66[] = {113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61};
static const unsigned char precomputed_pow_inv25519_p_66[] = {6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67};
static const unsigned char precomputed_pow_inv25519_q_67[] = {171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89};
static const unsigned char precomputed_pow_inv25519_p_67[] = {247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70};
static const unsigned char precomputed_pow_inv25519_q_68[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40};
static const unsigned char precomputed_pow_inv25519_p_68[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74};
static const unsigned char precomputed_pow_inv25519_q_69[] = {226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60};
static const unsigned char precomputed_pow_inv25519_p_69[] = {146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76};
static const unsigned char precomputed_pow_inv25519_q_70[] = {24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8};
static const unsigned char precomputed_pow_inv25519_p_70[] = {210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79};
static const unsigned char precomputed_pow_inv25519_q_71[] = {124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87};
static const unsigned char precomputed_pow_inv25519_p_71[] = {255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80};
static const unsigned char precomputed_pow_inv25519_q_72[] = {198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115};
static const unsigned char precomputed_pow_inv25519_p_72[] = {139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81};
static const unsigned char precomputed_pow_inv25519_q_73[] = {58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119};
static const unsigned char precomputed_pow_inv25519_p_73[] = {47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86};
static const unsigned char precomputed_pow_inv25519_q_74[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_pow_inv25519_p_74[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_pow_inv25519_q_75[] = {240,44,29,72,44,33,188,97,152,219,129,79,124,138,167,64,144,200,229,60,6,3,242,73,196,157,70,161,25,6,89,17};
static const unsigned char precomputed_pow_inv25519_p_75[] = {111,10,86,115,2,46,170,54,148,52,250,47,50,56,43,7,216,138,19,111,126,8,39,124,220,10,24,40,198,115,160,92};
static const unsigned char precomputed_pow_inv25519_q_76[] = {36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123};
static const unsigned char precomputed_pow_inv25519_p_76[] = {170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95};
static const unsigned char precomputed_pow_inv25519_q_77[] = {98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10};
static const unsigned char precomputed_pow_inv25519_p_77[] = {187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96};
static const unsigned char precomputed_pow_inv25519_q_78[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28};
static const unsigned char precomputed_pow_inv25519_p_78[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102};
static const unsigned char precomputed_pow_inv25519_q_79[] = {145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_pow_inv25519_p_79[] = {125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_pow_inv25519_q_80[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21};
static const unsigned char precomputed_pow_inv25519_p_80[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108};
static const unsigned char precomputed_pow_inv25519_q_81[] = {203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_pow_inv25519_p_81[] = {125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_pow_inv25519_q_82[] = {250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13};
static const unsigned char precomputed_pow_inv25519_p_82[] = {218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119};
static const unsigned char precomputed_pow_inv25519_q_83[] = {139,217,27,238,113,28,242,233,76,16,196,238,215,96,153,61,0,64,134,198,20,205,154,208,84,164,135,54,153,95,4,126};
static const unsigned char precomputed_pow_inv25519_p_83[] = {189,68,80,58,53,159,69,72,96,63,22,164,219,217,177,104,30,162,150,170,40,227,107,49,103,70,18,244,141,182,4,120};
static const unsigned char precomputed_pow_inv25519_q_84[] = {50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96};
static const unsigned char precomputed_pow_inv25519_p_84[] = {141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120};
static const unsigned char precomputed_pow_inv25519_q_85[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20};
static const unsigned char precomputed_pow_inv25519_p_85[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121};
static const unsigned char precomputed_pow_inv25519_q_86[] = {218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54};
static const unsigned char precomputed_pow_inv25519_p_86[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_pow_inv25519_q_87[] = {230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103};
static const unsigned char precomputed_pow_inv25519_p_87[] = {16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123};
static const unsigned char precomputed_pow_inv25519_q_88[] = {19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49};
static const unsigned char precomputed_pow_inv25519_p_88[] = {5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124};
static const unsigned char precomputed_pow_inv25519_q_89[] = {148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44};
static const unsigned char precomputed_pow_inv25519_p_89[] = {174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127};
static const unsigned char precomputed_pow_inv25519_q_90[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68};
static const unsigned char precomputed_pow_inv25519_p_90[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_91[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_pow_inv25519_p_91[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_92[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69};
static const unsigned char precomputed_pow_inv25519_p_92[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_93[] = {34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_pow_inv25519_p_93[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_94[] = {219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_pow_inv25519_p_94[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_95[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_pow_inv25519_p_95[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_96[] = {96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_pow_inv25519_p_96[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_97[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21};
static const unsigned char precomputed_pow_inv25519_p_97[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_98[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_pow_inv25519_p_98[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_99[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31};
static const unsigned char precomputed_pow_inv25519_p_99[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_100[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_pow_inv25519_p_100[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_101[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_101[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_102[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_p_102[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_103[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_103[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_104[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_104[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_105[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_105[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_106[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_106[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_107[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_107[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_108[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_108[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_109[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_109[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_110[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_110[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_111[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_111[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_112[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_112[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_113[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_113[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_114[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_114[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_115[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_115[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_116[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_116[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_117[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_117[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_118[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_118[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_119[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_119[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_120[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_120[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_121[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_121[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_122[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_122[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_123[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_123[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_124[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_124[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_125[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_125[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_126[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_126[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_127[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_127[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_128[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_128[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_129[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_129[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_130[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_130[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_131[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_131[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_132[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_132[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_133[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_133[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_134[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_134[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_135[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_135[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_136[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_136[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_137[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_137[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_138[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_138[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_139[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_139[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_140[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_140[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_141[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47};
static const unsigned char precomputed_pow_inv25519_p_141[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_142[] = {92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70};
static const unsigned char precomputed_pow_inv25519_p_142[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_143[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_pow_inv25519_p_143[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_144[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_pow_inv25519_p_144[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_145[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_pow_inv25519_p_145[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_146[] = {162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_pow_inv25519_p_146[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_147[] = {30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5};
static const unsigned char precomputed_pow_inv25519_p_147[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_148[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_pow_inv25519_p_148[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_149[] = {6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_pow_inv25519_p_149[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_150[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_pow_inv25519_p_150[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_151[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_pow_inv25519_p_151[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_152[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_pow_inv25519_p_152[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_153[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_pow_inv25519_p_153[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_154[] = {255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103};
static const unsigned char precomputed_pow_inv25519_p_154[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_pow_inv25519_q_155[] = {119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41};
static const unsigned char precomputed_pow_inv25519_p_155[] = {160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129};
static const unsigned char precomputed_pow_inv25519_q_156[] = {1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0};
static const unsigned char precomputed_pow_inv25519_p_156[] = {126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132};
static const unsigned char precomputed_pow_inv25519_q_157[] = {99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85};
static const unsigned char precomputed_pow_inv25519_p_157[] = {214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133};
static const unsigned char precomputed_pow_inv25519_q_158[] = {249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_pow_inv25519_p_158[] = {19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_pow_inv25519_q_159[] = {184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43};
static const unsigned char precomputed_pow_inv25519_p_159[] = {62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136};
static const unsigned char precomputed_pow_inv25519_q_160[] = {183,19,131,62,107,60,139,25,159,81,252,127,241,150,167,10,86,224,76,177,199,197,197,80,104,31,181,26,122,42,200,107};
static const unsigned char precomputed_pow_inv25519_p_160[] = {81,108,252,226,91,123,2,58,201,115,182,53,216,106,226,19,255,189,15,42,27,210,228,103,255,63,80,6,101,105,24,137};
static const unsigned char precomputed_pow_inv25519_q_161[] = {239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1};
static const unsigned char precomputed_pow_inv25519_p_161[] = {110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142};
static const unsigned char precomputed_pow_inv25519_q_162[] = {61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93};
static const unsigned char precomputed_pow_inv25519_p_162[] = {223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143};
static const unsigned char precomputed_pow_inv25519_q_163[] = {220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_pow_inv25519_p_163[] = {27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_pow_inv25519_q_164[] = {99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125};
static const unsigned char precomputed_pow_inv25519_p_164[] = {28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146};
static const unsigned char precomputed_pow_inv25519_q_165[] = {200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11};
static const unsigned char precomputed_pow_inv25519_p_165[] = {158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151};
static const unsigned char precomputed_pow_inv25519_q_166[] = {27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51};
static const unsigned char precomputed_pow_inv25519_p_166[] = {250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151};
static const unsigned char precomputed_pow_inv25519_q_167[] = {186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83};
static const unsigned char precomputed_pow_inv25519_p_167[] = {54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152};
static const unsigned char precomputed_pow_inv25519_q_168[] = {177,22,78,2,251,64,132,103,11,6,223,232,100,240,122,253,31,213,144,42,88,64,152,99,119,1,85,61,153,42,246,28};
static const unsigned char precomputed_pow_inv25519_p_168[] = {149,177,114,234,252,75,142,235,123,59,172,102,243,44,203,193,27,157,41,154,123,24,157,151,153,191,27,29,59,251,18,154};
static const unsigned char precomputed_pow_inv25519_q_169[] = {87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21};
static const unsigned char precomputed_pow_inv25519_p_169[] = {102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155};
static const unsigned char precomputed_pow_inv25519_q_170[] = {26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12};
static const unsigned char precomputed_pow_inv25519_p_170[] = {67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157};
static const unsigned char precomputed_pow_inv25519_q_171[] = {10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37};
static const unsigned char precomputed_pow_inv25519_p_171[] = {66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161};
static const unsigned char precomputed_pow_inv25519_q_172[] = {124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_pow_inv25519_p_172[] = {214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_pow_inv25519_q_173[] = {1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84};
static const unsigned char precomputed_pow_inv25519_p_173[] = {183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169};
static const unsigned char precomputed_pow_inv25519_q_174[] = {25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77};
static const unsigned char precomputed_pow_inv25519_p_174[] = {192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169};
static const unsigned char precomputed_pow_inv25519_q_175[] = {225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112};
static const unsigned char precomputed_pow_inv25519_p_175[] = {57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171};
static const unsigned char precomputed_pow_inv25519_q_176[] = {48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_pow_inv25519_p_176[] = {34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_pow_inv25519_q_177[] = {218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13};
static const unsigned char precomputed_pow_inv25519_p_177[] = {86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173};
static const unsigned char precomputed_pow_inv25519_q_178[] = {170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30};
static const unsigned char precomputed_pow_inv25519_p_178[] = {91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174};
static const unsigned char precomputed_pow_inv25519_q_179[] = {16,203,185,193,38,83,190,92,116,115,246,106,35,158,198,3,90,188,79,129,38,19,63,45,251,135,198,66,86,155,225,121};
static const unsigned char precomputed_pow_inv25519_p_179[] = {151,141,223,224,103,64,134,109,9,122,230,95,229,166,153,94,19,16,90,73,179,141,203,36,65,81,227,10,205,31,125,174};
static const unsigned char precomputed_pow_inv25519_q_180[] = {209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120};
static const unsigned char precomputed_pow_inv25519_p_180[] = {113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176};
static const unsigned char precomputed_pow_inv25519_q_181[] = {44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111};
static const unsigned char precomputed_pow_inv25519_p_181[] = {56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177};
static const unsigned char precomputed_pow_inv25519_q_182[] = {44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_pow_inv25519_p_182[] = {135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_pow_inv25519_q_183[] = {65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107};
static const unsigned char precomputed_pow_inv25519_p_183[] = {253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179};
static const unsigned char precomputed_pow_inv25519_q_184[] = {92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95};
static const unsigned char precomputed_pow_inv25519_p_184[] = {16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180};
static const unsigned char precomputed_pow_inv25519_q_185[] = {92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_pow_inv25519_p_185[] = {220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_pow_inv25519_q_186[] = {172,154,20,26,177,187,189,219,238,205,20,135,222,148,10,180,45,77,167,230,85,220,108,93,190,152,222,115,194,46,238,38};
static const unsigned char precomputed_pow_inv25519_p_186[] = {49,227,89,1,60,152,183,120,89,158,57,84,116,231,55,213,6,81,44,123,127,232,229,121,133,50,184,254,130,13,213,183};
static const unsigned char precomputed_pow_inv25519_q_187[] = {194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35};
static const unsigned char precomputed_pow_inv25519_p_187[] = {196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190};
static const unsigned char precomputed_pow_inv25519_q_188[] = {32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1};
static const unsigned char precomputed_pow_inv25519_p_188[] = {46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191};
static const unsigned char precomputed_pow_inv25519_q_189[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68};
static const unsigned char precomputed_pow_inv25519_p_189[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192};
static const unsigned char precomputed_pow_inv25519_q_190[] = {218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91};
static const unsigned char precomputed_pow_inv25519_p_190[] = {88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193};
static const unsigned char precomputed_pow_inv25519_q_191[] = {215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76};
static const unsigned char precomputed_pow_inv25519_p_191[] = {13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193};
static const unsigned char precomputed_pow_inv25519_q_192[] = {146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45};
static const unsigned char precomputed_pow_inv25519_p_192[] = {55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193};
static const unsigned char precomputed_pow_inv25519_q_193[] = {229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57};
static const unsigned char precomputed_pow_inv25519_p_193[] = {46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195};
static const unsigned char precomputed_pow_inv25519_q_194[] = {88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113};
static const unsigned char precomputed_pow_inv25519_p_194[] = {174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196};
static const unsigned char precomputed_pow_inv25519_q_195[] = {64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40};
static const unsigned char precomputed_pow_inv25519_p_195[] = {144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199};
static const unsigned char precomputed_pow_inv25519_q_196[] = {99,201,196,169,55,97,250,40,141,136,16,157,64,175,118,170,88,177,140,160,7,30,114,150,4,66,180,241,24,77,251,24};
static const unsigned char precomputed_pow_inv25519_p_196[] = {172,37,106,178,186,134,115,186,94,177,212,105,200,72,126,162,183,252,84,234,71,113,123,115,27,145,22,179,65,52,126,200};
static const unsigned char precomputed_pow_inv25519_q_197[] = {174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67};
static const unsigned char precomputed_pow_inv25519_p_197[] = {242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200};
static const unsigned char precomputed_pow_inv25519_q_198[] = {30,77,35,14,207,56,225,204,214,84,214,43,10,5,131,1,232,164,48,194,28,249,10,221,177,149,235,251,97,74,211,10};
static const unsigned char precomputed_pow_inv25519_p_198[] = {108,209,156,236,156,166,225,245,1,255,55,161,87,186,87,163,186,173,58,130,239,62,58,38,221,97,184,184,72,35,198,201};
static const unsigned char precomputed_pow_inv25519_q_199[] = {107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_pow_inv25519_p_199[] = {178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_pow_inv25519_q_200[] = {214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5};
static const unsigned char precomputed_pow_inv25519_p_200[] = {204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207};
static const unsigned char precomputed_pow_inv25519_q_201[] = {47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15};
static const unsigned char precomputed_pow_inv25519_p_201[] = {35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209};
static const unsigned char precomputed_pow_inv25519_q_202[] = {58,222,210,172,117,119,57,61,224,20,29,150,221,44,144,70,140,51,231,175,210,153,37,88,146,194,225,169,73,158,19,113};
static const unsigned char precomputed_pow_inv25519_p_202[] = {236,192,151,177,212,242,244,63,100,18,73,46,25,215,142,32,185,134,95,138,231,167,29,123,189,146,175,242,71,212,160,210};
static const unsigned char precomputed_pow_inv25519_q_203[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5};
static const unsigned char precomputed_pow_inv25519_p_203[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211};
static const unsigned char precomputed_pow_inv25519_q_204[] = {70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_pow_inv25519_p_204[] = {250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_pow_inv25519_q_205[] = {131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67};
static const unsigned char precomputed_pow_inv25519_p_205[] = {214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214};
static const unsigned char precomputed_pow_inv25519_q_206[] = {157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43};
static const unsigned char precomputed_pow_inv25519_p_206[] = {244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214};
static const unsigned char precomputed_pow_inv25519_q_207[] = {87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_pow_inv25519_p_207[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_pow_inv25519_q_208[] = {162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0};
static const unsigned char precomputed_pow_inv25519_p_208[] = {139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217};
static const unsigned char precomputed_pow_inv25519_q_209[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111};
static const unsigned char precomputed_pow_inv25519_p_209[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221};
static const unsigned char precomputed_pow_inv25519_q_210[] = {119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84};
static const unsigned char precomputed_pow_inv25519_p_210[] = {143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223};
static const unsigned char precomputed_pow_inv25519_q_211[] = {244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113};
static const unsigned char precomputed_pow_inv25519_p_211[] = {22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223};
static const unsigned char precomputed_pow_inv25519_q_212[] = {136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111};
static const unsigned char precomputed_pow_inv25519_p_212[] = {35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223};
static const unsigned char precomputed_pow_inv25519_q_213[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86};
static const unsigned char precomputed_pow_inv25519_p_213[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223};
static const unsigned char precomputed_pow_inv25519_q_214[] = {247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118};
static const unsigned char precomputed_pow_inv25519_p_214[] = {210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224};
static const unsigned char precomputed_pow_inv25519_q_215[] = {153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45};
static const unsigned char precomputed_pow_inv25519_p_215[] = {232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224};
static const unsigned char precomputed_pow_inv25519_q_216[] = {102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105};
static const unsigned char precomputed_pow_inv25519_p_216[] = {27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234};
static const unsigned char precomputed_pow_inv25519_q_217[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_pow_inv25519_p_217[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_pow_inv25519_q_218[] = {126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16};
static const unsigned char precomputed_pow_inv25519_p_218[] = {25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236};
static const unsigned char precomputed_pow_inv25519_q_219[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44};
static const unsigned char precomputed_pow_inv25519_p_219[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236};
static const unsigned char precomputed_pow_inv25519_q_220[] = {89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71};
static const unsigned char precomputed_pow_inv25519_p_220[] = {168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239};
static const unsigned char precomputed_pow_inv25519_q_221[] = {242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2};
static const unsigned char precomputed_pow_inv25519_p_221[] = {149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240};
static const unsigned char precomputed_pow_inv25519_q_222[] = {239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7};
static const unsigned char precomputed_pow_inv25519_p_222[] = {190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245};
static const unsigned char precomputed_pow_inv25519_q_223[] = {60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39};
static const unsigned char precomputed_pow_inv25519_p_223[] = {180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245};
static const unsigned char precomputed_pow_inv25519_q_224[] = {23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_pow_inv25519_p_224[] = {170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_pow_inv25519_q_225[] = {231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_pow_inv25519_p_225[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_pow_inv25519_q_226[] = {89,198,80,48,244,56,47,214,227,188,88,156,193,94,9,89,75,209,109,178,3,109,160,247,107,98,103,234,213,41,188,13};
static const unsigned char precomputed_pow_inv25519_p_226[] = {91,94,189,239,65,25,164,16,97,157,57,15,98,46,197,53,97,137,208,106,56,113,72,246,21,174,146,118,48,34,127,250};
static const unsigned char precomputed_pow_inv25519_q_227[] = {120,109,244,14,120,248,5,253,209,142,9,226,88,17,109,141,148,174,208,247,226,254,102,22,49,239,234,213,17,172,70,17};
static const unsigned char precomputed_pow_inv25519_p_227[] = {168,56,27,159,191,8,6,120,33,137,112,137,74,90,42,223,96,94,197,77,20,87,240,251,40,205,31,126,97,161,79,252};
static const unsigned char precomputed_pow_inv25519_q_228[] = {20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_pow_inv25519_p_228[] = {168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_pow_inv25519_q_229[] = {19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8};
static const unsigned char precomputed_pow_inv25519_p_229[] = {239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253};
static const unsigned char precomputed_pow_inv25519_q_230[] = {149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21};
static const unsigned char precomputed_pow_inv25519_p_230[] = {19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255};
static const unsigned char precomputed_pow_inv25519_q_231[] = {1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24};
static const unsigned char precomputed_pow_inv25519_p_231[] = {89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255};
static const unsigned char precomputed_pow_inv25519_q_232[] = {95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11};
static const unsigned char precomputed_pow_inv25519_p_232[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_233[] = {109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49};
static const unsigned char precomputed_pow_inv25519_p_233[] = {193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_234[] = {78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116};
static const unsigned char precomputed_pow_inv25519_p_234[] = {194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_235[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57};
static const unsigned char precomputed_pow_inv25519_p_235[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_236[] = {123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_pow_inv25519_p_236[] = {196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_237[] = {191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92};
static const unsigned char precomputed_pow_inv25519_p_237[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_238[] = {246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22};
static const unsigned char precomputed_pow_inv25519_p_238[] = {198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_239[] = {227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104};
static const unsigned char precomputed_pow_inv25519_p_239[] = {199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_240[] = {237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34};
static const unsigned char precomputed_pow_inv25519_p_240[] = {200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_241[] = {50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46};
static const unsigned char precomputed_pow_inv25519_p_241[] = {201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_242[] = {114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69};
static const unsigned char precomputed_pow_inv25519_p_242[] = {202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_243[] = {208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_pow_inv25519_p_243[] = {203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_244[] = {139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108};
static const unsigned char precomputed_pow_inv25519_p_244[] = {204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_245[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19};
static const unsigned char precomputed_pow_inv25519_p_245[] = {205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_246[] = {133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49};
static const unsigned char precomputed_pow_inv25519_p_246[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_247[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81};
static const unsigned char precomputed_pow_inv25519_p_247[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_248[] = {48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92};
static const unsigned char precomputed_pow_inv25519_p_248[] = {208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_249[] = {216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22};
static const unsigned char precomputed_pow_inv25519_p_249[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_250[] = {231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104};
static const unsigned char precomputed_pow_inv25519_p_250[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_251[] = {113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34};
static const unsigned char precomputed_pow_inv25519_p_251[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_252[] = {207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122};
static const unsigned char precomputed_pow_inv25519_p_252[] = {212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_253[] = {75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69};
static const unsigned char precomputed_pow_inv25519_p_253[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_254[] = {42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16};
static const unsigned char precomputed_pow_inv25519_p_254[] = {214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_255[] = {218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98};
static const unsigned char precomputed_pow_inv25519_p_255[] = {215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_256[] = {190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115};
static const unsigned char precomputed_pow_inv25519_p_256[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_257[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57};
static const unsigned char precomputed_pow_inv25519_p_257[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_258[] = {217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80};
static const unsigned char precomputed_pow_inv25519_p_258[] = {218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_259[] = {100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92};
static const unsigned char precomputed_pow_inv25519_p_259[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_260[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37};
static const unsigned char precomputed_pow_inv25519_p_260[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_261[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39};
static const unsigned char precomputed_pow_inv25519_p_261[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_262[] = {29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34};
static const unsigned char precomputed_pow_inv25519_p_262[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_263[] = {176,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,45};
static const unsigned char precomputed_pow_inv25519_p_263[] = {223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_264[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68};
static const unsigned char precomputed_pow_inv25519_p_264[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_265[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_pow_inv25519_p_265[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_266[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69};
static const unsigned char precomputed_pow_inv25519_p_266[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_267[] = {34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_pow_inv25519_p_267[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_268[] = {219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_pow_inv25519_p_268[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_269[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_pow_inv25519_p_269[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_270[] = {96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_pow_inv25519_p_270[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_271[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21};
static const unsigned char precomputed_pow_inv25519_p_271[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_272[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_pow_inv25519_p_272[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_273[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31};
static const unsigned char precomputed_pow_inv25519_p_273[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_274[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_pow_inv25519_p_274[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_275[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_275[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_p_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_277[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_277[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_278[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_278[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_279[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_279[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_280[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_280[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_281[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_281[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_282[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_282[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_283[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_283[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_284[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_284[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_285[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_285[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_286[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_286[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_287[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_287[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_288[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_288[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_289[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_289[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_290[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_290[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_291[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_291[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_292[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_292[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_293[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_293[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_294[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_294[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_295[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_295[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *p;
  long long psize;
} precomputed_pow_inv25519[precomputed_pow_inv25519_NUM] = {
  {
    precomputed_pow_inv25519_q_0,32,
    precomputed_pow_inv25519_p_0,32,
  },
  {
    precomputed_pow_inv25519_q_1,32,
    precomputed_pow_inv25519_p_1,32,
  },
  {
    precomputed_pow_inv25519_q_2,32,
    precomputed_pow_inv25519_p_2,32,
  },
  {
    precomputed_pow_inv25519_q_3,32,
    precomputed_pow_inv25519_p_3,32,
  },
  {
    precomputed_pow_inv25519_q_4,32,
    precomputed_pow_inv25519_p_4,32,
  },
  {
    precomputed_pow_inv25519_q_5,32,
    precomputed_pow_inv25519_p_5,32,
  },
  {
    precomputed_pow_inv25519_q_6,32,
    precomputed_pow_inv25519_p_6,32,
  },
  {
    precomputed_pow_inv25519_q_7,32,
    precomputed_pow_inv25519_p_7,32,
  },
  {
    precomputed_pow_inv25519_q_8,32,
    precomputed_pow_inv25519_p_8,32,
  },
  {
    precomputed_pow_inv25519_q_9,32,
    precomputed_pow_inv25519_p_9,32,
  },
  {
    precomputed_pow_inv25519_q_10,32,
    precomputed_pow_inv25519_p_10,32,
  },
  {
    precomputed_pow_inv25519_q_11,32,
    precomputed_pow_inv25519_p_11,32,
  },
  {
    precomputed_pow_inv25519_q_12,32,
    precomputed_pow_inv25519_p_12,32,
  },
  {
    precomputed_pow_inv25519_q_13,32,
    precomputed_pow_inv25519_p_13,32,
  },
  {
    precomputed_pow_inv25519_q_14,32,
    precomputed_pow_inv25519_p_14,32,
  },
  {
    precomputed_pow_inv25519_q_15,32,
    precomputed_pow_inv25519_p_15,32,
  },
  {
    precomputed_pow_inv25519_q_16,32,
    precomputed_pow_inv25519_p_16,32,
  },
  {
    precomputed_pow_inv25519_q_17,32,
    precomputed_pow_inv25519_p_17,32,
  },
  {
    precomputed_pow_inv25519_q_18,32,
    precomputed_pow_inv25519_p_18,32,
  },
  {
    precomputed_pow_inv25519_q_19,32,
    precomputed_pow_inv25519_p_19,32,
  },
  {
    precomputed_pow_inv25519_q_20,32,
    precomputed_pow_inv25519_p_20,32,
  },
  {
    precomputed_pow_inv25519_q_21,32,
    precomputed_pow_inv25519_p_21,32,
  },
  {
    precomputed_pow_inv25519_q_22,32,
    precomputed_pow_inv25519_p_22,32,
  },
  {
    precomputed_pow_inv25519_q_23,32,
    precomputed_pow_inv25519_p_23,32,
  },
  {
    precomputed_pow_inv25519_q_24,32,
    precomputed_pow_inv25519_p_24,32,
  },
  {
    precomputed_pow_inv25519_q_25,32,
    precomputed_pow_inv25519_p_25,32,
  },
  {
    precomputed_pow_inv25519_q_26,32,
    precomputed_pow_inv25519_p_26,32,
  },
  {
    precomputed_pow_inv25519_q_27,32,
    precomputed_pow_inv25519_p_27,32,
  },
  {
    precomputed_pow_inv25519_q_28,32,
    precomputed_pow_inv25519_p_28,32,
  },
  {
    precomputed_pow_inv25519_q_29,32,
    precomputed_pow_inv25519_p_29,32,
  },
  {
    precomputed_pow_inv25519_q_30,32,
    precomputed_pow_inv25519_p_30,32,
  },
  {
    precomputed_pow_inv25519_q_31,32,
    precomputed_pow_inv25519_p_31,32,
  },
  {
    precomputed_pow_inv25519_q_32,32,
    precomputed_pow_inv25519_p_32,32,
  },
  {
    precomputed_pow_inv25519_q_33,32,
    precomputed_pow_inv25519_p_33,32,
  },
  {
    precomputed_pow_inv25519_q_34,32,
    precomputed_pow_inv25519_p_34,32,
  },
  {
    precomputed_pow_inv25519_q_35,32,
    precomputed_pow_inv25519_p_35,32,
  },
  {
    precomputed_pow_inv25519_q_36,32,
    precomputed_pow_inv25519_p_36,32,
  },
  {
    precomputed_pow_inv25519_q_37,32,
    precomputed_pow_inv25519_p_37,32,
  },
  {
    precomputed_pow_inv25519_q_38,32,
    precomputed_pow_inv25519_p_38,32,
  },
  {
    precomputed_pow_inv25519_q_39,32,
    precomputed_pow_inv25519_p_39,32,
  },
  {
    precomputed_pow_inv25519_q_40,32,
    precomputed_pow_inv25519_p_40,32,
  },
  {
    precomputed_pow_inv25519_q_41,32,
    precomputed_pow_inv25519_p_41,32,
  },
  {
    precomputed_pow_inv25519_q_42,32,
    precomputed_pow_inv25519_p_42,32,
  },
  {
    precomputed_pow_inv25519_q_43,32,
    precomputed_pow_inv25519_p_43,32,
  },
  {
    precomputed_pow_inv25519_q_44,32,
    precomputed_pow_inv25519_p_44,32,
  },
  {
    precomputed_pow_inv25519_q_45,32,
    precomputed_pow_inv25519_p_45,32,
  },
  {
    precomputed_pow_inv25519_q_46,32,
    precomputed_pow_inv25519_p_46,32,
  },
  {
    precomputed_pow_inv25519_q_47,32,
    precomputed_pow_inv25519_p_47,32,
  },
  {
    precomputed_pow_inv25519_q_48,32,
    precomputed_pow_inv25519_p_48,32,
  },
  {
    precomputed_pow_inv25519_q_49,32,
    precomputed_pow_inv25519_p_49,32,
  },
  {
    precomputed_pow_inv25519_q_50,32,
    precomputed_pow_inv25519_p_50,32,
  },
  {
    precomputed_pow_inv25519_q_51,32,
    precomputed_pow_inv25519_p_51,32,
  },
  {
    precomputed_pow_inv25519_q_52,32,
    precomputed_pow_inv25519_p_52,32,
  },
  {
    precomputed_pow_inv25519_q_53,32,
    precomputed_pow_inv25519_p_53,32,
  },
  {
    precomputed_pow_inv25519_q_54,32,
    precomputed_pow_inv25519_p_54,32,
  },
  {
    precomputed_pow_inv25519_q_55,32,
    precomputed_pow_inv25519_p_55,32,
  },
  {
    precomputed_pow_inv25519_q_56,32,
    precomputed_pow_inv25519_p_56,32,
  },
  {
    precomputed_pow_inv25519_q_57,32,
    precomputed_pow_inv25519_p_57,32,
  },
  {
    precomputed_pow_inv25519_q_58,32,
    precomputed_pow_inv25519_p_58,32,
  },
  {
    precomputed_pow_inv25519_q_59,32,
    precomputed_pow_inv25519_p_59,32,
  },
  {
    precomputed_pow_inv25519_q_60,32,
    precomputed_pow_inv25519_p_60,32,
  },
  {
    precomputed_pow_inv25519_q_61,32,
    precomputed_pow_inv25519_p_61,32,
  },
  {
    precomputed_pow_inv25519_q_62,32,
    precomputed_pow_inv25519_p_62,32,
  },
  {
    precomputed_pow_inv25519_q_63,32,
    precomputed_pow_inv25519_p_63,32,
  },
  {
    precomputed_pow_inv25519_q_64,32,
    precomputed_pow_inv25519_p_64,32,
  },
  {
    precomputed_pow_inv25519_q_65,32,
    precomputed_pow_inv25519_p_65,32,
  },
  {
    precomputed_pow_inv25519_q_66,32,
    precomputed_pow_inv25519_p_66,32,
  },
  {
    precomputed_pow_inv25519_q_67,32,
    precomputed_pow_inv25519_p_67,32,
  },
  {
    precomputed_pow_inv25519_q_68,32,
    precomputed_pow_inv25519_p_68,32,
  },
  {
    precomputed_pow_inv25519_q_69,32,
    precomputed_pow_inv25519_p_69,32,
  },
  {
    precomputed_pow_inv25519_q_70,32,
    precomputed_pow_inv25519_p_70,32,
  },
  {
    precomputed_pow_inv25519_q_71,32,
    precomputed_pow_inv25519_p_71,32,
  },
  {
    precomputed_pow_inv25519_q_72,32,
    precomputed_pow_inv25519_p_72,32,
  },
  {
    precomputed_pow_inv25519_q_73,32,
    precomputed_pow_inv25519_p_73,32,
  },
  {
    precomputed_pow_inv25519_q_74,32,
    precomputed_pow_inv25519_p_74,32,
  },
  {
    precomputed_pow_inv25519_q_75,32,
    precomputed_pow_inv25519_p_75,32,
  },
  {
    precomputed_pow_inv25519_q_76,32,
    precomputed_pow_inv25519_p_76,32,
  },
  {
    precomputed_pow_inv25519_q_77,32,
    precomputed_pow_inv25519_p_77,32,
  },
  {
    precomputed_pow_inv25519_q_78,32,
    precomputed_pow_inv25519_p_78,32,
  },
  {
    precomputed_pow_inv25519_q_79,32,
    precomputed_pow_inv25519_p_79,32,
  },
  {
    precomputed_pow_inv25519_q_80,32,
    precomputed_pow_inv25519_p_80,32,
  },
  {
    precomputed_pow_inv25519_q_81,32,
    precomputed_pow_inv25519_p_81,32,
  },
  {
    precomputed_pow_inv25519_q_82,32,
    precomputed_pow_inv25519_p_82,32,
  },
  {
    precomputed_pow_inv25519_q_83,32,
    precomputed_pow_inv25519_p_83,32,
  },
  {
    precomputed_pow_inv25519_q_84,32,
    precomputed_pow_inv25519_p_84,32,
  },
  {
    precomputed_pow_inv25519_q_85,32,
    precomputed_pow_inv25519_p_85,32,
  },
  {
    precomputed_pow_inv25519_q_86,32,
    precomputed_pow_inv25519_p_86,32,
  },
  {
    precomputed_pow_inv25519_q_87,32,
    precomputed_pow_inv25519_p_87,32,
  },
  {
    precomputed_pow_inv25519_q_88,32,
    precomputed_pow_inv25519_p_88,32,
  },
  {
    precomputed_pow_inv25519_q_89,32,
    precomputed_pow_inv25519_p_89,32,
  },
  {
    precomputed_pow_inv25519_q_90,32,
    precomputed_pow_inv25519_p_90,32,
  },
  {
    precomputed_pow_inv25519_q_91,32,
    precomputed_pow_inv25519_p_91,32,
  },
  {
    precomputed_pow_inv25519_q_92,32,
    precomputed_pow_inv25519_p_92,32,
  },
  {
    precomputed_pow_inv25519_q_93,32,
    precomputed_pow_inv25519_p_93,32,
  },
  {
    precomputed_pow_inv25519_q_94,32,
    precomputed_pow_inv25519_p_94,32,
  },
  {
    precomputed_pow_inv25519_q_95,32,
    precomputed_pow_inv25519_p_95,32,
  },
  {
    precomputed_pow_inv25519_q_96,32,
    precomputed_pow_inv25519_p_96,32,
  },
  {
    precomputed_pow_inv25519_q_97,32,
    precomputed_pow_inv25519_p_97,32,
  },
  {
    precomputed_pow_inv25519_q_98,32,
    precomputed_pow_inv25519_p_98,32,
  },
  {
    precomputed_pow_inv25519_q_99,32,
    precomputed_pow_inv25519_p_99,32,
  },
  {
    precomputed_pow_inv25519_q_100,32,
    precomputed_pow_inv25519_p_100,32,
  },
  {
    precomputed_pow_inv25519_q_101,32,
    precomputed_pow_inv25519_p_101,32,
  },
  {
    precomputed_pow_inv25519_q_102,32,
    precomputed_pow_inv25519_p_102,32,
  },
  {
    precomputed_pow_inv25519_q_103,32,
    precomputed_pow_inv25519_p_103,32,
  },
  {
    precomputed_pow_inv25519_q_104,32,
    precomputed_pow_inv25519_p_104,32,
  },
  {
    precomputed_pow_inv25519_q_105,32,
    precomputed_pow_inv25519_p_105,32,
  },
  {
    precomputed_pow_inv25519_q_106,32,
    precomputed_pow_inv25519_p_106,32,
  },
  {
    precomputed_pow_inv25519_q_107,32,
    precomputed_pow_inv25519_p_107,32,
  },
  {
    precomputed_pow_inv25519_q_108,32,
    precomputed_pow_inv25519_p_108,32,
  },
  {
    precomputed_pow_inv25519_q_109,32,
    precomputed_pow_inv25519_p_109,32,
  },
  {
    precomputed_pow_inv25519_q_110,32,
    precomputed_pow_inv25519_p_110,32,
  },
  {
    precomputed_pow_inv25519_q_111,32,
    precomputed_pow_inv25519_p_111,32,
  },
  {
    precomputed_pow_inv25519_q_112,32,
    precomputed_pow_inv25519_p_112,32,
  },
  {
    precomputed_pow_inv25519_q_113,32,
    precomputed_pow_inv25519_p_113,32,
  },
  {
    precomputed_pow_inv25519_q_114,32,
    precomputed_pow_inv25519_p_114,32,
  },
  {
    precomputed_pow_inv25519_q_115,32,
    precomputed_pow_inv25519_p_115,32,
  },
  {
    precomputed_pow_inv25519_q_116,32,
    precomputed_pow_inv25519_p_116,32,
  },
  {
    precomputed_pow_inv25519_q_117,32,
    precomputed_pow_inv25519_p_117,32,
  },
  {
    precomputed_pow_inv25519_q_118,32,
    precomputed_pow_inv25519_p_118,32,
  },
  {
    precomputed_pow_inv25519_q_119,32,
    precomputed_pow_inv25519_p_119,32,
  },
  {
    precomputed_pow_inv25519_q_120,32,
    precomputed_pow_inv25519_p_120,32,
  },
  {
    precomputed_pow_inv25519_q_121,32,
    precomputed_pow_inv25519_p_121,32,
  },
  {
    precomputed_pow_inv25519_q_122,32,
    precomputed_pow_inv25519_p_122,32,
  },
  {
    precomputed_pow_inv25519_q_123,32,
    precomputed_pow_inv25519_p_123,32,
  },
  {
    precomputed_pow_inv25519_q_124,32,
    precomputed_pow_inv25519_p_124,32,
  },
  {
    precomputed_pow_inv25519_q_125,32,
    precomputed_pow_inv25519_p_125,32,
  },
  {
    precomputed_pow_inv25519_q_126,32,
    precomputed_pow_inv25519_p_126,32,
  },
  {
    precomputed_pow_inv25519_q_127,32,
    precomputed_pow_inv25519_p_127,32,
  },
  {
    precomputed_pow_inv25519_q_128,32,
    precomputed_pow_inv25519_p_128,32,
  },
  {
    precomputed_pow_inv25519_q_129,32,
    precomputed_pow_inv25519_p_129,32,
  },
  {
    precomputed_pow_inv25519_q_130,32,
    precomputed_pow_inv25519_p_130,32,
  },
  {
    precomputed_pow_inv25519_q_131,32,
    precomputed_pow_inv25519_p_131,32,
  },
  {
    precomputed_pow_inv25519_q_132,32,
    precomputed_pow_inv25519_p_132,32,
  },
  {
    precomputed_pow_inv25519_q_133,32,
    precomputed_pow_inv25519_p_133,32,
  },
  {
    precomputed_pow_inv25519_q_134,32,
    precomputed_pow_inv25519_p_134,32,
  },
  {
    precomputed_pow_inv25519_q_135,32,
    precomputed_pow_inv25519_p_135,32,
  },
  {
    precomputed_pow_inv25519_q_136,32,
    precomputed_pow_inv25519_p_136,32,
  },
  {
    precomputed_pow_inv25519_q_137,32,
    precomputed_pow_inv25519_p_137,32,
  },
  {
    precomputed_pow_inv25519_q_138,32,
    precomputed_pow_inv25519_p_138,32,
  },
  {
    precomputed_pow_inv25519_q_139,32,
    precomputed_pow_inv25519_p_139,32,
  },
  {
    precomputed_pow_inv25519_q_140,32,
    precomputed_pow_inv25519_p_140,32,
  },
  {
    precomputed_pow_inv25519_q_141,32,
    precomputed_pow_inv25519_p_141,32,
  },
  {
    precomputed_pow_inv25519_q_142,32,
    precomputed_pow_inv25519_p_142,32,
  },
  {
    precomputed_pow_inv25519_q_143,32,
    precomputed_pow_inv25519_p_143,32,
  },
  {
    precomputed_pow_inv25519_q_144,32,
    precomputed_pow_inv25519_p_144,32,
  },
  {
    precomputed_pow_inv25519_q_145,32,
    precomputed_pow_inv25519_p_145,32,
  },
  {
    precomputed_pow_inv25519_q_146,32,
    precomputed_pow_inv25519_p_146,32,
  },
  {
    precomputed_pow_inv25519_q_147,32,
    precomputed_pow_inv25519_p_147,32,
  },
  {
    precomputed_pow_inv25519_q_148,32,
    precomputed_pow_inv25519_p_148,32,
  },
  {
    precomputed_pow_inv25519_q_149,32,
    precomputed_pow_inv25519_p_149,32,
  },
  {
    precomputed_pow_inv25519_q_150,32,
    precomputed_pow_inv25519_p_150,32,
  },
  {
    precomputed_pow_inv25519_q_151,32,
    precomputed_pow_inv25519_p_151,32,
  },
  {
    precomputed_pow_inv25519_q_152,32,
    precomputed_pow_inv25519_p_152,32,
  },
  {
    precomputed_pow_inv25519_q_153,32,
    precomputed_pow_inv25519_p_153,32,
  },
  {
    precomputed_pow_inv25519_q_154,32,
    precomputed_pow_inv25519_p_154,32,
  },
  {
    precomputed_pow_inv25519_q_155,32,
    precomputed_pow_inv25519_p_155,32,
  },
  {
    precomputed_pow_inv25519_q_156,32,
    precomputed_pow_inv25519_p_156,32,
  },
  {
    precomputed_pow_inv25519_q_157,32,
    precomputed_pow_inv25519_p_157,32,
  },
  {
    precomputed_pow_inv25519_q_158,32,
    precomputed_pow_inv25519_p_158,32,
  },
  {
    precomputed_pow_inv25519_q_159,32,
    precomputed_pow_inv25519_p_159,32,
  },
  {
    precomputed_pow_inv25519_q_160,32,
    precomputed_pow_inv25519_p_160,32,
  },
  {
    precomputed_pow_inv25519_q_161,32,
    precomputed_pow_inv25519_p_161,32,
  },
  {
    precomputed_pow_inv25519_q_162,32,
    precomputed_pow_inv25519_p_162,32,
  },
  {
    precomputed_pow_inv25519_q_163,32,
    precomputed_pow_inv25519_p_163,32,
  },
  {
    precomputed_pow_inv25519_q_164,32,
    precomputed_pow_inv25519_p_164,32,
  },
  {
    precomputed_pow_inv25519_q_165,32,
    precomputed_pow_inv25519_p_165,32,
  },
  {
    precomputed_pow_inv25519_q_166,32,
    precomputed_pow_inv25519_p_166,32,
  },
  {
    precomputed_pow_inv25519_q_167,32,
    precomputed_pow_inv25519_p_167,32,
  },
  {
    precomputed_pow_inv25519_q_168,32,
    precomputed_pow_inv25519_p_168,32,
  },
  {
    precomputed_pow_inv25519_q_169,32,
    precomputed_pow_inv25519_p_169,32,
  },
  {
    precomputed_pow_inv25519_q_170,32,
    precomputed_pow_inv25519_p_170,32,
  },
  {
    precomputed_pow_inv25519_q_171,32,
    precomputed_pow_inv25519_p_171,32,
  },
  {
    precomputed_pow_inv25519_q_172,32,
    precomputed_pow_inv25519_p_172,32,
  },
  {
    precomputed_pow_inv25519_q_173,32,
    precomputed_pow_inv25519_p_173,32,
  },
  {
    precomputed_pow_inv25519_q_174,32,
    precomputed_pow_inv25519_p_174,32,
  },
  {
    precomputed_pow_inv25519_q_175,32,
    precomputed_pow_inv25519_p_175,32,
  },
  {
    precomputed_pow_inv25519_q_176,32,
    precomputed_pow_inv25519_p_176,32,
  },
  {
    precomputed_pow_inv25519_q_177,32,
    precomputed_pow_inv25519_p_177,32,
  },
  {
    precomputed_pow_inv25519_q_178,32,
    precomputed_pow_inv25519_p_178,32,
  },
  {
    precomputed_pow_inv25519_q_179,32,
    precomputed_pow_inv25519_p_179,32,
  },
  {
    precomputed_pow_inv25519_q_180,32,
    precomputed_pow_inv25519_p_180,32,
  },
  {
    precomputed_pow_inv25519_q_181,32,
    precomputed_pow_inv25519_p_181,32,
  },
  {
    precomputed_pow_inv25519_q_182,32,
    precomputed_pow_inv25519_p_182,32,
  },
  {
    precomputed_pow_inv25519_q_183,32,
    precomputed_pow_inv25519_p_183,32,
  },
  {
    precomputed_pow_inv25519_q_184,32,
    precomputed_pow_inv25519_p_184,32,
  },
  {
    precomputed_pow_inv25519_q_185,32,
    precomputed_pow_inv25519_p_185,32,
  },
  {
    precomputed_pow_inv25519_q_186,32,
    precomputed_pow_inv25519_p_186,32,
  },
  {
    precomputed_pow_inv25519_q_187,32,
    precomputed_pow_inv25519_p_187,32,
  },
  {
    precomputed_pow_inv25519_q_188,32,
    precomputed_pow_inv25519_p_188,32,
  },
  {
    precomputed_pow_inv25519_q_189,32,
    precomputed_pow_inv25519_p_189,32,
  },
  {
    precomputed_pow_inv25519_q_190,32,
    precomputed_pow_inv25519_p_190,32,
  },
  {
    precomputed_pow_inv25519_q_191,32,
    precomputed_pow_inv25519_p_191,32,
  },
  {
    precomputed_pow_inv25519_q_192,32,
    precomputed_pow_inv25519_p_192,32,
  },
  {
    precomputed_pow_inv25519_q_193,32,
    precomputed_pow_inv25519_p_193,32,
  },
  {
    precomputed_pow_inv25519_q_194,32,
    precomputed_pow_inv25519_p_194,32,
  },
  {
    precomputed_pow_inv25519_q_195,32,
    precomputed_pow_inv25519_p_195,32,
  },
  {
    precomputed_pow_inv25519_q_196,32,
    precomputed_pow_inv25519_p_196,32,
  },
  {
    precomputed_pow_inv25519_q_197,32,
    precomputed_pow_inv25519_p_197,32,
  },
  {
    precomputed_pow_inv25519_q_198,32,
    precomputed_pow_inv25519_p_198,32,
  },
  {
    precomputed_pow_inv25519_q_199,32,
    precomputed_pow_inv25519_p_199,32,
  },
  {
    precomputed_pow_inv25519_q_200,32,
    precomputed_pow_inv25519_p_200,32,
  },
  {
    precomputed_pow_inv25519_q_201,32,
    precomputed_pow_inv25519_p_201,32,
  },
  {
    precomputed_pow_inv25519_q_202,32,
    precomputed_pow_inv25519_p_202,32,
  },
  {
    precomputed_pow_inv25519_q_203,32,
    precomputed_pow_inv25519_p_203,32,
  },
  {
    precomputed_pow_inv25519_q_204,32,
    precomputed_pow_inv25519_p_204,32,
  },
  {
    precomputed_pow_inv25519_q_205,32,
    precomputed_pow_inv25519_p_205,32,
  },
  {
    precomputed_pow_inv25519_q_206,32,
    precomputed_pow_inv25519_p_206,32,
  },
  {
    precomputed_pow_inv25519_q_207,32,
    precomputed_pow_inv25519_p_207,32,
  },
  {
    precomputed_pow_inv25519_q_208,32,
    precomputed_pow_inv25519_p_208,32,
  },
  {
    precomputed_pow_inv25519_q_209,32,
    precomputed_pow_inv25519_p_209,32,
  },
  {
    precomputed_pow_inv25519_q_210,32,
    precomputed_pow_inv25519_p_210,32,
  },
  {
    precomputed_pow_inv25519_q_211,32,
    precomputed_pow_inv25519_p_211,32,
  },
  {
    precomputed_pow_inv25519_q_212,32,
    precomputed_pow_inv25519_p_212,32,
  },
  {
    precomputed_pow_inv25519_q_213,32,
    precomputed_pow_inv25519_p_213,32,
  },
  {
    precomputed_pow_inv25519_q_214,32,
    precomputed_pow_inv25519_p_214,32,
  },
  {
    precomputed_pow_inv25519_q_215,32,
    precomputed_pow_inv25519_p_215,32,
  },
  {
    precomputed_pow_inv25519_q_216,32,
    precomputed_pow_inv25519_p_216,32,
  },
  {
    precomputed_pow_inv25519_q_217,32,
    precomputed_pow_inv25519_p_217,32,
  },
  {
    precomputed_pow_inv25519_q_218,32,
    precomputed_pow_inv25519_p_218,32,
  },
  {
    precomputed_pow_inv25519_q_219,32,
    precomputed_pow_inv25519_p_219,32,
  },
  {
    precomputed_pow_inv25519_q_220,32,
    precomputed_pow_inv25519_p_220,32,
  },
  {
    precomputed_pow_inv25519_q_221,32,
    precomputed_pow_inv25519_p_221,32,
  },
  {
    precomputed_pow_inv25519_q_222,32,
    precomputed_pow_inv25519_p_222,32,
  },
  {
    precomputed_pow_inv25519_q_223,32,
    precomputed_pow_inv25519_p_223,32,
  },
  {
    precomputed_pow_inv25519_q_224,32,
    precomputed_pow_inv25519_p_224,32,
  },
  {
    precomputed_pow_inv25519_q_225,32,
    precomputed_pow_inv25519_p_225,32,
  },
  {
    precomputed_pow_inv25519_q_226,32,
    precomputed_pow_inv25519_p_226,32,
  },
  {
    precomputed_pow_inv25519_q_227,32,
    precomputed_pow_inv25519_p_227,32,
  },
  {
    precomputed_pow_inv25519_q_228,32,
    precomputed_pow_inv25519_p_228,32,
  },
  {
    precomputed_pow_inv25519_q_229,32,
    precomputed_pow_inv25519_p_229,32,
  },
  {
    precomputed_pow_inv25519_q_230,32,
    precomputed_pow_inv25519_p_230,32,
  },
  {
    precomputed_pow_inv25519_q_231,32,
    precomputed_pow_inv25519_p_231,32,
  },
  {
    precomputed_pow_inv25519_q_232,32,
    precomputed_pow_inv25519_p_232,32,
  },
  {
    precomputed_pow_inv25519_q_233,32,
    precomputed_pow_inv25519_p_233,32,
  },
  {
    precomputed_pow_inv25519_q_234,32,
    precomputed_pow_inv25519_p_234,32,
  },
  {
    precomputed_pow_inv25519_q_235,32,
    precomputed_pow_inv25519_p_235,32,
  },
  {
    precomputed_pow_inv25519_q_236,32,
    precomputed_pow_inv25519_p_236,32,
  },
  {
    precomputed_pow_inv25519_q_237,32,
    precomputed_pow_inv25519_p_237,32,
  },
  {
    precomputed_pow_inv25519_q_238,32,
    precomputed_pow_inv25519_p_238,32,
  },
  {
    precomputed_pow_inv25519_q_239,32,
    precomputed_pow_inv25519_p_239,32,
  },
  {
    precomputed_pow_inv25519_q_240,32,
    precomputed_pow_inv25519_p_240,32,
  },
  {
    precomputed_pow_inv25519_q_241,32,
    precomputed_pow_inv25519_p_241,32,
  },
  {
    precomputed_pow_inv25519_q_242,32,
    precomputed_pow_inv25519_p_242,32,
  },
  {
    precomputed_pow_inv25519_q_243,32,
    precomputed_pow_inv25519_p_243,32,
  },
  {
    precomputed_pow_inv25519_q_244,32,
    precomputed_pow_inv25519_p_244,32,
  },
  {
    precomputed_pow_inv25519_q_245,32,
    precomputed_pow_inv25519_p_245,32,
  },
  {
    precomputed_pow_inv25519_q_246,32,
    precomputed_pow_inv25519_p_246,32,
  },
  {
    precomputed_pow_inv25519_q_247,32,
    precomputed_pow_inv25519_p_247,32,
  },
  {
    precomputed_pow_inv25519_q_248,32,
    precomputed_pow_inv25519_p_248,32,
  },
  {
    precomputed_pow_inv25519_q_249,32,
    precomputed_pow_inv25519_p_249,32,
  },
  {
    precomputed_pow_inv25519_q_250,32,
    precomputed_pow_inv25519_p_250,32,
  },
  {
    precomputed_pow_inv25519_q_251,32,
    precomputed_pow_inv25519_p_251,32,
  },
  {
    precomputed_pow_inv25519_q_252,32,
    precomputed_pow_inv25519_p_252,32,
  },
  {
    precomputed_pow_inv25519_q_253,32,
    precomputed_pow_inv25519_p_253,32,
  },
  {
    precomputed_pow_inv25519_q_254,32,
    precomputed_pow_inv25519_p_254,32,
  },
  {
    precomputed_pow_inv25519_q_255,32,
    precomputed_pow_inv25519_p_255,32,
  },
  {
    precomputed_pow_inv25519_q_256,32,
    precomputed_pow_inv25519_p_256,32,
  },
  {
    precomputed_pow_inv25519_q_257,32,
    precomputed_pow_inv25519_p_257,32,
  },
  {
    precomputed_pow_inv25519_q_258,32,
    precomputed_pow_inv25519_p_258,32,
  },
  {
    precomputed_pow_inv25519_q_259,32,
    precomputed_pow_inv25519_p_259,32,
  },
  {
    precomputed_pow_inv25519_q_260,32,
    precomputed_pow_inv25519_p_260,32,
  },
  {
    precomputed_pow_inv25519_q_261,32,
    precomputed_pow_inv25519_p_261,32,
  },
  {
    precomputed_pow_inv25519_q_262,32,
    precomputed_pow_inv25519_p_262,32,
  },
  {
    precomputed_pow_inv25519_q_263,32,
    precomputed_pow_inv25519_p_263,32,
  },
  {
    precomputed_pow_inv25519_q_264,32,
    precomputed_pow_inv25519_p_264,32,
  },
  {
    precomputed_pow_inv25519_q_265,32,
    precomputed_pow_inv25519_p_265,32,
  },
  {
    precomputed_pow_inv25519_q_266,32,
    precomputed_pow_inv25519_p_266,32,
  },
  {
    precomputed_pow_inv25519_q_267,32,
    precomputed_pow_inv25519_p_267,32,
  },
  {
    precomputed_pow_inv25519_q_268,32,
    precomputed_pow_inv25519_p_268,32,
  },
  {
    precomputed_pow_inv25519_q_269,32,
    precomputed_pow_inv25519_p_269,32,
  },
  {
    precomputed_pow_inv25519_q_270,32,
    precomputed_pow_inv25519_p_270,32,
  },
  {
    precomputed_pow_inv25519_q_271,32,
    precomputed_pow_inv25519_p_271,32,
  },
  {
    precomputed_pow_inv25519_q_272,32,
    precomputed_pow_inv25519_p_272,32,
  },
  {
    precomputed_pow_inv25519_q_273,32,
    precomputed_pow_inv25519_p_273,32,
  },
  {
    precomputed_pow_inv25519_q_274,32,
    precomputed_pow_inv25519_p_274,32,
  },
  {
    precomputed_pow_inv25519_q_275,32,
    precomputed_pow_inv25519_p_275,32,
  },
  {
    precomputed_pow_inv25519_q_276,32,
    precomputed_pow_inv25519_p_276,32,
  },
  {
    precomputed_pow_inv25519_q_277,32,
    precomputed_pow_inv25519_p_277,32,
  },
  {
    precomputed_pow_inv25519_q_278,32,
    precomputed_pow_inv25519_p_278,32,
  },
  {
    precomputed_pow_inv25519_q_279,32,
    precomputed_pow_inv25519_p_279,32,
  },
  {
    precomputed_pow_inv25519_q_280,32,
    precomputed_pow_inv25519_p_280,32,
  },
  {
    precomputed_pow_inv25519_q_281,32,
    precomputed_pow_inv25519_p_281,32,
  },
  {
    precomputed_pow_inv25519_q_282,32,
    precomputed_pow_inv25519_p_282,32,
  },
  {
    precomputed_pow_inv25519_q_283,32,
    precomputed_pow_inv25519_p_283,32,
  },
  {
    precomputed_pow_inv25519_q_284,32,
    precomputed_pow_inv25519_p_284,32,
  },
  {
    precomputed_pow_inv25519_q_285,32,
    precomputed_pow_inv25519_p_285,32,
  },
  {
    precomputed_pow_inv25519_q_286,32,
    precomputed_pow_inv25519_p_286,32,
  },
  {
    precomputed_pow_inv25519_q_287,32,
    precomputed_pow_inv25519_p_287,32,
  },
  {
    precomputed_pow_inv25519_q_288,32,
    precomputed_pow_inv25519_p_288,32,
  },
  {
    precomputed_pow_inv25519_q_289,32,
    precomputed_pow_inv25519_p_289,32,
  },
  {
    precomputed_pow_inv25519_q_290,32,
    precomputed_pow_inv25519_p_290,32,
  },
  {
    precomputed_pow_inv25519_q_291,32,
    precomputed_pow_inv25519_p_291,32,
  },
  {
    precomputed_pow_inv25519_q_292,32,
    precomputed_pow_inv25519_p_292,32,
  },
  {
    precomputed_pow_inv25519_q_293,32,
    precomputed_pow_inv25519_p_293,32,
  },
  {
    precomputed_pow_inv25519_q_294,32,
    precomputed_pow_inv25519_p_294,32,
  },
  {
    precomputed_pow_inv25519_q_295,32,
    precomputed_pow_inv25519_p_295,32,
  },
} ;

static void test_pow_inv25519_impl(long long impl)
{
  unsigned char *q = test_pow_inv25519_q;
  unsigned char *p = test_pow_inv25519_p;
  unsigned char *q2 = test_pow_inv25519_q2;
  unsigned char *p2 = test_pow_inv25519_p2;
  long long qlen = crypto_pow_BYTES;
  long long plen = crypto_pow_BYTES;

  if (targeti && strcmp(targeti,lib25519_dispatch_pow_inv25519_implementation(impl))) return;
  if (impl >= 0) {
    crypto_pow = lib25519_dispatch_pow_inv25519(impl);
    printf("pow_inv25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_pow_inv25519_implementation(impl),lib25519_dispatch_pow_inv25519_compiler(impl));
  } else {
    crypto_pow = lib25519_pow_inv25519;
    printf("pow_inv25519 selected implementation %s compiler %s\n",lib25519_pow_inv25519_implementation(),lib25519_pow_inv25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(p2,p,plen);
      crypto_pow(q,p);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_pow");
      input_compare(p2,p,plen,"crypto_pow");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      crypto_pow(q2,p2);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_pow is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      crypto_pow(p2,p2);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_pow does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(pow_inv25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_pow_inv25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_pow_inv25519[precomp].qsize);
    input_prepare(p2,p,precomputed_pow_inv25519[precomp].psize);
    memcpy(p,precomputed_pow_inv25519[precomp].p,precomputed_pow_inv25519[precomp].psize);
    memcpy(p2,precomputed_pow_inv25519[precomp].p,precomputed_pow_inv25519[precomp].psize);
    crypto_pow(q,p);
    if (memcmp(q,precomputed_pow_inv25519[precomp].q,precomputed_pow_inv25519[precomp].qsize)) {
      fail("failure: crypto_pow fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_pow_inv25519[precomp].qsize;++pos) printf("%02x",precomputed_pow_inv25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_pow_inv25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_pow_inv25519[precomp].qsize,"crypto_pow");
    input_compare(p2,p,precomputed_pow_inv25519[precomp].psize,"crypto_pow");
  }
}

static void test_pow_inv25519(void)
{
  if (targeto && strcmp(targeto,"pow")) return;
  if (targetp && strcmp(targetp,"inv25519")) return;
  test_pow_inv25519_q = alignedcalloc(crypto_pow_BYTES);
  test_pow_inv25519_p = alignedcalloc(crypto_pow_BYTES);
  test_pow_inv25519_q2 = alignedcalloc(crypto_pow_BYTES);
  test_pow_inv25519_p2 = alignedcalloc(crypto_pow_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("pow_inv25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_pow_inv25519();++impl)
      forked(test_pow_inv25519_impl,impl);
    ++test_pow_inv25519_q;
    ++test_pow_inv25519_p;
    ++test_pow_inv25519_q2;
    ++test_pow_inv25519_p2;
  }
}
#undef crypto_pow_BYTES


/* ----- powbatch, derived from supercop/crypto_powbatch/try.c */
static const char *powbatch_inv25519_checksums[] = {
  "45b0b9dfeb75a7599064cbcd4fb3a5616105fe80f1dc7bf5258de9d1cb48c8e6",
  "9640b3e6b144ed3ef470ab7c8a24c30c18d951f36ca19890224c1ea3d7703317",
} ;

static void (*crypto_powbatch)(unsigned char *,const unsigned char *,long long);
#define crypto_powbatch_BYTES lib25519_powbatch_inv25519_BYTES

static unsigned char *test_powbatch_inv25519_q;
static unsigned char *test_powbatch_inv25519_p;
static unsigned char *test_powbatch_inv25519_q2;
static unsigned char *test_powbatch_inv25519_p2;

#define precomputed_powbatch_inv25519_NUM 170

static const unsigned char precomputed_powbatch_inv25519_q_0[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_0[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_1[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_1[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_2[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_2[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_3[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_3[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_4[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_4[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_5[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_5[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_6[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_6[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_7[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_7[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_8[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_8[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_9[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_9[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_10[] = {47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15};
static const unsigned char precomputed_powbatch_inv25519_p_10[] = {35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209};
static const unsigned char precomputed_powbatch_inv25519_q_11[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28};
static const unsigned char precomputed_powbatch_inv25519_p_11[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102};
static const unsigned char precomputed_powbatch_inv25519_q_12[] = {60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44};
static const unsigned char precomputed_powbatch_inv25519_p_12[] = {114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51};
static const unsigned char precomputed_powbatch_inv25519_q_13[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68};
static const unsigned char precomputed_powbatch_inv25519_p_13[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192};
static const unsigned char precomputed_powbatch_inv25519_q_14[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_powbatch_inv25519_p_14[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_15[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_15[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_16[] = {220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_powbatch_inv25519_p_16[] = {27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_powbatch_inv25519_q_17[] = {44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111};
static const unsigned char precomputed_powbatch_inv25519_p_17[] = {56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177};
static const unsigned char precomputed_powbatch_inv25519_q_18[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21};
static const unsigned char precomputed_powbatch_inv25519_p_18[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108};
static const unsigned char precomputed_powbatch_inv25519_q_19[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_powbatch_inv25519_p_19[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_20[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_powbatch_inv25519_p_20[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_powbatch_inv25519_q_21[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_21[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_22[] = {244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_powbatch_inv25519_p_22[] = {22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_23[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_powbatch_inv25519_p_23[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_24[] = {157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_24[] = {244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_25[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_25[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_26[] = {239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_26[] = {190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_27[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_powbatch_inv25519_p_27[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_powbatch_inv25519_q_28[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_28[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_29[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_powbatch_inv25519_p_29[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_30[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_powbatch_inv25519_p_30[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_powbatch_inv25519_q_31[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_powbatch_inv25519_p_31[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_powbatch_inv25519_q_32[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_powbatch_inv25519_p_32[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_powbatch_inv25519_q_33[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1};
static const unsigned char precomputed_powbatch_inv25519_p_33[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16};
static const unsigned char precomputed_powbatch_inv25519_q_34[] = {149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_powbatch_inv25519_p_34[] = {19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_powbatch_inv25519_q_35[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_35[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_36[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8};
static const unsigned char precomputed_powbatch_inv25519_p_36[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253};
static const unsigned char precomputed_powbatch_inv25519_q_37[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_powbatch_inv25519_p_37[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_powbatch_inv25519_q_38[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_38[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_39[] = {32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51};
static const unsigned char precomputed_powbatch_inv25519_p_39[] = {46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151};
static const unsigned char precomputed_powbatch_inv25519_q_40[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127};
static const unsigned char precomputed_powbatch_inv25519_p_40[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3};
static const unsigned char precomputed_powbatch_inv25519_q_41[] = {1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_powbatch_inv25519_p_41[] = {89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_42[] = {218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_powbatch_inv25519_p_42[] = {86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_43[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49};
static const unsigned char precomputed_powbatch_inv25519_p_43[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_44[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_44[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_45[] = {95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24};
static const unsigned char precomputed_powbatch_inv25519_p_45[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255};
static const unsigned char precomputed_powbatch_inv25519_q_46[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5};
static const unsigned char precomputed_powbatch_inv25519_p_46[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207};
static const unsigned char precomputed_powbatch_inv25519_q_47[] = {231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12};
static const unsigned char precomputed_powbatch_inv25519_p_47[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157};
static const unsigned char precomputed_powbatch_inv25519_q_48[] = {102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120};
static const unsigned char precomputed_powbatch_inv25519_p_48[] = {27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176};
static const unsigned char precomputed_powbatch_inv25519_q_49[] = {98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_powbatch_inv25519_p_49[] = {187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_50[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_powbatch_inv25519_p_50[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_powbatch_inv25519_q_51[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_powbatch_inv25519_p_51[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_52[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_powbatch_inv25519_p_52[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_53[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_p_53[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_q_54[] = {61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_54[] = {223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_55[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57};
static const unsigned char precomputed_powbatch_inv25519_p_55[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26};
static const unsigned char precomputed_powbatch_inv25519_q_56[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115};
static const unsigned char precomputed_powbatch_inv25519_p_56[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_57[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_57[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_58[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_58[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_59[] = {87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_powbatch_inv25519_p_59[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_powbatch_inv25519_q_60[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_powbatch_inv25519_p_60[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_61[] = {44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_powbatch_inv25519_p_61[] = {33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_62[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87};
static const unsigned char precomputed_powbatch_inv25519_p_62[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80};
static const unsigned char precomputed_powbatch_inv25519_q_63[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_63[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_64[] = {92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80};
static const unsigned char precomputed_powbatch_inv25519_p_64[] = {220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_65[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123};
static const unsigned char precomputed_powbatch_inv25519_p_65[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53};
static const unsigned char precomputed_powbatch_inv25519_q_66[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_powbatch_inv25519_p_66[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_powbatch_inv25519_q_67[] = {113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_powbatch_inv25519_p_67[] = {6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_68[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_68[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_69[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_69[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_70[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111};
static const unsigned char precomputed_powbatch_inv25519_p_70[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221};
static const unsigned char precomputed_powbatch_inv25519_q_71[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_powbatch_inv25519_p_71[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_powbatch_inv25519_q_72[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_powbatch_inv25519_p_72[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_powbatch_inv25519_q_73[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39};
static const unsigned char precomputed_powbatch_inv25519_p_73[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_74[] = {64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_powbatch_inv25519_p_74[] = {144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_powbatch_inv25519_q_75[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_75[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_76[] = {191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_powbatch_inv25519_p_76[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_77[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_powbatch_inv25519_p_77[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_78[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_powbatch_inv25519_p_78[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_powbatch_inv25519_q_79[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_powbatch_inv25519_p_79[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_80[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_80[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_81[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_p_81[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_82[] = {163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107};
static const unsigned char precomputed_powbatch_inv25519_p_82[] = {71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179};
static const unsigned char precomputed_powbatch_inv25519_q_83[] = {119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_powbatch_inv25519_p_83[] = {143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_84[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_powbatch_inv25519_p_84[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_powbatch_inv25519_q_85[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_powbatch_inv25519_p_85[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_86[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_powbatch_inv25519_p_86[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_87[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_87[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_88[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,183,19,131,62,107,60,139,25,159,81,252,127,241,150,167,10,86,224,76,177,199,197,197,80,104,31,181,26,122,42,200,107,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_powbatch_inv25519_p_88[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,81,108,252,226,91,123,2,58,201,115,182,53,216,106,226,19,255,189,15,42,27,210,228,103,255,63,80,6,101,105,24,137,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_89[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_powbatch_inv25519_p_89[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_powbatch_inv25519_q_90[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28};
static const unsigned char precomputed_powbatch_inv25519_p_90[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30};
static const unsigned char precomputed_powbatch_inv25519_q_91[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_powbatch_inv25519_p_91[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_powbatch_inv25519_q_92[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,30,77,35,14,207,56,225,204,214,84,214,43,10,5,131,1,232,164,48,194,28,249,10,221,177,149,235,251,97,74,211,10,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_92[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,108,209,156,236,156,166,225,245,1,255,55,161,87,186,87,163,186,173,58,130,239,62,58,38,221,97,184,184,72,35,198,201,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_93[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_powbatch_inv25519_p_93[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_powbatch_inv25519_q_94[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_p_94[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_q_95[] = {162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,176,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,45,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_powbatch_inv25519_p_95[] = {139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_powbatch_inv25519_q_96[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_96[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_97[] = {64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_powbatch_inv25519_p_97[] = {18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_98[] = {1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_98[] = {183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_99[] = {229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40};
static const unsigned char precomputed_powbatch_inv25519_p_99[] = {46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199};
static const unsigned char precomputed_powbatch_inv25519_q_100[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81};
static const unsigned char precomputed_powbatch_inv25519_p_100[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_101[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_powbatch_inv25519_p_101[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_102[] = {203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_powbatch_inv25519_p_102[] = {125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_103[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_powbatch_inv25519_p_103[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_104[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16};
static const unsigned char precomputed_powbatch_inv25519_p_104[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_105[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_105[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_106[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_powbatch_inv25519_p_106[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_powbatch_inv25519_q_107[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_107[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_108[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_powbatch_inv25519_p_108[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_powbatch_inv25519_q_109[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_powbatch_inv25519_p_109[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_110[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,89,198,80,48,244,56,47,214,227,188,88,156,193,94,9,89,75,209,109,178,3,109,160,247,107,98,103,234,213,41,188,13,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69};
static const unsigned char precomputed_powbatch_inv25519_p_110[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,91,94,189,239,65,25,164,16,97,157,57,15,98,46,197,53,97,137,208,106,56,113,72,246,21,174,146,118,48,34,127,250,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_111[] = {174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_111[] = {242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_112[] = {29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_powbatch_inv25519_p_112[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_powbatch_inv25519_q_113[] = {216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,99,201,196,169,55,97,250,40,141,136,16,157,64,175,118,170,88,177,140,160,7,30,114,150,4,66,180,241,24,77,251,24,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_powbatch_inv25519_p_113[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,172,37,106,178,186,134,115,186,94,177,212,105,200,72,126,162,183,252,84,234,71,113,123,115,27,145,22,179,65,52,126,200,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_114[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_powbatch_inv25519_p_114[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_powbatch_inv25519_q_115[] = {75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104};
static const unsigned char precomputed_powbatch_inv25519_p_115[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14};
static const unsigned char precomputed_powbatch_inv25519_q_116[] = {25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_116[] = {15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_117[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37};
static const unsigned char precomputed_powbatch_inv25519_p_117[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161};
static const unsigned char precomputed_powbatch_inv25519_q_118[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_p_118[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_119[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_powbatch_inv25519_p_119[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_powbatch_inv25519_q_120[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19};
static const unsigned char precomputed_powbatch_inv25519_p_120[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_121[] = {19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_121[] = {5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_122[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39};
static const unsigned char precomputed_powbatch_inv25519_p_122[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245};
static const unsigned char precomputed_powbatch_inv25519_q_123[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_powbatch_inv25519_p_123[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_124[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_124[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_125[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_p_125[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_126[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,172,154,20,26,177,187,189,219,238,205,20,135,222,148,10,180,45,77,167,230,85,220,108,93,190,152,222,115,194,46,238,38,107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67};
static const unsigned char precomputed_powbatch_inv25519_p_126[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,49,227,89,1,60,152,183,120,89,158,57,84,116,231,55,213,6,81,44,123,127,232,229,121,133,50,184,254,130,13,213,183,108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200};
static const unsigned char precomputed_powbatch_inv25519_q_127[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_127[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_128[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_128[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_129[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_powbatch_inv25519_p_129[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_130[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98};
static const unsigned char precomputed_powbatch_inv25519_p_130[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_131[] = {222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_131[] = {102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_132[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_powbatch_inv25519_p_132[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_powbatch_inv25519_q_133[] = {70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85};
static const unsigned char precomputed_powbatch_inv25519_p_133[] = {250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133};
static const unsigned char precomputed_powbatch_inv25519_q_134[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34};
static const unsigned char precomputed_powbatch_inv25519_p_134[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_135[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118};
static const unsigned char precomputed_powbatch_inv25519_p_135[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224};
static const unsigned char precomputed_powbatch_inv25519_q_136[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_powbatch_inv25519_p_136[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_powbatch_inv25519_q_137[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8};
static const unsigned char precomputed_powbatch_inv25519_p_137[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41};
static const unsigned char precomputed_powbatch_inv25519_q_138[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_powbatch_inv25519_p_138[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_powbatch_inv25519_q_139[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_powbatch_inv25519_p_139[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_140[] = {60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49,50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_powbatch_inv25519_p_140[] = {180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40,201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_141[] = {133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_powbatch_inv25519_p_141[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_142[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_142[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_143[] = {23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_143[] = {170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_144[] = {120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_powbatch_inv25519_p_144[] = {129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_145[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_145[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_146[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_powbatch_inv25519_p_146[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_147[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_powbatch_inv25519_p_147[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_powbatch_inv25519_q_148[] = {87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13};
static const unsigned char precomputed_powbatch_inv25519_p_148[] = {97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119};
static const unsigned char precomputed_powbatch_inv25519_q_149[] = {113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_powbatch_inv25519_p_149[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_powbatch_inv25519_q_150[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_powbatch_inv25519_p_150[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_151[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21,89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_151[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255,168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_152[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,139,217,27,238,113,28,242,233,76,16,196,238,215,96,153,61,0,64,134,198,20,205,154,208,84,164,135,54,153,95,4,126,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21};
static const unsigned char precomputed_powbatch_inv25519_p_152[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,189,68,80,58,53,159,69,72,96,63,22,164,219,217,177,104,30,162,150,170,40,227,107,49,103,70,18,244,141,182,4,120,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155};
static const unsigned char precomputed_powbatch_inv25519_q_153[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_powbatch_inv25519_p_153[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_powbatch_inv25519_q_154[] = {255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92};
static const unsigned char precomputed_powbatch_inv25519_p_154[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_155[] = {230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_powbatch_inv25519_p_155[] = {16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_powbatch_inv25519_q_156[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_156[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_157[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_157[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_158[] = {87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105};
static const unsigned char precomputed_powbatch_inv25519_p_158[] = {102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234};
static const unsigned char precomputed_powbatch_inv25519_q_159[] = {88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125};
static const unsigned char precomputed_powbatch_inv25519_p_159[] = {174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146};
static const unsigned char precomputed_powbatch_inv25519_q_160[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_160[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_161[] = {126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_powbatch_inv25519_p_161[] = {25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_powbatch_inv25519_q_162[] = {26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_powbatch_inv25519_p_162[] = {67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_powbatch_inv25519_q_163[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_powbatch_inv25519_p_163[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_powbatch_inv25519_q_164[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_p_164[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_q_165[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_powbatch_inv25519_p_165[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_166[] = {186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8,24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_powbatch_inv25519_p_166[] = {54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41,210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_167[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_powbatch_inv25519_p_167[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_168[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,58,222,210,172,117,119,57,61,224,20,29,150,221,44,144,70,140,51,231,175,210,153,37,88,146,194,225,169,73,158,19,113,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_powbatch_inv25519_p_168[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,192,151,177,212,242,244,63,100,18,73,46,25,215,142,32,185,134,95,138,231,167,29,123,189,146,175,242,71,212,160,210,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_powbatch_inv25519_q_169[] = {100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_169[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *p;
  long long psize;
  long long batch;
} precomputed_powbatch_inv25519[precomputed_powbatch_inv25519_NUM] = {
  {
    precomputed_powbatch_inv25519_q_0,0,
    precomputed_powbatch_inv25519_p_0,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_1,0,
    precomputed_powbatch_inv25519_p_1,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_2,0,
    precomputed_powbatch_inv25519_p_2,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_3,0,
    precomputed_powbatch_inv25519_p_3,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_4,0,
    precomputed_powbatch_inv25519_p_4,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_5,0,
    precomputed_powbatch_inv25519_p_5,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_6,0,
    precomputed_powbatch_inv25519_p_6,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_7,0,
    precomputed_powbatch_inv25519_p_7,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_8,0,
    precomputed_powbatch_inv25519_p_8,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_9,0,
    precomputed_powbatch_inv25519_p_9,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_10,32,
    precomputed_powbatch_inv25519_p_10,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_11,32,
    precomputed_powbatch_inv25519_p_11,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_12,32,
    precomputed_powbatch_inv25519_p_12,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_13,32,
    precomputed_powbatch_inv25519_p_13,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_14,32,
    precomputed_powbatch_inv25519_p_14,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_15,32,
    precomputed_powbatch_inv25519_p_15,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_16,32,
    precomputed_powbatch_inv25519_p_16,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_17,32,
    precomputed_powbatch_inv25519_p_17,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_18,32,
    precomputed_powbatch_inv25519_p_18,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_19,32,
    precomputed_powbatch_inv25519_p_19,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_20,64,
    precomputed_powbatch_inv25519_p_20,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_21,64,
    precomputed_powbatch_inv25519_p_21,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_22,64,
    precomputed_powbatch_inv25519_p_22,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_23,64,
    precomputed_powbatch_inv25519_p_23,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_24,64,
    precomputed_powbatch_inv25519_p_24,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_25,64,
    precomputed_powbatch_inv25519_p_25,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_26,64,
    precomputed_powbatch_inv25519_p_26,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_27,64,
    precomputed_powbatch_inv25519_p_27,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_28,64,
    precomputed_powbatch_inv25519_p_28,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_29,64,
    precomputed_powbatch_inv25519_p_29,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_30,96,
    precomputed_powbatch_inv25519_p_30,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_31,96,
    precomputed_powbatch_inv25519_p_31,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_32,96,
    precomputed_powbatch_inv25519_p_32,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_33,96,
    precomputed_powbatch_inv25519_p_33,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_34,96,
    precomputed_powbatch_inv25519_p_34,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_35,96,
    precomputed_powbatch_inv25519_p_35,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_36,96,
    precomputed_powbatch_inv25519_p_36,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_37,96,
    precomputed_powbatch_inv25519_p_37,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_38,96,
    precomputed_powbatch_inv25519_p_38,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_39,96,
    precomputed_powbatch_inv25519_p_39,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_40,128,
    precomputed_powbatch_inv25519_p_40,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_41,128,
    precomputed_powbatch_inv25519_p_41,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_42,128,
    precomputed_powbatch_inv25519_p_42,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_43,128,
    precomputed_powbatch_inv25519_p_43,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_44,128,
    precomputed_powbatch_inv25519_p_44,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_45,128,
    precomputed_powbatch_inv25519_p_45,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_46,128,
    precomputed_powbatch_inv25519_p_46,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_47,128,
    precomputed_powbatch_inv25519_p_47,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_48,128,
    precomputed_powbatch_inv25519_p_48,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_49,128,
    precomputed_powbatch_inv25519_p_49,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_50,160,
    precomputed_powbatch_inv25519_p_50,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_51,160,
    precomputed_powbatch_inv25519_p_51,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_52,160,
    precomputed_powbatch_inv25519_p_52,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_53,160,
    precomputed_powbatch_inv25519_p_53,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_54,160,
    precomputed_powbatch_inv25519_p_54,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_55,160,
    precomputed_powbatch_inv25519_p_55,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_56,160,
    precomputed_powbatch_inv25519_p_56,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_57,160,
    precomputed_powbatch_inv25519_p_57,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_58,160,
    precomputed_powbatch_inv25519_p_58,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_59,160,
    precomputed_powbatch_inv25519_p_59,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_60,192,
    precomputed_powbatch_inv25519_p_60,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_61,192,
    precomputed_powbatch_inv25519_p_61,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_62,192,
    precomputed_powbatch_inv25519_p_62,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_63,192,
    precomputed_powbatch_inv25519_p_63,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_64,192,
    precomputed_powbatch_inv25519_p_64,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_65,192,
    precomputed_powbatch_inv25519_p_65,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_66,192,
    precomputed_powbatch_inv25519_p_66,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_67,192,
    precomputed_powbatch_inv25519_p_67,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_68,192,
    precomputed_powbatch_inv25519_p_68,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_69,192,
    precomputed_powbatch_inv25519_p_69,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_70,224,
    precomputed_powbatch_inv25519_p_70,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_71,224,
    precomputed_powbatch_inv25519_p_71,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_72,224,
    precomputed_powbatch_inv25519_p_72,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_73,224,
    precomputed_powbatch_inv25519_p_73,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_74,224,
    precomputed_powbatch_inv25519_p_74,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_75,224,
    precomputed_powbatch_inv25519_p_75,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_76,224,
    precomputed_powbatch_inv25519_p_76,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_77,224,
    precomputed_powbatch_inv25519_p_77,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_78,224,
    precomputed_powbatch_inv25519_p_78,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_79,224,
    precomputed_powbatch_inv25519_p_79,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_80,256,
    precomputed_powbatch_inv25519_p_80,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_81,256,
    precomputed_powbatch_inv25519_p_81,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_82,256,
    precomputed_powbatch_inv25519_p_82,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_83,256,
    precomputed_powbatch_inv25519_p_83,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_84,256,
    precomputed_powbatch_inv25519_p_84,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_85,256,
    precomputed_powbatch_inv25519_p_85,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_86,256,
    precomputed_powbatch_inv25519_p_86,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_87,256,
    precomputed_powbatch_inv25519_p_87,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_88,256,
    precomputed_powbatch_inv25519_p_88,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_89,256,
    precomputed_powbatch_inv25519_p_89,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_90,288,
    precomputed_powbatch_inv25519_p_90,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_91,288,
    precomputed_powbatch_inv25519_p_91,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_92,288,
    precomputed_powbatch_inv25519_p_92,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_93,288,
    precomputed_powbatch_inv25519_p_93,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_94,288,
    precomputed_powbatch_inv25519_p_94,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_95,288,
    precomputed_powbatch_inv25519_p_95,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_96,288,
    precomputed_powbatch_inv25519_p_96,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_97,288,
    precomputed_powbatch_inv25519_p_97,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_98,288,
    precomputed_powbatch_inv25519_p_98,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_99,288,
    precomputed_powbatch_inv25519_p_99,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_100,320,
    precomputed_powbatch_inv25519_p_100,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_101,320,
    precomputed_powbatch_inv25519_p_101,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_102,320,
    precomputed_powbatch_inv25519_p_102,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_103,320,
    precomputed_powbatch_inv25519_p_103,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_104,320,
    precomputed_powbatch_inv25519_p_104,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_105,320,
    precomputed_powbatch_inv25519_p_105,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_106,320,
    precomputed_powbatch_inv25519_p_106,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_107,320,
    precomputed_powbatch_inv25519_p_107,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_108,320,
    precomputed_powbatch_inv25519_p_108,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_109,320,
    precomputed_powbatch_inv25519_p_109,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_110,352,
    precomputed_powbatch_inv25519_p_110,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_111,352,
    precomputed_powbatch_inv25519_p_111,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_112,352,
    precomputed_powbatch_inv25519_p_112,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_113,352,
    precomputed_powbatch_inv25519_p_113,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_114,352,
    precomputed_powbatch_inv25519_p_114,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_115,352,
    precomputed_powbatch_inv25519_p_115,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_116,352,
    precomputed_powbatch_inv25519_p_116,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_117,352,
    precomputed_powbatch_inv25519_p_117,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_118,352,
    precomputed_powbatch_inv25519_p_118,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_119,352,
    precomputed_powbatch_inv25519_p_119,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_120,384,
    precomputed_powbatch_inv25519_p_120,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_121,384,
    precomputed_powbatch_inv25519_p_121,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_122,384,
    precomputed_powbatch_inv25519_p_122,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_123,384,
    precomputed_powbatch_inv25519_p_123,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_124,384,
    precomputed_powbatch_inv25519_p_124,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_125,384,
    precomputed_powbatch_inv25519_p_125,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_126,384,
    precomputed_powbatch_inv25519_p_126,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_127,384,
    precomputed_powbatch_inv25519_p_127,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_128,384,
    precomputed_powbatch_inv25519_p_128,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_129,384,
    precomputed_powbatch_inv25519_p_129,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_130,416,
    precomputed_powbatch_inv25519_p_130,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_131,416,
    precomputed_powbatch_inv25519_p_131,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_132,416,
    precomputed_powbatch_inv25519_p_132,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_133,416,
    precomputed_powbatch_inv25519_p_133,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_134,416,
    precomputed_powbatch_inv25519_p_134,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_135,416,
    precomputed_powbatch_inv25519_p_135,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_136,416,
    precomputed_powbatch_inv25519_p_136,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_137,416,
    precomputed_powbatch_inv25519_p_137,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_138,416,
    precomputed_powbatch_inv25519_p_138,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_139,416,
    precomputed_powbatch_inv25519_p_139,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_140,448,
    precomputed_powbatch_inv25519_p_140,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_141,448,
    precomputed_powbatch_inv25519_p_141,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_142,448,
    precomputed_powbatch_inv25519_p_142,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_143,448,
    precomputed_powbatch_inv25519_p_143,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_144,448,
    precomputed_powbatch_inv25519_p_144,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_145,448,
    precomputed_powbatch_inv25519_p_145,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_146,448,
    precomputed_powbatch_inv25519_p_146,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_147,448,
    precomputed_powbatch_inv25519_p_147,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_148,448,
    precomputed_powbatch_inv25519_p_148,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_149,448,
    precomputed_powbatch_inv25519_p_149,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_150,480,
    precomputed_powbatch_inv25519_p_150,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_151,480,
    precomputed_powbatch_inv25519_p_151,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_152,480,
    precomputed_powbatch_inv25519_p_152,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_153,480,
    precomputed_powbatch_inv25519_p_153,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_154,480,
    precomputed_powbatch_inv25519_p_154,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_155,480,
    precomputed_powbatch_inv25519_p_155,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_156,480,
    precomputed_powbatch_inv25519_p_156,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_157,480,
    precomputed_powbatch_inv25519_p_157,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_158,480,
    precomputed_powbatch_inv25519_p_158,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_159,480,
    precomputed_powbatch_inv25519_p_159,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_160,512,
    precomputed_powbatch_inv25519_p_160,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_161,512,
    precomputed_powbatch_inv25519_p_161,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_162,512,
    precomputed_powbatch_inv25519_p_162,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_163,512,
    precomputed_powbatch_inv25519_p_163,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_164,512,
    precomputed_powbatch_inv25519_p_164,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_165,512,
    precomputed_powbatch_inv25519_p_165,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_166,512,
    precomputed_powbatch_inv25519_p_166,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_167,512,
    precomputed_powbatch_inv25519_p_167,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_168,512,
    precomputed_powbatch_inv25519_p_168,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_169,512,
    precomputed_powbatch_inv25519_p_169,512,
    16,
  },
} ;

static void test_powbatch_inv25519_impl(long long impl)
{
  unsigned char *q = test_powbatch_inv25519_q;
  unsigned char *p = test_powbatch_inv25519_p;
  unsigned char *q2 = test_powbatch_inv25519_q2;
  unsigned char *p2 = test_powbatch_inv25519_p2;
  long long qlen;
  long long plen;

  if (targeti && strcmp(targeti,lib25519_dispatch_powbatch_inv25519_implementation(impl))) return;
  if (impl >= 0) {
    crypto_powbatch = lib25519_dispatch_powbatch_inv25519(impl);
    printf("powbatch_inv25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_powbatch_inv25519_implementation(impl),lib25519_dispatch_powbatch_inv25519_compiler(impl));
  } else {
    crypto_powbatch = lib25519_powbatch_inv25519;
    printf("powbatch_inv25519 selected implementation %s compiler %s\n",lib25519_powbatch_inv25519_implementation(),lib25519_powbatch_inv25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;
    long long maxtest = checksumbig ? 128 : 16;
    long long mlen;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      qlen = mlen * crypto_powbatch_BYTES;
      plen = mlen * crypto_powbatch_BYTES;
      output_prepare(q2,q,qlen);
      input_prepare(p2,p,plen);
      crypto_powbatch(q,p,mlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_powbatch");
      input_compare(p2,p,plen,"crypto_powbatch");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      crypto_powbatch(q2,p2,mlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_powbatch is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      crypto_powbatch(p2,p2,mlen);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_powbatch does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(powbatch_inv25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_powbatch_inv25519_NUM;++precomp) {
    long long mlen = precomputed_powbatch_inv25519[precomp].batch;
    output_prepare(q2,q,precomputed_powbatch_inv25519[precomp].qsize);
    input_prepare(p2,p,precomputed_powbatch_inv25519[precomp].psize);
    memcpy(p,precomputed_powbatch_inv25519[precomp].p,precomputed_powbatch_inv25519[precomp].psize);
    memcpy(p2,precomputed_powbatch_inv25519[precomp].p,precomputed_powbatch_inv25519[precomp].psize);
    crypto_powbatch(q,p,mlen);
    if (memcmp(q,precomputed_powbatch_inv25519[precomp].q,precomputed_powbatch_inv25519[precomp].qsize)) {
      fail("failure: crypto_powbatch fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_powbatch_inv25519[precomp].qsize;++pos) printf("%02x",precomputed_powbatch_inv25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_powbatch_inv25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_powbatch_inv25519[precomp].qsize,"crypto_powbatch");
    input_compare(p2,p,precomputed_powbatch_inv25519[precomp].psize,"crypto_powbatch");
  }
}

static void test_powbatch_inv25519(void)
{
  if (targeto && strcmp(targeto,"powbatch")) return;
  if (targetp && strcmp(targetp,"inv25519")) return;
  test_powbatch_inv25519_q = alignedcalloc(128*crypto_powbatch_BYTES);
  test_powbatch_inv25519_p = alignedcalloc(128*crypto_powbatch_BYTES);
  test_powbatch_inv25519_q2 = alignedcalloc(128*crypto_powbatch_BYTES);
  test_powbatch_inv25519_p2 = alignedcalloc(128*crypto_powbatch_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("powbatch_inv25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_powbatch_inv25519();++impl)
      forked(test_powbatch_inv25519_impl,impl);
    ++test_powbatch_inv25519_q;
    ++test_powbatch_inv25519_p;
    ++test_powbatch_inv25519_q2;
    ++test_powbatch_inv25519_p2;
  }
}
#undef crypto_powbatch_BYTES


/* ----- nP, derived from supercop/crypto_nP/try.c */
static const char *nP_montgomery25519_checksums[] = {
  "b861d66109b42359e5994ed57ae566827c345b65a9d0671700320b82888397ec",
  "740924011f3448f65299f61b087f74a6eb9651a4203dfbf621d2bec54e149405",
} ;

static void (*crypto_nP)(unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_nP_SCALARBYTES lib25519_nP_montgomery25519_SCALARBYTES
#define crypto_nP_POINTBYTES lib25519_nP_montgomery25519_POINTBYTES

static unsigned char *test_nP_montgomery25519_q;
static unsigned char *test_nP_montgomery25519_n;
static unsigned char *test_nP_montgomery25519_p;
static unsigned char *test_nP_montgomery25519_q2;
static unsigned char *test_nP_montgomery25519_n2;
static unsigned char *test_nP_montgomery25519_p2;

#define precomputed_nP_montgomery25519_NUM 372

static const unsigned char precomputed_nP_montgomery25519_q_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_0[] = {22,165,108,86,5,154,20,29,152,42,38,184,15,197,6,22,9,228,189,48,3,19,228,73,57,251,178,27,117,180,121,83};
static const unsigned char precomputed_nP_montgomery25519_p_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_1[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_1[] = {139,146,167,138,83,58,254,190,251,60,110,156,52,211,217,116,28,175,54,171,72,205,88,250,162,123,91,36,201,104,201,225};
static const unsigned char precomputed_nP_montgomery25519_p_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_2[] = {129,42,27,226,56,122,209,122,33,165,197,59,204,245,117,180,65,210,211,35,205,129,134,7,75,25,155,208,55,142,9,28};
static const unsigned char precomputed_nP_montgomery25519_n_2[] = {40,99,197,149,12,76,46,216,65,163,184,95,88,169,52,102,10,143,162,20,164,177,134,75,36,187,91,135,65,113,164,111};
static const unsigned char precomputed_nP_montgomery25519_p_2[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_3[] = {162,93,163,159,20,188,94,13,51,72,116,75,189,214,110,123,124,9,238,31,79,7,237,111,225,81,4,77,40,149,130,82};
static const unsigned char precomputed_nP_montgomery25519_n_3[] = {249,136,238,59,164,86,241,133,205,15,12,226,199,113,49,1,247,239,150,87,31,12,54,21,210,187,99,46,64,166,182,166};
static const unsigned char precomputed_nP_montgomery25519_p_3[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_4[] = {121,223,164,139,202,179,32,228,109,181,229,181,139,0,181,124,140,230,145,47,130,223,137,147,17,118,27,113,92,100,228,98};
static const unsigned char precomputed_nP_montgomery25519_n_4[] = {45,15,68,93,105,161,236,142,132,222,64,65,61,38,44,243,32,161,134,170,84,232,175,213,242,206,236,93,30,166,38,12};
static const unsigned char precomputed_nP_montgomery25519_p_4[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_5[] = {239,133,37,52,169,133,200,97,68,65,139,30,226,202,18,162,33,55,136,193,253,245,29,8,169,139,55,159,251,46,166,107};
static const unsigned char precomputed_nP_montgomery25519_n_5[] = {66,162,214,17,77,227,115,67,248,216,210,73,216,96,172,93,126,63,38,233,228,89,232,80,113,127,88,112,85,247,241,224};
static const unsigned char precomputed_nP_montgomery25519_p_5[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_6[] = {66,245,111,3,98,139,24,189,155,145,236,234,46,217,98,153,28,247,110,223,14,222,218,185,48,86,154,56,134,240,21,93};
static const unsigned char precomputed_nP_montgomery25519_n_6[] = {176,167,216,65,10,75,148,78,76,151,92,161,168,237,252,14,170,191,18,24,113,151,192,59,92,204,29,110,25,193,162,76};
static const unsigned char precomputed_nP_montgomery25519_p_6[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_7[] = {85,216,96,126,239,24,171,238,158,88,201,26,202,187,130,154,241,114,114,95,95,29,6,98,33,120,172,125,108,180,197,114};
static const unsigned char precomputed_nP_montgomery25519_n_7[] = {190,147,100,101,77,151,179,249,20,102,182,218,161,187,38,207,142,126,195,32,205,249,96,90,162,80,63,226,98,120,239,127};
static const unsigned char precomputed_nP_montgomery25519_p_7[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_8[] = {247,143,27,107,199,100,117,167,157,168,246,0,110,30,208,91,218,135,95,226,47,159,110,22,230,94,31,219,179,141,240,71};
static const unsigned char precomputed_nP_montgomery25519_n_8[] = {147,215,107,156,104,176,12,226,26,128,179,131,210,202,169,59,227,81,62,36,35,82,151,139,126,209,74,57,26,207,219,102};
static const unsigned char precomputed_nP_montgomery25519_p_8[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_9[] = {8,230,182,92,48,214,174,119,128,155,246,232,247,243,230,27,18,49,135,212,35,67,70,253,49,55,189,111,188,19,5,108};
static const unsigned char precomputed_nP_montgomery25519_n_9[] = {132,175,87,38,2,127,24,123,10,20,230,220,70,101,14,168,26,154,32,108,78,93,106,112,2,147,7,146,149,82,157,35};
static const unsigned char precomputed_nP_montgomery25519_p_9[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_10[] = {135,110,236,86,44,66,16,135,102,160,234,251,75,169,40,162,23,252,170,56,119,186,208,82,4,133,157,1,170,36,83,77};
static const unsigned char precomputed_nP_montgomery25519_n_10[] = {193,95,146,115,121,195,161,67,226,160,12,126,178,128,86,146,245,113,187,78,36,100,116,199,49,41,122,79,39,152,203,40};
static const unsigned char precomputed_nP_montgomery25519_p_10[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_11[] = {177,112,232,197,251,252,99,183,10,138,35,150,194,24,91,208,73,35,104,140,114,246,168,207,34,63,19,124,216,198,168,44};
static const unsigned char precomputed_nP_montgomery25519_n_11[] = {236,45,18,11,37,163,223,201,31,238,132,192,1,225,170,91,70,220,130,111,139,208,93,86,211,22,147,29,9,165,75,251};
static const unsigned char precomputed_nP_montgomery25519_p_11[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_12[] = {147,18,46,232,128,232,34,246,212,145,27,134,255,227,150,31,236,60,94,72,20,254,53,138,162,159,253,128,210,223,193,23};
static const unsigned char precomputed_nP_montgomery25519_n_12[] = {214,148,177,62,22,252,2,219,156,203,249,78,135,68,219,13,25,181,42,250,161,197,21,221,181,140,175,242,30,162,164,254};
static const unsigned char precomputed_nP_montgomery25519_p_12[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_13[] = {91,38,221,90,220,250,249,107,234,224,251,4,109,192,201,181,132,216,71,254,152,204,74,202,124,239,186,53,86,16,183,55};
static const unsigned char precomputed_nP_montgomery25519_n_13[] = {19,146,48,164,180,234,202,31,98,230,250,183,198,75,6,104,144,119,247,32,46,71,235,138,229,32,112,138,58,243,13,152};
static const unsigned char precomputed_nP_montgomery25519_p_13[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_14[] = {141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48};
static const unsigned char precomputed_nP_montgomery25519_n_14[] = {40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139};
static const unsigned char precomputed_nP_montgomery25519_p_14[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_15[] = {217,115,32,35,66,144,65,8,25,143,191,82,225,61,129,97,90,4,150,71,57,17,1,231,14,199,229,207,221,174,89,13};
static const unsigned char precomputed_nP_montgomery25519_n_15[] = {2,222,22,131,160,78,116,188,224,216,251,122,243,253,84,123,180,252,82,233,141,218,42,150,213,250,32,17,174,233,198,144};
static const unsigned char precomputed_nP_montgomery25519_p_15[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_16[] = {168,30,239,136,43,9,85,111,60,43,82,60,196,16,54,69,36,18,140,202,217,195,39,26,118,7,90,218,115,19,147,79};
static const unsigned char precomputed_nP_montgomery25519_n_16[] = {128,119,130,105,236,245,3,235,114,211,107,56,5,89,175,50,3,46,15,154,32,145,30,229,124,32,44,50,136,214,58,70};
static const unsigned char precomputed_nP_montgomery25519_p_16[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_17[] = {186,206,120,110,192,152,199,91,199,20,152,117,205,170,37,52,176,120,41,54,230,114,120,138,135,222,72,41,155,2,120,95};
static const unsigned char precomputed_nP_montgomery25519_n_17[] = {76,10,122,92,95,60,108,66,87,202,172,123,231,241,121,153,60,13,209,184,200,16,84,74,62,81,89,106,177,149,201,7};
static const unsigned char precomputed_nP_montgomery25519_p_17[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_18[] = {8,100,222,18,220,20,218,99,254,188,214,171,119,88,234,228,50,86,45,103,188,156,0,91,129,17,52,149,192,244,246,108};
static const unsigned char precomputed_nP_montgomery25519_n_18[] = {145,52,243,43,154,181,28,84,69,217,127,105,124,26,144,86,194,239,44,38,126,15,220,245,35,24,159,43,124,97,207,182};
static const unsigned char precomputed_nP_montgomery25519_p_18[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_19[] = {38,75,14,165,222,53,13,233,72,76,179,164,11,252,190,89,47,54,76,98,36,68,200,205,16,81,242,128,73,117,120,89};
static const unsigned char precomputed_nP_montgomery25519_n_19[] = {146,211,172,10,196,116,198,246,17,89,234,39,110,19,252,7,180,188,59,196,241,55,208,72,179,169,75,88,153,141,37,3};
static const unsigned char precomputed_nP_montgomery25519_p_19[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_20[] = {45,251,59,61,97,219,78,236,93,144,47,91,181,225,215,145,201,10,128,250,30,245,216,88,147,237,63,156,243,103,228,122};
static const unsigned char precomputed_nP_montgomery25519_n_20[] = {212,156,146,156,127,229,232,48,160,29,227,173,107,76,56,36,21,111,10,90,192,138,249,203,182,138,92,200,128,190,180,32};
static const unsigned char precomputed_nP_montgomery25519_p_20[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_21[] = {130,247,47,178,248,52,54,192,213,119,42,9,99,242,192,111,160,106,220,145,217,226,58,89,18,9,81,100,252,221,221,46};
static const unsigned char precomputed_nP_montgomery25519_n_21[] = {238,205,118,104,224,32,1,124,103,246,230,131,211,47,8,131,118,55,85,122,152,0,26,90,147,81,190,53,208,236,202,243};
static const unsigned char precomputed_nP_montgomery25519_p_21[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_22[] = {110,7,125,207,66,148,213,123,27,131,1,51,171,70,41,235,248,209,1,139,29,117,199,115,19,229,10,124,38,119,167,95};
static const unsigned char precomputed_nP_montgomery25519_n_22[] = {184,255,235,31,96,215,85,15,110,246,97,134,39,210,12,132,239,67,247,243,236,62,204,71,15,198,95,132,56,102,223,48};
static const unsigned char precomputed_nP_montgomery25519_p_22[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_23[] = {121,232,151,106,249,132,75,30,73,205,71,105,61,158,181,131,150,161,64,69,138,140,30,8,40,61,72,109,102,207,107,46};
static const unsigned char precomputed_nP_montgomery25519_n_23[] = {176,21,36,69,234,239,12,133,189,95,127,247,243,129,176,233,252,210,8,4,62,179,45,71,132,151,131,142,107,226,149,82};
static const unsigned char precomputed_nP_montgomery25519_p_23[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_24[] = {189,197,102,194,52,207,156,183,67,27,246,1,63,74,157,164,178,75,166,128,84,36,11,214,239,86,170,86,145,66,109,117};
static const unsigned char precomputed_nP_montgomery25519_n_24[] = {197,131,147,67,59,184,171,62,161,63,145,185,219,190,36,179,208,35,161,239,97,250,147,78,155,122,131,84,222,20,255,57};
static const unsigned char precomputed_nP_montgomery25519_p_24[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_25[] = {198,237,17,59,13,46,43,8,99,121,23,190,202,234,240,252,155,193,97,152,217,159,15,251,82,54,246,226,180,134,32,123};
static const unsigned char precomputed_nP_montgomery25519_n_25[] = {220,255,225,12,119,108,43,211,239,127,106,206,117,125,148,215,84,165,157,177,185,39,226,94,196,90,235,111,149,251,106,228};
static const unsigned char precomputed_nP_montgomery25519_p_25[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_26[] = {171,226,12,187,31,76,168,13,76,46,35,191,62,137,48,2,209,188,191,149,42,154,3,16,133,1,173,136,97,149,120,43};
static const unsigned char precomputed_nP_montgomery25519_n_26[] = {1,28,90,119,160,181,243,45,18,11,199,48,127,45,242,31,193,80,42,66,154,199,187,183,101,84,43,245,158,152,45,188};
static const unsigned char precomputed_nP_montgomery25519_p_26[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_27[] = {161,223,243,227,234,158,42,211,46,211,205,39,166,23,202,203,26,65,220,32,37,204,145,199,242,178,16,111,221,227,215,116};
static const unsigned char precomputed_nP_montgomery25519_n_27[] = {128,211,202,5,133,44,165,24,11,106,41,213,148,126,225,3,196,79,227,38,11,161,243,167,11,73,135,245,143,32,105,241};
static const unsigned char precomputed_nP_montgomery25519_p_27[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_28[] = {227,16,183,177,15,162,157,55,149,46,188,120,29,196,13,218,249,145,106,62,56,120,249,64,11,212,158,254,153,222,134,102};
static const unsigned char precomputed_nP_montgomery25519_n_28[] = {105,78,213,136,250,153,54,196,78,209,104,98,206,228,99,111,100,117,226,107,188,69,131,53,250,81,161,57,154,75,186,86};
static const unsigned char precomputed_nP_montgomery25519_p_28[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_29[] = {123,3,226,18,231,250,54,63,5,20,66,86,154,30,243,71,196,222,234,139,221,232,16,130,78,97,139,198,176,238,220,27};
static const unsigned char precomputed_nP_montgomery25519_n_29[] = {103,233,237,136,26,9,199,182,184,122,105,253,11,251,200,159,239,173,81,83,253,65,193,123,246,147,153,39,103,241,131,206};
static const unsigned char precomputed_nP_montgomery25519_p_29[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_30[] = {15,216,90,115,25,121,207,41,112,66,176,118,79,176,85,9,162,102,135,200,230,98,135,24,229,37,74,23,87,146,107,75};
static const unsigned char precomputed_nP_montgomery25519_n_30[] = {88,208,32,95,60,24,182,214,242,35,2,43,181,126,241,232,103,169,202,71,248,100,223,15,81,170,105,233,181,20,139,143};
static const unsigned char precomputed_nP_montgomery25519_p_30[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_31[] = {167,69,92,82,21,33,118,83,239,21,209,140,157,76,171,158,207,12,119,240,246,209,154,135,0,78,7,81,200,101,186,99};
static const unsigned char precomputed_nP_montgomery25519_n_31[] = {251,163,38,67,159,49,110,10,31,29,115,131,183,15,141,31,33,127,239,142,94,23,75,0,189,146,169,229,4,13,46,20};
static const unsigned char precomputed_nP_montgomery25519_p_31[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_32[] = {8,139,160,142,177,217,68,114,183,108,120,157,4,55,210,197,122,181,154,109,149,1,44,118,166,30,19,188,14,141,44,35};
static const unsigned char precomputed_nP_montgomery25519_n_32[] = {99,8,10,186,138,69,61,254,102,60,148,169,218,139,116,20,156,161,166,38,77,146,150,224,159,120,161,205,114,242,117,201};
static const unsigned char precomputed_nP_montgomery25519_p_32[] = {111,18,243,62,180,93,101,187,23,73,13,39,192,139,194,106,10,72,242,42,183,238,122,107,144,57,141,20,210,163,142,0};
static const unsigned char precomputed_nP_montgomery25519_q_33[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_33[] = {173,229,74,44,190,251,221,217,123,144,158,53,116,65,212,153,140,78,191,166,177,29,200,208,116,177,250,141,151,172,255,18};
static const unsigned char precomputed_nP_montgomery25519_p_33[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_nP_montgomery25519_q_34[] = {81,212,247,2,165,203,138,13,12,188,47,181,141,146,236,57,186,2,196,20,129,165,17,228,157,55,212,222,126,114,58,74};
static const unsigned char precomputed_nP_montgomery25519_n_34[] = {86,113,216,237,144,237,27,77,43,86,221,218,78,165,92,68,2,121,158,174,144,41,197,225,133,57,198,150,193,205,31,80};
static const unsigned char precomputed_nP_montgomery25519_p_34[] = {245,196,70,99,114,97,152,96,91,20,31,160,88,52,151,161,94,92,11,177,23,242,92,137,253,43,147,168,159,120,99,3};
static const unsigned char precomputed_nP_montgomery25519_q_35[] = {228,228,179,142,119,218,163,179,18,100,15,16,219,88,146,63,140,252,124,190,66,108,232,165,55,163,242,240,143,207,151,79};
static const unsigned char precomputed_nP_montgomery25519_n_35[] = {253,78,2,197,246,2,80,67,175,244,59,34,195,228,158,234,134,91,114,225,55,146,120,105,181,188,229,205,129,46,176,76};
static const unsigned char precomputed_nP_montgomery25519_p_35[] = {38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5};
static const unsigned char precomputed_nP_montgomery25519_q_36[] = {205,232,203,120,115,196,192,76,184,227,29,204,114,160,206,2,164,87,199,142,87,173,42,249,6,168,123,162,43,50,233,87};
static const unsigned char precomputed_nP_montgomery25519_n_36[] = {100,157,37,78,181,39,219,183,230,127,78,28,20,217,129,180,250,127,193,234,24,210,28,32,124,140,0,239,47,98,237,54};
static const unsigned char precomputed_nP_montgomery25519_p_36[] = {180,140,35,108,225,133,69,227,5,99,158,116,180,144,160,84,162,70,208,203,161,213,101,113,83,32,64,115,124,202,72,8};
static const unsigned char precomputed_nP_montgomery25519_q_37[] = {116,162,107,174,184,107,105,141,168,164,21,209,119,243,166,176,21,209,28,31,65,131,190,203,128,255,94,131,55,69,185,35};
static const unsigned char precomputed_nP_montgomery25519_n_37[] = {118,77,87,240,2,224,102,178,26,241,208,238,205,43,49,10,248,202,177,174,221,204,149,132,117,236,242,182,0,197,71,99};
static const unsigned char precomputed_nP_montgomery25519_p_37[] = {95,70,199,15,156,222,195,114,220,234,120,29,41,57,178,200,195,111,57,87,200,244,18,3,131,83,38,147,255,157,82,11};
static const unsigned char precomputed_nP_montgomery25519_q_38[] = {20,96,92,201,136,69,10,113,254,74,165,39,25,79,82,23,55,110,87,2,223,203,70,39,10,151,217,38,130,228,110,35};
static const unsigned char precomputed_nP_montgomery25519_n_38[] = {65,15,32,20,53,133,12,74,45,16,232,61,190,241,108,142,219,107,165,43,166,77,224,0,143,238,111,108,78,188,83,189};
static const unsigned char precomputed_nP_montgomery25519_p_38[] = {100,78,166,101,186,16,33,249,148,243,238,215,228,226,85,199,101,181,163,20,243,90,100,96,195,116,97,35,31,153,67,17};
static const unsigned char precomputed_nP_montgomery25519_q_39[] = {18,244,59,81,248,218,145,225,18,224,235,185,206,228,171,123,58,219,224,244,155,107,209,155,205,67,188,62,88,237,239,40};
static const unsigned char precomputed_nP_montgomery25519_n_39[] = {148,190,255,45,219,178,118,248,201,115,191,247,159,237,100,82,206,92,216,227,195,56,214,22,93,175,182,124,241,116,21,197};
static const unsigned char precomputed_nP_montgomery25519_p_39[] = {216,45,32,54,238,248,211,160,133,246,29,225,4,154,119,36,23,185,121,58,169,66,254,145,201,141,179,170,190,62,54,18};
static const unsigned char precomputed_nP_montgomery25519_q_40[] = {143,89,69,222,179,212,88,144,197,252,13,219,244,149,71,33,78,245,157,244,93,18,109,20,156,74,71,239,48,201,0,36};
static const unsigned char precomputed_nP_montgomery25519_n_40[] = {195,90,245,191,118,127,212,249,167,243,171,178,54,241,180,206,227,159,217,21,10,140,196,140,68,80,151,15,68,176,89,190};
static const unsigned char precomputed_nP_montgomery25519_p_40[] = {36,64,6,108,6,62,53,35,126,236,93,246,67,94,0,106,66,15,83,213,254,31,127,68,93,156,238,47,127,221,92,20};
static const unsigned char precomputed_nP_montgomery25519_q_41[] = {242,17,147,144,73,76,20,33,70,38,176,162,163,20,110,251,153,126,98,180,47,185,101,227,13,31,169,7,65,168,217,33};
static const unsigned char precomputed_nP_montgomery25519_n_41[] = {187,110,3,156,243,58,23,69,63,43,126,198,25,232,244,117,90,198,194,216,156,226,210,73,183,27,14,37,47,227,115,7};
static const unsigned char precomputed_nP_montgomery25519_p_41[] = {148,214,197,89,82,44,90,188,128,24,185,102,86,13,225,157,32,231,77,115,186,232,140,218,184,193,239,49,124,231,169,21};
static const unsigned char precomputed_nP_montgomery25519_q_42[] = {15,110,14,218,109,97,208,5,119,1,172,107,129,13,15,212,190,36,103,67,142,60,73,93,73,192,62,251,214,1,248,33};
static const unsigned char precomputed_nP_montgomery25519_n_42[] = {83,201,187,156,49,162,122,98,244,64,232,65,97,99,249,20,112,35,197,48,214,75,215,12,58,113,197,148,113,214,183,52};
static const unsigned char precomputed_nP_montgomery25519_p_42[] = {68,129,160,218,218,241,248,204,45,63,176,224,36,15,218,40,118,107,85,223,166,31,199,0,47,181,170,156,116,254,39,22};
static const unsigned char precomputed_nP_montgomery25519_q_43[] = {56,21,5,209,153,28,67,172,37,109,174,13,123,39,248,41,6,32,97,215,136,83,40,105,144,155,46,38,66,191,92,111};
static const unsigned char precomputed_nP_montgomery25519_n_43[] = {216,225,212,157,91,85,59,235,154,67,45,114,168,180,42,127,197,112,107,19,206,209,121,58,84,128,9,85,201,218,145,12};
static const unsigned char precomputed_nP_montgomery25519_p_43[] = {207,108,156,64,182,29,155,51,168,111,164,225,193,194,145,89,21,77,220,193,35,3,222,175,89,78,123,87,130,50,248,22};
static const unsigned char precomputed_nP_montgomery25519_q_44[] = {124,34,221,39,200,223,110,235,114,121,23,183,13,139,29,105,164,48,137,253,75,215,206,50,99,236,183,40,157,114,126,8};
static const unsigned char precomputed_nP_montgomery25519_n_44[] = {213,147,100,238,218,244,221,153,119,214,125,130,158,51,183,19,100,226,158,224,124,214,84,217,214,5,100,138,151,82,47,113};
static const unsigned char precomputed_nP_montgomery25519_p_44[] = {137,80,205,184,163,118,77,202,204,124,57,5,93,109,93,13,226,255,107,99,47,121,243,196,104,138,162,229,83,2,98,26};
static const unsigned char precomputed_nP_montgomery25519_q_45[] = {209,78,224,191,218,3,170,4,33,85,112,53,175,85,212,14,190,108,45,17,159,66,4,171,44,222,255,213,156,13,224,24};
static const unsigned char precomputed_nP_montgomery25519_n_45[] = {162,66,132,16,45,177,133,232,174,4,192,131,107,32,178,62,173,98,230,51,26,75,146,57,50,234,195,185,78,252,166,122};
static const unsigned char precomputed_nP_montgomery25519_p_45[] = {34,240,10,243,6,229,25,22,251,207,81,236,92,210,208,177,233,177,0,228,234,100,198,50,208,115,10,189,11,213,7,32};
static const unsigned char precomputed_nP_montgomery25519_q_46[] = {65,230,67,147,81,29,193,205,106,166,158,26,136,203,16,178,103,85,161,96,102,107,105,133,105,84,64,40,68,43,195,91};
static const unsigned char precomputed_nP_montgomery25519_n_46[] = {108,47,222,232,210,191,39,56,170,87,9,43,52,219,179,129,140,92,177,75,218,9,219,168,101,130,70,60,50,158,31,182};
static const unsigned char precomputed_nP_montgomery25519_p_46[] = {55,42,50,167,103,43,115,186,153,214,232,93,85,246,127,28,39,87,49,26,34,202,133,77,222,157,109,253,151,211,235,32};
static const unsigned char precomputed_nP_montgomery25519_q_47[] = {32,163,168,139,99,25,127,116,102,44,81,149,235,117,39,200,88,48,216,100,104,104,82,71,66,252,153,234,179,66,237,60};
static const unsigned char precomputed_nP_montgomery25519_n_47[] = {46,81,149,149,39,21,251,100,137,131,130,206,145,167,225,73,16,83,211,60,37,120,156,59,54,63,12,239,157,17,84,250};
static const unsigned char precomputed_nP_montgomery25519_p_47[] = {35,194,4,145,228,170,52,36,136,247,152,246,231,250,199,161,157,68,105,95,235,110,137,99,98,244,73,208,83,37,109,35};
static const unsigned char precomputed_nP_montgomery25519_q_48[] = {140,24,30,176,134,8,31,231,89,88,140,197,126,181,244,132,204,147,137,5,26,207,233,155,233,228,209,90,38,40,202,118};
static const unsigned char precomputed_nP_montgomery25519_n_48[] = {73,75,142,5,29,149,53,179,200,42,206,120,189,172,169,234,155,245,32,16,189,242,246,199,228,216,79,193,21,149,73,11};
static const unsigned char precomputed_nP_montgomery25519_p_48[] = {106,173,113,9,210,120,250,178,209,255,187,62,17,65,238,231,37,96,212,220,76,123,244,227,72,68,22,201,239,234,252,35};
static const unsigned char precomputed_nP_montgomery25519_q_49[] = {33,8,41,21,196,57,27,11,142,108,106,99,167,6,192,237,255,230,224,36,117,7,242,70,226,111,243,213,61,23,15,53};
static const unsigned char precomputed_nP_montgomery25519_n_49[] = {77,142,218,116,40,190,158,142,14,25,103,22,220,112,238,115,106,208,60,113,132,11,139,211,134,73,184,101,247,197,94,92};
static const unsigned char precomputed_nP_montgomery25519_p_49[] = {69,46,183,255,198,153,158,240,122,231,14,3,68,224,88,41,255,150,5,100,114,25,47,223,131,156,7,132,91,115,13,36};
static const unsigned char precomputed_nP_montgomery25519_q_50[] = {40,105,249,168,34,223,38,206,115,50,194,65,164,57,143,11,92,115,159,142,217,0,132,251,237,153,184,34,195,196,37,112};
static const unsigned char precomputed_nP_montgomery25519_n_50[] = {30,227,78,104,84,81,163,164,213,29,187,243,170,68,117,193,9,81,235,137,157,206,4,218,77,29,188,210,29,124,49,251};
static const unsigned char precomputed_nP_montgomery25519_p_50[] = {148,73,188,146,204,183,204,19,83,160,11,237,141,97,161,237,152,98,49,50,41,86,14,129,143,0,92,46,72,233,49,38};
static const unsigned char precomputed_nP_montgomery25519_q_51[] = {148,246,73,15,184,154,236,223,224,226,251,31,64,159,206,121,178,247,22,39,70,164,110,173,199,108,204,202,3,77,219,5};
static const unsigned char precomputed_nP_montgomery25519_n_51[] = {142,225,151,172,17,225,127,68,154,120,49,210,16,84,196,235,13,86,29,77,208,152,52,147,1,64,149,163,99,12,19,231};
static const unsigned char precomputed_nP_montgomery25519_p_51[] = {165,184,205,223,247,7,80,140,96,73,134,57,123,193,114,229,182,148,182,23,189,138,186,90,244,253,92,62,29,75,227,38};
static const unsigned char precomputed_nP_montgomery25519_q_52[] = {227,182,214,47,131,182,21,112,64,150,229,231,76,159,115,101,254,178,24,4,238,128,253,76,19,54,242,153,40,8,96,107};
static const unsigned char precomputed_nP_montgomery25519_n_52[] = {212,34,94,235,200,193,0,184,101,187,23,99,253,170,8,165,176,93,221,119,178,52,105,186,227,109,125,247,157,129,161,28};
static const unsigned char precomputed_nP_montgomery25519_p_52[] = {108,20,31,116,94,141,126,45,163,85,126,44,19,190,238,243,224,86,12,212,102,52,127,109,241,32,139,167,37,52,87,39};
static const unsigned char precomputed_nP_montgomery25519_q_53[] = {234,96,13,185,171,29,139,232,201,74,241,138,212,122,221,43,20,207,254,56,35,85,151,69,164,53,40,138,8,222,33,20};
static const unsigned char precomputed_nP_montgomery25519_n_53[] = {66,185,1,82,139,99,252,182,220,250,204,91,12,232,235,41,29,21,190,254,183,189,74,31,4,12,67,189,37,68,172,221};
static const unsigned char precomputed_nP_montgomery25519_p_53[] = {26,98,96,48,105,236,129,197,157,34,71,126,66,69,87,108,146,182,197,41,180,14,89,76,92,46,119,230,190,58,177,46};
static const unsigned char precomputed_nP_montgomery25519_q_54[] = {228,112,130,63,107,81,23,249,186,10,22,86,99,174,198,10,157,41,6,67,30,228,13,31,83,154,42,32,230,159,64,116};
static const unsigned char precomputed_nP_montgomery25519_n_54[] = {29,139,208,144,158,44,163,1,154,204,136,129,249,124,170,119,165,192,236,183,170,69,227,92,93,168,183,102,236,70,132,35};
static const unsigned char precomputed_nP_montgomery25519_p_54[] = {56,103,119,158,120,22,48,230,208,156,54,119,226,189,178,33,160,83,156,57,66,229,19,16,110,194,27,195,36,104,230,50};
static const unsigned char precomputed_nP_montgomery25519_q_55[] = {255,129,18,169,7,117,207,247,14,22,204,204,150,149,241,109,184,234,176,191,204,226,59,95,60,137,13,206,30,84,86,58};
static const unsigned char precomputed_nP_montgomery25519_n_55[] = {201,38,160,195,92,79,81,7,153,46,160,11,225,87,6,177,229,123,232,181,40,91,68,106,252,81,130,223,73,157,105,86};
static const unsigned char precomputed_nP_montgomery25519_p_55[] = {148,163,155,168,115,30,231,224,48,18,225,45,29,95,43,203,221,69,199,158,140,41,162,221,127,99,184,43,182,49,191,52};
static const unsigned char precomputed_nP_montgomery25519_q_56[] = {216,58,60,48,207,147,39,42,240,212,174,51,254,97,191,197,184,179,199,46,208,162,235,199,58,84,206,231,135,146,53,3};
static const unsigned char precomputed_nP_montgomery25519_n_56[] = {197,251,119,136,36,212,2,98,147,53,96,203,69,110,178,248,42,129,249,180,77,223,221,240,247,101,119,199,240,147,174,59};
static const unsigned char precomputed_nP_montgomery25519_p_56[] = {33,110,138,129,221,49,212,141,87,34,182,133,210,124,174,124,181,138,116,52,154,117,0,194,143,57,157,171,95,142,131,54};
static const unsigned char precomputed_nP_montgomery25519_q_57[] = {166,240,57,159,250,12,176,99,21,179,66,164,251,8,22,151,94,185,246,184,60,34,80,126,163,254,145,138,250,217,239,55};
static const unsigned char precomputed_nP_montgomery25519_n_57[] = {117,58,35,111,63,75,58,219,24,188,41,38,213,60,56,25,107,40,249,28,25,194,92,106,2,201,194,172,55,240,143,88};
static const unsigned char precomputed_nP_montgomery25519_p_57[] = {16,14,168,202,146,235,104,175,47,76,126,143,2,68,12,74,128,54,65,154,82,43,146,59,129,187,98,222,21,120,161,57};
static const unsigned char precomputed_nP_montgomery25519_q_58[] = {58,144,221,68,149,243,211,220,123,4,9,128,144,125,157,1,216,48,133,89,2,18,245,83,40,245,77,176,207,170,188,126};
static const unsigned char precomputed_nP_montgomery25519_n_58[] = {76,75,16,137,188,138,139,186,248,43,22,143,182,126,58,197,103,73,165,66,85,12,234,199,46,110,80,174,76,163,47,59};
static const unsigned char precomputed_nP_montgomery25519_p_58[] = {77,80,233,58,202,29,49,53,159,3,213,231,47,143,129,165,208,30,47,197,42,119,210,132,72,188,68,202,24,143,20,61};
static const unsigned char precomputed_nP_montgomery25519_q_59[] = {49,255,250,144,86,100,223,59,248,213,193,15,175,5,233,5,93,3,178,104,161,187,55,226,138,69,127,23,37,210,251,30};
static const unsigned char precomputed_nP_montgomery25519_n_59[] = {53,245,55,25,59,19,52,104,12,190,154,155,254,60,211,10,173,59,255,119,78,185,214,240,80,140,246,173,40,214,178,31};
static const unsigned char precomputed_nP_montgomery25519_p_59[] = {247,9,183,167,211,71,178,197,159,211,252,106,164,133,217,230,19,245,215,29,92,240,192,129,163,60,151,149,102,219,251,61};
static const unsigned char precomputed_nP_montgomery25519_q_60[] = {152,251,21,58,4,206,92,66,175,109,126,19,17,4,136,153,160,151,177,196,251,14,160,205,121,23,97,7,196,38,40,91};
static const unsigned char precomputed_nP_montgomery25519_n_60[] = {95,123,103,87,5,178,10,135,206,161,95,233,75,102,103,198,205,232,37,55,209,52,254,26,201,114,42,28,28,52,229,250};
static const unsigned char precomputed_nP_montgomery25519_p_60[] = {21,85,14,139,190,149,43,205,86,195,25,195,234,193,198,172,181,215,183,28,239,61,27,154,113,244,161,237,94,192,145,62};
static const unsigned char precomputed_nP_montgomery25519_q_61[] = {97,215,117,83,136,126,243,115,111,73,20,197,165,85,65,129,118,57,81,198,161,170,79,46,219,7,174,251,203,113,79,67};
static const unsigned char precomputed_nP_montgomery25519_n_61[] = {212,103,173,234,110,130,170,202,238,170,113,83,237,70,174,165,128,137,208,112,166,62,58,119,136,16,92,2,42,246,113,235};
static const unsigned char precomputed_nP_montgomery25519_p_61[] = {2,179,55,63,101,158,203,81,211,253,4,244,143,91,239,184,216,246,222,242,51,162,197,100,105,151,85,160,120,245,221,63};
static const unsigned char precomputed_nP_montgomery25519_q_62[] = {167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106};
static const unsigned char precomputed_nP_montgomery25519_n_62[] = {37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42};
static const unsigned char precomputed_nP_montgomery25519_p_62[] = {144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66};
static const unsigned char precomputed_nP_montgomery25519_q_63[] = {36,55,236,229,245,79,207,49,203,20,232,169,77,191,14,108,115,63,173,247,108,115,162,142,117,229,217,72,26,175,68,106};
static const unsigned char precomputed_nP_montgomery25519_n_63[] = {23,50,2,94,118,21,204,94,239,46,9,3,10,238,121,200,247,28,126,236,204,216,61,30,175,166,142,170,88,128,44,182};
static const unsigned char precomputed_nP_montgomery25519_p_63[] = {39,183,227,89,201,132,189,69,4,190,233,93,209,47,210,121,112,180,254,123,62,210,123,36,178,222,2,150,99,8,35,66};
static const unsigned char precomputed_nP_montgomery25519_q_64[] = {146,149,77,134,215,1,44,221,5,86,144,64,62,218,24,92,66,95,109,169,110,156,123,103,200,136,175,181,79,206,77,30};
static const unsigned char precomputed_nP_montgomery25519_n_64[] = {213,168,128,89,134,56,190,212,254,149,134,166,70,229,99,211,215,36,27,134,65,78,24,151,38,28,67,38,44,67,165,213};
static const unsigned char precomputed_nP_montgomery25519_p_64[] = {56,176,43,249,168,49,164,59,122,166,156,67,205,1,29,102,123,29,160,44,247,99,10,241,124,103,109,238,186,72,8,75};
static const unsigned char precomputed_nP_montgomery25519_q_65[] = {140,226,113,176,170,125,185,72,144,99,240,177,95,243,32,51,68,104,183,169,16,133,225,52,210,200,4,218,182,105,37,104};
static const unsigned char precomputed_nP_montgomery25519_n_65[] = {179,97,78,242,114,30,10,144,56,149,221,128,190,241,18,143,147,199,4,189,121,234,72,175,18,209,41,0,95,222,34,58};
static const unsigned char precomputed_nP_montgomery25519_p_65[] = {178,235,248,67,138,16,63,246,250,175,128,244,254,92,235,203,151,120,251,136,184,163,190,14,217,41,101,253,24,24,44,78};
static const unsigned char precomputed_nP_montgomery25519_q_66[] = {63,4,23,253,35,192,48,242,97,105,156,93,94,131,136,135,234,220,44,198,162,110,76,234,4,24,99,125,56,100,216,63};
static const unsigned char precomputed_nP_montgomery25519_n_66[] = {13,74,52,214,90,233,227,224,221,209,189,31,98,134,79,12,20,205,239,229,202,59,161,241,208,66,161,8,230,48,104,231};
static const unsigned char precomputed_nP_montgomery25519_p_66[] = {144,156,227,220,61,222,81,95,42,91,74,29,61,104,162,134,169,177,250,227,191,48,4,92,102,178,221,36,47,191,11,80};
static const unsigned char precomputed_nP_montgomery25519_q_67[] = {237,127,188,222,241,16,254,146,84,195,223,127,96,31,31,85,67,186,200,162,130,186,146,173,211,182,140,232,125,203,222,2};
static const unsigned char precomputed_nP_montgomery25519_n_67[] = {199,15,246,104,121,68,176,114,148,63,133,234,196,214,43,48,37,221,32,76,238,144,186,125,120,124,75,164,245,223,232,123};
static const unsigned char precomputed_nP_montgomery25519_p_67[] = {91,92,141,74,120,143,102,65,177,14,15,243,89,123,207,69,62,223,25,195,152,71,40,96,65,238,58,41,216,213,97,82};
static const unsigned char precomputed_nP_montgomery25519_q_68[] = {181,222,209,109,182,226,150,229,99,94,129,129,202,251,88,218,173,54,120,32,159,13,194,200,151,39,193,64,72,6,44,24};
static const unsigned char precomputed_nP_montgomery25519_n_68[] = {242,0,246,18,121,63,165,228,66,126,192,196,235,199,37,199,3,168,187,101,2,146,35,226,198,233,122,105,81,139,29,82};
static const unsigned char precomputed_nP_montgomery25519_p_68[] = {43,198,245,39,220,128,136,246,170,207,98,217,133,116,138,163,11,32,198,18,109,169,214,121,50,33,201,242,219,142,111,82};
static const unsigned char precomputed_nP_montgomery25519_q_69[] = {2,53,245,62,112,133,194,113,152,186,76,56,71,101,59,255,229,204,223,23,8,98,41,236,15,141,174,84,176,31,225,105};
static const unsigned char precomputed_nP_montgomery25519_n_69[] = {172,34,177,175,150,29,34,180,200,84,157,182,242,243,43,39,147,247,92,183,210,61,20,129,117,211,27,208,5,235,153,176};
static const unsigned char precomputed_nP_montgomery25519_p_69[] = {10,177,130,220,69,165,144,38,157,90,143,67,154,190,167,190,50,19,237,121,170,125,249,96,216,189,175,54,84,188,180,82};
static const unsigned char precomputed_nP_montgomery25519_q_70[] = {176,85,166,39,118,113,247,129,215,210,93,45,236,83,4,34,146,19,90,66,49,85,204,206,232,3,26,141,96,101,112,4};
static const unsigned char precomputed_nP_montgomery25519_n_70[] = {159,227,167,216,244,16,147,38,173,141,121,182,83,21,236,80,132,102,92,154,166,71,149,127,117,125,4,24,33,63,142,189};
static const unsigned char precomputed_nP_montgomery25519_p_70[] = {94,229,114,115,221,228,181,199,119,253,17,139,10,59,149,2,202,196,187,230,76,134,89,44,251,24,230,195,37,229,246,85};
static const unsigned char precomputed_nP_montgomery25519_q_71[] = {133,56,209,64,169,248,218,8,156,22,108,249,93,19,19,20,10,202,251,221,92,152,21,138,66,150,67,179,210,116,53,91};
static const unsigned char precomputed_nP_montgomery25519_n_71[] = {175,143,152,210,222,255,216,27,191,206,9,31,49,72,30,207,225,250,90,47,96,110,131,145,55,57,113,118,107,27,83,107};
static const unsigned char precomputed_nP_montgomery25519_p_71[] = {12,123,117,152,26,247,24,62,172,166,28,83,83,247,213,200,159,238,221,115,67,36,1,103,17,111,231,9,73,16,197,86};
static const unsigned char precomputed_nP_montgomery25519_q_72[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_72[] = {107,186,160,142,195,202,118,52,209,113,10,53,105,99,156,228,1,98,117,197,252,194,43,191,179,77,159,99,106,32,14,129};
static const unsigned char precomputed_nP_montgomery25519_p_72[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_nP_montgomery25519_q_73[] = {168,88,184,124,168,95,193,139,180,122,21,83,7,167,242,61,142,140,57,104,68,191,153,220,184,6,164,114,78,208,43,3};
static const unsigned char precomputed_nP_montgomery25519_n_73[] = {237,61,58,130,13,85,224,251,35,94,212,78,203,235,201,20,34,129,69,102,214,79,138,98,123,157,67,82,14,64,80,174};
static const unsigned char precomputed_nP_montgomery25519_p_73[] = {22,233,173,34,218,187,183,195,246,174,184,130,178,202,229,97,80,232,75,20,49,182,202,180,87,80,28,232,150,21,32,87};
static const unsigned char precomputed_nP_montgomery25519_q_74[] = {27,140,184,246,181,174,139,12,170,14,22,32,229,243,80,102,110,113,2,211,170,28,63,207,246,75,190,124,83,154,186,59};
static const unsigned char precomputed_nP_montgomery25519_n_74[] = {182,75,243,148,4,128,244,221,155,58,207,252,40,150,126,7,167,21,179,216,143,122,136,187,36,11,217,148,104,183,162,160};
static const unsigned char precomputed_nP_montgomery25519_p_74[] = {26,84,171,174,223,46,251,179,68,112,12,140,25,120,168,230,49,157,85,92,120,86,93,64,218,91,204,5,82,50,64,87};
static const unsigned char precomputed_nP_montgomery25519_q_75[] = {100,160,131,243,53,186,251,114,8,52,151,27,30,160,13,72,173,210,109,126,132,158,106,196,4,88,22,212,130,242,254,124};
static const unsigned char precomputed_nP_montgomery25519_n_75[] = {243,198,119,37,239,8,52,57,150,12,13,205,198,171,130,161,99,22,239,72,48,151,65,200,41,169,247,63,119,148,130,170};
static const unsigned char precomputed_nP_montgomery25519_p_75[] = {89,147,70,16,191,57,46,101,100,225,112,11,39,133,85,116,187,123,222,118,25,139,220,212,91,148,174,60,170,219,28,88};
static const unsigned char precomputed_nP_montgomery25519_q_76[] = {201,155,12,75,225,4,142,124,244,58,18,139,255,150,172,144,168,104,16,32,44,188,45,70,238,199,97,32,247,139,217,62};
static const unsigned char precomputed_nP_montgomery25519_n_76[] = {59,221,34,203,249,204,78,247,89,11,106,78,176,234,184,64,48,248,19,152,166,49,37,109,200,188,112,187,224,180,92,175};
static const unsigned char precomputed_nP_montgomery25519_p_76[] = {237,126,162,241,233,132,69,64,152,207,154,191,214,121,178,91,45,8,97,215,143,67,183,19,166,189,181,22,103,153,198,88};
static const unsigned char precomputed_nP_montgomery25519_q_77[] = {45,234,189,106,93,41,197,201,25,229,188,27,200,109,20,28,157,91,139,137,162,0,243,82,191,136,58,230,14,123,21,126};
static const unsigned char precomputed_nP_montgomery25519_n_77[] = {196,142,88,86,120,128,248,216,203,143,30,145,212,88,8,226,44,209,237,51,95,0,37,209,222,37,184,14,51,238,143,113};
static const unsigned char precomputed_nP_montgomery25519_p_77[] = {166,71,52,250,165,142,124,133,244,167,47,167,159,231,196,183,228,176,163,220,102,133,113,231,10,178,182,106,107,111,142,89};
static const unsigned char precomputed_nP_montgomery25519_q_78[] = {96,255,146,161,76,7,96,239,148,166,23,180,53,104,37,186,46,128,89,3,171,67,92,201,226,96,241,85,156,155,106,26};
static const unsigned char precomputed_nP_montgomery25519_n_78[] = {246,50,136,243,85,168,3,233,189,68,221,90,81,189,140,213,160,226,230,85,65,61,248,106,74,191,103,228,116,69,59,59};
static const unsigned char precomputed_nP_montgomery25519_p_78[] = {187,24,54,60,85,139,162,25,69,55,173,79,185,91,202,234,176,176,71,225,85,8,207,26,71,123,185,60,233,190,79,90};
static const unsigned char precomputed_nP_montgomery25519_q_79[] = {255,4,221,217,210,234,93,23,172,194,86,106,81,143,125,64,202,114,105,83,19,133,166,47,172,39,142,122,237,86,128,70};
static const unsigned char precomputed_nP_montgomery25519_n_79[] = {72,231,186,167,16,158,213,224,231,195,162,8,119,71,123,14,249,87,11,30,84,163,123,174,230,11,109,83,61,178,182,15};
static const unsigned char precomputed_nP_montgomery25519_p_79[] = {133,133,21,198,3,134,9,12,210,254,123,114,174,238,77,96,254,88,37,64,5,178,199,141,45,0,39,9,184,239,76,94};
static const unsigned char precomputed_nP_montgomery25519_q_80[] = {110,113,117,196,107,121,84,48,49,149,121,164,3,133,75,138,55,101,216,33,156,143,15,96,198,175,237,75,185,14,12,69};
static const unsigned char precomputed_nP_montgomery25519_n_80[] = {196,114,61,3,194,185,195,49,128,208,169,247,44,24,202,182,89,234,161,242,149,34,52,51,148,178,138,2,195,29,56,251};
static const unsigned char precomputed_nP_montgomery25519_p_80[] = {67,255,144,201,115,140,26,118,4,229,216,118,29,235,86,170,110,116,92,125,4,165,62,125,93,218,171,166,14,251,223,95};
static const unsigned char precomputed_nP_montgomery25519_q_81[] = {88,3,144,195,28,174,124,41,102,180,112,240,10,31,224,247,202,153,22,182,105,85,35,154,190,93,45,156,96,6,86,9};
static const unsigned char precomputed_nP_montgomery25519_n_81[] = {232,254,230,246,132,207,176,119,157,251,89,221,134,63,243,78,83,175,53,239,86,105,93,51,88,4,173,177,32,124,144,193};
static const unsigned char precomputed_nP_montgomery25519_p_81[] = {227,121,24,129,106,238,151,39,102,19,51,220,96,154,229,232,131,181,191,15,149,0,235,69,220,12,5,240,198,151,132,96};
static const unsigned char precomputed_nP_montgomery25519_q_82[] = {184,104,230,182,129,76,150,111,49,140,51,165,182,24,57,150,50,121,20,24,229,80,67,104,254,120,83,13,14,124,45,86};
static const unsigned char precomputed_nP_montgomery25519_n_82[] = {31,60,154,239,1,99,22,215,237,93,143,96,188,253,160,127,211,130,94,5,225,196,37,124,3,57,3,71,4,241,231,15};
static const unsigned char precomputed_nP_montgomery25519_p_82[] = {240,22,72,68,27,247,111,127,36,102,253,162,235,57,103,223,77,206,56,9,214,96,69,138,244,14,98,103,63,107,126,98};
static const unsigned char precomputed_nP_montgomery25519_q_83[] = {69,121,86,227,222,239,11,208,33,176,252,85,217,169,174,186,246,248,170,213,13,176,85,81,25,23,34,81,251,61,27,15};
static const unsigned char precomputed_nP_montgomery25519_n_83[] = {232,59,52,197,225,94,168,91,231,73,162,9,196,84,83,9,115,91,228,28,110,247,129,120,199,247,248,114,2,161,167,146};
static const unsigned char precomputed_nP_montgomery25519_p_83[] = {216,133,220,191,70,32,82,157,83,231,220,192,43,155,5,1,175,92,52,144,185,209,117,107,251,155,54,254,111,193,98,99};
static const unsigned char precomputed_nP_montgomery25519_q_84[] = {119,95,0,82,108,75,113,6,44,136,6,36,243,251,32,7,104,182,129,199,63,114,69,233,251,107,213,42,64,188,144,76};
static const unsigned char precomputed_nP_montgomery25519_n_84[] = {66,171,64,207,81,72,227,218,155,228,231,169,174,118,47,75,92,9,36,200,119,200,153,240,214,245,84,125,0,11,90,137};
static const unsigned char precomputed_nP_montgomery25519_p_84[] = {85,180,86,15,22,113,163,114,168,159,20,183,93,182,205,13,113,42,45,139,252,244,3,166,9,43,252,141,81,24,129,103};
static const unsigned char precomputed_nP_montgomery25519_q_85[] = {107,174,134,87,216,186,174,9,66,224,28,33,211,23,25,13,139,44,73,125,110,242,96,106,72,144,93,169,50,27,180,6};
static const unsigned char precomputed_nP_montgomery25519_n_85[] = {251,203,92,151,139,124,57,59,173,109,164,85,93,77,202,88,44,76,10,57,85,66,182,43,163,115,122,239,140,82,226,13};
static const unsigned char precomputed_nP_montgomery25519_p_85[] = {41,161,241,169,209,53,71,139,150,143,73,155,162,199,45,186,77,244,153,141,226,6,54,243,185,180,107,39,148,117,92,106};
static const unsigned char precomputed_nP_montgomery25519_q_86[] = {7,18,149,199,142,15,15,235,24,15,67,212,106,110,177,124,26,214,252,13,89,48,12,66,35,106,43,25,66,132,159,100};
static const unsigned char precomputed_nP_montgomery25519_n_86[] = {37,177,125,17,181,23,36,116,112,172,138,193,110,33,2,198,112,237,96,15,244,166,4,191,129,237,85,244,100,105,65,83};
static const unsigned char precomputed_nP_montgomery25519_p_86[] = {128,23,97,182,37,168,50,230,91,51,94,191,211,109,124,125,74,88,82,154,251,171,187,124,56,245,169,188,106,34,145,107};
static const unsigned char precomputed_nP_montgomery25519_q_87[] = {103,231,168,16,38,143,127,110,16,71,251,28,231,215,228,222,85,87,158,104,130,141,45,189,3,180,179,10,162,46,78,92};
static const unsigned char precomputed_nP_montgomery25519_n_87[] = {160,194,66,170,188,109,55,145,134,247,234,198,159,74,206,216,28,240,81,111,79,54,182,197,178,15,33,34,44,190,194,210};
static const unsigned char precomputed_nP_montgomery25519_p_87[] = {127,15,15,250,255,35,159,42,17,119,215,29,236,176,123,244,254,92,142,79,152,129,191,128,162,120,217,207,55,134,218,108};
static const unsigned char precomputed_nP_montgomery25519_q_88[] = {73,23,176,31,225,42,167,200,73,7,156,3,193,59,105,14,42,173,194,190,183,110,83,43,127,58,195,19,51,229,36,37};
static const unsigned char precomputed_nP_montgomery25519_n_88[] = {88,64,1,35,44,133,219,142,181,211,0,49,193,178,129,99,210,8,68,62,157,47,152,209,255,43,234,157,47,157,220,69};
static const unsigned char precomputed_nP_montgomery25519_p_88[] = {15,154,28,146,107,252,218,170,25,168,127,42,52,44,9,232,19,129,115,18,153,155,113,175,13,84,224,189,164,184,185,109};
static const unsigned char precomputed_nP_montgomery25519_q_89[] = {215,8,201,193,79,168,61,72,101,20,152,251,171,111,150,218,75,51,85,85,148,255,131,141,255,156,17,126,159,6,177,109};
static const unsigned char precomputed_nP_montgomery25519_n_89[] = {198,130,248,4,101,0,28,58,140,67,122,32,79,157,187,169,88,64,24,185,85,96,94,28,162,26,203,99,157,170,13,224};
static const unsigned char precomputed_nP_montgomery25519_p_89[] = {102,152,70,122,156,35,87,188,3,59,236,143,255,220,32,60,180,184,194,174,67,78,155,210,158,158,124,57,123,29,226,111};
static const unsigned char precomputed_nP_montgomery25519_q_90[] = {84,52,11,125,245,132,150,18,72,100,216,10,97,116,194,219,120,17,230,231,77,86,11,115,18,17,117,83,207,244,176,124};
static const unsigned char precomputed_nP_montgomery25519_n_90[] = {138,118,50,4,97,30,223,67,133,227,178,230,148,132,25,72,174,35,177,140,212,86,244,251,114,81,166,39,66,105,57,204};
static const unsigned char precomputed_nP_montgomery25519_p_90[] = {224,127,120,206,90,168,171,155,214,37,59,146,114,174,149,43,10,200,87,58,190,106,83,37,22,129,102,187,150,99,56,112};
static const unsigned char precomputed_nP_montgomery25519_q_91[] = {238,109,71,253,157,191,230,60,96,185,101,2,100,103,60,84,144,93,177,132,112,219,142,64,254,164,8,139,87,191,250,31};
static const unsigned char precomputed_nP_montgomery25519_n_91[] = {69,229,130,138,60,156,82,143,20,25,212,170,17,117,206,159,105,196,250,105,245,227,20,236,205,129,92,190,32,22,203,57};
static const unsigned char precomputed_nP_montgomery25519_p_91[] = {145,46,193,20,199,31,45,117,163,16,240,251,124,50,2,144,229,182,166,220,69,62,50,87,111,130,156,251,207,229,213,117};
static const unsigned char precomputed_nP_montgomery25519_q_92[] = {134,205,13,226,154,77,112,59,108,242,192,203,108,5,89,119,105,54,99,227,158,177,209,151,225,8,176,145,62,72,244,107};
static const unsigned char precomputed_nP_montgomery25519_n_92[] = {143,55,48,87,112,53,12,169,191,131,44,139,63,7,152,58,172,14,127,193,96,112,246,78,28,218,220,172,164,124,33,109};
static const unsigned char precomputed_nP_montgomery25519_p_92[] = {132,5,166,191,250,161,222,193,180,248,102,211,248,213,60,251,68,10,193,132,181,254,109,76,71,80,157,162,230,28,133,121};
static const unsigned char precomputed_nP_montgomery25519_q_93[] = {132,211,21,191,66,248,248,89,73,111,43,217,220,90,21,178,4,219,49,48,22,113,99,190,107,95,35,114,217,59,197,42};
static const unsigned char precomputed_nP_montgomery25519_n_93[] = {233,7,88,169,245,138,136,155,68,93,31,123,215,120,20,114,152,0,25,64,65,69,245,208,239,35,197,64,79,172,241,2};
static const unsigned char precomputed_nP_montgomery25519_p_93[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_nP_montgomery25519_q_94[] = {96,202,115,189,116,193,131,183,206,245,166,211,213,163,181,114,114,156,236,147,196,192,27,239,83,67,106,173,100,236,252,47};
static const unsigned char precomputed_nP_montgomery25519_n_94[] = {61,101,52,96,193,219,34,197,56,228,8,41,247,55,20,132,35,123,168,137,255,18,94,150,60,94,124,47,23,172,16,155};
static const unsigned char precomputed_nP_montgomery25519_p_94[] = {40,159,165,57,215,189,171,104,153,204,112,113,174,10,40,167,37,157,88,148,126,99,85,136,235,128,68,248,197,12,47,122};
static const unsigned char precomputed_nP_montgomery25519_q_95[] = {43,253,2,146,18,249,141,246,239,169,54,244,169,61,16,180,149,39,14,119,135,74,235,68,146,113,195,81,229,38,122,75};
static const unsigned char precomputed_nP_montgomery25519_n_95[] = {202,160,109,22,187,18,114,244,108,11,254,168,103,181,204,123,239,226,125,136,152,139,92,10,115,223,130,70,56,224,173,192};
static const unsigned char precomputed_nP_montgomery25519_p_95[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_96[] = {167,175,126,31,208,11,138,29,108,204,241,125,175,14,115,81,219,83,39,19,165,200,222,35,120,16,71,153,151,169,50,104};
static const unsigned char precomputed_nP_montgomery25519_n_96[] = {19,22,170,41,57,196,167,197,237,159,108,72,100,236,202,254,165,39,22,31,150,255,39,145,145,109,234,73,190,112,233,226};
static const unsigned char precomputed_nP_montgomery25519_p_96[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_97[] = {36,8,58,231,6,163,21,209,25,168,61,203,194,202,156,87,143,205,251,110,150,100,47,16,144,135,57,184,168,5,44,51};
static const unsigned char precomputed_nP_montgomery25519_n_97[] = {250,207,235,85,195,176,210,21,49,226,14,28,243,119,217,108,68,70,135,148,114,230,134,229,39,172,0,0,48,80,97,214};
static const unsigned char precomputed_nP_montgomery25519_p_97[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_98[] = {179,73,180,255,248,60,100,186,199,247,245,45,119,213,164,143,28,85,7,91,72,48,154,97,161,216,224,199,234,9,254,79};
static const unsigned char precomputed_nP_montgomery25519_n_98[] = {171,155,199,168,248,84,62,38,61,251,253,20,229,129,247,173,217,81,240,145,14,20,90,23,134,78,232,212,51,34,250,172};
static const unsigned char precomputed_nP_montgomery25519_p_98[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_99[] = {155,56,106,143,220,91,199,35,51,40,34,60,68,132,234,215,235,216,224,102,48,147,31,123,65,192,218,123,192,69,204,88};
static const unsigned char precomputed_nP_montgomery25519_n_99[] = {216,66,150,88,66,14,93,184,117,133,100,210,116,16,39,29,158,140,14,79,195,252,81,101,222,179,28,201,66,97,137,95};
static const unsigned char precomputed_nP_montgomery25519_p_99[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_100[] = {135,115,33,191,144,231,20,161,98,28,77,82,146,186,0,121,148,163,84,123,175,168,159,183,95,66,121,8,30,105,215,104};
static const unsigned char precomputed_nP_montgomery25519_n_100[] = {126,10,81,72,98,92,102,101,31,240,58,127,17,123,117,166,91,170,166,84,188,34,154,208,46,251,14,87,0,105,114,47};
static const unsigned char precomputed_nP_montgomery25519_p_100[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_101[] = {184,152,148,235,8,16,51,133,188,254,11,79,161,191,124,78,106,124,211,231,108,219,92,138,18,188,205,203,223,38,138,118};
static const unsigned char precomputed_nP_montgomery25519_n_101[] = {10,131,96,200,92,222,33,20,40,227,105,197,27,52,94,103,254,50,55,208,121,2,232,214,99,15,32,20,15,43,222,109};
static const unsigned char precomputed_nP_montgomery25519_p_101[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_102[] = {98,215,92,179,246,154,125,32,18,145,5,39,203,210,146,30,53,83,227,20,109,186,64,31,179,85,248,148,129,219,43,39};
static const unsigned char precomputed_nP_montgomery25519_n_102[] = {245,128,192,158,84,249,137,57,221,154,202,22,214,133,39,248,114,73,117,202,58,176,43,180,136,84,106,233,196,76,47,60};
static const unsigned char precomputed_nP_montgomery25519_p_102[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_103[] = {163,33,2,237,179,15,10,83,254,69,45,136,40,192,117,38,0,213,31,240,83,116,174,100,58,144,175,56,180,187,59,2};
static const unsigned char precomputed_nP_montgomery25519_n_103[] = {86,132,7,229,208,131,24,182,237,39,205,5,254,76,56,75,71,195,212,224,168,179,128,128,199,239,9,175,235,190,218,12};
static const unsigned char precomputed_nP_montgomery25519_p_103[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_104[] = {118,105,251,142,173,206,119,201,47,240,166,60,39,156,155,111,147,129,253,132,244,244,191,40,212,235,110,70,241,225,145,42};
static const unsigned char precomputed_nP_montgomery25519_n_104[] = {218,116,75,114,172,230,16,193,163,154,126,185,187,254,154,213,18,237,33,147,209,222,139,84,80,198,201,142,171,183,9,178};
static const unsigned char precomputed_nP_montgomery25519_p_104[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_105[] = {218,19,60,95,164,29,193,143,31,60,118,76,181,15,34,25,36,25,107,130,112,1,254,30,88,119,91,143,204,104,68,115};
static const unsigned char precomputed_nP_montgomery25519_n_105[] = {102,244,58,119,155,31,176,155,201,67,186,91,94,48,167,170,255,129,116,151,167,203,173,120,226,156,230,70,180,187,160,129};
static const unsigned char precomputed_nP_montgomery25519_p_105[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_106[] = {32,9,88,219,42,178,51,219,92,36,92,6,17,122,205,3,143,164,248,172,108,77,113,31,45,213,215,21,152,78,171,51};
static const unsigned char precomputed_nP_montgomery25519_n_106[] = {48,124,248,1,229,78,90,159,144,127,179,25,138,145,171,159,139,209,42,221,103,134,165,156,190,149,2,186,49,191,106,198};
static const unsigned char precomputed_nP_montgomery25519_p_106[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_107[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_107[] = {127,168,222,138,187,89,94,132,67,191,183,6,49,48,33,163,188,38,86,77,26,121,155,25,71,23,137,248,57,15,9,37};
static const unsigned char precomputed_nP_montgomery25519_p_107[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_108[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_108[] = {29,96,25,19,112,147,141,120,188,41,78,222,44,150,121,75,69,175,171,106,40,52,87,126,121,16,126,87,23,36,150,140};
static const unsigned char precomputed_nP_montgomery25519_p_108[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_109[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_109[] = {107,93,211,155,221,173,12,104,216,40,219,59,4,41,87,244,86,208,62,135,204,236,147,28,221,9,196,79,1,84,193,178};
static const unsigned char precomputed_nP_montgomery25519_p_109[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_110[] = {119,220,130,248,172,121,136,58,112,22,32,242,0,215,240,240,73,194,107,33,173,48,122,143,203,15,1,98,169,138,17,96};
static const unsigned char precomputed_nP_montgomery25519_n_110[] = {134,208,252,118,56,61,27,237,20,246,149,81,237,237,113,234,136,14,30,201,171,146,132,221,168,115,237,104,160,183,135,222};
static const unsigned char precomputed_nP_montgomery25519_p_110[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_111[] = {191,96,234,8,162,191,161,169,220,137,105,236,215,170,48,86,253,59,49,95,28,131,143,42,119,57,37,26,0,6,3,74};
static const unsigned char precomputed_nP_montgomery25519_n_111[] = {75,114,85,162,109,230,214,121,39,165,181,96,16,182,162,72,61,8,9,52,189,26,92,30,158,109,130,167,215,80,130,122};
static const unsigned char precomputed_nP_montgomery25519_p_111[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_112[] = {79,44,236,112,159,54,150,95,117,110,182,61,177,18,158,99,107,124,142,159,114,211,46,83,130,42,252,119,143,232,229,84};
static const unsigned char precomputed_nP_montgomery25519_n_112[] = {167,187,243,125,206,236,2,177,69,39,27,152,40,227,228,231,28,216,46,12,238,71,36,195,154,40,15,179,66,180,77,245};
static const unsigned char precomputed_nP_montgomery25519_p_112[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_113[] = {120,118,158,141,125,24,142,120,47,134,69,41,152,97,48,54,233,93,206,63,177,243,10,239,15,75,5,166,48,220,51,42};
static const unsigned char precomputed_nP_montgomery25519_n_113[] = {244,175,1,128,188,72,149,246,181,16,184,225,132,244,229,128,85,193,26,150,57,165,199,139,193,154,79,158,200,163,180,67};
static const unsigned char precomputed_nP_montgomery25519_p_113[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_114[] = {154,52,76,173,8,179,82,209,123,62,55,159,184,42,203,79,85,136,37,33,206,15,34,229,172,130,233,168,80,218,61,45};
static const unsigned char precomputed_nP_montgomery25519_n_114[] = {130,235,58,201,21,190,167,80,54,37,71,222,197,100,193,93,169,199,76,141,191,166,181,1,89,8,197,71,71,185,112,226};
static const unsigned char precomputed_nP_montgomery25519_p_114[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_115[] = {73,60,108,146,86,171,58,233,185,238,63,146,73,30,24,34,168,99,126,227,84,5,105,118,225,99,196,231,236,222,30,78};
static const unsigned char precomputed_nP_montgomery25519_n_115[] = {122,58,111,170,110,97,174,165,185,228,229,99,23,86,80,121,81,137,76,171,44,133,24,21,47,189,44,142,110,203,172,228};
static const unsigned char precomputed_nP_montgomery25519_p_115[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_116[] = {98,24,253,129,142,215,166,88,61,78,76,204,63,148,128,154,172,46,214,22,232,19,159,246,156,88,25,209,232,64,143,103};
static const unsigned char precomputed_nP_montgomery25519_n_116[] = {138,90,118,69,204,231,142,73,87,186,169,126,23,144,77,150,22,85,129,155,224,213,218,29,206,88,136,173,148,187,212,48};
static const unsigned char precomputed_nP_montgomery25519_p_116[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_117[] = {57,242,82,233,126,54,168,233,155,25,198,102,114,4,58,53,68,128,90,192,59,130,141,40,215,52,107,196,131,41,65,39};
static const unsigned char precomputed_nP_montgomery25519_n_117[] = {143,5,129,132,16,165,68,26,217,213,183,2,61,160,235,94,97,160,134,98,96,79,204,206,51,31,96,40,42,248,139,74};
static const unsigned char precomputed_nP_montgomery25519_p_117[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_118[] = {123,70,222,176,120,109,101,245,75,98,220,83,5,255,243,76,191,226,15,90,209,192,192,236,110,38,48,104,108,237,145,40};
static const unsigned char precomputed_nP_montgomery25519_n_118[] = {92,243,79,38,222,93,146,249,0,77,52,32,178,24,251,60,104,5,10,117,211,94,109,59,250,54,153,231,102,60,234,71};
static const unsigned char precomputed_nP_montgomery25519_p_118[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_119[] = {55,148,59,52,217,39,224,148,171,189,93,22,23,51,10,19,211,155,65,128,118,2,100,22,172,253,152,235,235,75,32,67};
static const unsigned char precomputed_nP_montgomery25519_n_119[] = {0,69,224,111,143,3,121,60,218,111,61,191,244,207,154,238,43,179,95,164,194,49,71,196,224,76,62,140,76,137,174,79};
static const unsigned char precomputed_nP_montgomery25519_p_119[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_120[] = {249,135,87,93,181,36,185,185,29,41,248,205,125,88,68,213,249,15,243,25,75,40,228,78,236,220,85,85,118,111,169,86};
static const unsigned char precomputed_nP_montgomery25519_n_120[] = {165,25,173,168,70,166,223,122,78,153,39,69,250,162,177,233,203,26,79,231,92,0,158,9,116,19,14,193,175,27,150,117};
static const unsigned char precomputed_nP_montgomery25519_p_120[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_121[] = {106,103,2,243,137,56,146,229,122,239,78,38,157,70,155,109,250,148,25,146,155,131,53,130,252,229,155,60,116,196,27,24};
static const unsigned char precomputed_nP_montgomery25519_n_121[] = {251,191,130,168,64,230,88,54,22,53,35,177,3,197,33,239,188,60,216,140,88,186,126,206,1,97,131,2,250,177,194,86};
static const unsigned char precomputed_nP_montgomery25519_p_121[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_122[] = {56,169,74,148,128,81,129,189,149,193,170,248,98,241,253,84,138,97,74,51,6,228,232,110,164,73,149,25,108,184,144,118};
static const unsigned char precomputed_nP_montgomery25519_n_122[] = {50,82,191,214,169,252,155,195,155,212,255,127,87,214,19,237,14,27,139,171,142,23,34,74,60,136,88,220,116,122,30,67};
static const unsigned char precomputed_nP_montgomery25519_p_122[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_123[] = {40,200,204,209,91,183,68,11,249,72,60,139,63,177,138,71,245,134,205,27,114,128,202,70,153,135,44,233,35,233,100,28};
static const unsigned char precomputed_nP_montgomery25519_n_123[] = {211,246,247,134,90,237,209,205,238,198,243,113,12,34,103,183,150,113,189,173,254,100,88,246,192,98,123,82,70,180,97,180};
static const unsigned char precomputed_nP_montgomery25519_p_123[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_124[] = {41,180,99,22,85,111,172,206,203,210,25,146,24,17,12,58,24,38,145,39,250,10,156,182,230,244,68,97,12,26,173,78};
static const unsigned char precomputed_nP_montgomery25519_n_124[] = {11,45,66,197,85,116,154,149,65,54,212,30,20,171,189,126,107,236,184,213,194,189,199,3,122,186,156,36,49,221,75,243};
static const unsigned char precomputed_nP_montgomery25519_p_124[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_125[] = {239,222,144,88,98,46,18,204,120,214,116,139,233,19,96,178,82,59,103,84,52,232,24,152,111,232,130,39,175,220,254,34};
static const unsigned char precomputed_nP_montgomery25519_n_125[] = {252,28,130,205,43,35,198,203,94,180,183,172,82,160,235,193,237,31,103,189,152,231,44,91,251,64,191,27,75,254,228,13};
static const unsigned char precomputed_nP_montgomery25519_p_125[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_126[] = {126,137,129,238,107,156,145,31,56,159,155,66,4,83,86,183,9,220,155,48,244,177,187,3,182,38,36,137,95,249,128,25};
static const unsigned char precomputed_nP_montgomery25519_n_126[] = {150,106,51,130,110,109,118,34,37,58,101,225,223,130,237,20,148,88,34,55,189,39,159,170,9,166,166,101,82,155,237,246};
static const unsigned char precomputed_nP_montgomery25519_p_126[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nP_montgomery25519_q_127[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_127[] = {43,209,137,54,200,206,214,128,133,138,253,245,34,243,159,124,17,121,12,21,147,118,119,165,74,156,74,124,213,9,98,85};
static const unsigned char precomputed_nP_montgomery25519_p_127[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_128[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_128[] = {121,226,255,72,156,59,180,108,213,127,172,208,139,35,21,97,37,3,146,121,43,122,6,83,172,242,162,166,229,184,224,33};
static const unsigned char precomputed_nP_montgomery25519_p_128[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_129[] = {33,212,245,239,163,87,64,222,199,45,84,224,94,162,129,34,49,21,39,11,84,129,120,16,201,2,126,109,67,19,48,21};
static const unsigned char precomputed_nP_montgomery25519_n_129[] = {37,245,188,137,193,18,34,79,126,77,72,53,114,255,161,70,96,9,222,4,230,187,65,70,14,30,3,171,235,169,146,107};
static const unsigned char precomputed_nP_montgomery25519_p_129[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_130[] = {136,19,17,112,99,189,63,169,15,116,146,2,181,161,168,201,3,82,207,138,247,146,111,53,253,213,249,195,109,61,62,62};
static const unsigned char precomputed_nP_montgomery25519_n_130[] = {220,118,210,98,144,140,101,108,216,156,242,52,155,146,195,50,23,251,15,92,0,242,114,115,202,176,242,122,2,187,113,48};
static const unsigned char precomputed_nP_montgomery25519_p_130[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_131[] = {214,96,131,178,122,236,247,212,60,83,213,17,200,164,52,19,131,159,193,252,76,52,94,134,135,233,55,169,243,136,23,107};
static const unsigned char precomputed_nP_montgomery25519_n_131[] = {253,149,141,117,207,5,64,150,242,46,102,247,223,91,126,103,57,116,158,116,114,97,178,55,90,175,151,93,117,62,82,113};
static const unsigned char precomputed_nP_montgomery25519_p_131[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_132[] = {31,100,25,145,30,62,144,212,64,219,186,236,38,135,240,173,18,18,210,133,193,58,175,187,132,2,62,79,230,138,149,63};
static const unsigned char precomputed_nP_montgomery25519_n_132[] = {106,22,136,121,130,169,103,161,11,79,65,78,207,152,232,123,241,32,124,101,14,77,170,5,120,175,47,189,82,25,245,59};
static const unsigned char precomputed_nP_montgomery25519_p_132[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_133[] = {146,49,171,76,227,245,47,149,115,6,126,210,49,141,165,156,142,7,128,23,25,254,255,223,153,207,248,237,162,250,198,67};
static const unsigned char precomputed_nP_montgomery25519_n_133[] = {46,91,106,192,105,223,139,150,210,41,132,178,108,215,36,18,140,88,150,236,62,245,186,175,145,96,199,179,208,55,177,25};
static const unsigned char precomputed_nP_montgomery25519_p_133[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_134[] = {115,167,160,190,36,209,72,210,130,232,16,195,227,119,219,213,42,163,16,207,133,16,126,252,97,244,154,83,165,64,192,26};
static const unsigned char precomputed_nP_montgomery25519_n_134[] = {197,250,34,65,211,83,13,97,5,122,131,88,133,115,37,233,133,115,96,127,218,231,122,121,42,85,169,187,2,171,159,59};
static const unsigned char precomputed_nP_montgomery25519_p_134[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_135[] = {152,12,190,190,80,17,187,19,71,36,226,40,125,198,215,94,232,63,42,31,14,100,72,70,107,235,184,199,209,44,150,91};
static const unsigned char precomputed_nP_montgomery25519_n_135[] = {208,150,131,16,28,148,160,13,192,151,253,190,173,231,141,194,53,102,254,194,194,112,120,134,243,84,110,118,115,207,195,120};
static const unsigned char precomputed_nP_montgomery25519_p_135[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_136[] = {145,169,66,194,172,81,198,39,46,210,40,41,254,167,131,100,86,46,217,95,40,211,39,130,222,43,75,12,181,179,175,68};
static const unsigned char precomputed_nP_montgomery25519_n_136[] = {42,70,117,8,76,143,126,151,191,183,111,41,170,242,171,213,73,232,57,158,199,163,13,0,109,71,169,249,154,34,155,123};
static const unsigned char precomputed_nP_montgomery25519_p_136[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_137[] = {133,21,44,67,64,117,20,116,128,232,253,115,65,157,23,187,236,174,41,220,111,27,126,207,11,138,96,96,151,211,168,49};
static const unsigned char precomputed_nP_montgomery25519_n_137[] = {106,196,36,245,76,90,224,99,36,155,245,98,7,214,46,253,219,218,171,59,103,128,70,171,122,91,191,15,48,166,153,158};
static const unsigned char precomputed_nP_montgomery25519_p_137[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_138[] = {6,194,203,81,78,250,69,205,80,64,132,142,179,170,110,65,191,233,102,109,191,240,215,13,109,52,60,12,114,5,33,56};
static const unsigned char precomputed_nP_montgomery25519_n_138[] = {170,215,102,187,235,20,108,177,84,222,40,135,127,131,20,164,228,65,29,220,23,40,59,98,61,249,215,13,202,142,94,189};
static const unsigned char precomputed_nP_montgomery25519_p_138[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_139[] = {245,179,140,16,163,32,44,87,11,245,40,56,66,162,19,245,118,155,111,15,189,36,221,51,162,104,129,154,194,248,202,68};
static const unsigned char precomputed_nP_montgomery25519_n_139[] = {93,207,41,255,72,7,206,47,11,49,51,239,106,43,171,199,138,46,30,223,144,39,144,75,5,67,212,101,140,159,104,219};
static const unsigned char precomputed_nP_montgomery25519_p_139[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_140[] = {244,234,224,253,20,60,198,188,247,143,28,41,20,220,97,2,77,10,78,118,138,153,225,43,248,21,123,242,192,35,238,1};
static const unsigned char precomputed_nP_montgomery25519_n_140[] = {44,175,48,213,87,226,33,200,167,239,38,114,103,117,42,90,228,64,131,219,79,3,234,177,48,0,9,125,56,205,68,79};
static const unsigned char precomputed_nP_montgomery25519_p_140[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_141[] = {31,224,135,97,215,173,1,8,159,103,168,115,190,1,26,137,189,20,155,104,150,122,79,28,21,220,74,33,159,177,72,76};
static const unsigned char precomputed_nP_montgomery25519_n_141[] = {250,114,79,178,120,16,130,147,4,253,171,208,74,42,200,186,236,25,149,137,139,159,200,123,139,203,55,136,171,168,21,138};
static const unsigned char precomputed_nP_montgomery25519_p_141[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_142[] = {215,194,226,30,5,48,102,158,105,8,172,181,127,251,175,126,0,25,101,220,84,10,197,19,105,58,237,49,123,52,190,117};
static const unsigned char precomputed_nP_montgomery25519_n_142[] = {31,239,111,66,250,165,152,62,61,1,47,9,134,219,166,127,174,8,170,206,103,158,99,99,235,95,103,58,250,213,120,252};
static const unsigned char precomputed_nP_montgomery25519_p_142[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_143[] = {131,178,101,184,126,23,38,56,138,103,253,111,188,251,228,91,254,228,187,90,26,225,156,197,66,28,186,57,44,185,250,23};
static const unsigned char precomputed_nP_montgomery25519_n_143[] = {207,180,26,162,204,78,145,211,202,192,124,41,122,233,177,209,8,206,161,10,221,180,103,101,250,82,217,23,179,253,193,149};
static const unsigned char precomputed_nP_montgomery25519_p_143[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_144[] = {154,231,161,126,117,93,158,70,201,65,48,137,36,99,132,30,137,109,243,186,100,20,184,154,138,250,91,2,143,46,33,101};
static const unsigned char precomputed_nP_montgomery25519_n_144[] = {222,88,162,11,91,133,48,186,207,86,217,44,216,141,164,95,29,80,166,16,139,0,83,201,246,29,109,78,238,68,125,157};
static const unsigned char precomputed_nP_montgomery25519_p_144[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_145[] = {231,158,68,235,147,216,171,15,157,107,171,70,180,155,200,39,184,120,149,1,0,152,227,33,46,131,214,172,224,37,32,111};
static const unsigned char precomputed_nP_montgomery25519_n_145[] = {221,101,130,221,166,124,17,245,238,25,219,91,108,177,232,130,230,79,35,99,5,36,16,61,78,125,124,70,149,231,244,69};
static const unsigned char precomputed_nP_montgomery25519_p_145[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_146[] = {253,205,161,63,111,59,7,121,218,246,210,176,175,45,127,224,204,83,38,105,27,136,210,12,116,200,63,111,243,97,6,112};
static const unsigned char precomputed_nP_montgomery25519_n_146[] = {114,119,121,98,175,166,37,124,162,211,162,97,85,10,67,79,143,254,46,16,63,219,181,76,202,121,194,114,32,13,109,169};
static const unsigned char precomputed_nP_montgomery25519_p_146[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_147[] = {5,46,30,42,98,63,154,70,66,63,49,231,188,171,247,29,219,150,92,232,106,211,78,164,181,2,112,69,113,43,80,32};
static const unsigned char precomputed_nP_montgomery25519_n_147[] = {24,51,236,148,11,64,78,154,213,179,159,4,115,141,182,28,102,173,100,144,166,129,16,215,174,117,165,170,180,196,209,236};
static const unsigned char precomputed_nP_montgomery25519_p_147[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_148[] = {118,89,75,102,164,69,59,231,245,160,186,207,73,82,175,87,192,188,225,244,45,156,230,193,151,62,253,224,122,86,181,24};
static const unsigned char precomputed_nP_montgomery25519_n_148[] = {84,208,129,137,9,251,193,7,81,120,32,66,84,245,156,199,34,180,154,249,92,2,166,86,165,248,77,132,252,142,53,69};
static const unsigned char precomputed_nP_montgomery25519_p_148[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_149[] = {115,208,88,150,38,171,228,174,111,26,37,143,232,112,75,79,110,236,116,118,226,134,16,45,74,163,167,66,94,182,154,7};
static const unsigned char precomputed_nP_montgomery25519_n_149[] = {85,231,154,122,37,75,13,68,171,35,254,137,72,128,41,109,154,241,119,182,82,180,64,165,188,230,147,88,161,154,82,35};
static const unsigned char precomputed_nP_montgomery25519_p_149[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_150[] = {18,210,84,201,51,34,241,76,154,163,14,204,246,5,232,8,21,91,27,156,153,60,43,242,136,87,232,108,180,171,166,74};
static const unsigned char precomputed_nP_montgomery25519_n_150[] = {235,152,251,182,2,242,135,168,32,166,19,246,233,172,27,50,121,44,12,173,182,131,17,187,88,155,43,151,159,53,48,239};
static const unsigned char precomputed_nP_montgomery25519_p_150[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_151[] = {197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113};
static const unsigned char precomputed_nP_montgomery25519_n_151[] = {61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237};
static const unsigned char precomputed_nP_montgomery25519_p_151[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_152[] = {99,251,119,112,231,187,226,19,201,44,152,12,75,37,149,216,238,92,77,90,182,244,215,236,152,248,64,29,159,78,248,62};
static const unsigned char precomputed_nP_montgomery25519_n_152[] = {231,146,78,235,9,155,237,211,193,96,61,198,102,79,190,77,54,114,95,224,213,45,193,36,145,253,126,52,11,186,208,182};
static const unsigned char precomputed_nP_montgomery25519_p_152[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_153[] = {158,138,9,51,170,145,115,189,112,13,48,3,98,41,174,199,232,105,74,126,173,133,160,77,89,232,220,120,220,157,180,65};
static const unsigned char precomputed_nP_montgomery25519_n_153[] = {238,56,67,46,144,112,69,253,133,9,217,170,118,242,86,6,52,125,195,122,41,60,158,201,133,200,209,134,204,181,238,205};
static const unsigned char precomputed_nP_montgomery25519_p_153[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_154[] = {65,16,12,71,178,214,47,201,150,50,12,108,176,230,144,60,126,229,4,105,37,131,67,15,164,227,197,10,127,202,91,86};
static const unsigned char precomputed_nP_montgomery25519_n_154[] = {225,31,186,168,194,238,124,228,39,238,102,175,30,210,63,137,5,69,69,238,72,90,235,71,120,124,68,174,100,168,208,14};
static const unsigned char precomputed_nP_montgomery25519_p_154[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_155[] = {156,161,169,73,10,135,164,15,62,197,29,189,29,233,29,213,248,37,51,240,20,220,225,237,118,6,251,192,160,51,249,13};
static const unsigned char precomputed_nP_montgomery25519_n_155[] = {129,142,251,243,96,133,162,230,82,12,236,18,159,228,13,83,177,127,202,40,226,42,20,212,223,131,93,100,186,166,252,46};
static const unsigned char precomputed_nP_montgomery25519_p_155[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_156[] = {110,150,14,99,68,203,159,4,163,34,159,247,191,49,163,248,31,16,1,99,125,248,15,121,30,38,206,24,168,24,186,68};
static const unsigned char precomputed_nP_montgomery25519_n_156[] = {179,223,101,162,71,212,155,246,157,206,93,80,72,143,130,63,213,149,244,37,215,193,98,58,109,142,63,23,177,0,200,36};
static const unsigned char precomputed_nP_montgomery25519_p_156[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_157[] = {8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24};
static const unsigned char precomputed_nP_montgomery25519_n_157[] = {42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52};
static const unsigned char precomputed_nP_montgomery25519_p_157[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_158[] = {212,158,177,203,244,122,84,74,148,209,29,122,61,231,225,9,252,236,13,189,71,250,166,72,32,254,191,58,116,1,235,118};
static const unsigned char precomputed_nP_montgomery25519_n_158[] = {79,20,219,25,137,225,165,76,146,77,39,38,68,101,196,110,27,120,16,166,225,132,241,144,51,252,47,72,213,55,167,64};
static const unsigned char precomputed_nP_montgomery25519_p_158[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_q_159[] = {24,51,215,230,138,23,30,88,143,60,86,238,203,211,116,63,245,76,50,7,178,47,174,153,162,153,90,26,244,64,247,126};
static const unsigned char precomputed_nP_montgomery25519_n_159[] = {139,212,131,124,25,171,27,175,3,6,47,161,15,105,79,142,37,119,173,48,58,0,91,57,41,8,131,142,248,37,47,75};
static const unsigned char precomputed_nP_montgomery25519_p_159[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_nP_montgomery25519_q_160[] = {71,231,201,137,60,129,65,100,178,201,65,65,97,209,157,227,242,131,60,84,180,233,58,74,146,24,187,55,230,120,180,110};
static const unsigned char precomputed_nP_montgomery25519_n_160[] = {125,125,27,37,31,143,135,2,194,130,146,95,233,172,2,232,137,39,16,69,209,12,149,214,71,224,189,87,96,39,17,71};
static const unsigned char precomputed_nP_montgomery25519_p_160[] = {40,98,193,190,245,237,7,74,121,123,4,94,59,199,62,176,195,18,156,252,169,18,89,40,237,6,154,127,2,176,94,129};
static const unsigned char precomputed_nP_montgomery25519_q_161[] = {172,70,14,185,30,186,50,208,224,176,120,187,8,3,251,227,44,1,74,205,248,162,76,83,200,48,254,14,251,56,149,66};
static const unsigned char precomputed_nP_montgomery25519_n_161[] = {142,204,93,4,172,58,216,97,62,202,142,173,63,55,164,188,30,124,53,110,251,57,132,219,196,226,243,51,248,253,196,211};
static const unsigned char precomputed_nP_montgomery25519_p_161[] = {181,0,249,162,129,240,19,130,20,185,201,69,162,235,51,51,160,82,204,246,150,73,125,6,149,42,172,102,0,215,65,132};
static const unsigned char precomputed_nP_montgomery25519_q_162[] = {247,146,255,227,153,101,136,0,146,133,35,205,167,85,69,130,198,226,111,184,244,181,248,124,96,112,53,61,56,88,129,74};
static const unsigned char precomputed_nP_montgomery25519_n_162[] = {7,221,73,126,146,254,126,111,117,142,17,31,237,8,0,68,160,154,88,55,112,212,116,44,71,109,134,79,44,120,112,37};
static const unsigned char precomputed_nP_montgomery25519_p_162[] = {62,73,24,66,66,142,216,188,26,26,140,60,231,157,121,133,255,143,145,204,30,172,47,178,111,241,184,140,95,102,197,132};
static const unsigned char precomputed_nP_montgomery25519_q_163[] = {206,78,210,8,102,50,143,143,31,56,203,224,32,190,137,2,149,174,115,118,219,32,131,246,43,49,186,161,111,98,144,46};
static const unsigned char precomputed_nP_montgomery25519_n_163[] = {89,182,12,218,220,230,207,116,32,5,79,25,13,197,126,173,15,180,195,30,11,214,14,6,17,153,44,74,14,173,128,126};
static const unsigned char precomputed_nP_montgomery25519_p_163[] = {19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_nP_montgomery25519_q_164[] = {198,154,199,78,110,86,239,200,105,159,84,137,33,219,78,60,63,55,16,37,131,150,75,186,153,157,252,223,107,173,129,105};
static const unsigned char precomputed_nP_montgomery25519_n_164[] = {217,221,54,187,59,23,198,164,60,160,219,64,248,168,85,207,97,19,155,220,128,246,48,137,142,49,224,90,61,44,219,101};
static const unsigned char precomputed_nP_montgomery25519_p_164[] = {125,55,105,100,127,60,72,138,81,84,228,190,83,158,168,146,141,87,127,175,218,74,35,174,189,170,2,180,179,16,1,137};
static const unsigned char precomputed_nP_montgomery25519_q_165[] = {249,150,54,25,81,32,193,186,113,23,74,213,26,222,126,40,36,69,191,63,53,207,74,7,146,7,223,114,136,152,60,1};
static const unsigned char precomputed_nP_montgomery25519_n_165[] = {60,198,119,4,157,93,21,50,218,97,77,98,108,198,219,180,152,246,168,214,106,159,198,239,33,173,152,200,50,159,237,195};
static const unsigned char precomputed_nP_montgomery25519_p_165[] = {129,43,98,81,200,60,211,58,130,133,78,109,209,68,63,72,135,148,109,167,130,138,113,36,70,35,125,182,53,181,83,140};
static const unsigned char precomputed_nP_montgomery25519_q_166[] = {250,24,107,107,6,101,57,112,116,170,102,232,87,148,128,233,176,179,128,225,215,239,98,241,165,238,3,177,50,199,204,1};
static const unsigned char precomputed_nP_montgomery25519_n_166[] = {92,165,88,239,5,221,61,225,13,149,25,23,82,2,96,1,119,0,65,173,221,78,4,206,227,5,131,64,13,203,112,190};
static const unsigned char precomputed_nP_montgomery25519_p_166[] = {112,219,85,141,78,156,71,229,153,137,212,86,246,41,139,137,210,13,246,3,78,206,173,113,225,30,236,100,242,203,91,142};
static const unsigned char precomputed_nP_montgomery25519_q_167[] = {170,208,209,190,88,225,4,146,80,242,232,41,199,19,207,109,186,249,155,73,43,228,161,96,105,32,252,159,150,203,35,3};
static const unsigned char precomputed_nP_montgomery25519_n_167[] = {178,94,69,233,220,50,222,130,166,39,181,69,40,191,116,203,151,218,24,220,132,222,107,236,239,184,160,139,114,252,191,162};
static const unsigned char precomputed_nP_montgomery25519_p_167[] = {231,77,226,40,229,224,72,3,74,203,150,143,218,164,211,149,236,191,232,231,122,157,146,89,72,59,89,49,46,161,128,143};
static const unsigned char precomputed_nP_montgomery25519_q_168[] = {137,26,192,72,140,228,109,25,100,16,99,83,223,159,111,128,121,49,67,57,47,19,70,152,130,193,111,128,175,222,74,109};
static const unsigned char precomputed_nP_montgomery25519_n_168[] = {67,255,22,107,137,168,56,244,159,61,114,162,124,161,245,73,222,225,62,157,114,138,222,7,97,23,219,193,201,28,176,56};
static const unsigned char precomputed_nP_montgomery25519_p_168[] = {133,115,68,47,111,244,70,154,6,222,111,195,182,203,89,217,56,164,165,2,53,122,87,204,87,223,122,234,67,192,154,144};
static const unsigned char precomputed_nP_montgomery25519_q_169[] = {230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48};
static const unsigned char precomputed_nP_montgomery25519_n_169[] = {21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187};
static const unsigned char precomputed_nP_montgomery25519_p_169[] = {223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148};
static const unsigned char precomputed_nP_montgomery25519_q_170[] = {132,85,71,140,81,157,140,27,244,168,251,76,90,21,84,87,47,220,93,183,132,39,90,110,126,195,60,209,172,229,201,62};
static const unsigned char precomputed_nP_montgomery25519_n_170[] = {17,171,138,180,180,226,243,241,22,94,105,224,150,240,171,28,114,160,47,85,212,91,5,38,164,168,199,192,131,226,94,133};
static const unsigned char precomputed_nP_montgomery25519_p_170[] = {248,209,60,152,240,138,191,75,173,194,6,183,199,84,27,79,175,215,246,27,222,29,199,47,232,61,233,117,32,51,140,150};
static const unsigned char precomputed_nP_montgomery25519_q_171[] = {30,225,230,237,233,238,81,121,182,15,229,62,119,131,26,184,91,255,252,212,184,172,61,70,71,129,95,179,166,196,248,54};
static const unsigned char precomputed_nP_montgomery25519_n_171[] = {6,39,247,97,135,82,216,158,152,20,244,9,181,230,238,170,16,172,62,95,173,73,50,245,208,31,251,156,87,215,92,47};
static const unsigned char precomputed_nP_montgomery25519_p_171[] = {219,58,144,115,100,151,51,85,47,103,37,189,190,237,157,116,69,199,145,142,58,96,214,20,32,232,39,197,126,193,49,151};
static const unsigned char precomputed_nP_montgomery25519_q_172[] = {226,192,7,12,247,39,31,31,146,232,156,62,81,27,45,7,26,101,90,209,20,194,119,196,21,128,80,155,216,45,136,36};
static const unsigned char precomputed_nP_montgomery25519_n_172[] = {25,242,127,15,170,249,103,59,20,244,130,221,215,176,77,12,200,251,121,85,238,49,5,133,211,209,74,129,236,119,40,245};
static const unsigned char precomputed_nP_montgomery25519_p_172[] = {95,200,38,56,245,199,134,15,168,128,65,85,197,140,23,11,141,135,124,193,253,118,2,188,6,130,168,239,200,176,14,152};
static const unsigned char precomputed_nP_montgomery25519_q_173[] = {237,55,206,156,153,98,47,4,113,19,141,79,130,147,182,227,67,233,30,11,14,216,24,50,201,173,251,94,125,59,10,23};
static const unsigned char precomputed_nP_montgomery25519_n_173[] = {72,33,171,71,44,102,239,175,64,120,46,56,198,235,52,96,62,96,164,43,133,198,102,111,54,57,59,182,139,177,48,199};
static const unsigned char precomputed_nP_montgomery25519_p_173[] = {170,138,69,101,51,179,185,50,235,207,22,189,77,155,217,80,172,85,92,4,153,152,118,128,93,130,49,239,154,53,165,152};
static const unsigned char precomputed_nP_montgomery25519_q_174[] = {181,49,110,183,58,255,210,62,187,69,3,62,83,113,156,197,242,100,21,35,207,254,182,177,170,140,233,230,156,93,33,25};
static const unsigned char precomputed_nP_montgomery25519_n_174[] = {181,28,192,208,105,213,47,2,4,133,81,88,166,125,243,216,66,163,87,202,118,19,60,94,65,189,56,132,89,231,127,14};
static const unsigned char precomputed_nP_montgomery25519_p_174[] = {174,139,27,98,245,150,194,250,72,239,94,30,130,68,86,121,100,115,184,14,46,231,88,52,64,201,183,229,190,44,174,154};
static const unsigned char precomputed_nP_montgomery25519_q_175[] = {155,73,0,92,215,234,237,137,180,16,181,128,83,187,187,194,169,65,21,107,112,232,230,143,118,49,50,87,125,129,170,102};
static const unsigned char precomputed_nP_montgomery25519_n_175[] = {199,222,5,120,20,88,209,212,97,81,22,238,251,127,179,251,163,181,229,18,135,154,246,23,200,177,133,115,91,247,242,198};
static const unsigned char precomputed_nP_montgomery25519_p_175[] = {43,252,244,51,167,151,107,235,93,92,248,1,29,208,144,19,254,172,17,60,103,54,237,33,7,26,50,245,24,147,154,155};
static const unsigned char precomputed_nP_montgomery25519_q_176[] = {83,174,249,202,179,58,189,144,173,3,137,209,230,75,20,7,24,221,28,81,93,137,8,72,28,93,255,35,19,90,20,123};
static const unsigned char precomputed_nP_montgomery25519_n_176[] = {91,180,105,35,174,87,20,235,92,71,89,77,152,131,114,106,81,139,4,171,161,35,61,125,41,1,135,240,155,128,35,68};
static const unsigned char precomputed_nP_montgomery25519_p_176[] = {36,129,171,217,20,211,14,8,126,132,169,222,235,63,12,118,50,155,57,73,49,89,249,62,24,217,147,143,203,111,156,155};
static const unsigned char precomputed_nP_montgomery25519_q_177[] = {65,62,154,115,224,88,6,117,184,185,242,211,66,135,27,228,207,140,55,113,135,116,214,21,101,100,88,232,37,123,40,23};
static const unsigned char precomputed_nP_montgomery25519_n_177[] = {163,155,152,213,111,119,210,187,202,72,84,68,58,114,229,197,92,7,41,68,56,71,147,109,91,123,234,102,149,237,244,28};
static const unsigned char precomputed_nP_montgomery25519_p_177[] = {205,2,202,59,157,250,84,118,151,165,55,104,243,106,40,149,64,241,251,65,42,56,34,16,234,54,211,253,5,37,252,155};
static const unsigned char precomputed_nP_montgomery25519_q_178[] = {21,183,78,80,200,224,244,217,51,149,162,50,234,63,225,34,110,163,6,104,143,7,14,153,90,173,192,153,92,6,198,30};
static const unsigned char precomputed_nP_montgomery25519_n_178[] = {31,39,168,112,198,233,1,159,99,200,173,70,129,62,5,64,131,128,111,196,62,251,31,79,244,99,219,93,147,157,111,252};
static const unsigned char precomputed_nP_montgomery25519_p_178[] = {59,200,140,46,90,47,67,112,167,35,75,6,224,7,207,227,99,207,251,113,168,1,23,218,226,51,117,255,161,142,153,156};
static const unsigned char precomputed_nP_montgomery25519_q_179[] = {37,4,115,109,112,38,49,17,65,41,208,227,162,7,235,158,167,241,174,152,183,52,193,184,73,164,47,221,169,24,150,56};
static const unsigned char precomputed_nP_montgomery25519_n_179[] = {198,138,197,237,159,88,193,153,162,71,205,235,65,200,206,228,241,64,162,9,214,117,17,219,108,249,215,220,64,177,203,133};
static const unsigned char precomputed_nP_montgomery25519_p_179[] = {92,215,72,182,154,128,219,211,47,140,246,17,244,233,3,54,167,134,151,153,169,146,83,148,29,65,179,15,94,41,232,161};
static const unsigned char precomputed_nP_montgomery25519_q_180[] = {3,76,186,156,73,32,8,184,243,153,152,187,133,201,4,193,22,190,69,70,182,40,172,229,239,188,2,74,226,188,145,126};
static const unsigned char precomputed_nP_montgomery25519_n_180[] = {17,170,83,102,67,207,39,21,223,218,81,224,198,140,140,93,161,165,42,92,44,89,180,253,126,55,124,229,101,60,181,201};
static const unsigned char precomputed_nP_montgomery25519_p_180[] = {123,220,115,8,78,56,160,102,17,73,213,119,146,233,53,244,107,123,154,141,135,28,131,87,69,49,87,209,20,249,56,162};
static const unsigned char precomputed_nP_montgomery25519_q_181[] = {107,34,228,2,211,131,135,174,55,26,22,11,123,154,234,171,193,20,22,138,117,172,170,186,145,69,38,36,18,145,190,49};
static const unsigned char precomputed_nP_montgomery25519_n_181[] = {224,117,38,103,132,218,166,77,3,18,108,50,74,125,235,120,160,25,251,25,99,195,7,219,75,45,19,2,234,159,96,204};
static const unsigned char precomputed_nP_montgomery25519_p_181[] = {86,147,246,133,145,58,250,80,175,26,64,139,193,73,15,156,233,170,63,226,153,120,103,252,148,59,25,147,112,38,215,163};
static const unsigned char precomputed_nP_montgomery25519_q_182[] = {112,155,213,119,42,188,194,117,1,220,30,121,159,134,158,94,15,242,75,232,214,4,87,58,90,222,103,169,64,203,215,34};
static const unsigned char precomputed_nP_montgomery25519_n_182[] = {160,161,157,146,31,135,215,211,9,246,14,28,195,160,51,136,175,159,70,107,190,56,185,117,213,1,209,161,89,105,112,14};
static const unsigned char precomputed_nP_montgomery25519_p_182[] = {77,15,3,198,139,24,114,103,137,170,49,188,87,52,125,80,8,103,119,222,166,174,134,83,41,191,108,14,195,128,111,169};
static const unsigned char precomputed_nP_montgomery25519_q_183[] = {101,8,45,230,27,51,148,195,75,127,203,167,78,137,135,248,54,28,30,246,64,138,219,86,134,110,189,60,9,77,225,121};
static const unsigned char precomputed_nP_montgomery25519_n_183[] = {208,146,223,0,10,130,154,248,2,157,61,204,147,5,204,21,114,250,40,205,43,8,80,214,5,101,127,169,30,178,53,137};
static const unsigned char precomputed_nP_montgomery25519_p_183[] = {96,42,30,228,229,15,43,141,229,125,150,149,63,62,255,69,132,153,11,122,8,147,80,31,71,0,114,172,6,236,188,169};
static const unsigned char precomputed_nP_montgomery25519_q_184[] = {135,156,156,36,100,222,65,89,63,7,219,158,162,168,196,27,226,198,185,121,31,130,247,227,124,145,198,121,149,127,164,17};
static const unsigned char precomputed_nP_montgomery25519_n_184[] = {152,145,24,105,128,88,244,36,82,90,72,193,127,80,177,84,145,182,153,215,126,186,231,74,140,122,23,47,254,224,71,241};
static const unsigned char precomputed_nP_montgomery25519_p_184[] = {94,247,178,221,6,102,158,19,44,117,210,243,87,196,221,157,214,60,167,130,240,210,131,167,12,112,193,95,51,171,253,169};
static const unsigned char precomputed_nP_montgomery25519_q_185[] = {135,15,120,138,71,87,173,231,237,56,243,27,120,254,187,195,198,200,174,75,255,10,148,111,61,165,125,117,227,5,164,102};
static const unsigned char precomputed_nP_montgomery25519_n_185[] = {236,46,171,186,89,186,197,73,226,9,254,112,75,50,158,49,127,66,222,169,84,255,105,114,38,49,220,154,73,219,213,229};
static const unsigned char precomputed_nP_montgomery25519_p_185[] = {47,105,39,192,222,200,75,96,119,240,6,138,50,238,145,191,125,221,161,35,221,145,84,101,52,190,86,71,200,76,239,170};
static const unsigned char precomputed_nP_montgomery25519_q_186[] = {50,4,225,52,71,88,187,126,109,97,237,180,110,70,84,4,166,163,176,38,217,6,62,76,183,202,153,49,93,93,43,101};
static const unsigned char precomputed_nP_montgomery25519_n_186[] = {247,239,31,190,101,187,254,229,126,75,92,192,3,105,157,224,172,44,207,92,15,79,2,45,244,181,206,165,77,46,57,251};
static const unsigned char precomputed_nP_montgomery25519_p_186[] = {88,199,215,35,217,92,77,65,25,45,63,102,205,94,235,17,76,74,238,228,59,31,46,64,132,86,206,193,8,10,254,170};
static const unsigned char precomputed_nP_montgomery25519_q_187[] = {90,21,239,238,78,202,71,98,221,74,25,14,52,104,86,203,129,112,143,228,68,7,250,19,186,252,225,53,99,87,39,95};
static const unsigned char precomputed_nP_montgomery25519_n_187[] = {90,45,40,212,48,116,157,8,31,149,17,162,168,8,80,160,222,248,234,103,130,82,113,71,231,32,77,51,157,127,251,13};
static const unsigned char precomputed_nP_montgomery25519_p_187[] = {236,221,110,85,119,102,142,32,139,41,201,114,77,187,166,133,54,229,25,180,236,76,218,201,124,44,182,42,4,183,49,172};
static const unsigned char precomputed_nP_montgomery25519_q_188[] = {189,43,15,184,94,255,242,174,153,145,193,220,227,67,4,174,147,174,152,18,101,159,166,139,63,163,243,59,213,161,253,1};
static const unsigned char precomputed_nP_montgomery25519_n_188[] = {130,87,3,11,229,236,213,51,129,246,89,146,134,202,228,170,229,222,134,180,251,27,102,183,8,20,163,90,167,120,229,170};
static const unsigned char precomputed_nP_montgomery25519_p_188[] = {255,194,56,232,174,245,62,71,26,68,191,128,100,50,10,237,213,105,100,167,68,21,27,124,129,62,45,161,97,228,235,172};
static const unsigned char precomputed_nP_montgomery25519_q_189[] = {43,41,186,92,20,48,245,52,112,164,231,7,30,244,98,207,255,80,92,47,122,161,158,99,4,86,10,246,88,141,211,64};
static const unsigned char precomputed_nP_montgomery25519_n_189[] = {166,19,206,199,245,88,224,186,251,104,76,239,137,187,207,75,4,51,252,191,42,203,27,202,90,39,104,174,176,53,155,147};
static const unsigned char precomputed_nP_montgomery25519_p_189[] = {24,248,205,13,251,68,160,65,173,109,89,254,224,107,51,244,92,207,167,180,90,30,242,9,86,56,9,82,78,63,98,173};
static const unsigned char precomputed_nP_montgomery25519_q_190[] = {164,18,181,163,154,223,13,222,144,40,229,62,74,82,118,81,14,32,25,1,113,163,252,237,51,70,56,223,247,160,78,82};
static const unsigned char precomputed_nP_montgomery25519_n_190[] = {70,98,133,45,92,153,42,114,193,1,169,74,85,162,189,47,40,192,195,195,190,167,17,8,124,248,198,91,77,77,76,187};
static const unsigned char precomputed_nP_montgomery25519_p_190[] = {5,148,50,200,225,154,104,2,186,157,64,251,100,43,110,250,60,12,112,60,188,21,135,97,51,100,226,99,38,208,159,176};
static const unsigned char precomputed_nP_montgomery25519_q_191[] = {102,229,61,162,248,69,239,179,58,60,8,152,113,12,218,168,141,35,147,32,194,194,98,22,156,1,83,20,8,13,65,122};
static const unsigned char precomputed_nP_montgomery25519_n_191[] = {53,132,199,81,11,201,113,109,199,84,160,219,185,187,62,46,149,38,234,25,16,44,80,51,20,218,85,206,242,143,193,229};
static const unsigned char precomputed_nP_montgomery25519_p_191[] = {58,124,149,244,219,245,28,139,123,7,200,215,136,196,159,79,45,230,10,167,187,124,197,72,22,196,111,77,4,44,35,178};
static const unsigned char precomputed_nP_montgomery25519_q_192[] = {129,123,252,32,79,232,223,63,208,174,46,91,43,179,128,194,105,151,157,192,205,242,81,44,200,18,14,15,210,144,109,87};
static const unsigned char precomputed_nP_montgomery25519_n_192[] = {105,95,221,186,249,163,76,30,159,173,15,12,47,116,53,165,247,77,250,228,41,122,20,199,135,56,204,8,32,185,110,204};
static const unsigned char precomputed_nP_montgomery25519_p_192[] = {206,106,196,63,222,184,149,49,241,126,132,63,200,64,98,76,47,56,113,193,227,167,145,250,109,15,29,169,198,4,252,178};
static const unsigned char precomputed_nP_montgomery25519_q_193[] = {159,55,188,83,179,251,171,231,152,89,242,9,193,181,236,12,223,112,236,40,247,85,159,25,85,107,225,18,155,177,61,7};
static const unsigned char precomputed_nP_montgomery25519_n_193[] = {185,65,102,155,86,42,66,137,198,133,133,100,74,67,77,176,139,40,147,143,72,105,62,87,7,119,145,45,181,120,204,120};
static const unsigned char precomputed_nP_montgomery25519_p_193[] = {202,89,131,157,3,118,249,46,74,101,132,152,106,47,243,202,220,92,140,62,172,55,113,156,173,4,96,104,141,80,79,180};
static const unsigned char precomputed_nP_montgomery25519_q_194[] = {190,145,102,90,116,173,9,96,1,136,94,70,240,65,189,201,171,145,254,247,129,62,21,105,243,190,11,68,201,228,8,12};
static const unsigned char precomputed_nP_montgomery25519_n_194[] = {225,250,207,49,79,0,242,177,148,78,153,60,96,143,63,27,126,123,35,67,94,64,246,82,4,143,123,46,214,217,4,203};
static const unsigned char precomputed_nP_montgomery25519_p_194[] = {23,11,234,10,227,139,156,80,199,166,30,156,2,164,43,61,58,71,110,74,197,50,42,192,114,28,144,175,233,77,233,181};
static const unsigned char precomputed_nP_montgomery25519_q_195[] = {231,135,174,215,156,67,163,120,76,181,241,178,10,247,172,245,31,239,228,196,174,195,118,22,142,51,13,168,31,199,62,43};
static const unsigned char precomputed_nP_montgomery25519_n_195[] = {205,134,235,203,124,126,159,19,10,114,85,61,128,28,54,139,148,212,84,221,41,170,135,244,16,248,51,220,233,21,148,142};
static const unsigned char precomputed_nP_montgomery25519_p_195[] = {4,185,44,222,234,105,45,228,84,211,77,226,210,230,92,138,18,64,100,12,109,20,161,29,169,107,73,50,2,113,32,184};
static const unsigned char precomputed_nP_montgomery25519_q_196[] = {73,146,214,103,234,183,216,144,200,165,221,87,194,213,49,122,62,65,255,204,72,182,131,146,75,41,207,45,248,160,66,90};
static const unsigned char precomputed_nP_montgomery25519_n_196[] = {226,246,94,150,74,153,137,249,205,77,50,216,122,57,174,15,56,200,114,149,108,39,37,64,119,244,18,45,180,144,81,110};
static const unsigned char precomputed_nP_montgomery25519_p_196[] = {167,149,123,83,102,56,8,128,52,35,252,196,135,30,152,179,223,240,232,71,44,238,176,128,107,94,97,60,121,129,219,184};
static const unsigned char precomputed_nP_montgomery25519_q_197[] = {218,151,19,123,28,234,235,200,163,179,10,170,252,43,86,73,85,71,114,100,167,146,135,33,146,246,108,40,7,137,39,115};
static const unsigned char precomputed_nP_montgomery25519_n_197[] = {7,253,193,58,175,41,205,115,33,166,243,153,184,10,43,46,177,68,128,214,230,75,53,63,110,205,14,138,28,4,170,122};
static const unsigned char precomputed_nP_montgomery25519_p_197[] = {92,16,248,176,17,243,88,13,137,6,58,182,139,221,105,188,108,139,108,94,186,224,118,160,35,97,77,197,56,233,17,190};
static const unsigned char precomputed_nP_montgomery25519_q_198[] = {239,148,237,0,202,18,221,76,204,192,173,223,64,192,155,240,126,69,40,188,148,63,98,179,153,171,127,132,205,146,38,118};
static const unsigned char precomputed_nP_montgomery25519_n_198[] = {252,94,239,81,117,164,15,227,11,136,47,221,160,0,112,48,75,245,169,49,28,66,103,200,31,165,123,91,102,225,49,181};
static const unsigned char precomputed_nP_montgomery25519_p_198[] = {90,240,227,251,144,184,238,241,55,58,14,223,188,73,5,141,231,144,206,200,253,27,157,213,251,175,49,90,4,21,43,193};
static const unsigned char precomputed_nP_montgomery25519_q_199[] = {114,178,3,172,20,190,19,181,77,121,28,50,216,32,39,195,172,140,113,226,234,6,168,216,230,208,249,107,66,64,233,60};
static const unsigned char precomputed_nP_montgomery25519_n_199[] = {253,137,9,247,203,124,24,46,218,175,229,53,181,209,246,137,119,4,163,65,141,102,147,90,89,107,249,125,59,39,181,176};
static const unsigned char precomputed_nP_montgomery25519_p_199[] = {70,56,241,199,2,77,116,39,168,14,15,19,243,81,48,228,66,197,86,102,62,178,178,118,177,163,197,69,113,99,107,196};
static const unsigned char precomputed_nP_montgomery25519_q_200[] = {14,53,226,212,72,54,37,122,49,73,1,118,243,185,162,74,34,107,209,235,157,118,141,39,113,86,137,20,138,74,1,98};
static const unsigned char precomputed_nP_montgomery25519_n_200[] = {26,73,199,77,137,156,65,62,242,248,157,124,0,233,203,85,118,6,69,150,81,226,45,216,106,201,6,12,234,114,1,55};
static const unsigned char precomputed_nP_montgomery25519_p_200[] = {179,13,226,14,207,73,38,8,115,109,3,46,235,11,118,202,164,47,136,100,117,120,90,6,44,242,147,142,67,58,34,197};
static const unsigned char precomputed_nP_montgomery25519_q_201[] = {11,170,79,238,36,206,68,38,246,56,104,176,194,101,73,154,107,241,159,210,25,51,189,254,44,37,137,100,143,9,146,80};
static const unsigned char precomputed_nP_montgomery25519_n_201[] = {245,75,186,86,169,16,76,178,243,176,11,204,175,254,84,179,94,169,63,28,176,221,142,93,220,117,199,161,227,2,11,151};
static const unsigned char precomputed_nP_montgomery25519_p_201[] = {110,16,92,235,125,30,216,86,90,26,103,163,229,193,149,39,17,86,214,36,50,108,148,100,208,16,40,12,194,4,159,198};
static const unsigned char precomputed_nP_montgomery25519_q_202[] = {178,130,114,238,38,16,52,113,3,101,188,106,231,131,176,203,199,120,61,248,168,88,88,57,200,132,94,21,26,110,252,103};
static const unsigned char precomputed_nP_montgomery25519_n_202[] = {15,182,29,11,249,249,210,54,202,63,102,206,22,139,241,14,240,225,101,98,97,88,120,55,200,151,109,26,119,136,34,156};
static const unsigned char precomputed_nP_montgomery25519_p_202[] = {95,204,232,169,227,16,187,78,103,76,46,253,39,219,178,130,101,27,212,225,115,213,227,31,126,186,195,148,169,85,245,199};
static const unsigned char precomputed_nP_montgomery25519_q_203[] = {215,155,105,172,214,147,237,205,119,60,252,47,67,96,235,114,110,201,226,162,219,48,127,194,252,165,209,248,235,150,64,23};
static const unsigned char precomputed_nP_montgomery25519_n_203[] = {24,113,214,137,60,212,159,0,197,103,163,201,179,148,131,59,203,28,179,9,203,249,187,135,0,163,200,149,208,20,23,253};
static const unsigned char precomputed_nP_montgomery25519_p_203[] = {174,0,5,175,234,211,162,13,126,160,91,211,165,51,116,163,210,242,48,25,249,254,242,78,240,81,44,86,166,90,115,206};
static const unsigned char precomputed_nP_montgomery25519_q_204[] = {166,231,42,36,82,248,104,43,82,112,6,217,2,173,23,178,47,58,82,139,81,21,252,83,220,4,25,236,19,233,29,40};
static const unsigned char precomputed_nP_montgomery25519_n_204[] = {231,182,113,252,88,106,180,122,247,46,118,29,64,46,11,183,82,110,78,0,249,244,125,26,167,156,41,250,113,111,87,27};
static const unsigned char precomputed_nP_montgomery25519_p_204[] = {223,152,153,220,140,131,68,151,208,123,2,153,171,70,47,103,111,91,11,234,230,63,51,223,200,244,236,171,145,50,249,207};
static const unsigned char precomputed_nP_montgomery25519_q_205[] = {0,180,224,147,32,164,89,230,151,104,186,154,99,51,136,73,196,133,201,147,116,52,167,136,145,196,105,175,165,34,28,108};
static const unsigned char precomputed_nP_montgomery25519_n_205[] = {21,73,182,113,25,32,183,230,191,199,180,51,101,33,170,156,139,80,203,154,58,155,82,74,52,96,158,247,238,207,150,235};
static const unsigned char precomputed_nP_montgomery25519_p_205[] = {155,109,9,21,56,25,184,169,128,198,2,189,9,126,77,58,227,73,99,0,182,182,150,89,26,73,98,86,218,251,57,209};
static const unsigned char precomputed_nP_montgomery25519_q_206[] = {242,84,128,149,205,214,49,57,162,189,47,96,211,217,144,69,45,198,30,208,20,93,90,160,20,186,93,252,217,14,232,42};
static const unsigned char precomputed_nP_montgomery25519_n_206[] = {143,37,213,51,161,231,224,75,16,56,35,130,76,12,253,214,79,34,55,212,159,106,240,121,43,193,22,182,251,220,206,220};
static const unsigned char precomputed_nP_montgomery25519_p_206[] = {250,180,62,72,167,188,211,161,75,8,67,186,254,249,239,196,135,111,170,129,173,38,239,174,51,106,216,119,163,96,80,209};
static const unsigned char precomputed_nP_montgomery25519_q_207[] = {110,203,38,47,155,200,34,223,176,221,103,84,230,144,95,250,34,28,202,120,170,176,202,218,74,129,95,249,77,229,72,123};
static const unsigned char precomputed_nP_montgomery25519_n_207[] = {1,212,157,103,232,159,234,223,107,249,58,63,187,122,154,71,215,115,105,125,123,13,216,158,238,87,62,1,147,150,74,91};
static const unsigned char precomputed_nP_montgomery25519_p_207[] = {125,242,29,114,232,48,27,244,31,171,46,41,1,218,112,38,126,119,17,27,127,158,41,97,36,105,51,103,198,133,79,214};
static const unsigned char precomputed_nP_montgomery25519_q_208[] = {236,248,147,230,0,12,122,127,81,208,149,0,97,187,213,177,109,216,52,215,168,107,82,70,144,31,173,149,212,176,141,121};
static const unsigned char precomputed_nP_montgomery25519_n_208[] = {4,125,207,3,202,0,18,17,153,119,245,2,150,30,216,90,168,14,225,105,57,217,74,74,170,97,59,191,217,207,41,50};
static const unsigned char precomputed_nP_montgomery25519_p_208[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_nP_montgomery25519_q_209[] = {129,54,127,113,23,213,170,23,125,175,158,90,213,181,240,71,94,221,10,124,254,181,32,136,220,100,246,33,142,108,253,122};
static const unsigned char precomputed_nP_montgomery25519_n_209[] = {217,196,76,61,125,89,107,15,75,92,77,43,108,217,85,154,247,0,143,2,74,98,132,4,233,82,51,186,107,119,248,217};
static const unsigned char precomputed_nP_montgomery25519_p_209[] = {3,30,161,46,86,232,112,81,22,22,166,87,64,190,106,88,166,32,34,174,203,96,240,21,231,168,202,224,136,252,95,216};
static const unsigned char precomputed_nP_montgomery25519_q_210[] = {207,99,98,54,244,37,197,214,156,117,144,114,91,66,109,51,150,66,7,58,125,133,76,166,247,62,34,75,174,82,117,119};
static const unsigned char precomputed_nP_montgomery25519_n_210[] = {202,5,147,74,179,48,169,40,156,198,55,4,197,182,10,91,43,62,80,143,47,103,78,121,37,164,50,113,36,101,11,118};
static const unsigned char precomputed_nP_montgomery25519_p_210[] = {58,50,13,118,120,27,56,5,140,124,44,234,250,149,21,57,233,36,207,197,165,234,195,118,154,167,56,193,69,102,30,217};
static const unsigned char precomputed_nP_montgomery25519_q_211[] = {121,50,129,4,175,130,113,47,11,231,181,146,108,87,42,154,202,225,14,245,94,177,3,144,235,171,44,206,253,188,50,63};
static const unsigned char precomputed_nP_montgomery25519_n_211[] = {48,54,85,129,231,252,147,229,224,143,247,165,134,246,63,179,227,248,71,165,201,19,59,229,18,76,197,48,38,161,152,200};
static const unsigned char precomputed_nP_montgomery25519_p_211[] = {33,166,110,206,84,190,224,115,16,16,158,248,30,0,233,114,28,202,152,41,116,80,233,121,144,82,116,76,168,173,30,218};
static const unsigned char precomputed_nP_montgomery25519_q_212[] = {176,182,52,252,134,77,176,235,75,203,19,14,204,192,20,85,158,135,211,17,217,16,231,54,41,73,208,31,27,201,231,67};
static const unsigned char precomputed_nP_montgomery25519_n_212[] = {15,178,181,41,106,62,93,252,17,170,218,222,225,22,147,136,1,241,195,59,36,141,156,234,43,72,126,126,41,17,193,34};
static const unsigned char precomputed_nP_montgomery25519_p_212[] = {56,0,37,25,36,249,203,33,105,221,23,56,110,251,249,180,154,183,67,64,123,150,36,125,50,218,191,132,212,126,128,222};
static const unsigned char precomputed_nP_montgomery25519_q_213[] = {43,186,50,61,113,54,20,246,129,62,252,230,142,137,188,131,52,135,179,98,232,100,109,104,47,120,116,195,104,53,219,76};
static const unsigned char precomputed_nP_montgomery25519_n_213[] = {140,20,116,65,40,144,224,107,218,207,103,120,233,230,200,36,235,153,213,2,165,191,132,50,23,197,154,210,54,80,227,225};
static const unsigned char precomputed_nP_montgomery25519_p_213[] = {142,22,38,205,200,222,195,37,214,165,19,37,81,22,87,95,227,152,243,211,179,168,34,169,78,193,55,91,16,56,230,222};
static const unsigned char precomputed_nP_montgomery25519_q_214[] = {42,70,245,57,92,204,31,170,214,134,23,18,203,54,54,166,42,86,52,54,83,242,185,188,38,39,121,150,204,77,186,9};
static const unsigned char precomputed_nP_montgomery25519_n_214[] = {16,186,3,79,167,172,35,23,153,145,76,173,252,89,100,128,157,108,140,3,111,159,86,179,182,166,18,0,144,105,90,60};
static const unsigned char precomputed_nP_montgomery25519_p_214[] = {250,186,28,252,147,237,14,97,25,165,61,72,56,205,33,143,0,159,175,39,99,66,31,226,24,190,5,150,240,223,238,222};
static const unsigned char precomputed_nP_montgomery25519_q_215[] = {252,153,120,176,103,212,75,243,94,253,126,19,145,198,184,151,142,97,5,167,143,143,166,67,50,196,36,175,109,172,119,2};
static const unsigned char precomputed_nP_montgomery25519_n_215[] = {138,115,96,4,71,205,43,171,21,152,153,99,190,18,34,162,183,121,231,19,180,164,138,104,80,104,207,183,2,217,179,210};
static const unsigned char precomputed_nP_montgomery25519_p_215[] = {141,193,75,162,4,203,133,174,153,196,55,67,223,46,171,9,180,112,112,89,191,187,159,93,201,66,140,226,7,118,67,226};
static const unsigned char precomputed_nP_montgomery25519_q_216[] = {161,11,162,100,6,245,172,159,215,191,146,107,32,227,42,247,252,245,246,10,78,80,109,130,135,23,147,91,19,93,171,113};
static const unsigned char precomputed_nP_montgomery25519_n_216[] = {128,83,222,94,225,133,130,100,117,220,66,98,26,70,116,10,171,17,177,191,249,73,198,53,147,139,0,141,89,108,21,132};
static const unsigned char precomputed_nP_montgomery25519_p_216[] = {236,16,165,65,1,173,130,47,201,213,171,154,185,172,79,19,203,117,86,19,191,75,213,174,85,205,184,195,105,19,136,228};
static const unsigned char precomputed_nP_montgomery25519_q_217[] = {85,22,94,43,250,25,107,211,127,176,94,120,179,15,69,112,208,255,149,239,112,175,29,76,194,87,205,12,119,143,224,112};
static const unsigned char precomputed_nP_montgomery25519_n_217[] = {86,250,18,0,104,153,243,165,197,139,139,226,90,121,113,11,56,40,253,53,174,168,237,82,165,31,245,32,206,93,96,189};
static const unsigned char precomputed_nP_montgomery25519_p_217[] = {87,6,127,250,161,21,246,107,3,203,72,146,112,227,19,204,92,125,202,100,252,110,139,19,133,193,218,63,15,199,167,228};
static const unsigned char precomputed_nP_montgomery25519_q_218[] = {176,88,213,41,206,76,234,184,116,73,157,208,92,216,24,119,57,36,66,147,8,160,21,98,210,253,8,43,48,167,53,48};
static const unsigned char precomputed_nP_montgomery25519_n_218[] = {1,129,111,159,224,98,133,48,105,2,130,113,58,161,223,238,13,149,116,37,158,4,80,158,137,172,82,159,76,30,90,198};
static const unsigned char precomputed_nP_montgomery25519_p_218[] = {112,52,5,29,28,239,246,218,83,106,50,236,83,212,229,146,245,69,47,61,220,72,230,59,243,251,128,98,206,213,120,229};
static const unsigned char precomputed_nP_montgomery25519_q_219[] = {62,0,123,251,99,62,66,71,243,231,164,120,115,181,126,254,237,36,36,32,140,194,68,35,73,35,222,199,199,107,28,117};
static const unsigned char precomputed_nP_montgomery25519_n_219[] = {22,25,157,191,182,145,141,114,11,227,34,104,72,192,36,19,221,45,137,85,89,83,163,40,16,141,176,151,27,155,53,98};
static const unsigned char precomputed_nP_montgomery25519_p_219[] = {84,33,33,195,205,95,87,46,215,226,73,47,6,206,1,220,87,223,209,122,91,233,94,210,113,168,229,78,121,87,53,230};
static const unsigned char precomputed_nP_montgomery25519_q_220[] = {70,120,164,208,137,21,121,162,170,232,226,147,29,219,46,113,250,108,94,182,81,170,242,154,139,170,231,136,62,149,152,109};
static const unsigned char precomputed_nP_montgomery25519_n_220[] = {235,205,101,195,113,156,65,13,74,68,207,37,52,0,64,243,229,176,52,109,93,181,253,95,202,37,46,81,102,160,111,253};
static const unsigned char precomputed_nP_montgomery25519_p_220[] = {38,57,245,107,31,171,57,222,37,89,242,246,200,69,132,204,142,29,85,51,40,241,114,164,100,92,53,88,211,92,202,230};
static const unsigned char precomputed_nP_montgomery25519_q_221[] = {14,237,34,146,132,166,157,178,67,25,254,152,153,185,63,240,88,85,182,87,39,199,1,173,180,1,24,254,13,167,52,122};
static const unsigned char precomputed_nP_montgomery25519_n_221[] = {30,172,238,224,197,130,196,220,34,173,118,170,81,36,14,91,149,82,226,167,147,33,88,60,66,39,33,177,134,78,205,127};
static const unsigned char precomputed_nP_montgomery25519_p_221[] = {41,26,248,132,62,248,195,130,95,125,203,188,212,31,51,250,131,201,151,226,53,4,200,159,144,59,61,181,50,96,124,232};
static const unsigned char precomputed_nP_montgomery25519_q_222[] = {242,199,150,29,101,160,96,249,71,189,152,244,2,107,249,84,53,111,96,147,59,52,94,253,64,24,115,111,7,201,175,122};
static const unsigned char precomputed_nP_montgomery25519_n_222[] = {29,4,43,97,249,178,206,176,24,181,101,239,229,11,192,189,75,210,11,146,108,200,142,33,195,168,88,98,47,178,42,86};
static const unsigned char precomputed_nP_montgomery25519_p_222[] = {237,131,60,71,84,163,46,254,98,12,230,87,251,116,196,185,116,253,229,243,247,223,86,243,70,181,200,64,6,180,114,234};
static const unsigned char precomputed_nP_montgomery25519_q_223[] = {1,178,251,232,38,255,44,82,173,188,52,91,62,83,168,38,95,75,72,128,133,212,62,143,110,112,121,149,220,105,4,85};
static const unsigned char precomputed_nP_montgomery25519_n_223[] = {187,188,55,105,117,127,48,88,219,168,140,162,236,164,142,130,39,125,143,134,233,2,241,216,207,11,210,25,49,121,237,100};
static const unsigned char precomputed_nP_montgomery25519_p_223[] = {159,109,38,90,9,148,16,166,4,12,203,81,214,74,15,69,187,18,59,178,98,237,243,35,8,205,27,12,125,168,206,236};
static const unsigned char precomputed_nP_montgomery25519_q_224[] = {175,8,94,200,26,183,77,83,31,204,57,39,124,104,223,137,28,239,203,131,34,179,127,231,231,26,223,14,36,198,12,102};
static const unsigned char precomputed_nP_montgomery25519_n_224[] = {91,236,197,142,183,255,180,242,223,169,55,214,19,251,194,108,83,232,55,186,94,32,121,252,117,219,77,53,28,82,178,197};
static const unsigned char precomputed_nP_montgomery25519_p_224[] = {77,177,87,210,156,163,175,191,211,150,62,37,21,150,200,44,125,200,224,117,67,164,169,113,221,215,61,61,88,133,65,237};
static const unsigned char precomputed_nP_montgomery25519_q_225[] = {79,239,164,209,27,133,140,233,228,18,135,107,160,242,47,192,248,192,216,54,217,167,41,134,14,151,241,20,44,45,65,112};
static const unsigned char precomputed_nP_montgomery25519_n_225[] = {249,121,227,0,220,61,220,130,163,234,166,135,156,84,185,240,222,192,240,251,42,89,37,174,250,67,204,200,124,5,208,74};
static const unsigned char precomputed_nP_montgomery25519_p_225[] = {51,146,91,49,186,142,83,19,20,166,202,118,177,2,123,32,74,77,241,206,200,63,243,219,5,255,246,165,176,60,121,242};
static const unsigned char precomputed_nP_montgomery25519_q_226[] = {46,130,121,139,15,200,12,86,200,15,247,172,80,99,45,114,180,28,227,23,203,233,211,8,246,205,217,147,171,99,219,57};
static const unsigned char precomputed_nP_montgomery25519_n_226[] = {199,49,248,141,255,31,48,127,152,79,223,151,117,207,201,52,60,57,104,59,61,108,162,64,156,190,128,175,242,55,94,48};
static const unsigned char precomputed_nP_montgomery25519_p_226[] = {37,23,19,91,121,184,178,247,132,107,151,13,254,239,14,213,228,79,139,141,234,186,35,114,206,67,48,145,227,157,176,245};
static const unsigned char precomputed_nP_montgomery25519_q_227[] = {92,164,40,99,40,192,66,62,77,160,155,220,53,40,184,13,30,33,3,251,48,94,67,38,33,104,167,232,228,171,151,84};
static const unsigned char precomputed_nP_montgomery25519_n_227[] = {93,221,22,55,195,227,161,174,147,211,145,19,79,172,208,253,119,134,208,36,107,5,8,20,150,167,236,214,248,239,5,159};
static const unsigned char precomputed_nP_montgomery25519_p_227[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_nP_montgomery25519_q_228[] = {154,94,142,191,27,252,192,84,123,41,33,19,218,35,128,221,242,122,223,205,179,50,60,118,31,32,16,164,45,185,232,80};
static const unsigned char precomputed_nP_montgomery25519_n_228[] = {5,156,184,178,39,194,31,255,117,92,162,195,37,165,244,163,1,95,247,189,238,81,110,7,131,121,120,104,241,60,93,66};
static const unsigned char precomputed_nP_montgomery25519_p_228[] = {128,48,20,114,22,220,220,209,152,138,21,42,4,56,162,215,127,41,23,102,98,16,235,175,36,137,194,230,234,79,79,251};
static const unsigned char precomputed_nP_montgomery25519_q_229[] = {162,200,159,138,45,13,115,138,144,161,63,6,91,72,118,169,6,181,210,18,111,174,62,33,31,232,84,171,40,69,200,85};
static const unsigned char precomputed_nP_montgomery25519_n_229[] = {242,199,99,179,152,3,130,123,89,46,201,162,154,42,255,238,249,39,148,248,119,195,64,7,88,245,92,103,176,127,246,246};
static const unsigned char precomputed_nP_montgomery25519_p_229[] = {235,162,54,148,157,227,126,179,250,16,171,200,149,22,152,172,34,91,213,50,6,121,240,134,54,215,4,38,91,154,39,252};
static const unsigned char precomputed_nP_montgomery25519_q_230[] = {134,117,13,133,76,76,11,104,240,246,53,69,95,54,199,222,80,75,6,41,61,6,42,151,152,238,83,104,84,68,82,56};
static const unsigned char precomputed_nP_montgomery25519_n_230[] = {241,148,11,238,65,111,83,221,62,163,122,3,214,81,163,124,215,161,175,59,109,179,234,146,143,101,238,191,51,189,207,19};
static const unsigned char precomputed_nP_montgomery25519_p_230[] = {14,156,212,9,229,242,211,90,86,23,60,168,108,114,41,2,84,100,202,204,244,219,54,187,48,194,31,211,37,152,156,253};
static const unsigned char precomputed_nP_montgomery25519_q_231[] = {241,134,87,215,83,178,102,73,233,53,211,88,184,115,74,195,209,8,146,155,112,251,184,47,221,243,207,27,132,10,132,103};
static const unsigned char precomputed_nP_montgomery25519_n_231[] = {252,183,195,196,181,28,177,17,120,12,14,179,208,173,153,181,207,112,70,87,86,106,193,54,242,158,69,84,146,24,2,249};
static const unsigned char precomputed_nP_montgomery25519_p_231[] = {26,210,64,74,96,212,130,61,169,249,41,43,135,136,190,112,128,56,18,47,169,218,118,240,98,194,168,50,223,178,247,254};
static const unsigned char precomputed_nP_montgomery25519_q_232[] = {226,229,86,250,226,103,61,86,101,102,170,10,63,9,246,69,117,118,210,10,220,237,241,170,242,18,116,58,91,167,107,110};
static const unsigned char precomputed_nP_montgomery25519_n_232[] = {223,165,235,66,86,199,79,249,146,49,58,149,36,142,248,189,193,104,102,128,215,30,81,109,178,82,166,213,180,252,107,6};
static const unsigned char precomputed_nP_montgomery25519_p_232[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_233[] = {84,254,45,150,154,98,111,211,23,245,171,54,22,154,176,232,226,22,118,224,202,10,81,191,197,247,21,58,221,110,151,50};
static const unsigned char precomputed_nP_montgomery25519_n_233[] = {160,206,225,52,77,80,51,243,156,109,3,151,189,102,95,154,232,34,76,174,61,53,134,144,181,241,50,76,253,127,95,104};
static const unsigned char precomputed_nP_montgomery25519_p_233[] = {193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_234[] = {143,113,135,245,250,124,30,154,148,22,222,2,117,102,37,93,250,232,201,25,74,171,107,245,58,131,36,66,114,107,208,2};
static const unsigned char precomputed_nP_montgomery25519_n_234[] = {182,169,173,124,154,41,121,130,249,60,17,47,224,46,34,4,109,78,19,61,55,95,38,31,3,241,167,172,114,247,68,94};
static const unsigned char precomputed_nP_montgomery25519_p_234[] = {194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_235[] = {1,109,129,242,119,182,55,3,153,159,123,44,185,57,21,206,56,39,169,140,95,249,234,0,69,12,113,108,191,23,1,96};
static const unsigned char precomputed_nP_montgomery25519_n_235[] = {141,243,62,246,228,126,164,138,215,42,211,203,59,98,231,37,182,36,20,225,114,183,104,237,62,66,102,136,42,216,171,71};
static const unsigned char precomputed_nP_montgomery25519_p_235[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_236[] = {192,244,164,145,98,244,9,246,197,103,1,157,51,121,12,217,237,163,46,47,31,207,34,115,161,241,242,8,216,217,12,64};
static const unsigned char precomputed_nP_montgomery25519_n_236[] = {76,5,85,225,28,105,236,171,21,214,182,252,200,65,53,141,180,203,157,174,166,136,231,81,155,199,255,157,38,182,191,34};
static const unsigned char precomputed_nP_montgomery25519_p_236[] = {196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_237[] = {234,38,16,122,131,105,113,8,184,145,137,86,13,79,72,188,44,16,207,203,179,59,194,14,41,217,244,168,4,6,88,72};
static const unsigned char precomputed_nP_montgomery25519_n_237[] = {171,140,216,125,246,116,155,154,112,37,101,190,158,206,239,245,50,123,181,160,210,63,64,181,69,108,17,204,227,57,22,67};
static const unsigned char precomputed_nP_montgomery25519_p_237[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_238[] = {47,115,8,251,186,185,171,39,249,40,33,1,18,101,92,219,88,129,3,177,237,246,163,93,167,149,3,184,116,88,241,25};
static const unsigned char precomputed_nP_montgomery25519_n_238[] = {16,155,44,56,94,103,146,14,89,136,151,106,208,28,115,62,147,211,236,88,68,162,46,191,252,165,129,173,162,71,195,131};
static const unsigned char precomputed_nP_montgomery25519_p_238[] = {198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_239[] = {21,84,118,159,59,245,230,151,180,211,234,186,152,140,135,211,131,219,69,203,17,169,193,235,216,127,223,102,98,1,191,26};
static const unsigned char precomputed_nP_montgomery25519_n_239[] = {76,1,174,177,42,93,230,196,214,123,172,212,69,19,229,229,112,172,129,42,103,14,236,234,193,218,233,22,211,213,16,1};
static const unsigned char precomputed_nP_montgomery25519_p_239[] = {199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_240[] = {19,91,35,55,26,16,58,150,14,11,211,85,201,223,90,113,107,149,54,13,225,66,8,38,250,101,202,37,218,226,152,75};
static const unsigned char precomputed_nP_montgomery25519_n_240[] = {144,32,180,164,202,131,21,99,23,54,90,43,226,186,88,251,65,173,68,225,7,246,245,25,193,0,199,155,74,232,45,118};
static const unsigned char precomputed_nP_montgomery25519_p_240[] = {200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_241[] = {173,238,48,49,7,88,140,189,222,52,38,76,94,246,163,179,79,68,199,174,175,35,28,171,166,228,36,118,201,58,109,61};
static const unsigned char precomputed_nP_montgomery25519_n_241[] = {236,169,210,206,173,249,102,74,90,138,129,27,92,33,164,217,136,98,132,201,254,183,12,196,82,156,127,152,143,155,135,192};
static const unsigned char precomputed_nP_montgomery25519_p_241[] = {201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_242[] = {235,14,110,53,191,65,207,130,47,77,134,173,120,240,222,139,29,180,151,72,162,218,70,217,73,77,253,120,147,236,10,61};
static const unsigned char precomputed_nP_montgomery25519_n_242[] = {242,118,199,205,119,164,108,93,255,103,82,80,71,24,76,10,37,191,147,128,26,14,16,1,201,170,187,82,112,15,231,179};
static const unsigned char precomputed_nP_montgomery25519_p_242[] = {202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_243[] = {57,74,239,155,208,129,43,123,158,71,189,175,103,55,72,239,237,109,15,72,56,141,97,161,180,151,109,117,42,250,184,118};
static const unsigned char precomputed_nP_montgomery25519_n_243[] = {123,159,170,137,125,249,79,117,52,118,158,61,65,244,43,10,156,31,198,161,153,173,129,5,130,173,150,248,49,217,8,227};
static const unsigned char precomputed_nP_montgomery25519_p_243[] = {203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_244[] = {52,64,63,32,59,126,186,249,244,99,54,83,22,9,37,16,48,126,99,33,177,126,99,80,233,21,61,226,163,249,55,32};
static const unsigned char precomputed_nP_montgomery25519_n_244[] = {66,244,159,19,88,253,213,23,32,209,189,251,8,249,71,51,66,19,33,88,169,184,184,83,24,137,123,237,88,112,136,100};
static const unsigned char precomputed_nP_montgomery25519_p_244[] = {204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_245[] = {203,110,3,139,59,73,180,116,211,247,111,59,160,56,91,186,33,143,92,198,148,162,24,120,130,109,3,10,231,16,77,30};
static const unsigned char precomputed_nP_montgomery25519_n_245[] = {105,32,136,160,60,155,175,45,48,161,226,173,0,138,143,225,238,198,72,214,85,185,77,134,223,35,233,234,148,169,7,121};
static const unsigned char precomputed_nP_montgomery25519_p_245[] = {205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_246[] = {255,82,248,88,61,49,168,220,29,130,1,110,152,243,156,136,217,219,236,92,185,217,90,81,253,170,11,27,2,238,82,54};
static const unsigned char precomputed_nP_montgomery25519_n_246[] = {114,237,141,232,195,47,33,59,235,143,14,231,243,190,94,78,53,71,137,45,84,252,75,0,62,232,175,124,142,112,220,222};
static const unsigned char precomputed_nP_montgomery25519_p_246[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_247[] = {60,22,33,140,23,162,113,107,155,140,224,219,58,96,175,108,53,128,62,69,108,113,149,118,205,53,88,43,42,31,142,55};
static const unsigned char precomputed_nP_montgomery25519_n_247[] = {209,15,156,222,4,222,189,121,131,58,205,56,210,159,113,238,70,35,148,1,65,130,208,50,53,177,126,156,112,17,10,106};
static const unsigned char precomputed_nP_montgomery25519_p_247[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_248[] = {204,187,162,207,214,53,94,210,29,108,25,4,213,123,82,215,173,223,116,44,147,220,85,208,25,20,241,20,100,97,223,41};
static const unsigned char precomputed_nP_montgomery25519_n_248[] = {105,85,101,187,197,3,87,214,112,224,218,200,110,84,23,24,84,51,176,82,246,133,72,56,74,110,162,183,16,65,156,9};
static const unsigned char precomputed_nP_montgomery25519_p_248[] = {208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_249[] = {251,98,204,212,151,230,92,115,12,253,83,80,49,51,202,230,25,35,78,198,170,9,74,228,125,247,101,252,40,101,248,120};
static const unsigned char precomputed_nP_montgomery25519_n_249[] = {255,30,104,119,178,60,91,121,220,185,35,46,37,16,253,178,135,28,160,129,123,119,167,118,87,3,6,74,16,25,171,167};
static const unsigned char precomputed_nP_montgomery25519_p_249[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_250[] = {5,168,106,188,73,12,34,187,203,246,72,18,25,207,249,218,205,93,206,60,174,15,128,30,117,208,119,125,204,0,69,104};
static const unsigned char precomputed_nP_montgomery25519_n_250[] = {116,185,13,114,141,41,129,67,255,178,218,214,149,9,141,97,144,215,186,32,22,135,194,93,20,52,11,141,223,165,75,67};
static const unsigned char precomputed_nP_montgomery25519_p_250[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_251[] = {16,176,71,29,5,94,145,54,10,27,149,62,98,110,49,207,187,136,60,70,108,197,164,236,231,202,78,68,116,44,114,12};
static const unsigned char precomputed_nP_montgomery25519_n_251[] = {250,93,251,149,137,50,222,108,176,129,27,24,187,95,27,248,51,94,232,229,55,90,171,191,160,85,183,86,23,6,224,128};
static const unsigned char precomputed_nP_montgomery25519_p_251[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_252[] = {118,218,149,241,214,33,125,242,130,22,147,72,83,220,163,24,130,172,18,66,72,206,244,12,146,34,20,156,123,174,125,122};
static const unsigned char precomputed_nP_montgomery25519_n_252[] = {65,99,53,92,228,166,24,237,239,207,164,149,189,109,242,0,113,5,174,121,235,137,62,7,24,44,128,29,111,223,2,8};
static const unsigned char precomputed_nP_montgomery25519_p_252[] = {212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_253[] = {146,43,123,255,31,155,213,85,188,25,221,200,248,13,245,68,170,167,163,189,220,88,41,78,249,84,138,234,158,186,176,75};
static const unsigned char precomputed_nP_montgomery25519_n_253[] = {147,175,202,105,252,90,225,232,240,127,173,129,198,217,39,91,13,202,235,161,2,63,4,105,31,248,88,122,189,14,202,217};
static const unsigned char precomputed_nP_montgomery25519_p_253[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_254[] = {154,252,107,191,196,167,167,136,136,98,93,165,209,41,6,157,130,51,6,68,53,89,39,163,170,39,99,132,237,74,159,57};
static const unsigned char precomputed_nP_montgomery25519_n_254[] = {130,38,64,153,50,178,132,13,249,105,90,134,211,153,139,250,179,52,6,126,172,131,79,192,196,11,75,32,14,192,52,157};
static const unsigned char precomputed_nP_montgomery25519_p_254[] = {214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_255[] = {232,223,29,50,126,217,13,125,105,77,176,189,58,93,172,9,98,165,81,119,248,183,137,75,104,255,23,182,247,162,99,8};
static const unsigned char precomputed_nP_montgomery25519_n_255[] = {160,100,121,66,86,16,225,47,180,132,98,217,222,58,98,233,242,189,70,72,24,109,180,168,134,12,202,37,38,186,241,243};
static const unsigned char precomputed_nP_montgomery25519_p_255[] = {215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_256[] = {116,70,20,190,1,228,58,162,97,230,38,210,46,203,75,121,38,47,150,168,111,194,217,74,139,93,163,63,251,59,118,43};
static const unsigned char precomputed_nP_montgomery25519_n_256[] = {24,143,235,33,67,131,180,27,71,202,101,41,90,157,230,92,56,143,162,41,110,98,199,236,58,206,79,101,250,17,98,84};
static const unsigned char precomputed_nP_montgomery25519_p_256[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_257[] = {126,55,220,151,180,27,202,117,159,44,8,122,63,39,156,203,142,192,247,237,107,246,70,7,213,252,99,166,210,52,191,97};
static const unsigned char precomputed_nP_montgomery25519_n_257[] = {227,49,81,31,220,251,248,247,148,58,181,157,82,126,45,220,192,245,253,208,243,173,42,250,105,251,200,201,25,149,246,50};
static const unsigned char precomputed_nP_montgomery25519_p_257[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_258[] = {184,122,157,192,154,231,105,41,94,69,37,230,209,206,80,42,230,92,79,235,72,0,173,193,149,93,81,159,3,222,209,67};
static const unsigned char precomputed_nP_montgomery25519_n_258[] = {193,235,196,99,199,87,172,17,95,224,191,36,128,62,51,208,76,95,133,10,13,137,195,28,125,191,249,15,61,55,2,94};
static const unsigned char precomputed_nP_montgomery25519_p_258[] = {218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_259[] = {180,167,250,223,182,154,131,236,92,247,193,57,146,215,254,245,39,26,86,84,160,44,80,79,10,137,193,48,226,150,244,84};
static const unsigned char precomputed_nP_montgomery25519_n_259[] = {89,236,77,222,176,64,70,44,184,182,164,93,227,248,251,30,209,123,23,82,78,124,19,21,52,41,227,132,216,223,196,216};
static const unsigned char precomputed_nP_montgomery25519_p_259[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_260[] = {60,192,58,28,87,176,201,167,97,147,222,140,8,28,23,184,137,118,108,190,240,203,59,10,188,50,7,248,244,70,246,85};
static const unsigned char precomputed_nP_montgomery25519_n_260[] = {142,181,57,7,232,193,70,222,196,113,47,171,219,255,149,10,92,22,47,155,193,100,162,214,251,60,200,133,126,165,61,164};
static const unsigned char precomputed_nP_montgomery25519_p_260[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_261[] = {237,233,209,128,35,74,98,191,219,14,142,247,21,184,48,218,12,66,235,142,38,201,74,115,203,99,197,195,181,145,64,18};
static const unsigned char precomputed_nP_montgomery25519_n_261[] = {128,176,62,75,113,107,246,234,120,66,247,56,41,217,30,167,80,190,150,146,17,193,11,247,74,235,142,53,223,132,110,26};
static const unsigned char precomputed_nP_montgomery25519_p_261[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_262[] = {130,188,214,217,3,161,54,133,153,23,231,239,204,250,189,175,80,94,207,73,155,208,50,219,223,133,155,189,102,74,86,113};
static const unsigned char precomputed_nP_montgomery25519_n_262[] = {36,77,85,226,56,38,117,133,11,109,233,69,172,47,97,87,165,160,3,75,141,239,61,167,109,222,27,229,7,145,39,212};
static const unsigned char precomputed_nP_montgomery25519_p_262[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_263[] = {227,14,91,89,149,235,87,47,99,114,144,161,63,49,199,206,166,102,67,148,111,155,190,231,26,97,66,200,152,157,97,106};
static const unsigned char precomputed_nP_montgomery25519_n_263[] = {124,10,75,235,100,213,226,134,158,190,52,54,191,184,24,122,19,241,103,46,31,244,18,11,112,159,61,204,212,171,148,77};
static const unsigned char precomputed_nP_montgomery25519_p_263[] = {223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_264[] = {242,89,152,96,42,56,87,23,28,237,153,236,48,53,216,130,41,246,187,228,42,0,105,229,19,247,196,116,110,188,161,106};
static const unsigned char precomputed_nP_montgomery25519_n_264[] = {114,77,137,119,43,99,102,76,57,148,166,12,209,145,244,18,51,32,100,72,123,209,37,111,231,73,58,102,253,18,34,162};
static const unsigned char precomputed_nP_montgomery25519_p_264[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_265[] = {14,219,163,120,245,151,25,166,50,224,152,7,225,58,30,88,16,130,127,229,43,47,74,108,254,13,74,201,106,96,143,120};
static const unsigned char precomputed_nP_montgomery25519_n_265[] = {98,41,196,71,7,230,103,174,63,255,108,213,119,236,171,19,162,180,162,134,224,35,65,176,113,107,250,148,124,143,127,33};
static const unsigned char precomputed_nP_montgomery25519_p_265[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_266[] = {87,236,127,198,169,148,118,83,58,50,75,21,133,21,65,45,14,189,87,81,215,96,59,78,219,142,162,18,59,85,83,99};
static const unsigned char precomputed_nP_montgomery25519_n_266[] = {42,75,239,217,24,95,98,148,232,45,231,23,58,147,211,241,137,82,226,205,0,137,96,60,250,6,17,71,225,110,153,121};
static const unsigned char precomputed_nP_montgomery25519_p_266[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_267[] = {224,179,222,89,255,48,52,179,140,224,236,20,136,156,186,137,2,157,150,223,155,241,245,156,99,211,82,13,29,52,168,81};
static const unsigned char precomputed_nP_montgomery25519_n_267[] = {5,32,48,98,160,151,211,105,47,139,190,68,135,114,76,139,230,135,88,1,28,202,107,153,140,154,79,162,154,105,231,217};
static const unsigned char precomputed_nP_montgomery25519_p_267[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_268[] = {64,91,102,139,101,206,222,171,228,8,235,102,170,68,4,28,147,133,171,48,83,187,216,119,107,20,43,2,254,116,218,94};
static const unsigned char precomputed_nP_montgomery25519_n_268[] = {117,246,27,36,54,185,197,126,128,70,19,206,190,244,213,241,2,214,6,42,73,184,224,42,134,19,67,210,95,131,206,65};
static const unsigned char precomputed_nP_montgomery25519_p_268[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_269[] = {96,152,132,105,44,180,126,28,69,184,225,234,81,248,99,233,148,25,242,161,80,3,51,87,86,219,28,141,82,225,91,18};
static const unsigned char precomputed_nP_montgomery25519_n_269[] = {127,56,48,91,234,196,208,190,82,145,55,146,222,16,9,128,161,66,197,177,237,132,255,64,248,2,201,114,190,1,253,140};
static const unsigned char precomputed_nP_montgomery25519_p_269[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_270[] = {245,147,197,14,116,81,238,160,86,55,195,142,129,205,120,245,176,155,135,184,139,85,206,241,38,229,120,82,130,101,111,12};
static const unsigned char precomputed_nP_montgomery25519_n_270[] = {132,172,226,25,189,173,154,215,196,207,251,66,181,178,144,119,92,47,169,146,3,24,13,155,176,60,167,107,65,196,145,120};
static const unsigned char precomputed_nP_montgomery25519_p_270[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_271[] = {9,178,206,181,142,48,124,46,179,156,48,251,55,239,115,5,121,70,93,197,129,97,161,207,155,176,26,201,43,111,39,99};
static const unsigned char precomputed_nP_montgomery25519_n_271[] = {103,96,224,34,32,32,4,192,29,59,69,42,12,161,242,208,65,31,166,128,221,191,253,253,209,190,200,141,126,51,100,190};
static const unsigned char precomputed_nP_montgomery25519_p_271[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_272[] = {147,241,120,113,224,227,19,27,252,128,102,181,229,207,33,112,228,183,166,22,96,243,43,175,115,109,22,76,240,144,232,7};
static const unsigned char precomputed_nP_montgomery25519_n_272[] = {58,127,250,228,154,38,80,111,154,118,109,43,124,162,201,216,109,113,253,122,247,187,181,147,40,167,0,129,243,224,127,55};
static const unsigned char precomputed_nP_montgomery25519_p_272[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_273[] = {115,133,173,27,62,250,88,134,96,111,195,204,235,48,166,87,167,250,168,137,187,92,210,236,239,190,20,127,191,201,204,91};
static const unsigned char precomputed_nP_montgomery25519_n_273[] = {222,142,62,16,49,39,57,171,168,42,148,96,163,45,1,9,98,82,32,250,131,253,106,61,28,238,182,254,185,100,104,183};
static const unsigned char precomputed_nP_montgomery25519_p_273[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_274[] = {26,72,40,11,41,19,139,5,91,221,38,250,195,246,25,132,206,72,32,94,158,183,73,185,132,155,47,231,237,107,22,113};
static const unsigned char precomputed_nP_montgomery25519_n_274[] = {221,15,180,234,241,143,88,255,62,22,37,253,96,95,93,214,130,78,236,187,114,98,25,123,184,13,24,116,241,244,9,3};
static const unsigned char precomputed_nP_montgomery25519_p_274[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_275[] = {119,243,169,67,101,142,55,101,19,229,2,251,162,150,18,160,112,134,178,193,7,225,98,208,156,230,253,183,65,134,234,30};
static const unsigned char precomputed_nP_montgomery25519_n_275[] = {139,232,90,130,109,54,160,143,19,93,33,62,239,86,106,141,212,170,67,203,91,227,33,162,207,68,209,31,55,222,213,61};
static const unsigned char precomputed_nP_montgomery25519_p_275[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_276[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_276[] = {128,219,230,29,173,177,141,63,189,111,11,56,254,236,235,103,133,18,242,200,176,98,251,230,170,142,80,174,220,115,74,136};
static const unsigned char precomputed_nP_montgomery25519_p_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_277[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_277[] = {205,52,231,62,162,59,157,180,143,65,237,10,155,182,225,131,84,77,97,169,54,21,134,141,114,74,99,57,55,14,160,150};
static const unsigned char precomputed_nP_montgomery25519_p_277[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_278[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_278[] = {120,117,181,0,114,107,75,63,81,45,26,100,177,189,190,75,76,155,79,108,26,93,46,211,26,166,229,184,32,217,220,117};
static const unsigned char precomputed_nP_montgomery25519_p_278[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_279[] = {139,147,141,94,93,143,239,121,211,81,7,154,161,209,7,107,178,61,20,223,137,117,220,32,14,123,164,122,20,46,70,31};
static const unsigned char precomputed_nP_montgomery25519_n_279[] = {217,184,164,88,62,54,210,17,153,249,234,177,206,234,187,1,173,27,4,169,47,206,63,97,199,12,146,88,111,217,78,65};
static const unsigned char precomputed_nP_montgomery25519_p_279[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_280[] = {0,8,245,27,88,69,231,240,113,253,194,181,87,25,252,185,40,105,46,159,147,94,139,142,131,39,53,75,16,206,222,113};
static const unsigned char precomputed_nP_montgomery25519_n_280[] = {129,242,248,169,53,254,41,115,23,99,37,158,165,8,170,24,63,109,136,182,235,12,252,1,226,141,235,45,76,29,144,179};
static const unsigned char precomputed_nP_montgomery25519_p_280[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_281[] = {4,243,251,109,137,210,96,75,126,55,164,203,108,60,142,184,22,115,198,64,107,67,90,220,241,226,200,57,51,125,193,103};
static const unsigned char precomputed_nP_montgomery25519_n_281[] = {204,176,178,17,32,215,206,10,207,12,78,92,119,191,189,237,111,57,21,219,243,225,101,99,132,103,153,131,44,57,99,194};
static const unsigned char precomputed_nP_montgomery25519_p_281[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_282[] = {8,178,89,230,199,191,250,150,143,137,166,130,170,245,171,169,133,222,28,78,230,198,190,1,49,175,201,250,128,82,252,47};
static const unsigned char precomputed_nP_montgomery25519_n_282[] = {103,125,120,219,142,193,63,99,95,94,120,255,195,163,244,192,141,144,144,242,54,7,248,237,124,71,23,57,198,209,115,177};
static const unsigned char precomputed_nP_montgomery25519_p_282[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_283[] = {246,114,119,143,155,39,157,246,34,55,191,127,26,58,19,46,165,222,14,207,65,129,225,39,13,216,33,128,100,154,200,93};
static const unsigned char precomputed_nP_montgomery25519_n_283[] = {6,229,131,13,74,195,162,9,2,228,150,154,123,93,113,203,82,225,206,134,33,190,195,16,138,7,140,6,165,142,200,248};
static const unsigned char precomputed_nP_montgomery25519_p_283[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_284[] = {204,122,49,114,58,61,115,158,17,228,115,102,218,190,240,197,111,177,250,75,24,247,17,176,143,83,147,166,57,45,102,23};
static const unsigned char precomputed_nP_montgomery25519_n_284[] = {69,29,123,95,20,77,200,220,161,127,205,110,115,242,135,240,13,237,24,47,141,27,141,147,168,195,78,250,57,75,33,193};
static const unsigned char precomputed_nP_montgomery25519_p_284[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_285[] = {244,146,37,213,178,53,228,12,102,15,156,100,18,101,235,155,107,127,117,214,75,172,94,175,202,9,102,73,140,176,124,5};
static const unsigned char precomputed_nP_montgomery25519_n_285[] = {56,76,151,133,96,85,108,66,115,196,191,219,109,219,122,25,202,81,94,248,63,77,42,51,36,139,236,237,20,60,17,48};
static const unsigned char precomputed_nP_montgomery25519_p_285[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_286[] = {148,188,32,138,35,155,131,145,247,84,194,147,26,230,196,137,182,79,238,150,206,142,38,214,146,1,127,88,47,63,152,67};
static const unsigned char precomputed_nP_montgomery25519_n_286[] = {119,37,3,232,154,73,101,203,242,144,126,179,22,10,45,94,17,184,23,255,211,161,52,136,26,150,171,21,252,192,146,105};
static const unsigned char precomputed_nP_montgomery25519_p_286[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_287[] = {209,8,167,238,183,163,11,201,243,185,121,161,29,123,20,175,222,28,200,142,145,47,77,106,203,64,70,86,163,201,45,53};
static const unsigned char precomputed_nP_montgomery25519_n_287[] = {185,89,159,240,55,61,227,236,79,54,134,247,113,119,201,223,61,57,176,52,178,107,76,248,195,183,218,70,2,173,201,75};
static const unsigned char precomputed_nP_montgomery25519_p_287[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_288[] = {98,163,196,68,252,99,1,247,236,37,88,104,24,167,95,254,22,154,226,52,102,227,151,125,253,130,214,218,119,248,75,58};
static const unsigned char precomputed_nP_montgomery25519_n_288[] = {238,4,202,6,200,58,96,24,207,82,16,141,202,169,160,7,165,61,40,5,116,241,187,116,159,80,6,242,182,173,94,59};
static const unsigned char precomputed_nP_montgomery25519_p_288[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_289[] = {131,184,40,236,201,25,226,15,254,203,109,30,23,96,252,240,196,182,159,89,115,37,70,250,109,160,42,78,55,155,232,74};
static const unsigned char precomputed_nP_montgomery25519_n_289[] = {101,222,223,26,206,156,204,185,76,95,32,117,10,126,86,35,35,87,27,95,11,25,168,243,204,196,231,23,141,222,245,4};
static const unsigned char precomputed_nP_montgomery25519_p_289[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_290[] = {128,200,33,171,61,181,149,40,157,81,87,232,179,117,143,223,16,178,66,151,121,165,153,244,21,43,97,130,164,152,211,35};
static const unsigned char precomputed_nP_montgomery25519_n_290[] = {228,205,241,152,208,216,43,53,3,195,46,142,103,217,206,84,73,194,178,157,241,64,165,11,152,2,113,151,69,234,12,192};
static const unsigned char precomputed_nP_montgomery25519_p_290[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_291[] = {223,75,13,226,76,177,189,93,51,68,131,194,183,178,154,171,211,179,5,128,98,214,70,79,95,15,37,250,248,116,70,127};
static const unsigned char precomputed_nP_montgomery25519_n_291[] = {153,8,207,112,220,24,154,208,124,64,209,151,219,203,20,87,3,185,38,62,238,27,69,114,86,102,36,245,54,109,70,217};
static const unsigned char precomputed_nP_montgomery25519_p_291[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_292[] = {126,246,89,95,225,129,218,133,97,109,54,10,221,243,180,97,9,73,61,62,229,102,18,182,42,111,35,14,215,178,188,30};
static const unsigned char precomputed_nP_montgomery25519_n_292[] = {49,205,141,255,216,41,246,132,104,170,191,91,166,2,115,173,134,218,66,23,152,187,30,137,25,191,57,232,211,39,135,94};
static const unsigned char precomputed_nP_montgomery25519_p_292[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_293[] = {218,32,254,212,8,74,75,59,35,10,147,245,81,16,116,191,60,217,50,26,181,201,162,223,252,193,5,7,161,94,137,78};
static const unsigned char precomputed_nP_montgomery25519_n_293[] = {173,94,114,153,255,15,146,241,23,12,151,123,87,7,174,47,165,162,164,136,62,36,54,15,9,138,189,230,124,181,208,104};
static const unsigned char precomputed_nP_montgomery25519_p_293[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_294[] = {18,53,101,1,161,55,109,55,55,245,40,232,72,51,227,62,45,172,78,1,35,35,96,219,227,194,151,255,96,226,166,98};
static const unsigned char precomputed_nP_montgomery25519_n_294[] = {182,183,161,12,243,138,218,91,67,43,210,252,17,182,137,251,37,22,202,234,43,254,44,97,244,244,97,40,199,151,186,161};
static const unsigned char precomputed_nP_montgomery25519_p_294[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_295[] = {242,86,244,104,119,137,72,40,118,67,216,30,195,131,6,158,122,176,90,117,93,74,71,235,10,59,122,174,197,2,226,59};
static const unsigned char precomputed_nP_montgomery25519_n_295[] = {183,164,111,106,254,186,133,112,217,52,220,7,24,172,132,172,170,68,251,154,140,38,240,10,204,87,79,34,55,162,159,103};
static const unsigned char precomputed_nP_montgomery25519_p_295[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nP_montgomery25519_q_296[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_296[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_p_296[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_297[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_297[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_p_297[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_298[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_298[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_p_298[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_299[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_299[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_p_299[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_300[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_300[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_p_300[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_301[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77};
static const unsigned char precomputed_nP_montgomery25519_n_301[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nP_montgomery25519_p_301[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_302[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_302[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nP_montgomery25519_p_302[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_303[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_303[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nP_montgomery25519_p_303[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_304[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_304[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nP_montgomery25519_p_304[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_305[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_305[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nP_montgomery25519_p_305[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_306[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_306[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nP_montgomery25519_p_306[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_307[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_307[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nP_montgomery25519_p_307[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_308[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_308[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nP_montgomery25519_p_308[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_309[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_309[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nP_montgomery25519_p_309[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_310[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_310[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nP_montgomery25519_p_310[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_311[] = {174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nP_montgomery25519_n_311[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nP_montgomery25519_p_311[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_312[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_312[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nP_montgomery25519_p_312[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_313[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_313[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nP_montgomery25519_p_313[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_314[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_314[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nP_montgomery25519_p_314[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_315[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_315[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nP_montgomery25519_p_315[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_316[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_316[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nP_montgomery25519_p_316[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_317[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_317[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nP_montgomery25519_p_317[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_318[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_318[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nP_montgomery25519_p_318[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_319[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_319[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nP_montgomery25519_p_319[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_320[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_320[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nP_montgomery25519_p_320[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_321[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70};
static const unsigned char precomputed_nP_montgomery25519_n_321[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nP_montgomery25519_p_321[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_322[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_322[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nP_montgomery25519_p_322[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_323[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_323[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nP_montgomery25519_p_323[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_324[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_324[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nP_montgomery25519_p_324[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_325[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_325[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nP_montgomery25519_p_325[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_326[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_326[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nP_montgomery25519_p_326[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_327[] = {209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nP_montgomery25519_n_327[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nP_montgomery25519_p_327[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_328[] = {65,15,235,90,165,23,55,202,122,21,115,134,135,213,129,92,121,19,17,181,54,134,148,118,57,194,144,32,68,24,130,40};
static const unsigned char precomputed_nP_montgomery25519_n_328[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nP_montgomery25519_p_328[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_329[] = {65,15,235,90,165,23,55,202,122,21,115,134,135,213,129,92,121,19,17,181,54,134,148,118,57,194,144,32,68,24,130,40};
static const unsigned char precomputed_nP_montgomery25519_n_329[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nP_montgomery25519_p_329[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_330[] = {65,15,235,90,165,23,55,202,122,21,115,134,135,213,129,92,121,19,17,181,54,134,148,118,57,194,144,32,68,24,130,40};
static const unsigned char precomputed_nP_montgomery25519_n_330[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nP_montgomery25519_p_330[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_331[] = {65,15,235,90,165,23,55,202,122,21,115,134,135,213,129,92,121,19,17,181,54,134,148,118,57,194,144,32,68,24,130,40};
static const unsigned char precomputed_nP_montgomery25519_n_331[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nP_montgomery25519_p_331[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_332[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_332[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nP_montgomery25519_p_332[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_333[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_333[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nP_montgomery25519_p_333[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_334[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_334[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nP_montgomery25519_p_334[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_335[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_335[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nP_montgomery25519_p_335[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_336[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_336[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nP_montgomery25519_p_336[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_337[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_337[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nP_montgomery25519_p_337[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_338[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_338[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nP_montgomery25519_p_338[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_339[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_339[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nP_montgomery25519_p_339[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_340[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_340[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nP_montgomery25519_p_340[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_341[] = {109,138,207,247,64,117,107,238,187,28,24,80,125,89,55,137,19,82,117,58,74,123,10,248,234,235,140,156,99,60,63,64};
static const unsigned char precomputed_nP_montgomery25519_n_341[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nP_montgomery25519_p_341[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_342[] = {2,4,227,41,22,217,16,242,153,36,17,149,21,122,112,241,172,35,16,124,233,123,240,67,172,231,103,196,30,180,63,123};
static const unsigned char precomputed_nP_montgomery25519_n_342[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nP_montgomery25519_p_342[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_343[] = {2,4,227,41,22,217,16,242,153,36,17,149,21,122,112,241,172,35,16,124,233,123,240,67,172,231,103,196,30,180,63,123};
static const unsigned char precomputed_nP_montgomery25519_n_343[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nP_montgomery25519_p_343[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_344[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_344[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nP_montgomery25519_p_344[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_345[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_345[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nP_montgomery25519_p_345[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_346[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_346[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nP_montgomery25519_p_346[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_347[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_347[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nP_montgomery25519_p_347[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_348[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_348[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nP_montgomery25519_p_348[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_349[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_349[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nP_montgomery25519_p_349[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_350[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_350[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nP_montgomery25519_p_350[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_351[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_n_351[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nP_montgomery25519_p_351[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_352[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_352[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nP_montgomery25519_p_352[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_353[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_353[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nP_montgomery25519_p_353[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_354[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_354[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nP_montgomery25519_p_354[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_355[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_355[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nP_montgomery25519_p_355[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_356[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_356[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nP_montgomery25519_p_356[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_357[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_357[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nP_montgomery25519_p_357[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_358[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_358[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nP_montgomery25519_p_358[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_359[] = {136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nP_montgomery25519_n_359[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nP_montgomery25519_p_359[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_360[] = {4,60,159,148,140,4,91,54,247,97,13,166,37,139,55,207,203,171,12,83,188,81,88,119,110,36,233,70,202,224,137,84};
static const unsigned char precomputed_nP_montgomery25519_n_360[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nP_montgomery25519_p_360[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_361[] = {4,60,159,148,140,4,91,54,247,97,13,166,37,139,55,207,203,171,12,83,188,81,88,119,110,36,233,70,202,224,137,84};
static const unsigned char precomputed_nP_montgomery25519_n_361[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nP_montgomery25519_p_361[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_362[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_362[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nP_montgomery25519_p_362[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_363[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_363[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nP_montgomery25519_p_363[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_364[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_364[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nP_montgomery25519_p_364[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_365[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_365[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nP_montgomery25519_p_365[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_366[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_366[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nP_montgomery25519_p_366[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_367[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_367[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nP_montgomery25519_p_367[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_368[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_368[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nP_montgomery25519_p_368[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_369[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_369[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nP_montgomery25519_p_369[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_370[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_370[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nP_montgomery25519_p_370[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nP_montgomery25519_q_371[] = {208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nP_montgomery25519_n_371[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nP_montgomery25519_p_371[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
  const unsigned char *p;
  long long psize;
} precomputed_nP_montgomery25519[precomputed_nP_montgomery25519_NUM] = {
  {
    precomputed_nP_montgomery25519_q_0,32,
    precomputed_nP_montgomery25519_n_0,32,
    precomputed_nP_montgomery25519_p_0,32,
  },
  {
    precomputed_nP_montgomery25519_q_1,32,
    precomputed_nP_montgomery25519_n_1,32,
    precomputed_nP_montgomery25519_p_1,32,
  },
  {
    precomputed_nP_montgomery25519_q_2,32,
    precomputed_nP_montgomery25519_n_2,32,
    precomputed_nP_montgomery25519_p_2,32,
  },
  {
    precomputed_nP_montgomery25519_q_3,32,
    precomputed_nP_montgomery25519_n_3,32,
    precomputed_nP_montgomery25519_p_3,32,
  },
  {
    precomputed_nP_montgomery25519_q_4,32,
    precomputed_nP_montgomery25519_n_4,32,
    precomputed_nP_montgomery25519_p_4,32,
  },
  {
    precomputed_nP_montgomery25519_q_5,32,
    precomputed_nP_montgomery25519_n_5,32,
    precomputed_nP_montgomery25519_p_5,32,
  },
  {
    precomputed_nP_montgomery25519_q_6,32,
    precomputed_nP_montgomery25519_n_6,32,
    precomputed_nP_montgomery25519_p_6,32,
  },
  {
    precomputed_nP_montgomery25519_q_7,32,
    precomputed_nP_montgomery25519_n_7,32,
    precomputed_nP_montgomery25519_p_7,32,
  },
  {
    precomputed_nP_montgomery25519_q_8,32,
    precomputed_nP_montgomery25519_n_8,32,
    precomputed_nP_montgomery25519_p_8,32,
  },
  {
    precomputed_nP_montgomery25519_q_9,32,
    precomputed_nP_montgomery25519_n_9,32,
    precomputed_nP_montgomery25519_p_9,32,
  },
  {
    precomputed_nP_montgomery25519_q_10,32,
    precomputed_nP_montgomery25519_n_10,32,
    precomputed_nP_montgomery25519_p_10,32,
  },
  {
    precomputed_nP_montgomery25519_q_11,32,
    precomputed_nP_montgomery25519_n_11,32,
    precomputed_nP_montgomery25519_p_11,32,
  },
  {
    precomputed_nP_montgomery25519_q_12,32,
    precomputed_nP_montgomery25519_n_12,32,
    precomputed_nP_montgomery25519_p_12,32,
  },
  {
    precomputed_nP_montgomery25519_q_13,32,
    precomputed_nP_montgomery25519_n_13,32,
    precomputed_nP_montgomery25519_p_13,32,
  },
  {
    precomputed_nP_montgomery25519_q_14,32,
    precomputed_nP_montgomery25519_n_14,32,
    precomputed_nP_montgomery25519_p_14,32,
  },
  {
    precomputed_nP_montgomery25519_q_15,32,
    precomputed_nP_montgomery25519_n_15,32,
    precomputed_nP_montgomery25519_p_15,32,
  },
  {
    precomputed_nP_montgomery25519_q_16,32,
    precomputed_nP_montgomery25519_n_16,32,
    precomputed_nP_montgomery25519_p_16,32,
  },
  {
    precomputed_nP_montgomery25519_q_17,32,
    precomputed_nP_montgomery25519_n_17,32,
    precomputed_nP_montgomery25519_p_17,32,
  },
  {
    precomputed_nP_montgomery25519_q_18,32,
    precomputed_nP_montgomery25519_n_18,32,
    precomputed_nP_montgomery25519_p_18,32,
  },
  {
    precomputed_nP_montgomery25519_q_19,32,
    precomputed_nP_montgomery25519_n_19,32,
    precomputed_nP_montgomery25519_p_19,32,
  },
  {
    precomputed_nP_montgomery25519_q_20,32,
    precomputed_nP_montgomery25519_n_20,32,
    precomputed_nP_montgomery25519_p_20,32,
  },
  {
    precomputed_nP_montgomery25519_q_21,32,
    precomputed_nP_montgomery25519_n_21,32,
    precomputed_nP_montgomery25519_p_21,32,
  },
  {
    precomputed_nP_montgomery25519_q_22,32,
    precomputed_nP_montgomery25519_n_22,32,
    precomputed_nP_montgomery25519_p_22,32,
  },
  {
    precomputed_nP_montgomery25519_q_23,32,
    precomputed_nP_montgomery25519_n_23,32,
    precomputed_nP_montgomery25519_p_23,32,
  },
  {
    precomputed_nP_montgomery25519_q_24,32,
    precomputed_nP_montgomery25519_n_24,32,
    precomputed_nP_montgomery25519_p_24,32,
  },
  {
    precomputed_nP_montgomery25519_q_25,32,
    precomputed_nP_montgomery25519_n_25,32,
    precomputed_nP_montgomery25519_p_25,32,
  },
  {
    precomputed_nP_montgomery25519_q_26,32,
    precomputed_nP_montgomery25519_n_26,32,
    precomputed_nP_montgomery25519_p_26,32,
  },
  {
    precomputed_nP_montgomery25519_q_27,32,
    precomputed_nP_montgomery25519_n_27,32,
    precomputed_nP_montgomery25519_p_27,32,
  },
  {
    precomputed_nP_montgomery25519_q_28,32,
    precomputed_nP_montgomery25519_n_28,32,
    precomputed_nP_montgomery25519_p_28,32,
  },
  {
    precomputed_nP_montgomery25519_q_29,32,
    precomputed_nP_montgomery25519_n_29,32,
    precomputed_nP_montgomery25519_p_29,32,
  },
  {
    precomputed_nP_montgomery25519_q_30,32,
    precomputed_nP_montgomery25519_n_30,32,
    precomputed_nP_montgomery25519_p_30,32,
  },
  {
    precomputed_nP_montgomery25519_q_31,32,
    precomputed_nP_montgomery25519_n_31,32,
    precomputed_nP_montgomery25519_p_31,32,
  },
  {
    precomputed_nP_montgomery25519_q_32,32,
    precomputed_nP_montgomery25519_n_32,32,
    precomputed_nP_montgomery25519_p_32,32,
  },
  {
    precomputed_nP_montgomery25519_q_33,32,
    precomputed_nP_montgomery25519_n_33,32,
    precomputed_nP_montgomery25519_p_33,32,
  },
  {
    precomputed_nP_montgomery25519_q_34,32,
    precomputed_nP_montgomery25519_n_34,32,
    precomputed_nP_montgomery25519_p_34,32,
  },
  {
    precomputed_nP_montgomery25519_q_35,32,
    precomputed_nP_montgomery25519_n_35,32,
    precomputed_nP_montgomery25519_p_35,32,
  },
  {
    precomputed_nP_montgomery25519_q_36,32,
    precomputed_nP_montgomery25519_n_36,32,
    precomputed_nP_montgomery25519_p_36,32,
  },
  {
    precomputed_nP_montgomery25519_q_37,32,
    precomputed_nP_montgomery25519_n_37,32,
    precomputed_nP_montgomery25519_p_37,32,
  },
  {
    precomputed_nP_montgomery25519_q_38,32,
    precomputed_nP_montgomery25519_n_38,32,
    precomputed_nP_montgomery25519_p_38,32,
  },
  {
    precomputed_nP_montgomery25519_q_39,32,
    precomputed_nP_montgomery25519_n_39,32,
    precomputed_nP_montgomery25519_p_39,32,
  },
  {
    precomputed_nP_montgomery25519_q_40,32,
    precomputed_nP_montgomery25519_n_40,32,
    precomputed_nP_montgomery25519_p_40,32,
  },
  {
    precomputed_nP_montgomery25519_q_41,32,
    precomputed_nP_montgomery25519_n_41,32,
    precomputed_nP_montgomery25519_p_41,32,
  },
  {
    precomputed_nP_montgomery25519_q_42,32,
    precomputed_nP_montgomery25519_n_42,32,
    precomputed_nP_montgomery25519_p_42,32,
  },
  {
    precomputed_nP_montgomery25519_q_43,32,
    precomputed_nP_montgomery25519_n_43,32,
    precomputed_nP_montgomery25519_p_43,32,
  },
  {
    precomputed_nP_montgomery25519_q_44,32,
    precomputed_nP_montgomery25519_n_44,32,
    precomputed_nP_montgomery25519_p_44,32,
  },
  {
    precomputed_nP_montgomery25519_q_45,32,
    precomputed_nP_montgomery25519_n_45,32,
    precomputed_nP_montgomery25519_p_45,32,
  },
  {
    precomputed_nP_montgomery25519_q_46,32,
    precomputed_nP_montgomery25519_n_46,32,
    precomputed_nP_montgomery25519_p_46,32,
  },
  {
    precomputed_nP_montgomery25519_q_47,32,
    precomputed_nP_montgomery25519_n_47,32,
    precomputed_nP_montgomery25519_p_47,32,
  },
  {
    precomputed_nP_montgomery25519_q_48,32,
    precomputed_nP_montgomery25519_n_48,32,
    precomputed_nP_montgomery25519_p_48,32,
  },
  {
    precomputed_nP_montgomery25519_q_49,32,
    precomputed_nP_montgomery25519_n_49,32,
    precomputed_nP_montgomery25519_p_49,32,
  },
  {
    precomputed_nP_montgomery25519_q_50,32,
    precomputed_nP_montgomery25519_n_50,32,
    precomputed_nP_montgomery25519_p_50,32,
  },
  {
    precomputed_nP_montgomery25519_q_51,32,
    precomputed_nP_montgomery25519_n_51,32,
    precomputed_nP_montgomery25519_p_51,32,
  },
  {
    precomputed_nP_montgomery25519_q_52,32,
    precomputed_nP_montgomery25519_n_52,32,
    precomputed_nP_montgomery25519_p_52,32,
  },
  {
    precomputed_nP_montgomery25519_q_53,32,
    precomputed_nP_montgomery25519_n_53,32,
    precomputed_nP_montgomery25519_p_53,32,
  },
  {
    precomputed_nP_montgomery25519_q_54,32,
    precomputed_nP_montgomery25519_n_54,32,
    precomputed_nP_montgomery25519_p_54,32,
  },
  {
    precomputed_nP_montgomery25519_q_55,32,
    precomputed_nP_montgomery25519_n_55,32,
    precomputed_nP_montgomery25519_p_55,32,
  },
  {
    precomputed_nP_montgomery25519_q_56,32,
    precomputed_nP_montgomery25519_n_56,32,
    precomputed_nP_montgomery25519_p_56,32,
  },
  {
    precomputed_nP_montgomery25519_q_57,32,
    precomputed_nP_montgomery25519_n_57,32,
    precomputed_nP_montgomery25519_p_57,32,
  },
  {
    precomputed_nP_montgomery25519_q_58,32,
    precomputed_nP_montgomery25519_n_58,32,
    precomputed_nP_montgomery25519_p_58,32,
  },
  {
    precomputed_nP_montgomery25519_q_59,32,
    precomputed_nP_montgomery25519_n_59,32,
    precomputed_nP_montgomery25519_p_59,32,
  },
  {
    precomputed_nP_montgomery25519_q_60,32,
    precomputed_nP_montgomery25519_n_60,32,
    precomputed_nP_montgomery25519_p_60,32,
  },
  {
    precomputed_nP_montgomery25519_q_61,32,
    precomputed_nP_montgomery25519_n_61,32,
    precomputed_nP_montgomery25519_p_61,32,
  },
  {
    precomputed_nP_montgomery25519_q_62,32,
    precomputed_nP_montgomery25519_n_62,32,
    precomputed_nP_montgomery25519_p_62,32,
  },
  {
    precomputed_nP_montgomery25519_q_63,32,
    precomputed_nP_montgomery25519_n_63,32,
    precomputed_nP_montgomery25519_p_63,32,
  },
  {
    precomputed_nP_montgomery25519_q_64,32,
    precomputed_nP_montgomery25519_n_64,32,
    precomputed_nP_montgomery25519_p_64,32,
  },
  {
    precomputed_nP_montgomery25519_q_65,32,
    precomputed_nP_montgomery25519_n_65,32,
    precomputed_nP_montgomery25519_p_65,32,
  },
  {
    precomputed_nP_montgomery25519_q_66,32,
    precomputed_nP_montgomery25519_n_66,32,
    precomputed_nP_montgomery25519_p_66,32,
  },
  {
    precomputed_nP_montgomery25519_q_67,32,
    precomputed_nP_montgomery25519_n_67,32,
    precomputed_nP_montgomery25519_p_67,32,
  },
  {
    precomputed_nP_montgomery25519_q_68,32,
    precomputed_nP_montgomery25519_n_68,32,
    precomputed_nP_montgomery25519_p_68,32,
  },
  {
    precomputed_nP_montgomery25519_q_69,32,
    precomputed_nP_montgomery25519_n_69,32,
    precomputed_nP_montgomery25519_p_69,32,
  },
  {
    precomputed_nP_montgomery25519_q_70,32,
    precomputed_nP_montgomery25519_n_70,32,
    precomputed_nP_montgomery25519_p_70,32,
  },
  {
    precomputed_nP_montgomery25519_q_71,32,
    precomputed_nP_montgomery25519_n_71,32,
    precomputed_nP_montgomery25519_p_71,32,
  },
  {
    precomputed_nP_montgomery25519_q_72,32,
    precomputed_nP_montgomery25519_n_72,32,
    precomputed_nP_montgomery25519_p_72,32,
  },
  {
    precomputed_nP_montgomery25519_q_73,32,
    precomputed_nP_montgomery25519_n_73,32,
    precomputed_nP_montgomery25519_p_73,32,
  },
  {
    precomputed_nP_montgomery25519_q_74,32,
    precomputed_nP_montgomery25519_n_74,32,
    precomputed_nP_montgomery25519_p_74,32,
  },
  {
    precomputed_nP_montgomery25519_q_75,32,
    precomputed_nP_montgomery25519_n_75,32,
    precomputed_nP_montgomery25519_p_75,32,
  },
  {
    precomputed_nP_montgomery25519_q_76,32,
    precomputed_nP_montgomery25519_n_76,32,
    precomputed_nP_montgomery25519_p_76,32,
  },
  {
    precomputed_nP_montgomery25519_q_77,32,
    precomputed_nP_montgomery25519_n_77,32,
    precomputed_nP_montgomery25519_p_77,32,
  },
  {
    precomputed_nP_montgomery25519_q_78,32,
    precomputed_nP_montgomery25519_n_78,32,
    precomputed_nP_montgomery25519_p_78,32,
  },
  {
    precomputed_nP_montgomery25519_q_79,32,
    precomputed_nP_montgomery25519_n_79,32,
    precomputed_nP_montgomery25519_p_79,32,
  },
  {
    precomputed_nP_montgomery25519_q_80,32,
    precomputed_nP_montgomery25519_n_80,32,
    precomputed_nP_montgomery25519_p_80,32,
  },
  {
    precomputed_nP_montgomery25519_q_81,32,
    precomputed_nP_montgomery25519_n_81,32,
    precomputed_nP_montgomery25519_p_81,32,
  },
  {
    precomputed_nP_montgomery25519_q_82,32,
    precomputed_nP_montgomery25519_n_82,32,
    precomputed_nP_montgomery25519_p_82,32,
  },
  {
    precomputed_nP_montgomery25519_q_83,32,
    precomputed_nP_montgomery25519_n_83,32,
    precomputed_nP_montgomery25519_p_83,32,
  },
  {
    precomputed_nP_montgomery25519_q_84,32,
    precomputed_nP_montgomery25519_n_84,32,
    precomputed_nP_montgomery25519_p_84,32,
  },
  {
    precomputed_nP_montgomery25519_q_85,32,
    precomputed_nP_montgomery25519_n_85,32,
    precomputed_nP_montgomery25519_p_85,32,
  },
  {
    precomputed_nP_montgomery25519_q_86,32,
    precomputed_nP_montgomery25519_n_86,32,
    precomputed_nP_montgomery25519_p_86,32,
  },
  {
    precomputed_nP_montgomery25519_q_87,32,
    precomputed_nP_montgomery25519_n_87,32,
    precomputed_nP_montgomery25519_p_87,32,
  },
  {
    precomputed_nP_montgomery25519_q_88,32,
    precomputed_nP_montgomery25519_n_88,32,
    precomputed_nP_montgomery25519_p_88,32,
  },
  {
    precomputed_nP_montgomery25519_q_89,32,
    precomputed_nP_montgomery25519_n_89,32,
    precomputed_nP_montgomery25519_p_89,32,
  },
  {
    precomputed_nP_montgomery25519_q_90,32,
    precomputed_nP_montgomery25519_n_90,32,
    precomputed_nP_montgomery25519_p_90,32,
  },
  {
    precomputed_nP_montgomery25519_q_91,32,
    precomputed_nP_montgomery25519_n_91,32,
    precomputed_nP_montgomery25519_p_91,32,
  },
  {
    precomputed_nP_montgomery25519_q_92,32,
    precomputed_nP_montgomery25519_n_92,32,
    precomputed_nP_montgomery25519_p_92,32,
  },
  {
    precomputed_nP_montgomery25519_q_93,32,
    precomputed_nP_montgomery25519_n_93,32,
    precomputed_nP_montgomery25519_p_93,32,
  },
  {
    precomputed_nP_montgomery25519_q_94,32,
    precomputed_nP_montgomery25519_n_94,32,
    precomputed_nP_montgomery25519_p_94,32,
  },
  {
    precomputed_nP_montgomery25519_q_95,32,
    precomputed_nP_montgomery25519_n_95,32,
    precomputed_nP_montgomery25519_p_95,32,
  },
  {
    precomputed_nP_montgomery25519_q_96,32,
    precomputed_nP_montgomery25519_n_96,32,
    precomputed_nP_montgomery25519_p_96,32,
  },
  {
    precomputed_nP_montgomery25519_q_97,32,
    precomputed_nP_montgomery25519_n_97,32,
    precomputed_nP_montgomery25519_p_97,32,
  },
  {
    precomputed_nP_montgomery25519_q_98,32,
    precomputed_nP_montgomery25519_n_98,32,
    precomputed_nP_montgomery25519_p_98,32,
  },
  {
    precomputed_nP_montgomery25519_q_99,32,
    precomputed_nP_montgomery25519_n_99,32,
    precomputed_nP_montgomery25519_p_99,32,
  },
  {
    precomputed_nP_montgomery25519_q_100,32,
    precomputed_nP_montgomery25519_n_100,32,
    precomputed_nP_montgomery25519_p_100,32,
  },
  {
    precomputed_nP_montgomery25519_q_101,32,
    precomputed_nP_montgomery25519_n_101,32,
    precomputed_nP_montgomery25519_p_101,32,
  },
  {
    precomputed_nP_montgomery25519_q_102,32,
    precomputed_nP_montgomery25519_n_102,32,
    precomputed_nP_montgomery25519_p_102,32,
  },
  {
    precomputed_nP_montgomery25519_q_103,32,
    precomputed_nP_montgomery25519_n_103,32,
    precomputed_nP_montgomery25519_p_103,32,
  },
  {
    precomputed_nP_montgomery25519_q_104,32,
    precomputed_nP_montgomery25519_n_104,32,
    precomputed_nP_montgomery25519_p_104,32,
  },
  {
    precomputed_nP_montgomery25519_q_105,32,
    precomputed_nP_montgomery25519_n_105,32,
    precomputed_nP_montgomery25519_p_105,32,
  },
  {
    precomputed_nP_montgomery25519_q_106,32,
    precomputed_nP_montgomery25519_n_106,32,
    precomputed_nP_montgomery25519_p_106,32,
  },
  {
    precomputed_nP_montgomery25519_q_107,32,
    precomputed_nP_montgomery25519_n_107,32,
    precomputed_nP_montgomery25519_p_107,32,
  },
  {
    precomputed_nP_montgomery25519_q_108,32,
    precomputed_nP_montgomery25519_n_108,32,
    precomputed_nP_montgomery25519_p_108,32,
  },
  {
    precomputed_nP_montgomery25519_q_109,32,
    precomputed_nP_montgomery25519_n_109,32,
    precomputed_nP_montgomery25519_p_109,32,
  },
  {
    precomputed_nP_montgomery25519_q_110,32,
    precomputed_nP_montgomery25519_n_110,32,
    precomputed_nP_montgomery25519_p_110,32,
  },
  {
    precomputed_nP_montgomery25519_q_111,32,
    precomputed_nP_montgomery25519_n_111,32,
    precomputed_nP_montgomery25519_p_111,32,
  },
  {
    precomputed_nP_montgomery25519_q_112,32,
    precomputed_nP_montgomery25519_n_112,32,
    precomputed_nP_montgomery25519_p_112,32,
  },
  {
    precomputed_nP_montgomery25519_q_113,32,
    precomputed_nP_montgomery25519_n_113,32,
    precomputed_nP_montgomery25519_p_113,32,
  },
  {
    precomputed_nP_montgomery25519_q_114,32,
    precomputed_nP_montgomery25519_n_114,32,
    precomputed_nP_montgomery25519_p_114,32,
  },
  {
    precomputed_nP_montgomery25519_q_115,32,
    precomputed_nP_montgomery25519_n_115,32,
    precomputed_nP_montgomery25519_p_115,32,
  },
  {
    precomputed_nP_montgomery25519_q_116,32,
    precomputed_nP_montgomery25519_n_116,32,
    precomputed_nP_montgomery25519_p_116,32,
  },
  {
    precomputed_nP_montgomery25519_q_117,32,
    precomputed_nP_montgomery25519_n_117,32,
    precomputed_nP_montgomery25519_p_117,32,
  },
  {
    precomputed_nP_montgomery25519_q_118,32,
    precomputed_nP_montgomery25519_n_118,32,
    precomputed_nP_montgomery25519_p_118,32,
  },
  {
    precomputed_nP_montgomery25519_q_119,32,
    precomputed_nP_montgomery25519_n_119,32,
    precomputed_nP_montgomery25519_p_119,32,
  },
  {
    precomputed_nP_montgomery25519_q_120,32,
    precomputed_nP_montgomery25519_n_120,32,
    precomputed_nP_montgomery25519_p_120,32,
  },
  {
    precomputed_nP_montgomery25519_q_121,32,
    precomputed_nP_montgomery25519_n_121,32,
    precomputed_nP_montgomery25519_p_121,32,
  },
  {
    precomputed_nP_montgomery25519_q_122,32,
    precomputed_nP_montgomery25519_n_122,32,
    precomputed_nP_montgomery25519_p_122,32,
  },
  {
    precomputed_nP_montgomery25519_q_123,32,
    precomputed_nP_montgomery25519_n_123,32,
    precomputed_nP_montgomery25519_p_123,32,
  },
  {
    precomputed_nP_montgomery25519_q_124,32,
    precomputed_nP_montgomery25519_n_124,32,
    precomputed_nP_montgomery25519_p_124,32,
  },
  {
    precomputed_nP_montgomery25519_q_125,32,
    precomputed_nP_montgomery25519_n_125,32,
    precomputed_nP_montgomery25519_p_125,32,
  },
  {
    precomputed_nP_montgomery25519_q_126,32,
    precomputed_nP_montgomery25519_n_126,32,
    precomputed_nP_montgomery25519_p_126,32,
  },
  {
    precomputed_nP_montgomery25519_q_127,32,
    precomputed_nP_montgomery25519_n_127,32,
    precomputed_nP_montgomery25519_p_127,32,
  },
  {
    precomputed_nP_montgomery25519_q_128,32,
    precomputed_nP_montgomery25519_n_128,32,
    precomputed_nP_montgomery25519_p_128,32,
  },
  {
    precomputed_nP_montgomery25519_q_129,32,
    precomputed_nP_montgomery25519_n_129,32,
    precomputed_nP_montgomery25519_p_129,32,
  },
  {
    precomputed_nP_montgomery25519_q_130,32,
    precomputed_nP_montgomery25519_n_130,32,
    precomputed_nP_montgomery25519_p_130,32,
  },
  {
    precomputed_nP_montgomery25519_q_131,32,
    precomputed_nP_montgomery25519_n_131,32,
    precomputed_nP_montgomery25519_p_131,32,
  },
  {
    precomputed_nP_montgomery25519_q_132,32,
    precomputed_nP_montgomery25519_n_132,32,
    precomputed_nP_montgomery25519_p_132,32,
  },
  {
    precomputed_nP_montgomery25519_q_133,32,
    precomputed_nP_montgomery25519_n_133,32,
    precomputed_nP_montgomery25519_p_133,32,
  },
  {
    precomputed_nP_montgomery25519_q_134,32,
    precomputed_nP_montgomery25519_n_134,32,
    precomputed_nP_montgomery25519_p_134,32,
  },
  {
    precomputed_nP_montgomery25519_q_135,32,
    precomputed_nP_montgomery25519_n_135,32,
    precomputed_nP_montgomery25519_p_135,32,
  },
  {
    precomputed_nP_montgomery25519_q_136,32,
    precomputed_nP_montgomery25519_n_136,32,
    precomputed_nP_montgomery25519_p_136,32,
  },
  {
    precomputed_nP_montgomery25519_q_137,32,
    precomputed_nP_montgomery25519_n_137,32,
    precomputed_nP_montgomery25519_p_137,32,
  },
  {
    precomputed_nP_montgomery25519_q_138,32,
    precomputed_nP_montgomery25519_n_138,32,
    precomputed_nP_montgomery25519_p_138,32,
  },
  {
    precomputed_nP_montgomery25519_q_139,32,
    precomputed_nP_montgomery25519_n_139,32,
    precomputed_nP_montgomery25519_p_139,32,
  },
  {
    precomputed_nP_montgomery25519_q_140,32,
    precomputed_nP_montgomery25519_n_140,32,
    precomputed_nP_montgomery25519_p_140,32,
  },
  {
    precomputed_nP_montgomery25519_q_141,32,
    precomputed_nP_montgomery25519_n_141,32,
    precomputed_nP_montgomery25519_p_141,32,
  },
  {
    precomputed_nP_montgomery25519_q_142,32,
    precomputed_nP_montgomery25519_n_142,32,
    precomputed_nP_montgomery25519_p_142,32,
  },
  {
    precomputed_nP_montgomery25519_q_143,32,
    precomputed_nP_montgomery25519_n_143,32,
    precomputed_nP_montgomery25519_p_143,32,
  },
  {
    precomputed_nP_montgomery25519_q_144,32,
    precomputed_nP_montgomery25519_n_144,32,
    precomputed_nP_montgomery25519_p_144,32,
  },
  {
    precomputed_nP_montgomery25519_q_145,32,
    precomputed_nP_montgomery25519_n_145,32,
    precomputed_nP_montgomery25519_p_145,32,
  },
  {
    precomputed_nP_montgomery25519_q_146,32,
    precomputed_nP_montgomery25519_n_146,32,
    precomputed_nP_montgomery25519_p_146,32,
  },
  {
    precomputed_nP_montgomery25519_q_147,32,
    precomputed_nP_montgomery25519_n_147,32,
    precomputed_nP_montgomery25519_p_147,32,
  },
  {
    precomputed_nP_montgomery25519_q_148,32,
    precomputed_nP_montgomery25519_n_148,32,
    precomputed_nP_montgomery25519_p_148,32,
  },
  {
    precomputed_nP_montgomery25519_q_149,32,
    precomputed_nP_montgomery25519_n_149,32,
    precomputed_nP_montgomery25519_p_149,32,
  },
  {
    precomputed_nP_montgomery25519_q_150,32,
    precomputed_nP_montgomery25519_n_150,32,
    precomputed_nP_montgomery25519_p_150,32,
  },
  {
    precomputed_nP_montgomery25519_q_151,32,
    precomputed_nP_montgomery25519_n_151,32,
    precomputed_nP_montgomery25519_p_151,32,
  },
  {
    precomputed_nP_montgomery25519_q_152,32,
    precomputed_nP_montgomery25519_n_152,32,
    precomputed_nP_montgomery25519_p_152,32,
  },
  {
    precomputed_nP_montgomery25519_q_153,32,
    precomputed_nP_montgomery25519_n_153,32,
    precomputed_nP_montgomery25519_p_153,32,
  },
  {
    precomputed_nP_montgomery25519_q_154,32,
    precomputed_nP_montgomery25519_n_154,32,
    precomputed_nP_montgomery25519_p_154,32,
  },
  {
    precomputed_nP_montgomery25519_q_155,32,
    precomputed_nP_montgomery25519_n_155,32,
    precomputed_nP_montgomery25519_p_155,32,
  },
  {
    precomputed_nP_montgomery25519_q_156,32,
    precomputed_nP_montgomery25519_n_156,32,
    precomputed_nP_montgomery25519_p_156,32,
  },
  {
    precomputed_nP_montgomery25519_q_157,32,
    precomputed_nP_montgomery25519_n_157,32,
    precomputed_nP_montgomery25519_p_157,32,
  },
  {
    precomputed_nP_montgomery25519_q_158,32,
    precomputed_nP_montgomery25519_n_158,32,
    precomputed_nP_montgomery25519_p_158,32,
  },
  {
    precomputed_nP_montgomery25519_q_159,32,
    precomputed_nP_montgomery25519_n_159,32,
    precomputed_nP_montgomery25519_p_159,32,
  },
  {
    precomputed_nP_montgomery25519_q_160,32,
    precomputed_nP_montgomery25519_n_160,32,
    precomputed_nP_montgomery25519_p_160,32,
  },
  {
    precomputed_nP_montgomery25519_q_161,32,
    precomputed_nP_montgomery25519_n_161,32,
    precomputed_nP_montgomery25519_p_161,32,
  },
  {
    precomputed_nP_montgomery25519_q_162,32,
    precomputed_nP_montgomery25519_n_162,32,
    precomputed_nP_montgomery25519_p_162,32,
  },
  {
    precomputed_nP_montgomery25519_q_163,32,
    precomputed_nP_montgomery25519_n_163,32,
    precomputed_nP_montgomery25519_p_163,32,
  },
  {
    precomputed_nP_montgomery25519_q_164,32,
    precomputed_nP_montgomery25519_n_164,32,
    precomputed_nP_montgomery25519_p_164,32,
  },
  {
    precomputed_nP_montgomery25519_q_165,32,
    precomputed_nP_montgomery25519_n_165,32,
    precomputed_nP_montgomery25519_p_165,32,
  },
  {
    precomputed_nP_montgomery25519_q_166,32,
    precomputed_nP_montgomery25519_n_166,32,
    precomputed_nP_montgomery25519_p_166,32,
  },
  {
    precomputed_nP_montgomery25519_q_167,32,
    precomputed_nP_montgomery25519_n_167,32,
    precomputed_nP_montgomery25519_p_167,32,
  },
  {
    precomputed_nP_montgomery25519_q_168,32,
    precomputed_nP_montgomery25519_n_168,32,
    precomputed_nP_montgomery25519_p_168,32,
  },
  {
    precomputed_nP_montgomery25519_q_169,32,
    precomputed_nP_montgomery25519_n_169,32,
    precomputed_nP_montgomery25519_p_169,32,
  },
  {
    precomputed_nP_montgomery25519_q_170,32,
    precomputed_nP_montgomery25519_n_170,32,
    precomputed_nP_montgomery25519_p_170,32,
  },
  {
    precomputed_nP_montgomery25519_q_171,32,
    precomputed_nP_montgomery25519_n_171,32,
    precomputed_nP_montgomery25519_p_171,32,
  },
  {
    precomputed_nP_montgomery25519_q_172,32,
    precomputed_nP_montgomery25519_n_172,32,
    precomputed_nP_montgomery25519_p_172,32,
  },
  {
    precomputed_nP_montgomery25519_q_173,32,
    precomputed_nP_montgomery25519_n_173,32,
    precomputed_nP_montgomery25519_p_173,32,
  },
  {
    precomputed_nP_montgomery25519_q_174,32,
    precomputed_nP_montgomery25519_n_174,32,
    precomputed_nP_montgomery25519_p_174,32,
  },
  {
    precomputed_nP_montgomery25519_q_175,32,
    precomputed_nP_montgomery25519_n_175,32,
    precomputed_nP_montgomery25519_p_175,32,
  },
  {
    precomputed_nP_montgomery25519_q_176,32,
    precomputed_nP_montgomery25519_n_176,32,
    precomputed_nP_montgomery25519_p_176,32,
  },
  {
    precomputed_nP_montgomery25519_q_177,32,
    precomputed_nP_montgomery25519_n_177,32,
    precomputed_nP_montgomery25519_p_177,32,
  },
  {
    precomputed_nP_montgomery25519_q_178,32,
    precomputed_nP_montgomery25519_n_178,32,
    precomputed_nP_montgomery25519_p_178,32,
  },
  {
    precomputed_nP_montgomery25519_q_179,32,
    precomputed_nP_montgomery25519_n_179,32,
    precomputed_nP_montgomery25519_p_179,32,
  },
  {
    precomputed_nP_montgomery25519_q_180,32,
    precomputed_nP_montgomery25519_n_180,32,
    precomputed_nP_montgomery25519_p_180,32,
  },
  {
    precomputed_nP_montgomery25519_q_181,32,
    precomputed_nP_montgomery25519_n_181,32,
    precomputed_nP_montgomery25519_p_181,32,
  },
  {
    precomputed_nP_montgomery25519_q_182,32,
    precomputed_nP_montgomery25519_n_182,32,
    precomputed_nP_montgomery25519_p_182,32,
  },
  {
    precomputed_nP_montgomery25519_q_183,32,
    precomputed_nP_montgomery25519_n_183,32,
    precomputed_nP_montgomery25519_p_183,32,
  },
  {
    precomputed_nP_montgomery25519_q_184,32,
    precomputed_nP_montgomery25519_n_184,32,
    precomputed_nP_montgomery25519_p_184,32,
  },
  {
    precomputed_nP_montgomery25519_q_185,32,
    precomputed_nP_montgomery25519_n_185,32,
    precomputed_nP_montgomery25519_p_185,32,
  },
  {
    precomputed_nP_montgomery25519_q_186,32,
    precomputed_nP_montgomery25519_n_186,32,
    precomputed_nP_montgomery25519_p_186,32,
  },
  {
    precomputed_nP_montgomery25519_q_187,32,
    precomputed_nP_montgomery25519_n_187,32,
    precomputed_nP_montgomery25519_p_187,32,
  },
  {
    precomputed_nP_montgomery25519_q_188,32,
    precomputed_nP_montgomery25519_n_188,32,
    precomputed_nP_montgomery25519_p_188,32,
  },
  {
    precomputed_nP_montgomery25519_q_189,32,
    precomputed_nP_montgomery25519_n_189,32,
    precomputed_nP_montgomery25519_p_189,32,
  },
  {
    precomputed_nP_montgomery25519_q_190,32,
    precomputed_nP_montgomery25519_n_190,32,
    precomputed_nP_montgomery25519_p_190,32,
  },
  {
    precomputed_nP_montgomery25519_q_191,32,
    precomputed_nP_montgomery25519_n_191,32,
    precomputed_nP_montgomery25519_p_191,32,
  },
  {
    precomputed_nP_montgomery25519_q_192,32,
    precomputed_nP_montgomery25519_n_192,32,
    precomputed_nP_montgomery25519_p_192,32,
  },
  {
    precomputed_nP_montgomery25519_q_193,32,
    precomputed_nP_montgomery25519_n_193,32,
    precomputed_nP_montgomery25519_p_193,32,
  },
  {
    precomputed_nP_montgomery25519_q_194,32,
    precomputed_nP_montgomery25519_n_194,32,
    precomputed_nP_montgomery25519_p_194,32,
  },
  {
    precomputed_nP_montgomery25519_q_195,32,
    precomputed_nP_montgomery25519_n_195,32,
    precomputed_nP_montgomery25519_p_195,32,
  },
  {
    precomputed_nP_montgomery25519_q_196,32,
    precomputed_nP_montgomery25519_n_196,32,
    precomputed_nP_montgomery25519_p_196,32,
  },
  {
    precomputed_nP_montgomery25519_q_197,32,
    precomputed_nP_montgomery25519_n_197,32,
    precomputed_nP_montgomery25519_p_197,32,
  },
  {
    precomputed_nP_montgomery25519_q_198,32,
    precomputed_nP_montgomery25519_n_198,32,
    precomputed_nP_montgomery25519_p_198,32,
  },
  {
    precomputed_nP_montgomery25519_q_199,32,
    precomputed_nP_montgomery25519_n_199,32,
    precomputed_nP_montgomery25519_p_199,32,
  },
  {
    precomputed_nP_montgomery25519_q_200,32,
    precomputed_nP_montgomery25519_n_200,32,
    precomputed_nP_montgomery25519_p_200,32,
  },
  {
    precomputed_nP_montgomery25519_q_201,32,
    precomputed_nP_montgomery25519_n_201,32,
    precomputed_nP_montgomery25519_p_201,32,
  },
  {
    precomputed_nP_montgomery25519_q_202,32,
    precomputed_nP_montgomery25519_n_202,32,
    precomputed_nP_montgomery25519_p_202,32,
  },
  {
    precomputed_nP_montgomery25519_q_203,32,
    precomputed_nP_montgomery25519_n_203,32,
    precomputed_nP_montgomery25519_p_203,32,
  },
  {
    precomputed_nP_montgomery25519_q_204,32,
    precomputed_nP_montgomery25519_n_204,32,
    precomputed_nP_montgomery25519_p_204,32,
  },
  {
    precomputed_nP_montgomery25519_q_205,32,
    precomputed_nP_montgomery25519_n_205,32,
    precomputed_nP_montgomery25519_p_205,32,
  },
  {
    precomputed_nP_montgomery25519_q_206,32,
    precomputed_nP_montgomery25519_n_206,32,
    precomputed_nP_montgomery25519_p_206,32,
  },
  {
    precomputed_nP_montgomery25519_q_207,32,
    precomputed_nP_montgomery25519_n_207,32,
    precomputed_nP_montgomery25519_p_207,32,
  },
  {
    precomputed_nP_montgomery25519_q_208,32,
    precomputed_nP_montgomery25519_n_208,32,
    precomputed_nP_montgomery25519_p_208,32,
  },
  {
    precomputed_nP_montgomery25519_q_209,32,
    precomputed_nP_montgomery25519_n_209,32,
    precomputed_nP_montgomery25519_p_209,32,
  },
  {
    precomputed_nP_montgomery25519_q_210,32,
    precomputed_nP_montgomery25519_n_210,32,
    precomputed_nP_montgomery25519_p_210,32,
  },
  {
    precomputed_nP_montgomery25519_q_211,32,
    precomputed_nP_montgomery25519_n_211,32,
    precomputed_nP_montgomery25519_p_211,32,
  },
  {
    precomputed_nP_montgomery25519_q_212,32,
    precomputed_nP_montgomery25519_n_212,32,
    precomputed_nP_montgomery25519_p_212,32,
  },
  {
    precomputed_nP_montgomery25519_q_213,32,
    precomputed_nP_montgomery25519_n_213,32,
    precomputed_nP_montgomery25519_p_213,32,
  },
  {
    precomputed_nP_montgomery25519_q_214,32,
    precomputed_nP_montgomery25519_n_214,32,
    precomputed_nP_montgomery25519_p_214,32,
  },
  {
    precomputed_nP_montgomery25519_q_215,32,
    precomputed_nP_montgomery25519_n_215,32,
    precomputed_nP_montgomery25519_p_215,32,
  },
  {
    precomputed_nP_montgomery25519_q_216,32,
    precomputed_nP_montgomery25519_n_216,32,
    precomputed_nP_montgomery25519_p_216,32,
  },
  {
    precomputed_nP_montgomery25519_q_217,32,
    precomputed_nP_montgomery25519_n_217,32,
    precomputed_nP_montgomery25519_p_217,32,
  },
  {
    precomputed_nP_montgomery25519_q_218,32,
    precomputed_nP_montgomery25519_n_218,32,
    precomputed_nP_montgomery25519_p_218,32,
  },
  {
    precomputed_nP_montgomery25519_q_219,32,
    precomputed_nP_montgomery25519_n_219,32,
    precomputed_nP_montgomery25519_p_219,32,
  },
  {
    precomputed_nP_montgomery25519_q_220,32,
    precomputed_nP_montgomery25519_n_220,32,
    precomputed_nP_montgomery25519_p_220,32,
  },
  {
    precomputed_nP_montgomery25519_q_221,32,
    precomputed_nP_montgomery25519_n_221,32,
    precomputed_nP_montgomery25519_p_221,32,
  },
  {
    precomputed_nP_montgomery25519_q_222,32,
    precomputed_nP_montgomery25519_n_222,32,
    precomputed_nP_montgomery25519_p_222,32,
  },
  {
    precomputed_nP_montgomery25519_q_223,32,
    precomputed_nP_montgomery25519_n_223,32,
    precomputed_nP_montgomery25519_p_223,32,
  },
  {
    precomputed_nP_montgomery25519_q_224,32,
    precomputed_nP_montgomery25519_n_224,32,
    precomputed_nP_montgomery25519_p_224,32,
  },
  {
    precomputed_nP_montgomery25519_q_225,32,
    precomputed_nP_montgomery25519_n_225,32,
    precomputed_nP_montgomery25519_p_225,32,
  },
  {
    precomputed_nP_montgomery25519_q_226,32,
    precomputed_nP_montgomery25519_n_226,32,
    precomputed_nP_montgomery25519_p_226,32,
  },
  {
    precomputed_nP_montgomery25519_q_227,32,
    precomputed_nP_montgomery25519_n_227,32,
    precomputed_nP_montgomery25519_p_227,32,
  },
  {
    precomputed_nP_montgomery25519_q_228,32,
    precomputed_nP_montgomery25519_n_228,32,
    precomputed_nP_montgomery25519_p_228,32,
  },
  {
    precomputed_nP_montgomery25519_q_229,32,
    precomputed_nP_montgomery25519_n_229,32,
    precomputed_nP_montgomery25519_p_229,32,
  },
  {
    precomputed_nP_montgomery25519_q_230,32,
    precomputed_nP_montgomery25519_n_230,32,
    precomputed_nP_montgomery25519_p_230,32,
  },
  {
    precomputed_nP_montgomery25519_q_231,32,
    precomputed_nP_montgomery25519_n_231,32,
    precomputed_nP_montgomery25519_p_231,32,
  },
  {
    precomputed_nP_montgomery25519_q_232,32,
    precomputed_nP_montgomery25519_n_232,32,
    precomputed_nP_montgomery25519_p_232,32,
  },
  {
    precomputed_nP_montgomery25519_q_233,32,
    precomputed_nP_montgomery25519_n_233,32,
    precomputed_nP_montgomery25519_p_233,32,
  },
  {
    precomputed_nP_montgomery25519_q_234,32,
    precomputed_nP_montgomery25519_n_234,32,
    precomputed_nP_montgomery25519_p_234,32,
  },
  {
    precomputed_nP_montgomery25519_q_235,32,
    precomputed_nP_montgomery25519_n_235,32,
    precomputed_nP_montgomery25519_p_235,32,
  },
  {
    precomputed_nP_montgomery25519_q_236,32,
    precomputed_nP_montgomery25519_n_236,32,
    precomputed_nP_montgomery25519_p_236,32,
  },
  {
    precomputed_nP_montgomery25519_q_237,32,
    precomputed_nP_montgomery25519_n_237,32,
    precomputed_nP_montgomery25519_p_237,32,
  },
  {
    precomputed_nP_montgomery25519_q_238,32,
    precomputed_nP_montgomery25519_n_238,32,
    precomputed_nP_montgomery25519_p_238,32,
  },
  {
    precomputed_nP_montgomery25519_q_239,32,
    precomputed_nP_montgomery25519_n_239,32,
    precomputed_nP_montgomery25519_p_239,32,
  },
  {
    precomputed_nP_montgomery25519_q_240,32,
    precomputed_nP_montgomery25519_n_240,32,
    precomputed_nP_montgomery25519_p_240,32,
  },
  {
    precomputed_nP_montgomery25519_q_241,32,
    precomputed_nP_montgomery25519_n_241,32,
    precomputed_nP_montgomery25519_p_241,32,
  },
  {
    precomputed_nP_montgomery25519_q_242,32,
    precomputed_nP_montgomery25519_n_242,32,
    precomputed_nP_montgomery25519_p_242,32,
  },
  {
    precomputed_nP_montgomery25519_q_243,32,
    precomputed_nP_montgomery25519_n_243,32,
    precomputed_nP_montgomery25519_p_243,32,
  },
  {
    precomputed_nP_montgomery25519_q_244,32,
    precomputed_nP_montgomery25519_n_244,32,
    precomputed_nP_montgomery25519_p_244,32,
  },
  {
    precomputed_nP_montgomery25519_q_245,32,
    precomputed_nP_montgomery25519_n_245,32,
    precomputed_nP_montgomery25519_p_245,32,
  },
  {
    precomputed_nP_montgomery25519_q_246,32,
    precomputed_nP_montgomery25519_n_246,32,
    precomputed_nP_montgomery25519_p_246,32,
  },
  {
    precomputed_nP_montgomery25519_q_247,32,
    precomputed_nP_montgomery25519_n_247,32,
    precomputed_nP_montgomery25519_p_247,32,
  },
  {
    precomputed_nP_montgomery25519_q_248,32,
    precomputed_nP_montgomery25519_n_248,32,
    precomputed_nP_montgomery25519_p_248,32,
  },
  {
    precomputed_nP_montgomery25519_q_249,32,
    precomputed_nP_montgomery25519_n_249,32,
    precomputed_nP_montgomery25519_p_249,32,
  },
  {
    precomputed_nP_montgomery25519_q_250,32,
    precomputed_nP_montgomery25519_n_250,32,
    precomputed_nP_montgomery25519_p_250,32,
  },
  {
    precomputed_nP_montgomery25519_q_251,32,
    precomputed_nP_montgomery25519_n_251,32,
    precomputed_nP_montgomery25519_p_251,32,
  },
  {
    precomputed_nP_montgomery25519_q_252,32,
    precomputed_nP_montgomery25519_n_252,32,
    precomputed_nP_montgomery25519_p_252,32,
  },
  {
    precomputed_nP_montgomery25519_q_253,32,
    precomputed_nP_montgomery25519_n_253,32,
    precomputed_nP_montgomery25519_p_253,32,
  },
  {
    precomputed_nP_montgomery25519_q_254,32,
    precomputed_nP_montgomery25519_n_254,32,
    precomputed_nP_montgomery25519_p_254,32,
  },
  {
    precomputed_nP_montgomery25519_q_255,32,
    precomputed_nP_montgomery25519_n_255,32,
    precomputed_nP_montgomery25519_p_255,32,
  },
  {
    precomputed_nP_montgomery25519_q_256,32,
    precomputed_nP_montgomery25519_n_256,32,
    precomputed_nP_montgomery25519_p_256,32,
  },
  {
    precomputed_nP_montgomery25519_q_257,32,
    precomputed_nP_montgomery25519_n_257,32,
    precomputed_nP_montgomery25519_p_257,32,
  },
  {
    precomputed_nP_montgomery25519_q_258,32,
    precomputed_nP_montgomery25519_n_258,32,
    precomputed_nP_montgomery25519_p_258,32,
  },
  {
    precomputed_nP_montgomery25519_q_259,32,
    precomputed_nP_montgomery25519_n_259,32,
    precomputed_nP_montgomery25519_p_259,32,
  },
  {
    precomputed_nP_montgomery25519_q_260,32,
    precomputed_nP_montgomery25519_n_260,32,
    precomputed_nP_montgomery25519_p_260,32,
  },
  {
    precomputed_nP_montgomery25519_q_261,32,
    precomputed_nP_montgomery25519_n_261,32,
    precomputed_nP_montgomery25519_p_261,32,
  },
  {
    precomputed_nP_montgomery25519_q_262,32,
    precomputed_nP_montgomery25519_n_262,32,
    precomputed_nP_montgomery25519_p_262,32,
  },
  {
    precomputed_nP_montgomery25519_q_263,32,
    precomputed_nP_montgomery25519_n_263,32,
    precomputed_nP_montgomery25519_p_263,32,
  },
  {
    precomputed_nP_montgomery25519_q_264,32,
    precomputed_nP_montgomery25519_n_264,32,
    precomputed_nP_montgomery25519_p_264,32,
  },
  {
    precomputed_nP_montgomery25519_q_265,32,
    precomputed_nP_montgomery25519_n_265,32,
    precomputed_nP_montgomery25519_p_265,32,
  },
  {
    precomputed_nP_montgomery25519_q_266,32,
    precomputed_nP_montgomery25519_n_266,32,
    precomputed_nP_montgomery25519_p_266,32,
  },
  {
    precomputed_nP_montgomery25519_q_267,32,
    precomputed_nP_montgomery25519_n_267,32,
    precomputed_nP_montgomery25519_p_267,32,
  },
  {
    precomputed_nP_montgomery25519_q_268,32,
    precomputed_nP_montgomery25519_n_268,32,
    precomputed_nP_montgomery25519_p_268,32,
  },
  {
    precomputed_nP_montgomery25519_q_269,32,
    precomputed_nP_montgomery25519_n_269,32,
    precomputed_nP_montgomery25519_p_269,32,
  },
  {
    precomputed_nP_montgomery25519_q_270,32,
    precomputed_nP_montgomery25519_n_270,32,
    precomputed_nP_montgomery25519_p_270,32,
  },
  {
    precomputed_nP_montgomery25519_q_271,32,
    precomputed_nP_montgomery25519_n_271,32,
    precomputed_nP_montgomery25519_p_271,32,
  },
  {
    precomputed_nP_montgomery25519_q_272,32,
    precomputed_nP_montgomery25519_n_272,32,
    precomputed_nP_montgomery25519_p_272,32,
  },
  {
    precomputed_nP_montgomery25519_q_273,32,
    precomputed_nP_montgomery25519_n_273,32,
    precomputed_nP_montgomery25519_p_273,32,
  },
  {
    precomputed_nP_montgomery25519_q_274,32,
    precomputed_nP_montgomery25519_n_274,32,
    precomputed_nP_montgomery25519_p_274,32,
  },
  {
    precomputed_nP_montgomery25519_q_275,32,
    precomputed_nP_montgomery25519_n_275,32,
    precomputed_nP_montgomery25519_p_275,32,
  },
  {
    precomputed_nP_montgomery25519_q_276,32,
    precomputed_nP_montgomery25519_n_276,32,
    precomputed_nP_montgomery25519_p_276,32,
  },
  {
    precomputed_nP_montgomery25519_q_277,32,
    precomputed_nP_montgomery25519_n_277,32,
    precomputed_nP_montgomery25519_p_277,32,
  },
  {
    precomputed_nP_montgomery25519_q_278,32,
    precomputed_nP_montgomery25519_n_278,32,
    precomputed_nP_montgomery25519_p_278,32,
  },
  {
    precomputed_nP_montgomery25519_q_279,32,
    precomputed_nP_montgomery25519_n_279,32,
    precomputed_nP_montgomery25519_p_279,32,
  },
  {
    precomputed_nP_montgomery25519_q_280,32,
    precomputed_nP_montgomery25519_n_280,32,
    precomputed_nP_montgomery25519_p_280,32,
  },
  {
    precomputed_nP_montgomery25519_q_281,32,
    precomputed_nP_montgomery25519_n_281,32,
    precomputed_nP_montgomery25519_p_281,32,
  },
  {
    precomputed_nP_montgomery25519_q_282,32,
    precomputed_nP_montgomery25519_n_282,32,
    precomputed_nP_montgomery25519_p_282,32,
  },
  {
    precomputed_nP_montgomery25519_q_283,32,
    precomputed_nP_montgomery25519_n_283,32,
    precomputed_nP_montgomery25519_p_283,32,
  },
  {
    precomputed_nP_montgomery25519_q_284,32,
    precomputed_nP_montgomery25519_n_284,32,
    precomputed_nP_montgomery25519_p_284,32,
  },
  {
    precomputed_nP_montgomery25519_q_285,32,
    precomputed_nP_montgomery25519_n_285,32,
    precomputed_nP_montgomery25519_p_285,32,
  },
  {
    precomputed_nP_montgomery25519_q_286,32,
    precomputed_nP_montgomery25519_n_286,32,
    precomputed_nP_montgomery25519_p_286,32,
  },
  {
    precomputed_nP_montgomery25519_q_287,32,
    precomputed_nP_montgomery25519_n_287,32,
    precomputed_nP_montgomery25519_p_287,32,
  },
  {
    precomputed_nP_montgomery25519_q_288,32,
    precomputed_nP_montgomery25519_n_288,32,
    precomputed_nP_montgomery25519_p_288,32,
  },
  {
    precomputed_nP_montgomery25519_q_289,32,
    precomputed_nP_montgomery25519_n_289,32,
    precomputed_nP_montgomery25519_p_289,32,
  },
  {
    precomputed_nP_montgomery25519_q_290,32,
    precomputed_nP_montgomery25519_n_290,32,
    precomputed_nP_montgomery25519_p_290,32,
  },
  {
    precomputed_nP_montgomery25519_q_291,32,
    precomputed_nP_montgomery25519_n_291,32,
    precomputed_nP_montgomery25519_p_291,32,
  },
  {
    precomputed_nP_montgomery25519_q_292,32,
    precomputed_nP_montgomery25519_n_292,32,
    precomputed_nP_montgomery25519_p_292,32,
  },
  {
    precomputed_nP_montgomery25519_q_293,32,
    precomputed_nP_montgomery25519_n_293,32,
    precomputed_nP_montgomery25519_p_293,32,
  },
  {
    precomputed_nP_montgomery25519_q_294,32,
    precomputed_nP_montgomery25519_n_294,32,
    precomputed_nP_montgomery25519_p_294,32,
  },
  {
    precomputed_nP_montgomery25519_q_295,32,
    precomputed_nP_montgomery25519_n_295,32,
    precomputed_nP_montgomery25519_p_295,32,
  },
  {
    precomputed_nP_montgomery25519_q_296,32,
    precomputed_nP_montgomery25519_n_296,32,
    precomputed_nP_montgomery25519_p_296,32,
  },
  {
    precomputed_nP_montgomery25519_q_297,32,
    precomputed_nP_montgomery25519_n_297,32,
    precomputed_nP_montgomery25519_p_297,32,
  },
  {
    precomputed_nP_montgomery25519_q_298,32,
    precomputed_nP_montgomery25519_n_298,32,
    precomputed_nP_montgomery25519_p_298,32,
  },
  {
    precomputed_nP_montgomery25519_q_299,32,
    precomputed_nP_montgomery25519_n_299,32,
    precomputed_nP_montgomery25519_p_299,32,
  },
  {
    precomputed_nP_montgomery25519_q_300,32,
    precomputed_nP_montgomery25519_n_300,32,
    precomputed_nP_montgomery25519_p_300,32,
  },
  {
    precomputed_nP_montgomery25519_q_301,32,
    precomputed_nP_montgomery25519_n_301,32,
    precomputed_nP_montgomery25519_p_301,32,
  },
  {
    precomputed_nP_montgomery25519_q_302,32,
    precomputed_nP_montgomery25519_n_302,32,
    precomputed_nP_montgomery25519_p_302,32,
  },
  {
    precomputed_nP_montgomery25519_q_303,32,
    precomputed_nP_montgomery25519_n_303,32,
    precomputed_nP_montgomery25519_p_303,32,
  },
  {
    precomputed_nP_montgomery25519_q_304,32,
    precomputed_nP_montgomery25519_n_304,32,
    precomputed_nP_montgomery25519_p_304,32,
  },
  {
    precomputed_nP_montgomery25519_q_305,32,
    precomputed_nP_montgomery25519_n_305,32,
    precomputed_nP_montgomery25519_p_305,32,
  },
  {
    precomputed_nP_montgomery25519_q_306,32,
    precomputed_nP_montgomery25519_n_306,32,
    precomputed_nP_montgomery25519_p_306,32,
  },
  {
    precomputed_nP_montgomery25519_q_307,32,
    precomputed_nP_montgomery25519_n_307,32,
    precomputed_nP_montgomery25519_p_307,32,
  },
  {
    precomputed_nP_montgomery25519_q_308,32,
    precomputed_nP_montgomery25519_n_308,32,
    precomputed_nP_montgomery25519_p_308,32,
  },
  {
    precomputed_nP_montgomery25519_q_309,32,
    precomputed_nP_montgomery25519_n_309,32,
    precomputed_nP_montgomery25519_p_309,32,
  },
  {
    precomputed_nP_montgomery25519_q_310,32,
    precomputed_nP_montgomery25519_n_310,32,
    precomputed_nP_montgomery25519_p_310,32,
  },
  {
    precomputed_nP_montgomery25519_q_311,32,
    precomputed_nP_montgomery25519_n_311,32,
    precomputed_nP_montgomery25519_p_311,32,
  },
  {
    precomputed_nP_montgomery25519_q_312,32,
    precomputed_nP_montgomery25519_n_312,32,
    precomputed_nP_montgomery25519_p_312,32,
  },
  {
    precomputed_nP_montgomery25519_q_313,32,
    precomputed_nP_montgomery25519_n_313,32,
    precomputed_nP_montgomery25519_p_313,32,
  },
  {
    precomputed_nP_montgomery25519_q_314,32,
    precomputed_nP_montgomery25519_n_314,32,
    precomputed_nP_montgomery25519_p_314,32,
  },
  {
    precomputed_nP_montgomery25519_q_315,32,
    precomputed_nP_montgomery25519_n_315,32,
    precomputed_nP_montgomery25519_p_315,32,
  },
  {
    precomputed_nP_montgomery25519_q_316,32,
    precomputed_nP_montgomery25519_n_316,32,
    precomputed_nP_montgomery25519_p_316,32,
  },
  {
    precomputed_nP_montgomery25519_q_317,32,
    precomputed_nP_montgomery25519_n_317,32,
    precomputed_nP_montgomery25519_p_317,32,
  },
  {
    precomputed_nP_montgomery25519_q_318,32,
    precomputed_nP_montgomery25519_n_318,32,
    precomputed_nP_montgomery25519_p_318,32,
  },
  {
    precomputed_nP_montgomery25519_q_319,32,
    precomputed_nP_montgomery25519_n_319,32,
    precomputed_nP_montgomery25519_p_319,32,
  },
  {
    precomputed_nP_montgomery25519_q_320,32,
    precomputed_nP_montgomery25519_n_320,32,
    precomputed_nP_montgomery25519_p_320,32,
  },
  {
    precomputed_nP_montgomery25519_q_321,32,
    precomputed_nP_montgomery25519_n_321,32,
    precomputed_nP_montgomery25519_p_321,32,
  },
  {
    precomputed_nP_montgomery25519_q_322,32,
    precomputed_nP_montgomery25519_n_322,32,
    precomputed_nP_montgomery25519_p_322,32,
  },
  {
    precomputed_nP_montgomery25519_q_323,32,
    precomputed_nP_montgomery25519_n_323,32,
    precomputed_nP_montgomery25519_p_323,32,
  },
  {
    precomputed_nP_montgomery25519_q_324,32,
    precomputed_nP_montgomery25519_n_324,32,
    precomputed_nP_montgomery25519_p_324,32,
  },
  {
    precomputed_nP_montgomery25519_q_325,32,
    precomputed_nP_montgomery25519_n_325,32,
    precomputed_nP_montgomery25519_p_325,32,
  },
  {
    precomputed_nP_montgomery25519_q_326,32,
    precomputed_nP_montgomery25519_n_326,32,
    precomputed_nP_montgomery25519_p_326,32,
  },
  {
    precomputed_nP_montgomery25519_q_327,32,
    precomputed_nP_montgomery25519_n_327,32,
    precomputed_nP_montgomery25519_p_327,32,
  },
  {
    precomputed_nP_montgomery25519_q_328,32,
    precomputed_nP_montgomery25519_n_328,32,
    precomputed_nP_montgomery25519_p_328,32,
  },
  {
    precomputed_nP_montgomery25519_q_329,32,
    precomputed_nP_montgomery25519_n_329,32,
    precomputed_nP_montgomery25519_p_329,32,
  },
  {
    precomputed_nP_montgomery25519_q_330,32,
    precomputed_nP_montgomery25519_n_330,32,
    precomputed_nP_montgomery25519_p_330,32,
  },
  {
    precomputed_nP_montgomery25519_q_331,32,
    precomputed_nP_montgomery25519_n_331,32,
    precomputed_nP_montgomery25519_p_331,32,
  },
  {
    precomputed_nP_montgomery25519_q_332,32,
    precomputed_nP_montgomery25519_n_332,32,
    precomputed_nP_montgomery25519_p_332,32,
  },
  {
    precomputed_nP_montgomery25519_q_333,32,
    precomputed_nP_montgomery25519_n_333,32,
    precomputed_nP_montgomery25519_p_333,32,
  },
  {
    precomputed_nP_montgomery25519_q_334,32,
    precomputed_nP_montgomery25519_n_334,32,
    precomputed_nP_montgomery25519_p_334,32,
  },
  {
    precomputed_nP_montgomery25519_q_335,32,
    precomputed_nP_montgomery25519_n_335,32,
    precomputed_nP_montgomery25519_p_335,32,
  },
  {
    precomputed_nP_montgomery25519_q_336,32,
    precomputed_nP_montgomery25519_n_336,32,
    precomputed_nP_montgomery25519_p_336,32,
  },
  {
    precomputed_nP_montgomery25519_q_337,32,
    precomputed_nP_montgomery25519_n_337,32,
    precomputed_nP_montgomery25519_p_337,32,
  },
  {
    precomputed_nP_montgomery25519_q_338,32,
    precomputed_nP_montgomery25519_n_338,32,
    precomputed_nP_montgomery25519_p_338,32,
  },
  {
    precomputed_nP_montgomery25519_q_339,32,
    precomputed_nP_montgomery25519_n_339,32,
    precomputed_nP_montgomery25519_p_339,32,
  },
  {
    precomputed_nP_montgomery25519_q_340,32,
    precomputed_nP_montgomery25519_n_340,32,
    precomputed_nP_montgomery25519_p_340,32,
  },
  {
    precomputed_nP_montgomery25519_q_341,32,
    precomputed_nP_montgomery25519_n_341,32,
    precomputed_nP_montgomery25519_p_341,32,
  },
  {
    precomputed_nP_montgomery25519_q_342,32,
    precomputed_nP_montgomery25519_n_342,32,
    precomputed_nP_montgomery25519_p_342,32,
  },
  {
    precomputed_nP_montgomery25519_q_343,32,
    precomputed_nP_montgomery25519_n_343,32,
    precomputed_nP_montgomery25519_p_343,32,
  },
  {
    precomputed_nP_montgomery25519_q_344,32,
    precomputed_nP_montgomery25519_n_344,32,
    precomputed_nP_montgomery25519_p_344,32,
  },
  {
    precomputed_nP_montgomery25519_q_345,32,
    precomputed_nP_montgomery25519_n_345,32,
    precomputed_nP_montgomery25519_p_345,32,
  },
  {
    precomputed_nP_montgomery25519_q_346,32,
    precomputed_nP_montgomery25519_n_346,32,
    precomputed_nP_montgomery25519_p_346,32,
  },
  {
    precomputed_nP_montgomery25519_q_347,32,
    precomputed_nP_montgomery25519_n_347,32,
    precomputed_nP_montgomery25519_p_347,32,
  },
  {
    precomputed_nP_montgomery25519_q_348,32,
    precomputed_nP_montgomery25519_n_348,32,
    precomputed_nP_montgomery25519_p_348,32,
  },
  {
    precomputed_nP_montgomery25519_q_349,32,
    precomputed_nP_montgomery25519_n_349,32,
    precomputed_nP_montgomery25519_p_349,32,
  },
  {
    precomputed_nP_montgomery25519_q_350,32,
    precomputed_nP_montgomery25519_n_350,32,
    precomputed_nP_montgomery25519_p_350,32,
  },
  {
    precomputed_nP_montgomery25519_q_351,32,
    precomputed_nP_montgomery25519_n_351,32,
    precomputed_nP_montgomery25519_p_351,32,
  },
  {
    precomputed_nP_montgomery25519_q_352,32,
    precomputed_nP_montgomery25519_n_352,32,
    precomputed_nP_montgomery25519_p_352,32,
  },
  {
    precomputed_nP_montgomery25519_q_353,32,
    precomputed_nP_montgomery25519_n_353,32,
    precomputed_nP_montgomery25519_p_353,32,
  },
  {
    precomputed_nP_montgomery25519_q_354,32,
    precomputed_nP_montgomery25519_n_354,32,
    precomputed_nP_montgomery25519_p_354,32,
  },
  {
    precomputed_nP_montgomery25519_q_355,32,
    precomputed_nP_montgomery25519_n_355,32,
    precomputed_nP_montgomery25519_p_355,32,
  },
  {
    precomputed_nP_montgomery25519_q_356,32,
    precomputed_nP_montgomery25519_n_356,32,
    precomputed_nP_montgomery25519_p_356,32,
  },
  {
    precomputed_nP_montgomery25519_q_357,32,
    precomputed_nP_montgomery25519_n_357,32,
    precomputed_nP_montgomery25519_p_357,32,
  },
  {
    precomputed_nP_montgomery25519_q_358,32,
    precomputed_nP_montgomery25519_n_358,32,
    precomputed_nP_montgomery25519_p_358,32,
  },
  {
    precomputed_nP_montgomery25519_q_359,32,
    precomputed_nP_montgomery25519_n_359,32,
    precomputed_nP_montgomery25519_p_359,32,
  },
  {
    precomputed_nP_montgomery25519_q_360,32,
    precomputed_nP_montgomery25519_n_360,32,
    precomputed_nP_montgomery25519_p_360,32,
  },
  {
    precomputed_nP_montgomery25519_q_361,32,
    precomputed_nP_montgomery25519_n_361,32,
    precomputed_nP_montgomery25519_p_361,32,
  },
  {
    precomputed_nP_montgomery25519_q_362,32,
    precomputed_nP_montgomery25519_n_362,32,
    precomputed_nP_montgomery25519_p_362,32,
  },
  {
    precomputed_nP_montgomery25519_q_363,32,
    precomputed_nP_montgomery25519_n_363,32,
    precomputed_nP_montgomery25519_p_363,32,
  },
  {
    precomputed_nP_montgomery25519_q_364,32,
    precomputed_nP_montgomery25519_n_364,32,
    precomputed_nP_montgomery25519_p_364,32,
  },
  {
    precomputed_nP_montgomery25519_q_365,32,
    precomputed_nP_montgomery25519_n_365,32,
    precomputed_nP_montgomery25519_p_365,32,
  },
  {
    precomputed_nP_montgomery25519_q_366,32,
    precomputed_nP_montgomery25519_n_366,32,
    precomputed_nP_montgomery25519_p_366,32,
  },
  {
    precomputed_nP_montgomery25519_q_367,32,
    precomputed_nP_montgomery25519_n_367,32,
    precomputed_nP_montgomery25519_p_367,32,
  },
  {
    precomputed_nP_montgomery25519_q_368,32,
    precomputed_nP_montgomery25519_n_368,32,
    precomputed_nP_montgomery25519_p_368,32,
  },
  {
    precomputed_nP_montgomery25519_q_369,32,
    precomputed_nP_montgomery25519_n_369,32,
    precomputed_nP_montgomery25519_p_369,32,
  },
  {
    precomputed_nP_montgomery25519_q_370,32,
    precomputed_nP_montgomery25519_n_370,32,
    precomputed_nP_montgomery25519_p_370,32,
  },
  {
    precomputed_nP_montgomery25519_q_371,32,
    precomputed_nP_montgomery25519_n_371,32,
    precomputed_nP_montgomery25519_p_371,32,
  },
} ;

static void test_nP_montgomery25519_impl(long long impl)
{
  unsigned char *q = test_nP_montgomery25519_q;
  unsigned char *n = test_nP_montgomery25519_n;
  unsigned char *p = test_nP_montgomery25519_p;
  unsigned char *q2 = test_nP_montgomery25519_q2;
  unsigned char *n2 = test_nP_montgomery25519_n2;
  unsigned char *p2 = test_nP_montgomery25519_p2;
  long long qlen = crypto_nP_POINTBYTES;
  long long nlen = crypto_nP_SCALARBYTES;
  long long plen = crypto_nP_POINTBYTES;

  if (targeti && strcmp(targeti,lib25519_dispatch_nP_montgomery25519_implementation(impl))) return;
  if (impl >= 0) {
    crypto_nP = lib25519_dispatch_nP_montgomery25519(impl);
    printf("nP_montgomery25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nP_montgomery25519_implementation(impl),lib25519_dispatch_nP_montgomery25519_compiler(impl));
  } else {
    crypto_nP = lib25519_nP_montgomery25519;
    printf("nP_montgomery25519 selected implementation %s compiler %s\n",lib25519_nP_montgomery25519_implementation(),lib25519_nP_montgomery25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      input_prepare(p2,p,plen);
      crypto_nP(q,n,p);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nP");
      input_compare(n2,n,nlen,"crypto_nP");
      input_compare(p2,p,plen,"crypto_nP");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      crypto_nP(q2,n2,p2);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nP is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      crypto_nP(n2,n2,p);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nP does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
      crypto_nP(p2,n,p2);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_nP does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(nP_montgomery25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nP_montgomery25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_nP_montgomery25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nP_montgomery25519[precomp].nsize);
    memcpy(n,precomputed_nP_montgomery25519[precomp].n,precomputed_nP_montgomery25519[precomp].nsize);
    memcpy(n2,precomputed_nP_montgomery25519[precomp].n,precomputed_nP_montgomery25519[precomp].nsize);
    input_prepare(p2,p,precomputed_nP_montgomery25519[precomp].psize);
    memcpy(p,precomputed_nP_montgomery25519[precomp].p,precomputed_nP_montgomery25519[precomp].psize);
    memcpy(p2,precomputed_nP_montgomery25519[precomp].p,precomputed_nP_montgomery25519[precomp].psize);
    crypto_nP(q,n,p);
    if (memcmp(q,precomputed_nP_montgomery25519[precomp].q,precomputed_nP_montgomery25519[precomp].qsize)) {
      fail("failure: crypto_nP fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nP_montgomery25519[precomp].qsize;++pos) printf("%02x",precomputed_nP_montgomery25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nP_montgomery25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nP_montgomery25519[precomp].qsize,"crypto_nP");
    input_compare(n2,n,precomputed_nP_montgomery25519[precomp].nsize,"crypto_nP");
    input_compare(p2,p,precomputed_nP_montgomery25519[precomp].psize,"crypto_nP");
  }
}

static void test_nP_montgomery25519(void)
{
  if (targeto && strcmp(targeto,"nP")) return;
  if (targetp && strcmp(targetp,"montgomery25519")) return;
  test_nP_montgomery25519_q = alignedcalloc(crypto_nP_POINTBYTES);
  test_nP_montgomery25519_n = alignedcalloc(crypto_nP_SCALARBYTES+crypto_nP_POINTBYTES);
  test_nP_montgomery25519_p = alignedcalloc(crypto_nP_POINTBYTES);
  test_nP_montgomery25519_q2 = alignedcalloc(crypto_nP_POINTBYTES);
  test_nP_montgomery25519_n2 = alignedcalloc(crypto_nP_SCALARBYTES+crypto_nP_POINTBYTES);
  test_nP_montgomery25519_p2 = alignedcalloc(crypto_nP_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("nP_montgomery25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nP_montgomery25519();++impl)
      forked(test_nP_montgomery25519_impl,impl);
    ++test_nP_montgomery25519_q;
    ++test_nP_montgomery25519_n;
    ++test_nP_montgomery25519_p;
    ++test_nP_montgomery25519_q2;
    ++test_nP_montgomery25519_n2;
    ++test_nP_montgomery25519_p2;
  }
}
#undef crypto_nP_SCALARBYTES
#undef crypto_nP_POINTBYTES


/* ----- nPbatch, derived from supercop/crypto_nPbatch/try.c */
static const char *nPbatch_montgomery25519_checksums[] = {
  "70ad918d115325afd930af794ffaa7941a917fcda4f80a02079566e6164fa970",
  "a0b24a12c2f75852961141d12324d5ee943e8200fcba97c56ce239362e4cdda3",
} ;

static void (*crypto_nPbatch)(unsigned char *,const unsigned char *,const unsigned char *,long long);
#define crypto_nPbatch_SCALARBYTES lib25519_nPbatch_montgomery25519_SCALARBYTES
#define crypto_nPbatch_POINTBYTES lib25519_nPbatch_montgomery25519_POINTBYTES

static unsigned char *test_nPbatch_montgomery25519_q;
static unsigned char *test_nPbatch_montgomery25519_n;
static unsigned char *test_nPbatch_montgomery25519_p;
static unsigned char *test_nPbatch_montgomery25519_q2;
static unsigned char *test_nPbatch_montgomery25519_n2;
static unsigned char *test_nPbatch_montgomery25519_p2;

#define precomputed_nPbatch_montgomery25519_NUM 17

static const unsigned char precomputed_nPbatch_montgomery25519_q_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_n_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_p_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_q_1[] = {132,211,21,191,66,248,248,89,73,111,43,217,220,90,21,178,4,219,49,48,22,113,99,190,107,95,35,114,217,59,197,42};
static const unsigned char precomputed_nPbatch_montgomery25519_n_1[] = {233,7,88,169,245,138,136,155,68,93,31,123,215,120,20,114,152,0,25,64,65,69,245,208,239,35,197,64,79,172,241,2};
static const unsigned char precomputed_nPbatch_montgomery25519_p_1[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_nPbatch_montgomery25519_q_2[] = {217,115,32,35,66,144,65,8,25,143,191,82,225,61,129,97,90,4,150,71,57,17,1,231,14,199,229,207,221,174,89,13,33,8,41,21,196,57,27,11,142,108,106,99,167,6,192,237,255,230,224,36,117,7,242,70,226,111,243,213,61,23,15,53};
static const unsigned char precomputed_nPbatch_montgomery25519_n_2[] = {2,222,22,131,160,78,116,188,224,216,251,122,243,253,84,123,180,252,82,233,141,218,42,150,213,250,32,17,174,233,198,144,77,142,218,116,40,190,158,142,14,25,103,22,220,112,238,115,106,208,60,113,132,11,139,211,134,73,184,101,247,197,94,92};
static const unsigned char precomputed_nPbatch_montgomery25519_p_2[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,46,183,255,198,153,158,240,122,231,14,3,68,224,88,41,255,150,5,100,114,25,47,223,131,156,7,132,91,115,13,36};
static const unsigned char precomputed_nPbatch_montgomery25519_q_3[] = {69,121,86,227,222,239,11,208,33,176,252,85,217,169,174,186,246,248,170,213,13,176,85,81,25,23,34,81,251,61,27,15,31,224,135,97,215,173,1,8,159,103,168,115,190,1,26,137,189,20,155,104,150,122,79,28,21,220,74,33,159,177,72,76,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nPbatch_montgomery25519_n_3[] = {232,59,52,197,225,94,168,91,231,73,162,9,196,84,83,9,115,91,228,28,110,247,129,120,199,247,248,114,2,161,167,146,250,114,79,178,120,16,130,147,4,253,171,208,74,42,200,186,236,25,149,137,139,159,200,123,139,203,55,136,171,168,21,138,236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nPbatch_montgomery25519_p_3[] = {216,133,220,191,70,32,82,157,83,231,220,192,43,155,5,1,175,92,52,144,185,209,117,107,251,155,54,254,111,193,98,99,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_4[] = {162,93,163,159,20,188,94,13,51,72,116,75,189,214,110,123,124,9,238,31,79,7,237,111,225,81,4,77,40,149,130,82,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,49,255,250,144,86,100,223,59,248,213,193,15,175,5,233,5,93,3,178,104,161,187,55,226,138,69,127,23,37,210,251,30,136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nPbatch_montgomery25519_n_4[] = {249,136,238,59,164,86,241,133,205,15,12,226,199,113,49,1,247,239,150,87,31,12,54,21,210,187,99,46,64,166,182,166,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,53,245,55,25,59,19,52,104,12,190,154,155,254,60,211,10,173,59,255,119,78,185,214,240,80,140,246,173,40,214,178,31,142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nPbatch_montgomery25519_p_4[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,9,183,167,211,71,178,197,159,211,252,106,164,133,217,230,19,245,215,29,92,240,192,129,163,60,151,149,102,219,251,61,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_5[] = {228,112,130,63,107,81,23,249,186,10,22,86,99,174,198,10,157,41,6,67,30,228,13,31,83,154,42,32,230,159,64,116,237,233,209,128,35,74,98,191,219,14,142,247,21,184,48,218,12,66,235,142,38,201,74,115,203,99,197,195,181,145,64,18,215,194,226,30,5,48,102,158,105,8,172,181,127,251,175,126,0,25,101,220,84,10,197,19,105,58,237,49,123,52,190,117,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106};
static const unsigned char precomputed_nPbatch_montgomery25519_n_5[] = {29,139,208,144,158,44,163,1,154,204,136,129,249,124,170,119,165,192,236,183,170,69,227,92,93,168,183,102,236,70,132,35,128,176,62,75,113,107,246,234,120,66,247,56,41,217,30,167,80,190,150,146,17,193,11,247,74,235,142,53,223,132,110,26,31,239,111,66,250,165,152,62,61,1,47,9,134,219,166,127,174,8,170,206,103,158,99,99,235,95,103,58,250,213,120,252,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42};
static const unsigned char precomputed_nPbatch_montgomery25519_p_5[] = {56,103,119,158,120,22,48,230,208,156,54,119,226,189,178,33,160,83,156,57,66,229,19,16,110,194,27,195,36,104,230,50,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66};
static const unsigned char precomputed_nPbatch_montgomery25519_q_6[] = {8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,235,14,110,53,191,65,207,130,47,77,134,173,120,240,222,139,29,180,151,72,162,218,70,217,73,77,253,120,147,236,10,61,184,152,148,235,8,16,51,133,188,254,11,79,161,191,124,78,106,124,211,231,108,219,92,138,18,188,205,203,223,38,138,118,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106};
static const unsigned char precomputed_nPbatch_montgomery25519_n_6[] = {42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,242,118,199,205,119,164,108,93,255,103,82,80,71,24,76,10,37,191,147,128,26,14,16,1,201,170,187,82,112,15,231,179,10,131,96,200,92,222,33,20,40,227,105,197,27,52,94,103,254,50,55,208,121,2,232,214,99,15,32,20,15,43,222,109,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42};
static const unsigned char precomputed_nPbatch_montgomery25519_p_6[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66};
static const unsigned char precomputed_nPbatch_montgomery25519_q_7[] = {116,70,20,190,1,228,58,162,97,230,38,210,46,203,75,121,38,47,150,168,111,194,217,74,139,93,163,63,251,59,118,43,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48,143,113,135,245,250,124,30,154,148,22,222,2,117,102,37,93,250,232,201,25,74,171,107,245,58,131,36,66,114,107,208,2,99,251,119,112,231,187,226,19,201,44,152,12,75,37,149,216,238,92,77,90,182,244,215,236,152,248,64,29,159,78,248,62,64,91,102,139,101,206,222,171,228,8,235,102,170,68,4,28,147,133,171,48,83,187,216,119,107,20,43,2,254,116,218,94,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48};
static const unsigned char precomputed_nPbatch_montgomery25519_n_7[] = {24,143,235,33,67,131,180,27,71,202,101,41,90,157,230,92,56,143,162,41,110,98,199,236,58,206,79,101,250,17,98,84,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187,182,169,173,124,154,41,121,130,249,60,17,47,224,46,34,4,109,78,19,61,55,95,38,31,3,241,167,172,114,247,68,94,231,146,78,235,9,155,237,211,193,96,61,198,102,79,190,77,54,114,95,224,213,45,193,36,145,253,126,52,11,186,208,182,117,246,27,36,54,185,197,126,128,70,19,206,190,244,213,241,2,214,6,42,73,184,224,42,134,19,67,210,95,131,206,65,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187};
static const unsigned char precomputed_nPbatch_montgomery25519_p_7[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148};
static const unsigned char precomputed_nPbatch_montgomery25519_q_8[] = {5,168,106,188,73,12,34,187,203,246,72,18,25,207,249,218,205,93,206,60,174,15,128,30,117,208,119,125,204,0,69,104,45,234,189,106,93,41,197,201,25,229,188,27,200,109,20,28,157,91,139,137,162,0,243,82,191,136,58,230,14,123,21,126,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,247,47,178,248,52,54,192,213,119,42,9,99,242,192,111,160,106,220,145,217,226,58,89,18,9,81,100,252,221,221,46,36,55,236,229,245,79,207,49,203,20,232,169,77,191,14,108,115,63,173,247,108,115,162,142,117,229,217,72,26,175,68,106,66,245,111,3,98,139,24,189,155,145,236,234,46,217,98,153,28,247,110,223,14,222,218,185,48,86,154,56,134,240,21,93,24,51,215,230,138,23,30,88,143,60,86,238,203,211,116,63,245,76,50,7,178,47,174,153,162,153,90,26,244,64,247,126};
static const unsigned char precomputed_nPbatch_montgomery25519_n_8[] = {116,185,13,114,141,41,129,67,255,178,218,214,149,9,141,97,144,215,186,32,22,135,194,93,20,52,11,141,223,165,75,67,196,142,88,86,120,128,248,216,203,143,30,145,212,88,8,226,44,209,237,51,95,0,37,209,222,37,184,14,51,238,143,113,218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,173,229,74,44,190,251,221,217,123,144,158,53,116,65,212,153,140,78,191,166,177,29,200,208,116,177,250,141,151,172,255,18,238,205,118,104,224,32,1,124,103,246,230,131,211,47,8,131,118,55,85,122,152,0,26,90,147,81,190,53,208,236,202,243,23,50,2,94,118,21,204,94,239,46,9,3,10,238,121,200,247,28,126,236,204,216,61,30,175,166,142,170,88,128,44,182,176,167,216,65,10,75,148,78,76,151,92,161,168,237,252,14,170,191,18,24,113,151,192,59,92,204,29,110,25,193,162,76,139,212,131,124,25,171,27,175,3,6,47,161,15,105,79,142,37,119,173,48,58,0,91,57,41,8,131,142,248,37,47,75};
static const unsigned char precomputed_nPbatch_montgomery25519_p_8[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,166,71,52,250,165,142,124,133,244,167,47,167,159,231,196,183,228,176,163,220,102,133,113,231,10,178,182,106,107,111,142,89,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,183,227,89,201,132,189,69,4,190,233,93,209,47,210,121,112,180,254,123,62,210,123,36,178,222,2,150,99,8,35,66,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_nPbatch_montgomery25519_q_9[] = {84,52,11,125,245,132,150,18,72,100,216,10,97,116,194,219,120,17,230,231,77,86,11,115,18,17,117,83,207,244,176,124,121,232,151,106,249,132,75,30,73,205,71,105,61,158,181,131,150,161,64,69,138,140,30,8,40,61,72,109,102,207,107,46,228,228,179,142,119,218,163,179,18,100,15,16,219,88,146,63,140,252,124,190,66,108,232,165,55,163,242,240,143,207,151,79,170,208,209,190,88,225,4,146,80,242,232,41,199,19,207,109,186,249,155,73,43,228,161,96,105,32,252,159,150,203,35,3,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,218,19,60,95,164,29,193,143,31,60,118,76,181,15,34,25,36,25,107,130,112,1,254,30,88,119,91,143,204,104,68,115,85,216,96,126,239,24,171,238,158,88,201,26,202,187,130,154,241,114,114,95,95,29,6,98,33,120,172,125,108,180,197,114,118,218,149,241,214,33,125,242,130,22,147,72,83,220,163,24,130,172,18,66,72,206,244,12,146,34,20,156,123,174,125,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_n_9[] = {138,118,50,4,97,30,223,67,133,227,178,230,148,132,25,72,174,35,177,140,212,86,244,251,114,81,166,39,66,105,57,204,176,21,36,69,234,239,12,133,189,95,127,247,243,129,176,233,252,210,8,4,62,179,45,71,132,151,131,142,107,226,149,82,253,78,2,197,246,2,80,67,175,244,59,34,195,228,158,234,134,91,114,225,55,146,120,105,181,188,229,205,129,46,176,76,178,94,69,233,220,50,222,130,166,39,181,69,40,191,116,203,151,218,24,220,132,222,107,236,239,184,160,139,114,252,191,162,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,102,244,58,119,155,31,176,155,201,67,186,91,94,48,167,170,255,129,116,151,167,203,173,120,226,156,230,70,180,187,160,129,190,147,100,101,77,151,179,249,20,102,182,218,161,187,38,207,142,126,195,32,205,249,96,90,162,80,63,226,98,120,239,127,65,99,53,92,228,166,24,237,239,207,164,149,189,109,242,0,113,5,174,121,235,137,62,7,24,44,128,29,111,223,2,8,29,96,25,19,112,147,141,120,188,41,78,222,44,150,121,75,69,175,171,106,40,52,87,126,121,16,126,87,23,36,150,140};
static const unsigned char precomputed_nPbatch_montgomery25519_p_9[] = {224,127,120,206,90,168,171,155,214,37,59,146,114,174,149,43,10,200,87,58,190,106,83,37,22,129,102,187,150,99,56,112,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,231,77,226,40,229,224,72,3,74,203,150,143,218,164,211,149,236,191,232,231,122,157,146,89,72,59,89,49,46,161,128,143,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_10[] = {227,182,214,47,131,182,21,112,64,150,229,231,76,159,115,101,254,178,24,4,238,128,253,76,19,54,242,153,40,8,96,107,155,56,106,143,220,91,199,35,51,40,34,60,68,132,234,215,235,216,224,102,48,147,31,123,65,192,218,123,192,69,204,88,56,21,5,209,153,28,67,172,37,109,174,13,123,39,248,41,6,32,97,215,136,83,40,105,144,155,46,38,66,191,92,111,161,223,243,227,234,158,42,211,46,211,205,39,166,23,202,203,26,65,220,32,37,204,145,199,242,178,16,111,221,227,215,116,218,151,19,123,28,234,235,200,163,179,10,170,252,43,86,73,85,71,114,100,167,146,135,33,146,246,108,40,7,137,39,115,255,82,248,88,61,49,168,220,29,130,1,110,152,243,156,136,217,219,236,92,185,217,90,81,253,170,11,27,2,238,82,54,43,186,50,61,113,54,20,246,129,62,252,230,142,137,188,131,52,135,179,98,232,100,109,104,47,120,116,195,104,53,219,76,73,60,108,146,86,171,58,233,185,238,63,146,73,30,24,34,168,99,126,227,84,5,105,118,225,99,196,231,236,222,30,78,135,110,236,86,44,66,16,135,102,160,234,251,75,169,40,162,23,252,170,56,119,186,208,82,4,133,157,1,170,36,83,77,79,44,236,112,159,54,150,95,117,110,182,61,177,18,158,99,107,124,142,159,114,211,46,83,130,42,252,119,143,232,229,84};
static const unsigned char precomputed_nPbatch_montgomery25519_n_10[] = {212,34,94,235,200,193,0,184,101,187,23,99,253,170,8,165,176,93,221,119,178,52,105,186,227,109,125,247,157,129,161,28,216,66,150,88,66,14,93,184,117,133,100,210,116,16,39,29,158,140,14,79,195,252,81,101,222,179,28,201,66,97,137,95,216,225,212,157,91,85,59,235,154,67,45,114,168,180,42,127,197,112,107,19,206,209,121,58,84,128,9,85,201,218,145,12,128,211,202,5,133,44,165,24,11,106,41,213,148,126,225,3,196,79,227,38,11,161,243,167,11,73,135,245,143,32,105,241,7,253,193,58,175,41,205,115,33,166,243,153,184,10,43,46,177,68,128,214,230,75,53,63,110,205,14,138,28,4,170,122,114,237,141,232,195,47,33,59,235,143,14,231,243,190,94,78,53,71,137,45,84,252,75,0,62,232,175,124,142,112,220,222,140,20,116,65,40,144,224,107,218,207,103,120,233,230,200,36,235,153,213,2,165,191,132,50,23,197,154,210,54,80,227,225,122,58,111,170,110,97,174,165,185,228,229,99,23,86,80,121,81,137,76,171,44,133,24,21,47,189,44,142,110,203,172,228,193,95,146,115,121,195,161,67,226,160,12,126,178,128,86,146,245,113,187,78,36,100,116,199,49,41,122,79,39,152,203,40,167,187,243,125,206,236,2,177,69,39,27,152,40,227,228,231,28,216,46,12,238,71,36,195,154,40,15,179,66,180,77,245};
static const unsigned char precomputed_nPbatch_montgomery25519_p_10[] = {108,20,31,116,94,141,126,45,163,85,126,44,19,190,238,243,224,86,12,212,102,52,127,109,241,32,139,167,37,52,87,39,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,207,108,156,64,182,29,155,51,168,111,164,225,193,194,145,89,21,77,220,193,35,3,222,175,89,78,123,87,130,50,248,22,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,16,248,176,17,243,88,13,137,6,58,182,139,221,105,188,108,139,108,94,186,224,118,160,35,97,77,197,56,233,17,190,206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,142,22,38,205,200,222,195,37,214,165,19,37,81,22,87,95,227,152,243,211,179,168,34,169,78,193,55,91,16,56,230,222,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_11[] = {8,100,222,18,220,20,218,99,254,188,214,171,119,88,234,228,50,86,45,103,188,156,0,91,129,17,52,149,192,244,246,108,139,147,141,94,93,143,239,121,211,81,7,154,161,209,7,107,178,61,20,223,137,117,220,32,14,123,164,122,20,46,70,31,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,146,43,123,255,31,155,213,85,188,25,221,200,248,13,245,68,170,167,163,189,220,88,41,78,249,84,138,234,158,186,176,75,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,167,69,92,82,21,33,118,83,239,21,209,140,157,76,171,158,207,12,119,240,246,209,154,135,0,78,7,81,200,101,186,99,8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,40,200,204,209,91,183,68,11,249,72,60,139,63,177,138,71,245,134,205,27,114,128,202,70,153,135,44,233,35,233,100,28,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,118,218,149,241,214,33,125,242,130,22,147,72,83,220,163,24,130,172,18,66,72,206,244,12,146,34,20,156,123,174,125,122,119,243,169,67,101,142,55,101,19,229,2,251,162,150,18,160,112,134,178,193,7,225,98,208,156,230,253,183,65,134,234,30};
static const unsigned char precomputed_nPbatch_montgomery25519_n_11[] = {145,52,243,43,154,181,28,84,69,217,127,105,124,26,144,86,194,239,44,38,126,15,220,245,35,24,159,43,124,97,207,182,217,184,164,88,62,54,210,17,153,249,234,177,206,234,187,1,173,27,4,169,47,206,63,97,199,12,146,88,111,217,78,65,235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,147,175,202,105,252,90,225,232,240,127,173,129,198,217,39,91,13,202,235,161,2,63,4,105,31,248,88,122,189,14,202,217,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,251,163,38,67,159,49,110,10,31,29,115,131,183,15,141,31,33,127,239,142,94,23,75,0,189,146,169,229,4,13,46,20,42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,211,246,247,134,90,237,209,205,238,198,243,113,12,34,103,183,150,113,189,173,254,100,88,246,192,98,123,82,70,180,97,180,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,65,99,53,92,228,166,24,237,239,207,164,149,189,109,242,0,113,5,174,121,235,137,62,7,24,44,128,29,111,223,2,8,139,232,90,130,109,54,160,143,19,93,33,62,239,86,106,141,212,170,67,203,91,227,33,162,207,68,209,31,55,222,213,61};
static const unsigned char precomputed_nPbatch_montgomery25519_p_11[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nPbatch_montgomery25519_q_12[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,90,21,239,238,78,202,71,98,221,74,25,14,52,104,86,203,129,112,143,228,68,7,250,19,186,252,225,53,99,87,39,95,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,49,171,76,227,245,47,149,115,6,126,210,49,141,165,156,142,7,128,23,25,254,255,223,153,207,248,237,162,250,198,67,156,161,169,73,10,135,164,15,62,197,29,189,29,233,29,213,248,37,51,240,20,220,225,237,118,6,251,192,160,51,249,13,128,200,33,171,61,181,149,40,157,81,87,232,179,117,143,223,16,178,66,151,121,165,153,244,21,43,97,130,164,152,211,35,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,218,19,60,95,164,29,193,143,31,60,118,76,181,15,34,25,36,25,107,130,112,1,254,30,88,119,91,143,204,104,68,115,191,96,234,8,162,191,161,169,220,137,105,236,215,170,48,86,253,59,49,95,28,131,143,42,119,57,37,26,0,6,3,74};
static const unsigned char precomputed_nPbatch_montgomery25519_n_12[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,90,45,40,212,48,116,157,8,31,149,17,162,168,8,80,160,222,248,234,103,130,82,113,71,231,32,77,51,157,127,251,13,160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,46,91,106,192,105,223,139,150,210,41,132,178,108,215,36,18,140,88,150,236,62,245,186,175,145,96,199,179,208,55,177,25,129,142,251,243,96,133,162,230,82,12,236,18,159,228,13,83,177,127,202,40,226,42,20,212,223,131,93,100,186,166,252,46,228,205,241,152,208,216,43,53,3,195,46,142,103,217,206,84,73,194,178,157,241,64,165,11,152,2,113,151,69,234,12,192,123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,102,244,58,119,155,31,176,155,201,67,186,91,94,48,167,170,255,129,116,151,167,203,173,120,226,156,230,70,180,187,160,129,75,114,85,162,109,230,214,121,39,165,181,96,16,182,162,72,61,8,9,52,189,26,92,30,158,109,130,167,215,80,130,122};
static const unsigned char precomputed_nPbatch_montgomery25519_p_12[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,221,110,85,119,102,142,32,139,41,201,114,77,187,166,133,54,229,25,180,236,76,218,201,124,44,182,42,4,183,49,172,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_13[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,133,37,52,169,133,200,97,68,65,139,30,226,202,18,162,33,55,136,193,253,245,29,8,169,139,55,159,251,46,166,107,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,227,182,214,47,131,182,21,112,64,150,229,231,76,159,115,101,254,178,24,4,238,128,253,76,19,54,242,153,40,8,96,107,110,203,38,47,155,200,34,223,176,221,103,84,230,144,95,250,34,28,202,120,170,176,202,218,74,129,95,249,77,229,72,123,190,145,102,90,116,173,9,96,1,136,94,70,240,65,189,201,171,145,254,247,129,62,21,105,243,190,11,68,201,228,8,12,8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,4,243,251,109,137,210,96,75,126,55,164,203,108,60,142,184,22,115,198,64,107,67,90,220,241,226,200,57,51,125,193,103,231,135,174,215,156,67,163,120,76,181,241,178,10,247,172,245,31,239,228,196,174,195,118,22,142,51,13,168,31,199,62,43,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nPbatch_montgomery25519_n_13[] = {107,186,160,142,195,202,118,52,209,113,10,53,105,99,156,228,1,98,117,197,252,194,43,191,179,77,159,99,106,32,14,129,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,66,162,214,17,77,227,115,67,248,216,210,73,216,96,172,93,126,63,38,233,228,89,232,80,113,127,88,112,85,247,241,224,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,212,34,94,235,200,193,0,184,101,187,23,99,253,170,8,165,176,93,221,119,178,52,105,186,227,109,125,247,157,129,161,28,1,212,157,103,232,159,234,223,107,249,58,63,187,122,154,71,215,115,105,125,123,13,216,158,238,87,62,1,147,150,74,91,225,250,207,49,79,0,242,177,148,78,153,60,96,143,63,27,126,123,35,67,94,64,246,82,4,143,123,46,214,217,4,203,42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,204,176,178,17,32,215,206,10,207,12,78,92,119,191,189,237,111,57,21,219,243,225,101,99,132,103,153,131,44,57,99,194,205,134,235,203,124,126,159,19,10,114,85,61,128,28,54,139,148,212,84,221,41,170,135,244,16,248,51,220,233,21,148,142,122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nPbatch_montgomery25519_p_13[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,20,31,116,94,141,126,45,163,85,126,44,19,190,238,243,224,86,12,212,102,52,127,109,241,32,139,167,37,52,87,39,125,242,29,114,232,48,27,244,31,171,46,41,1,218,112,38,126,119,17,27,127,158,41,97,36,105,51,103,198,133,79,214,23,11,234,10,227,139,156,80,199,166,30,156,2,164,43,61,58,71,110,74,197,50,42,192,114,28,144,175,233,77,233,181,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,185,44,222,234,105,45,228,84,211,77,226,210,230,92,138,18,64,100,12,109,20,161,29,169,107,73,50,2,113,32,184,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_14[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77,62,0,123,251,99,62,66,71,243,231,164,120,115,181,126,254,237,36,36,32,140,194,68,35,73,35,222,199,199,107,28,117,218,151,19,123,28,234,235,200,163,179,10,170,252,43,86,73,85,71,114,100,167,146,135,33,146,246,108,40,7,137,39,115,239,148,237,0,202,18,221,76,204,192,173,223,64,192,155,240,126,69,40,188,148,63,98,179,153,171,127,132,205,146,38,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77,143,113,135,245,250,124,30,154,148,22,222,2,117,102,37,93,250,232,201,25,74,171,107,245,58,131,36,66,114,107,208,2,237,127,188,222,241,16,254,146,84,195,223,127,96,31,31,85,67,186,200,162,130,186,146,173,211,182,140,232,125,203,222,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,236,127,198,169,148,118,83,58,50,75,21,133,21,65,45,14,189,87,81,215,96,59,78,219,142,162,18,59,85,83,99};
static const unsigned char precomputed_nPbatch_montgomery25519_n_14[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,22,25,157,191,182,145,141,114,11,227,34,104,72,192,36,19,221,45,137,85,89,83,163,40,16,141,176,151,27,155,53,98,7,253,193,58,175,41,205,115,33,166,243,153,184,10,43,46,177,68,128,214,230,75,53,63,110,205,14,138,28,4,170,122,252,94,239,81,117,164,15,227,11,136,47,221,160,0,112,48,75,245,169,49,28,66,103,200,31,165,123,91,102,225,49,181,139,146,167,138,83,58,254,190,251,60,110,156,52,211,217,116,28,175,54,171,72,205,88,250,162,123,91,36,201,104,201,225,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,182,169,173,124,154,41,121,130,249,60,17,47,224,46,34,4,109,78,19,61,55,95,38,31,3,241,167,172,114,247,68,94,199,15,246,104,121,68,176,114,148,63,133,234,196,214,43,48,37,221,32,76,238,144,186,125,120,124,75,164,245,223,232,123,29,96,25,19,112,147,141,120,188,41,78,222,44,150,121,75,69,175,171,106,40,52,87,126,121,16,126,87,23,36,150,140,160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,42,75,239,217,24,95,98,148,232,45,231,23,58,147,211,241,137,82,226,205,0,137,96,60,250,6,17,71,225,110,153,121};
static const unsigned char precomputed_nPbatch_montgomery25519_p_14[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,33,33,195,205,95,87,46,215,226,73,47,6,206,1,220,87,223,209,122,91,233,94,210,113,168,229,78,121,87,53,230,92,16,248,176,17,243,88,13,137,6,58,182,139,221,105,188,108,139,108,94,186,224,118,160,35,97,77,197,56,233,17,190,90,240,227,251,144,184,238,241,55,58,14,223,188,73,5,141,231,144,206,200,253,27,157,213,251,175,49,90,4,21,43,193,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,91,92,141,74,120,143,102,65,177,14,15,243,89,123,207,69,62,223,25,195,152,71,40,96,65,238,58,41,216,213,97,82,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nPbatch_montgomery25519_q_15[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,232,223,29,50,126,217,13,125,105,77,176,189,58,93,172,9,98,165,81,119,248,183,137,75,104,255,23,182,247,162,99,8,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,52,64,63,32,59,126,186,249,244,99,54,83,22,9,37,16,48,126,99,33,177,126,99,80,233,21,61,226,163,249,55,32,85,216,96,126,239,24,171,238,158,88,201,26,202,187,130,154,241,114,114,95,95,29,6,98,33,120,172,125,108,180,197,114,250,24,107,107,6,101,57,112,116,170,102,232,87,148,128,233,176,179,128,225,215,239,98,241,165,238,3,177,50,199,204,1,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91,32,9,88,219,42,178,51,219,92,36,92,6,17,122,205,3,143,164,248,172,108,77,113,31,45,213,215,21,152,78,171,51,101,8,45,230,27,51,148,195,75,127,203,167,78,137,135,248,54,28,30,246,64,138,219,86,134,110,189,60,9,77,225,121,96,152,132,105,44,180,126,28,69,184,225,234,81,248,99,233,148,25,242,161,80,3,51,87,86,219,28,141,82,225,91,18,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nPbatch_montgomery25519_n_15[] = {107,93,211,155,221,173,12,104,216,40,219,59,4,41,87,244,86,208,62,135,204,236,147,28,221,9,196,79,1,84,193,178,217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,160,100,121,66,86,16,225,47,180,132,98,217,222,58,98,233,242,189,70,72,24,109,180,168,134,12,202,37,38,186,241,243,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,66,244,159,19,88,253,213,23,32,209,189,251,8,249,71,51,66,19,33,88,169,184,184,83,24,137,123,237,88,112,136,100,190,147,100,101,77,151,179,249,20,102,182,218,161,187,38,207,142,126,195,32,205,249,96,90,162,80,63,226,98,120,239,127,92,165,88,239,5,221,61,225,13,149,25,23,82,2,96,1,119,0,65,173,221,78,4,206,227,5,131,64,13,203,112,190,237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,48,124,248,1,229,78,90,159,144,127,179,25,138,145,171,159,139,209,42,221,103,134,165,156,190,149,2,186,49,191,106,198,208,146,223,0,10,130,154,248,2,157,61,204,147,5,204,21,114,250,40,205,43,8,80,214,5,101,127,169,30,178,53,137,127,56,48,91,234,196,208,190,82,145,55,146,222,16,9,128,161,66,197,177,237,132,255,64,248,2,201,114,190,1,253,140,197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nPbatch_montgomery25519_p_15[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,219,85,141,78,156,71,229,153,137,212,86,246,41,139,137,210,13,246,3,78,206,173,113,225,30,236,100,242,203,91,142,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,96,42,30,228,229,15,43,141,229,125,150,149,63,62,255,69,132,153,11,122,8,147,80,31,71,0,114,172,6,236,188,169,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_16[] = {176,182,52,252,134,77,176,235,75,203,19,14,204,192,20,85,158,135,211,17,217,16,231,54,41,73,208,31,27,201,231,67,215,194,226,30,5,48,102,158,105,8,172,181,127,251,175,126,0,25,101,220,84,10,197,19,105,58,237,49,123,52,190,117,175,8,94,200,26,183,77,83,31,204,57,39,124,104,223,137,28,239,203,131,34,179,127,231,231,26,223,14,36,198,12,102,207,99,98,54,244,37,197,214,156,117,144,114,91,66,109,51,150,66,7,58,125,133,76,166,247,62,34,75,174,82,117,119,245,147,197,14,116,81,238,160,86,55,195,142,129,205,120,245,176,155,135,184,139,85,206,241,38,229,120,82,130,101,111,12,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,31,100,25,145,30,62,144,212,64,219,186,236,38,135,240,173,18,18,210,133,193,58,175,187,132,2,62,79,230,138,149,63,121,223,164,139,202,179,32,228,109,181,229,181,139,0,181,124,140,230,145,47,130,223,137,147,17,118,27,113,92,100,228,98,184,104,230,182,129,76,150,111,49,140,51,165,182,24,57,150,50,121,20,24,229,80,67,104,254,120,83,13,14,124,45,86,62,0,123,251,99,62,66,71,243,231,164,120,115,181,126,254,237,36,36,32,140,194,68,35,73,35,222,199,199,107,28,117,250,24,107,107,6,101,57,112,116,170,102,232,87,148,128,233,176,179,128,225,215,239,98,241,165,238,3,177,50,199,204,1,81,212,247,2,165,203,138,13,12,188,47,181,141,146,236,57,186,2,196,20,129,165,17,228,157,55,212,222,126,114,58,74,15,110,14,218,109,97,208,5,119,1,172,107,129,13,15,212,190,36,103,67,142,60,73,93,73,192,62,251,214,1,248,33,8,230,182,92,48,214,174,119,128,155,246,232,247,243,230,27,18,49,135,212,35,67,70,253,49,55,189,111,188,19,5,108,215,155,105,172,214,147,237,205,119,60,252,47,67,96,235,114,110,201,226,162,219,48,127,194,252,165,209,248,235,150,64,23,235,14,110,53,191,65,207,130,47,77,134,173,120,240,222,139,29,180,151,72,162,218,70,217,73,77,253,120,147,236,10,61};
static const unsigned char precomputed_nPbatch_montgomery25519_n_16[] = {15,178,181,41,106,62,93,252,17,170,218,222,225,22,147,136,1,241,195,59,36,141,156,234,43,72,126,126,41,17,193,34,31,239,111,66,250,165,152,62,61,1,47,9,134,219,166,127,174,8,170,206,103,158,99,99,235,95,103,58,250,213,120,252,91,236,197,142,183,255,180,242,223,169,55,214,19,251,194,108,83,232,55,186,94,32,121,252,117,219,77,53,28,82,178,197,202,5,147,74,179,48,169,40,156,198,55,4,197,182,10,91,43,62,80,143,47,103,78,121,37,164,50,113,36,101,11,118,132,172,226,25,189,173,154,215,196,207,251,66,181,178,144,119,92,47,169,146,3,24,13,155,176,60,167,107,65,196,145,120,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,106,22,136,121,130,169,103,161,11,79,65,78,207,152,232,123,241,32,124,101,14,77,170,5,120,175,47,189,82,25,245,59,45,15,68,93,105,161,236,142,132,222,64,65,61,38,44,243,32,161,134,170,84,232,175,213,242,206,236,93,30,166,38,12,31,60,154,239,1,99,22,215,237,93,143,96,188,253,160,127,211,130,94,5,225,196,37,124,3,57,3,71,4,241,231,15,22,25,157,191,182,145,141,114,11,227,34,104,72,192,36,19,221,45,137,85,89,83,163,40,16,141,176,151,27,155,53,98,92,165,88,239,5,221,61,225,13,149,25,23,82,2,96,1,119,0,65,173,221,78,4,206,227,5,131,64,13,203,112,190,86,113,216,237,144,237,27,77,43,86,221,218,78,165,92,68,2,121,158,174,144,41,197,225,133,57,198,150,193,205,31,80,83,201,187,156,49,162,122,98,244,64,232,65,97,99,249,20,112,35,197,48,214,75,215,12,58,113,197,148,113,214,183,52,132,175,87,38,2,127,24,123,10,20,230,220,70,101,14,168,26,154,32,108,78,93,106,112,2,147,7,146,149,82,157,35,24,113,214,137,60,212,159,0,197,103,163,201,179,148,131,59,203,28,179,9,203,249,187,135,0,163,200,149,208,20,23,253,242,118,199,205,119,164,108,93,255,103,82,80,71,24,76,10,37,191,147,128,26,14,16,1,201,170,187,82,112,15,231,179};
static const unsigned char precomputed_nPbatch_montgomery25519_p_16[] = {56,0,37,25,36,249,203,33,105,221,23,56,110,251,249,180,154,183,67,64,123,150,36,125,50,218,191,132,212,126,128,222,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,77,177,87,210,156,163,175,191,211,150,62,37,21,150,200,44,125,200,224,117,67,164,169,113,221,215,61,61,88,133,65,237,58,50,13,118,120,27,56,5,140,124,44,234,250,149,21,57,233,36,207,197,165,234,195,118,154,167,56,193,69,102,30,217,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,22,72,68,27,247,111,127,36,102,253,162,235,57,103,223,77,206,56,9,214,96,69,138,244,14,98,103,63,107,126,98,84,33,33,195,205,95,87,46,215,226,73,47,6,206,1,220,87,223,209,122,91,233,94,210,113,168,229,78,121,87,53,230,112,219,85,141,78,156,71,229,153,137,212,86,246,41,139,137,210,13,246,3,78,206,173,113,225,30,236,100,242,203,91,142,245,196,70,99,114,97,152,96,91,20,31,160,88,52,151,161,94,92,11,177,23,242,92,137,253,43,147,168,159,120,99,3,68,129,160,218,218,241,248,204,45,63,176,224,36,15,218,40,118,107,85,223,166,31,199,0,47,181,170,156,116,254,39,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,0,5,175,234,211,162,13,126,160,91,211,165,51,116,163,210,242,48,25,249,254,242,78,240,81,44,86,166,90,115,206,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
  const unsigned char *p;
  long long psize;
  long long batch;
} precomputed_nPbatch_montgomery25519[precomputed_nPbatch_montgomery25519_NUM] = {
  {
    precomputed_nPbatch_montgomery25519_q_0,0,
    precomputed_nPbatch_montgomery25519_n_0,0,
    precomputed_nPbatch_montgomery25519_p_0,0,
    0,
  },
  {
    precomputed_nPbatch_montgomery25519_q_1,32,
    precomputed_nPbatch_montgomery25519_n_1,32,
    precomputed_nPbatch_montgomery25519_p_1,32,
    1,
  },
  {
    precomputed_nPbatch_montgomery25519_q_2,64,
    precomputed_nPbatch_montgomery25519_n_2,64,
    precomputed_nPbatch_montgomery25519_p_2,64,
    2,
  },
  {
    precomputed_nPbatch_montgomery25519_q_3,96,
    precomputed_nPbatch_montgomery25519_n_3,96,
    precomputed_nPbatch_montgomery25519_p_3,96,
    3,
  },
  {
    precomputed_nPbatch_montgomery25519_q_4,128,
    precomputed_nPbatch_montgomery25519_n_4,128,
    precomputed_nPbatch_montgomery25519_p_4,128,
    4,
  },
  {
    precomputed_nPbatch_montgomery25519_q_5,160,
    precomputed_nPbatch_montgomery25519_n_5,160,
    precomputed_nPbatch_montgomery25519_p_5,160,
    5,
  },
  {
    precomputed_nPbatch_montgomery25519_q_6,192,
    precomputed_nPbatch_montgomery25519_n_6,192,
    precomputed_nPbatch_montgomery25519_p_6,192,
    6,
  },
  {
    precomputed_nPbatch_montgomery25519_q_7,224,
    precomputed_nPbatch_montgomery25519_n_7,224,
    precomputed_nPbatch_montgomery25519_p_7,224,
    7,
  },
  {
    precomputed_nPbatch_montgomery25519_q_8,256,
    precomputed_nPbatch_montgomery25519_n_8,256,
    precomputed_nPbatch_montgomery25519_p_8,256,
    8,
  },
  {
    precomputed_nPbatch_montgomery25519_q_9,288,
    precomputed_nPbatch_montgomery25519_n_9,288,
    precomputed_nPbatch_montgomery25519_p_9,288,
    9,
  },
  {
    precomputed_nPbatch_montgomery25519_q_10,320,
    precomputed_nPbatch_montgomery25519_n_10,320,
    precomputed_nPbatch_montgomery25519_p_10,320,
    10,
  },
  {
    precomputed_nPbatch_montgomery25519_q_11,352,
    precomputed_nPbatch_montgomery25519_n_11,352,
    precomputed_nPbatch_montgomery25519_p_11,352,
    11,
  },
  {
    precomputed_nPbatch_montgomery25519_q_12,384,
    precomputed_nPbatch_montgomery25519_n_12,384,
    precomputed_nPbatch_montgomery25519_p_12,384,
    12,
  },
  {
    precomputed_nPbatch_montgomery25519_q_13,416,
    precomputed_nPbatch_montgomery25519_n_13,416,
    precomputed_nPbatch_montgomery25519_p_13,416,
    13,
  },
  {
    precomputed_nPbatch_montgomery25519_q_14,448,
    precomputed_nPbatch_montgomery25519_n_14,448,
    precomputed_nPbatch_montgomery25519_p_14,448,
    14,
  },
  {
    precomputed_nPbatch_montgomery25519_q_15,480,
    precomputed_nPbatch_montgomery25519_n_15,480,
    precomputed_nPbatch_montgomery25519_p_15,480,
    15,
  },
  {
    precomputed_nPbatch_montgomery25519_q_16,512,
    precomputed_nPbatch_montgomery25519_n_16,512,
    precomputed_nPbatch_montgomery25519_p_16,512,
    16,
  },
} ;

static void test_nPbatch_montgomery25519_impl(long long impl)
{
  unsigned char *q = test_nPbatch_montgomery25519_q;
  unsigned char *n = test_nPbatch_montgomery25519_n;
  unsigned char *p = test_nPbatch_montgomery25519_p;
  unsigned char *q2 = test_nPbatch_montgomery25519_q2;
  unsigned char *n2 = test_nPbatch_montgomery25519_n2;
  unsigned char *p2 = test_nPbatch_montgomery25519_p2;
  long long qlen;
  long long nlen;
  long long plen;

  if (targeti && strcmp(targeti,lib25519_dispatch_nPbatch_montgomery25519_implementation(impl))) return;
  if (impl >= 0) {
    crypto_nPbatch = lib25519_dispatch_nPbatch_montgomery25519(impl);
    printf("nPbatch_montgomery25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nPbatch_montgomery25519_implementation(impl),lib25519_dispatch_nPbatch_montgomery25519_compiler(impl));
  } else {
    crypto_nPbatch = lib25519_nPbatch_montgomery25519;
    printf("nPbatch_montgomery25519 selected implementation %s compiler %s\n",lib25519_nPbatch_montgomery25519_implementation(),lib25519_nPbatch_montgomery25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 256 : 32;
    long long maxtest = checksumbig ? 128 : 16;
    long long mlen;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      qlen = mlen * crypto_nPbatch_POINTBYTES;
      nlen = mlen * crypto_nPbatch_SCALARBYTES;
      plen = mlen * crypto_nPbatch_POINTBYTES;
      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      input_prepare(p2,p,plen);
      crypto_nPbatch(q,n,p,mlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nPbatch");
      input_compare(n2,n,nlen,"crypto_nPbatch");
      input_compare(p2,p,plen,"crypto_nPbatch");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      crypto_nPbatch(q2,n2,p2,mlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nPbatch is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      crypto_nPbatch(n2,n2,p,mlen);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nPbatch does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
      crypto_nPbatch(p2,n,p2,mlen);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_nPbatch does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(nPbatch_montgomery25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nPbatch_montgomery25519_NUM;++precomp) {
    long long mlen = precomputed_nPbatch_montgomery25519[precomp].batch;
    output_prepare(q2,q,precomputed_nPbatch_montgomery25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    memcpy(n,precomputed_nPbatch_montgomery25519[precomp].n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    memcpy(n2,precomputed_nPbatch_montgomery25519[precomp].n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    input_prepare(p2,p,precomputed_nPbatch_montgomery25519[precomp].psize);
    memcpy(p,precomputed_nPbatch_montgomery25519[precomp].p,precomputed_nPbatch_montgomery25519[precomp].psize);
    memcpy(p2,precomputed_nPbatch_montgomery25519[precomp].p,precomputed_nPbatch_montgomery25519[precomp].psize);
    crypto_nPbatch(q,n,p,mlen);
    if (memcmp(q,precomputed_nPbatch_montgomery25519[precomp].q,precomputed_nPbatch_montgomery25519[precomp].qsize)) {
      fail("failure: crypto_nPbatch fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nPbatch_montgomery25519[precomp].qsize;++pos) printf("%02x",precomputed_nPbatch_montgomery25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nPbatch_montgomery25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nPbatch_montgomery25519[precomp].qsize,"crypto_nPbatch");
    input_compare(n2,n,precomputed_nPbatch_montgomery25519[precomp].nsize,"crypto_nPbatch");
    input_compare(p2,p,precomputed_nPbatch_montgomery25519[precomp].psize,"crypto_nPbatch");
  }
}

static void test_nPbatch_montgomery25519(void)
{
  if (targeto && strcmp(targeto,"nPbatch")) return;
  if (targetp && strcmp(targetp,"montgomery25519")) return;
  test_nPbatch_montgomery25519_q = alignedcalloc(128*crypto_nPbatch_POINTBYTES);
  test_nPbatch_montgomery25519_n = alignedcalloc(128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES));
  test_nPbatch_montgomery25519_p = alignedcalloc(128*crypto_nPbatch_POINTBYTES);
  test_nPbatch_montgomery25519_q2 = alignedcalloc(128*crypto_nPbatch_POINTBYTES);
  test_nPbatch_montgomery25519_n2 = alignedcalloc(128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES));
  test_nPbatch_montgomery25519_p2 = alignedcalloc(128*crypto_nPbatch_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("nPbatch_montgomery25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nPbatch_montgomery25519();++impl)
      forked(test_nPbatch_montgomery25519_impl,impl);
    ++test_nPbatch_montgomery25519_q;
    ++test_nPbatch_montgomery25519_n;
    ++test_nPbatch_montgomery25519_p;
    ++test_nPbatch_montgomery25519_q2;
    ++test_nPbatch_montgomery25519_n2;
    ++test_nPbatch_montgomery25519_p2;
  }
}
#undef crypto_nPbatch_SCALARBYTES
#undef crypto_nPbatch_POINTBYTES


/* ----- nG, derived from supercop/crypto_nG/try.c */
static const char *nG_merged25519_checksums[] = {
  "a4e761839798a07817484e97605bd63215b4938934ed9ce01935bbced48155bc",
  "0a01c09fc8a8c7e8c18f841b2e1b2da9c156868737d194d223b03531cf2db731",
} ;

static void (*crypto_nG)(unsigned char *,const unsigned char *);
#define crypto_nG_SCALARBYTES lib25519_nG_merged25519_SCALARBYTES
#define crypto_nG_POINTBYTES lib25519_nG_merged25519_POINTBYTES

static unsigned char *test_nG_merged25519_q;
static unsigned char *test_nG_merged25519_n;
static unsigned char *test_nG_merged25519_q2;
static unsigned char *test_nG_merged25519_n2;

#define precomputed_nG_merged25519_NUM 204

static const unsigned char precomputed_nG_merged25519_q_0[] = {133,218,221,213,182,167,220,17,81,165,169,16,157,1,98,146,173,245,154,229,120,122,142,232,80,50,175,61,48,98,60,116};
static const unsigned char precomputed_nG_merged25519_n_0[] = {14,252,177,48,51,24,150,255,44,250,132,235,147,239,78,66,173,190,143,74,31,10,84,177,152,242,102,165,15,106,180,143};
static const unsigned char precomputed_nG_merged25519_q_1[] = {21,137,40,17,147,173,40,217,252,204,13,39,126,161,52,33,103,220,167,227,173,212,171,240,74,133,108,100,110,38,37,203};
static const unsigned char precomputed_nG_merged25519_n_1[] = {4,98,90,244,250,174,214,153,18,248,206,99,12,173,215,101,111,19,140,120,200,225,137,93,10,154,215,119,183,184,110,67};
static const unsigned char precomputed_nG_merged25519_q_2[] = {162,29,197,12,149,155,174,166,249,128,97,252,70,240,197,153,55,135,92,1,67,192,227,81,165,24,200,228,196,179,252,14};
static const unsigned char precomputed_nG_merged25519_n_2[] = {26,90,61,26,108,30,1,123,69,213,78,134,230,158,104,207,14,110,188,73,111,89,39,23,114,21,175,51,18,34,172,225};
static const unsigned char precomputed_nG_merged25519_q_3[] = {99,233,95,90,78,115,131,115,66,215,223,175,169,79,14,163,151,0,237,8,26,122,160,89,64,3,106,116,214,252,226,227};
static const unsigned char precomputed_nG_merged25519_n_3[] = {40,23,118,110,26,89,64,207,170,236,133,185,238,148,225,2,118,128,234,122,43,160,205,8,71,218,49,136,251,19,2,82};
static const unsigned char precomputed_nG_merged25519_q_4[] = {54,150,206,203,58,110,225,157,183,86,161,217,21,173,52,118,210,103,209,184,244,215,140,213,108,38,253,214,220,68,59,21};
static const unsigned char precomputed_nG_merged25519_n_4[] = {193,46,183,245,21,125,231,201,156,66,212,74,156,49,235,176,118,234,219,138,128,194,100,66,242,63,179,4,64,172,10,185};
static const unsigned char precomputed_nG_merged25519_q_5[] = {229,150,16,70,160,155,23,143,193,204,18,207,12,35,16,109,19,161,33,163,231,148,93,33,192,8,208,33,52,245,73,118};
static const unsigned char precomputed_nG_merged25519_n_5[] = {10,7,143,232,161,214,197,102,31,170,6,0,81,126,210,18,101,96,18,149,227,110,205,192,95,127,78,212,117,99,195,227};
static const unsigned char precomputed_nG_merged25519_q_6[] = {73,105,152,67,21,142,191,92,30,165,214,112,236,97,191,160,115,199,32,54,253,64,12,183,200,153,220,13,247,122,168,120};
static const unsigned char precomputed_nG_merged25519_n_6[] = {97,3,128,29,30,130,136,227,27,41,200,232,149,155,85,88,165,150,242,99,80,35,129,101,113,59,149,211,77,30,75,178};
static const unsigned char precomputed_nG_merged25519_q_7[] = {154,10,210,253,121,116,76,235,128,102,47,92,73,216,196,148,103,90,201,122,11,94,192,85,13,193,122,32,104,107,44,86};
static const unsigned char precomputed_nG_merged25519_n_7[] = {106,169,193,176,237,39,174,67,198,73,118,162,37,236,106,78,45,67,20,98,141,248,56,249,185,128,248,126,74,155,171,214};
static const unsigned char precomputed_nG_merged25519_q_8[] = {242,127,197,101,157,182,135,14,30,144,113,135,145,40,211,42,139,166,32,175,62,68,63,56,125,65,228,23,153,31,9,121};
static const unsigned char precomputed_nG_merged25519_n_8[] = {137,33,93,180,100,175,164,180,175,113,146,77,71,201,157,232,74,69,159,109,245,3,51,44,39,14,155,211,55,34,16,27};
static const unsigned char precomputed_nG_merged25519_q_9[] = {56,11,123,153,186,17,205,235,203,26,210,162,38,100,99,95,184,127,125,207,51,224,32,196,119,210,101,197,184,231,245,122};
static const unsigned char precomputed_nG_merged25519_n_9[] = {129,241,79,112,4,141,121,80,104,172,222,222,108,215,166,191,18,54,187,139,89,29,71,91,98,103,167,160,72,42,77,162};
static const unsigned char precomputed_nG_merged25519_q_10[] = {36,227,145,67,153,167,149,57,231,243,241,68,24,56,226,208,21,225,45,44,253,75,155,98,34,41,113,202,172,245,217,59};
static const unsigned char precomputed_nG_merged25519_n_10[] = {248,184,56,147,163,223,180,173,66,182,20,230,145,143,177,100,65,10,32,55,127,20,137,122,228,85,77,171,245,28,137,214};
static const unsigned char precomputed_nG_merged25519_q_11[] = {200,209,38,54,107,155,162,213,139,66,104,33,240,22,163,55,57,117,215,169,210,36,216,146,41,231,244,195,139,121,254,0};
static const unsigned char precomputed_nG_merged25519_n_11[] = {192,35,128,83,162,109,231,202,199,158,130,36,132,214,107,77,69,130,37,98,42,1,138,9,249,184,64,213,118,109,188,141};
static const unsigned char precomputed_nG_merged25519_q_12[] = {0,247,38,106,217,100,0,75,146,156,162,91,151,191,98,7,50,138,182,191,206,5,104,123,113,39,192,119,91,70,133,44};
static const unsigned char precomputed_nG_merged25519_n_12[] = {97,207,224,138,5,184,83,176,42,139,86,52,44,49,3,197,167,220,73,214,54,86,97,21,176,173,2,51,189,184,163,22};
static const unsigned char precomputed_nG_merged25519_q_13[] = {24,71,171,234,213,78,8,17,237,82,105,158,41,52,68,101,207,165,51,142,135,25,110,107,184,104,200,119,68,173,59,119};
static const unsigned char precomputed_nG_merged25519_n_13[] = {56,98,7,141,181,187,179,200,10,182,204,190,168,129,189,32,44,119,77,78,218,191,112,5,67,87,84,50,133,102,245,18};
static const unsigned char precomputed_nG_merged25519_q_14[] = {217,153,48,91,233,138,209,224,28,163,218,7,29,45,183,133,213,145,116,178,133,212,17,102,130,112,139,93,187,16,48,11};
static const unsigned char precomputed_nG_merged25519_n_14[] = {164,117,126,223,222,210,183,203,165,89,96,90,92,52,180,71,137,243,235,34,42,247,179,157,221,184,215,122,42,77,19,148};
static const unsigned char precomputed_nG_merged25519_q_15[] = {233,141,127,176,161,169,81,186,69,119,8,7,219,207,140,141,179,217,154,20,74,236,120,151,133,9,40,11,248,100,171,61};
static const unsigned char precomputed_nG_merged25519_n_15[] = {37,20,118,112,165,202,61,122,229,92,171,192,202,22,253,197,79,109,40,131,114,128,218,129,178,49,179,254,218,218,37,147};
static const unsigned char precomputed_nG_merged25519_q_16[] = {143,235,242,112,234,244,127,42,130,112,146,216,216,118,207,241,18,54,165,57,153,36,51,254,49,158,71,172,234,86,30,115};
static const unsigned char precomputed_nG_merged25519_n_16[] = {228,139,29,124,221,239,86,110,242,200,229,137,171,165,136,144,62,238,2,156,164,202,112,170,25,170,222,164,60,38,172,251};
static const unsigned char precomputed_nG_merged25519_q_17[] = {119,237,4,68,155,203,157,8,39,68,130,178,241,153,84,205,9,184,30,234,214,64,139,141,221,0,208,205,160,208,206,122};
static const unsigned char precomputed_nG_merged25519_n_17[] = {15,188,181,84,79,123,28,96,218,82,147,215,19,139,191,255,171,27,45,165,24,25,233,142,225,76,57,60,188,116,151,63};
static const unsigned char precomputed_nG_merged25519_q_18[] = {230,126,124,186,28,168,134,3,88,238,75,227,231,171,125,245,132,57,18,181,223,229,2,189,221,242,88,163,213,64,50,104};
static const unsigned char precomputed_nG_merged25519_n_18[] = {68,205,99,39,157,39,232,121,65,138,14,209,106,34,53,93,228,125,167,202,33,116,203,133,224,96,179,158,7,219,76,208};
static const unsigned char precomputed_nG_merged25519_q_19[] = {146,242,159,166,200,201,150,160,60,217,52,208,122,192,206,216,213,254,39,88,137,139,18,78,111,220,114,219,129,119,123,67};
static const unsigned char precomputed_nG_merged25519_n_19[] = {146,70,128,239,133,16,48,130,169,201,83,140,118,113,39,26,174,164,250,46,127,84,154,254,213,186,121,88,183,134,34,53};
static const unsigned char precomputed_nG_merged25519_q_20[] = {90,86,188,252,38,122,3,18,104,33,60,199,75,240,95,203,122,59,34,63,90,181,216,112,120,252,142,38,100,73,219,51};
static const unsigned char precomputed_nG_merged25519_n_20[] = {188,20,82,254,10,0,82,194,233,195,12,205,100,107,3,45,38,220,109,116,141,32,25,94,57,182,26,22,49,115,11,224};
static const unsigned char precomputed_nG_merged25519_q_21[] = {208,111,18,67,63,233,46,43,98,19,222,177,223,200,241,217,152,121,123,245,214,32,222,249,73,169,177,60,12,248,55,158};
static const unsigned char precomputed_nG_merged25519_n_21[] = {247,146,8,90,8,199,41,31,163,112,106,211,122,242,184,170,18,98,204,153,159,229,79,111,7,232,42,88,7,163,87,55};
static const unsigned char precomputed_nG_merged25519_q_22[] = {195,200,243,197,196,207,227,141,88,22,134,33,16,234,171,107,21,159,157,201,96,21,72,205,31,234,131,81,182,213,113,64};
static const unsigned char precomputed_nG_merged25519_n_22[] = {114,73,62,161,254,9,21,14,233,92,252,67,128,17,118,236,147,107,117,46,236,71,147,133,124,155,254,161,88,97,5,200};
static const unsigned char precomputed_nG_merged25519_q_23[] = {71,47,120,45,240,125,236,219,24,118,182,126,40,128,132,87,0,8,136,25,211,29,205,193,196,82,219,215,30,225,165,85};
static const unsigned char precomputed_nG_merged25519_n_23[] = {117,189,86,19,188,223,94,108,110,96,152,163,238,14,215,95,249,3,35,246,180,115,139,215,204,210,174,17,27,225,146,148};
static const unsigned char precomputed_nG_merged25519_q_24[] = {6,120,14,54,131,140,165,197,128,126,193,206,138,103,77,167,127,12,178,66,21,27,149,46,219,110,179,232,1,3,10,96};
static const unsigned char precomputed_nG_merged25519_n_24[] = {105,44,234,39,55,66,111,237,198,40,48,255,113,86,248,146,42,107,85,53,126,173,135,195,83,124,223,150,49,42,214,231};
static const unsigned char precomputed_nG_merged25519_q_25[] = {170,173,18,125,183,4,162,58,4,108,184,211,64,98,80,11,14,189,137,1,113,91,228,142,135,109,168,37,4,185,110,41};
static const unsigned char precomputed_nG_merged25519_n_25[] = {164,33,179,146,61,72,144,115,145,255,13,173,230,213,204,172,46,179,219,180,17,115,213,208,164,190,252,45,2,121,87,67};
static const unsigned char precomputed_nG_merged25519_q_26[] = {239,168,117,46,90,253,251,53,129,85,95,19,196,0,198,236,179,159,6,5,138,155,31,208,30,203,63,42,92,176,246,159};
static const unsigned char precomputed_nG_merged25519_n_26[] = {54,168,211,156,169,144,89,156,75,38,141,222,162,116,177,116,22,176,16,39,129,67,110,18,174,149,183,208,22,80,243,60};
static const unsigned char precomputed_nG_merged25519_q_27[] = {70,90,116,158,218,216,103,205,236,149,206,168,77,49,223,238,123,157,44,221,113,190,218,163,15,167,193,24,64,230,200,32};
static const unsigned char precomputed_nG_merged25519_n_27[] = {62,224,81,23,101,197,155,131,180,224,124,147,140,157,182,200,221,142,62,41,87,49,32,137,192,120,40,138,150,172,172,17};
static const unsigned char precomputed_nG_merged25519_q_28[] = {47,28,67,32,72,218,215,211,41,169,231,221,225,158,209,123,45,150,20,202,129,47,66,198,156,164,232,193,166,228,55,98};
static const unsigned char precomputed_nG_merged25519_n_28[] = {242,196,171,22,237,29,23,48,203,78,97,43,51,177,33,41,173,144,211,164,204,185,200,115,27,200,20,223,153,136,23,152};
static const unsigned char precomputed_nG_merged25519_q_29[] = {133,255,102,184,241,33,53,161,64,165,61,128,174,250,60,25,164,76,242,30,148,21,89,53,205,101,155,189,203,217,87,85};
static const unsigned char precomputed_nG_merged25519_n_29[] = {46,118,218,21,6,58,150,225,219,27,183,159,86,243,238,102,167,82,148,176,235,100,137,93,140,190,69,205,42,59,132,137};
static const unsigned char precomputed_nG_merged25519_q_30[] = {58,208,59,76,188,233,160,118,158,60,166,149,188,13,26,154,116,64,194,48,140,179,59,4,238,206,210,89,93,109,139,32};
static const unsigned char precomputed_nG_merged25519_n_30[] = {107,168,181,208,37,162,103,49,30,13,181,90,116,182,204,161,210,253,141,95,240,205,240,165,69,113,238,29,210,3,249,255};
static const unsigned char precomputed_nG_merged25519_q_31[] = {73,62,203,112,176,134,155,69,135,47,30,173,28,43,178,113,188,188,231,27,172,122,96,99,236,242,253,109,210,254,20,16};
static const unsigned char precomputed_nG_merged25519_n_31[] = {64,78,238,224,233,71,9,219,30,166,238,145,142,135,243,131,103,7,83,232,183,239,99,65,25,171,26,38,93,253,194,162};
static const unsigned char precomputed_nG_merged25519_q_32[] = {12,97,67,237,42,207,179,144,2,227,167,226,3,28,166,216,220,242,8,29,166,64,216,106,83,71,185,169,242,153,49,17};
static const unsigned char precomputed_nG_merged25519_n_32[] = {127,26,200,57,169,2,77,216,149,78,53,110,25,175,50,233,26,43,78,67,243,152,142,159,88,195,163,197,134,251,85,202};
static const unsigned char precomputed_nG_merged25519_q_33[] = {93,96,122,15,112,17,211,233,152,205,188,181,90,160,82,225,19,105,186,83,107,89,227,115,56,108,105,11,79,53,207,63};
static const unsigned char precomputed_nG_merged25519_n_33[] = {234,161,205,240,101,129,58,120,2,203,55,111,131,137,23,245,216,239,61,14,186,84,2,81,92,183,101,93,33,34,103,225};
static const unsigned char precomputed_nG_merged25519_q_34[] = {239,87,246,243,207,185,86,248,217,30,54,240,27,254,167,204,120,202,154,90,202,122,61,59,230,89,22,167,42,11,98,45};
static const unsigned char precomputed_nG_merged25519_n_34[] = {171,190,230,107,212,78,249,130,216,145,106,42,198,203,178,238,76,62,101,159,59,39,51,201,169,89,122,92,124,212,24,250};
static const unsigned char precomputed_nG_merged25519_q_35[] = {80,122,179,178,62,164,3,194,112,28,39,23,252,192,155,80,162,6,223,44,24,14,33,18,104,83,41,135,41,109,17,224};
static const unsigned char precomputed_nG_merged25519_n_35[] = {142,200,252,229,150,10,123,159,206,168,81,231,16,240,92,236,28,144,210,217,0,173,112,127,136,187,15,111,150,138,109,119};
static const unsigned char precomputed_nG_merged25519_q_36[] = {56,182,76,24,217,7,54,70,242,91,148,57,174,212,99,231,177,247,71,183,247,38,3,12,249,130,68,7,39,67,189,143};
static const unsigned char precomputed_nG_merged25519_n_36[] = {210,185,232,239,74,58,15,215,244,15,186,140,243,94,6,166,138,80,213,191,7,4,200,44,138,232,124,15,70,166,80,60};
static const unsigned char precomputed_nG_merged25519_q_37[] = {160,69,77,238,221,238,44,234,198,74,237,123,188,231,251,245,2,84,48,87,44,90,108,105,8,157,246,65,156,58,195,57};
static const unsigned char precomputed_nG_merged25519_n_37[] = {208,70,173,227,58,128,247,7,158,114,44,134,37,236,155,193,175,48,1,24,28,247,142,145,47,197,25,148,3,252,167,179};
static const unsigned char precomputed_nG_merged25519_q_38[] = {115,114,240,204,123,58,219,165,106,184,23,78,196,223,139,214,11,17,77,10,195,244,194,41,207,226,246,221,66,68,222,62};
static const unsigned char precomputed_nG_merged25519_n_38[] = {241,50,50,190,236,125,117,62,114,248,185,248,121,110,167,101,7,19,95,47,189,128,92,51,191,197,203,21,245,254,56,242};
static const unsigned char precomputed_nG_merged25519_q_39[] = {17,27,90,95,72,5,219,79,198,96,140,229,7,19,105,220,31,44,10,189,228,142,143,175,103,37,93,43,100,177,222,150};
static const unsigned char precomputed_nG_merged25519_n_39[] = {8,35,126,152,221,126,219,224,48,87,27,139,201,175,66,173,138,113,5,73,26,181,127,228,40,221,169,219,238,57,93,43};
static const unsigned char precomputed_nG_merged25519_q_40[] = {10,2,138,157,12,244,25,125,236,19,139,240,232,244,16,156,12,161,228,81,57,78,67,210,129,29,113,210,20,106,198,226};
static const unsigned char precomputed_nG_merged25519_n_40[] = {166,222,31,175,196,76,20,78,132,242,56,61,146,97,155,109,209,170,216,48,130,119,160,84,86,85,188,207,77,30,140,126};
static const unsigned char precomputed_nG_merged25519_q_41[] = {240,222,146,238,207,103,248,61,137,145,17,6,76,137,189,125,12,79,213,118,195,80,109,29,74,38,106,28,157,152,206,110};
static const unsigned char precomputed_nG_merged25519_n_41[] = {251,246,135,3,126,6,236,29,185,3,148,209,173,16,2,242,27,110,212,137,5,171,125,180,154,52,232,126,34,220,226,177};
static const unsigned char precomputed_nG_merged25519_q_42[] = {35,213,178,187,124,140,73,101,93,210,200,86,179,158,164,210,215,156,54,180,216,243,29,26,235,227,26,142,109,206,108,112};
static const unsigned char precomputed_nG_merged25519_n_42[] = {122,189,106,75,10,100,25,87,235,251,121,142,37,54,45,38,27,156,146,187,235,146,11,63,196,248,43,228,239,152,176,150};
static const unsigned char precomputed_nG_merged25519_q_43[] = {193,217,128,217,238,154,50,186,70,148,167,93,206,43,227,92,253,237,69,30,135,11,132,104,186,147,79,11,193,235,158,85};
static const unsigned char precomputed_nG_merged25519_n_43[] = {249,68,234,200,175,106,31,122,79,107,167,10,37,124,170,233,66,5,127,233,5,108,234,71,191,189,120,252,248,164,23,146};
static const unsigned char precomputed_nG_merged25519_q_44[] = {139,112,244,194,138,153,217,230,143,225,97,150,194,143,167,165,75,20,121,127,220,4,195,150,232,91,181,219,31,78,26,37};
static const unsigned char precomputed_nG_merged25519_n_44[] = {240,8,108,24,44,3,72,203,70,205,254,161,212,43,190,211,30,58,80,191,231,230,149,33,102,225,39,78,169,87,28,231};
static const unsigned char precomputed_nG_merged25519_q_45[] = {142,40,63,66,176,219,127,245,3,253,178,123,88,91,146,185,21,183,120,70,76,69,217,33,34,177,86,96,126,114,27,3};
static const unsigned char precomputed_nG_merged25519_n_45[] = {95,160,182,6,202,134,90,35,53,96,136,211,134,171,148,211,118,251,48,95,248,21,243,174,83,117,207,18,150,221,29,28};
static const unsigned char precomputed_nG_merged25519_q_46[] = {103,129,227,106,53,41,239,32,158,10,78,37,130,41,79,69,183,208,103,118,89,251,74,175,236,209,163,52,221,35,157,31};
static const unsigned char precomputed_nG_merged25519_n_46[] = {46,95,36,196,148,52,40,77,79,83,152,45,161,99,13,111,188,217,182,203,240,81,177,154,63,31,98,65,11,142,197,24};
static const unsigned char precomputed_nG_merged25519_q_47[] = {249,27,137,39,161,15,133,187,99,132,151,171,146,22,39,79,38,151,254,224,252,144,151,55,224,57,37,209,206,32,240,194};
static const unsigned char precomputed_nG_merged25519_n_47[] = {152,102,154,216,31,251,97,187,236,3,80,121,124,92,13,244,145,112,85,148,115,233,176,177,63,64,130,68,166,15,242,108};
static const unsigned char precomputed_nG_merged25519_q_48[] = {133,185,231,141,84,179,78,90,88,65,9,167,25,154,109,95,66,91,94,230,249,234,239,128,77,134,211,97,31,163,247,38};
static const unsigned char precomputed_nG_merged25519_n_48[] = {47,157,164,241,25,123,61,95,97,4,76,139,183,126,27,22,244,89,189,11,230,254,90,189,241,163,249,126,236,10,78,210};
static const unsigned char precomputed_nG_merged25519_q_49[] = {195,234,12,244,247,159,43,89,154,207,87,129,9,174,86,91,49,14,72,158,133,4,10,63,132,217,83,9,59,118,139,19};
static const unsigned char precomputed_nG_merged25519_n_49[] = {226,212,119,253,81,239,100,23,38,101,72,87,105,45,253,60,103,45,35,156,37,137,251,60,163,35,9,106,16,154,45,119};
static const unsigned char precomputed_nG_merged25519_q_50[] = {133,31,247,111,200,212,191,254,182,231,194,23,126,28,147,124,91,165,243,237,143,121,211,16,47,7,174,139,23,104,56,47};
static const unsigned char precomputed_nG_merged25519_n_50[] = {57,101,29,22,86,253,64,71,187,107,116,30,238,144,148,48,0,227,142,231,144,235,31,81,176,45,10,93,225,205,164,242};
static const unsigned char precomputed_nG_merged25519_q_51[] = {100,164,52,85,247,129,172,141,125,67,177,226,248,185,123,176,80,99,233,160,164,225,197,207,250,18,72,121,10,201,34,14};
static const unsigned char precomputed_nG_merged25519_n_51[] = {193,60,149,62,156,153,43,108,5,77,156,134,113,145,113,111,47,126,75,27,129,110,204,69,79,155,127,123,13,191,43,221};
static const unsigned char precomputed_nG_merged25519_q_52[] = {252,139,231,164,188,7,92,122,16,244,213,166,136,81,235,88,209,136,101,105,120,96,170,54,22,136,203,159,77,117,81,154};
static const unsigned char precomputed_nG_merged25519_n_52[] = {40,252,175,146,145,151,124,167,228,175,139,42,158,118,218,147,194,36,175,191,70,184,100,168,251,241,12,121,124,116,150,53};
static const unsigned char precomputed_nG_merged25519_q_53[] = {143,242,153,38,70,0,130,0,67,98,254,148,131,85,127,154,165,67,196,69,56,101,209,108,105,196,117,70,142,241,152,78};
static const unsigned char precomputed_nG_merged25519_n_53[] = {137,53,41,50,33,208,134,171,193,107,122,236,87,44,133,159,235,80,141,15,54,51,242,62,212,89,171,147,200,10,135,140};
static const unsigned char precomputed_nG_merged25519_q_54[] = {52,224,221,192,111,110,162,155,102,66,47,166,37,90,240,129,107,78,51,255,22,163,195,220,215,169,174,127,144,94,226,201};
static const unsigned char precomputed_nG_merged25519_n_54[] = {52,173,167,245,97,13,31,36,106,202,38,234,75,71,153,19,71,218,63,248,155,14,202,32,206,84,144,180,241,224,180,33};
static const unsigned char precomputed_nG_merged25519_q_55[] = {19,129,58,16,91,112,212,175,101,238,120,14,118,215,72,122,168,243,103,14,5,155,120,167,91,165,171,143,43,209,191,81};
static const unsigned char precomputed_nG_merged25519_n_55[] = {130,236,212,243,13,80,154,170,130,215,24,193,141,101,101,168,215,153,194,150,96,153,173,27,108,9,111,197,60,7,172,217};
static const unsigned char precomputed_nG_merged25519_q_56[] = {23,155,224,66,163,85,106,226,131,22,240,140,147,193,178,204,47,129,185,94,6,212,43,215,172,31,181,7,21,234,243,236};
static const unsigned char precomputed_nG_merged25519_n_56[] = {39,24,96,237,13,251,124,122,234,58,1,166,176,139,228,74,91,191,18,74,25,117,123,119,139,1,176,179,130,133,200,49};
static const unsigned char precomputed_nG_merged25519_q_57[] = {219,197,41,136,68,150,118,164,141,38,74,12,215,111,202,130,136,47,4,28,146,148,224,65,117,210,26,200,213,112,74,14};
static const unsigned char precomputed_nG_merged25519_n_57[] = {135,108,110,216,118,255,247,110,14,250,1,70,15,227,48,188,238,144,45,58,31,18,45,23,220,103,197,59,35,188,183,243};
static const unsigned char precomputed_nG_merged25519_q_58[] = {168,9,245,4,218,176,115,72,11,204,7,190,161,49,137,247,5,27,179,115,230,95,14,158,68,30,227,132,125,153,20,105};
static const unsigned char precomputed_nG_merged25519_n_58[] = {59,60,133,102,147,72,54,52,175,218,110,6,20,238,236,143,221,118,254,225,212,21,86,202,90,58,152,199,48,197,95,182};
static const unsigned char precomputed_nG_merged25519_q_59[] = {19,6,106,157,254,10,36,27,66,74,133,218,136,144,135,125,66,231,33,43,150,176,158,159,4,122,81,126,56,97,66,73};
static const unsigned char precomputed_nG_merged25519_n_59[] = {51,38,100,77,150,15,128,241,49,163,156,43,131,210,175,131,148,239,188,253,239,68,38,174,91,253,231,127,56,77,194,119};
static const unsigned char precomputed_nG_merged25519_q_60[] = {162,141,255,162,40,108,188,125,233,10,145,159,166,172,147,218,231,202,74,84,140,122,134,231,252,137,85,102,193,57,244,28};
static const unsigned char precomputed_nG_merged25519_n_60[] = {43,75,147,223,200,128,246,99,53,144,97,248,156,143,22,49,63,52,25,172,135,115,71,208,209,169,242,131,232,185,9,159};
static const unsigned char precomputed_nG_merged25519_q_61[] = {94,102,107,210,115,6,137,18,14,220,220,154,102,44,152,50,112,163,169,91,102,236,176,18,209,18,66,128,188,112,213,122};
static const unsigned char precomputed_nG_merged25519_n_61[] = {72,100,21,171,53,71,79,134,164,152,237,173,26,184,165,153,158,133,172,216,74,232,190,206,30,247,0,133,14,153,102,60};
static const unsigned char precomputed_nG_merged25519_q_62[] = {40,34,94,183,173,244,46,30,228,227,7,34,147,79,57,140,16,211,131,33,164,143,86,13,59,79,3,126,221,12,28,7};
static const unsigned char precomputed_nG_merged25519_n_62[] = {157,38,1,210,164,205,77,143,52,65,73,133,72,122,248,162,212,199,0,145,19,35,54,117,137,14,135,105,63,81,144,235};
static const unsigned char precomputed_nG_merged25519_q_63[] = {88,211,7,25,201,88,168,130,72,20,154,92,7,71,239,4,46,12,86,203,211,97,229,221,126,224,228,156,234,121,95,234};
static const unsigned char precomputed_nG_merged25519_n_63[] = {253,3,6,26,136,2,66,96,106,120,74,93,73,149,57,185,179,34,114,254,238,89,214,249,89,134,63,107,246,153,54,65};
static const unsigned char precomputed_nG_merged25519_q_64[] = {164,93,249,139,221,192,154,53,53,4,75,103,251,134,100,22,176,210,193,110,41,152,7,181,183,242,116,87,93,105,63,103};
static const unsigned char precomputed_nG_merged25519_n_64[] = {196,127,157,234,203,32,233,90,251,147,116,243,54,34,152,23,113,128,143,41,35,171,220,236,200,29,59,57,81,216,242,46};
static const unsigned char precomputed_nG_merged25519_q_65[] = {78,17,74,143,171,215,95,164,212,137,254,178,80,127,13,45,218,255,252,69,223,52,164,135,35,235,86,167,242,168,236,103};
static const unsigned char precomputed_nG_merged25519_n_65[] = {189,88,70,51,3,225,206,243,44,236,56,56,63,27,10,70,38,118,146,59,244,21,230,106,99,190,212,77,221,42,67,119};
static const unsigned char precomputed_nG_merged25519_q_66[] = {238,71,34,225,188,4,13,26,144,70,157,250,182,111,168,59,200,155,227,247,34,54,218,28,163,8,138,72,214,170,189,205};
static const unsigned char precomputed_nG_merged25519_n_66[] = {96,67,95,208,121,23,46,57,171,108,102,161,216,172,175,73,159,168,123,35,51,75,193,132,253,144,246,222,228,201,23,120};
static const unsigned char precomputed_nG_merged25519_q_67[] = {205,244,204,202,186,74,88,247,237,46,10,63,190,73,201,18,80,21,131,2,27,114,134,253,136,114,45,238,195,219,180,95};
static const unsigned char precomputed_nG_merged25519_n_67[] = {80,100,100,236,81,142,247,64,196,4,194,165,131,253,155,207,59,201,241,174,81,150,188,140,106,66,123,104,218,67,145,225};
static const unsigned char precomputed_nG_merged25519_q_68[] = {207,105,197,117,253,71,103,227,138,245,193,163,168,77,226,89,15,205,65,110,249,119,140,15,0,216,133,172,219,11,12,78};
static const unsigned char precomputed_nG_merged25519_n_68[] = {233,72,18,18,154,96,44,46,69,98,137,231,214,88,100,165,3,75,237,52,80,33,116,228,43,128,227,6,227,217,76,187};
static const unsigned char precomputed_nG_merged25519_q_69[] = {18,244,198,188,213,166,93,14,150,4,96,98,118,116,209,211,231,126,9,244,38,88,106,37,193,144,221,115,240,252,81,111};
static const unsigned char precomputed_nG_merged25519_n_69[] = {43,62,58,85,209,87,135,23,116,39,173,126,145,132,233,35,14,143,64,228,200,245,115,249,221,87,246,141,46,248,100,149};
static const unsigned char precomputed_nG_merged25519_q_70[] = {165,90,179,130,204,218,247,189,238,129,95,131,245,206,6,87,236,171,29,181,84,203,58,135,151,5,105,151,216,202,1,74};
static const unsigned char precomputed_nG_merged25519_n_70[] = {64,158,173,19,54,201,125,205,64,105,92,171,243,239,180,235,148,208,199,169,144,13,196,138,184,75,87,249,102,183,126,43};
static const unsigned char precomputed_nG_merged25519_q_71[] = {133,92,158,60,21,108,200,188,216,157,11,100,96,200,221,117,219,48,228,176,97,62,104,115,183,167,21,42,129,98,38,186};
static const unsigned char precomputed_nG_merged25519_n_71[] = {19,113,230,38,129,48,147,11,124,8,111,128,153,85,193,126,61,154,198,200,239,194,164,107,68,141,42,46,56,69,33,98};
static const unsigned char precomputed_nG_merged25519_q_72[] = {20,237,110,80,59,209,61,56,111,148,161,62,94,73,71,11,136,115,27,106,35,245,9,34,242,155,207,61,54,203,109,48};
static const unsigned char precomputed_nG_merged25519_n_72[] = {24,83,121,203,216,158,47,158,106,131,35,241,108,240,206,28,173,12,170,244,188,196,51,234,225,185,32,12,113,236,151,236};
static const unsigned char precomputed_nG_merged25519_q_73[] = {253,54,15,90,187,233,161,252,143,101,101,38,34,132,111,199,94,15,122,119,75,57,99,36,225,104,27,222,80,204,86,56};
static const unsigned char precomputed_nG_merged25519_n_73[] = {248,159,134,88,110,15,245,200,135,10,19,194,156,195,9,247,186,157,233,66,255,55,66,40,70,31,13,43,11,111,10,230};
static const unsigned char precomputed_nG_merged25519_q_74[] = {28,105,254,10,231,115,112,55,241,180,78,217,105,125,154,196,34,237,67,69,158,58,184,109,75,145,66,138,183,152,79,114};
static const unsigned char precomputed_nG_merged25519_n_74[] = {115,32,32,108,246,168,201,224,61,168,100,219,252,25,55,139,127,219,33,52,24,76,69,66,108,103,119,186,96,134,30,172};
static const unsigned char precomputed_nG_merged25519_q_75[] = {106,64,102,69,75,76,222,173,193,40,48,164,165,224,27,134,45,156,207,131,71,218,255,75,233,205,19,222,200,63,137,110};
static const unsigned char precomputed_nG_merged25519_n_75[] = {231,137,251,196,111,109,126,243,38,184,15,33,198,220,208,33,59,108,93,74,212,123,38,136,118,183,19,173,181,143,188,221};
static const unsigned char precomputed_nG_merged25519_q_76[] = {51,0,154,92,203,162,128,110,60,210,148,225,64,147,104,76,53,214,226,119,105,175,147,176,189,36,196,48,204,125,140,74};
static const unsigned char precomputed_nG_merged25519_n_76[] = {110,142,138,114,250,226,80,42,161,22,196,158,214,195,61,114,158,160,103,242,24,249,73,36,79,200,62,23,67,249,127,233};
static const unsigned char precomputed_nG_merged25519_q_77[] = {173,63,99,222,178,169,165,115,226,108,38,97,159,224,238,158,102,213,137,254,244,132,140,168,205,19,207,181,159,165,194,87};
static const unsigned char precomputed_nG_merged25519_n_77[] = {239,172,33,52,11,26,217,131,181,27,143,107,112,67,36,57,94,240,68,167,75,36,103,79,98,132,210,155,149,60,209,161};
static const unsigned char precomputed_nG_merged25519_q_78[] = {142,19,103,213,195,194,97,250,148,224,75,200,156,48,183,123,204,31,244,92,207,162,85,25,191,192,177,25,22,58,95,124};
static const unsigned char precomputed_nG_merged25519_n_78[] = {6,217,152,202,221,143,3,38,149,101,61,144,40,23,137,233,163,16,12,229,171,154,216,148,14,205,132,185,238,71,249,112};
static const unsigned char precomputed_nG_merged25519_q_79[] = {233,95,239,159,15,181,173,37,243,124,28,216,129,180,0,151,91,112,141,36,220,146,17,124,19,178,132,24,234,162,36,244};
static const unsigned char precomputed_nG_merged25519_n_79[] = {6,135,247,173,18,176,22,216,166,110,161,143,141,200,221,129,42,79,83,173,174,132,231,147,232,175,117,130,2,31,93,14};
static const unsigned char precomputed_nG_merged25519_q_80[] = {235,171,214,149,185,117,9,254,75,198,158,20,118,39,247,14,72,254,101,241,228,92,233,245,163,79,202,89,154,38,132,29};
static const unsigned char precomputed_nG_merged25519_n_80[] = {206,30,35,121,193,167,76,209,105,93,144,225,202,208,155,182,114,69,152,249,191,40,241,150,74,237,103,141,45,134,49,150};
static const unsigned char precomputed_nG_merged25519_q_81[] = {214,216,103,27,218,87,176,96,72,144,132,217,160,62,190,195,11,199,232,164,81,188,169,152,35,134,228,11,185,203,32,73};
static const unsigned char precomputed_nG_merged25519_n_81[] = {145,47,221,170,77,40,173,100,195,78,80,9,96,127,171,225,209,30,146,84,132,80,124,73,136,250,118,185,99,198,43,199};
static const unsigned char precomputed_nG_merged25519_q_82[] = {147,107,197,226,199,221,124,115,1,151,31,97,7,191,23,89,121,172,248,61,81,73,56,254,34,100,135,233,166,53,221,186};
static const unsigned char precomputed_nG_merged25519_n_82[] = {205,249,166,148,75,51,38,174,72,78,240,79,133,244,142,19,70,159,50,81,53,205,71,30,104,21,48,115,35,67,138,109};
static const unsigned char precomputed_nG_merged25519_q_83[] = {243,66,247,66,62,57,139,168,183,216,236,87,204,55,230,94,176,175,28,253,21,22,179,98,36,80,46,193,32,75,176,221};
static const unsigned char precomputed_nG_merged25519_n_83[] = {117,117,96,45,99,75,192,252,46,168,191,224,36,237,231,142,215,231,57,205,200,223,55,199,229,183,115,121,31,33,190,65};
static const unsigned char precomputed_nG_merged25519_q_84[] = {66,98,79,170,54,172,253,63,39,103,7,48,86,182,100,69,160,157,35,220,78,33,201,243,81,165,193,173,74,107,65,111};
static const unsigned char precomputed_nG_merged25519_n_84[] = {193,32,91,37,76,201,20,214,211,232,4,199,153,114,132,79,182,60,248,77,231,125,36,85,96,131,88,21,129,8,12,254};
static const unsigned char precomputed_nG_merged25519_q_85[] = {63,109,129,80,49,251,201,41,111,80,204,4,32,17,72,57,245,212,128,171,163,29,223,218,225,178,156,90,41,231,63,50};
static const unsigned char precomputed_nG_merged25519_n_85[] = {173,240,96,2,195,99,177,226,68,136,188,49,84,64,250,149,78,173,55,99,107,69,7,98,140,191,148,157,137,64,57,253};
static const unsigned char precomputed_nG_merged25519_q_86[] = {165,218,225,122,152,34,207,72,61,226,193,169,80,241,112,239,38,233,231,207,178,54,206,212,133,125,35,105,102,123,35,78};
static const unsigned char precomputed_nG_merged25519_n_86[] = {119,134,61,169,0,75,34,229,11,132,226,236,8,126,158,37,140,35,100,188,235,250,43,92,241,191,144,35,62,158,192,194};
static const unsigned char precomputed_nG_merged25519_q_87[] = {129,14,10,182,22,250,85,228,111,244,59,106,178,39,85,228,194,153,252,106,152,225,13,35,178,228,16,124,177,11,144,124};
static const unsigned char precomputed_nG_merged25519_n_87[] = {92,225,6,97,141,108,210,197,69,239,217,18,245,137,32,30,244,109,38,198,48,32,13,219,142,47,192,78,4,86,66,146};
static const unsigned char precomputed_nG_merged25519_q_88[] = {15,156,131,174,171,245,73,196,50,113,21,84,229,117,131,19,240,26,40,194,169,109,75,243,132,163,33,178,59,115,34,35};
static const unsigned char precomputed_nG_merged25519_n_88[] = {75,67,250,11,172,214,74,39,6,155,217,211,40,248,114,121,85,162,145,159,43,211,53,203,221,189,68,127,205,54,116,114};
static const unsigned char precomputed_nG_merged25519_q_89[] = {167,150,91,222,34,202,202,158,222,85,128,125,225,140,250,177,131,111,252,19,78,156,30,206,120,120,33,191,222,164,107,115};
static const unsigned char precomputed_nG_merged25519_n_89[] = {20,207,210,24,33,88,119,199,31,61,106,27,94,223,248,77,172,83,39,188,217,206,87,250,252,38,206,58,2,113,194,248};
static const unsigned char precomputed_nG_merged25519_q_90[] = {157,28,212,39,141,145,95,162,161,34,193,186,160,255,21,46,4,123,71,62,139,70,253,180,92,58,33,23,147,100,24,51};
static const unsigned char precomputed_nG_merged25519_n_90[] = {77,228,48,160,181,122,36,55,119,132,115,250,186,94,158,181,32,107,7,234,127,48,192,30,17,88,200,152,147,12,19,139};
static const unsigned char precomputed_nG_merged25519_q_91[] = {32,4,56,86,178,184,215,9,111,109,135,216,176,215,186,144,237,223,114,178,34,90,4,207,191,96,29,51,205,35,111,76};
static const unsigned char precomputed_nG_merged25519_n_91[] = {0,85,143,145,217,163,110,101,94,145,23,188,73,70,35,131,56,156,39,40,139,38,11,113,24,155,9,1,103,240,219,86};
static const unsigned char precomputed_nG_merged25519_q_92[] = {225,190,105,124,86,25,110,82,29,88,218,55,207,70,14,99,173,57,30,203,18,85,102,59,145,14,76,243,120,196,138,86};
static const unsigned char precomputed_nG_merged25519_n_92[] = {202,103,195,152,83,118,152,164,128,218,18,106,71,167,100,220,1,129,233,117,55,58,2,173,24,163,2,68,28,27,161,123};
static const unsigned char precomputed_nG_merged25519_q_93[] = {182,234,44,163,47,9,78,52,43,3,241,173,22,50,195,210,227,148,226,23,149,227,156,108,210,163,27,67,1,136,37,39};
static const unsigned char precomputed_nG_merged25519_n_93[] = {162,179,114,79,63,57,44,81,193,33,56,180,102,58,185,3,70,217,121,210,171,203,151,18,81,228,82,143,252,240,97,232};
static const unsigned char precomputed_nG_merged25519_q_94[] = {48,224,174,249,239,168,73,98,61,187,13,145,102,138,147,147,14,188,98,66,30,117,0,77,145,146,36,181,80,202,231,6};
static const unsigned char precomputed_nG_merged25519_n_94[] = {106,112,23,50,29,210,39,79,57,12,122,158,177,133,83,96,21,12,240,106,115,15,239,159,86,17,166,198,166,144,68,131};
static const unsigned char precomputed_nG_merged25519_q_95[] = {103,4,29,212,189,81,41,119,43,101,173,124,11,88,197,0,119,233,81,166,249,141,15,95,117,141,185,72,175,241,87,103};
static const unsigned char precomputed_nG_merged25519_n_95[] = {242,83,31,132,61,78,147,229,73,88,255,37,96,242,142,208,96,30,12,65,15,166,34,212,185,19,37,196,234,33,166,151};
static const unsigned char precomputed_nG_merged25519_q_96[] = {27,156,149,160,184,52,147,29,234,37,202,73,115,189,28,177,197,146,89,15,96,199,5,64,169,222,219,220,171,226,66,248};
static const unsigned char precomputed_nG_merged25519_n_96[] = {6,103,172,137,117,164,200,126,96,32,78,249,8,9,121,182,225,39,158,28,170,212,240,198,33,82,172,221,48,191,250,100};
static const unsigned char precomputed_nG_merged25519_q_97[] = {1,24,59,4,101,181,100,139,204,31,91,210,250,247,205,54,207,76,172,109,87,165,124,71,54,10,195,97,56,12,172,119};
static const unsigned char precomputed_nG_merged25519_n_97[] = {241,165,131,211,163,174,119,205,198,110,254,246,41,123,207,207,233,245,144,31,180,78,131,233,236,243,226,255,93,157,226,206};
static const unsigned char precomputed_nG_merged25519_q_98[] = {148,212,155,105,22,42,217,97,82,59,154,179,74,106,70,86,158,48,249,1,47,163,225,178,78,55,115,221,50,22,43,58};
static const unsigned char precomputed_nG_merged25519_n_98[] = {18,32,225,235,121,109,146,205,229,146,24,56,24,233,22,126,111,33,133,159,249,31,175,203,2,41,57,167,207,53,236,206};
static const unsigned char precomputed_nG_merged25519_q_99[] = {225,34,160,192,183,237,222,62,18,34,101,94,193,177,206,74,24,97,106,197,225,78,237,65,51,252,187,109,92,29,202,129};
static const unsigned char precomputed_nG_merged25519_n_99[] = {228,182,61,134,80,248,152,169,144,228,86,31,210,36,187,230,104,176,123,182,92,161,98,225,228,95,8,126,179,188,115,118};
static const unsigned char precomputed_nG_merged25519_q_100[] = {139,196,209,44,209,44,206,240,225,210,83,122,92,29,82,49,201,107,25,98,252,160,170,19,93,176,110,173,57,73,137,180};
static const unsigned char precomputed_nG_merged25519_n_100[] = {49,236,81,17,2,139,29,237,148,53,47,163,234,48,26,98,132,219,243,15,45,42,104,62,63,171,30,136,14,40,174,109};
static const unsigned char precomputed_nG_merged25519_q_101[] = {200,68,80,223,3,67,208,248,155,67,114,26,214,120,251,203,153,130,112,48,196,193,96,204,125,162,51,125,191,190,48,61};
static const unsigned char precomputed_nG_merged25519_n_101[] = {33,217,207,179,131,181,1,204,249,19,229,30,156,109,111,164,27,182,181,77,81,125,9,245,26,188,57,29,171,9,47,192};
static const unsigned char precomputed_nG_merged25519_q_102[] = {162,0,28,103,136,199,40,69,106,172,107,46,177,130,171,227,6,191,227,196,211,59,112,31,127,243,230,75,168,13,19,92};
static const unsigned char precomputed_nG_merged25519_n_102[] = {236,78,246,110,90,65,156,79,220,93,140,241,38,133,101,190,143,22,91,102,47,73,132,2,22,121,87,44,105,189,228,180};
static const unsigned char precomputed_nG_merged25519_q_103[] = {181,83,207,199,72,216,70,141,103,75,12,215,43,233,19,173,128,44,64,109,76,20,22,167,24,248,77,171,213,137,180,56};
static const unsigned char precomputed_nG_merged25519_n_103[] = {245,221,226,170,131,224,135,73,20,30,235,241,107,173,155,180,184,216,168,105,219,47,44,188,238,195,28,137,94,120,174,91};
static const unsigned char precomputed_nG_merged25519_q_104[] = {71,119,22,251,156,223,174,133,159,200,189,175,198,175,37,249,90,163,106,137,219,152,188,26,107,104,148,212,4,101,234,212};
static const unsigned char precomputed_nG_merged25519_n_104[] = {8,110,37,59,118,72,82,221,109,207,92,19,105,210,153,89,229,172,147,205,252,51,0,133,51,39,92,169,81,25,113,18};
static const unsigned char precomputed_nG_merged25519_q_105[] = {97,191,64,101,220,164,47,33,92,169,162,204,26,9,86,248,55,187,250,75,234,108,64,1,193,167,59,166,224,103,184,207};
static const unsigned char precomputed_nG_merged25519_n_105[] = {51,31,171,63,97,168,57,202,66,43,203,171,187,15,254,191,246,7,131,10,3,57,222,127,141,185,51,175,75,110,249,4};
static const unsigned char precomputed_nG_merged25519_q_106[] = {76,27,91,200,170,63,179,215,123,123,223,230,21,31,9,240,212,176,243,58,224,151,208,131,227,132,237,68,13,224,219,148};
static const unsigned char precomputed_nG_merged25519_n_106[] = {241,246,125,43,103,239,237,44,122,195,143,51,187,182,68,211,122,192,110,133,60,55,181,156,118,151,66,42,142,233,132,34};
static const unsigned char precomputed_nG_merged25519_q_107[] = {80,193,160,250,22,205,105,190,55,82,214,175,175,117,25,132,128,10,117,160,3,237,122,84,219,126,65,17,178,107,51,33};
static const unsigned char precomputed_nG_merged25519_n_107[] = {2,41,17,26,198,119,88,167,221,59,136,122,82,120,126,136,179,22,219,44,233,104,217,7,148,253,9,120,150,203,254,237};
static const unsigned char precomputed_nG_merged25519_q_108[] = {88,132,109,9,176,42,17,99,143,109,179,197,8,51,55,60,45,32,11,228,153,51,203,230,238,12,9,134,16,146,75,126};
static const unsigned char precomputed_nG_merged25519_n_108[] = {125,90,104,48,37,34,117,80,250,44,224,225,239,233,34,113,20,30,116,156,8,71,218,236,40,109,90,225,65,250,159,108};
static const unsigned char precomputed_nG_merged25519_q_109[] = {9,59,236,159,88,156,60,215,65,29,144,206,180,240,221,133,71,146,251,75,252,22,188,79,124,76,59,55,152,30,120,93};
static const unsigned char precomputed_nG_merged25519_n_109[] = {227,109,59,1,58,16,245,87,220,24,30,226,66,198,241,233,56,135,231,193,211,152,219,126,146,145,2,63,45,26,101,128};
static const unsigned char precomputed_nG_merged25519_q_110[] = {191,249,157,232,214,180,112,120,128,229,97,155,200,139,7,30,132,28,110,105,27,93,58,81,241,138,52,156,75,38,170,223};
static const unsigned char precomputed_nG_merged25519_n_110[] = {113,187,8,166,79,70,149,53,130,231,56,237,79,78,172,236,61,72,102,223,207,79,138,186,125,207,95,0,177,15,132,122};
static const unsigned char precomputed_nG_merged25519_q_111[] = {193,163,64,210,46,2,8,101,66,90,202,139,180,114,144,167,116,154,10,162,29,28,70,190,121,65,247,181,59,221,95,10};
static const unsigned char precomputed_nG_merged25519_n_111[] = {93,227,44,20,223,204,200,210,52,230,156,36,182,136,110,83,212,117,127,20,116,192,95,155,246,9,93,2,88,150,91,175};
static const unsigned char precomputed_nG_merged25519_q_112[] = {161,100,179,27,120,46,131,106,156,182,96,12,244,230,127,114,131,43,131,19,163,133,110,90,144,253,114,178,96,133,93,5};
static const unsigned char precomputed_nG_merged25519_n_112[] = {156,159,107,251,13,107,248,203,242,51,231,164,48,88,246,149,122,70,55,125,192,227,47,76,143,7,212,219,249,226,91,20};
static const unsigned char precomputed_nG_merged25519_q_113[] = {128,238,13,127,53,21,194,18,125,63,187,117,97,223,163,170,16,44,103,209,192,127,158,79,25,214,13,249,222,171,186,65};
static const unsigned char precomputed_nG_merged25519_n_113[] = {155,169,171,165,88,143,193,192,229,174,23,49,24,155,232,133,248,158,173,112,162,42,89,62,236,107,89,123,133,124,54,150};
static const unsigned char precomputed_nG_merged25519_q_114[] = {71,86,74,9,116,177,179,72,49,12,187,225,75,169,228,26,94,248,217,152,21,193,203,221,238,197,40,170,162,145,195,184};
static const unsigned char precomputed_nG_merged25519_n_114[] = {26,62,104,111,173,4,224,251,190,230,249,253,27,212,248,115,63,69,100,77,7,29,186,147,98,124,34,222,64,48,49,2};
static const unsigned char precomputed_nG_merged25519_q_115[] = {96,77,52,193,212,255,140,137,183,101,150,16,239,128,116,134,165,76,199,185,49,200,211,176,137,163,66,104,2,14,220,110};
static const unsigned char precomputed_nG_merged25519_n_115[] = {187,42,244,170,51,253,205,98,135,221,225,10,161,197,254,133,41,49,62,82,9,165,246,119,57,111,103,87,234,183,118,119};
static const unsigned char precomputed_nG_merged25519_q_116[] = {251,122,111,246,120,208,239,166,211,47,180,228,135,106,178,161,15,90,163,79,210,199,245,48,125,114,70,136,15,51,123,43};
static const unsigned char precomputed_nG_merged25519_n_116[] = {13,90,122,148,215,139,219,237,185,114,250,70,116,26,1,229,181,21,41,198,156,62,65,116,102,65,232,237,83,231,46,123};
static const unsigned char precomputed_nG_merged25519_q_117[] = {254,56,122,215,227,189,131,240,213,75,243,96,40,48,216,14,61,70,218,222,28,25,28,112,138,222,58,39,139,105,208,188};
static const unsigned char precomputed_nG_merged25519_n_117[] = {173,73,74,2,64,170,144,40,211,161,103,64,184,199,221,15,119,56,55,58,32,155,79,206,222,17,202,243,85,7,249,32};
static const unsigned char precomputed_nG_merged25519_q_118[] = {221,144,122,161,220,168,63,59,177,157,151,203,105,57,134,223,243,13,30,44,194,10,1,192,48,233,52,177,105,254,108,37};
static const unsigned char precomputed_nG_merged25519_n_118[] = {91,105,22,97,41,149,73,204,172,72,190,52,82,126,42,195,82,141,250,205,139,134,76,38,99,191,208,128,76,201,55,231};
static const unsigned char precomputed_nG_merged25519_q_119[] = {78,244,242,41,180,182,171,231,130,180,254,93,212,239,161,66,35,163,55,159,190,81,232,197,205,60,66,192,146,71,126,210};
static const unsigned char precomputed_nG_merged25519_n_119[] = {127,124,129,161,81,20,51,3,237,224,90,78,3,255,236,201,174,25,159,192,35,38,221,205,117,196,123,153,131,97,173,41};
static const unsigned char precomputed_nG_merged25519_q_120[] = {178,209,37,76,92,190,183,6,38,251,155,51,255,151,33,71,104,89,232,137,138,125,206,77,17,154,32,61,166,217,74,76};
static const unsigned char precomputed_nG_merged25519_n_120[] = {235,79,40,53,50,46,91,206,26,218,236,208,101,116,229,44,123,135,18,53,252,116,102,73,71,88,173,160,24,196,88,153};
static const unsigned char precomputed_nG_merged25519_q_121[] = {191,10,24,120,44,179,136,225,116,92,171,204,31,30,102,250,50,117,22,18,136,83,30,123,36,38,207,185,206,28,234,141};
static const unsigned char precomputed_nG_merged25519_n_121[] = {164,254,126,2,194,185,7,81,241,195,17,238,106,157,143,211,114,205,13,51,6,145,23,226,4,20,99,74,71,42,49,39};
static const unsigned char precomputed_nG_merged25519_q_122[] = {58,181,135,41,98,14,200,55,50,69,113,145,130,232,245,132,1,147,73,34,113,192,103,105,0,250,245,167,128,228,122,23};
static const unsigned char precomputed_nG_merged25519_n_122[] = {203,123,250,217,215,118,221,47,96,108,78,133,238,243,192,231,94,7,153,53,191,65,197,139,131,119,1,241,107,153,115,69};
static const unsigned char precomputed_nG_merged25519_q_123[] = {10,72,125,214,110,45,3,118,32,248,245,177,46,193,190,2,48,119,133,76,133,151,170,178,95,229,20,25,94,227,144,32};
static const unsigned char precomputed_nG_merged25519_n_123[] = {127,92,207,211,116,218,76,193,246,23,111,48,131,110,18,170,173,143,73,65,103,209,153,66,51,108,250,130,234,97,143,31};
static const unsigned char precomputed_nG_merged25519_q_124[] = {183,207,141,110,147,213,44,151,129,41,25,148,84,127,165,255,122,216,43,166,238,19,240,81,44,68,20,188,167,16,179,83};
static const unsigned char precomputed_nG_merged25519_n_124[] = {226,156,59,127,152,20,194,27,95,223,50,111,146,27,26,216,73,45,195,208,255,45,214,208,129,172,213,207,4,213,28,172};
static const unsigned char precomputed_nG_merged25519_q_125[] = {63,43,52,114,8,20,123,139,103,128,106,211,137,227,227,93,175,5,45,53,98,253,244,166,11,210,188,150,201,99,173,5};
static const unsigned char precomputed_nG_merged25519_n_125[] = {207,188,210,60,233,151,159,85,160,172,249,57,189,94,226,240,173,18,186,146,117,178,6,183,175,114,227,103,89,124,73,60};
static const unsigned char precomputed_nG_merged25519_q_126[] = {6,174,70,114,4,103,88,251,52,214,179,58,36,214,175,226,215,13,97,187,25,122,13,188,214,181,191,132,225,111,28,210};
static const unsigned char precomputed_nG_merged25519_n_126[] = {164,141,12,199,217,10,241,247,45,93,212,32,193,214,246,251,81,32,178,225,232,253,224,210,26,214,89,22,84,132,155,7};
static const unsigned char precomputed_nG_merged25519_q_127[] = {17,207,26,138,16,164,197,241,107,166,102,45,23,192,169,209,69,89,215,28,123,239,163,166,213,162,143,19,18,4,128,96};
static const unsigned char precomputed_nG_merged25519_n_127[] = {204,196,172,188,163,217,81,173,134,119,178,82,23,75,105,24,147,9,9,245,75,228,228,161,166,124,93,87,233,144,56,163};
static const unsigned char precomputed_nG_merged25519_q_128[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_128[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_130[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_130[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_131[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_131[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_132[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_132[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_133[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_133[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_134[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_134[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_135[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_135[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_136[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_136[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_137[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_137[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_138[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_138[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_139[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_139[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_140[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_140[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_141[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_141[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_142[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_142[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_143[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_143[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_144[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_144[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_145[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_145[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_146[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_146[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_147[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_147[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_148[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_148[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_149[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_149[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_150[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_150[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_151[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_151[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_152[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_152[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_153[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_153[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_154[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_154[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_155[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_155[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_156[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_156[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_157[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_157[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_158[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_158[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_159[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_159[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_160[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_160[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_161[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_161[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_162[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_162[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_163[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_163[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_164[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_164[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_165[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_165[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_166[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_166[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_167[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_167[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_168[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_168[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_169[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_169[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_170[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_170[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_171[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_171[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_172[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_172[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_173[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_173[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_174[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_174[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_175[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_175[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_176[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_176[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_177[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_177[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_178[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_178[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_179[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_179[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_180[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_180[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_181[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_181[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_182[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_182[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_183[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_183[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_184[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_184[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_185[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_185[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_186[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_186[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_187[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_187[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_188[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_188[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_189[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_189[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_190[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_190[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_191[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_191[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_192[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_192[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_193[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_193[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_194[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_194[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_195[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_195[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_196[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_196[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_197[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_197[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_198[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_198[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_199[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_199[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_200[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_200[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_201[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_201[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_202[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_202[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_203[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_203[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
} precomputed_nG_merged25519[precomputed_nG_merged25519_NUM] = {
  {
    precomputed_nG_merged25519_q_0,32,
    precomputed_nG_merged25519_n_0,32,
  },
  {
    precomputed_nG_merged25519_q_1,32,
    precomputed_nG_merged25519_n_1,32,
  },
  {
    precomputed_nG_merged25519_q_2,32,
    precomputed_nG_merged25519_n_2,32,
  },
  {
    precomputed_nG_merged25519_q_3,32,
    precomputed_nG_merged25519_n_3,32,
  },
  {
    precomputed_nG_merged25519_q_4,32,
    precomputed_nG_merged25519_n_4,32,
  },
  {
    precomputed_nG_merged25519_q_5,32,
    precomputed_nG_merged25519_n_5,32,
  },
  {
    precomputed_nG_merged25519_q_6,32,
    precomputed_nG_merged25519_n_6,32,
  },
  {
    precomputed_nG_merged25519_q_7,32,
    precomputed_nG_merged25519_n_7,32,
  },
  {
    precomputed_nG_merged25519_q_8,32,
    precomputed_nG_merged25519_n_8,32,
  },
  {
    precomputed_nG_merged25519_q_9,32,
    precomputed_nG_merged25519_n_9,32,
  },
  {
    precomputed_nG_merged25519_q_10,32,
    precomputed_nG_merged25519_n_10,32,
  },
  {
    precomputed_nG_merged25519_q_11,32,
    precomputed_nG_merged25519_n_11,32,
  },
  {
    precomputed_nG_merged25519_q_12,32,
    precomputed_nG_merged25519_n_12,32,
  },
  {
    precomputed_nG_merged25519_q_13,32,
    precomputed_nG_merged25519_n_13,32,
  },
  {
    precomputed_nG_merged25519_q_14,32,
    precomputed_nG_merged25519_n_14,32,
  },
  {
    precomputed_nG_merged25519_q_15,32,
    precomputed_nG_merged25519_n_15,32,
  },
  {
    precomputed_nG_merged25519_q_16,32,
    precomputed_nG_merged25519_n_16,32,
  },
  {
    precomputed_nG_merged25519_q_17,32,
    precomputed_nG_merged25519_n_17,32,
  },
  {
    precomputed_nG_merged25519_q_18,32,
    precomputed_nG_merged25519_n_18,32,
  },
  {
    precomputed_nG_merged25519_q_19,32,
    precomputed_nG_merged25519_n_19,32,
  },
  {
    precomputed_nG_merged25519_q_20,32,
    precomputed_nG_merged25519_n_20,32,
  },
  {
    precomputed_nG_merged25519_q_21,32,
    precomputed_nG_merged25519_n_21,32,
  },
  {
    precomputed_nG_merged25519_q_22,32,
    precomputed_nG_merged25519_n_22,32,
  },
  {
    precomputed_nG_merged25519_q_23,32,
    precomputed_nG_merged25519_n_23,32,
  },
  {
    precomputed_nG_merged25519_q_24,32,
    precomputed_nG_merged25519_n_24,32,
  },
  {
    precomputed_nG_merged25519_q_25,32,
    precomputed_nG_merged25519_n_25,32,
  },
  {
    precomputed_nG_merged25519_q_26,32,
    precomputed_nG_merged25519_n_26,32,
  },
  {
    precomputed_nG_merged25519_q_27,32,
    precomputed_nG_merged25519_n_27,32,
  },
  {
    precomputed_nG_merged25519_q_28,32,
    precomputed_nG_merged25519_n_28,32,
  },
  {
    precomputed_nG_merged25519_q_29,32,
    precomputed_nG_merged25519_n_29,32,
  },
  {
    precomputed_nG_merged25519_q_30,32,
    precomputed_nG_merged25519_n_30,32,
  },
  {
    precomputed_nG_merged25519_q_31,32,
    precomputed_nG_merged25519_n_31,32,
  },
  {
    precomputed_nG_merged25519_q_32,32,
    precomputed_nG_merged25519_n_32,32,
  },
  {
    precomputed_nG_merged25519_q_33,32,
    precomputed_nG_merged25519_n_33,32,
  },
  {
    precomputed_nG_merged25519_q_34,32,
    precomputed_nG_merged25519_n_34,32,
  },
  {
    precomputed_nG_merged25519_q_35,32,
    precomputed_nG_merged25519_n_35,32,
  },
  {
    precomputed_nG_merged25519_q_36,32,
    precomputed_nG_merged25519_n_36,32,
  },
  {
    precomputed_nG_merged25519_q_37,32,
    precomputed_nG_merged25519_n_37,32,
  },
  {
    precomputed_nG_merged25519_q_38,32,
    precomputed_nG_merged25519_n_38,32,
  },
  {
    precomputed_nG_merged25519_q_39,32,
    precomputed_nG_merged25519_n_39,32,
  },
  {
    precomputed_nG_merged25519_q_40,32,
    precomputed_nG_merged25519_n_40,32,
  },
  {
    precomputed_nG_merged25519_q_41,32,
    precomputed_nG_merged25519_n_41,32,
  },
  {
    precomputed_nG_merged25519_q_42,32,
    precomputed_nG_merged25519_n_42,32,
  },
  {
    precomputed_nG_merged25519_q_43,32,
    precomputed_nG_merged25519_n_43,32,
  },
  {
    precomputed_nG_merged25519_q_44,32,
    precomputed_nG_merged25519_n_44,32,
  },
  {
    precomputed_nG_merged25519_q_45,32,
    precomputed_nG_merged25519_n_45,32,
  },
  {
    precomputed_nG_merged25519_q_46,32,
    precomputed_nG_merged25519_n_46,32,
  },
  {
    precomputed_nG_merged25519_q_47,32,
    precomputed_nG_merged25519_n_47,32,
  },
  {
    precomputed_nG_merged25519_q_48,32,
    precomputed_nG_merged25519_n_48,32,
  },
  {
    precomputed_nG_merged25519_q_49,32,
    precomputed_nG_merged25519_n_49,32,
  },
  {
    precomputed_nG_merged25519_q_50,32,
    precomputed_nG_merged25519_n_50,32,
  },
  {
    precomputed_nG_merged25519_q_51,32,
    precomputed_nG_merged25519_n_51,32,
  },
  {
    precomputed_nG_merged25519_q_52,32,
    precomputed_nG_merged25519_n_52,32,
  },
  {
    precomputed_nG_merged25519_q_53,32,
    precomputed_nG_merged25519_n_53,32,
  },
  {
    precomputed_nG_merged25519_q_54,32,
    precomputed_nG_merged25519_n_54,32,
  },
  {
    precomputed_nG_merged25519_q_55,32,
    precomputed_nG_merged25519_n_55,32,
  },
  {
    precomputed_nG_merged25519_q_56,32,
    precomputed_nG_merged25519_n_56,32,
  },
  {
    precomputed_nG_merged25519_q_57,32,
    precomputed_nG_merged25519_n_57,32,
  },
  {
    precomputed_nG_merged25519_q_58,32,
    precomputed_nG_merged25519_n_58,32,
  },
  {
    precomputed_nG_merged25519_q_59,32,
    precomputed_nG_merged25519_n_59,32,
  },
  {
    precomputed_nG_merged25519_q_60,32,
    precomputed_nG_merged25519_n_60,32,
  },
  {
    precomputed_nG_merged25519_q_61,32,
    precomputed_nG_merged25519_n_61,32,
  },
  {
    precomputed_nG_merged25519_q_62,32,
    precomputed_nG_merged25519_n_62,32,
  },
  {
    precomputed_nG_merged25519_q_63,32,
    precomputed_nG_merged25519_n_63,32,
  },
  {
    precomputed_nG_merged25519_q_64,32,
    precomputed_nG_merged25519_n_64,32,
  },
  {
    precomputed_nG_merged25519_q_65,32,
    precomputed_nG_merged25519_n_65,32,
  },
  {
    precomputed_nG_merged25519_q_66,32,
    precomputed_nG_merged25519_n_66,32,
  },
  {
    precomputed_nG_merged25519_q_67,32,
    precomputed_nG_merged25519_n_67,32,
  },
  {
    precomputed_nG_merged25519_q_68,32,
    precomputed_nG_merged25519_n_68,32,
  },
  {
    precomputed_nG_merged25519_q_69,32,
    precomputed_nG_merged25519_n_69,32,
  },
  {
    precomputed_nG_merged25519_q_70,32,
    precomputed_nG_merged25519_n_70,32,
  },
  {
    precomputed_nG_merged25519_q_71,32,
    precomputed_nG_merged25519_n_71,32,
  },
  {
    precomputed_nG_merged25519_q_72,32,
    precomputed_nG_merged25519_n_72,32,
  },
  {
    precomputed_nG_merged25519_q_73,32,
    precomputed_nG_merged25519_n_73,32,
  },
  {
    precomputed_nG_merged25519_q_74,32,
    precomputed_nG_merged25519_n_74,32,
  },
  {
    precomputed_nG_merged25519_q_75,32,
    precomputed_nG_merged25519_n_75,32,
  },
  {
    precomputed_nG_merged25519_q_76,32,
    precomputed_nG_merged25519_n_76,32,
  },
  {
    precomputed_nG_merged25519_q_77,32,
    precomputed_nG_merged25519_n_77,32,
  },
  {
    precomputed_nG_merged25519_q_78,32,
    precomputed_nG_merged25519_n_78,32,
  },
  {
    precomputed_nG_merged25519_q_79,32,
    precomputed_nG_merged25519_n_79,32,
  },
  {
    precomputed_nG_merged25519_q_80,32,
    precomputed_nG_merged25519_n_80,32,
  },
  {
    precomputed_nG_merged25519_q_81,32,
    precomputed_nG_merged25519_n_81,32,
  },
  {
    precomputed_nG_merged25519_q_82,32,
    precomputed_nG_merged25519_n_82,32,
  },
  {
    precomputed_nG_merged25519_q_83,32,
    precomputed_nG_merged25519_n_83,32,
  },
  {
    precomputed_nG_merged25519_q_84,32,
    precomputed_nG_merged25519_n_84,32,
  },
  {
    precomputed_nG_merged25519_q_85,32,
    precomputed_nG_merged25519_n_85,32,
  },
  {
    precomputed_nG_merged25519_q_86,32,
    precomputed_nG_merged25519_n_86,32,
  },
  {
    precomputed_nG_merged25519_q_87,32,
    precomputed_nG_merged25519_n_87,32,
  },
  {
    precomputed_nG_merged25519_q_88,32,
    precomputed_nG_merged25519_n_88,32,
  },
  {
    precomputed_nG_merged25519_q_89,32,
    precomputed_nG_merged25519_n_89,32,
  },
  {
    precomputed_nG_merged25519_q_90,32,
    precomputed_nG_merged25519_n_90,32,
  },
  {
    precomputed_nG_merged25519_q_91,32,
    precomputed_nG_merged25519_n_91,32,
  },
  {
    precomputed_nG_merged25519_q_92,32,
    precomputed_nG_merged25519_n_92,32,
  },
  {
    precomputed_nG_merged25519_q_93,32,
    precomputed_nG_merged25519_n_93,32,
  },
  {
    precomputed_nG_merged25519_q_94,32,
    precomputed_nG_merged25519_n_94,32,
  },
  {
    precomputed_nG_merged25519_q_95,32,
    precomputed_nG_merged25519_n_95,32,
  },
  {
    precomputed_nG_merged25519_q_96,32,
    precomputed_nG_merged25519_n_96,32,
  },
  {
    precomputed_nG_merged25519_q_97,32,
    precomputed_nG_merged25519_n_97,32,
  },
  {
    precomputed_nG_merged25519_q_98,32,
    precomputed_nG_merged25519_n_98,32,
  },
  {
    precomputed_nG_merged25519_q_99,32,
    precomputed_nG_merged25519_n_99,32,
  },
  {
    precomputed_nG_merged25519_q_100,32,
    precomputed_nG_merged25519_n_100,32,
  },
  {
    precomputed_nG_merged25519_q_101,32,
    precomputed_nG_merged25519_n_101,32,
  },
  {
    precomputed_nG_merged25519_q_102,32,
    precomputed_nG_merged25519_n_102,32,
  },
  {
    precomputed_nG_merged25519_q_103,32,
    precomputed_nG_merged25519_n_103,32,
  },
  {
    precomputed_nG_merged25519_q_104,32,
    precomputed_nG_merged25519_n_104,32,
  },
  {
    precomputed_nG_merged25519_q_105,32,
    precomputed_nG_merged25519_n_105,32,
  },
  {
    precomputed_nG_merged25519_q_106,32,
    precomputed_nG_merged25519_n_106,32,
  },
  {
    precomputed_nG_merged25519_q_107,32,
    precomputed_nG_merged25519_n_107,32,
  },
  {
    precomputed_nG_merged25519_q_108,32,
    precomputed_nG_merged25519_n_108,32,
  },
  {
    precomputed_nG_merged25519_q_109,32,
    precomputed_nG_merged25519_n_109,32,
  },
  {
    precomputed_nG_merged25519_q_110,32,
    precomputed_nG_merged25519_n_110,32,
  },
  {
    precomputed_nG_merged25519_q_111,32,
    precomputed_nG_merged25519_n_111,32,
  },
  {
    precomputed_nG_merged25519_q_112,32,
    precomputed_nG_merged25519_n_112,32,
  },
  {
    precomputed_nG_merged25519_q_113,32,
    precomputed_nG_merged25519_n_113,32,
  },
  {
    precomputed_nG_merged25519_q_114,32,
    precomputed_nG_merged25519_n_114,32,
  },
  {
    precomputed_nG_merged25519_q_115,32,
    precomputed_nG_merged25519_n_115,32,
  },
  {
    precomputed_nG_merged25519_q_116,32,
    precomputed_nG_merged25519_n_116,32,
  },
  {
    precomputed_nG_merged25519_q_117,32,
    precomputed_nG_merged25519_n_117,32,
  },
  {
    precomputed_nG_merged25519_q_118,32,
    precomputed_nG_merged25519_n_118,32,
  },
  {
    precomputed_nG_merged25519_q_119,32,
    precomputed_nG_merged25519_n_119,32,
  },
  {
    precomputed_nG_merged25519_q_120,32,
    precomputed_nG_merged25519_n_120,32,
  },
  {
    precomputed_nG_merged25519_q_121,32,
    precomputed_nG_merged25519_n_121,32,
  },
  {
    precomputed_nG_merged25519_q_122,32,
    precomputed_nG_merged25519_n_122,32,
  },
  {
    precomputed_nG_merged25519_q_123,32,
    precomputed_nG_merged25519_n_123,32,
  },
  {
    precomputed_nG_merged25519_q_124,32,
    precomputed_nG_merged25519_n_124,32,
  },
  {
    precomputed_nG_merged25519_q_125,32,
    precomputed_nG_merged25519_n_125,32,
  },
  {
    precomputed_nG_merged25519_q_126,32,
    precomputed_nG_merged25519_n_126,32,
  },
  {
    precomputed_nG_merged25519_q_127,32,
    precomputed_nG_merged25519_n_127,32,
  },
  {
    precomputed_nG_merged25519_q_128,32,
    precomputed_nG_merged25519_n_128,32,
  },
  {
    precomputed_nG_merged25519_q_129,32,
    precomputed_nG_merged25519_n_129,32,
  },
  {
    precomputed_nG_merged25519_q_130,32,
    precomputed_nG_merged25519_n_130,32,
  },
  {
    precomputed_nG_merged25519_q_131,32,
    precomputed_nG_merged25519_n_131,32,
  },
  {
    precomputed_nG_merged25519_q_132,32,
    precomputed_nG_merged25519_n_132,32,
  },
  {
    precomputed_nG_merged25519_q_133,32,
    precomputed_nG_merged25519_n_133,32,
  },
  {
    precomputed_nG_merged25519_q_134,32,
    precomputed_nG_merged25519_n_134,32,
  },
  {
    precomputed_nG_merged25519_q_135,32,
    precomputed_nG_merged25519_n_135,32,
  },
  {
    precomputed_nG_merged25519_q_136,32,
    precomputed_nG_merged25519_n_136,32,
  },
  {
    precomputed_nG_merged25519_q_137,32,
    precomputed_nG_merged25519_n_137,32,
  },
  {
    precomputed_nG_merged25519_q_138,32,
    precomputed_nG_merged25519_n_138,32,
  },
  {
    precomputed_nG_merged25519_q_139,32,
    precomputed_nG_merged25519_n_139,32,
  },
  {
    precomputed_nG_merged25519_q_140,32,
    precomputed_nG_merged25519_n_140,32,
  },
  {
    precomputed_nG_merged25519_q_141,32,
    precomputed_nG_merged25519_n_141,32,
  },
  {
    precomputed_nG_merged25519_q_142,32,
    precomputed_nG_merged25519_n_142,32,
  },
  {
    precomputed_nG_merged25519_q_143,32,
    precomputed_nG_merged25519_n_143,32,
  },
  {
    precomputed_nG_merged25519_q_144,32,
    precomputed_nG_merged25519_n_144,32,
  },
  {
    precomputed_nG_merged25519_q_145,32,
    precomputed_nG_merged25519_n_145,32,
  },
  {
    precomputed_nG_merged25519_q_146,32,
    precomputed_nG_merged25519_n_146,32,
  },
  {
    precomputed_nG_merged25519_q_147,32,
    precomputed_nG_merged25519_n_147,32,
  },
  {
    precomputed_nG_merged25519_q_148,32,
    precomputed_nG_merged25519_n_148,32,
  },
  {
    precomputed_nG_merged25519_q_149,32,
    precomputed_nG_merged25519_n_149,32,
  },
  {
    precomputed_nG_merged25519_q_150,32,
    precomputed_nG_merged25519_n_150,32,
  },
  {
    precomputed_nG_merged25519_q_151,32,
    precomputed_nG_merged25519_n_151,32,
  },
  {
    precomputed_nG_merged25519_q_152,32,
    precomputed_nG_merged25519_n_152,32,
  },
  {
    precomputed_nG_merged25519_q_153,32,
    precomputed_nG_merged25519_n_153,32,
  },
  {
    precomputed_nG_merged25519_q_154,32,
    precomputed_nG_merged25519_n_154,32,
  },
  {
    precomputed_nG_merged25519_q_155,32,
    precomputed_nG_merged25519_n_155,32,
  },
  {
    precomputed_nG_merged25519_q_156,32,
    precomputed_nG_merged25519_n_156,32,
  },
  {
    precomputed_nG_merged25519_q_157,32,
    precomputed_nG_merged25519_n_157,32,
  },
  {
    precomputed_nG_merged25519_q_158,32,
    precomputed_nG_merged25519_n_158,32,
  },
  {
    precomputed_nG_merged25519_q_159,32,
    precomputed_nG_merged25519_n_159,32,
  },
  {
    precomputed_nG_merged25519_q_160,32,
    precomputed_nG_merged25519_n_160,32,
  },
  {
    precomputed_nG_merged25519_q_161,32,
    precomputed_nG_merged25519_n_161,32,
  },
  {
    precomputed_nG_merged25519_q_162,32,
    precomputed_nG_merged25519_n_162,32,
  },
  {
    precomputed_nG_merged25519_q_163,32,
    precomputed_nG_merged25519_n_163,32,
  },
  {
    precomputed_nG_merged25519_q_164,32,
    precomputed_nG_merged25519_n_164,32,
  },
  {
    precomputed_nG_merged25519_q_165,32,
    precomputed_nG_merged25519_n_165,32,
  },
  {
    precomputed_nG_merged25519_q_166,32,
    precomputed_nG_merged25519_n_166,32,
  },
  {
    precomputed_nG_merged25519_q_167,32,
    precomputed_nG_merged25519_n_167,32,
  },
  {
    precomputed_nG_merged25519_q_168,32,
    precomputed_nG_merged25519_n_168,32,
  },
  {
    precomputed_nG_merged25519_q_169,32,
    precomputed_nG_merged25519_n_169,32,
  },
  {
    precomputed_nG_merged25519_q_170,32,
    precomputed_nG_merged25519_n_170,32,
  },
  {
    precomputed_nG_merged25519_q_171,32,
    precomputed_nG_merged25519_n_171,32,
  },
  {
    precomputed_nG_merged25519_q_172,32,
    precomputed_nG_merged25519_n_172,32,
  },
  {
    precomputed_nG_merged25519_q_173,32,
    precomputed_nG_merged25519_n_173,32,
  },
  {
    precomputed_nG_merged25519_q_174,32,
    precomputed_nG_merged25519_n_174,32,
  },
  {
    precomputed_nG_merged25519_q_175,32,
    precomputed_nG_merged25519_n_175,32,
  },
  {
    precomputed_nG_merged25519_q_176,32,
    precomputed_nG_merged25519_n_176,32,
  },
  {
    precomputed_nG_merged25519_q_177,32,
    precomputed_nG_merged25519_n_177,32,
  },
  {
    precomputed_nG_merged25519_q_178,32,
    precomputed_nG_merged25519_n_178,32,
  },
  {
    precomputed_nG_merged25519_q_179,32,
    precomputed_nG_merged25519_n_179,32,
  },
  {
    precomputed_nG_merged25519_q_180,32,
    precomputed_nG_merged25519_n_180,32,
  },
  {
    precomputed_nG_merged25519_q_181,32,
    precomputed_nG_merged25519_n_181,32,
  },
  {
    precomputed_nG_merged25519_q_182,32,
    precomputed_nG_merged25519_n_182,32,
  },
  {
    precomputed_nG_merged25519_q_183,32,
    precomputed_nG_merged25519_n_183,32,
  },
  {
    precomputed_nG_merged25519_q_184,32,
    precomputed_nG_merged25519_n_184,32,
  },
  {
    precomputed_nG_merged25519_q_185,32,
    precomputed_nG_merged25519_n_185,32,
  },
  {
    precomputed_nG_merged25519_q_186,32,
    precomputed_nG_merged25519_n_186,32,
  },
  {
    precomputed_nG_merged25519_q_187,32,
    precomputed_nG_merged25519_n_187,32,
  },
  {
    precomputed_nG_merged25519_q_188,32,
    precomputed_nG_merged25519_n_188,32,
  },
  {
    precomputed_nG_merged25519_q_189,32,
    precomputed_nG_merged25519_n_189,32,
  },
  {
    precomputed_nG_merged25519_q_190,32,
    precomputed_nG_merged25519_n_190,32,
  },
  {
    precomputed_nG_merged25519_q_191,32,
    precomputed_nG_merged25519_n_191,32,
  },
  {
    precomputed_nG_merged25519_q_192,32,
    precomputed_nG_merged25519_n_192,32,
  },
  {
    precomputed_nG_merged25519_q_193,32,
    precomputed_nG_merged25519_n_193,32,
  },
  {
    precomputed_nG_merged25519_q_194,32,
    precomputed_nG_merged25519_n_194,32,
  },
  {
    precomputed_nG_merged25519_q_195,32,
    precomputed_nG_merged25519_n_195,32,
  },
  {
    precomputed_nG_merged25519_q_196,32,
    precomputed_nG_merged25519_n_196,32,
  },
  {
    precomputed_nG_merged25519_q_197,32,
    precomputed_nG_merged25519_n_197,32,
  },
  {
    precomputed_nG_merged25519_q_198,32,
    precomputed_nG_merged25519_n_198,32,
  },
  {
    precomputed_nG_merged25519_q_199,32,
    precomputed_nG_merged25519_n_199,32,
  },
  {
    precomputed_nG_merged25519_q_200,32,
    precomputed_nG_merged25519_n_200,32,
  },
  {
    precomputed_nG_merged25519_q_201,32,
    precomputed_nG_merged25519_n_201,32,
  },
  {
    precomputed_nG_merged25519_q_202,32,
    precomputed_nG_merged25519_n_202,32,
  },
  {
    precomputed_nG_merged25519_q_203,32,
    precomputed_nG_merged25519_n_203,32,
  },
} ;

static void test_nG_merged25519_impl(long long impl)
{
  unsigned char *q = test_nG_merged25519_q;
  unsigned char *n = test_nG_merged25519_n;
  unsigned char *q2 = test_nG_merged25519_q2;
  unsigned char *n2 = test_nG_merged25519_n2;
  long long qlen = crypto_nG_POINTBYTES;
  long long nlen = crypto_nG_SCALARBYTES;

  if (targeti && strcmp(targeti,lib25519_dispatch_nG_merged25519_implementation(impl))) return;
  if (impl >= 0) {
    crypto_nG = lib25519_dispatch_nG_merged25519(impl);
    printf("nG_merged25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nG_merged25519_implementation(impl),lib25519_dispatch_nG_merged25519_compiler(impl));
  } else {
    crypto_nG = lib25519_nG_merged25519;
    printf("nG_merged25519 selected implementation %s compiler %s\n",lib25519_nG_merged25519_implementation(),lib25519_nG_merged25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      crypto_nG(q,n);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nG");
      input_compare(n2,n,nlen,"crypto_nG");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      crypto_nG(q2,n2);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nG is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      crypto_nG(n2,n2);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nG does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
    }
    checksum_expected(nG_merged25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nG_merged25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_nG_merged25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nG_merged25519[precomp].nsize);
    memcpy(n,precomputed_nG_merged25519[precomp].n,precomputed_nG_merged25519[precomp].nsize);
    memcpy(n2,precomputed_nG_merged25519[precomp].n,precomputed_nG_merged25519[precomp].nsize);
    crypto_nG(q,n);
    if (memcmp(q,precomputed_nG_merged25519[precomp].q,precomputed_nG_merged25519[precomp].qsize)) {
      fail("failure: crypto_nG fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nG_merged25519[precomp].qsize;++pos) printf("%02x",precomputed_nG_merged25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nG_merged25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nG_merged25519[precomp].qsize,"crypto_nG");
    input_compare(n2,n,precomputed_nG_merged25519[precomp].nsize,"crypto_nG");
  }
}

static void test_nG_merged25519(void)
{
  if (targeto && strcmp(targeto,"nG")) return;
  if (targetp && strcmp(targetp,"merged25519")) return;
  test_nG_merged25519_q = alignedcalloc(crypto_nG_POINTBYTES);
  test_nG_merged25519_n = alignedcalloc(crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);
  test_nG_merged25519_q2 = alignedcalloc(crypto_nG_POINTBYTES);
  test_nG_merged25519_n2 = alignedcalloc(crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    printf("nG_merged25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nG_merged25519();++impl)
      forked(test_nG_merged25519_impl,impl);
    ++test_nG_merged25519_q;
    ++test_nG_merged25519_n;
    ++test_nG_merged25519_q2;
    ++test_nG_merged25519_n2;
  }
}
#undef crypto_nG_SCALARBYTES
#undef crypto_nG_POINTBYTES

static const char *nG_montgomery25519_checksums[] = {
  "5c8a5d8b32e3d26b33071779ce9191095d7bd4ab3bb6a40b68976e41a98cfc3b",
  "2becc8cd065820fcf82e53a03c5b5235582480fc11d072f2bd15153aebd4e057",
} ;

static void (*crypto_nG)(unsigned char *,const unsigned char *);
#define crypto_nG_SCALARBYTES lib25519_nG_montgomery25519_SCALARBYTES
#define crypto_nG_POINTBYTES lib25519_nG_montgomery25519_POINTBYTES

static unsigned char *test_nG_montgomery25519_q;
static unsigned char *test_nG_montgomery25519_n;
static unsigned char *test_nG_montgomery25519_q2;
static unsigned char *test_nG_montgomery25519_n2;

#define precomputed_nG_montgomery25519_NUM 204

static const unsigned char precomputed_nG_montgomery25519_q_0[] = {44,101,73,224,192,197,182,193,198,236,100,246,66,1,61,81,166,127,157,110,54,66,251,198,92,55,173,36,249,59,233,126};
static const unsigned char precomputed_nG_montgomery25519_n_0[] = {248,181,1,40,168,159,146,159,7,139,148,246,114,42,35,194,81,211,62,44,126,145,190,89,62,58,107,20,218,93,118,95};
static const unsigned char precomputed_nG_montgomery25519_q_1[] = {22,233,216,103,29,176,73,7,154,58,234,156,164,185,58,67,63,98,25,70,163,27,197,131,27,124,136,194,50,127,27,91};
static const unsigned char precomputed_nG_montgomery25519_n_1[] = {14,232,69,146,96,32,217,118,165,148,112,63,5,13,120,17,228,235,88,112,98,223,9,159,154,56,205,253,30,183,254,241};
static const unsigned char precomputed_nG_montgomery25519_q_2[] = {11,119,200,123,188,243,40,196,247,76,172,56,18,200,54,108,199,218,66,158,249,60,59,253,46,128,27,35,33,98,140,121};
static const unsigned char precomputed_nG_montgomery25519_n_2[] = {11,163,86,36,137,113,113,229,202,180,1,160,250,8,230,243,132,17,69,51,144,151,87,27,156,223,140,110,112,87,53,140};
static const unsigned char precomputed_nG_montgomery25519_q_3[] = {232,150,156,228,44,205,185,197,125,253,134,159,89,140,116,166,52,204,93,160,165,235,252,106,74,24,135,3,220,188,153,18};
static const unsigned char precomputed_nG_montgomery25519_n_3[] = {16,216,149,3,205,241,168,94,207,104,27,160,54,112,73,99,134,123,175,246,124,247,59,182,146,31,82,203,200,18,92,130};
static const unsigned char precomputed_nG_montgomery25519_q_4[] = {251,17,37,208,222,241,58,226,178,13,172,0,33,142,148,168,121,36,132,171,245,230,144,7,155,170,104,45,90,96,96,72};
static const unsigned char precomputed_nG_montgomery25519_n_4[] = {148,4,13,240,188,103,159,76,215,255,194,136,69,190,104,224,217,76,164,0,233,176,114,160,88,113,113,9,79,141,177,167};
static const unsigned char precomputed_nG_montgomery25519_q_5[] = {42,58,16,107,223,183,177,33,181,110,224,163,48,54,79,177,87,245,128,181,167,50,136,8,250,202,95,210,148,233,40,116};
static const unsigned char precomputed_nG_montgomery25519_n_5[] = {18,57,230,52,26,1,62,159,250,37,100,205,24,38,31,225,20,8,251,54,163,185,28,238,130,157,199,35,237,92,244,183};
static const unsigned char precomputed_nG_montgomery25519_q_6[] = {97,239,71,43,224,161,158,90,19,122,241,102,97,255,166,42,96,161,158,9,11,221,175,222,163,228,209,79,49,242,182,119};
static const unsigned char precomputed_nG_montgomery25519_n_6[] = {31,148,53,108,30,105,71,99,143,68,89,101,48,139,33,183,231,45,1,138,84,28,226,175,40,187,63,17,182,147,181,111};
static const unsigned char precomputed_nG_montgomery25519_q_7[] = {154,114,106,210,32,53,205,118,189,69,147,82,82,194,188,134,3,234,129,186,111,226,201,222,157,165,205,54,110,139,120,83};
static const unsigned char precomputed_nG_montgomery25519_n_7[] = {88,108,123,69,26,196,138,148,157,192,0,60,139,64,0,18,50,253,240,196,178,158,190,242,213,127,171,27,171,100,126,98};
static const unsigned char precomputed_nG_montgomery25519_q_8[] = {255,124,30,66,230,132,210,253,61,154,13,174,253,37,123,239,111,36,77,63,2,122,199,142,34,154,140,2,60,18,193,38};
static const unsigned char precomputed_nG_montgomery25519_n_8[] = {199,203,24,166,64,157,248,207,126,145,226,70,226,46,83,164,212,97,249,87,34,190,68,80,167,63,215,145,26,153,223,72};
static const unsigned char precomputed_nG_montgomery25519_q_9[] = {233,203,176,130,48,239,30,31,73,239,234,82,72,96,143,113,37,101,28,17,113,90,196,238,212,68,64,137,165,236,73,32};
static const unsigned char precomputed_nG_montgomery25519_n_9[] = {12,178,98,251,119,168,170,140,182,33,62,143,118,199,236,245,180,189,123,225,65,6,230,228,227,92,55,211,134,132,198,38};
static const unsigned char precomputed_nG_montgomery25519_q_10[] = {235,43,183,250,73,96,207,60,226,212,213,174,72,40,62,49,32,238,19,237,100,203,157,20,16,80,17,188,169,199,87,69};
static const unsigned char precomputed_nG_montgomery25519_n_10[] = {202,122,215,32,241,88,182,107,239,199,244,200,35,37,123,181,26,150,59,21,180,73,135,215,184,42,187,112,115,13,235,84};
static const unsigned char precomputed_nG_montgomery25519_q_11[] = {201,14,27,106,204,26,136,248,200,36,109,120,34,56,120,195,103,145,198,66,151,130,68,56,51,120,64,116,101,166,148,34};
static const unsigned char precomputed_nG_montgomery25519_n_11[] = {119,199,1,5,187,141,221,57,160,118,141,51,84,183,7,115,31,183,209,1,224,243,85,240,163,250,207,186,125,153,24,121};
static const unsigned char precomputed_nG_montgomery25519_q_12[] = {18,17,188,202,61,40,175,192,37,198,66,1,209,60,129,254,194,76,254,181,30,207,172,187,242,254,97,118,71,131,64,121};
static const unsigned char precomputed_nG_montgomery25519_n_12[] = {147,181,139,164,118,11,157,253,138,152,243,158,200,155,204,226,14,234,142,113,42,233,232,152,113,172,69,205,115,162,116,65};
static const unsigned char precomputed_nG_montgomery25519_q_13[] = {37,224,252,164,235,13,240,252,189,252,60,188,200,216,143,15,252,125,135,25,180,38,248,255,215,211,197,207,205,250,234,6};
static const unsigned char precomputed_nG_montgomery25519_n_13[] = {151,201,136,193,3,163,232,197,250,69,54,50,146,250,192,80,116,116,69,85,81,243,34,135,215,190,6,34,187,205,146,211};
static const unsigned char precomputed_nG_montgomery25519_q_14[] = {109,65,57,126,39,59,194,55,244,212,93,233,113,222,214,19,240,116,36,152,0,118,101,227,49,251,93,111,143,23,201,29};
static const unsigned char precomputed_nG_montgomery25519_n_14[] = {53,140,196,22,171,6,214,196,80,29,248,191,58,99,92,7,43,116,208,20,74,221,103,42,77,122,30,52,191,213,24,111};
static const unsigned char precomputed_nG_montgomery25519_q_15[] = {140,101,22,137,6,44,213,100,234,203,208,180,139,115,83,102,43,195,100,183,105,9,246,30,25,84,161,100,50,117,182,83};
static const unsigned char precomputed_nG_montgomery25519_n_15[] = {152,21,165,122,147,183,199,178,223,227,148,248,12,192,148,244,198,101,20,221,20,40,81,179,137,166,133,247,158,97,16,186};
static const unsigned char precomputed_nG_montgomery25519_q_16[] = {203,46,169,217,216,136,69,179,134,217,182,110,81,152,110,71,18,222,44,153,11,72,221,54,218,73,175,50,62,227,189,105};
static const unsigned char precomputed_nG_montgomery25519_n_16[] = {199,126,47,157,213,119,132,90,244,150,154,153,154,154,175,20,126,75,236,6,157,105,203,242,103,149,187,238,74,100,29,95};
static const unsigned char precomputed_nG_montgomery25519_q_17[] = {128,93,5,190,107,222,19,204,217,12,113,236,162,176,166,25,251,40,252,164,171,43,90,44,6,77,20,164,154,63,158,7};
static const unsigned char precomputed_nG_montgomery25519_n_17[] = {147,41,221,16,120,22,132,154,184,105,117,139,112,209,48,48,102,83,82,213,18,58,173,96,158,249,223,174,110,72,249,153};
static const unsigned char precomputed_nG_montgomery25519_q_18[] = {9,218,176,210,206,47,135,144,154,202,245,156,198,134,209,172,52,35,134,21,218,42,99,135,81,134,110,255,138,126,248,34};
static const unsigned char precomputed_nG_montgomery25519_n_18[] = {112,148,171,50,138,202,67,156,140,89,111,230,219,30,184,200,227,20,71,82,155,103,17,59,134,168,24,154,48,55,32,71};
static const unsigned char precomputed_nG_montgomery25519_q_19[] = {8,3,202,49,25,245,106,49,116,110,42,158,86,222,129,254,168,26,255,3,247,11,249,170,190,211,250,155,24,150,192,41};
static const unsigned char precomputed_nG_montgomery25519_n_19[] = {199,183,70,67,59,68,228,176,208,10,125,52,255,142,161,107,28,174,244,115,102,51,114,77,64,190,79,234,136,47,175,91};
static const unsigned char precomputed_nG_montgomery25519_q_20[] = {228,227,141,214,206,35,141,24,202,113,127,15,243,143,213,65,42,116,208,171,234,179,152,66,10,169,171,57,71,192,159,85};
static const unsigned char precomputed_nG_montgomery25519_n_20[] = {233,159,249,86,219,139,158,70,42,195,176,76,198,41,132,143,44,224,5,108,23,14,93,69,204,227,164,90,104,14,60,40};
static const unsigned char precomputed_nG_montgomery25519_q_21[] = {207,123,193,30,219,178,11,72,105,117,4,65,4,162,57,212,54,199,105,198,19,197,31,67,143,39,113,74,202,173,159,91};
static const unsigned char precomputed_nG_montgomery25519_n_21[] = {190,72,88,96,176,73,76,47,132,132,175,86,38,14,206,53,218,244,156,179,108,147,149,29,169,28,214,15,234,26,85,53};
static const unsigned char precomputed_nG_montgomery25519_q_22[] = {126,135,38,197,155,193,166,187,158,210,160,0,248,215,35,59,136,120,38,73,173,186,23,18,95,9,248,187,43,13,199,101};
static const unsigned char precomputed_nG_montgomery25519_n_22[] = {61,117,112,156,219,187,229,35,238,210,246,106,48,168,101,69,220,180,114,154,115,7,171,250,27,121,92,134,165,83,99,112};
static const unsigned char precomputed_nG_montgomery25519_q_23[] = {90,163,30,112,14,2,97,154,84,67,176,71,190,143,20,7,240,216,14,241,210,1,250,181,129,147,94,225,35,32,40,76};
static const unsigned char precomputed_nG_montgomery25519_n_23[] = {250,220,191,52,104,105,84,62,242,254,8,18,46,88,247,248,39,31,253,69,209,26,127,225,178,41,120,249,238,52,73,53};
static const unsigned char precomputed_nG_montgomery25519_q_24[] = {43,176,209,174,33,167,159,219,239,213,211,254,235,136,64,88,102,86,126,197,24,230,200,108,26,105,230,132,70,203,15,60};
static const unsigned char precomputed_nG_montgomery25519_n_24[] = {165,236,60,105,227,60,108,62,233,194,213,235,121,33,24,69,113,87,55,189,250,66,55,250,182,214,129,41,251,136,2,211};
static const unsigned char precomputed_nG_montgomery25519_q_25[] = {18,108,13,98,125,12,35,117,78,14,173,144,130,233,220,103,61,48,61,138,173,73,78,230,43,146,200,198,202,68,166,114};
static const unsigned char precomputed_nG_montgomery25519_n_25[] = {183,127,46,22,41,41,11,240,249,213,246,134,2,67,153,129,251,42,136,14,216,249,183,120,53,251,1,106,115,229,245,147};
static const unsigned char precomputed_nG_montgomery25519_q_26[] = {36,32,32,180,194,114,27,225,13,172,80,245,211,245,17,217,34,50,62,79,248,217,44,43,7,129,4,138,24,80,143,79};
static const unsigned char precomputed_nG_montgomery25519_n_26[] = {144,246,246,13,14,80,136,47,137,223,221,221,172,249,61,118,37,166,102,74,111,169,38,132,56,10,247,64,253,214,61,241};
static const unsigned char precomputed_nG_montgomery25519_q_27[] = {14,21,190,58,193,178,32,136,216,132,1,159,253,136,204,25,198,161,209,166,24,212,123,57,204,106,194,185,61,102,133,114};
static const unsigned char precomputed_nG_montgomery25519_n_27[] = {185,57,126,93,32,245,59,244,228,128,212,243,96,46,242,13,13,75,2,167,111,120,117,105,47,12,230,96,5,40,73,184};
static const unsigned char precomputed_nG_montgomery25519_q_28[] = {213,51,228,40,129,146,130,248,131,62,14,178,172,217,20,149,191,212,249,72,1,34,156,61,74,34,226,105,17,84,209,80};
static const unsigned char precomputed_nG_montgomery25519_n_28[] = {109,84,200,146,153,129,235,230,7,79,177,144,214,106,177,23,5,90,63,28,203,159,12,93,87,217,61,244,52,63,225,61};
static const unsigned char precomputed_nG_montgomery25519_q_29[] = {129,167,201,196,132,169,163,1,17,105,68,159,113,135,169,108,40,212,23,159,143,238,70,113,27,52,199,197,95,146,85,126};
static const unsigned char precomputed_nG_montgomery25519_n_29[] = {228,162,222,194,144,84,3,9,115,119,212,85,233,217,59,199,57,157,40,142,48,6,250,102,92,195,127,128,27,22,158,71};
static const unsigned char precomputed_nG_montgomery25519_q_30[] = {120,103,152,49,82,245,180,210,18,103,251,55,45,145,67,83,21,117,18,175,181,22,48,61,206,21,154,250,12,134,157,23};
static const unsigned char precomputed_nG_montgomery25519_n_30[] = {171,218,223,232,27,15,193,203,132,118,247,251,155,117,124,7,128,103,192,93,64,34,74,143,66,151,138,176,6,252,218,205};
static const unsigned char precomputed_nG_montgomery25519_q_31[] = {127,149,123,121,135,208,71,131,79,205,255,68,95,48,168,111,64,113,226,65,209,97,166,86,123,14,198,194,84,249,147,57};
static const unsigned char precomputed_nG_montgomery25519_n_31[] = {73,212,56,83,87,96,45,59,56,150,101,42,101,118,4,94,69,135,31,96,60,74,155,222,137,187,207,211,110,129,54,134};
static const unsigned char precomputed_nG_montgomery25519_q_32[] = {137,150,86,87,214,209,137,142,54,23,127,97,186,99,246,136,84,195,89,22,226,112,3,222,181,48,26,113,72,46,18,68};
static const unsigned char precomputed_nG_montgomery25519_n_32[] = {128,86,9,240,10,150,186,54,196,60,206,41,190,111,6,15,104,70,250,151,198,189,157,227,13,100,184,190,70,252,108,106};
static const unsigned char precomputed_nG_montgomery25519_q_33[] = {120,108,163,209,215,42,47,22,132,165,178,217,23,235,221,94,11,144,55,102,118,56,235,203,26,31,235,91,2,233,9,57};
static const unsigned char precomputed_nG_montgomery25519_n_33[] = {143,68,191,130,34,54,10,179,78,122,92,103,61,194,242,182,56,117,173,172,239,46,26,254,221,174,44,106,77,163,109,150};
static const unsigned char precomputed_nG_montgomery25519_q_34[] = {51,39,77,39,12,64,251,237,75,31,86,190,173,24,121,116,204,235,21,66,28,17,160,215,115,32,87,235,99,0,70,73};
static const unsigned char precomputed_nG_montgomery25519_n_34[] = {6,48,68,18,62,116,229,178,180,39,94,200,111,75,220,203,76,199,207,219,113,118,148,175,32,32,107,146,64,12,228,65};
static const unsigned char precomputed_nG_montgomery25519_q_35[] = {156,178,123,100,84,35,125,66,241,126,52,112,26,121,95,96,46,13,32,86,1,209,114,182,78,32,135,74,149,53,56,89};
static const unsigned char precomputed_nG_montgomery25519_n_35[] = {54,5,81,2,149,104,165,112,156,85,53,35,105,152,8,215,27,169,227,200,119,128,41,178,83,124,82,55,80,34,124,147};
static const unsigned char precomputed_nG_montgomery25519_q_36[] = {64,79,89,242,159,172,86,45,6,141,239,99,98,223,140,102,111,250,187,174,139,78,208,60,128,208,255,239,40,124,197,100};
static const unsigned char precomputed_nG_montgomery25519_n_36[] = {132,195,224,61,35,5,159,144,25,69,4,4,244,116,232,252,18,91,221,80,99,247,100,169,124,166,202,86,74,253,217,77};
static const unsigned char precomputed_nG_montgomery25519_q_37[] = {83,156,177,241,3,80,35,145,181,118,166,248,17,239,23,170,31,152,148,199,160,196,98,107,210,33,239,125,129,173,11,112};
static const unsigned char precomputed_nG_montgomery25519_n_37[] = {80,56,243,242,188,63,207,83,52,5,144,165,76,248,253,168,159,178,148,61,10,233,168,227,9,236,253,57,87,93,157,133};
static const unsigned char precomputed_nG_montgomery25519_q_38[] = {243,184,108,115,167,61,66,115,189,103,208,101,151,125,150,73,235,160,215,7,167,34,113,116,91,10,18,21,241,157,169,25};
static const unsigned char precomputed_nG_montgomery25519_n_38[] = {231,188,33,49,132,250,243,148,132,244,118,152,49,163,206,63,32,69,96,52,196,79,0,159,62,60,118,108,183,151,228,232};
static const unsigned char precomputed_nG_montgomery25519_q_39[] = {219,184,178,42,76,242,99,76,211,155,123,47,162,5,41,170,253,180,125,151,68,141,133,133,149,250,27,187,31,238,212,31};
static const unsigned char precomputed_nG_montgomery25519_n_39[] = {43,158,30,127,10,160,120,118,158,170,140,134,64,33,132,156,29,44,71,180,174,52,16,184,8,204,93,155,16,209,127,97};
static const unsigned char precomputed_nG_montgomery25519_q_40[] = {24,77,226,254,82,120,244,151,250,191,142,87,196,80,117,173,128,35,37,190,63,246,152,209,55,109,125,174,176,123,195,42};
static const unsigned char precomputed_nG_montgomery25519_n_40[] = {150,131,157,218,200,100,94,164,145,203,20,105,222,208,169,27,13,186,35,245,28,144,248,193,82,95,235,172,180,170,118,124};
static const unsigned char precomputed_nG_montgomery25519_q_41[] = {111,125,87,59,189,141,150,157,177,154,49,224,192,185,125,47,118,225,94,50,164,225,47,31,26,59,3,110,175,121,255,63};
static const unsigned char precomputed_nG_montgomery25519_n_41[] = {193,246,237,0,40,33,29,56,183,153,174,89,123,144,18,83,96,136,49,82,239,132,102,241,0,53,52,62,17,45,121,18};
static const unsigned char precomputed_nG_montgomery25519_q_42[] = {74,161,209,191,143,72,135,114,36,221,77,51,77,61,210,243,82,42,233,127,149,62,173,6,142,107,76,119,122,52,0,24};
static const unsigned char precomputed_nG_montgomery25519_n_42[] = {70,3,65,0,114,24,25,165,155,42,222,112,212,37,3,7,163,20,13,4,9,101,15,124,148,110,72,37,49,216,152,0};
static const unsigned char precomputed_nG_montgomery25519_q_43[] = {240,17,65,128,222,188,51,179,44,254,96,233,152,221,248,113,109,126,143,3,165,24,49,239,182,203,195,77,153,21,26,16};
static const unsigned char precomputed_nG_montgomery25519_n_43[] = {33,194,117,109,66,207,181,250,92,38,54,162,70,144,28,242,118,168,64,183,98,239,199,235,154,113,222,57,0,186,194,49};
static const unsigned char precomputed_nG_montgomery25519_q_44[] = {70,60,90,37,152,210,72,119,75,248,250,200,153,217,188,179,196,241,189,227,97,221,11,237,158,126,217,113,77,144,83,35};
static const unsigned char precomputed_nG_montgomery25519_n_44[] = {193,201,139,241,210,71,234,92,126,85,186,0,4,145,4,241,77,35,164,79,95,114,230,112,21,41,180,230,215,116,73,184};
static const unsigned char precomputed_nG_montgomery25519_q_45[] = {129,118,6,79,108,115,231,206,173,24,242,100,63,20,27,107,141,232,187,210,82,114,175,42,14,76,72,103,186,85,27,46};
static const unsigned char precomputed_nG_montgomery25519_n_45[] = {150,139,28,166,172,205,159,1,23,222,96,89,102,139,25,175,183,101,239,183,206,32,33,192,41,22,223,107,143,73,160,50};
static const unsigned char precomputed_nG_montgomery25519_q_46[] = {219,61,28,233,38,51,65,2,96,178,192,54,95,214,207,115,46,121,124,181,251,20,214,205,199,27,84,8,85,19,48,103};
static const unsigned char precomputed_nG_montgomery25519_n_46[] = {251,133,84,194,4,222,184,37,45,25,80,61,85,223,22,91,124,40,235,196,203,193,31,137,38,211,231,154,76,104,73,200};
static const unsigned char precomputed_nG_montgomery25519_q_47[] = {165,191,33,172,185,254,208,67,197,9,199,247,156,53,228,176,95,45,236,46,250,120,42,230,68,117,25,236,2,161,233,38};
static const unsigned char precomputed_nG_montgomery25519_n_47[] = {131,86,213,72,251,92,146,144,158,137,245,228,136,104,186,182,226,128,158,192,62,202,69,189,225,43,214,117,51,26,31,51};
static const unsigned char precomputed_nG_montgomery25519_q_48[] = {2,194,163,242,105,204,65,204,69,54,166,138,0,160,39,161,68,206,132,81,40,122,143,120,238,196,216,243,243,86,9,3};
static const unsigned char precomputed_nG_montgomery25519_n_48[] = {60,42,201,227,21,150,42,186,133,169,250,72,97,236,91,235,123,183,31,173,64,51,96,236,221,228,0,223,179,62,23,89};
static const unsigned char precomputed_nG_montgomery25519_q_49[] = {59,49,73,91,67,32,68,135,249,39,2,143,248,204,34,10,163,154,194,12,173,67,107,115,194,162,64,117,168,63,45,68};
static const unsigned char precomputed_nG_montgomery25519_n_49[] = {128,199,106,32,154,78,38,27,72,148,80,4,95,247,73,203,28,41,88,197,27,184,58,22,198,111,243,15,190,166,149,198};
static const unsigned char precomputed_nG_montgomery25519_q_50[] = {118,185,133,0,163,216,37,228,197,73,162,158,208,118,252,196,144,118,90,172,3,170,49,62,40,161,26,79,99,207,48,73};
static const unsigned char precomputed_nG_montgomery25519_n_50[] = {127,101,191,28,148,8,98,199,227,49,249,127,188,215,238,202,94,48,189,113,126,162,24,156,49,220,132,169,16,205,44,51};
static const unsigned char precomputed_nG_montgomery25519_q_51[] = {151,140,64,139,222,109,163,24,8,7,171,199,62,167,194,130,220,166,14,55,133,56,215,239,100,79,12,215,59,35,47,5};
static const unsigned char precomputed_nG_montgomery25519_n_51[] = {32,114,157,231,253,81,34,116,65,111,53,89,235,252,196,252,48,13,141,44,21,182,186,106,84,221,61,119,12,206,88,155};
static const unsigned char precomputed_nG_montgomery25519_q_52[] = {146,200,111,108,165,8,233,118,47,44,9,200,173,98,87,150,201,29,12,120,52,115,41,9,102,238,154,13,118,165,80,8};
static const unsigned char precomputed_nG_montgomery25519_n_52[] = {25,189,178,233,5,103,25,80,233,209,70,192,154,204,135,200,150,5,16,53,37,51,165,109,147,246,72,162,122,250,68,194};
static const unsigned char precomputed_nG_montgomery25519_q_53[] = {219,85,213,7,35,123,174,0,146,57,249,221,49,106,153,177,125,210,202,249,215,106,135,220,50,108,101,221,120,222,209,121};
static const unsigned char precomputed_nG_montgomery25519_n_53[] = {172,208,42,169,82,1,140,1,13,13,126,143,78,134,234,87,52,24,69,233,98,68,63,110,47,160,4,231,94,116,177,114};
static const unsigned char precomputed_nG_montgomery25519_q_54[] = {238,52,219,74,35,150,194,118,91,22,192,59,176,21,39,105,71,79,179,208,28,50,48,174,222,202,50,32,17,86,136,74};
static const unsigned char precomputed_nG_montgomery25519_n_54[] = {34,121,0,61,76,153,99,93,123,129,113,110,206,196,186,13,188,221,84,169,8,138,142,207,90,12,143,247,209,84,77,131};
static const unsigned char precomputed_nG_montgomery25519_q_55[] = {238,83,44,137,90,53,130,229,180,124,10,146,170,228,211,83,122,247,24,29,38,201,8,67,244,71,153,35,158,158,248,94};
static const unsigned char precomputed_nG_montgomery25519_n_55[] = {42,136,94,105,148,88,105,238,54,10,193,182,191,238,173,106,165,179,167,114,129,129,171,197,72,161,212,183,140,130,184,99};
static const unsigned char precomputed_nG_montgomery25519_q_56[] = {92,28,64,43,179,201,212,121,19,176,150,159,19,34,105,211,186,150,29,79,217,30,43,18,91,244,147,30,37,50,145,73};
static const unsigned char precomputed_nG_montgomery25519_n_56[] = {18,205,14,159,90,202,16,229,181,12,52,228,161,16,61,44,107,173,102,151,53,184,32,24,130,29,92,84,67,92,132,180};
static const unsigned char precomputed_nG_montgomery25519_q_57[] = {42,123,79,236,5,178,213,172,228,33,53,20,223,155,22,83,178,60,197,76,216,66,253,72,234,255,100,190,187,215,47,111};
static const unsigned char precomputed_nG_montgomery25519_n_57[] = {163,203,116,25,171,243,121,61,195,21,221,204,26,153,102,181,18,126,247,132,97,24,154,66,189,179,44,203,2,156,163,230};
static const unsigned char precomputed_nG_montgomery25519_q_58[] = {250,177,147,217,233,160,186,29,119,105,104,242,246,148,130,225,133,120,254,157,80,7,137,38,116,114,236,211,201,59,47,56};
static const unsigned char precomputed_nG_montgomery25519_n_58[] = {125,31,64,167,137,175,45,21,51,211,233,128,110,198,74,117,45,90,176,84,221,252,149,184,186,209,44,76,155,54,22,59};
static const unsigned char precomputed_nG_montgomery25519_q_59[] = {129,77,30,15,126,37,8,178,208,227,146,4,183,147,231,48,102,168,28,240,188,210,90,245,217,121,55,56,86,40,22,112};
static const unsigned char precomputed_nG_montgomery25519_n_59[] = {201,219,182,219,90,131,170,113,119,195,100,44,89,247,250,41,204,90,36,184,227,150,213,164,34,114,159,96,7,210,203,249};
static const unsigned char precomputed_nG_montgomery25519_q_60[] = {121,66,2,74,6,6,88,169,97,137,221,1,33,78,114,235,25,147,99,206,254,85,152,219,170,41,133,78,143,99,59,127};
static const unsigned char precomputed_nG_montgomery25519_n_60[] = {80,128,135,167,93,150,211,226,214,185,68,212,42,8,155,194,56,246,61,248,130,15,179,233,68,78,0,21,88,229,27,250};
static const unsigned char precomputed_nG_montgomery25519_q_61[] = {170,119,56,39,128,28,95,151,68,67,79,245,138,27,171,172,185,60,193,43,24,47,44,22,133,51,192,33,91,235,206,106};
static const unsigned char precomputed_nG_montgomery25519_n_61[] = {156,66,77,180,174,107,233,12,184,58,46,61,64,98,183,92,16,219,71,111,27,51,188,248,186,186,102,180,73,56,13,192};
static const unsigned char precomputed_nG_montgomery25519_q_62[] = {8,65,6,229,48,237,228,7,186,78,20,76,185,115,71,216,3,174,43,115,161,223,182,143,26,77,223,136,88,179,28,15};
static const unsigned char precomputed_nG_montgomery25519_n_62[] = {126,105,113,222,138,197,147,2,78,6,164,71,89,108,88,171,66,1,135,129,235,20,23,71,23,196,77,202,214,125,157,175};
static const unsigned char precomputed_nG_montgomery25519_q_63[] = {97,202,213,1,93,35,63,31,114,140,174,116,11,159,132,134,43,215,202,227,193,252,196,226,200,189,101,97,25,250,52,110};
static const unsigned char precomputed_nG_montgomery25519_n_63[] = {210,1,39,43,213,4,113,52,209,168,194,36,183,83,208,113,96,24,160,90,15,173,111,2,218,216,204,35,245,82,131,100};
static const unsigned char precomputed_nG_montgomery25519_q_64[] = {144,90,151,40,70,230,158,150,37,254,76,138,189,139,90,226,169,139,212,188,116,43,13,72,178,251,51,114,187,178,133,105};
static const unsigned char precomputed_nG_montgomery25519_n_64[] = {26,133,164,74,34,10,213,241,118,228,228,196,85,9,45,2,27,221,132,101,239,21,197,32,148,26,6,122,61,238,33,109};
static const unsigned char precomputed_nG_montgomery25519_q_65[] = {10,188,206,205,136,173,60,128,77,197,17,231,223,211,230,220,17,104,1,218,62,134,163,191,85,109,102,124,51,150,122,56};
static const unsigned char precomputed_nG_montgomery25519_n_65[] = {24,77,11,250,21,9,26,2,228,106,203,113,113,8,205,27,52,212,75,253,88,90,98,94,225,3,17,117,52,37,118,8};
static const unsigned char precomputed_nG_montgomery25519_q_66[] = {208,24,51,144,1,211,11,51,209,140,140,180,150,71,16,72,255,82,76,63,254,109,43,14,72,89,12,117,77,196,221,112};
static const unsigned char precomputed_nG_montgomery25519_n_66[] = {143,172,134,214,84,140,49,228,174,156,78,179,61,77,91,228,144,247,118,134,122,129,186,68,152,25,181,254,25,239,203,173};
static const unsigned char precomputed_nG_montgomery25519_q_67[] = {50,40,208,33,127,78,209,52,163,161,65,165,100,201,185,211,194,83,220,236,171,131,64,9,243,32,91,219,61,241,131,20};
static const unsigned char precomputed_nG_montgomery25519_n_67[] = {219,123,41,215,52,53,170,77,222,109,52,73,25,99,9,198,56,1,84,246,138,208,150,1,142,15,66,240,6,89,57,84};
static const unsigned char precomputed_nG_montgomery25519_q_68[] = {255,255,52,23,148,8,10,129,27,228,21,242,65,164,23,127,138,187,31,100,178,128,195,40,228,149,121,155,207,184,181,12};
static const unsigned char precomputed_nG_montgomery25519_n_68[] = {204,171,34,245,66,116,196,142,227,179,177,211,221,118,54,247,140,254,82,214,0,116,156,233,213,182,128,73,40,197,46,135};
static const unsigned char precomputed_nG_montgomery25519_q_69[] = {169,10,50,75,199,215,160,218,225,10,166,49,42,98,157,131,106,197,113,14,21,16,69,162,127,31,115,83,26,50,220,44};
static const unsigned char precomputed_nG_montgomery25519_n_69[] = {61,124,30,206,44,119,58,162,88,242,155,6,244,255,208,58,104,217,249,227,171,95,17,220,83,192,221,148,164,122,8,64};
static const unsigned char precomputed_nG_montgomery25519_q_70[] = {33,128,135,172,244,183,44,121,229,229,30,190,63,226,46,39,242,3,248,58,154,233,198,50,245,4,78,235,192,222,16,116};
static const unsigned char precomputed_nG_montgomery25519_n_70[] = {11,222,99,51,38,46,245,94,147,100,179,51,147,230,162,113,17,37,165,101,252,247,185,36,144,73,114,123,22,194,214,45};
static const unsigned char precomputed_nG_montgomery25519_q_71[] = {144,75,112,204,177,170,103,101,100,245,2,231,54,239,231,165,204,193,16,59,117,199,192,107,107,218,95,48,56,38,110,59};
static const unsigned char precomputed_nG_montgomery25519_n_71[] = {0,109,134,77,20,214,239,230,93,78,150,182,114,48,60,49,182,164,80,57,127,100,123,26,249,117,119,77,10,164,16,174};
static const unsigned char precomputed_nG_montgomery25519_q_72[] = {236,116,148,250,53,204,255,155,189,174,49,31,227,4,199,185,208,101,4,144,61,99,214,209,250,189,47,68,87,244,255,119};
static const unsigned char precomputed_nG_montgomery25519_n_72[] = {190,52,77,80,59,196,250,15,154,113,245,213,86,255,155,2,170,204,185,85,136,183,10,194,90,223,247,17,165,194,113,185};
static const unsigned char precomputed_nG_montgomery25519_q_73[] = {190,179,239,119,211,163,178,156,228,21,15,252,208,25,41,206,154,89,209,161,71,3,248,190,218,248,185,156,20,160,126,76};
static const unsigned char precomputed_nG_montgomery25519_n_73[] = {115,106,3,157,86,134,12,145,213,31,164,99,232,92,120,54,207,172,141,117,138,12,49,213,173,20,82,175,80,110,119,181};
static const unsigned char precomputed_nG_montgomery25519_q_74[] = {151,247,57,97,74,63,212,198,121,181,59,203,196,23,78,158,248,155,40,115,225,235,68,103,24,145,186,35,48,255,78,29};
static const unsigned char precomputed_nG_montgomery25519_n_74[] = {75,105,208,239,69,92,1,44,88,234,160,169,110,27,102,193,137,141,31,119,244,190,62,149,23,253,114,138,166,219,233,12};
static const unsigned char precomputed_nG_montgomery25519_q_75[] = {91,88,13,142,88,152,119,94,151,178,38,105,65,203,224,246,198,72,71,98,229,32,31,51,217,79,138,34,198,58,179,70};
static const unsigned char precomputed_nG_montgomery25519_n_75[] = {25,4,206,72,111,144,216,129,151,243,187,122,192,98,90,152,226,21,218,134,198,164,40,4,78,212,53,34,231,49,235,93};
static const unsigned char precomputed_nG_montgomery25519_q_76[] = {113,242,158,115,21,159,155,180,109,128,161,142,51,244,151,129,226,247,98,58,15,136,15,211,29,232,125,88,18,156,4,87};
static const unsigned char precomputed_nG_montgomery25519_n_76[] = {130,177,74,203,203,9,147,135,150,55,71,149,91,175,112,194,97,100,29,255,151,202,137,159,32,238,169,17,105,195,248,204};
static const unsigned char precomputed_nG_montgomery25519_q_77[] = {59,136,166,195,70,104,62,128,52,248,9,234,7,194,70,131,203,213,54,0,194,151,73,250,173,41,5,68,170,108,31,97};
static const unsigned char precomputed_nG_montgomery25519_n_77[] = {26,139,84,222,73,164,95,200,197,246,159,238,232,197,100,177,248,155,162,245,92,148,69,65,182,152,102,102,144,175,66,166};
static const unsigned char precomputed_nG_montgomery25519_q_78[] = {202,17,137,96,105,114,181,212,253,36,207,127,122,175,226,141,188,173,58,232,56,248,91,180,241,125,166,251,235,85,42,112};
static const unsigned char precomputed_nG_montgomery25519_n_78[] = {114,164,45,29,139,80,49,60,106,107,60,128,63,120,253,179,193,56,108,162,227,252,98,109,0,25,202,38,28,138,44,27};
static const unsigned char precomputed_nG_montgomery25519_q_79[] = {170,194,130,44,72,120,74,92,93,148,117,38,246,71,92,140,114,84,251,163,98,26,115,180,126,160,230,40,229,122,74,88};
static const unsigned char precomputed_nG_montgomery25519_n_79[] = {140,255,196,225,13,181,102,161,58,158,219,87,108,13,233,160,85,170,107,238,165,112,3,40,204,223,33,176,135,137,131,231};
static const unsigned char precomputed_nG_montgomery25519_q_80[] = {37,181,156,223,73,148,255,25,225,127,31,176,26,136,85,198,118,20,104,38,18,215,103,66,160,33,238,135,14,72,65,85};
static const unsigned char precomputed_nG_montgomery25519_n_80[] = {89,164,46,121,146,172,87,140,34,168,132,6,230,49,237,159,96,92,236,101,47,59,64,29,206,188,61,248,197,236,69,167};
static const unsigned char precomputed_nG_montgomery25519_q_81[] = {31,131,56,113,246,52,240,82,43,199,215,249,193,40,111,135,237,109,39,35,12,11,42,67,129,73,56,188,52,215,185,88};
static const unsigned char precomputed_nG_montgomery25519_n_81[] = {15,224,104,161,59,86,211,32,209,58,171,165,234,218,86,47,130,95,28,62,155,193,166,66,168,42,126,13,43,240,89,217};
static const unsigned char precomputed_nG_montgomery25519_q_82[] = {169,156,99,85,216,243,253,94,165,4,157,157,50,105,112,162,106,23,170,55,67,80,69,166,131,249,157,9,223,46,95,107};
static const unsigned char precomputed_nG_montgomery25519_n_82[] = {91,21,41,161,17,32,132,81,220,123,110,142,13,121,29,181,216,173,254,249,123,99,54,191,199,98,8,201,237,129,121,229};
static const unsigned char precomputed_nG_montgomery25519_q_83[] = {70,37,114,73,84,70,104,61,216,163,160,43,161,16,125,139,33,44,118,108,80,0,40,14,175,183,38,130,96,78,152,39};
static const unsigned char precomputed_nG_montgomery25519_n_83[] = {119,175,107,233,214,49,15,33,34,240,165,131,124,172,88,165,151,21,231,192,33,212,143,125,164,32,251,55,215,88,94,173};
static const unsigned char precomputed_nG_montgomery25519_q_84[] = {169,247,83,137,121,24,61,102,195,157,195,159,35,145,47,183,46,246,87,52,6,96,168,129,208,74,198,116,5,100,41,21};
static const unsigned char precomputed_nG_montgomery25519_n_84[] = {45,185,247,101,62,178,115,117,40,137,19,3,52,214,247,56,98,107,124,152,151,34,77,254,14,218,87,71,38,70,109,201};
static const unsigned char precomputed_nG_montgomery25519_q_85[] = {244,201,218,228,24,195,67,76,89,84,36,108,125,251,247,27,12,181,242,88,132,116,255,121,142,33,45,179,14,63,74,45};
static const unsigned char precomputed_nG_montgomery25519_n_85[] = {212,148,110,55,200,16,191,27,144,170,216,245,122,143,77,52,2,173,111,97,150,226,50,250,255,202,251,217,158,10,214,176};
static const unsigned char precomputed_nG_montgomery25519_q_86[] = {235,42,62,230,239,101,137,17,210,137,216,226,83,83,199,183,46,85,55,18,144,218,212,187,11,229,21,108,58,2,154,16};
static const unsigned char precomputed_nG_montgomery25519_n_86[] = {83,109,4,217,251,38,255,79,150,202,155,27,23,235,50,83,71,46,95,204,190,1,133,105,176,96,36,185,100,100,219,160};
static const unsigned char precomputed_nG_montgomery25519_q_87[] = {115,196,14,7,223,5,34,5,145,161,211,231,159,143,233,118,19,24,78,249,104,215,51,54,88,168,226,120,163,227,155,38};
static const unsigned char precomputed_nG_montgomery25519_n_87[] = {220,73,255,236,98,106,71,217,120,72,104,95,145,59,95,228,172,211,130,57,153,25,136,142,244,43,208,201,7,59,127,82};
static const unsigned char precomputed_nG_montgomery25519_q_88[] = {115,253,197,120,56,153,69,26,253,71,74,213,1,23,182,13,27,7,160,241,108,64,86,196,241,157,106,63,59,102,83,70};
static const unsigned char precomputed_nG_montgomery25519_n_88[] = {101,45,94,226,67,86,209,9,52,17,7,240,188,142,33,206,171,161,24,172,81,96,131,173,95,1,190,230,66,32,127,37};
static const unsigned char precomputed_nG_montgomery25519_q_89[] = {166,74,198,146,147,49,106,142,62,179,216,242,183,55,52,108,245,246,139,38,110,64,8,26,208,107,9,188,81,47,146,68};
static const unsigned char precomputed_nG_montgomery25519_n_89[] = {139,29,203,36,46,99,179,5,84,125,7,126,231,205,84,116,96,255,175,78,138,28,127,170,191,60,163,92,81,71,35,141};
static const unsigned char precomputed_nG_montgomery25519_q_90[] = {56,254,54,251,73,9,106,208,32,93,47,47,184,0,187,3,250,206,159,119,108,28,207,205,6,107,79,126,117,212,229,104};
static const unsigned char precomputed_nG_montgomery25519_n_90[] = {218,129,65,22,37,94,131,101,35,110,15,119,83,245,240,48,244,186,36,142,53,245,35,180,236,233,183,22,106,235,36,246};
static const unsigned char precomputed_nG_montgomery25519_q_91[] = {42,113,184,14,22,84,226,141,134,22,150,26,253,241,96,135,90,28,222,1,178,62,150,181,184,105,88,129,174,162,148,31};
static const unsigned char precomputed_nG_montgomery25519_n_91[] = {134,239,139,12,40,148,217,177,8,124,217,162,184,125,47,135,143,189,125,245,99,46,131,92,130,250,53,108,244,194,45,133};
static const unsigned char precomputed_nG_montgomery25519_q_92[] = {99,65,125,140,163,100,187,220,51,93,151,14,223,124,138,182,211,85,220,102,72,111,151,161,197,39,207,150,74,161,195,72};
static const unsigned char precomputed_nG_montgomery25519_n_92[] = {230,3,148,40,241,93,220,142,10,240,184,111,118,170,205,217,252,224,208,159,65,35,156,179,246,174,57,32,65,59,60,236};
static const unsigned char precomputed_nG_montgomery25519_q_93[] = {248,127,161,232,101,239,115,61,149,169,29,53,123,150,212,49,199,212,35,26,112,56,50,56,38,192,228,150,254,103,189,37};
static const unsigned char precomputed_nG_montgomery25519_n_93[] = {123,179,56,107,13,69,146,119,8,144,192,54,27,20,55,8,83,79,44,187,149,68,160,184,173,31,244,171,70,41,131,106};
static const unsigned char precomputed_nG_montgomery25519_q_94[] = {65,117,211,12,216,225,143,146,33,92,96,43,220,234,33,87,126,58,103,77,161,160,102,185,241,215,210,159,17,71,11,5};
static const unsigned char precomputed_nG_montgomery25519_n_94[] = {134,128,185,138,206,221,239,252,160,115,159,34,206,174,143,34,93,127,60,193,12,198,66,6,163,192,30,205,168,82,170,178};
static const unsigned char precomputed_nG_montgomery25519_q_95[] = {221,57,1,167,72,124,145,106,61,123,89,250,26,224,11,219,121,16,207,132,86,104,47,8,29,126,69,51,110,83,43,27};
static const unsigned char precomputed_nG_montgomery25519_n_95[] = {139,0,60,75,217,43,90,39,138,78,41,105,11,51,18,195,181,67,4,2,160,54,244,203,125,170,229,99,68,44,246,50};
static const unsigned char precomputed_nG_montgomery25519_q_96[] = {136,160,227,119,24,213,77,220,29,148,198,247,252,173,61,88,71,207,43,69,129,84,18,236,191,3,122,36,144,171,75,20};
static const unsigned char precomputed_nG_montgomery25519_n_96[] = {130,119,54,17,101,169,43,173,142,182,170,201,18,38,139,248,159,4,19,116,61,37,18,196,236,194,38,233,123,175,78,46};
static const unsigned char precomputed_nG_montgomery25519_q_97[] = {39,176,114,157,15,77,195,47,98,46,154,106,101,97,186,245,113,93,10,243,11,51,126,171,222,29,36,172,254,185,16,107};
static const unsigned char precomputed_nG_montgomery25519_n_97[] = {203,223,42,236,165,214,194,133,186,90,243,232,20,65,51,85,124,253,59,176,226,143,40,176,27,56,128,97,229,157,203,62};
static const unsigned char precomputed_nG_montgomery25519_q_98[] = {4,112,186,26,73,115,35,109,244,30,18,239,197,25,210,206,205,96,194,179,248,102,154,82,203,230,30,234,127,20,47,124};
static const unsigned char precomputed_nG_montgomery25519_n_98[] = {233,83,35,64,153,97,121,198,109,141,67,100,71,202,244,103,185,53,218,170,171,201,115,137,228,128,154,136,5,207,1,237};
static const unsigned char precomputed_nG_montgomery25519_q_99[] = {247,1,180,237,7,35,235,55,91,30,219,255,215,219,252,149,109,218,104,100,69,236,67,247,154,161,81,88,69,65,32,118};
static const unsigned char precomputed_nG_montgomery25519_n_99[] = {70,227,81,151,194,81,152,39,109,58,72,118,146,53,147,99,166,243,65,97,127,11,103,218,15,58,248,94,80,141,219,179};
static const unsigned char precomputed_nG_montgomery25519_q_100[] = {90,21,64,11,37,11,141,49,46,74,98,219,243,147,68,174,67,63,55,239,169,24,90,91,169,140,138,183,205,46,99,16};
static const unsigned char precomputed_nG_montgomery25519_n_100[] = {176,126,237,81,102,102,132,124,198,161,76,34,206,83,37,206,222,67,114,153,232,1,251,175,144,138,7,199,201,115,7,28};
static const unsigned char precomputed_nG_montgomery25519_q_101[] = {82,74,202,211,226,26,97,34,75,225,54,117,19,142,96,216,218,114,149,24,159,148,129,161,240,127,243,22,171,202,34,125};
static const unsigned char precomputed_nG_montgomery25519_n_101[] = {8,139,80,129,28,92,227,252,104,99,17,50,65,187,193,22,212,206,170,208,43,233,87,99,27,150,116,7,208,93,145,84};
static const unsigned char precomputed_nG_montgomery25519_q_102[] = {190,106,244,14,253,44,237,59,19,182,46,49,42,4,13,23,206,21,53,123,219,92,219,72,189,254,12,254,222,163,139,112};
static const unsigned char precomputed_nG_montgomery25519_n_102[] = {29,177,188,135,13,64,192,142,201,69,250,152,30,173,54,236,59,99,15,242,142,72,189,22,157,126,27,244,31,52,167,177};
static const unsigned char precomputed_nG_montgomery25519_q_103[] = {11,192,78,123,179,201,109,66,134,214,78,204,16,96,195,16,175,13,246,229,141,108,82,77,67,243,128,121,82,195,16,43};
static const unsigned char precomputed_nG_montgomery25519_n_103[] = {106,62,139,211,234,205,169,252,229,42,19,207,121,246,194,120,167,15,115,166,20,223,32,104,216,154,194,95,131,167,36,197};
static const unsigned char precomputed_nG_montgomery25519_q_104[] = {59,19,185,127,46,16,161,64,111,171,136,138,68,224,35,109,105,28,245,243,51,65,0,166,142,105,203,98,99,113,14,78};
static const unsigned char precomputed_nG_montgomery25519_n_104[] = {87,95,6,48,16,178,73,234,28,200,209,171,227,63,109,129,57,214,223,106,131,249,240,73,116,200,157,242,240,42,76,162};
static const unsigned char precomputed_nG_montgomery25519_q_105[] = {126,41,246,11,112,28,100,230,194,136,26,88,211,173,236,33,44,41,106,174,67,215,91,37,46,49,215,16,209,95,196,8};
static const unsigned char precomputed_nG_montgomery25519_n_105[] = {204,15,228,131,156,185,61,161,152,150,67,113,68,53,243,62,24,216,129,171,30,11,31,102,248,59,127,142,161,57,80,215};
static const unsigned char precomputed_nG_montgomery25519_q_106[] = {218,219,136,245,228,2,203,64,153,42,104,191,33,82,145,64,77,113,118,66,59,175,113,230,17,39,108,240,48,135,218,5};
static const unsigned char precomputed_nG_montgomery25519_n_106[] = {55,138,52,244,26,64,233,55,219,89,73,81,174,126,193,63,206,82,174,123,74,198,156,229,224,10,38,108,77,120,157,26};
static const unsigned char precomputed_nG_montgomery25519_q_107[] = {215,252,67,88,250,76,235,146,160,67,132,180,99,166,125,255,236,116,0,120,234,205,110,20,121,207,98,60,13,181,143,4};
static const unsigned char precomputed_nG_montgomery25519_n_107[] = {85,137,204,48,130,249,234,35,89,233,48,221,53,243,96,97,211,18,211,45,21,98,234,221,177,119,203,170,210,44,229,164};
static const unsigned char precomputed_nG_montgomery25519_q_108[] = {177,225,217,188,205,185,112,112,6,225,160,156,86,13,239,157,124,31,215,163,40,199,131,58,85,193,231,193,206,186,98,77};
static const unsigned char precomputed_nG_montgomery25519_n_108[] = {56,252,57,128,138,57,148,28,83,174,202,88,98,17,163,34,82,26,247,112,162,64,192,167,231,8,189,28,156,29,188,251};
static const unsigned char precomputed_nG_montgomery25519_q_109[] = {217,169,80,55,17,90,153,11,148,47,211,56,65,144,161,138,66,5,206,212,207,66,115,159,107,113,126,238,3,82,214,54};
static const unsigned char precomputed_nG_montgomery25519_n_109[] = {112,121,57,107,72,182,104,221,176,75,223,205,42,214,83,163,255,49,31,102,204,116,167,237,242,106,100,110,205,135,219,89};
static const unsigned char precomputed_nG_montgomery25519_q_110[] = {106,232,125,67,140,243,175,7,29,77,204,9,36,222,19,112,33,80,108,118,175,181,57,13,53,82,180,200,198,104,114,100};
static const unsigned char precomputed_nG_montgomery25519_n_110[] = {44,125,194,131,141,28,85,153,189,124,131,6,215,148,12,146,101,154,22,73,139,185,118,218,137,216,101,196,127,218,186,94};
static const unsigned char precomputed_nG_montgomery25519_q_111[] = {25,167,166,42,250,60,154,221,179,53,153,104,130,229,157,17,231,241,201,107,57,106,224,96,242,13,148,59,97,220,153,42};
static const unsigned char precomputed_nG_montgomery25519_n_111[] = {51,130,62,172,209,36,41,161,29,1,87,181,150,163,126,169,188,192,128,188,163,6,47,152,40,145,201,170,93,219,137,176};
static const unsigned char precomputed_nG_montgomery25519_q_112[] = {68,33,236,124,237,226,8,150,133,116,178,140,238,225,215,179,52,244,84,146,197,55,48,62,196,98,118,86,18,69,78,109};
static const unsigned char precomputed_nG_montgomery25519_n_112[] = {117,39,80,87,195,165,184,217,135,17,153,93,117,67,4,42,11,71,238,32,18,163,25,219,224,124,157,18,124,177,88,48};
static const unsigned char precomputed_nG_montgomery25519_q_113[] = {33,37,129,47,133,98,239,169,189,200,141,166,43,22,238,225,172,247,225,218,173,149,150,77,179,73,52,25,216,221,41,3};
static const unsigned char precomputed_nG_montgomery25519_n_113[] = {99,161,20,181,199,241,107,128,91,222,223,174,253,195,200,117,10,189,188,0,149,112,34,159,91,220,244,190,164,50,47,91};
static const unsigned char precomputed_nG_montgomery25519_q_114[] = {215,39,57,114,185,6,106,47,249,244,241,228,115,218,5,72,202,54,192,107,229,202,220,157,233,113,60,93,190,49,132,127};
static const unsigned char precomputed_nG_montgomery25519_n_114[] = {129,131,164,9,1,35,50,200,135,132,250,64,150,121,41,247,33,174,51,108,194,47,111,153,203,98,177,70,155,227,121,56};
static const unsigned char precomputed_nG_montgomery25519_q_115[] = {4,160,84,26,135,171,173,252,81,216,123,198,123,183,81,98,69,205,244,47,30,1,131,217,10,22,97,41,89,219,154,42};
static const unsigned char precomputed_nG_montgomery25519_n_115[] = {74,193,132,93,153,229,221,132,20,175,212,87,254,121,113,97,254,58,26,58,211,44,26,123,29,223,66,16,103,248,71,41};
static const unsigned char precomputed_nG_montgomery25519_q_116[] = {134,187,23,244,110,88,203,14,172,152,244,161,178,203,137,72,214,92,117,231,113,66,108,33,14,122,4,43,30,153,41,58};
static const unsigned char precomputed_nG_montgomery25519_n_116[] = {115,254,100,139,60,197,181,208,22,157,181,82,59,72,36,58,212,9,46,184,187,159,233,153,4,128,243,94,6,94,131,242};
static const unsigned char precomputed_nG_montgomery25519_q_117[] = {109,131,103,194,88,121,106,20,61,194,0,112,7,219,194,121,205,239,137,238,145,227,176,145,116,169,132,110,222,186,25,13};
static const unsigned char precomputed_nG_montgomery25519_n_117[] = {219,73,229,221,188,105,135,94,153,141,144,222,123,209,184,245,88,225,11,205,31,170,143,55,8,119,4,13,98,20,122,168};
static const unsigned char precomputed_nG_montgomery25519_q_118[] = {204,41,112,129,220,87,8,115,81,70,91,107,192,66,116,55,79,98,37,51,156,120,70,3,43,144,95,139,52,48,224,41};
static const unsigned char precomputed_nG_montgomery25519_n_118[] = {196,193,187,93,241,121,11,47,90,122,60,236,194,215,109,163,178,7,61,147,65,26,117,3,164,2,158,146,36,119,32,60};
static const unsigned char precomputed_nG_montgomery25519_q_119[] = {134,162,134,212,176,129,0,175,152,87,105,13,210,170,183,174,181,214,22,255,166,217,245,17,157,178,60,67,182,213,243,81};
static const unsigned char precomputed_nG_montgomery25519_n_119[] = {227,222,100,66,28,246,173,249,53,149,213,37,185,54,69,163,16,250,185,224,102,146,4,98,179,194,53,222,8,220,97,123};
static const unsigned char precomputed_nG_montgomery25519_q_120[] = {163,57,72,14,105,41,25,105,33,251,68,189,186,30,95,182,210,48,26,251,148,236,40,94,236,6,100,46,116,13,102,73};
static const unsigned char precomputed_nG_montgomery25519_n_120[] = {209,99,147,114,75,237,209,1,229,15,127,18,235,119,0,211,147,124,173,121,62,141,17,8,76,143,7,103,226,214,166,146};
static const unsigned char precomputed_nG_montgomery25519_q_121[] = {231,214,186,185,132,85,228,182,28,78,168,61,112,205,229,145,139,97,178,236,91,120,171,153,29,24,190,249,110,159,96,14};
static const unsigned char precomputed_nG_montgomery25519_n_121[] = {103,224,148,94,155,129,179,251,105,250,220,47,46,139,24,183,209,66,113,59,131,78,182,20,165,48,145,219,12,96,248,18};
static const unsigned char precomputed_nG_montgomery25519_q_122[] = {18,2,183,113,150,221,15,140,218,124,112,103,112,27,4,89,12,253,76,44,209,86,249,235,77,10,204,164,190,77,237,10};
static const unsigned char precomputed_nG_montgomery25519_n_122[] = {208,4,251,158,62,204,198,242,117,188,234,88,248,175,49,90,172,113,94,200,25,91,3,16,43,140,111,76,171,161,135,4};
static const unsigned char precomputed_nG_montgomery25519_q_123[] = {248,99,147,125,98,129,78,142,57,115,131,11,241,197,240,182,57,193,94,193,14,11,136,122,72,116,247,254,53,232,184,73};
static const unsigned char precomputed_nG_montgomery25519_n_123[] = {126,74,143,250,221,41,169,175,238,249,166,84,124,36,25,221,221,106,160,39,213,160,65,1,220,177,253,54,123,209,136,144};
static const unsigned char precomputed_nG_montgomery25519_q_124[] = {103,102,33,65,143,34,247,169,101,62,153,147,175,173,107,164,123,7,10,12,57,84,221,14,208,230,35,240,80,156,123,102};
static const unsigned char precomputed_nG_montgomery25519_n_124[] = {143,57,128,178,242,8,119,32,25,176,50,115,223,118,164,211,113,228,56,213,248,18,237,148,101,184,118,9,25,46,43,44};
static const unsigned char precomputed_nG_montgomery25519_q_125[] = {131,46,70,237,163,138,5,131,9,132,240,153,214,179,149,218,22,99,31,46,136,7,28,80,213,71,143,234,132,201,142,32};
static const unsigned char precomputed_nG_montgomery25519_n_125[] = {245,122,67,58,179,139,166,104,97,201,74,88,230,100,106,82,94,69,97,82,95,158,166,80,96,136,166,26,117,220,136,213};
static const unsigned char precomputed_nG_montgomery25519_q_126[] = {18,236,254,203,182,30,41,246,109,110,144,221,12,121,3,75,88,133,20,228,205,237,237,21,179,34,177,40,34,171,125,37};
static const unsigned char precomputed_nG_montgomery25519_n_126[] = {177,1,54,227,31,2,70,177,148,115,178,232,34,44,225,90,104,138,115,154,32,57,48,20,168,164,0,83,173,234,42,97};
static const unsigned char precomputed_nG_montgomery25519_q_127[] = {164,246,166,99,198,192,139,239,233,157,116,118,18,84,11,82,8,253,193,169,18,215,22,128,96,174,105,202,219,183,140,17};
static const unsigned char precomputed_nG_montgomery25519_n_127[] = {127,247,155,26,58,240,193,235,103,31,209,206,83,124,54,240,122,240,31,168,185,104,161,158,250,17,202,252,121,120,91,1};
static const unsigned char precomputed_nG_montgomery25519_q_128[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_128[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_129[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_130[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_130[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_131[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_131[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_132[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_132[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_133[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_133[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_134[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_134[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_135[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_135[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_136[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_136[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_137[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_137[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_138[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_138[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_139[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_139[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_140[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_140[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_141[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_141[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_142[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_142[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_143[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_143[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_144[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_144[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_145[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_145[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_146[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_146[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_147[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_147[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_148[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_148[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_149[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_149[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_150[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_150[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_151[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_151[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_152[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_152[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_153[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_153[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_154[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_154[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_155[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_155[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_156[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_156[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_157[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_157[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_158[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_158[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_159[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_159[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_160[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_160[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_161[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_161[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_162[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_162[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_163[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_163[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_164[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_164[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_165[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_165[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_166[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_166[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_167[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_167[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_168[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_168[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_169[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_169[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_170[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_170[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_171[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_171[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_172[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_172[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_173[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_173[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_174[] = {186,100,129,102,128,121,51,14,111,124,248,226,230,194,177,153,116,171,27,164,13,96,68,219,72,119,208,151,145,146,43,25};
static const unsigned char precomputed_nG_montgomery25519_n_174[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_175[] = {186,100,129,102,128,121,51,14,111,124,248,226,230,194,177,153,116,171,27,164,13,96,68,219,72,119,208,151,145,146,43,25};
static const unsigned char precomputed_nG_montgomery25519_n_175[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_176[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_176[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_177[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_177[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_178[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_178[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_179[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_179[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_180[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_180[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_181[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_181[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_182[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_182[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_183[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_183[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_184[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_184[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_185[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_185[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_186[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_186[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_187[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_187[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_188[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_188[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_189[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_189[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_190[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_190[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_191[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_191[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_192[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_montgomery25519_n_192[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_193[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_montgomery25519_n_193[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_194[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_194[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_195[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_195[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_196[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_196[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_197[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_197[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_198[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_198[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_199[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_199[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_200[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_200[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_201[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_201[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_202[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_202[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_203[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_203[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
} precomputed_nG_montgomery25519[precomputed_nG_montgomery25519_NUM] = {
  {
    precomputed_nG_montgomery25519_q_0,32,
    precomputed_nG_montgomery25519_n_0,32,
  },
  {
    precomputed_nG_montgomery25519_q_1,32,
    precomputed_nG_montgomery25519_n_1,32,
  },
  {
    precomputed_nG_montgomery25519_q_2,32,
    precomputed_nG_montgomery25519_n_2,32,
  },
  {
    precomputed_nG_montgomery25519_q_3,32,
    precomputed_nG_montgomery25519_n_3,32,
  },
  {
    precomputed_nG_montgomery25519_q_4,32,
    precomputed_nG_montgomery25519_n_4,32,
  },
  {
    precomputed_nG_montgomery25519_q_5,32,
    precomputed_nG_montgomery25519_n_5,32,
  },
  {
    precomputed_nG_montgomery25519_q_6,32,
    precomputed_nG_montgomery25519_n_6,32,
  },
  {
    precomputed_nG_montgomery25519_q_7,32,
    precomputed_nG_montgomery25519_n_7,32,
  },
  {
    precomputed_nG_montgomery25519_q_8,32,
    precomputed_nG_montgomery25519_n_8,32,
  },
  {
    precomputed_nG_montgomery25519_q_9,32,
    precomputed_nG_montgomery25519_n_9,32,
  },
  {
    precomputed_nG_montgomery25519_q_10,32,
    precomputed_nG_montgomery25519_n_10,32,
  },
  {
    precomputed_nG_montgomery25519_q_11,32,
    precomputed_nG_montgomery25519_n_11,32,
  },
  {
    precomputed_nG_montgomery25519_q_12,32,
    precomputed_nG_montgomery25519_n_12,32,
  },
  {
    precomputed_nG_montgomery25519_q_13,32,
    precomputed_nG_montgomery25519_n_13,32,
  },
  {
    precomputed_nG_montgomery25519_q_14,32,
    precomputed_nG_montgomery25519_n_14,32,
  },
  {
    precomputed_nG_montgomery25519_q_15,32,
    precomputed_nG_montgomery25519_n_15,32,
  },
  {
    precomputed_nG_montgomery25519_q_16,32,
    precomputed_nG_montgomery25519_n_16,32,
  },
  {
    precomputed_nG_montgomery25519_q_17,32,
    precomputed_nG_montgomery25519_n_17,32,
  },
  {
    precomputed_nG_montgomery25519_q_18,32,
    precomputed_nG_montgomery25519_n_18,32,
  },
  {
    precomputed_nG_montgomery25519_q_19,32,
    precomputed_nG_montgomery25519_n_19,32,
  },
  {
    precomputed_nG_montgomery25519_q_20,32,
    precomputed_nG_montgomery25519_n_20,32,
  },
  {
    precomputed_nG_montgomery25519_q_21,32,
    precomputed_nG_montgomery25519_n_21,32,
  },
  {
    precomputed_nG_montgomery25519_q_22,32,
    precomputed_nG_montgomery25519_n_22,32,
  },
  {
    precomputed_nG_montgomery25519_q_23,32,
    precomputed_nG_montgomery25519_n_23,32,
  },
  {
    precomputed_nG_montgomery25519_q_24,32,
    precomputed_nG_montgomery25519_n_24,32,
  },
  {
    precomputed_nG_montgomery25519_q_25,32,
    precomputed_nG_montgomery25519_n_25,32,
  },
  {
    precomputed_nG_montgomery25519_q_26,32,
    precomputed_nG_montgomery25519_n_26,32,
  },
  {
    precomputed_nG_montgomery25519_q_27,32,
    precomputed_nG_montgomery25519_n_27,32,
  },
  {
    precomputed_nG_montgomery25519_q_28,32,
    precomputed_nG_montgomery25519_n_28,32,
  },
  {
    precomputed_nG_montgomery25519_q_29,32,
    precomputed_nG_montgomery25519_n_29,32,
  },
  {
    precomputed_nG_montgomery25519_q_30,32,
    precomputed_nG_montgomery25519_n_30,32,
  },
  {
    precomputed_nG_montgomery25519_q_31,32,
    precomputed_nG_montgomery25519_n_31,32,
  },
  {
    precomputed_nG_montgomery25519_q_32,32,
    precomputed_nG_montgomery25519_n_32,32,
  },
  {
    precomputed_nG_montgomery25519_q_33,32,
    precomputed_nG_montgomery25519_n_33,32,
  },
  {
    precomputed_nG_montgomery25519_q_34,32,
    precomputed_nG_montgomery25519_n_34,32,
  },
  {
    precomputed_nG_montgomery25519_q_35,32,
    precomputed_nG_montgomery25519_n_35,32,
  },
  {
    precomputed_nG_montgomery25519_q_36,32,
    precomputed_nG_montgomery25519_n_36,32,
  },
  {
    precomputed_nG_montgomery25519_q_37,32,
    precomputed_nG_montgomery25519_n_37,32,
  },
  {
    precomputed_nG_montgomery25519_q_38,32,
    precomputed_nG_montgomery25519_n_38,32,
  },
  {
    precomputed_nG_montgomery25519_q_39,32,
    precomputed_nG_montgomery25519_n_39,32,
  },
  {
    precomputed_nG_montgomery25519_q_40,32,
    precomputed_nG_montgomery25519_n_40,32,
  },
  {
    precomputed_nG_montgomery25519_q_41,32,
    precomputed_nG_montgomery25519_n_41,32,
  },
  {
    precomputed_nG_montgomery25519_q_42,32,
    precomputed_nG_montgomery25519_n_42,32,
  },
  {
    precomputed_nG_montgomery25519_q_43,32,
    precomputed_nG_montgomery25519_n_43,32,
  },
  {
    precomputed_nG_montgomery25519_q_44,32,
    precomputed_nG_montgomery25519_n_44,32,
  },
  {
    precomputed_nG_montgomery25519_q_45,32,
    precomputed_nG_montgomery25519_n_45,32,
  },
  {
    precomputed_nG_montgomery25519_q_46,32,
    precomputed_nG_montgomery25519_n_46,32,
  },
  {
    precomputed_nG_montgomery25519_q_47,32,
    precomputed_nG_montgomery25519_n_47,32,
  },
  {
    precomputed_nG_montgomery25519_q_48,32,
    precomputed_nG_montgomery25519_n_48,32,
  },
  {
    precomputed_nG_montgomery25519_q_49,32,
    precomputed_nG_montgomery25519_n_49,32,
  },
  {
    precomputed_nG_montgomery25519_q_50,32,
    precomputed_nG_montgomery25519_n_50,32,
  },
  {
    precomputed_nG_montgomery25519_q_51,32,
    precomputed_nG_montgomery25519_n_51,32,
  },
  {
    precomputed_nG_montgomery25519_q_52,32,
    precomputed_nG_montgomery25519_n_52,32,
  },
  {
    precomputed_nG_montgomery25519_q_53,32,
    precomputed_nG_montgomery25519_n_53,32,
  },
  {
    precomputed_nG_montgomery25519_q_54,32,
    precomputed_nG_montgomery25519_n_54,32,
  },
  {
    precomputed_nG_montgomery25519_q_55,32,
    precomputed_nG_montgomery25519_n_55,32,
  },
  {
    precomputed_nG_montgomery25519_q_56,32,
    precomputed_nG_montgomery25519_n_56,32,
  },
  {
    precomputed_nG_montgomery25519_q_57,32,
    precomputed_nG_montgomery25519_n_57,32,
  },
  {
    precomputed_nG_montgomery25519_q_58,32,
    precomputed_nG_montgomery25519_n_58,32,
  },
  {
    precomputed_nG_montgomery25519_q_59,32,
    precomputed_nG_montgomery25519_n_59,32,
  },
  {
    precomputed_nG_montgomery25519_q_60,32,
    precomputed_nG_montgomery25519_n_60,32,
  },
  {
    precomputed_nG_montgomery25519_q_61,32,
    precomputed_nG_montgomery25519_n_61,32,
  },
  {
    precomputed_nG_montgomery25519_q_62,32,
    precomputed_nG_montgomery25519_n_62,32,
  },
  {
    precomputed_nG_montgomery25519_q_63,32,
    precomputed_nG_montgomery25519_n_63,32,
  },
  {
    precomputed_nG_montgomery25519_q_64,32,
    precomputed_nG_montgomery25519_n_64,32,
  },
  {
    precomputed_nG_montgomery25519_q_65,32,
    precomputed_nG_montgomery25519_n_65,32,
  },
  {
    precomputed_nG_montgomery25519_q_66,32,
    precomputed_nG_montgomery25519_n_66,32,
  },
  {
    precomputed_nG_montgomery25519_q_67,32,
    precomputed_nG_montgomery25519_n_67,32,
  },
  {
    precomputed_nG_montgomery25519_q_68,32,
    precomputed_nG_montgomery25519_n_68,32,
  },
  {
    precomputed_nG_montgomery25519_q_69,32,
    precomputed_nG_montgomery25519_n_69,32,
  },
  {
    precomputed_nG_montgomery25519_q_70,32,
    precomputed_nG_montgomery25519_n_70,32,
  },
  {
    precomputed_nG_montgomery25519_q_71,32,
    precomputed_nG_montgomery25519_n_71,32,
  },
  {
    precomputed_nG_montgomery25519_q_72,32,
    precomputed_nG_montgomery25519_n_72,32,
  },
  {
    precomputed_nG_montgomery25519_q_73,32,
    precomputed_nG_montgomery25519_n_73,32,
  },
  {
    precomputed_nG_montgomery25519_q_74,32,
    precomputed_nG_montgomery25519_n_74,32,
  },
  {
    precomputed_nG_montgomery25519_q_75,32,
    precomputed_nG_montgomery25519_n_75,32,
  },
  {
    precomputed_nG_montgomery25519_q_76,32,
    precomputed_nG_montgomery25519_n_76,32,
  },
  {
    precomputed_nG_montgomery25519_q_77,32,
    precomputed_nG_montgomery25519_n_77,32,
  },
  {
    precomputed_nG_montgomery25519_q_78,32,
    precomputed_nG_montgomery25519_n_78,32,
  },
  {
    precomputed_nG_montgomery25519_q_79,32,
    precomputed_nG_montgomery25519_n_79,32,
  },
  {
    precomputed_nG_montgomery25519_q_80,32,
    precomputed_nG_montgomery25519_n_80,32,
  },
  {
    precomputed_nG_montgomery25519_q_81,32,
    precomputed_nG_montgomery25519_n_81,32,
  },
  {
    precomputed_nG_montgomery25519_q_82,32,
    precomputed_nG_montgomery25519_n_82,32,
  },
  {
    precomputed_nG_montgomery25519_q_83,32,
    precomputed_nG_montgomery25519_n_83,32,
  },
  {
    precomputed_nG_montgomery25519_q_84,32,
    precomputed_nG_montgomery25519_n_84,32,
  },
  {
    precomputed_nG_montgomery25519_q_85,32,
    precomputed_nG_montgomery25519_n_85,32,
  },
  {
    precomputed_nG_montgomery25519_q_86,32,
    precomputed_nG_montgomery25519_n_86,32,
  },
  {
    precomputed_nG_montgomery25519_q_87,32,
    precomputed_nG_montgomery25519_n_87,32,
  },
  {
    precomputed_nG_montgomery25519_q_88,32,
    precomputed_nG_montgomery25519_n_88,32,
  },
  {
    precomputed_nG_montgomery25519_q_89,32,
    precomputed_nG_montgomery25519_n_89,32,
  },
  {
    precomputed_nG_montgomery25519_q_90,32,
    precomputed_nG_montgomery25519_n_90,32,
  },
  {
    precomputed_nG_montgomery25519_q_91,32,
    precomputed_nG_montgomery25519_n_91,32,
  },
  {
    precomputed_nG_montgomery25519_q_92,32,
    precomputed_nG_montgomery25519_n_92,32,
  },
  {
    precomputed_nG_montgomery25519_q_93,32,
    precomputed_nG_montgomery25519_n_93,32,
  },
  {
    precomputed_nG_montgomery25519_q_94,32,
    precomputed_nG_montgomery25519_n_94,32,
  },
  {
    precomputed_nG_montgomery25519_q_95,32,
    precomputed_nG_montgomery25519_n_95,32,
  },
  {
    precomputed_nG_montgomery25519_q_96,32,
    precomputed_nG_montgomery25519_n_96,32,
  },
  {
    precomputed_nG_montgomery25519_q_97,32,
    precomputed_nG_montgomery25519_n_97,32,
  },
  {
    precomputed_nG_montgomery25519_q_98,32,
    precomputed_nG_montgomery25519_n_98,32,
  },
  {
    precomputed_nG_montgomery25519_q_99,32,
    precomputed_nG_montgomery25519_n_99,32,
  },
  {
    precomputed_nG_montgomery25519_q_100,32,
    precomputed_nG_montgomery25519_n_100,32,
  },
  {
    precomputed_nG_montgomery25519_q_101,32,
    precomputed_nG_montgomery25519_n_101,32,
  },
  {
    precomputed_nG_montgomery25519_q_102,32,
    precomputed_nG_montgomery25519_n_102,32,
  },
  {
    precomputed_nG_montgomery25519_q_103,32,
    precomputed_nG_montgomery25519_n_103,32,
  },
  {
    precomputed_nG_montgomery25519_q_104,32,
    precomputed_nG_montgomery25519_n_104,32,
  },
  {
    precomputed_nG_montgomery25519_q_105,32,
    precomputed_nG_montgomery25519_n_105,32,
  },
  {
    precomputed_nG_montgomery25519_q_106,32,
    precomputed_nG_montgomery25519_n_106,32,
  },
  {
    precomputed_nG_montgomery25519_q_107,32,
    precomputed_nG_montgomery25519_n_107,32,
  },
  {
    precomputed_nG_montgomery25519_q_108,32,
    precomputed_nG_montgomery25519_n_108,32,
  },
  {
    precomputed_nG_montgomery25519_q_109,32,
    precomputed_nG_montgomery25519_n_109,32,
  },
  {
    precomputed_nG_montgomery25519_q_110,32,
    precomputed_nG_montgomery25519_n_110,32,
  },
  {
    precomputed_nG_montgomery25519_q_111,32,
    precomputed_nG_montgomery25519_n_111,32,
  },
  {
    precomputed_nG_montgomery25519_q_112,32,
    precomputed_nG_montgomery25519_n_112,32,
  },
  {
    precomputed_nG_montgomery25519_q_113,32,
    precomputed_nG_montgomery25519_n_113,32,
  },
  {
    precomputed_nG_montgomery25519_q_114,32,
    precomputed_nG_montgomery25519_n_114,32,
  },
  {
    precomputed_nG_montgomery25519_q_115,32,
    precomputed_nG_montgomery25519_n_115,32,
  },
  {
    precomputed_nG_montgomery25519_q_116,32,
    precomputed_nG_montgomery25519_n_116,32,
  },
  {
    precomputed_nG_montgomery25519_q_117,32,
    precomputed_nG_montgomery25519_n_117,32,
  },
  {
    precomputed_nG_montgomery25519_q_118,32,
    precomputed_nG_montgomery25519_n_118,32,
  },
  {
    precomputed_nG_montgomery25519_q_119,32,
    precomputed_nG_montgomery25519_n_119,32,
  },
  {
    precomputed_nG_montgomery25519_q_120,32,
    precomputed_nG_montgomery25519_n_120,32,
  },
  {
    precomputed_nG_montgomery25519_q_121,32,
    precomputed_nG_montgomery25519_n_121,32,
  },
  {
    precomputed_nG_montgomery25519_q_122,32,
    precomputed_nG_montgomery25519_n_122,32,
  },
  {
    precomputed_nG_montgomery25519_q_123,32,
    precomputed_nG_montgomery25519_n_123,32,
  },
  {
    precomputed_nG_montgomery25519_q_124,32,
    precomputed_nG_montgomery25519_n_124,32,
  },
  {
    precomputed_nG_montgomery25519_q_125,32,
    precomputed_nG_montgomery25519_n_125,32,
  },
  {
    precomputed_nG_montgomery25519_q_126,32,
    precomputed_nG_montgomery25519_n_126,32,
  },
  {
    precomputed_nG_montgomery25519_q_127,32,
    precomputed_nG_montgomery25519_n_127,32,
  },
  {
    precomputed_nG_montgomery25519_q_128,32,
    precomputed_nG_montgomery25519_n_128,32,
  },
  {
    precomputed_nG_montgomery25519_q_129,32,
    precomputed_nG_montgomery25519_n_129,32,
  },
  {
    precomputed_nG_montgomery25519_q_130,32,
    precomputed_nG_montgomery25519_n_130,32,
  },
  {
    precomputed_nG_montgomery25519_q_131,32,
    precomputed_nG_montgomery25519_n_131,32,
  },
  {
    precomputed_nG_montgomery25519_q_132,32,
    precomputed_nG_montgomery25519_n_132,32,
  },
  {
    precomputed_nG_montgomery25519_q_133,32,
    precomputed_nG_montgomery25519_n_133,32,
  },
  {
    precomputed_nG_montgomery25519_q_134,32,
    precomputed_nG_montgomery25519_n_134,32,
  },
  {
    precomputed_nG_montgomery25519_q_135,32,
    precomputed_nG_montgomery25519_n_135,32,
  },
  {
    precomputed_nG_montgomery25519_q_136,32,
    precomputed_nG_montgomery25519_n_136,32,
  },
  {
    precomputed_nG_montgomery25519_q_137,32,
    precomputed_nG_montgomery25519_n_137,32,
  },
  {
    precomputed_nG_montgomery25519_q_138,32,
    precomputed_nG_montgomery25519_n_138,32,
  },
  {
    precomputed_nG_montgomery25519_q_139,32,
    precomputed_nG_montgomery25519_n_139,32,
  },
  {
    precomputed_nG_montgomery25519_q_140,32,
    precomputed_nG_montgomery25519_n_140,32,
  },
  {
    precomputed_nG_montgomery25519_q_141,32,
    precomputed_nG_montgomery25519_n_141,32,
  },
  {
    precomputed_nG_montgomery25519_q_142,32,
    precomputed_nG_montgomery25519_n_142,32,
  },
  {
    precomputed_nG_montgomery25519_q_143,32,
    precomputed_nG_montgomery25519_n_143,32,
  },
  {
    precomputed_nG_montgomery25519_q_144,32,
    precomputed_nG_montgomery25519_n_144,32,
  },
  {
    precomputed_nG_montgomery25519_q_145,32,
    precomputed_nG_montgomery25519_n_145,32,
  },
  {
    precomputed_nG_montgomery25519_q_146,32,
    precomputed_nG_montgomery25519_n_146,32,
  },
  {
    precomputed_nG_montgomery25519_q_147,32,
    precomputed_nG_montgomery25519_n_147,32,
  },
  {
    precomputed_nG_montgomery25519_q_148,32,
    precomputed_nG_montgomery25519_n_148,32,
  },
  {
    precomputed_nG_montgomery25519_q_149,32,
    precomputed_nG_montgomery25519_n_149,32,
  },
  {
    precomputed_nG_montgomery25519_q_150,32,
    precomputed_nG_montgomery25519_n_150,32,
  },
  {
    precomputed_nG_montgomery25519_q_151,32,
    precomputed_nG_montgomery25519_n_151,32,
  },
  {
    precomputed_nG_montgomery25519_q_152,32,
    precomputed_nG_montgomery25519_n_152,32,
  },
  {
    precomputed_nG_montgomery25519_q_153,32,
    precomputed_nG_montgomery25519_n_153,32,
  },
  {
    precomputed_nG_montgomery25519_q_154,32,
    precomputed_nG_montgomery25519_n_154,32,
  },
  {
    precomputed_nG_montgomery25519_q_155,32,
    precomputed_nG_montgomery25519_n_155,32,
  },
  {
    precomputed_nG_montgomery25519_q_156,32,
    precomputed_nG_montgomery25519_n_156,32,
  },
  {
    precomputed_nG_montgomery25519_q_157,32,
    precomputed_nG_montgomery25519_n_157,32,
  },
  {
    precomputed_nG_montgomery25519_q_158,32,
    precomputed_nG_montgomery25519_n_158,32,
  },
  {
    precomputed_nG_montgomery25519_q_159,32,
    precomputed_nG_montgomery25519_n_159,32,
  },
  {
    precomputed_nG_montgomery25519_q_160,32,
    precomputed_nG_montgomery25519_n_160,32,
  },
  {
    precomputed_nG_montgomery25519_q_161,32,
    precomputed_nG_montgomery25519_n_161,32,
  },
  {
    precomputed_nG_montgomery25519_q_162,32,
    precomputed_nG_montgomery25519_n_162,32,
  },
  {
    precomputed_nG_montgomery25519_q_163,32,
    precomputed_nG_montgomery25519_n_163,32,
  },
  {
    precomputed_nG_montgomery25519_q_164,32,
    precomputed_nG_montgomery25519_n_164,32,
  },
  {
    precomputed_nG_montgomery25519_q_165,32,
    precomputed_nG_montgomery25519_n_165,32,
  },
  {
    precomputed_nG_montgomery25519_q_166,32,
    precomputed_nG_montgomery25519_n_166,32,
  },
  {
    precomputed_nG_montgomery25519_q_167,32,
    precomputed_nG_montgomery25519_n_167,32,
  },
  {
    precomputed_nG_montgomery25519_q_168,32,
    precomputed_nG_montgomery25519_n_168,32,
  },
  {
    precomputed_nG_montgomery25519_q_169,32,
    precomputed_nG_montgomery25519_n_169,32,
  },
  {
    precomputed_nG_montgomery25519_q_170,32,
    precomputed_nG_montgomery25519_n_170,32,
  },
  {
    precomputed_nG_montgomery25519_q_171,32,
    precomputed_nG_montgomery25519_n_171,32,
  },
  {
    precomputed_nG_montgomery25519_q_172,32,
    precomputed_nG_montgomery25519_n_172,32,
  },
  {
    precomputed_nG_montgomery25519_q_173,32,
    precomputed_nG_montgomery25519_n_173,32,
  },
  {
    precomputed_nG_montgomery25519_q_174,32,
    precomputed_nG_montgomery25519_n_174,32,
  },
  {
    precomputed_nG_montgomery25519_q_175,32,
    precomputed_nG_montgomery25519_n_175,32,
  },
  {
    precomputed_nG_montgomery25519_q_176,32,
    precomputed_nG_montgomery25519_n_176,32,
  },
  {
    precomputed_nG_montgomery25519_q_177,32,
    precomputed_nG_montgomery25519_n_177,32,
  },
  {
    precomputed_nG_montgomery25519_q_178,32,
    precomputed_nG_montgomery25519_n_178,32,
  },
  {
    precomputed_nG_montgomery25519_q_179,32,
    precomputed_nG_montgomery25519_n_179,32,
  },
  {
    precomputed_nG_montgomery25519_q_180,32,
    precomputed_nG_montgomery25519_n_180,32,
  },
  {
    precomputed_nG_montgomery25519_q_181,32,
    precomputed_nG_montgomery25519_n_181,32,
  },
  {
    precomputed_nG_montgomery25519_q_182,32,
    precomputed_nG_montgomery25519_n_182,32,
  },
  {
    precomputed_nG_montgomery25519_q_183,32,
    precomputed_nG_montgomery25519_n_183,32,
  },
  {
    precomputed_nG_montgomery25519_q_184,32,
    precomputed_nG_montgomery25519_n_184,32,
  },
  {
    precomputed_nG_montgomery25519_q_185,32,
    precomputed_nG_montgomery25519_n_185,32,
  },
  {
    precomputed_nG_montgomery25519_q_186,32,
    precomputed_nG_montgomery25519_n_186,32,
  },
  {
    precomputed_nG_montgomery25519_q_187,32,
    precomputed_nG_montgomery25519_n_187,32,
  },
  {
    precomputed_nG_montgomery25519_q_188,32,
    precomputed_nG_montgomery25519_n_188,32,
  },
  {
    precomputed_nG_montgomery25519_q_189,32,
    precomputed_nG_montgomery25519_n_18