/*
 * LXImage-Qt - a simple and fast image viewer
 * Copyright (C) 2013  PCMan <pcman.tw@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "modelfilter.h"
#include <QImageReader>

using namespace LxImage;

ModelFilter::ModelFilter() {

}

ModelFilter::~ModelFilter() {

}

bool ModelFilter::filterAcceptsRow(const Fm::ProxyFolderModel* model, const std::shared_ptr<const Fm::FileInfo>& info) const
{
  Q_UNUSED(model)

  // Filter out formats that we don't support but don't use FileInfo::isImage() because
  // it only checks if the mimetype starts with "image/" while Qt may support more.
  static const QList<QByteArray> mimeTypes = QImageReader::supportedMimeTypes();
  return info && mimeTypes.contains(info->mimeType()->name());
}

