-- MIPS ioctl differences

local arch = {
  IOC = {
    SIZEBITS = 13,
    DIRBITS = 3,
    NONE = 1,
    READ = 2,
    WRITE = 4,
  },
  ioctl = function(_IO, _IOR, _IOW, _IORW)
    return {
      FIONREAD	     = 0x467f,
      TCSBRK	     = 0x5405,
      TCXONC	     = 0x5406,
      TCFLSH	     = 0x5407,
      TCGETS	     = {number = 0x540d, read = true, type = "termios"},
      TCSETS	     = 0x540e,
      TCSETSW	     = 0x540f,
      TCSETSF	     = 0x5410,
      TIOCPKT	     = 0x5470,
      TIOCNOTTY	     = 0x5471,
      TIOCSTI	     = 0x5472,
      TIOCSCTTY	     = 0x5480,
      TIOCGSOFTCAR   = 0x5481,
      TIOCSSOFTCAR   = 0x5482,
      TIOCLINUX	     = 0x5483,
      TIOCGSERIAL    = 0x5484,
      TIOCSSERIAL    = 0x5485,
      TCSBRKP	     = 0x5486,
      TIOCSERCONFIG  = 0x5488,
      TIOCSERGWILD   = 0x5489,
      TIOCSERSWILD   = 0x548a,
      TIOCGLCKTRMIOS = 0x548b,
      TIOCSLCKTRMIOS = 0x548c,
      TIOCSERGSTRUCT = 0x548d,
      TIOCSERGETLSR  = 0x548e,
      TIOCSERGETMULTI= 0x548f,
      TIOCSERSETMULTI= 0x5490,
      TIOCMIWAIT     = 0x5491,
      TIOCGICOUNT    = 0x5492,
      FIOCLEX	     = 0x6601,
      FIONCLEX	     = 0x6602,
      FIOASYNC	     = 0x667d,
      FIONBIO        = 0x667e,
      FIOQSIZE	     = 0x667f,
      TIOCGETD	     = 0x7400,
      TIOCSETD	     = 0x7401,
      TIOCEXCL	     = 0x740d,
      TIOCNXCL	     = 0x740e,
      TIOCGSID	     = 0x7416,
      TIOCMSET	     = 0x741a,
      TIOCMBIS	     = 0x741b,
      TIOCMBIC	     = 0x741c,
      TIOCMGET	     = 0x741d,
      TIOCOUTQ	     = 0x7472,
      FIOGETOWN      = _IOR('f', 123, "int"),
      FIOSETOWN      = _IOW('f', 124, "int"),
      SIOCATMARK     = _IOR('s', 7, "int"),
      SIOCSPGRP      = _IOW('s', 8, "pid"),
      SIOCGPGRP      = _IOR('s', 9, "pid"),
      TIOCSWINSZ     = _IOW('t', 103, "winsize"),
      TIOCGWINSZ     = _IOR('t', 104, "winsize"),
      TIOCSPGRP	     = _IOW('t', 118, "int"),
      TIOCGPGRP	     = _IOR('t', 119, "int"),
      TIOCCONS	     = _IOW('t', 120, "int"),
    }
  end,
}

return arch

