from LTSPAgent.plugin import Plugin
from BaseHTTPServer import HTTPServer, BaseHTTPRequestHandler
from SocketServer import ThreadingMixIn
import threading, json, urlparse, socket

class jsonHandler(BaseHTTPRequestHandler):
    def log_message(self, format, *args):
        return

    def do_POST(self):
        request=self.path.split('/')

        if len(request) != 3 or request[2] != "json":
            self.send_response(404)
            self.end_headers()
            return

        plugin=request[1]
        if not plugin in self.server.plugins:
            self.send_response(404)
            self.end_headers()
            return

        if not hasattr(self.server.plugins[plugin],'json_handler'):
            self.send_response(404)
            self.end_headers()
            return

        try:
            length=self.headers.getheader('content-length','0')
            content=self.rfile.read(int(length))
            post=urlparse.parse_qs(content)
            if "query" in post:
                query=json.loads(post['query'][0])
            else:
                self.send_response(404)
                self.end_headers()
                return
        except:
            self.send_response(404)
            self.end_headers()
            return

        if not "action" in query:
            self.send_response(500)
            self.end_headers()
            return

        client=self.headers.getheader('X-Forwarded-For',self.client_address[0])

        self.send_response(200)
        self.end_headers()
        self.server.LOGGER.debug("Remote call on %s with params %s", self.server.plugins[plugin], str(query))
        try:
            self.wfile.write(json.dumps(getattr(self.server.plugins[plugin],'json_handler')(query,client)))
            self.wfile.write('\n')
        except:
            self.server.LOGGER.info("Lost connection with %s" % client)

        return

class ThreadedHTTPServer(ThreadingMixIn, HTTPServer):
    """Handle requests in a separate thread."""
    def __init__(self, server_address, SecureXMLRPCRequestHandler):
        # Deal with IPv6
        addrinfo = socket.getaddrinfo(server_address[0], server_address[1])
        for entry in addrinfo:
            if entry[0] == socket.AF_INET6:
                self.address_family = socket.AF_INET6

        HTTPServer.__init__(self, server_address, SecureXMLRPCRequestHandler)

class jsonserverThread(threading.Thread):
    def run(self):
        server = ThreadedHTTPServer(self.connection, jsonHandler)
        server.plugins=self.plugins
        server.LOGGER=self.LOGGER
        self.LOGGER.info("Serving HTTP/JSON on %s port %s", self.connection[0],self.connection[1])
        server.serve_forever()

class jsonlink(Plugin):
    """Export another plugin's functions over JSON"""

    def init_plugin(self):
        jsonserver=jsonserverThread()
        jsonserver.plugins=self.plugins
        jsonserver.connection=(self.get_config_path(self.config,'general','bindaddr'), int(self.get_config_path(self.config,'general','bindport')))
        jsonserver.LOGGER=self.LOGGER
        jsonserver.start()

        Plugin.init_plugin(self)
