#!/usr/bin/python
# WARNING: Used to build the WebLive appservs, DO NOT MODIFY OR REMOVE !
import apt, glob, string

from weblive import WebLive
wl=WebLive('https://weblive.stgraber.org/weblive/json',False)

blacklist_category=['P2P','System','3DGraphics','AudioVideoEditing','AudioVideo','Audio','Video']
blacklist_package=['playonlinux','cheese','synapse','docky','mumble','eclipse-platform','netbeans','qt4-designer','webhttrack','compizconfig-settings-manager','fretsonfire','avogadro']
blacklist_keyword=['3D','GL','virtualbox','compiz']
blacklist_package=sorted(set(blacklist_package+wl.list_package_blacklist()))

cache = apt.Cache()

packages=[]
for desktop in glob.glob("/usr/share/app-install/desktop/*.desktop"):
    current_pkg = None
    nodisplay = False
    terminal = False
    categories = []
    skip = False

    for line in map(string.strip, open(desktop)):
        if line.startswith("X-AppInstall-Package"):
            (tag, sep, value) = line.partition("=")
            current_pkg = value

        if line.startswith("NoDisplay"):
            (tag, sep, value) = line.partition("=")
            if value in ('true','True'):
                nodisplay=True

        if line.startswith("Terminal"):
            (tag, sep, value) = line.partition("=")
            if value in ('true','True'):
                terminal=True

        if line.startswith("Categories"):
            (tag, sep, value) = line.partition("=")
            categories=value.split(';')

        for keyword in blacklist_keyword:
            if keyword in line:
                skip = True

    if '' in categories:
        categories.remove('')

    if current_pkg:
        if current_pkg in blacklist_package:
            skip = True

        if terminal == True or nodisplay == True:
            skip = True

        for category in categories:
            if category in blacklist_category:
                skip = True

        if current_pkg not in cache:
            skip = True

        for package in packages:
            if current_pkg == package[0]:
                skip = True
                break

        if skip == False:
            # Check if package is installable and isn't too big
            cache.clear()
            try:
                cache[current_pkg].mark_install()
            except:
                continue
            if cache.required_space > (150 * 1024 * 1024):
                continue

            packages.append([current_pkg,cache[current_pkg].candidateVersion,not cache[current_pkg].is_installed])

for package in sorted(packages):
    print "%s;%s;%s" % (package[0],package[1],package[2])
