; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

; --------------------------------------------------------------------
; llvm.is.fpclass
; --------------------------------------------------------------------

; FIXME: Should this really be immarg?
; define i1 @test_class_undef_mask_f32(float %x) {
;   %val = call i1 @llvm.is.fpclass.f32(float %x, i32 undef)
;   ret i1 %val
; }

define i1 @test_class_no_mask_f32(float %x) {
; CHECK-LABEL: @test_class_no_mask_f32(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 0)
  ret i1 %val
}

define i1 @test_class_full_mask_f32(float %x) {
; CHECK-LABEL: @test_class_full_mask_f32(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 1023)
  ret i1 %val
}

define i1 @test_class_undef_no_mask_f32() {
; CHECK-LABEL: @test_class_undef_no_mask_f32(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f32(float undef, i32 0)
  ret i1 %val
}

define i1 @test_class_undef_full_mask_f32() {
; CHECK-LABEL: @test_class_undef_full_mask_f32(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f32(float undef, i32 1023)
  ret i1 %val
}

define i1 @test_class_poison_no_mask_f32() {
; CHECK-LABEL: @test_class_poison_no_mask_f32(
; CHECK-NEXT:    ret i1 poison
;
  %val = call i1 @llvm.is.fpclass.f32(float poison, i32 0)
  ret i1 %val
}

define i1 @test_class_poison_full_mask_f32() {
; CHECK-LABEL: @test_class_poison_full_mask_f32(
; CHECK-NEXT:    ret i1 poison
;
  %val = call i1 @llvm.is.fpclass.f32(float poison, i32 1023)
  ret i1 %val
}

define i1 @test_class_undef_val_f32() {
; CHECK-LABEL: @test_class_undef_val_f32(
; CHECK-NEXT:    ret i1 undef
;
  %val = call i1 @llvm.is.fpclass.f32(float undef, i32 4)
  ret i1 %val
}

define i1 @test_class_poison_val_f32() {
; CHECK-LABEL: @test_class_poison_val_f32(
; CHECK-NEXT:    ret i1 poison
;
  %val = call i1 @llvm.is.fpclass.f32(float poison, i32 4)
  ret i1 %val
}

; FIXME: Should this really be immarg?
; define i1 @test_class_undef_undef_f32() {
;   %val = call i1 @llvm.is.fpclass.f32(float undef, i32 undef)
;   ret i1 %val
; }

; FIXME: Should this really be immarg?
; define i1 @test_class_var_mask_f32(float %x, i32 %mask) {
;   %val = call i1 @llvm.is.fpclass.f32(float %x, i32 %mask)
;   ret i1 %val
; }

define i1 @test_class_isnan_f32(float %x) {
; CHECK-LABEL: @test_class_isnan_f32(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 3)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 3)
  ret i1 %val
}

define i1 @test_class_isnan_f32_strict(float %x) {
; CHECK-LABEL: @test_class_isnan_f32_strict(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 3) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 3) strictfp
  ret i1 %val
}

define i1 @test_class_is_p0_n0_f32(float %x) {
; CHECK-LABEL: @test_class_is_p0_n0_f32(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 96)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 96) ; fcZero
  ret i1 %val
}

define i1 @test_class_is_not_p0_n0_f32(float %x) {
; CHECK-LABEL: @test_class_is_not_p0_n0_f32(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 927)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 927) ; ~fcZero & fcAllFlags
  ret i1 %val
}

define i1 @test_class_is_not_p0_n0_f32_strict(float %x) {
; CHECK-LABEL: @test_class_is_not_p0_n0_f32_strict(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 927) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 927) strictfp ; ~fcZero & fcAllFlags
  ret i1 %val
}

define i1 @test_class_is_not_p0_n0_f32_daz(float %x) "denormal-fp-math"="ieee,preserve-sign" {
; CHECK-LABEL: @test_class_is_not_p0_n0_f32_daz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 927)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 927) ; ~fcZero & fcAllFlags
  ret i1 %val
}

define i1 @test_class_is_not_p0_n0_psub_nsub_f32_daz(float %x) "denormal-fp-math"="ieee,preserve-sign" {
; CHECK-LABEL: @test_class_is_not_p0_n0_psub_nsub_f32_daz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 783)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 783) ; ~(fcZero|fcSubnormal) & fcAllFlags
  ret i1 %val
}

define i1 @test_class_is_not_p0_n0_psub_nsub_f32_dapz(float %x) "denormal-fp-math"="ieee,positive-zero" {
; CHECK-LABEL: @test_class_is_not_p0_n0_psub_nsub_f32_dapz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 783)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 783) ; ~(fcZero|fcSubnormal) & fcAllFlags
  ret i1 %val
}

define i1 @test_class_is_p0_n0_f32_strict(float %x) {
; CHECK-LABEL: @test_class_is_p0_n0_f32_strict(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 96) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 96) strictfp
  ret i1 %val
}

define i1 @test_class_is_p0_n0_f32_daz(float %x) "denormal-fp-math"="ieee,preserve-sign" {
; CHECK-LABEL: @test_class_is_p0_n0_f32_daz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 96)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 96) ; fcZero
  ret i1 %val
}

define i1 @test_class_is_p0_n0_f32_dapz(float %x) "denormal-fp-math"="ieee,positive-zero" {
; CHECK-LABEL: @test_class_is_p0_n0_f32_dapz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 96)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 96) ; fcZero
  ret i1 %val
}

define i1 @test_class_is_p0_n0_psub_nsub_f32(float %x) {
; CHECK-LABEL: @test_class_is_p0_n0_psub_nsub_f32(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 240)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 240) ; fcZero | fcSubnormal
  ret i1 %val
}

define i1 @test_class_is_p0_n0_psub_nsub_f32_daz(float %x) "denormal-fp-math"="ieee,preserve-sign" {
; CHECK-LABEL: @test_class_is_p0_n0_psub_nsub_f32_daz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 240)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 240) ; fcZero | fcSubnormal
  ret i1 %val
}

define i1 @test_class_is_p0_n0_psub_nsub_f32_dapz(float %x) "denormal-fp-math"="ieee,positive-zero" {
; CHECK-LABEL: @test_class_is_p0_n0_psub_nsub_f32_dapz(
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 240)
; CHECK-NEXT:    ret i1 [[VAL]]
;
  %val = call i1 @llvm.is.fpclass.f32(float %x, i32 240) ; fcZero | fcSubnormal
  ret i1 %val
}

define i1 @test_constant_class_snan_test_snan_f64() {
; CHECK-LABEL: @test_constant_class_snan_test_snan_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF0000000000001, i32 1)
  ret i1 %val
}

define i1 @test_constant_class_qnan_test_qnan_f64() {
; CHECK-LABEL: @test_constant_class_qnan_test_qnan_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF8000000000000, i32 2)
  ret i1 %val
}

define i1 @test_constant_class_qnan_test_snan_f64() {
; CHECK-LABEL: @test_constant_class_qnan_test_snan_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF8000000000000, i32 1)
  ret i1 %val
}

define i1 @test_constant_class_ninf_test_ninf_f64() {
; CHECK-LABEL: @test_constant_class_ninf_test_ninf_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0xFFF0000000000000, i32 4)
  ret i1 %val
}

define i1 @test_constant_class_pinf_test_ninf_f64() {
; CHECK-LABEL: @test_constant_class_pinf_test_ninf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF0000000000000, i32 4)
  ret i1 %val
}

define i1 @test_constant_class_qnan_test_ninf_f64() {
; CHECK-LABEL: @test_constant_class_qnan_test_ninf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF8000000000000, i32 4)
  ret i1 %val
}

define i1 @test_constant_class_snan_test_ninf_f64() {
; CHECK-LABEL: @test_constant_class_snan_test_ninf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF0000000000001, i32 4)
  ret i1 %val
}

define i1 @test_constant_class_nnormal_test_nnormal_f64() {
; CHECK-LABEL: @test_constant_class_nnormal_test_nnormal_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double -1.0, i32 8)
  ret i1 %val
}

define i1 @test_constant_class_pnormal_test_nnormal_f64() {
; CHECK-LABEL: @test_constant_class_pnormal_test_nnormal_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 1.0, i32 8)
  ret i1 %val
}

define i1 @test_constant_class_nsubnormal_test_nsubnormal_f64() {
; CHECK-LABEL: @test_constant_class_nsubnormal_test_nsubnormal_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x800fffffffffffff, i32 16)
  ret i1 %val
}

define i1 @test_constant_class_psubnormal_test_nsubnormal_f64() {
; CHECK-LABEL: @test_constant_class_psubnormal_test_nsubnormal_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x000fffffffffffff, i32 16)
  ret i1 %val
}

define i1 @test_constant_class_nzero_test_nzero_f64() {
; CHECK-LABEL: @test_constant_class_nzero_test_nzero_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double -0.0, i32 32)
  ret i1 %val
}

define i1 @test_constant_class_pzero_test_nzero_f64() {
; CHECK-LABEL: @test_constant_class_pzero_test_nzero_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0.0, i32 32)
  ret i1 %val
}

define i1 @test_constant_class_pzero_test_pzero_f64() {
; CHECK-LABEL: @test_constant_class_pzero_test_pzero_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0.0, i32 64)
  ret i1 %val
}

define i1 @test_constant_class_nzero_test_pzero_f64() {
; CHECK-LABEL: @test_constant_class_nzero_test_pzero_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double -0.0, i32 64)
  ret i1 %val
}

define i1 @test_constant_class_psubnormal_test_psubnormal_f64() {
; CHECK-LABEL: @test_constant_class_psubnormal_test_psubnormal_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x000fffffffffffff, i32 128)
  ret i1 %val
}

define i1 @test_constant_class_nsubnormal_test_psubnormal_f64() {
; CHECK-LABEL: @test_constant_class_nsubnormal_test_psubnormal_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x800fffffffffffff, i32 128)
  ret i1 %val
}

define i1 @test_constant_class_pnormal_test_pnormal_f64() {
; CHECK-LABEL: @test_constant_class_pnormal_test_pnormal_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 1.0, i32 256)
  ret i1 %val
}

define i1 @test_constant_class_nnormal_test_pnormal_f64() {
; CHECK-LABEL: @test_constant_class_nnormal_test_pnormal_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double -1.0, i32 256)
  ret i1 %val
}

define i1 @test_constant_class_pinf_test_pinf_f64() {
; CHECK-LABEL: @test_constant_class_pinf_test_pinf_f64(
; CHECK-NEXT:    ret i1 true
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF0000000000000, i32 512)
  ret i1 %val
}

define i1 @test_constant_class_ninf_test_pinf_f64() {
; CHECK-LABEL: @test_constant_class_ninf_test_pinf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0xFFF0000000000000, i32 512)
  ret i1 %val
}

define i1 @test_constant_class_qnan_test_pinf_f64() {
; CHECK-LABEL: @test_constant_class_qnan_test_pinf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF8000000000000, i32 512)
  ret i1 %val
}

define i1 @test_constant_class_snan_test_pinf_f64() {
; CHECK-LABEL: @test_constant_class_snan_test_pinf_f64(
; CHECK-NEXT:    ret i1 false
;
  %val = call i1 @llvm.is.fpclass.f64(double 0x7FF0000000000001, i32 512)
  ret i1 %val
}

define i1 @test_class_is_snan_nnan_src(float %x) {
; CHECK-LABEL: @test_class_is_snan_nnan_src(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 1)
  ret i1 %class
}

define i1 @test_class_is_qnan_nnan_src(float %x) {
; CHECK-LABEL: @test_class_is_qnan_nnan_src(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 2)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 2)
  ret i1 %class
}

define i1 @test_class_is_nan_nnan_src(float %x) {
; CHECK-LABEL: @test_class_is_nan_nnan_src(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 3)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 3)
  ret i1 %class
}

define i1 @test_class_is_nan_other_nnan_src(float %x) {
; CHECK-LABEL: @test_class_is_nan_other_nnan_src(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 267)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 267)
  ret i1 %class
}

; Fold test of is not nan
define i1 @test_class_is_not_nan_nnan_src(float %x) {
; CHECK-LABEL: @test_class_is_not_nan_nnan_src(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 1020)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 1020) ; ~fcNan & fcAllFlags
  ret i1 %class
}

define i1 @test_class_is_not_nan_nnan_src_strict(float %x) {
; CHECK-LABEL: @test_class_is_not_nan_nnan_src_strict(
; CHECK-NEXT:    [[NNAN:%.*]] = fadd nnan float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NNAN]], i32 1020) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %nnan = fadd nnan float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %nnan, i32 1020) strictfp ; ~fcNan & fcAllFlags
  ret i1 %class
}

; --------------------------------------------------------------------
; llvm.is.fpclass with ninf sources
; --------------------------------------------------------------------

define i1 @test_class_is_ninf_pinf_ninf_src(float %x) {
; CHECK-LABEL: @test_class_is_ninf_pinf_ninf_src(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 516)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 516)
  ret i1 %class
}

define i1 @test_class_is_ninf_ninf_src(float %x) {
; CHECK-LABEL: @test_class_is_ninf_ninf_src(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 4)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 4)
  ret i1 %class
}

define i1 @test_class_is_pinf_ninf_src(float %x) {
; CHECK-LABEL: @test_class_is_pinf_ninf_src(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 512)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 512)
  ret i1 %class
}

define i1 @test_class_is_ninf_pinf_pnormal_ninf_src(float %x) {
; CHECK-LABEL: @test_class_is_ninf_pinf_pnormal_ninf_src(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 772)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 772)
  ret i1 %class
}

define i1 @test_class_is_not_inf_ninf_src(float %x) {
; CHECK-LABEL: @test_class_is_not_inf_ninf_src(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 507)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 507) ; ~fcInf & fcAllFlags
  ret i1 %class
}

define i1 @test_class_is_not_inf_ninf_src_strict(float %x) {
; CHECK-LABEL: @test_class_is_not_inf_ninf_src_strict(
; CHECK-NEXT:    [[NINF:%.*]] = fadd ninf float [[X:%.*]], 1.000000e+00
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[NINF]], i32 507) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %ninf = fadd ninf float %x, 1.0
  %class = call i1 @llvm.is.fpclass.f32(float %ninf, i32 507) strictfp ; ~fcInf & fcAllFlags
  ret i1 %class
}

; --------------------------------------------------------------------
; Negation of llvm.is.fpclass
; --------------------------------------------------------------------

define i1 @test_class_not_is_nan(float %x) {
; CHECK-LABEL: @test_class_not_is_nan(
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 1020)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %class = call i1 @llvm.is.fpclass.f32(float %x, i32 3)
  %not = xor i1 %class, true
  ret i1 %not
}

define i1 @test_class_not_is_nan_multi_use(float %x, ptr %ptr) {
; CHECK-LABEL: @test_class_not_is_nan_multi_use(
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 3)
; CHECK-NEXT:    store i1 [[CLASS]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[NOT:%.*]] = xor i1 [[CLASS]], true
; CHECK-NEXT:    ret i1 [[NOT]]
;
  %class = call i1 @llvm.is.fpclass.f32(float %x, i32 3)
  store i1 %class, ptr %ptr
  %not = xor i1 %class, true
  ret i1 %not
}

define i1 @test_class_not_is_inf_nan(float %x) {
; CHECK-LABEL: @test_class_not_is_inf_nan(
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 504)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %class = call i1 @llvm.is.fpclass.f32(float %x, i32 519)
  %not = xor i1 %class, true
  ret i1 %not
}

define i1 @test_class_not_is_normal(float %x) {
; CHECK-LABEL: @test_class_not_is_normal(
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 759)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %class = call i1 @llvm.is.fpclass.f32(float %x, i32 264)
  %not = xor i1 %class, true
  ret i1 %not
}

define i1 @test_class_xor_false(float %x) {
; CHECK-LABEL: @test_class_xor_false(
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[X:%.*]], i32 33)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %class = call i1 @llvm.is.fpclass.f32(float %x, i32 33)
  %not = xor i1 %class, false
  ret i1 %not
}

define <2 x i1> @test_class_not_vector(<2 x float> %x) {
; CHECK-LABEL: @test_class_not_vector(
; CHECK-NEXT:    [[CLASS:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[X:%.*]], i32 990)
; CHECK-NEXT:    ret <2 x i1> [[CLASS]]
;
  %class = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %x, i32 33)
  %not = xor <2 x i1> %class, <i1 true, i1 true>
  ret <2 x i1> %not
}

define <2 x i1> @test_class_xor_vector(<2 x float> %x) {
; CHECK-LABEL: @test_class_xor_vector(
; CHECK-NEXT:    [[CLASS:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[X:%.*]], i32 33)
; CHECK-NEXT:    [[NOT:%.*]] = xor <2 x i1> [[CLASS]], <i1 true, i1 false>
; CHECK-NEXT:    ret <2 x i1> [[NOT]]
;
  %class = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %x, i32 33)
  %not = xor <2 x i1> %class, <i1 true, i1 false>
  ret <2 x i1> %not
}

; --------------------------------------------------------------------
; or llvm.is.fpclass, llvm.is.fpclass
; --------------------------------------------------------------------

define i1 @test_fold_or_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_or_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 1)
; CHECK-NEXT:    [[CLASS1:%.*]] = fcmp uno float [[A]], 0.000000e+00
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = fcmp uno float %a, 0.000000e+00
  %or = or i1 %class0, %class1
  ret i1 %or
}

define i1 @test_fold_or3_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_or3_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 7)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %or.0 = or i1 %class0, %class1
  %or.1 = or i1 %or.0, %class2
  ret i1 %or.1
}

define i1 @test_fold_or_all_tests_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_or_all_tests_class_f32_0(
; CHECK-NEXT:    ret i1 true
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class3 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %class4 = call i1 @llvm.is.fpclass.f32(float %a, i32 16)
  %class5 = call i1 @llvm.is.fpclass.f32(float %a, i32 32)
  %class6 = call i1 @llvm.is.fpclass.f32(float %a, i32 64)
  %class7 = call i1 @llvm.is.fpclass.f32(float %a, i32 128)
  %class8 = call i1 @llvm.is.fpclass.f32(float %a, i32 256)
  %class9 = call i1 @llvm.is.fpclass.f32(float %a, i32 512)
  %or.0 = or i1 %class0, %class1
  %or.1 = or i1 %or.0, %class2
  %or.2 = or i1 %or.1, %class3
  %or.3 = or i1 %or.2, %class4
  %or.4 = or i1 %or.3, %class5
  %or.5 = or i1 %or.4, %class6
  %or.6 = or i1 %or.5, %class7
  %or.7 = or i1 %or.6, %class8
  %or.8 = or i1 %or.7, %class9
  ret i1 %or.8
}

define i1 @test_fold_or_class_f32_1(float %a) {
; CHECK-LABEL: @test_fold_or_class_f32_1(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 12)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %or = or i1 %class0, %class1
  ret i1 %or
}

define i1 @test_no_fold_or_class_f32_multi_use0(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_or_class_f32_multi_use0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    store i1 [[CLASS0]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  store i1 %class0, ptr %ptr
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %or = or i1 %class0, %class1
  ret i1 %or
}

define i1 @test_no_fold_or_class_f32_multi_use1(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_or_class_f32_multi_use1(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    store i1 [[CLASS1]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  store i1 %class1, ptr %ptr
  %or = or i1 %class0, %class1
  ret i1 %or
}

define i1 @test_fold_or_class_f32_2(float %a) {
; CHECK-LABEL: @test_fold_or_class_f32_2(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 7)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %or = or i1 %class0, %class1
  ret i1 %or
}

define i1 @test_no_fold_or_class_f32_0(float %a, float %b) {
; CHECK-LABEL: @test_no_fold_or_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[B:%.*]], i32 8)
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %b, i32 8)
  %or = or i1 %class0, %class1
  ret i1 %or
}

define <2 x i1> @test_fold_or_class_v2f32(<2 x float> %a) {
; CHECK-LABEL: @test_fold_or_class_v2f32(
; CHECK-NEXT:    [[CLASS0:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[A:%.*]], i32 12)
; CHECK-NEXT:    ret <2 x i1> [[CLASS0]]
;
  %class0 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 4)
  %class1 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 8)
  %or = or <2 x i1> %class0, %class1
  ret <2 x i1> %or
}

; --------------------------------------------------------------------
; and llvm.is.fpclass, llvm.is.fpclass
; --------------------------------------------------------------------

define i1 @test_fold_and_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_and_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 1)
; CHECK-NEXT:    [[CLASS1:%.*]] = fcmp uno float [[A]], 0.000000e+00
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[AND]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = fcmp uno float %a, 0.000000e+00
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_fold_and3_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_and3_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 2)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 3)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %and.0 = and i1 %class0, %class1
  %and.1 = and i1 %and.0, %class2
  ret i1 %and.1
}

define i1 @test_fold_and_all_tests_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_and_all_tests_class_f32_0(
; CHECK-NEXT:    ret i1 false
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class3 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %class4 = call i1 @llvm.is.fpclass.f32(float %a, i32 16)
  %class5 = call i1 @llvm.is.fpclass.f32(float %a, i32 32)
  %class6 = call i1 @llvm.is.fpclass.f32(float %a, i32 64)
  %class7 = call i1 @llvm.is.fpclass.f32(float %a, i32 128)
  %class8 = call i1 @llvm.is.fpclass.f32(float %a, i32 256)
  %class9 = call i1 @llvm.is.fpclass.f32(float %a, i32 512)
  %and.0 = and i1 %class0, %class1
  %and.1 = and i1 %and.0, %class2
  %and.2 = and i1 %and.1, %class3
  %and.3 = and i1 %and.2, %class4
  %and.4 = and i1 %and.3, %class5
  %and.5 = and i1 %and.4, %class6
  %and.6 = and i1 %and.5, %class7
  %and.7 = and i1 %and.6, %class8
  %and.8 = and i1 %and.7, %class9
  ret i1 %and.8
}

define i1 @test_fold_and_not_all_tests_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_and_not_all_tests_class_f32_0(
; CHECK-NEXT:    ret i1 false
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1022)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 1021)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 1019)
  %class3 = call i1 @llvm.is.fpclass.f32(float %a, i32 1015)
  %class4 = call i1 @llvm.is.fpclass.f32(float %a, i32 1007)
  %class5 = call i1 @llvm.is.fpclass.f32(float %a, i32 991)
  %class6 = call i1 @llvm.is.fpclass.f32(float %a, i32 959)
  %class7 = call i1 @llvm.is.fpclass.f32(float %a, i32 895)
  %class8 = call i1 @llvm.is.fpclass.f32(float %a, i32 767)
  %class9 = call i1 @llvm.is.fpclass.f32(float %a, i32 511)
  %and.0 = and i1 %class0, %class1
  %and.1 = and i1 %and.0, %class2
  %and.2 = and i1 %and.1, %class3
  %and.3 = and i1 %and.2, %class4
  %and.4 = and i1 %and.3, %class5
  %and.5 = and i1 %and.4, %class6
  %and.6 = and i1 %and.5, %class7
  %and.7 = and i1 %and.6, %class8
  %and.8 = and i1 %and.7, %class9
  ret i1 %and.8
}

define i1 @test_fold_and_class_f32_1(float %a) {
; CHECK-LABEL: @test_fold_and_class_f32_1(
; CHECK-NEXT:    ret i1 false
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 48)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 11)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_no_fold_and_class_f32_multi_use0(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_and_class_f32_multi_use0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 15)
; CHECK-NEXT:    store i1 [[CLASS0]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[AND]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 15)
  store i1 %class0, ptr %ptr
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_no_fold_and_class_f32_multi_use1(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_and_class_f32_multi_use1(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 15)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    store i1 [[CLASS1]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[AND]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 15)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  store i1 %class1, ptr %ptr
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_fold_and_class_f32_2(float %a) {
; CHECK-LABEL: @test_fold_and_class_f32_2(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 7)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_fold_and_class_f32_3(float %a) {
; CHECK-LABEL: @test_fold_and_class_f32_3(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 37)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 393)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_fold_and_class_f32_4(float %a) {
; CHECK-LABEL: @test_fold_and_class_f32_4(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 393)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 37)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define i1 @test_no_fold_and_class_f32_0(float %a, float %b) {
; CHECK-LABEL: @test_no_fold_and_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 7)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[B:%.*]], i32 15)
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[AND]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %class1 = call i1 @llvm.is.fpclass.f32(float %b, i32 15)
  %and = and i1 %class0, %class1
  ret i1 %and
}

define <2 x i1> @test_fold_and_class_v2f32(<2 x float> %a) {
; CHECK-LABEL: @test_fold_and_class_v2f32(
; CHECK-NEXT:    [[CLASS0:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[A:%.*]], i32 7)
; CHECK-NEXT:    ret <2 x i1> [[CLASS0]]
;
  %class0 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 7)
  %class1 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 15)
  %and = and <2 x i1> %class0, %class1
  ret <2 x i1> %and
}

; --------------------------------------------------------------------
; xor llvm.is.fpclass, llvm.is.fpclass
; --------------------------------------------------------------------

define i1 @test_fold_xor_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_xor_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 1)
; CHECK-NEXT:    [[CLASS1:%.*]] = fcmp uno float [[A]], 0.000000e+00
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[XOR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = fcmp uno float %a, 0.000000e+00
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define i1 @test_fold_xor3_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_xor3_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 7)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %xor.0 = xor i1 %class0, %class1
  %xor.1 = xor i1 %xor.0, %class2
  ret i1 %xor.1
}

define i1 @test_fold_xor_all_tests_class_f32_0(float %a) {
; CHECK-LABEL: @test_fold_xor_all_tests_class_f32_0(
; CHECK-NEXT:    ret i1 true
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 1)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 2)
  %class2 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class3 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %class4 = call i1 @llvm.is.fpclass.f32(float %a, i32 16)
  %class5 = call i1 @llvm.is.fpclass.f32(float %a, i32 32)
  %class6 = call i1 @llvm.is.fpclass.f32(float %a, i32 64)
  %class7 = call i1 @llvm.is.fpclass.f32(float %a, i32 128)
  %class8 = call i1 @llvm.is.fpclass.f32(float %a, i32 256)
  %class9 = call i1 @llvm.is.fpclass.f32(float %a, i32 512)
  %xor.0 = xor i1 %class0, %class1
  %xor.1 = xor i1 %xor.0, %class2
  %xor.2 = xor i1 %xor.1, %class3
  %xor.3 = xor i1 %xor.2, %class4
  %xor.4 = xor i1 %xor.3, %class5
  %xor.5 = xor i1 %xor.4, %class6
  %xor.6 = xor i1 %xor.5, %class7
  %xor.7 = xor i1 %xor.6, %class8
  %xor.8 = xor i1 %xor.7, %class9
  ret i1 %xor.8
}

define i1 @test_fold_xor_class_f32_1(float %a) {
; CHECK-LABEL: @test_fold_xor_class_f32_1(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 12)
; CHECK-NEXT:    ret i1 [[CLASS0]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define i1 @test_no_fold_xor_class_f32_multi_use0(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_xor_class_f32_multi_use0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    store i1 [[CLASS0]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[XOR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  store i1 %class0, ptr %ptr
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define i1 @test_no_fold_xor_class_f32_multi_use1(float %a, ptr %ptr) {
; CHECK-LABEL: @test_no_fold_xor_class_f32_multi_use1(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A]], i32 8)
; CHECK-NEXT:    store i1 [[CLASS1]], ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[XOR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 8)
  store i1 %class1, ptr %ptr
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define i1 @test_fold_xor_class_f32_2(float %a) {
; CHECK-LABEL: @test_fold_xor_class_f32_2(
; CHECK-NEXT:    ret i1 false
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %class1 = call i1 @llvm.is.fpclass.f32(float %a, i32 7)
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define i1 @test_no_fold_xor_class_f32_0(float %a, float %b) {
; CHECK-LABEL: @test_no_fold_xor_class_f32_0(
; CHECK-NEXT:    [[CLASS0:%.*]] = call i1 @llvm.is.fpclass.f32(float [[A:%.*]], i32 4)
; CHECK-NEXT:    [[CLASS1:%.*]] = call i1 @llvm.is.fpclass.f32(float [[B:%.*]], i32 8)
; CHECK-NEXT:    [[XOR:%.*]] = xor i1 [[CLASS0]], [[CLASS1]]
; CHECK-NEXT:    ret i1 [[XOR]]
;
  %class0 = call i1 @llvm.is.fpclass.f32(float %a, i32 4)
  %class1 = call i1 @llvm.is.fpclass.f32(float %b, i32 8)
  %xor = xor i1 %class0, %class1
  ret i1 %xor
}

define <2 x i1> @test_fold_xor_class_v2f32(<2 x float> %a) {
; CHECK-LABEL: @test_fold_xor_class_v2f32(
; CHECK-NEXT:    [[CLASS0:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[A:%.*]], i32 9)
; CHECK-NEXT:    ret <2 x i1> [[CLASS0]]
;
  %class0 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 4)
  %class1 = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %a, i32 13)
  %xor = xor <2 x i1> %class0, %class1
  ret <2 x i1> %xor
}

; ---------------------------------------------------------------------
; fneg folds
; ---------------------------------------------------------------------

; -> false
define i1 @test_class_fneg_none(float %arg) {
; CHECK-LABEL: @test_class_fneg_none(
; CHECK-NEXT:    ret i1 false
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 0)
  ret i1 %class
}

; -> true
define i1 @test_class_fneg_all(float %arg) {
; CHECK-LABEL: @test_class_fneg_all(
; CHECK-NEXT:    ret i1 true
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 1023)
  ret i1 %class
}

; -> snan
define i1 @test_class_fneg_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_snan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 1)
  ret i1 %class
}

; -> qnan
define i1 @test_class_fneg_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_qnan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 2)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 2)
  ret i1 %class
}

; -> posinf
define i1 @test_class_fneg_neginf(float %arg) {
; CHECK-LABEL: @test_class_fneg_neginf(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 4)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 4)
  ret i1 %class
}

; -> posnormal
define i1 @test_class_fneg_negnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_negnormal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 8)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 8)
  ret i1 %class
}

; -> possubnormal
define i1 @test_class_fneg_negsubnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_negsubnormal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 16)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 16)
  ret i1 %class
}

; -> poszero
define i1 @test_class_fneg_negzero(float %arg) {
; CHECK-LABEL: @test_class_fneg_negzero(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 32)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 32)
  ret i1 %class
}

; -> negzero
define i1 @test_class_fneg_poszero(float %arg) {
; CHECK-LABEL: @test_class_fneg_poszero(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 64)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 64)
  ret i1 %class
}

; -> negsubnormal
define i1 @test_class_fneg_possubnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_possubnormal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 128)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 128)
  ret i1 %class
}

; -> negnormal
define i1 @test_class_fneg_posnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_posnormal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 256)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 256)
  ret i1 %class
}

; -> neginf
define i1 @test_class_fneg_posinf(float %arg) {
; CHECK-LABEL: @test_class_fneg_posinf(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 512)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 512)
  ret i1 %class
}

; -> qnan|snan
define i1 @test_class_fneg_isnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_isnan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 3)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 3)
  ret i1 %class
}

; -> ~nan
define i1 @test_class_fneg_nnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_nnan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 1020)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 1020)
  ret i1 %class
}

; -> normal
define i1 @test_class_fneg_normal(float %arg) {
; CHECK-LABEL: @test_class_fneg_normal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 264)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 264)
  ret i1 %class
}

; -> zero
define i1 @test_class_fneg_zero(float %arg) {
;
; CHECK-LABEL: @test_class_fneg_zero(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 96)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 96)
  ret i1 %class
}

; -> subnormal
define i1 @test_class_fneg_subnormal(float %arg) {
;
; CHECK-LABEL: @test_class_fneg_subnormal(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 144)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 144)
  ret i1 %class
}

; -> normal|pinf
define i1 @test_class_fneg_normal_neginf(float %arg) {
; CHECK-LABEL: @test_class_fneg_normal_neginf(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 268)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 268)
  ret i1 %class
}

; -> normal|ninf
define i1 @test_class_fneg_normal_pinf(float %arg) {
; CHECK-LABEL: @test_class_fneg_normal_pinf(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 776)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 776)
  ret i1 %class
}

; -> pinf|nnormal|pnormal|nzero
define i1 @test_class_fneg_neginf_posnormal_negsubnormal_poszero(float %arg) {
; CHECK-LABEL: @test_class_fneg_neginf_posnormal_negsubnormal_poszero(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 340)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 340)
  ret i1 %class
}

; -> pinf|nnormal|psubnormal|negzero|snan
define i1 @test_class_fneg_neginf_posnormal_negsubnormal_poszero_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_neginf_posnormal_negsubnormal_poszero_snan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 341)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 341)
  ret i1 %class
}

; pinf|negnormal|psubnormal|negzero|qnan
define i1 @test_class_fneg_neginf_posnormal_negsubnormal_poszero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_neginf_posnormal_negsubnormal_poszero_qnan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 342)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 342)
  ret i1 %class
}

; -> pinf | nnormal|psubnormal|nzero|nan
define i1 @test_class_fneg_neginf_posnormal_negsubnormal_poszero_nan(float %arg) {
; CHECK-LABEL: @test_class_fneg_neginf_posnormal_negsubnormal_poszero_nan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 343)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 343)
  ret i1 %class
}

; -> ninf|pnormal|negsubnormal|pzero
define i1 @test_class_fneg_posinf_negnormal_possubnormal_negzero(float %arg) {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 680)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 680)
  ret i1 %class
}

; -> ninf|pnormal|negsubnormal|pzero|snan
define i1 @test_class_fneg_posinf_negnormal_possubnormal_negzero_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero_snan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 681)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 681)
  ret i1 %class
}

; -> ninf|pnormal|negsubnormal|pzero|qnan
define i1 @test_class_fneg_posinf_negnormal_possubnormal_negzero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero_qnan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 682)
  ret i1 %class
}

; -> ninf|pnormal|negsubnormal|pzero
define i1 @test_class_fneg_posinf_negnormal_possubnormal_negzero_nan(float %arg) {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero_nan(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 683)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 683)
  ret i1 %class
}

; strictfp doesn't matter
; -> ninf|pnormal|negsubnormal|pzero|snan
define i1 @test_class_fneg_posinf_negnormal_possubnormal_negzero_snan_strictfp(float %arg) strictfp {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero_snan_strictfp(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 681) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 681) strictfp
  ret i1 %class
}

; multiple uses don't matter
define i1 @test_class_fneg_multiple_use_fneg(float %arg, ptr %ptr) {
; CHECK-LABEL: @test_class_fneg_multiple_use_fneg(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg float [[ARG:%.*]]
; CHECK-NEXT:    store float [[FNEG]], ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fneg = fneg float %arg
  store float %fneg, ptr %ptr
  %class = call i1 @llvm.is.fpclass.f32(float %fneg, i32 682)
  ret i1 %class
}

define <2 x i1> @test_class_fneg_posinf_negnormal_possubnormal_negzero_nan_vector(<2 x float> %arg) {
; CHECK-LABEL: @test_class_fneg_posinf_negnormal_possubnormal_negzero_nan_vector(
; CHECK-NEXT:    [[FNEG:%.*]] = fneg <2 x float> [[ARG:%.*]]
; CHECK-NEXT:    [[CLASS:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[FNEG]], i32 683)
; CHECK-NEXT:    ret <2 x i1> [[CLASS]]
;
  %fneg = fneg <2 x float> %arg
  %class = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %fneg, i32 683)
  ret <2 x i1> %class
}

; ---------------------------------------------------------------------
; fabs folds
; ---------------------------------------------------------------------

; -> false
define i1 @test_class_fabs_none(float %arg) {
; CHECK-LABEL: @test_class_fabs_none(
; CHECK-NEXT:    ret i1 false
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 0)
  ret i1 %class
}

; -> true
define i1 @test_class_fabs_all(float %arg) {
; CHECK-LABEL: @test_class_fabs_all(
; CHECK-NEXT:    ret i1 true
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 1023)
  ret i1 %class
}

; -> snan
define i1 @test_class_fabs_snan(float %arg) {
; CHECK-LABEL: @test_class_fabs_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 1)
  ret i1 %class
}

; -> qnan
define i1 @test_class_fabs_qnan(float %arg) {
; CHECK-LABEL: @test_class_fabs_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 2)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 2)
  ret i1 %class
}

; -> false
define i1 @test_class_fabs_neginf(float %arg) {
; CHECK-LABEL: @test_class_fabs_neginf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 4)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 4)
  ret i1 %class
}

; -> false
define i1 @test_class_fabs_negnormal(float %arg) {
; CHECK-LABEL: @test_class_fabs_negnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 8)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 8)
  ret i1 %class
}

; -> false
define i1 @test_class_fabs_negsubnormal(float %arg) {
; CHECK-LABEL: @test_class_fabs_negsubnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 16)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 16)
  ret i1 %class
}

; -> false
define i1 @test_class_fabs_negzero(float %arg) {
; CHECK-LABEL: @test_class_fabs_negzero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 32)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 32)
  ret i1 %class
}

; -> poszero
define i1 @test_class_fabs_poszero(float %arg) {
; CHECK-LABEL: @test_class_fabs_poszero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 64)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 64)
  ret i1 %class
}

; -> possubnormal
define i1 @test_class_fabs_possubnormal(float %arg) {
; CHECK-LABEL: @test_class_fabs_possubnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 128)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 128)
  ret i1 %class
}

; -> posnormal
define i1 @test_class_fabs_posnormal(float %arg) {
; CHECK-LABEL: @test_class_fabs_posnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 256)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 256)
  ret i1 %class
}

; -> posinf
define i1 @test_class_fabs_posinf(float %arg) {
; CHECK-LABEL: @test_class_fabs_posinf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 512)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 512)
  ret i1 %class
}

; -> qnan|snan
define i1 @test_class_fabs_isnan(float %arg) {
; CHECK-LABEL: @test_class_fabs_isnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 3)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 3)
  ret i1 %class
}

; -> fcPositive
define i1 @test_class_fabs_nnan(float %arg) {
; CHECK-LABEL: @test_class_fabs_nnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 1020)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 1020)
  ret i1 %class
}

; -> posnormal
define i1 @test_class_fabs_normal(float %arg) {
; CHECK-LABEL: @test_class_fabs_normal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 264)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 264)
  ret i1 %class
}

; -> poszero
define i1 @test_class_fabs_zero(float %arg) {
; CHECK-LABEL: @test_class_fabs_zero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 96)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 96)
  ret i1 %class
}

; -> possubnormal
define i1 @test_class_fabs_subnormal(float %arg) {
; CHECK-LABEL: @test_class_fabs_subnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 144)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 144)
  ret i1 %class
}

; -> posnormal
define i1 @test_class_fabs_normal_neginf(float %arg) {
; CHECK-LABEL: @test_class_fabs_normal_neginf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 268)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 268)
  ret i1 %class
}

; -> pnormal|pinf
define i1 @test_class_fabs_normal_pinf(float %arg) {
; CHECK-LABEL: @test_class_fabs_normal_pinf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 776)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 776)
  ret i1 %class
}

; -> pnormal|pzero
define i1 @test_class_fabs_neginf_posnormal_negsubnormal_poszero(float %arg) {
; CHECK-LABEL: @test_class_fabs_neginf_posnormal_negsubnormal_poszero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 340)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 340)
  ret i1 %class
}

; -> pnormal|pzero|snan
define i1 @test_class_fabs_neginf_posnormal_negsubnormal_poszero_snan(float %arg) {
; CHECK-LABEL: @test_class_fabs_neginf_posnormal_negsubnormal_poszero_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 341)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 341)
  ret i1 %class
}

; -> negnormal|pzero|qnan
define i1 @test_class_fabs_neginf_posnormal_negsubnormal_poszero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fabs_neginf_posnormal_negsubnormal_poszero_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 342)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 342)
  ret i1 %class
}

; -> pnormal|pzero|nan
define i1 @test_class_fabs_neginf_posnormal_negsubnormal_poszero_nan(float %arg) {
; CHECK-LABEL: @test_class_fabs_neginf_posnormal_negsubnormal_poszero_nan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 343)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 343)
  ret i1 %class
}

; -> ninf|pnormal|negsubnormal|pzero
define i1 @test_class_fabs_posinf_negnormal_possubnormal_negzero(float %arg) {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 680)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 680)
  ret i1 %class
}

; -> pinf|psubnormal|snan
define i1 @test_class_fabs_posinf_negnormal_possubnormal_negzero_snan(float %arg) {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 681)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 681)
  ret i1 %class
}

; -> pinf|psubnormal|qnan
define i1 @test_class_fabs_posinf_negnormal_possubnormal_negzero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 682)
  ret i1 %class
}

; -> pinf|psubnormal|nan
define i1 @test_class_fabs_posinf_negnormal_possubnormal_negzero_nan(float %arg) {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero_nan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 683)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 683)
  ret i1 %class
}

; strictfp doesn't matter
; -> pinf|psubnormal|snan
define i1 @test_class_fabs_posinf_negnormal_possubnormal_negzero_snan_strictfp(float %arg) strictfp {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero_snan_strictfp(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 681) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 681) strictfp
  ret i1 %class
}

; multiple uses don't matter
define i1 @test_class_fabs_multiple_use_fabs(float %arg, ptr %ptr) {
; CHECK-LABEL: @test_class_fabs_multiple_use_fabs(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    store float [[FABS]], ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FABS]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  store float %fabs, ptr %ptr
  %class = call i1 @llvm.is.fpclass.f32(float %fabs, i32 682)
  ret i1 %class
}

define <2 x i1> @test_class_fabs_posinf_negnormal_possubnormal_negzero_nan_vector(<2 x float> %arg) {
; CHECK-LABEL: @test_class_fabs_posinf_negnormal_possubnormal_negzero_nan_vector(
; CHECK-NEXT:    [[FABS:%.*]] = call <2 x float> @llvm.fabs.v2f32(<2 x float> [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[FABS]], i32 683)
; CHECK-NEXT:    ret <2 x i1> [[CLASS]]
;
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %arg)
  %class = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %fabs, i32 683)
  ret <2 x i1> %class
}

; ---------------------------------------------------------------------
; fneg (fabs) folds
; ---------------------------------------------------------------------

define i1 @test_class_fneg_fabs_none(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_none(
; CHECK-NEXT:    ret i1 false
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 0)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_all(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_all(
; CHECK-NEXT:    ret i1 true
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 1023)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 1)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 1)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 2)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 2)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_neginf(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_neginf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 4)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 4)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_negnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_negnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 8)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 8)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_negsubnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_negsubnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 16)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 16)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_negzero(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_negzero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 32)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 32)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_poszero(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_poszero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 64)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 64)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_possubnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_possubnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 128)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 128)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 256)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 256)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posinf(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 512)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 512)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_isnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_isnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 3)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 3)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_nnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_nnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 1020)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 1020)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_normal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_normal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 264)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 264)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_zero(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_zero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 96)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 96)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_subnormal(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_subnormal(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 144)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 144)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_normal_neginf(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_normal_neginf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 268)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 268)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_normal_pinf(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_normal_pinf(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 776)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 776)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 340)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 340)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 341)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 341)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 342)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 342)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_nan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_neginf_posnormal_negsubnormal_poszero_nan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 343)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 343)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 680)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 680)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_snan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_snan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 681)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 681)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_qnan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_qnan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 682)
  ret i1 %class
}

define i1 @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_nan(float %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_nan(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 683)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 683)
  ret i1 %class
}

; strictfp doesn't matter
define i1 @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_snan_strictfp(float %arg) strictfp {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_snan_strictfp(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 681) #[[ATTR2]]
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 681) strictfp
  ret i1 %class
}

; multiple uses don't matter
define i1 @test_class_fneg_fabs_multiple_use_fabs(float %arg, ptr %ptr) {
; CHECK-LABEL: @test_class_fneg_fabs_multiple_use_fabs(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[ARG:%.*]])
; CHECK-NEXT:    [[FNEG_FABS:%.*]] = fneg float [[FABS]]
; CHECK-NEXT:    store float [[FNEG_FABS]], ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[CLASS:%.*]] = call i1 @llvm.is.fpclass.f32(float [[FNEG_FABS]], i32 682)
; CHECK-NEXT:    ret i1 [[CLASS]]
;
  %fabs = call float @llvm.fabs.f32(float %arg)
  %fneg.fabs = fneg float %fabs
  store float %fneg.fabs, ptr %ptr
  %class = call i1 @llvm.is.fpclass.f32(float %fneg.fabs, i32 682)
  ret i1 %class
}

define <2 x i1> @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_nan_vector(<2 x float> %arg) {
; CHECK-LABEL: @test_class_fneg_fabs_posinf_negnormal_possubnormal_negzero_nan_vector(
; CHECK-NEXT:    [[FABS:%.*]] = call <2 x float> @llvm.fabs.v2f32(<2 x float> [[ARG:%.*]])
; CHECK-NEXT:    [[CLASS:%.*]] = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> [[FABS]], i32 683)
; CHECK-NEXT:    ret <2 x i1> [[CLASS]]
;
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %arg)
  %fneg.fabs = fneg <2 x float> %fabs
  %class = call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %fabs, i32 683)
  ret <2 x i1> %class
}

declare i1 @llvm.is.fpclass.f32(float, i32 immarg)
declare i1 @llvm.is.fpclass.f64(double, i32 immarg)
declare <2 x i1> @llvm.is.fpclass.v2f32(<2 x float>, i32 immarg)
declare float @llvm.fabs.f32(float)
declare <2 x float> @llvm.fabs.v2f32(<2 x float>)
