; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -unroll-runtime -unroll-count=2 -loop-unroll -unroll-runtime-epilog=true  | FileCheck %s -check-prefix=EPILOG
; RUN: opt < %s -S -unroll-runtime -unroll-count=2 -loop-unroll -unroll-runtime-epilog=false | FileCheck %s -check-prefix=PROLOG
target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"

; This test case documents how runtime loop unrolling handles the case
; when the backedge-count is -1.

; If %N, the backedge-taken count, is -1 then %0 unsigned-overflows
; and is 0.  %xtraiter too is 0, signifying that the total trip-count
; is divisible by 2.  The prologue then branches to the unrolled loop
; and executes the 2^32 iterations there, in groups of 2.

define i32 @foo(i32 %N) {
; EPILOG-LABEL: @foo(
; EPILOG-NEXT:  entry:
; EPILOG-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], 1
; EPILOG-NEXT:    [[XTRAITER:%.*]] = and i32 [[TMP0]], 1
; EPILOG-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[N]], 1
; EPILOG-NEXT:    br i1 [[TMP1]], label [[WHILE_END_UNR_LCSSA:%.*]], label [[ENTRY_NEW:%.*]]
; EPILOG:       entry.new:
; EPILOG-NEXT:    [[UNROLL_ITER:%.*]] = sub i32 [[TMP0]], [[XTRAITER]]
; EPILOG-NEXT:    br label [[WHILE_BODY:%.*]]
; EPILOG:       while.body:
; EPILOG-NEXT:    [[I:%.*]] = phi i32 [ 0, [[ENTRY_NEW]] ], [ [[INC_1:%.*]], [[WHILE_BODY]] ]
; EPILOG-NEXT:    [[NITER:%.*]] = phi i32 [ 0, [[ENTRY_NEW]] ], [ [[NITER_NEXT_1:%.*]], [[WHILE_BODY]] ]
; EPILOG-NEXT:    [[INC:%.*]] = add nuw nsw i32 [[I]], 1
; EPILOG-NEXT:    [[NITER_NEXT:%.*]] = add nuw nsw i32 [[NITER]], 1
; EPILOG-NEXT:    [[INC_1]] = add i32 [[INC]], 1
; EPILOG-NEXT:    [[NITER_NEXT_1]] = add i32 [[NITER_NEXT]], 1
; EPILOG-NEXT:    [[NITER_NCMP_1:%.*]] = icmp eq i32 [[NITER_NEXT_1]], [[UNROLL_ITER]]
; EPILOG-NEXT:    br i1 [[NITER_NCMP_1]], label [[WHILE_END_UNR_LCSSA_LOOPEXIT:%.*]], label [[WHILE_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; EPILOG:       while.end.unr-lcssa.loopexit:
; EPILOG-NEXT:    [[I_LCSSA_PH_PH:%.*]] = phi i32 [ [[INC]], [[WHILE_BODY]] ]
; EPILOG-NEXT:    [[I_UNR_PH:%.*]] = phi i32 [ [[INC_1]], [[WHILE_BODY]] ]
; EPILOG-NEXT:    br label [[WHILE_END_UNR_LCSSA]]
; EPILOG:       while.end.unr-lcssa:
; EPILOG-NEXT:    [[I_LCSSA_PH:%.*]] = phi i32 [ undef, [[ENTRY:%.*]] ], [ [[I_LCSSA_PH_PH]], [[WHILE_END_UNR_LCSSA_LOOPEXIT]] ]
; EPILOG-NEXT:    [[I_UNR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[I_UNR_PH]], [[WHILE_END_UNR_LCSSA_LOOPEXIT]] ]
; EPILOG-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i32 [[XTRAITER]], 0
; EPILOG-NEXT:    br i1 [[LCMP_MOD]], label [[WHILE_BODY_EPIL_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; EPILOG:       while.body.epil.preheader:
; EPILOG-NEXT:    br label [[WHILE_BODY_EPIL:%.*]]
; EPILOG:       while.body.epil:
; EPILOG-NEXT:    br label [[WHILE_END]]
; EPILOG:       while.end:
; EPILOG-NEXT:    [[I_LCSSA:%.*]] = phi i32 [ [[I_LCSSA_PH]], [[WHILE_END_UNR_LCSSA]] ], [ [[I_UNR]], [[WHILE_BODY_EPIL]] ]
; EPILOG-NEXT:    ret i32 [[I_LCSSA]]
;
; PROLOG-LABEL: @foo(
; PROLOG-NEXT:  entry:
; PROLOG-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], 1
; PROLOG-NEXT:    [[XTRAITER:%.*]] = and i32 [[TMP0]], 1
; PROLOG-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i32 [[XTRAITER]], 0
; PROLOG-NEXT:    br i1 [[LCMP_MOD]], label [[WHILE_BODY_PROL_PREHEADER:%.*]], label [[WHILE_BODY_PROL_LOOPEXIT:%.*]]
; PROLOG:       while.body.prol.preheader:
; PROLOG-NEXT:    br label [[WHILE_BODY_PROL:%.*]]
; PROLOG:       while.body.prol:
; PROLOG-NEXT:    br label [[WHILE_BODY_PROL_LOOPEXIT]]
; PROLOG:       while.body.prol.loopexit:
; PROLOG-NEXT:    [[I_LCSSA_UNR:%.*]] = phi i32 [ undef, [[ENTRY:%.*]] ], [ 0, [[WHILE_BODY_PROL]] ]
; PROLOG-NEXT:    [[I_UNR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ 1, [[WHILE_BODY_PROL]] ]
; PROLOG-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[N]], 1
; PROLOG-NEXT:    br i1 [[TMP1]], label [[WHILE_END:%.*]], label [[ENTRY_NEW:%.*]]
; PROLOG:       entry.new:
; PROLOG-NEXT:    br label [[WHILE_BODY:%.*]]
; PROLOG:       while.body:
; PROLOG-NEXT:    [[I:%.*]] = phi i32 [ [[I_UNR]], [[ENTRY_NEW]] ], [ [[INC_1:%.*]], [[WHILE_BODY]] ]
; PROLOG-NEXT:    [[INC:%.*]] = add i32 [[I]], 1
; PROLOG-NEXT:    [[CMP_1:%.*]] = icmp eq i32 [[INC]], [[N]]
; PROLOG-NEXT:    [[INC_1]] = add i32 [[INC]], 1
; PROLOG-NEXT:    br i1 [[CMP_1]], label [[WHILE_END_UNR_LCSSA:%.*]], label [[WHILE_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; PROLOG:       while.end.unr-lcssa:
; PROLOG-NEXT:    [[I_LCSSA_PH:%.*]] = phi i32 [ [[INC]], [[WHILE_BODY]] ]
; PROLOG-NEXT:    br label [[WHILE_END]]
; PROLOG:       while.end:
; PROLOG-NEXT:    [[I_LCSSA:%.*]] = phi i32 [ [[I_LCSSA_UNR]], [[WHILE_BODY_PROL_LOOPEXIT]] ], [ [[I_LCSSA_PH]], [[WHILE_END_UNR_LCSSA]] ]
; PROLOG-NEXT:    ret i32 [[I_LCSSA]]
;
entry:
  br label %while.body

while.body:                                       ; preds = %while.body, %entry
  %i = phi i32 [ 0, %entry ], [ %inc, %while.body ]
  %cmp = icmp eq i32 %i, %N
  %inc = add i32 %i, 1
  br i1 %cmp, label %while.end, label %while.body

while.end:                                        ; preds = %while.body
  ret i32 %i
}
