; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown             | FileCheck %s
; RUN: llc < %s -mtriple=i686-unknown -mattr=sse2 | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64

define i32 @testmsws(float %x) {
; CHECK-LABEL: testmsws:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundf # TAILCALL
;
; X64-LABEL: testmsws:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp lroundf@PLT # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f32(float %x)
  ret i32 %0
}

define i32 @testmswd(double %x) {
; CHECK-LABEL: testmswd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lround # TAILCALL
;
; X64-LABEL: testmswd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp lround@PLT # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f64(double %x)
  ret i32 %0
}

define i32 @testmsll(x86_fp80 %x) {
; CHECK-LABEL: testmsll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundl # TAILCALL
;
; X64-LABEL: testmsll:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp lroundl@PLT # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f80(x86_fp80 %x)
  ret i32 %0
}

declare i32 @llvm.lround.i32.f32(float) nounwind readnone
declare i32 @llvm.lround.i32.f64(double) nounwind readnone
declare i32 @llvm.lround.i32.f80(x86_fp80) nounwind readnone
