; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK-64
; RUN: llc -mcpu=pwr9 -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK-32

define <4 x float> @_Z7testInsILj0ELj0EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj0EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj0EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj1EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj1EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj1EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 5, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj2EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj2EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj2EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 6, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj3EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj3EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj3EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 7, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj0EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj0EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj0EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj1EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj1EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj1EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj2EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj2EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj2EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 6, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj3EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj3EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj3EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 7, i32 2, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj0EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj0EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj0EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj1EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj1EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj1EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 5, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj2EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj2EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj2EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj3EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj3EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj3EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 7, i32 3>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj0EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj0EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj0EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 4>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj1EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj1EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj1EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 5>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj2EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj2EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj2EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 6>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj3EDv4_fET1_S1_S1_(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj3EDv4_fET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj3EDv4_fET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x float> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj0EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj0EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj0EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj1EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj1EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj1EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 5, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj2EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj2EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj2EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 6, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj3EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj3EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj3EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 7, i32 1, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj0EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj0EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj0EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj1EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj1EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj1EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj2EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj2EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj2EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 6, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj3EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj3EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj3EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 7, i32 2, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj0EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj0EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj0EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj1EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj1EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj1EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 5, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj2EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj2EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj2EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj3EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj3EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj3EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 7, i32 3>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj0EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj0EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj0EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 4>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj1EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj1EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj1EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 5>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj2EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj2EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj2EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 6>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj3EDv4_jET1_S1_S1_(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj3EDv4_jET1_S1_S1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj3EDv4_jET1_S1_S1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x i32> %vecins
}

define float @_Z13testUiToFpExtILj0EEfDv4_j(<4 x i32> %a) {
; CHECK-64-LABEL: _Z13testUiToFpExtILj0EEfDv4_j:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 0
; CHECK-64-NEXT:    xscvuxdsp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z13testUiToFpExtILj0EEfDv4_j:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -32(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxdsp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 0
  %conv = uitofp i32 %vecext to float
  ret float %conv
}

define float @_Z13testUiToFpExtILj1EEfDv4_j(<4 x i32> %a) {
; CHECK-64-LABEL: _Z13testUiToFpExtILj1EEfDv4_j:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 4
; CHECK-64-NEXT:    xscvuxdsp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z13testUiToFpExtILj1EEfDv4_j:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -28(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxdsp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 1
  %conv = uitofp i32 %vecext to float
  ret float %conv
}

define float @_Z13testUiToFpExtILj2EEfDv4_j(<4 x i32> %a) {
; CHECK-64-LABEL: _Z13testUiToFpExtILj2EEfDv4_j:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 8
; CHECK-64-NEXT:    xscvuxdsp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z13testUiToFpExtILj2EEfDv4_j:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -24(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxdsp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 2
  %conv = uitofp i32 %vecext to float
  ret float %conv
}

define float @_Z13testUiToFpExtILj3EEfDv4_j(<4 x i32> %a) {
; CHECK-64-LABEL: _Z13testUiToFpExtILj3EEfDv4_j:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 12
; CHECK-64-NEXT:    xscvuxdsp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z13testUiToFpExtILj3EEfDv4_j:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -20(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxdsp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 3
  %conv = uitofp i32 %vecext to float
  ret float %conv
}

; Verify we generate optimal code for unsigned vector int elem extract followed
; by conversion to double

define double @conv2dlbTestui0(<4 x i32> %a) {
; CHECK-64-LABEL: conv2dlbTestui0:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 0
; CHECK-64-NEXT:    xscvuxddp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: conv2dlbTestui0:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -32(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxddp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %0 = extractelement <4 x i32> %a, i32 0
  %1 = uitofp i32 %0 to double
  ret double %1
}

define double @conv2dlbTestui1(<4 x i32> %a) {
; CHECK-64-LABEL: conv2dlbTestui1:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 4
; CHECK-64-NEXT:    xscvuxddp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: conv2dlbTestui1:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -28(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxddp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %0 = extractelement <4 x i32> %a, i32 1
  %1 = uitofp i32 %0 to double
  ret double %1
}

define double @conv2dlbTestui2(<4 x i32> %a) {
; CHECK-64-LABEL: conv2dlbTestui2:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 8
; CHECK-64-NEXT:    xscvuxddp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: conv2dlbTestui2:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -24(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxddp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %0 = extractelement <4 x i32> %a, i32 2
  %1 = uitofp i32 %0 to double
  ret double %1
}

define double @conv2dlbTestui3(<4 x i32> %a) {
; CHECK-64-LABEL: conv2dlbTestui3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 0, 34, 12
; CHECK-64-NEXT:    xscvuxddp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: conv2dlbTestui3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwz 3, -20(1)
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxddp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %0 = extractelement <4 x i32> %a, i32 3
  %1 = uitofp i32 %0 to double
  ret double %1
}

; verify we don't crash for variable elem extract
define double @conv2dlbTestuiVar(<4 x i32> %a, i32 zeroext %elem) {
; CHECK-64-LABEL: conv2dlbTestuiVar:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    mtfprwz 0, 3
; CHECK-64-NEXT:    xscvuxddp 1, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: conv2dlbTestuiVar:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -32
; CHECK-32-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -32(1)
; CHECK-32-NEXT:    lwzx 3, 4, 3
; CHECK-32-NEXT:    stw 3, -4(1)
; CHECK-32-NEXT:    addi 3, 1, -4
; CHECK-32-NEXT:    lfiwzx 0, 0, 3
; CHECK-32-NEXT:    xscvuxddp 1, 0
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %elem
  %conv = uitofp i32 %vecext to double
  ret double %conv
}

define <4 x float> @_Z10testInsEltILj0EDv4_ffET0_S1_T1_(<4 x float> %a, float %b) {
; CHECK-64-LABEL: _Z10testInsEltILj0EDv4_ffET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xscvdpspn 0, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj0EDv4_ffET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xscvdpspn 0, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x float> %a, float %b, i32 0
  ret <4 x float> %vecins
}

define <4 x float> @_Z10testInsEltILj1EDv4_ffET0_S1_T1_(<4 x float> %a, float %b) {
; CHECK-64-LABEL: _Z10testInsEltILj1EDv4_ffET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xscvdpspn 0, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj1EDv4_ffET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xscvdpspn 0, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x float> %a, float %b, i32 1
  ret <4 x float> %vecins
}

define <4 x float> @_Z10testInsEltILj2EDv4_ffET0_S1_T1_(<4 x float> %a, float %b) {
; CHECK-64-LABEL: _Z10testInsEltILj2EDv4_ffET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xscvdpspn 0, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj2EDv4_ffET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xscvdpspn 0, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x float> %a, float %b, i32 2
  ret <4 x float> %vecins
}

define <4 x float> @_Z10testInsEltILj3EDv4_ffET0_S1_T1_(<4 x float> %a, float %b) {
; CHECK-64-LABEL: _Z10testInsEltILj3EDv4_ffET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xscvdpspn 0, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj3EDv4_ffET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xscvdpspn 0, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x float> %a, float %b, i32 3
  ret <4 x float> %vecins
}

define <4 x i32> @_Z10testInsEltILj0EDv4_jjET0_S1_T1_(<4 x i32> %a, i32 zeroext %b) {
; CHECK-64-LABEL: _Z10testInsEltILj0EDv4_jjET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mtfprwz 0, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj0EDv4_jjET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mtfprwz 0, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x i32> %a, i32 %b, i32 0
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z10testInsEltILj1EDv4_jjET0_S1_T1_(<4 x i32> %a, i32 zeroext %b) {
; CHECK-64-LABEL: _Z10testInsEltILj1EDv4_jjET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mtfprwz 0, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj1EDv4_jjET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mtfprwz 0, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x i32> %a, i32 %b, i32 1
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z10testInsEltILj2EDv4_jjET0_S1_T1_(<4 x i32> %a, i32 zeroext %b) {
; CHECK-64-LABEL: _Z10testInsEltILj2EDv4_jjET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mtfprwz 0, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj2EDv4_jjET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mtfprwz 0, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x i32> %a, i32 %b, i32 2
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z10testInsEltILj3EDv4_jjET0_S1_T1_(<4 x i32> %a, i32 zeroext %b) {
; CHECK-64-LABEL: _Z10testInsEltILj3EDv4_jjET0_S1_T1_:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mtfprwz 0, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z10testInsEltILj3EDv4_jjET0_S1_T1_:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mtfprwz 0, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x i32> %a, i32 %b, i32 3
  ret <4 x i32> %vecins
}

define <4 x float> @_Z7testInsILj0ELj0EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj0EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj0EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj1EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj1EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj1EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 1, i32 5, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj2EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj2EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj2EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 2, i32 5, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj0ELj3EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj3EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj3EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 3, i32 5, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj0EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj0EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj0EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 0, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj1EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj1EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj1EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj2EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj2EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj2EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 2, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj1ELj3EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj3EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj3EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 3, i32 6, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj0EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj0EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj0EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 0, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj1EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj1EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj1EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 1, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj2EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj2EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj2EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 2, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj2ELj3EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj3EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj3EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 3, i32 7>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj0EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj0EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj0EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 0>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj1EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj1EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj1EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 1>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj2EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj2EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj2EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 2>
  ret <4 x float> %vecins
}

define <4 x float> @_Z7testInsILj3ELj3EDv4_fET1_S1_S1_r(<4 x float> %a, <4 x float> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj3EDv4_fET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj3EDv4_fET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %b, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 3>
  ret <4 x float> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj0EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj0EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj0EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj1EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj1EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj1EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 1, i32 5, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj2EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj2EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj2EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 2, i32 5, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj0ELj3EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj0ELj3EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj0ELj3EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 3, i32 5, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj0EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj0EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj0EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 0, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj1EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj1EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj1EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj2EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj2EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj2EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 2, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj1ELj3EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj1ELj3EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj1ELj3EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 3, i32 6, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj0EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj0EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj0EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 0, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj1EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj1EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj1EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 1, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj2EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj2EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj2EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 2, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj2ELj3EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj2ELj3EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj2ELj3EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 3, i32 7>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj0EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj0EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj0EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 3
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 0>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj1EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj1EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj1EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 1>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj2EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj2EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj2EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxsldwi 0, 35, 35, 1
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 2>
  ret <4 x i32> %vecins
}

define <4 x i32> @_Z7testInsILj3ELj3EDv4_jET1_S1_S1_r(<4 x i32> %a, <4 x i32> %b) {
; CHECK-64-LABEL: _Z7testInsILj3ELj3EDv4_jET1_S1_S1_r:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 0, 35
; CHECK-64-NEXT:    xxinsertw 34, 0, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: _Z7testInsILj3ELj3EDv4_jET1_S1_S1_r:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 0, 35
; CHECK-32-NEXT:    xxinsertw 34, 0, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x i32> %b, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 6, i32 3>
  ret <4 x i32> %vecins
}
define <4 x float> @testSameVecEl0BE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl0BE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 34, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl0BE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 34, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 5, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}
define <4 x float> @testSameVecEl2BE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl2BE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 34, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl2BE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 34, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 0, i32 1, i32 5, i32 3>
  ret <4 x float> %vecins
}
define <4 x float> @testSameVecEl3BE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl3BE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 34, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl3BE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 34, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 0, i32 1, i32 2, i32 5>
  ret <4 x float> %vecins
}
define <4 x float> @testSameVecEl0LE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl0LE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxspltw 0, 34, 2
; CHECK-64-NEXT:    xxsldwi 0, 34, 0, 1
; CHECK-64-NEXT:    xxsldwi 34, 0, 0, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl0LE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxspltw 0, 34, 2
; CHECK-32-NEXT:    xxsldwi 0, 34, 0, 1
; CHECK-32-NEXT:    xxsldwi 34, 0, 0, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 6, i32 1, i32 2, i32 3>
  ret <4 x float> %vecins
}
define <4 x float> @testSameVecEl1LE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl1LE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxswapd 35, 34
; CHECK-64-NEXT:    vmrghw 2, 2, 3
; CHECK-64-NEXT:    vmrghw 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl1LE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxswapd 35, 34
; CHECK-32-NEXT:    vmrghw 2, 2, 3
; CHECK-32-NEXT:    vmrghw 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 0, i32 6, i32 2, i32 3>
  ret <4 x float> %vecins
}
define <4 x float> @testSameVecEl3LE(<4 x float> %a) {
; CHECK-64-LABEL: testSameVecEl3LE:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxspltw 0, 34, 2
; CHECK-64-NEXT:    xxswapd 1, 34
; CHECK-64-NEXT:    xxsldwi 34, 1, 0, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: testSameVecEl3LE:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxspltw 0, 34, 2
; CHECK-32-NEXT:    xxswapd 1, 34
; CHECK-32-NEXT:    xxsldwi 34, 1, 0, 2
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <4 x float> %a, <4 x float> %a, <4 x i32> <i32 0, i32 1, i32 2, i32 6>
  ret <4 x float> %vecins
}
define <4 x float> @insertVarF(<4 x float> %a, float %f, i32 %el) {
; CHECK-64-LABEL: insertVarF:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    rlwinm 3, 4, 2, 28, 29
; CHECK-64-NEXT:    addi 4, 1, -16
; CHECK-64-NEXT:    stxv 34, -16(1)
; CHECK-64-NEXT:    stfsx 1, 4, 3
; CHECK-64-NEXT:    lxv 34, -16(1)
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: insertVarF:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    rlwinm 3, 4, 2, 28, 29
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    stfsx 1, 4, 3
; CHECK-32-NEXT:    lxv 34, -16(1)
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x float> %a, float %f, i32 %el
  ret <4 x float> %vecins
}
define <4 x i32> @insertVarI(<4 x i32> %a, i32 %i, i32 %el) {
; CHECK-64-LABEL: insertVarI:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    addi 5, 1, -16
; CHECK-64-NEXT:    rlwinm 4, 4, 2, 28, 29
; CHECK-64-NEXT:    stxv 34, -16(1)
; CHECK-64-NEXT:    stwx 3, 5, 4
; CHECK-64-NEXT:    lxv 34, -16(1)
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: insertVarI:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 5, 1, -16
; CHECK-32-NEXT:    rlwinm 4, 4, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    stwx 3, 5, 4
; CHECK-32-NEXT:    lxv 34, -16(1)
; CHECK-32-NEXT:    blr
entry:
  %vecins = insertelement <4 x i32> %a, i32 %i, i32 %el
  ret <4 x i32> %vecins
}
define <4 x i32> @intrinsicInsertTest(<4 x i32> %a, <2 x i64> %b) {
; CHECK-64-LABEL: intrinsicInsertTest:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxinsertw 34, 35, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: intrinsicInsertTest:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxinsertw 34, 35, 3
; CHECK-32-NEXT:    blr
entry:
  %ans = tail call <4 x i32> @llvm.ppc.vsx.xxinsertw(<4 x i32> %a, <2 x i64> %b, i32 3)
  ret <4 x i32> %ans
}
declare <4 x i32> @llvm.ppc.vsx.xxinsertw(<4 x i32>, <2 x i64>, i32)
define <2 x i64> @intrinsicExtractTest(<2 x i64> %a) {
; CHECK-64-LABEL: intrinsicExtractTest:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    xxextractuw 34, 34, 5
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: intrinsicExtractTest:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    xxextractuw 34, 34, 5
; CHECK-32-NEXT:    blr
entry:
  %ans = tail call <2 x i64> @llvm.ppc.vsx.xxextractuw(<2 x i64> %a, i32 5)
  ret <2 x i64> %ans
}
declare <2 x i64>  @llvm.ppc.vsx.xxextractuw(<2 x i64>, i32)
