/*
 *  Copyright 1994-2013 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_PERCEPTRON_H
#define __BINIOU_PERCEPTRON_H

#include "utils.h"


typedef struct Perceptron_s {
  int layers;        /* total number of layers in the network */
  int *npl;          /* number of neurons per layer */

  float ***Weights;  /* Weight[l,i,j]: Wij (layer l-1 -> l) */
  float **Activity;  /* Activity[l,i]: activity of neuron 'i' on layer 'l' */ 
  float **Error;     /* Error[l,i]: error on the neuron 'i' on layer 'l' */
  float ***dWeights; /* for the back-propagation */

  GRand *grand;      /* PRNG */
} Perceptron_t;


Perceptron_t *Perceptron_new(int, int *, float);
void Perceptron_delete(Perceptron_t *);
void Perceptron_init(Perceptron_t *, float);
float Perceptron_FF(const Perceptron_t *, float *);
void Perceptron_BP(Perceptron_t *, float, float, float);
void Perceptron_save(const Perceptron_t *, const char *);
void Perceptron_load(Perceptron_t *, const char *);

#endif /* __BINIOU_PERCEPTRON_H */
