/*
 * Copyright © Stichting FOM.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */



/**
    \file   lcmaps_return_account_from_pem.h
    \brief  Include file for the return account from PEM interface
    \author The Nikhef Grid Security Middleware Team

    \ingroup LcmapsBasicInterface
*/


#ifndef LCMAPS_RETURN_ACCOUNT_FROM_PEM_H
#define LCMAPS_RETURN_ACCOUNT_FROM_PEM_H


/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcmaps_account.h"
#include "lcmaps_basic.h"

/**
    \brief Return the mapped account and poolindex
    If LCMAPS is invoked via this interface it will return the user account info
    and poolindex, alternatively named leaseid, to the calling application.

    \param pem_string
            The PEM-encoded string containing the user proxy
    \param mapcounter
            The counter which will be added to the poolindex, effectively enabling
            multiple account mappings
    \param plcmaps_account
            A structure that contains account information: (output)
            uid, gids (primary and secondary) and the poolindex
            Please use lcmaps_account_info_clean() to clean this
            structure after use.

    \retval 0 success.
    \retval 1 failure.
*/
typedef int
lcmaps_return_account_from_pem_t(
        char * pem_string,
        int mapcounter,
        lcmaps_account_info_t * plcmaps_account
);

/**
   The interface handle details are found in this 'implementation' header file that
   the API user should never bother to see.
*/
#include "_lcmaps_return_account_from_pem.h"

#ifndef LCMAPS_USE_DLOPEN
/**
   \brief declaration of the interface function

   The interface function needs to be declared when linking rather than dlopen()'ing.
*/
lcmaps_return_account_from_pem_t lcmaps_return_account_from_pem;
#endif /* LCMAPS_USE_DLOPEN */

/**
   \brief Opaque handle type for the interface

   The opaque handle type that the API user should declare a single instance of.
   This must be passed to nearly all macros (in OO terms, this would be a derived
   type of LCMAPS_HANDLE).
   Usage: 
   LCMAPS_HANDLE_RETURN_ACCOUNT_FROM_PEM handle;
 */
typedef _lcmaps_handle_return_account_from_pem_t LCMAPS_HANDLE_RETURN_ACCOUNT_FROM_PEM;
/* typedef void * LCMAPS_HANDLE_RETURN_ACCOUNT_FROM_PEM; */

/**
   The declarator can be used to declare and init the handle in one go.
 */
#define LCMAPS_DECL_HANDLE_RETURN_ACCOUNT_FROM_PEM(l) \
    _LCMAPS_DECL_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)

/**
   The initializer of the handle object. This macro must be called before any
   other macro using an LCMAPS_HANDLE.
   \param l An instance of LCMAPS_HANDLE_RETURN_ACCOUNT_FROM_PEM
   \retval 1 always.
 */
#define LCMAPS_INIT_HANDLE_RETURN_ACCOUNT_FROM_PEM(l) \
    _LCMAPS_INIT_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)

/**
   This macro loads and prepares LCMAPS; must be called before any 
   use of the interface functions, but after LCMAPS_INIT_HANDLE_RETURN_ACCOUNT_FROM_PEM.
   \param l an initialized handle
   \retval 0 in case of failure, inspect LCMAPS_ERRMSG(l)
   \retval 1 on success
 */
#define LCMAPS_LOAD_RETURN_ACCOUNT_FROM_PEM(l) \
    _LCMAPS_LOAD_RETURN_ACCOUNT_FROM_PEM(l)

/**
    \brief close the LCMAPS_HANDLE

    This macro closes any opened interface libraries and clears the handle.
    After this call the handle must be considered invalid. The LCMAPS_CLOSE_HANDLE
    can be found in lcmaps.h.
*/
#define LCMAPS_CLOSE_HANDLE_RETURN_ACCOUNT_FROM_PEM(l)	\
    LCMAPS_CLOSE_HANDLE(l)

#endif /* LCMAPS_RETURN_POOLINDEX_WITHOUT_GSI_H */
