/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \page lcmaps_dummy_bad.mod dummy NOT OK plugin

    \section dummysection1 The dummy bad plugin
    ALWAYS return NOT OK !
*/

/*!
    \file   lcmaps_dummy_bad.c
    \brief  Interface to the LCMAPS plugins
    \author Martijn Steenbakkers for the EU DataGrid.

    This file contains code for a dummy LCMAPS plugin that always returns NOT OK.
    the plugin has to provide to the LCMAPS. The interface consists of the following
    functions:
    -# plugin_initialize()
    -# plugin_run()
    -# plugin_terminate()
    -# plugin_introspect()
*/

/*****************************************************************************
                            Include header files
******************************************************************************/
#include "lcmaps_plugins_basic_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <lcmaps/lcmaps_modules.h>
#include <lcmaps/lcmaps_arguments.h>

/******************************************************************************
                                Definitions
******************************************************************************/

/******************************************************************************
                          Module specific prototypes
******************************************************************************/

/******************************************************************************
                       Define module specific variables
******************************************************************************/

/******************************************************************************
Function:   plugin_introspect
Description:
    return list of required arguments
Parameters:

Returns:
    LCMAPS_MOD_SUCCESS : succes
    LCMAPS_MOD_FAIL    : failure
******************************************************************************/
/*!
    \fn plugin_introspect(
        int * argc,
        lcmaps_argument_t ** argv
        )
    \brief Plugin asks for required arguments

    \param int * argc
    \param lcmaps_argument_t ** argv
    \retval LCMAPS_MOD_SUCCESS success
    \retval LCMAPS_MOD_FAIL    failure (will result in a lcmaps failure)
*/
int plugin_introspect(
        int * argc,
        lcmaps_argument_t ** argv
)
{
    char * logstr = "lcmaps_dummy_bad-plugin_introspect()";
    static lcmaps_argument_t argList[] = {
        { NULL           , NULL               , -1,   NULL}
    };

    lcmaps_log_debug(4,"%s: introspecting\n", logstr);

    *argv = argList;
    *argc = lcmaps_cntArgs(argList);
    lcmaps_log_debug(5,"%s: address first argument: 0x%x\n", logstr, argList);

    return LCMAPS_MOD_SUCCESS;
}


/******************************************************************************
Function:   plugin_initialize
Description:
    Initialize plugin
Parameters:
    argc, argv
    argv[0]: the name of the plugin
Returns:
    LCMAPS_MOD_SUCCESS : succes
    LCMAPS_MOD_FAIL    : failure
    LCMAPS_MOD_NOFILE  : db file not found (will halt LCMAPS initialization)
******************************************************************************/
/*!
    \fn plugin_initialize(
        int argc,
        char ** argv
        )
    \brief initialize the plugin.
    
    Everything that is needed to initialize the plugin should be put inside this function.
    Arguments as read from the LCMAPS database (argc, argv) are passed to the plugin.

    \param argc number of passed arguments.
    \param argv argument list. argv[0] contains the name of the plugin.
    \retval LCMAPS_MOD_SUCCESS successful initialization
    \retval LCMAPS_MOD_FAIL    failure in the plugin initialization
    \retval LCMAPS_MOD_NOFILE  private plugin database could not be found (same effect as
                             LCMAPS_MOD_FAIL)
*/
int plugin_initialize(
        int argc,
        char ** argv
)
{
    char * logstr = "lcmaps_dummy_bad-plugin_initialize()";
    int i;

    lcmaps_log_debug(5,"%s: passed arguments:\n", logstr);
    for (i=0; i < argc; i++)
    {
        lcmaps_log_debug(5,"%s: arg %d is %s\n", logstr, i,argv[i]);
    }

    return LCMAPS_MOD_SUCCESS;
}

/******************************************************************************
Function:   plugin_run
Description:
    Gather credentials for LCMAPS
Parameters:
    argc: number of arguments
    argv: list of arguments
Returns:
    LCMAPS_MOD_SUCCESS: authorization succeeded
    LCMAPS_MOD_FAIL   : authorization failed
******************************************************************************/
/*!
    \fn plugin_run(
        int argc,
        lcmaps_argument_t * argv
        )
    \brief Gather credentials for user making use of the ordered arguments

    Ask for credentials by passing the arguments (like JDL, globus DN, VOMS roles etc.)
    that were ordered earlier by the plugin_introspect() function

    \param argc number of arguments
    \param argv list of arguments
    \retval LCMAPS_MOD_SUCCESS authorization succeeded
    \retval LCMAPS_MOD_FAIL    authorization failed
*/
int plugin_run(
        int argc,
        lcmaps_argument_t * argv
)
{
    char * logstr = "lcmaps_dummy_bad-plugin_run()";

    lcmaps_log_debug(5,"%s:\n", logstr);
    lcmaps_log(LOG_INFO, "%s: bad plugin successfully failed by design\n", logstr);

    return LCMAPS_MOD_FAIL;
}

/******************************************************************************
Function:   plugin_verify
Description:
    Verify credentials for LCMAPS
Parameters:
    argc: number of arguments
    argv: list of arguments
Returns:
    LCMAPS_MOD_SUCCESS: authorization succeeded
    LCMAPS_MOD_FAIL   : authorization failed
******************************************************************************/
/*!
    \fn plugin_verify(
        int argc,
        lcmaps_argument_t * argv
        )
    \brief Verify credentials for user making use of the ordered arguments

    Ask for credentials by passing the arguments (like JDL, globus DN, VOMS roles etc.)
    that were ordered earlier by the plugin_introspect() function and verify the right
    to use a certain account

    \param argc number of arguments
    \param argv list of arguments
    \retval LCMAPS_MOD_SUCCESS authorization succeeded
    \retval LCMAPS_MOD_FAIL    authorization failed
*/
int plugin_verify(
        int argc,
        lcmaps_argument_t * argv
)
{
    char * logstr = "lcmaps_dummy_bad-plugin_verify()";

    lcmaps_log_debug(5,"%s:\n", logstr);

    return LCMAPS_MOD_FAIL;
}

/******************************************************************************
Function:   plugin_terminate
Description:
    Terminate plugin
Parameters:

Returns:
    LCMAPS_MOD_SUCCESS : succes
    LCMAPS_MOD_FAIL    : failure
******************************************************************************/
/*!
    \fn plugin_terminate()
    \brief Whatever is needed to terminate the plugin module goes in here.
    \retval LCMAPS_MOD_SUCCESS success
    \retval LCMAPS_MOD_FAIL    failure (will result in an authorization failure)
*/
int plugin_terminate()
{
    char * logstr = "lcmaps_dummy_bad-plugin_terminate()";
    lcmaps_log_debug(5,"%s: terminating\n", logstr);

    return LCMAPS_MOD_SUCCESS;
}

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps-plugins-basic/src/dummy/lcmaps_dummy_bad.c,v $
    $Date: 2010-02-19 06:08:47 $
    $Revision: 1.5 $
    $Author: okoeroo $
******************************************************************************/
