/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.intentions;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/intentions/loopToCallChain")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IntentionTest2Generated extends AbstractIntentionTest2 {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInLoopToCallChain() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("array.kt")
    public void testArray() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/array.kt");
    }

    @TestMetadata("asSequenceOnly.kt")
    public void testAsSequenceOnly() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/asSequenceOnly.kt");
    }

    @TestMetadata("customTypeWithIterator.kt")
    public void testCustomTypeWithIterator() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/customTypeWithIterator.kt");
    }

    @TestMetadata("embeddedBreak1.kt")
    public void testEmbeddedBreak1() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/embeddedBreak1.kt");
    }

    @TestMetadata("embeddedBreak2.kt")
    public void testEmbeddedBreak2() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/embeddedBreak2.kt");
    }

    @TestMetadata("embeddedContinue.kt")
    public void testEmbeddedContinue() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/embeddedContinue.kt");
    }

    @TestMetadata("intArray.kt")
    public void testIntArray() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/intArray.kt");
    }

    @TestMetadata("itAlreadyUsed.kt")
    public void testItAlreadyUsed() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/itAlreadyUsed.kt");
    }

    @TestMetadata("KT14191.kt")
    public void testKT14191() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/KT14191.kt");
    }

    @TestMetadata("lastOrNull_ifAssign.kt")
    public void testLastOrNull_ifAssign() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/lastOrNull_ifAssign.kt");
    }

    @TestMetadata("moveInitializationsCloserToLoop.kt")
    public void testMoveInitializationsCloserToLoop() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/moveInitializationsCloserToLoop.kt");
    }

    @TestMetadata("range.kt")
    public void testRange() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/range.kt");
    }

    @TestMetadata("twoInitializationsBeforeLoop.kt")
    public void testTwoInitializationsBeforeLoop() throws Exception {
        runTest("idea/testData/intentions/loopToCallChain/twoInitializationsBeforeLoop.kt");
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/any")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Any extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAny() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/any"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anyNotNull.kt")
        public void testAnyNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/anyNotNull.kt");
        }

        @TestMetadata("ifAssign.kt")
        public void testIfAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign.kt");
        }

        @TestMetadata("ifAssign_moveDeclaration.kt")
        public void testIfAssign_moveDeclaration() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_moveDeclaration.kt");
        }

        @TestMetadata("ifAssign_moveInitialization.kt")
        public void testIfAssign_moveInitialization() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_moveInitialization.kt");
        }

        @TestMetadata("ifAssign_noBreak.kt")
        public void testIfAssign_noBreak() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_noBreak.kt");
        }

        @TestMetadata("ifAssign_nonBooleanResult.kt")
        public void testIfAssign_nonBooleanResult() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult.kt");
        }

        @TestMetadata("ifAssign_nonBooleanResult2.kt")
        public void testIfAssign_nonBooleanResult2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult2.kt");
        }

        @TestMetadata("ifReturn.kt")
        public void testIfReturn() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifReturn.kt");
        }

        @TestMetadata("ifReturn_nonBooleanResult.kt")
        public void testIfReturn_nonBooleanResult() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/ifReturn_nonBooleanResult.kt");
        }

        @TestMetadata("indexNeeded.kt")
        public void testIndexNeeded() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/indexNeeded.kt");
        }

        @TestMetadata("KT13998.kt")
        public void testKT13998() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/KT13998.kt");
        }

        @TestMetadata("KT13998_1.kt")
        public void testKT13998_1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/KT13998_1.kt");
        }

        @TestMetadata("kt17730.kt")
        public void testKt17730() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/kt17730.kt");
        }

        @TestMetadata("kt17730_1.kt")
        public void testKt17730_1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/kt17730_1.kt");
        }

        @TestMetadata("none.kt")
        public void testNone() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/none.kt");
        }

        @TestMetadata("return.kt")
        public void testReturn() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/any/return.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/contains")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contains extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("1.kt")
        public void test1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/contains/1.kt");
        }

        @TestMetadata("2.kt")
        public void test2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/contains/2.kt");
        }

        @TestMetadata("3.kt")
        public void test3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/contains/3.kt");
        }

        @TestMetadata("4.kt")
        public void test4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/contains/4.kt");
        }

        public void testAllFilesPresentInContains() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/contains"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/count")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Count extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("1.kt")
        public void test1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/1.kt");
        }

        @TestMetadata("2.kt")
        public void test2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/2.kt");
        }

        public void testAllFilesPresentInCount() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/count"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("countIsInstance.kt")
        public void testCountIsInstance() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/countIsInstance.kt");
        }

        @TestMetadata("countNotNull.kt")
        public void testCountNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/countNotNull.kt");
        }

        @TestMetadata("countSomethingAndNotNull.kt")
        public void testCountSomethingAndNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/countSomethingAndNotNull.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/long.kt");
        }

        @TestMetadata("nonConstantInitial.kt")
        public void testNonConstantInitial() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/nonConstantInitial.kt");
        }

        @TestMetadata("nonZeroInitial.kt")
        public void testNonZeroInitial() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/nonZeroInitial.kt");
        }

        @TestMetadata("prefix.kt")
        public void testPrefix() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/prefix.kt");
        }

        @TestMetadata("variableUsedBefore.kt")
        public void testVariableUsedBefore() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/count/variableUsedBefore.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/filter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Filter extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFilter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/filter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assign.kt")
        public void testAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign.kt");
        }

        @TestMetadata("assign2.kt")
        public void testAssign2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign2.kt");
        }

        @TestMetadata("assignFilterIndexed.kt")
        public void testAssignFilterIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assignFilterIndexed.kt");
        }

        @TestMetadata("assignFilterNotNull.kt")
        public void testAssignFilterNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assignFilterNotNull.kt");
        }

        @TestMetadata("assign_ArrayListRequired.kt")
        public void testAssign_ArrayListRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired.kt");
        }

        @TestMetadata("assign_ArrayListRequired2.kt")
        public void testAssign_ArrayListRequired2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired2.kt");
        }

        @TestMetadata("assign_ArrayListRequired3.kt")
        public void testAssign_ArrayListRequired3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired3.kt");
        }

        @TestMetadata("assign_MutableListRequired.kt")
        public void testAssign_MutableListRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign_MutableListRequired.kt");
        }

        @TestMetadata("assign_breakAndContinue.kt")
        public void testAssign_breakAndContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/assign_breakAndContinue.kt");
        }

        @TestMetadata("cannotSplitOutFilterIsInstance.kt")
        public void testCannotSplitOutFilterIsInstance() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/cannotSplitOutFilterIsInstance.kt");
        }

        @TestMetadata("doNotSplitOutFilterIsInstance.kt")
        public void testDoNotSplitOutFilterIsInstance() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterIsInstance.kt");
        }

        @TestMetadata("doNotSplitOutFilterNotNull.kt")
        public void testDoNotSplitOutFilterNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterNotNull.kt");
        }

        @TestMetadata("filterIndexed.kt")
        public void testFilterIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed.kt");
        }

        @TestMetadata("filterIndexed2.kt")
        public void testFilterIndexed2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed2.kt");
        }

        @TestMetadata("filterIndexedAndFlatMapWithContinue.kt")
        public void testFilterIndexedAndFlatMapWithContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedAndFlatMapWithContinue.kt");
        }

        @TestMetadata("filterIndexedTo.kt")
        public void testFilterIndexedTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo.kt");
        }

        @TestMetadata("filterIndexedTo2.kt")
        public void testFilterIndexedTo2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo2.kt");
        }

        @TestMetadata("filterIndexed_indexChangedTwice.kt")
        public void testFilterIndexed_indexChangedTwice() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexChangedTwice.kt");
        }

        @TestMetadata("filterIndexed_indexStartNotZero.kt")
        public void testFilterIndexed_indexStartNotZero() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexStartNotZero.kt");
        }

        @TestMetadata("filterIndexed_indexUsedAfter.kt")
        public void testFilterIndexed_indexUsedAfter() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedAfter.kt");
        }

        @TestMetadata("filterIndexed_indexUsedEarlierInLoop.kt")
        public void testFilterIndexed_indexUsedEarlierInLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedEarlierInLoop.kt");
        }

        @TestMetadata("filterIndexed_merge1.kt")
        public void testFilterIndexed_merge1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge1.kt");
        }

        @TestMetadata("filterIndexed_merge2.kt")
        public void testFilterIndexed_merge2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge2.kt");
        }

        @TestMetadata("filterIndexed_merge3.kt")
        public void testFilterIndexed_merge3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge3.kt");
        }

        @TestMetadata("filterIndexed_merge4.kt")
        public void testFilterIndexed_merge4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge4.kt");
        }

        @TestMetadata("filterIndexed_twoIndices.kt")
        public void testFilterIndexed_twoIndices() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndices.kt");
        }

        @TestMetadata("filterIndexed_twoIndicesUsed.kt")
        public void testFilterIndexed_twoIndicesUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndicesUsed.kt");
        }

        @TestMetadata("filterIsInstance.kt")
        public void testFilterIsInstance() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstance.kt");
        }

        @TestMetadata("filterIsInstanceTo.kt")
        public void testFilterIsInstanceTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstanceTo.kt");
        }

        @TestMetadata("filterIsInstance_ifContinue.kt")
        public void testFilterIsInstance_ifContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstance_ifContinue.kt");
        }

        @TestMetadata("filterNotNull.kt")
        public void testFilterNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNull.kt");
        }

        @TestMetadata("filterNotNullTo.kt")
        public void testFilterNotNullTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo.kt");
        }

        @TestMetadata("filterNotNullTo2.kt")
        public void testFilterNotNullTo2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo2.kt");
        }

        @TestMetadata("filterNotNull_ifContinue.kt")
        public void testFilterNotNull_ifContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNull_ifContinue.kt");
        }

        @TestMetadata("filterNotTo.kt")
        public void testFilterNotTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNotTo.kt");
        }

        @TestMetadata("filterNot_ifContinue.kt")
        public void testFilterNot_ifContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterNot_ifContinue.kt");
        }

        @TestMetadata("filterTo.kt")
        public void testFilterTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterTo.kt");
        }

        @TestMetadata("filterTo2.kt")
        public void testFilterTo2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/filterTo2.kt");
        }

        @TestMetadata("glueTogetherFilterNotNull.kt")
        public void testGlueTogetherFilterNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/glueTogetherFilterNotNull.kt");
        }

        @TestMetadata("ifContinue.kt")
        public void testIfContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/ifContinue.kt");
        }

        @TestMetadata("ifContinue2.kt")
        public void testIfContinue2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/ifContinue2.kt");
        }

        @TestMetadata("ifContinueInBlock.kt")
        public void testIfContinueInBlock() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/ifContinueInBlock.kt");
        }

        @TestMetadata("ifContinueWithLabel.kt")
        public void testIfContinueWithLabel() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/ifContinueWithLabel.kt");
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/ifElse.kt");
        }

        @TestMetadata("inputVarNotUsed.kt")
        public void testInputVarNotUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/inputVarNotUsed.kt");
        }

        @TestMetadata("inputVariableNotUsed.kt")
        public void testInputVariableNotUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/inputVariableNotUsed.kt");
        }

        @TestMetadata("mergeMultiple.kt")
        public void testMergeMultiple() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/mergeMultiple.kt");
        }

        @TestMetadata("splitOutFilterIsInstance.kt")
        public void testSplitOutFilterIsInstance() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterIsInstance.kt");
        }

        @TestMetadata("splitOutFilterNotNull.kt")
        public void testSplitOutFilterNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull.kt");
        }

        @TestMetadata("splitOutFilterNotNull2.kt")
        public void testSplitOutFilterNotNull2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull2.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/firstOrNull")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FirstOrNull extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFirstOrNull() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/firstOrNull"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignmentInitialization.kt")
        public void testAssignmentInitialization() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/assignmentInitialization.kt");
        }

        @TestMetadata("cannotUseLet.kt")
        public void testCannotUseLet() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/cannotUseLet.kt");
        }

        @TestMetadata("ifAssign.kt")
        public void testIfAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign.kt");
        }

        @TestMetadata("ifAssign_breakWithLabel.kt")
        public void testIfAssign_breakWithLabel() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_breakWithLabel.kt");
        }

        @TestMetadata("ifAssign_cannotBeVal.kt")
        public void testIfAssign_cannotBeVal() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_cannotBeVal.kt");
        }

        @TestMetadata("ifAssign_preserveComments.kt")
        public void testIfAssign_preserveComments() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_preserveComments.kt");
        }

        @TestMetadata("ifAssign_variableUsedBefore.kt")
        public void testIfAssign_variableUsedBefore() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_variableUsedBefore.kt");
        }

        @TestMetadata("ifReturn.kt")
        public void testIfReturn() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifReturn.kt");
        }

        @TestMetadata("KT14292.kt")
        public void testKT14292() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/KT14292.kt");
        }

        @TestMetadata("let.kt")
        public void testLet() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/let.kt");
        }

        @TestMetadata("let2.kt")
        public void testLet2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/let2.kt");
        }

        @TestMetadata("letOrNotNull.kt")
        public void testLetOrNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/letOrNotNull.kt");
        }

        @TestMetadata("return.kt")
        public void testReturn() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/return.kt");
        }

        @TestMetadata("returnExpression.kt")
        public void testReturnExpression() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpression.kt");
        }

        @TestMetadata("returnExpressionOrNotNull.kt")
        public void testReturnExpressionOrNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpressionOrNotNull.kt");
        }

        @TestMetadata("returnNotNullIfNone.kt")
        public void testReturnNotNullIfNone() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone.kt");
        }

        @TestMetadata("returnNotNullIfNone2.kt")
        public void testReturnNotNullIfNone2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone2.kt");
        }

        @TestMetadata("return_comment.kt")
        public void testReturn_comment() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/return_comment.kt");
        }

        @TestMetadata("safeDotExpression.kt")
        public void testSafeDotExpression() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/safeDotExpression.kt");
        }

        @TestMetadata("withMergedFilter.kt")
        public void testWithMergedFilter() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/firstOrNull/withMergedFilter.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/flatMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FlatMap extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFlatMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/flatMap"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("break.kt")
        public void testBreak() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/break.kt");
        }

        @TestMetadata("continue.kt")
        public void testContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/continue.kt");
        }

        @TestMetadata("flatMapTo.kt")
        public void testFlatMapTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo.kt");
        }

        @TestMetadata("flatMapTo2.kt")
        public void testFlatMapTo2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo2.kt");
        }

        @TestMetadata("flatMapTo3.kt")
        public void testFlatMapTo3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo3.kt");
        }

        @TestMetadata("indexUsed.kt")
        public void testIndexUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/indexUsed.kt");
        }

        @TestMetadata("inputVarStillNeeded.kt")
        public void testInputVarStillNeeded() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/inputVarStillNeeded.kt");
        }

        @TestMetadata("notIterable.kt")
        public void testNotIterable() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/notIterable.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/simple.kt");
        }

        @TestMetadata("wrongBreak.kt")
        public void testWrongBreak() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/wrongBreak.kt");
        }

        @TestMetadata("wrongContinue.kt")
        public void testWrongContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/flatMap/wrongContinue.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/forEach")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ForEach extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInForEach() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/forEach"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("indexed.kt")
        public void testIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/indexed.kt");
        }

        @TestMetadata("indexed_nothingElse.kt")
        public void testIndexed_nothingElse() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/indexed_nothingElse.kt");
        }

        @TestMetadata("KT14341.kt")
        public void testKT14341() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/KT14341.kt");
        }

        @TestMetadata("KT21083.kt")
        public void testKT21083() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/KT21083.kt");
        }

        @TestMetadata("notAvailable.kt")
        public void testNotAvailable() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/notAvailable.kt");
        }

        @TestMetadata("notIndexed.kt")
        public void testNotIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/notIndexed.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/forEach/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/indexOf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IndexOf extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIndexOf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/indexOf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("indexOf.kt")
        public void testIndexOf() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOf.kt");
        }

        @TestMetadata("indexOfFirst_ifAssign.kt")
        public void testIndexOfFirst_ifAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifAssign.kt");
        }

        @TestMetadata("indexOfFirst_ifReturn.kt")
        public void testIndexOfFirst_ifReturn() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifReturn.kt");
        }

        @TestMetadata("indexOfFirst_mustBeNoIndexInCondition.kt")
        public void testIndexOfFirst_mustBeNoIndexInCondition() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_mustBeNoIndexInCondition.kt");
        }

        @TestMetadata("indexOfLast_ifAssign.kt")
        public void testIndexOfLast_ifAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfLast_ifAssign.kt");
        }

        @TestMetadata("KT14303.kt")
        public void testKT14303() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/KT14303.kt");
        }

        @TestMetadata("lastIndexOf.kt")
        public void testLastIndexOf() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/indexOf/lastIndexOf.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/introduceIndex")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceIndex extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIntroduceIndex() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/introduceIndex"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("indexPlusPlusInsideExpression.kt")
        public void testIndexPlusPlusInsideExpression() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression.kt");
        }

        @TestMetadata("indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt")
        public void testIndexPlusPlusInsideExpression_indexUsedAfterIncrement() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt");
        }

        @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt")
        public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt");
        }

        @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt")
        public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt");
        }

        @TestMetadata("indexPlusPlusIsNotLastStatement.kt")
        public void testIndexPlusPlusIsNotLastStatement() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement.kt");
        }

        @TestMetadata("indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt")
        public void testIndexPlusPlusIsNotLastStatement_indexUsedAfterIncrement() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt");
        }

        @TestMetadata("indexWithNestedLoop.kt")
        public void testIndexWithNestedLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexWithNestedLoop.kt");
        }

        @TestMetadata("prefixIndexPlusPlusInsideExpression.kt")
        public void testPrefixIndexPlusPlusInsideExpression() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/introduceIndex/prefixIndexPlusPlusInsideExpression.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/map")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Map extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/map"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignMap.kt")
        public void testAssignMap() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/assignMap.kt");
        }

        @TestMetadata("assignMap2.kt")
        public void testAssignMap2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/assignMap2.kt");
        }

        @TestMetadata("KT18816.kt")
        public void testKT18816() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/KT18816.kt");
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/map.kt");
        }

        @TestMetadata("mapAndFilterIndexed.kt")
        public void testMapAndFilterIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapAndFilterIndexed.kt");
        }

        @TestMetadata("mapIndexed.kt")
        public void testMapIndexed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed.kt");
        }

        @TestMetadata("mapIndexedNotNull.kt")
        public void testMapIndexedNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull.kt");
        }

        @TestMetadata("mapIndexedNotNullTo.kt")
        public void testMapIndexedNotNullTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo.kt");
        }

        @TestMetadata("mapIndexedNotNullTo_elvisContinue.kt")
        public void testMapIndexedNotNullTo_elvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo_elvisContinue.kt");
        }

        @TestMetadata("mapIndexedNotNull_elvisContinue.kt")
        public void testMapIndexedNotNull_elvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull_elvisContinue.kt");
        }

        @TestMetadata("mapIndexedTo.kt")
        public void testMapIndexedTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedTo.kt");
        }

        @TestMetadata("mapIndexed_afterFilter.kt")
        public void testMapIndexed_afterFilter() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed_afterFilter.kt");
        }

        @TestMetadata("mapIndexed_twice.kt")
        public void testMapIndexed_twice() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed_twice.kt");
        }

        @TestMetadata("mapNotNull.kt")
        public void testMapNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull.kt");
        }

        @TestMetadata("mapNotNullTo.kt")
        public void testMapNotNullTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNullTo.kt");
        }

        @TestMetadata("mapNotNullTo_elvisContinue.kt")
        public void testMapNotNullTo_elvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNullTo_elvisContinue.kt");
        }

        @TestMetadata("mapNotNull_elvisContinue.kt")
        public void testMapNotNull_elvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_elvisContinue.kt");
        }

        @TestMetadata("mapNotNull_nestedLoopElvisContinue.kt")
        public void testMapNotNull_nestedLoopElvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_nestedLoopElvisContinue.kt");
        }

        @TestMetadata("mapNotNull_wrongElvisContinue.kt")
        public void testMapNotNull_wrongElvisContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_wrongElvisContinue.kt");
        }

        @TestMetadata("mapTo.kt")
        public void testMapTo() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapTo.kt");
        }

        @TestMetadata("mapTo2.kt")
        public void testMapTo2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapTo2.kt");
        }

        @TestMetadata("mapTo3.kt")
        public void testMapTo3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapTo3.kt");
        }

        @TestMetadata("mapTo4.kt")
        public void testMapTo4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapTo4.kt");
        }

        @TestMetadata("mapTo_inputVarNotUsed.kt")
        public void testMapTo_inputVarNotUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapTo_inputVarNotUsed.kt");
        }

        @TestMetadata("mapUsesOldIndexAfterFilter.kt")
        public void testMapUsesOldIndexAfterFilter() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapUsesOldIndexAfterFilter.kt");
        }

        @TestMetadata("mapVar.kt")
        public void testMapVar() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/mapVar.kt");
        }

        @TestMetadata("map_var.kt")
        public void testMap_var() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/map_var.kt");
        }

        @TestMetadata("map_variableStillNeeded.kt")
        public void testMap_variableStillNeeded() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/map/map_variableStillNeeded.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/maxMin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MaxMin extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMaxMin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/maxMin"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("KT14210.kt")
        public void testKT14210() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/KT14210.kt");
        }

        @TestMetadata("max1.kt")
        public void testMax1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max1.kt");
        }

        @TestMetadata("max2.kt")
        public void testMax2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max2.kt");
        }

        @TestMetadata("max3.kt")
        public void testMax3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max3.kt");
        }

        @TestMetadata("max4.kt")
        public void testMax4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max4.kt");
        }

        @TestMetadata("max5.kt")
        public void testMax5() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max5.kt");
        }

        @TestMetadata("max6.kt")
        public void testMax6() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max6.kt");
        }

        @TestMetadata("max7.kt")
        public void testMax7() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/max7.kt");
        }

        @TestMetadata("min1.kt")
        public void testMin1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/min1.kt");
        }

        @TestMetadata("min2.kt")
        public void testMin2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/min2.kt");
        }

        @TestMetadata("min3.kt")
        public void testMin3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/min3.kt");
        }

        @TestMetadata("min4.kt")
        public void testMin4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/min4.kt");
        }

        @TestMetadata("min5.kt")
        public void testMin5() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/maxMin/min5.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/smartCasts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SmartCasts extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSmartCasts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/smartCasts"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("errorOutsideLoop.kt")
        public void testErrorOutsideLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/errorOutsideLoop.kt");
        }

        @TestMetadata("smartCastNotBroken.kt")
        public void testSmartCastNotBroken() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken.kt");
        }

        @TestMetadata("smartCastNotBroken2.kt")
        public void testSmartCastNotBroken2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken2.kt");
        }

        @TestMetadata("smartCastNotBroken3.kt")
        public void testSmartCastNotBroken3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken3.kt");
        }

        @TestMetadata("smartCastNotBroken4.kt")
        public void testSmartCastNotBroken4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken4.kt");
        }

        @TestMetadata("smartCastNotBroken5.kt")
        public void testSmartCastNotBroken5() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken5.kt");
        }

        @TestMetadata("smartCastNotNullRequired.kt")
        public void testSmartCastNotNullRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotNullRequired.kt");
        }

        @TestMetadata("smartCastNotRequired.kt")
        public void testSmartCastNotRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotRequired.kt");
        }

        @TestMetadata("smartCastRequired.kt")
        public void testSmartCastRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired.kt");
        }

        @TestMetadata("smartCastRequired2.kt")
        public void testSmartCastRequired2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired2.kt");
        }

        @TestMetadata("smartCastRequired3.kt")
        public void testSmartCastRequired3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired3.kt");
        }

        @TestMetadata("smartCastRequired4.kt")
        public void testSmartCastRequired4() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired4.kt");
        }

        @TestMetadata("smartCastRequired5.kt")
        public void testSmartCastRequired5() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired5.kt");
        }

        @TestMetadata("smartCastRequired6.kt")
        public void testSmartCastRequired6() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired6.kt");
        }

        @TestMetadata("smartCastThisRequired.kt")
        public void testSmartCastThisRequired() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastThisRequired.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/sum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Sum extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/sum"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("bytes.kt")
        public void testBytes() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/bytes.kt");
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/doubles.kt");
        }

        @TestMetadata("floats.kt")
        public void testFloats() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/floats.kt");
        }

        @TestMetadata("floatsIntoDouble.kt")
        public void testFloatsIntoDouble() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/floatsIntoDouble.kt");
        }

        @TestMetadata("indexUsed.kt")
        public void testIndexUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/indexUsed.kt");
        }

        @TestMetadata("indexUsed2.kt")
        public void testIndexUsed2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/indexUsed2.kt");
        }

        @TestMetadata("ints.kt")
        public void testInts() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/ints.kt");
        }

        @TestMetadata("longs.kt")
        public void testLongs() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/longs.kt");
        }

        @TestMetadata("nonNumbers.kt")
        public void testNonNumbers() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/nonNumbers.kt");
        }

        @TestMetadata("nonZeroInitial.kt")
        public void testNonZeroInitial() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/nonZeroInitial.kt");
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/short.kt");
        }

        @TestMetadata("smartCast.kt")
        public void testSmartCast() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/smartCast.kt");
        }

        @TestMetadata("smartCastNotNull.kt")
        public void testSmartCastNotNull() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/smartCastNotNull.kt");
        }

        @TestMetadata("sumByDouble.kt")
        public void testSumByDouble() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/sumByDouble.kt");
        }

        @TestMetadata("sumByInts.kt")
        public void testSumByInts() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/sumByInts.kt");
        }

        @TestMetadata("sumByIntsIntoLong.kt")
        public void testSumByIntsIntoLong() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/sumByIntsIntoLong.kt");
        }

        @TestMetadata("sumByShorts.kt")
        public void testSumByShorts() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/sum/sumByShorts.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/takeWhile")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TakeWhile extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTakeWhile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/takeWhile"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifElse1.kt")
        public void testIfElse1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/takeWhile/ifElse1.kt");
        }

        @TestMetadata("ifElse2.kt")
        public void testIfElse2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/takeWhile/ifElse2.kt");
        }

        @TestMetadata("nestedLoop.kt")
        public void testNestedLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/takeWhile/nestedLoop.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/takeWhile/simple.kt");
        }

        @TestMetadata("wrongBreak.kt")
        public void testWrongBreak() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/takeWhile/wrongBreak.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain/toCollection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToCollection extends AbstractIntentionTest2 {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addAfterLoop.kt")
        public void testAddAfterLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/addAfterLoop.kt");
        }

        @TestMetadata("addToCollection.kt")
        public void testAddToCollection() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/addToCollection.kt");
        }

        public void testAllFilesPresentInToCollection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/toCollection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("badReceiver1.kt")
        public void testBadReceiver1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/badReceiver1.kt");
        }

        @TestMetadata("badReceiver2.kt")
        public void testBadReceiver2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/badReceiver2.kt");
        }

        @TestMetadata("explicitValType.kt")
        public void testExplicitValType() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/explicitValType.kt");
        }

        @TestMetadata("goodReceiver.kt")
        public void testGoodReceiver() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/goodReceiver.kt");
        }

        @TestMetadata("KT18881.kt")
        public void testKT18881() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/KT18881.kt");
        }

        @TestMetadata("resultCollectionUsedInsideLoop.kt")
        public void testResultCollectionUsedInsideLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/resultCollectionUsedInsideLoop.kt");
        }

        @TestMetadata("toList.kt")
        public void testToList() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toList.kt");
        }

        @TestMetadata("toList2.kt")
        public void testToList2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toList2.kt");
        }

        @TestMetadata("toList3.kt")
        public void testToList3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toList3.kt");
        }

        @TestMetadata("toMutableSet.kt")
        public void testToMutableSet() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet.kt");
        }

        @TestMetadata("toMutableSet2.kt")
        public void testToMutableSet2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet2.kt");
        }

        @TestMetadata("toMutableSet3.kt")
        public void testToMutableSet3() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet3.kt");
        }

        @TestMetadata("toSet.kt")
        public void testToSet() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toSet.kt");
        }

        @TestMetadata("toSetWithMap.kt")
        public void testToSetWithMap() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/toCollection/toSetWithMap.kt");
        }
    }
}
