/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "compactosd.h"

#include <QLabel>

CompactOsd::CompactOsd()
    : Osd()
{
    QGraphicsWidget *widget = new QGraphicsWidget();
    QGraphicsScene *scene = new QGraphicsScene(this);
    scene->addItem(widget);

    setGraphicsWidget(widget);

    m_icon = new Plasma::Label(widget);
    m_icon->setScaledContents(false);
    m_icon->setMaximumSize(QSizeF(24, 22));
    m_icon->setMinimumSize(QSizeF(24, 22));

    m_meter = new Plasma::Meter(widget);
    m_meter->setMeterType(Plasma::Meter::BarMeterHorizontal);
    m_meter->setMaximumHeight(20);
    m_meter->setMinimumHeight(20);

    m_layout = new QGraphicsLinearLayout(Qt::Horizontal, widget);
    m_layout->setContentsMargins(0, 0, 0, 0);
    m_layout->setMaximumWidth(260);
    m_layout->setMinimumWidth(260);
    m_layout->addItem(m_icon);
    m_layout->addItem(m_meter);
    m_layout->setAlignment(m_meter, Qt::AlignVCenter);
}


CompactOsd::~CompactOsd()
{
}


QSize CompactOsd::requestedPixmapSize() const
{
    return m_icon->size().toSize();
}


void CompactOsd::setContents(const QPixmap &pixmap, const QString&, unsigned char percent)
{
    m_icon->nativeWidget()->setPixmap(pixmap);
    m_meter->setValue(percent);
}
