/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#include "xml.h"

char* welcome_token_exchange()
{
    // <auth type="token-welcome-exchange">
    // <token>JLKJLKJDS</token></auth>
    xmlNodePtr n;
    xmlNodePtr m;
    xmlDocPtr doc;
    xmlChar *xmlbuff;
    int buffersize;

    doc = xmlNewDoc(BAD_CAST "1.0");
    n = xmlNewNode(NULL, BAD_CAST "auth");
    m = xmlNewNode(NULL, BAD_CAST "token");
    xmlAddChild(n, m);

    xmlSetProp(n, (xmlChar*)"type",
               (xmlChar*)"token-welcome-exchange");

    int i = 0;
    char random[21];
    for (i = 0; i < 21; i++) {
        char c = (char)(rand() % 26+65);
        random[i] = c;
    }
    random[21] ='\0';

    xmlNodeSetContent(m, BAD_CAST random);
    xmlDocSetRootElement(doc, n);

    xmlDocDumpFormatMemory(doc, &xmlbuff, &buffersize, 1);
    printf("%s", (char *) xmlbuff);

    xmlFreeDoc(doc);
    return (char *) xmlbuff;
}

char* rsa_public_key_exchange(char* public_key)
{
    // <auth type="key-exchange"><key>
    // dqsdqsdmqskdlkqsdlkqji</key></auth>
    xmlNodePtr n;
    xmlNodePtr m;
    xmlDocPtr doc;
    xmlChar *xmlbuff;
    int buffersize;

    doc = xmlNewDoc(BAD_CAST "1.0");
    n = xmlNewNode(NULL, BAD_CAST "auth");
    m = xmlNewNode(NULL, BAD_CAST "key");
    xmlAddChild(n, m);

    xmlSetProp(n, (xmlChar*)"type",
               (xmlChar*)"key-exchange");

    xmlNodeAddContent(m, BAD_CAST public_key);
    xmlDocSetRootElement(doc, n);

    xmlDocDumpFormatMemory(doc, &xmlbuff,
                           &buffersize, 1);
    printf("%s", (char *) xmlbuff);

    xmlFreeDoc(doc);
    return (char *) xmlbuff;
}

char* password_exchange(char* hash)
{
    // <auth type="password"><hash>[password +
    // Token hash]</hash></auth>
    xmlNodePtr n;
    xmlNodePtr m;
    xmlDocPtr doc;
    xmlChar *xmlbuff;
    int buffersize;

    doc = xmlNewDoc(BAD_CAST "1.0");
    n = xmlNewNode(NULL, BAD_CAST "auth");
    m = xmlNewNode(NULL, BAD_CAST "hash");
    xmlAddChild(n, m);

    xmlSetProp(n, (xmlChar*)"type",
               (xmlChar*)"password");

    xmlNodeSetContent(m, BAD_CAST hash);
    xmlDocSetRootElement(doc, n);

    xmlDocDumpFormatMemory(doc, &xmlbuff,
                           &buffersize, 1);
    printf("%s", (char *) xmlbuff);

    xmlFreeDoc(doc);
    return (char *) xmlbuff;
}

char* symetric_key_exchange(char key[])
{
    // password-checking-aes-key-sharing :
    // <auth><k>key</k></auth>
    xmlNodePtr n, o;
    xmlDocPtr doc;
    xmlChar *xmlbuff;
    int buffersize;

    doc = xmlNewDoc(BAD_CAST "1.0");
    n = xmlNewNode(NULL, BAD_CAST "auth");
    o = xmlNewNode(NULL, BAD_CAST "k");

    xmlAddChild(n, o);

    xmlNodeSetContent(o, BAD_CAST key);
    xmlDocSetRootElement(doc, n);

    xmlDocDumpFormatMemory(doc, &xmlbuff,
                           &buffersize, 1);
    printf("%s", (char *) xmlbuff);

    xmlFreeDoc(doc);
    return (char *) xmlbuff;
}

char* authentification_status(const char* tra)
{
    // <auth type="encryption-status">
    // <status>suceeded</status></auth>
    xmlNodePtr n;
    xmlNodePtr m;
    xmlDocPtr doc;
    xmlChar *xmlbuff;
    int buffersize;

    doc = xmlNewDoc(BAD_CAST "1.0");
    n = xmlNewNode(NULL, BAD_CAST "auth");
    m = xmlNewNode(NULL, BAD_CAST "status");
    xmlAddChild(n, m);

    xmlSetProp(n, (xmlChar*)"type",
               (xmlChar*)"encryption-status");

    xmlNodeSetContent(m, BAD_CAST tra);
    xmlDocSetRootElement(doc, n);

    xmlDocDumpFormatMemory(doc, &xmlbuff, &buffersize, 1);
    printf("%s", (char *) xmlbuff);

    xmlFreeDoc(doc);
    return (char *) xmlbuff;
}

char* gen_random_char(int size)
{
    int i = 0;
    char random[size];
    for (i = 0; i < size; i++) {
        char c = (char)(rand() % 26+65);
        random[i] = c;
    }
    random[size] ='\0';
    return (char*)random;
}

