
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQHBoxLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QHBoxLayout>
#include <QChildEvent>
#include <QEvent>
#include <QLayout>
#include <QLayoutItem>
#include <QMargins>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QSpacerItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QHBoxLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QHBoxLayout::staticMetaObject);
}


// static QString QHBoxLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QHBoxLayout::tr (arg1, arg2, arg3));
}


// static QString QHBoxLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QHBoxLayout::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QHBoxLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QHBoxLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QHBoxLayout::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QHBoxLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QHBoxLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QBoxLayout> &qtdecl_QBoxLayout ();

qt_gsi::QtNativeClass<QHBoxLayout> decl_QHBoxLayout (qtdecl_QBoxLayout (), "QtWidgets", "QHBoxLayout_Native",
  methods_QHBoxLayout (),
  "@hide\n@alias QHBoxLayout");

GSI_QTWIDGETS_PUBLIC gsi::Class<QHBoxLayout> &qtdecl_QHBoxLayout () { return decl_QHBoxLayout; }

}


class QHBoxLayout_Adaptor : public QHBoxLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QHBoxLayout_Adaptor();

  //  [adaptor ctor] QHBoxLayout::QHBoxLayout()
  QHBoxLayout_Adaptor() : QHBoxLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QHBoxLayout::QHBoxLayout(QWidget *parent)
  QHBoxLayout_Adaptor(QWidget *parent) : QHBoxLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QHBoxLayout::addChildLayout(QLayout *l)
  void fp_QHBoxLayout_addChildLayout_1341 (QLayout *l) {
    QHBoxLayout::addChildLayout(l);
  }

  //  [expose] void QHBoxLayout::addChildWidget(QWidget *w)
  void fp_QHBoxLayout_addChildWidget_1315 (QWidget *w) {
    QHBoxLayout::addChildWidget(w);
  }

  //  [expose] bool QHBoxLayout::adoptLayout(QLayout *layout)
  bool fp_QHBoxLayout_adoptLayout_1341 (QLayout *layout) {
    return QHBoxLayout::adoptLayout(layout);
  }

  //  [expose] QRect QHBoxLayout::alignmentRect(const QRect &)
  QRect fp_QHBoxLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QHBoxLayout::alignmentRect(arg1);
  }

  //  [expose] bool QHBoxLayout::isSignalConnected(const QMetaMethod &signal)
  bool fp_QHBoxLayout_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QHBoxLayout::isSignalConnected(signal);
  }

  //  [expose] int QHBoxLayout::receivers(const char *signal)
  int fp_QHBoxLayout_receivers_c1731 (const char *signal) const {
    return QHBoxLayout::receivers(signal);
  }

  //  [expose] QObject *QHBoxLayout::sender()
  QObject * fp_QHBoxLayout_sender_c0 () const {
    return QHBoxLayout::sender();
  }

  //  [expose] int QHBoxLayout::senderSignalIndex()
  int fp_QHBoxLayout_senderSignalIndex_c0 () const {
    return QHBoxLayout::senderSignalIndex();
  }

  //  [expose] void QHBoxLayout::widgetEvent(QEvent *)
  void fp_QHBoxLayout_widgetEvent_1217 (QEvent *arg1) {
    QHBoxLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QHBoxLayout::addItem(QLayoutItem *)
  void cbs_addItem_1740_0(QLayoutItem *arg1)
  {
    QHBoxLayout::addItem(arg1);
  }

  virtual void addItem(QLayoutItem *arg1)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QHBoxLayout_Adaptor, QLayoutItem *>(&QHBoxLayout_Adaptor::cbs_addItem_1740_0, arg1);
    } else {
      QHBoxLayout::addItem(arg1);
    }
  }

  //  [adaptor impl] QFlags<QSizePolicy::ControlType> QHBoxLayout::controlTypes()
  QFlags<QSizePolicy::ControlType> cbs_controlTypes_c0_0() const
  {
    return QHBoxLayout::controlTypes();
  }

  virtual QFlags<QSizePolicy::ControlType> controlTypes() const
  {
    if (cb_controlTypes_c0_0.can_issue()) {
      return cb_controlTypes_c0_0.issue<QHBoxLayout_Adaptor, QFlags<QSizePolicy::ControlType> >(&QHBoxLayout_Adaptor::cbs_controlTypes_c0_0);
    } else {
      return QHBoxLayout::controlTypes();
    }
  }

  //  [adaptor impl] int QHBoxLayout::count()
  int cbs_count_c0_0() const
  {
    return QHBoxLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QHBoxLayout_Adaptor, int>(&QHBoxLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QHBoxLayout::count();
    }
  }

  //  [emitter impl] void QHBoxLayout::destroyed(QObject *)
  void emitter_QHBoxLayout_destroyed_1302(QObject *arg1)
  {
    emit QHBoxLayout::destroyed(arg1);
  }

  //  [adaptor impl] bool QHBoxLayout::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QHBoxLayout::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QHBoxLayout_Adaptor, bool, QEvent *>(&QHBoxLayout_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QHBoxLayout::event(_event);
    }
  }

  //  [adaptor impl] bool QHBoxLayout::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QHBoxLayout::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QHBoxLayout_Adaptor, bool, QObject *, QEvent *>(&QHBoxLayout_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QHBoxLayout::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QHBoxLayout::expandingDirections()
  QFlags<Qt::Orientation> cbs_expandingDirections_c0_0() const
  {
    return QHBoxLayout::expandingDirections();
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return cb_expandingDirections_c0_0.issue<QHBoxLayout_Adaptor, QFlags<Qt::Orientation> >(&QHBoxLayout_Adaptor::cbs_expandingDirections_c0_0);
    } else {
      return QHBoxLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QHBoxLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QHBoxLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QHBoxLayout_Adaptor, QRect>(&QHBoxLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QHBoxLayout::geometry();
    }
  }

  //  [adaptor impl] bool QHBoxLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QHBoxLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QHBoxLayout_Adaptor, bool>(&QHBoxLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QHBoxLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QHBoxLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QHBoxLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QHBoxLayout_Adaptor, int, int>(&QHBoxLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QHBoxLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QHBoxLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QHBoxLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QHBoxLayout_Adaptor, int, QWidget *>(&QHBoxLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QHBoxLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QHBoxLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QHBoxLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QHBoxLayout_Adaptor>(&QHBoxLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QHBoxLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QHBoxLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QHBoxLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QHBoxLayout_Adaptor, bool>(&QHBoxLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QHBoxLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QHBoxLayout::itemAt(int)
  QLayoutItem * cbs_itemAt_c767_0(int arg1) const
  {
    return QHBoxLayout::itemAt(arg1);
  }

  virtual QLayoutItem * itemAt(int arg1) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QHBoxLayout_Adaptor, QLayoutItem *, int>(&QHBoxLayout_Adaptor::cbs_itemAt_c767_0, arg1);
    } else {
      return QHBoxLayout::itemAt(arg1);
    }
  }

  //  [adaptor impl] QLayout *QHBoxLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QHBoxLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QHBoxLayout_Adaptor, QLayout *>(&QHBoxLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QHBoxLayout::layout();
    }
  }

  //  [adaptor impl] QSize QHBoxLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QHBoxLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QHBoxLayout_Adaptor, QSize>(&QHBoxLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QHBoxLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QHBoxLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QHBoxLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QHBoxLayout_Adaptor, int, int>(&QHBoxLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QHBoxLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QHBoxLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QHBoxLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QHBoxLayout_Adaptor, QSize>(&QHBoxLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QHBoxLayout::minimumSize();
    }
  }

  //  [emitter impl] void QHBoxLayout::objectNameChanged(const QString &objectName)
  void emitter_QHBoxLayout_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QHBoxLayout::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QHBoxLayout::setGeometry(const QRect &)
  void cbs_setGeometry_1792_0(const QRect &arg1)
  {
    QHBoxLayout::setGeometry(arg1);
  }

  virtual void setGeometry(const QRect &arg1)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QHBoxLayout_Adaptor, const QRect &>(&QHBoxLayout_Adaptor::cbs_setGeometry_1792_0, arg1);
    } else {
      QHBoxLayout::setGeometry(arg1);
    }
  }

  //  [adaptor impl] QSize QHBoxLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QHBoxLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QHBoxLayout_Adaptor, QSize>(&QHBoxLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QHBoxLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QHBoxLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QHBoxLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QHBoxLayout_Adaptor, QSpacerItem *>(&QHBoxLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QHBoxLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QHBoxLayout::takeAt(int)
  QLayoutItem * cbs_takeAt_767_0(int arg1)
  {
    return QHBoxLayout::takeAt(arg1);
  }

  virtual QLayoutItem * takeAt(int arg1)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QHBoxLayout_Adaptor, QLayoutItem *, int>(&QHBoxLayout_Adaptor::cbs_takeAt_767_0, arg1);
    } else {
      return QHBoxLayout::takeAt(arg1);
    }
  }

  //  [adaptor impl] QWidget *QHBoxLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QHBoxLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QHBoxLayout_Adaptor, QWidget *>(&QHBoxLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QHBoxLayout::widget();
    }
  }

  //  [adaptor impl] void QHBoxLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QHBoxLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QHBoxLayout_Adaptor, QChildEvent *>(&QHBoxLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QHBoxLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QHBoxLayout::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QHBoxLayout::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QHBoxLayout_Adaptor, QEvent *>(&QHBoxLayout_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QHBoxLayout::customEvent(event);
    }
  }

  //  [adaptor impl] void QHBoxLayout::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QHBoxLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QHBoxLayout_Adaptor, const QMetaMethod &>(&QHBoxLayout_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QHBoxLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QHBoxLayout::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QHBoxLayout::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QHBoxLayout_Adaptor, QTimerEvent *>(&QHBoxLayout_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QHBoxLayout::timerEvent(event);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_controlTypes_c0_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QHBoxLayout_Adaptor::~QHBoxLayout_Adaptor() { }

//  Constructor QHBoxLayout::QHBoxLayout() (adaptor class)

static void _init_ctor_QHBoxLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QHBoxLayout_Adaptor> ();
}

static void _call_ctor_QHBoxLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHBoxLayout_Adaptor *> (new QHBoxLayout_Adaptor ());
}


//  Constructor QHBoxLayout::QHBoxLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QHBoxLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QHBoxLayout_Adaptor> ();
}

static void _call_ctor_QHBoxLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QHBoxLayout_Adaptor *> (new QHBoxLayout_Adaptor (arg1));
}


// exposed void QHBoxLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_addChildLayout_1341 (arg1);
}


// exposed void QHBoxLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_addChildWidget_1315 (arg1);
}


// void QHBoxLayout::addItem(QLayoutItem *)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = args.read<QLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}


// exposed bool QHBoxLayout::adoptLayout(QLayout *layout)

static void _init_fp_adoptLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_adoptLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_adoptLayout_1341 (arg1));
}


// exposed QRect QHBoxLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_alignmentRect_c1792 (arg1));
}


// void QHBoxLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QFlags<QSizePolicy::ControlType> QHBoxLayout::controlTypes()

static void _init_cbs_controlTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QSizePolicy::ControlType> > ();
}

static void _call_cbs_controlTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QSizePolicy::ControlType> > ((QFlags<QSizePolicy::ControlType>)((QHBoxLayout_Adaptor *)cls)->cbs_controlTypes_c0_0 ());
}

static void _set_callback_cbs_controlTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_controlTypes_c0_0 = cb;
}


// int QHBoxLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// void QHBoxLayout::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QHBoxLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QHBoxLayout_Adaptor *)cls)->emitter_QHBoxLayout_destroyed_1302 (arg1);
}


// void QHBoxLayout::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QHBoxLayout::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QHBoxLayout::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QFlags<Qt::Orientation> QHBoxLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QHBoxLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}


// QRect QHBoxLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QHBoxLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}


// bool QHBoxLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QHBoxLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// int QHBoxLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}


// void QHBoxLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// bool QHBoxLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}


// exposed bool QHBoxLayout::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_isSignalConnected_c2394 (arg1));
}


// QLayoutItem *QHBoxLayout::itemAt(int)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QHBoxLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// QLayout *QHBoxLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLayout * > ((QLayout *)((QHBoxLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}


// QSize QHBoxLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QHBoxLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}


// int QHBoxLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}


// QSize QHBoxLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QHBoxLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}


// emitter void QHBoxLayout::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QHBoxLayout_Adaptor *)cls)->emitter_QHBoxLayout_objectNameChanged_4567 (arg1);
}


// exposed int QHBoxLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_receivers_c1731 (arg1));
}


// exposed QObject *QHBoxLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_sender_c0 ());
}


// exposed int QHBoxLayout::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_senderSignalIndex_c0 ());
}


// void QHBoxLayout::setGeometry(const QRect &)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}


// QSize QHBoxLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QHBoxLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// QSpacerItem *QHBoxLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSpacerItem * > ((QSpacerItem *)((QHBoxLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}


// QLayoutItem *QHBoxLayout::takeAt(int)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QHBoxLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}


// void QHBoxLayout::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QWidget *QHBoxLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QHBoxLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHBoxLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}


// exposed void QHBoxLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QHBoxLayout_Adaptor *)cls)->fp_QHBoxLayout_widgetEvent_1217 (arg1);
}


namespace gsi
{

gsi::Class<QHBoxLayout> &qtdecl_QHBoxLayout ();

static gsi::Methods methods_QHBoxLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHBoxLayout::QHBoxLayout()\nThis method creates an object of class QHBoxLayout.", &_init_ctor_QHBoxLayout_Adaptor_0, &_call_ctor_QHBoxLayout_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHBoxLayout::QHBoxLayout(QWidget *parent)\nThis method creates an object of class QHBoxLayout.", &_init_ctor_QHBoxLayout_Adaptor_1315, &_call_ctor_QHBoxLayout_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*addChildLayout", "@brief Method void QHBoxLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
  methods += new qt_gsi::GenericMethod ("*addChildWidget", "@brief Method void QHBoxLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QHBoxLayout::addItem(QLayoutItem *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("*adoptLayout", "@brief Method bool QHBoxLayout::adoptLayout(QLayout *layout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adoptLayout_1341, &_call_fp_adoptLayout_1341);
  methods += new qt_gsi::GenericMethod ("*alignmentRect", "@brief Method QRect QHBoxLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QHBoxLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@brief Virtual method QFlags<QSizePolicy::ControlType> QHBoxLayout::controlTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@hide", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0, &_set_callback_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QHBoxLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QHBoxLayout::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QHBoxLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QHBoxLayout::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QHBoxLayout::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QHBoxLayout::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QHBoxLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QHBoxLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QHBoxLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QHBoxLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QHBoxLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QHBoxLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QHBoxLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QHBoxLayout::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QHBoxLayout::itemAt(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QHBoxLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QHBoxLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QHBoxLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QHBoxLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QHBoxLayout::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QHBoxLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QHBoxLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QHBoxLayout::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QHBoxLayout::setGeometry(const QRect &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QHBoxLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QHBoxLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QHBoxLayout::takeAt(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QHBoxLayout::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QHBoxLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("*widgetEvent", "@brief Method void QHBoxLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
  return methods;
}

gsi::Class<QHBoxLayout_Adaptor> decl_QHBoxLayout_Adaptor (qtdecl_QHBoxLayout (), "QtWidgets", "QHBoxLayout",
  methods_QHBoxLayout_Adaptor (),
  "@qt\n@brief Binding of QHBoxLayout");

}

