
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPaintDeviceWindow.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPaintDeviceWindow>
#include <QAccessibleInterface>
#include <QChildEvent>
#include <QCursor>
#include <QEvent>
#include <QExposeEvent>
#include <QFocusEvent>
#include <QHideEvent>
#include <QIcon>
#include <QKeyEvent>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEvent>
#include <QPainter>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSurfaceFormat>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QTouchEvent>
#include <QWheelEvent>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPaintDeviceWindow

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPaintDeviceWindow::staticMetaObject);
}


// double QPaintDeviceWindow::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QPaintDeviceWindow *)cls)->devicePixelRatio ());
}


// int QPaintDeviceWindow::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPaintDeviceWindow *)cls)->height ());
}


// void QPaintDeviceWindow::update(const QRect &rect)


static void _init_f_update_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow *)cls)->update (arg1);
}


// void QPaintDeviceWindow::update(const QRegion &region)


static void _init_f_update_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow *)cls)->update (arg1);
}


// void QPaintDeviceWindow::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow *)cls)->update ();
}


// int QPaintDeviceWindow::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPaintDeviceWindow *)cls)->width ());
}


// static QString QPaintDeviceWindow::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPaintDeviceWindow::tr (arg1, arg2, arg3));
}


// static QString QPaintDeviceWindow::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPaintDeviceWindow::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QWindow

static void _init_f_QPaintDeviceWindow_as_QWindow (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow *> ();
}

static void _call_f_QPaintDeviceWindow_as_QWindow (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QWindow *> ((QWindow *)(QPaintDeviceWindow *)cls);
}

static void _init_f_QPaintDeviceWindow_as_const_QWindow (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QWindow *> ();
}

static void _call_f_QPaintDeviceWindow_as_const_QWindow (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QWindow *> ((const QWindow *)(const QPaintDeviceWindow *)cls);
}

//  base class cast for QPaintDevice

static void _init_f_QPaintDeviceWindow_as_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice *> ();
}

static void _call_f_QPaintDeviceWindow_as_QPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice *> ((QPaintDevice *)(QPaintDeviceWindow *)cls);
}

static void _init_f_QPaintDeviceWindow_as_const_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPaintDevice *> ();
}

static void _call_f_QPaintDeviceWindow_as_const_QPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QPaintDevice *> ((const QPaintDevice *)(const QPaintDeviceWindow *)cls);
}


namespace gsi
{

static gsi::Methods methods_QPaintDeviceWindow () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("devicePixelRatio", "@brief Method double QPaintDeviceWindow::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod (":height", "@brief Method int QPaintDeviceWindow::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QPaintDeviceWindow::update(const QRect &rect)\n", false, &_init_f_update_1792, &_call_f_update_1792);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QPaintDeviceWindow::update(const QRegion &region)\n", false, &_init_f_update_2006, &_call_f_update_2006);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QPaintDeviceWindow::update()\n", false, &_init_f_update_0, &_call_f_update_0);
  methods += new qt_gsi::GenericMethod (":width", "@brief Method int QPaintDeviceWindow::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += gsi::qt_signal ("activeChanged()", "activeChanged", "@brief Signal declaration for QPaintDeviceWindow::activeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > ("contentOrientationChanged(Qt::ScreenOrientation)", "contentOrientationChanged", gsi::arg("orientation"), "@brief Signal declaration for QPaintDeviceWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPaintDeviceWindow::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("focusObjectChanged(QObject *)", "focusObjectChanged", gsi::arg("object"), "@brief Signal declaration for QPaintDeviceWindow::focusObjectChanged(QObject *object)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("heightChanged(int)", "heightChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::heightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumHeightChanged(int)", "maximumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::maximumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumWidthChanged(int)", "maximumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::maximumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumHeightChanged(int)", "minimumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::minimumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumWidthChanged(int)", "minimumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::minimumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowModality>::target_type & > ("modalityChanged(Qt::WindowModality)", "modalityChanged", gsi::arg("modality"), "@brief Signal declaration for QPaintDeviceWindow::modalityChanged(Qt::WindowModality modality)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPaintDeviceWindow::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("opacityChanged(double)", "opacityChanged", gsi::arg("opacity"), "@brief Signal declaration for QPaintDeviceWindow::opacityChanged(double opacity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenChanged(QScreen *)", "screenChanged", gsi::arg("screen"), "@brief Signal declaration for QPaintDeviceWindow::screenChanged(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QWindow::Visibility>::target_type & > ("visibilityChanged(QWindow::Visibility)", "visibilityChanged", gsi::arg("visibility"), "@brief Signal declaration for QPaintDeviceWindow::visibilityChanged(QWindow::Visibility visibility)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("visibleChanged(bool)", "visibleChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::visibleChanged(bool arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("widthChanged(int)", "widthChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::widthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowState>::target_type & > ("windowStateChanged(Qt::WindowState)", "windowStateChanged", gsi::arg("windowState"), "@brief Signal declaration for QPaintDeviceWindow::windowStateChanged(Qt::WindowState windowState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QPaintDeviceWindow::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("xChanged(int)", "xChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::xChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("yChanged(int)", "yChanged", gsi::arg("arg"), "@brief Signal declaration for QPaintDeviceWindow::yChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPaintDeviceWindow::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPaintDeviceWindow::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQWindow", "@brief Delivers the base class interface QWindow of QPaintDeviceWindow\nClass QPaintDeviceWindow is derived from multiple base classes. This method delivers the QWindow base class aspect.", false, &_init_f_QPaintDeviceWindow_as_QWindow, &_call_f_QPaintDeviceWindow_as_QWindow);
  methods += new qt_gsi::GenericMethod ("asConstQWindow", "@brief Delivers the base class interface QWindow of QPaintDeviceWindow\nClass QPaintDeviceWindow is derived from multiple base classes. This method delivers the QWindow base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPaintDeviceWindow_as_const_QWindow, &_call_f_QPaintDeviceWindow_as_const_QWindow);
  methods += new qt_gsi::GenericMethod ("asQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QPaintDeviceWindow\nClass QPaintDeviceWindow is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.", false, &_init_f_QPaintDeviceWindow_as_QPaintDevice, &_call_f_QPaintDeviceWindow_as_QPaintDevice);
  methods += new qt_gsi::GenericMethod ("asConstQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QPaintDeviceWindow\nClass QPaintDeviceWindow is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPaintDeviceWindow_as_const_QPaintDevice, &_call_f_QPaintDeviceWindow_as_const_QPaintDevice);
  return methods;
}

gsi::Class<QWindow> &qtdecl_QWindow ();

qt_gsi::QtNativeClass<QPaintDeviceWindow> decl_QPaintDeviceWindow (qtdecl_QWindow (), "QtGui", "QPaintDeviceWindow_Native",
  methods_QPaintDeviceWindow (),
  "@hide\n@alias QPaintDeviceWindow");

//  Additional base classes

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::ClassExt<QPaintDeviceWindow> base_class_QPaintDevice_in_QPaintDeviceWindow (qtdecl_QPaintDevice ());

GSI_QTGUI_PUBLIC gsi::Class<QPaintDeviceWindow> &qtdecl_QPaintDeviceWindow () { return decl_QPaintDeviceWindow; }

}


class QPaintDeviceWindow_Adaptor : public QPaintDeviceWindow, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPaintDeviceWindow_Adaptor();

  //  [expose] bool QPaintDeviceWindow::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPaintDeviceWindow_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPaintDeviceWindow::isSignalConnected(signal);
  }

  //  [expose] int QPaintDeviceWindow::receivers(const char *signal)
  int fp_QPaintDeviceWindow_receivers_c1731 (const char *signal) const {
    return QPaintDeviceWindow::receivers(signal);
  }

  //  [expose] QObject *QPaintDeviceWindow::sender()
  QObject * fp_QPaintDeviceWindow_sender_c0 () const {
    return QPaintDeviceWindow::sender();
  }

  //  [expose] int QPaintDeviceWindow::senderSignalIndex()
  int fp_QPaintDeviceWindow_senderSignalIndex_c0 () const {
    return QPaintDeviceWindow::senderSignalIndex();
  }

  //  [adaptor impl] QAccessibleInterface *QPaintDeviceWindow::accessibleRoot()
  QAccessibleInterface * cbs_accessibleRoot_c0_0() const
  {
    return QPaintDeviceWindow::accessibleRoot();
  }

  virtual QAccessibleInterface * accessibleRoot() const
  {
    if (cb_accessibleRoot_c0_0.can_issue()) {
      return cb_accessibleRoot_c0_0.issue<QPaintDeviceWindow_Adaptor, QAccessibleInterface *>(&QPaintDeviceWindow_Adaptor::cbs_accessibleRoot_c0_0);
    } else {
      return QPaintDeviceWindow::accessibleRoot();
    }
  }

  //  [emitter impl] void QPaintDeviceWindow::activeChanged()
  void emitter_QPaintDeviceWindow_activeChanged_0()
  {
    emit QPaintDeviceWindow::activeChanged();
  }

  //  [emitter impl] void QPaintDeviceWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)
  void emitter_QPaintDeviceWindow_contentOrientationChanged_2521(Qt::ScreenOrientation orientation)
  {
    emit QPaintDeviceWindow::contentOrientationChanged(orientation);
  }

  //  [emitter impl] void QPaintDeviceWindow::destroyed(QObject *)
  void emitter_QPaintDeviceWindow_destroyed_1302(QObject *arg1)
  {
    emit QPaintDeviceWindow::destroyed(arg1);
  }

  //  [adaptor impl] bool QPaintDeviceWindow::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QPaintDeviceWindow::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPaintDeviceWindow_Adaptor, bool, QObject *, QEvent *>(&QPaintDeviceWindow_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QPaintDeviceWindow::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QObject *QPaintDeviceWindow::focusObject()
  QObject * cbs_focusObject_c0_0() const
  {
    return QPaintDeviceWindow::focusObject();
  }

  virtual QObject * focusObject() const
  {
    if (cb_focusObject_c0_0.can_issue()) {
      return cb_focusObject_c0_0.issue<QPaintDeviceWindow_Adaptor, QObject *>(&QPaintDeviceWindow_Adaptor::cbs_focusObject_c0_0);
    } else {
      return QPaintDeviceWindow::focusObject();
    }
  }

  //  [emitter impl] void QPaintDeviceWindow::focusObjectChanged(QObject *object)
  void emitter_QPaintDeviceWindow_focusObjectChanged_1302(QObject *object)
  {
    emit QPaintDeviceWindow::focusObjectChanged(object);
  }

  //  [adaptor impl] QSurfaceFormat QPaintDeviceWindow::format()
  QSurfaceFormat cbs_format_c0_0() const
  {
    return QPaintDeviceWindow::format();
  }

  virtual QSurfaceFormat format() const
  {
    if (cb_format_c0_0.can_issue()) {
      return cb_format_c0_0.issue<QPaintDeviceWindow_Adaptor, QSurfaceFormat>(&QPaintDeviceWindow_Adaptor::cbs_format_c0_0);
    } else {
      return QPaintDeviceWindow::format();
    }
  }

  //  [emitter impl] void QPaintDeviceWindow::heightChanged(int arg)
  void emitter_QPaintDeviceWindow_heightChanged_767(int arg)
  {
    emit QPaintDeviceWindow::heightChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::maximumHeightChanged(int arg)
  void emitter_QPaintDeviceWindow_maximumHeightChanged_767(int arg)
  {
    emit QPaintDeviceWindow::maximumHeightChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::maximumWidthChanged(int arg)
  void emitter_QPaintDeviceWindow_maximumWidthChanged_767(int arg)
  {
    emit QPaintDeviceWindow::maximumWidthChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::minimumHeightChanged(int arg)
  void emitter_QPaintDeviceWindow_minimumHeightChanged_767(int arg)
  {
    emit QPaintDeviceWindow::minimumHeightChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::minimumWidthChanged(int arg)
  void emitter_QPaintDeviceWindow_minimumWidthChanged_767(int arg)
  {
    emit QPaintDeviceWindow::minimumWidthChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::modalityChanged(Qt::WindowModality modality)
  void emitter_QPaintDeviceWindow_modalityChanged_2216(Qt::WindowModality modality)
  {
    emit QPaintDeviceWindow::modalityChanged(modality);
  }

  //  [emitter impl] void QPaintDeviceWindow::objectNameChanged(const QString &objectName)
  void emitter_QPaintDeviceWindow_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPaintDeviceWindow::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QPaintDeviceWindow::opacityChanged(double opacity)
  void emitter_QPaintDeviceWindow_opacityChanged_1071(double opacity)
  {
    emit QPaintDeviceWindow::opacityChanged(opacity);
  }

  //  [emitter impl] void QPaintDeviceWindow::screenChanged(QScreen *screen)
  void emitter_QPaintDeviceWindow_screenChanged_1311(QScreen *screen)
  {
    emit QPaintDeviceWindow::screenChanged(screen);
  }

  //  [adaptor impl] QSize QPaintDeviceWindow::size()
  QSize cbs_size_c0_0() const
  {
    return QPaintDeviceWindow::size();
  }

  virtual QSize size() const
  {
    if (cb_size_c0_0.can_issue()) {
      return cb_size_c0_0.issue<QPaintDeviceWindow_Adaptor, QSize>(&QPaintDeviceWindow_Adaptor::cbs_size_c0_0);
    } else {
      return QPaintDeviceWindow::size();
    }
  }

  //  [adaptor impl] QSurface::SurfaceType QPaintDeviceWindow::surfaceType()
  qt_gsi::Converter<QSurface::SurfaceType>::target_type cbs_surfaceType_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QSurface::SurfaceType>(QPaintDeviceWindow::surfaceType());
  }

  virtual QSurface::SurfaceType surfaceType() const
  {
    if (cb_surfaceType_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QSurface::SurfaceType>(cb_surfaceType_c0_0.issue<QPaintDeviceWindow_Adaptor, qt_gsi::Converter<QSurface::SurfaceType>::target_type>(&QPaintDeviceWindow_Adaptor::cbs_surfaceType_c0_0)).cref();
    } else {
      return QPaintDeviceWindow::surfaceType();
    }
  }

  //  [emitter impl] void QPaintDeviceWindow::visibilityChanged(QWindow::Visibility visibility)
  void emitter_QPaintDeviceWindow_visibilityChanged_2329(QWindow::Visibility visibility)
  {
    emit QPaintDeviceWindow::visibilityChanged(visibility);
  }

  //  [emitter impl] void QPaintDeviceWindow::visibleChanged(bool arg)
  void emitter_QPaintDeviceWindow_visibleChanged_864(bool arg)
  {
    emit QPaintDeviceWindow::visibleChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::widthChanged(int arg)
  void emitter_QPaintDeviceWindow_widthChanged_767(int arg)
  {
    emit QPaintDeviceWindow::widthChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::windowStateChanged(Qt::WindowState windowState)
  void emitter_QPaintDeviceWindow_windowStateChanged_1894(Qt::WindowState windowState)
  {
    emit QPaintDeviceWindow::windowStateChanged(windowState);
  }

  //  [emitter impl] void QPaintDeviceWindow::windowTitleChanged(const QString &title)
  void emitter_QPaintDeviceWindow_windowTitleChanged_2025(const QString &title)
  {
    emit QPaintDeviceWindow::windowTitleChanged(title);
  }

  //  [emitter impl] void QPaintDeviceWindow::xChanged(int arg)
  void emitter_QPaintDeviceWindow_xChanged_767(int arg)
  {
    emit QPaintDeviceWindow::xChanged(arg);
  }

  //  [emitter impl] void QPaintDeviceWindow::yChanged(int arg)
  void emitter_QPaintDeviceWindow_yChanged_767(int arg)
  {
    emit QPaintDeviceWindow::yChanged(arg);
  }

  //  [adaptor impl] void QPaintDeviceWindow::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QPaintDeviceWindow::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPaintDeviceWindow_Adaptor, QChildEvent *>(&QPaintDeviceWindow_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QPaintDeviceWindow::childEvent(event);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QPaintDeviceWindow::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPaintDeviceWindow_Adaptor, QEvent *>(&QPaintDeviceWindow_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QPaintDeviceWindow::customEvent(event);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPaintDeviceWindow::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPaintDeviceWindow_Adaptor, const QMetaMethod &>(&QPaintDeviceWindow_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPaintDeviceWindow::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QPaintDeviceWindow::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QPaintDeviceWindow::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPaintDeviceWindow_Adaptor, bool, QEvent *>(&QPaintDeviceWindow_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QPaintDeviceWindow::event(_event);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::exposeEvent(QExposeEvent *)
  void cbs_exposeEvent_1845_0(QExposeEvent *arg1)
  {
    QPaintDeviceWindow::exposeEvent(arg1);
  }

  virtual void exposeEvent(QExposeEvent *arg1)
  {
    if (cb_exposeEvent_1845_0.can_issue()) {
      cb_exposeEvent_1845_0.issue<QPaintDeviceWindow_Adaptor, QExposeEvent *>(&QPaintDeviceWindow_Adaptor::cbs_exposeEvent_1845_0, arg1);
    } else {
      QPaintDeviceWindow::exposeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QPaintDeviceWindow::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPaintDeviceWindow_Adaptor, QFocusEvent *>(&QPaintDeviceWindow_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QPaintDeviceWindow::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QPaintDeviceWindow::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPaintDeviceWindow_Adaptor, QFocusEvent *>(&QPaintDeviceWindow_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QPaintDeviceWindow::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPaintDeviceWindow::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPaintDeviceWindow_Adaptor, QHideEvent *>(&QPaintDeviceWindow_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPaintDeviceWindow::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPaintDeviceWindow::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPaintDeviceWindow_Adaptor, QPainter *>(&QPaintDeviceWindow_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPaintDeviceWindow::initPainter(painter);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QPaintDeviceWindow::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPaintDeviceWindow_Adaptor, QKeyEvent *>(&QPaintDeviceWindow_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QPaintDeviceWindow::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QPaintDeviceWindow::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPaintDeviceWindow_Adaptor, QKeyEvent *>(&QPaintDeviceWindow_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QPaintDeviceWindow::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] int QPaintDeviceWindow::metric(QPaintDevice::PaintDeviceMetric metric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & _metric) const
  {
    return QPaintDeviceWindow::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(_metric).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric _metric) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPaintDeviceWindow_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPaintDeviceWindow_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(_metric));
    } else {
      return QPaintDeviceWindow::metric(_metric);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QPaintDeviceWindow::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPaintDeviceWindow_Adaptor, QMouseEvent *>(&QPaintDeviceWindow_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QPaintDeviceWindow::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QPaintDeviceWindow::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPaintDeviceWindow_Adaptor, QMouseEvent *>(&QPaintDeviceWindow_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QPaintDeviceWindow::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QPaintDeviceWindow::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPaintDeviceWindow_Adaptor, QMouseEvent *>(&QPaintDeviceWindow_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QPaintDeviceWindow::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QPaintDeviceWindow::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPaintDeviceWindow_Adaptor, QMouseEvent *>(&QPaintDeviceWindow_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QPaintDeviceWindow::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPaintDeviceWindow::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPaintDeviceWindow_Adaptor, QMoveEvent *>(&QPaintDeviceWindow_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPaintDeviceWindow::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPaintDeviceWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QPaintDeviceWindow::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QPaintDeviceWindow_Adaptor, bool, const QByteArray &, void *, long int *>(&QPaintDeviceWindow_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QPaintDeviceWindow::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QPaintDeviceWindow::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPaintDeviceWindow_Adaptor, QPaintEvent *>(&QPaintDeviceWindow_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QPaintDeviceWindow::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QPaintDeviceWindow::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPaintDeviceWindow::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPaintDeviceWindow_Adaptor, QPaintDevice *, QPoint *>(&QPaintDeviceWindow_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPaintDeviceWindow::redirected(offset);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QPaintDeviceWindow::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPaintDeviceWindow_Adaptor, QResizeEvent *>(&QPaintDeviceWindow_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QPaintDeviceWindow::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] QPainter *QPaintDeviceWindow::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPaintDeviceWindow::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPaintDeviceWindow_Adaptor, QPainter *>(&QPaintDeviceWindow_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPaintDeviceWindow::sharedPainter();
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPaintDeviceWindow::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPaintDeviceWindow_Adaptor, QShowEvent *>(&QPaintDeviceWindow_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPaintDeviceWindow::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPaintDeviceWindow::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPaintDeviceWindow_Adaptor, QTabletEvent *>(&QPaintDeviceWindow_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPaintDeviceWindow::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QPaintDeviceWindow::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPaintDeviceWindow_Adaptor, QTimerEvent *>(&QPaintDeviceWindow_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QPaintDeviceWindow::timerEvent(event);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::touchEvent(QTouchEvent *)
  void cbs_touchEvent_1732_0(QTouchEvent *arg1)
  {
    QPaintDeviceWindow::touchEvent(arg1);
  }

  virtual void touchEvent(QTouchEvent *arg1)
  {
    if (cb_touchEvent_1732_0.can_issue()) {
      cb_touchEvent_1732_0.issue<QPaintDeviceWindow_Adaptor, QTouchEvent *>(&QPaintDeviceWindow_Adaptor::cbs_touchEvent_1732_0, arg1);
    } else {
      QPaintDeviceWindow::touchEvent(arg1);
    }
  }

  //  [adaptor impl] void QPaintDeviceWindow::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QPaintDeviceWindow::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPaintDeviceWindow_Adaptor, QWheelEvent *>(&QPaintDeviceWindow_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QPaintDeviceWindow::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_accessibleRoot_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusObject_c0_0;
  gsi::Callback cb_format_c0_0;
  gsi::Callback cb_size_c0_0;
  gsi::Callback cb_surfaceType_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_exposeEvent_1845_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_touchEvent_1732_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QPaintDeviceWindow_Adaptor::~QPaintDeviceWindow_Adaptor() { }

// QAccessibleInterface *QPaintDeviceWindow::accessibleRoot()

static void _init_cbs_accessibleRoot_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_accessibleRoot_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QPaintDeviceWindow_Adaptor *)cls)->cbs_accessibleRoot_c0_0 ());
}

static void _set_callback_cbs_accessibleRoot_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_accessibleRoot_c0_0 = cb;
}


// emitter void QPaintDeviceWindow::activeChanged()

static void _init_emitter_activeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_activeChanged_0 ();
}


// void QPaintDeviceWindow::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QPaintDeviceWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)

static void _init_emitter_contentOrientationChanged_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_contentOrientationChanged_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_contentOrientationChanged_2521 (arg1);
}


// void QPaintDeviceWindow::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPaintDeviceWindow::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_destroyed_1302 (arg1);
}


// void QPaintDeviceWindow::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QPaintDeviceWindow::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPaintDeviceWindow_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPaintDeviceWindow::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPaintDeviceWindow_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QPaintDeviceWindow::exposeEvent(QExposeEvent *)

static void _init_cbs_exposeEvent_1845_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QExposeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_exposeEvent_1845_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QExposeEvent *arg1 = args.read<QExposeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_exposeEvent_1845_0 (arg1);
}

static void _set_callback_cbs_exposeEvent_1845_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_exposeEvent_1845_0 = cb;
}


// void QPaintDeviceWindow::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// QObject *QPaintDeviceWindow::focusObject()

static void _init_cbs_focusObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_cbs_focusObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPaintDeviceWindow_Adaptor *)cls)->cbs_focusObject_c0_0 ());
}

static void _set_callback_cbs_focusObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_focusObject_c0_0 = cb;
}


// emitter void QPaintDeviceWindow::focusObjectChanged(QObject *object)

static void _init_emitter_focusObjectChanged_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusObjectChanged_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_focusObjectChanged_1302 (arg1);
}


// void QPaintDeviceWindow::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// QSurfaceFormat QPaintDeviceWindow::format()

static void _init_cbs_format_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_cbs_format_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)((QPaintDeviceWindow_Adaptor *)cls)->cbs_format_c0_0 ());
}

static void _set_callback_cbs_format_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_format_c0_0 = cb;
}


// emitter void QPaintDeviceWindow::heightChanged(int arg)

static void _init_emitter_heightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_heightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_heightChanged_767 (arg1);
}


// void QPaintDeviceWindow::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QPaintDeviceWindow::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed bool QPaintDeviceWindow::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPaintDeviceWindow_Adaptor *)cls)->fp_QPaintDeviceWindow_isSignalConnected_c2394 (arg1));
}


// void QPaintDeviceWindow::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QPaintDeviceWindow::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// emitter void QPaintDeviceWindow::maximumHeightChanged(int arg)

static void _init_emitter_maximumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_maximumHeightChanged_767 (arg1);
}


// emitter void QPaintDeviceWindow::maximumWidthChanged(int arg)

static void _init_emitter_maximumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_maximumWidthChanged_767 (arg1);
}


// int QPaintDeviceWindow::metric(QPaintDevice::PaintDeviceMetric metric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPaintDeviceWindow_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// emitter void QPaintDeviceWindow::minimumHeightChanged(int arg)

static void _init_emitter_minimumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_minimumHeightChanged_767 (arg1);
}


// emitter void QPaintDeviceWindow::minimumWidthChanged(int arg)

static void _init_emitter_minimumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_minimumWidthChanged_767 (arg1);
}


// emitter void QPaintDeviceWindow::modalityChanged(Qt::WindowModality modality)

static void _init_emitter_modalityChanged_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modalityChanged_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowModality>::target_type & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_modalityChanged_2216 (arg1);
}


// void QPaintDeviceWindow::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QPaintDeviceWindow::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QPaintDeviceWindow::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QPaintDeviceWindow::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QPaintDeviceWindow::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QPaintDeviceWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QPaintDeviceWindow_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QPaintDeviceWindow::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_objectNameChanged_4567 (arg1);
}


// emitter void QPaintDeviceWindow::opacityChanged(double opacity)

static void _init_emitter_opacityChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_opacityChanged_1071 (arg1);
}


// void QPaintDeviceWindow::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QPaintDeviceWindow::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPaintDeviceWindow_Adaptor *)cls)->fp_QPaintDeviceWindow_receivers_c1731 (arg1));
}


// QPaintDevice *QPaintDeviceWindow::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPaintDeviceWindow_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QPaintDeviceWindow::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// emitter void QPaintDeviceWindow::screenChanged(QScreen *screen)

static void _init_emitter_screenChanged_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenChanged_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_screenChanged_1311 (arg1);
}


// exposed QObject *QPaintDeviceWindow::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPaintDeviceWindow_Adaptor *)cls)->fp_QPaintDeviceWindow_sender_c0 ());
}


// exposed int QPaintDeviceWindow::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPaintDeviceWindow_Adaptor *)cls)->fp_QPaintDeviceWindow_senderSignalIndex_c0 ());
}


// QPainter *QPaintDeviceWindow::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPaintDeviceWindow_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QPaintDeviceWindow::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QPaintDeviceWindow::size()

static void _init_cbs_size_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_size_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPaintDeviceWindow_Adaptor *)cls)->cbs_size_c0_0 ());
}

static void _set_callback_cbs_size_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_size_c0_0 = cb;
}


// QSurface::SurfaceType QPaintDeviceWindow::surfaceType()

static void _init_cbs_surfaceType_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ();
}

static void _call_cbs_surfaceType_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ((qt_gsi::Converter<QSurface::SurfaceType>::target_type)((QPaintDeviceWindow_Adaptor *)cls)->cbs_surfaceType_c0_0 ());
}

static void _set_callback_cbs_surfaceType_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_surfaceType_c0_0 = cb;
}


// void QPaintDeviceWindow::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QPaintDeviceWindow::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QPaintDeviceWindow::touchEvent(QTouchEvent *)

static void _init_cbs_touchEvent_1732_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTouchEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_touchEvent_1732_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTouchEvent *arg1 = args.read<QTouchEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_touchEvent_1732_0 (arg1);
}

static void _set_callback_cbs_touchEvent_1732_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_touchEvent_1732_0 = cb;
}


// emitter void QPaintDeviceWindow::visibilityChanged(QWindow::Visibility visibility)

static void _init_emitter_visibilityChanged_2329 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visibility");
  decl->add_arg<const qt_gsi::Converter<QWindow::Visibility>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibilityChanged_2329 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWindow::Visibility>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWindow::Visibility>::target_type & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_visibilityChanged_2329 (arg1);
}


// emitter void QPaintDeviceWindow::visibleChanged(bool arg)

static void _init_emitter_visibleChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_visibleChanged_864 (arg1);
}


// void QPaintDeviceWindow::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintDeviceWindow_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintDeviceWindow_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QPaintDeviceWindow::widthChanged(int arg)

static void _init_emitter_widthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_widthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_widthChanged_767 (arg1);
}


// emitter void QPaintDeviceWindow::windowStateChanged(Qt::WindowState windowState)

static void _init_emitter_windowStateChanged_1894 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowState");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowStateChanged_1894 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowState>::target_type & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_windowStateChanged_1894 (arg1);
}


// emitter void QPaintDeviceWindow::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_windowTitleChanged_2025 (arg1);
}


// emitter void QPaintDeviceWindow::xChanged(int arg)

static void _init_emitter_xChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_xChanged_767 (arg1);
}


// emitter void QPaintDeviceWindow::yChanged(int arg)

static void _init_emitter_yChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPaintDeviceWindow_Adaptor *)cls)->emitter_QPaintDeviceWindow_yChanged_767 (arg1);
}


namespace gsi
{

gsi::Class<QPaintDeviceWindow> &qtdecl_QPaintDeviceWindow ();

static gsi::Methods methods_QPaintDeviceWindow_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@brief Virtual method QAccessibleInterface *QPaintDeviceWindow::accessibleRoot()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@hide", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0, &_set_callback_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QPaintDeviceWindow::activeChanged()\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_0, &_call_emitter_activeChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPaintDeviceWindow::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_contentOrientationChanged", "@brief Emitter for signal void QPaintDeviceWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nCall this method to emit this signal.", false, &_init_emitter_contentOrientationChanged_2521, &_call_emitter_contentOrientationChanged_2521);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPaintDeviceWindow::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPaintDeviceWindow::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPaintDeviceWindow::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPaintDeviceWindow::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPaintDeviceWindow::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@brief Virtual method void QPaintDeviceWindow::exposeEvent(QExposeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@hide", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0, &_set_callback_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPaintDeviceWindow::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@brief Virtual method QObject *QPaintDeviceWindow::focusObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@hide", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0, &_set_callback_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusObjectChanged", "@brief Emitter for signal void QPaintDeviceWindow::focusObjectChanged(QObject *object)\nCall this method to emit this signal.", false, &_init_emitter_focusObjectChanged_1302, &_call_emitter_focusObjectChanged_1302);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPaintDeviceWindow::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method QSurfaceFormat QPaintDeviceWindow::format()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0, &_set_callback_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_heightChanged", "@brief Emitter for signal void QPaintDeviceWindow::heightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_heightChanged_767, &_call_emitter_heightChanged_767);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPaintDeviceWindow::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPaintDeviceWindow::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPaintDeviceWindow::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPaintDeviceWindow::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPaintDeviceWindow::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("emit_maximumHeightChanged", "@brief Emitter for signal void QPaintDeviceWindow::maximumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumHeightChanged_767, &_call_emitter_maximumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_maximumWidthChanged", "@brief Emitter for signal void QPaintDeviceWindow::maximumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumWidthChanged_767, &_call_emitter_maximumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPaintDeviceWindow::metric(QPaintDevice::PaintDeviceMetric metric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("emit_minimumHeightChanged", "@brief Emitter for signal void QPaintDeviceWindow::minimumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumHeightChanged_767, &_call_emitter_minimumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_minimumWidthChanged", "@brief Emitter for signal void QPaintDeviceWindow::minimumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumWidthChanged_767, &_call_emitter_minimumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_modalityChanged", "@brief Emitter for signal void QPaintDeviceWindow::modalityChanged(Qt::WindowModality modality)\nCall this method to emit this signal.", false, &_init_emitter_modalityChanged_2216, &_call_emitter_modalityChanged_2216);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPaintDeviceWindow::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPaintDeviceWindow::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPaintDeviceWindow::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPaintDeviceWindow::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPaintDeviceWindow::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QPaintDeviceWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPaintDeviceWindow::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QPaintDeviceWindow::opacityChanged(double opacity)\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_1071, &_call_emitter_opacityChanged_1071);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPaintDeviceWindow::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPaintDeviceWindow::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPaintDeviceWindow::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPaintDeviceWindow::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("emit_screenChanged", "@brief Emitter for signal void QPaintDeviceWindow::screenChanged(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenChanged_1311, &_call_emitter_screenChanged_1311);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPaintDeviceWindow::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPaintDeviceWindow::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPaintDeviceWindow::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPaintDeviceWindow::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Virtual method QSize QPaintDeviceWindow::size()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("size", "@hide", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0, &_set_callback_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@brief Virtual method QSurface::SurfaceType QPaintDeviceWindow::surfaceType()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@hide", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0, &_set_callback_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPaintDeviceWindow::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPaintDeviceWindow::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@brief Virtual method void QPaintDeviceWindow::touchEvent(QTouchEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@hide", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0, &_set_callback_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("emit_visibilityChanged", "@brief Emitter for signal void QPaintDeviceWindow::visibilityChanged(QWindow::Visibility visibility)\nCall this method to emit this signal.", false, &_init_emitter_visibilityChanged_2329, &_call_emitter_visibilityChanged_2329);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QPaintDeviceWindow::visibleChanged(bool arg)\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_864, &_call_emitter_visibleChanged_864);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPaintDeviceWindow::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_widthChanged", "@brief Emitter for signal void QPaintDeviceWindow::widthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_widthChanged_767, &_call_emitter_widthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_windowStateChanged", "@brief Emitter for signal void QPaintDeviceWindow::windowStateChanged(Qt::WindowState windowState)\nCall this method to emit this signal.", false, &_init_emitter_windowStateChanged_1894, &_call_emitter_windowStateChanged_1894);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QPaintDeviceWindow::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QPaintDeviceWindow::xChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_xChanged_767, &_call_emitter_xChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QPaintDeviceWindow::yChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_yChanged_767, &_call_emitter_yChanged_767);
  return methods;
}

gsi::Class<QPaintDeviceWindow_Adaptor> decl_QPaintDeviceWindow_Adaptor (qtdecl_QPaintDeviceWindow (), "QtGui", "QPaintDeviceWindow",
  methods_QPaintDeviceWindow_Adaptor (),
  "@qt\n@brief Binding of QPaintDeviceWindow");

}

