/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<BigInteger> {
    @Override
    protected NumberFormat[] getNumberFormats() {
        NumberFormat[] formats;
        for (NumberFormat format : formats = super.getNumberFormats()) {
            ((DecimalFormat)format).setParseBigDecimal(true);
        }
        return formats;
    }

    @Override
    public BigInteger convert(String input, Class<? extends BigInteger> targetType, Collection<ValidationError> errors) {
        BigDecimal decimal = (BigDecimal)this.parse(input, errors);
        if (errors.size() == 0) {
            return decimal.toBigInteger();
        }
        return null;
    }
}

