/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Base64;
import net.sourceforge.stripes.util.Log;

public class CryptoUtil {
    private static final Log log = Log.getInstance(CryptoUtil.class);
    private static final SecureRandom random = new SecureRandom();
    public static final String ALGORITHM = "DESede";
    public static final String CONFIG_ENCRYPTION_KEY = "Stripes.EncryptionKey";
    private static final int MIN_KEY_BYTES = 128;
    private static final int NONCE_SIZE = 2;
    private static final int HASH_CODE_SEED = 5381;
    private static final int HASH_CODE_SIZE = 2;
    private static final int DISCARD_BYTES = 4;
    private static final int BASE64_OPTIONS = 24;
    private static SecretKey secretKey;

    @Deprecated
    public static String encrypt(String input, HttpServletRequest request) {
        return CryptoUtil.encrypt(input);
    }

    public static String encrypt(String input) {
        Configuration configuration;
        if (input == null) {
            input = "";
        }
        if ((configuration = StripesFilter.getConfiguration()) != null && configuration.isDebugMode()) {
            return input;
        }
        try {
            Cipher cipher = CryptoUtil.getCipher(1);
            byte[] inbytes = input.getBytes();
            int inputLength = inbytes.length;
            int size = cipher.getOutputSize(4 + inputLength);
            byte[] output = new byte[size];
            byte[] nonce = CryptoUtil.nextNonce();
            byte[] hash = CryptoUtil.generateHashCode(nonce, inbytes);
            int index = cipher.update(hash, 0, 2, output, 0);
            index = cipher.update(nonce, 0, 2, output, index);
            if (inbytes.length == 0) {
                cipher.doFinal(output, index);
            } else {
                cipher.doFinal(inbytes, 0, inbytes.length, output, index);
            }
            return Base64.encodeBytes(output, 24);
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not encrypt value.", e);
        }
    }

    @Deprecated
    public static String decrypt(String input, HttpServletRequest request) {
        return CryptoUtil.decrypt(input);
    }

    public static String decrypt(String input) {
        byte[] output;
        if (input == null) {
            return null;
        }
        Configuration configuration = StripesFilter.getConfiguration();
        if (configuration != null && configuration.isDebugMode()) {
            return input;
        }
        byte[] bytes = Base64.decode(input, 24);
        Cipher cipher = CryptoUtil.getCipher(2);
        try {
            output = cipher.doFinal(bytes);
        }
        catch (IllegalBlockSizeException e) {
            log.warn("Input was not encrypted with the current encryption key: ", input);
            return null;
        }
        catch (BadPaddingException e) {
            log.warn("Input was not encrypted with the current encryption key: ", input);
            return null;
        }
        if (!CryptoUtil.checkHashCode(output)) {
            log.warn("Input was not encrypted with the current encryption key: ", input);
            return null;
        }
        return new String(output, 4, output.length - 4);
    }

    protected static Cipher getCipher(int mode) {
        try {
            SecretKey key = CryptoUtil.getSecretKey();
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(mode, key);
            return cipher;
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not generate a Cipher.", e);
        }
    }

    protected static synchronized SecretKey getSecretKey() {
        try {
            if (secretKey == null) {
                byte[] material = CryptoUtil.getKeyMaterialFromConfig();
                if (material == null) {
                    material = new byte[128];
                    new SecureRandom().nextBytes(material);
                } else {
                    MessageDigest digest = MessageDigest.getInstance("SHA1");
                    int length = digest.getDigestLength();
                    byte[] hashed = new byte[128];
                    for (int i = 0; i < hashed.length; i += length) {
                        material = digest.digest(material);
                        System.arraycopy(material, 0, hashed, i, Math.min(length, 128 - i));
                    }
                    material = hashed;
                }
                SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM);
                secretKey = factory.generateSecret(new DESedeKeySpec(material));
            }
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not generate a secret key.", e);
        }
        return secretKey;
    }

    protected static byte[] getKeyMaterialFromConfig() {
        try {
            String key;
            Configuration config = StripesFilter.getConfiguration();
            if (config != null && (key = config.getBootstrapPropertyResolver().getProperty(CONFIG_ENCRYPTION_KEY)) != null) {
                return key.getBytes();
            }
        }
        catch (Exception e) {
            log.warn("Could not load key material from configuration.", e);
        }
        return null;
    }

    public static synchronized void setSecretKey(SecretKey key) {
        secretKey = key;
    }

    protected static byte[] nextNonce() {
        byte[] nonce = new byte[2];
        random.nextBytes(nonce);
        return nonce;
    }

    protected static byte[] generateHashCode(byte[] ... byteses) {
        long hash = 5381L;
        for (int i = 0; i < byteses.length; ++i) {
            byte[] bytes = byteses[i];
            for (int j = 0; j < bytes.length; ++j) {
                hash = (hash << 5) + hash + (long)bytes[j];
            }
        }
        byte[] hashBytes = new byte[2];
        for (int i = 1; i >= 0; --i) {
            hashBytes[i] = (byte)(hash & 0xFFL);
            hash >>>= 8;
        }
        return hashBytes;
    }

    protected static boolean checkHashCode(byte[] value) {
        int i;
        if (value.length < 2) {
            return false;
        }
        long hash = 5381L;
        for (i = 2; i < value.length; ++i) {
            hash = (hash << 5) + hash + (long)value[i];
        }
        for (i = 1; i >= 0; --i) {
            if (value[i] != (byte)(hash & 0xFFL)) {
                return false;
            }
            hash >>>= 8;
        }
        return true;
    }
}

