/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.InputSelectTag;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.util.HtmlUtil;

public class InputOptionTag
extends InputTagSupport
implements BodyTag {
    private String selected;
    private String label;
    private Object value;

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public String getSelected() {
        return this.selected;
    }

    public int doStartInputTag() throws JspException {
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndInputTag() throws JspException {
        InputSelectTag selectTag = this.getParentTag(InputSelectTag.class);
        if (selectTag == null) {
            throw new StripesJspException("Option tags must always be contained inside a select tag.");
        }
        String actualLabel = this.getBodyContentAsString();
        if (actualLabel == null) {
            actualLabel = this.label;
        }
        Object actualValue = this.value == null ? actualLabel : this.value;
        this.getAttributes().put("value", this.format(actualValue));
        if (selectTag.isOptionSelected(actualValue, this.selected != null)) {
            this.getAttributes().put("selected", "selected");
        }
        try {
            this.writeOpenTag(this.getPageContext().getOut(), "option");
            if (actualLabel != null) {
                this.getPageContext().getOut().write(HtmlUtil.encode(actualLabel));
            }
            this.writeCloseTag(this.getPageContext().getOut(), "option");
            this.getAttributes().remove("selected");
            this.getAttributes().remove("value");
        }
        catch (IOException ioe) {
            throw new JspException("IOException in InputOptionTag.doEndTag().", (Throwable)ioe);
        }
        return 6;
    }

    protected void registerWithParentForm() throws StripesJspException {
    }
}

