/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.util;

import com.sun.tools.doclets.util.PathSpecifier;
import com.sun.tools.doclets.util.Specifier;
import java.io.File;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class PackageList {
    public static LinkedList namesToSkip = new LinkedList();
    public static LinkedList pkgsToSkip = new LinkedList();
    static LinkedList rootPaths = new LinkedList();
    static LinkedList pkgList = new LinkedList();

    public static void main(String[] args) {
        if (args.length < 1) {
            PackageList.echoUsage();
            return;
        }
        PackageList.processArgs(args);
        ListIterator paths = rootPaths.listIterator();
        while (paths.hasNext()) {
            String rootPath = (String)paths.next();
            File root = new File(rootPath);
            if (!root.isDirectory()) continue;
            PackageList.findPkgs(root, root);
        }
        ListIterator plt = pkgList.listIterator();
        while (plt.hasNext()) {
            String pkgName = (String)plt.next();
            System.out.println(pkgName);
        }
    }

    public static LinkedList findPkgs(File root, File dir) {
        ListIterator skipNames = namesToSkip.listIterator();
        while (skipNames.hasNext()) {
            Specifier skipName = (Specifier)skipNames.next();
            if (!skipName.match(dir.getName())) continue;
            return pkgList;
        }
        ListIterator skipPkgs = pkgsToSkip.listIterator();
        while (skipPkgs.hasNext()) {
            PathSpecifier skipPkg = (PathSpecifier)skipPkgs.next();
            if (!skipPkg.match(PackageList.pkgName(root, dir), ".")) continue;
            return pkgList;
        }
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class") || files[i].endsWith(".java")) {
                if (root.equals(dir)) {
                    pkgList.add("(anonymous)");
                    break;
                }
                pkgList.add(PackageList.pkgName(root, dir));
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < files.length) {
            File file = new File(dir, files[i2]);
            if (file.isDirectory()) {
                PackageList.findPkgs(root, file);
            }
            ++i2;
        }
        return pkgList;
    }

    public static String pkgName(File root, File dir) {
        if (root.equals(dir)) {
            return ".";
        }
        char separator = File.separatorChar;
        int rootPathLength = root.getPath().length();
        String fullPath = dir.getPath();
        String localPath = fullPath.substring(rootPathLength + 1);
        return localPath.replace(separator, '.');
    }

    protected static void echoUsage() {
        System.out.println("usage: java PackageList {options} dir1 dir2 ... > package.lst");
        System.out.println("");
        System.out.println("options:");
        System.out.println("  -skipAll name1:name2:...");
        System.out.println("  -skip    pkg1:pkg2:...");
        System.out.println("where:");
        System.out.println("  * -skipAll designates a colon-separated list of directory names to be");
        System.out.println("     skipped at any level of the hierarchy where they occur");
        System.out.println("  * -skip designates a colon-separated list of fully-qualified package names");
        System.out.println("     to be skipped");
        System.out.println("  * the names and packages listed can be Specifier patterns");
        System.out.println("    or PathSpecifer patterns, respectively");
        System.out.println("  * the remaining command line arguments are directory paths");
        System.out.println("    to the packages");
        System.out.println("Example:");
        System.out.println("  java PackageList -skipAll SCCS:RCS:CVS -skip x.y.z  myDir");
    }

    protected static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            StringTokenizer st;
            if (args[i].equals("-skipAll")) {
                if (++i >= args.length) {
                    System.out.println("No list of names after -skipAll option");
                    System.exit(1);
                }
                String names = args[i];
                st = new StringTokenizer(names, ":");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    namesToSkip.add(new Specifier(name));
                }
            } else if (args[i].equals("-skip")) {
                if (++i >= args.length) {
                    System.out.println("No package list after -skip option");
                    System.exit(1);
                }
                String pkgs = args[i];
                st = new StringTokenizer(pkgs, ":");
                while (st.hasMoreTokens()) {
                    String pkg = st.nextToken();
                    pkgsToSkip.add(new PathSpecifier(pkg, "."));
                }
            } else {
                rootPaths.add(args[i]);
            }
            ++i;
        }
        if (rootPaths.size() == 0) {
            System.out.println("No root directories specified on command line.");
            System.exit(1);
        }
    }
}

