/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.ClassInfoVisitor;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;

public class JarDiff {
    protected Map depClassInfo = new HashMap();
    protected Map oldClassInfo = new TreeMap();
    protected Map newClassInfo = new TreeMap();
    private URL[] deps;
    private URLClassLoader depLoader;
    private String oldVersion;
    private String newVersion;
    private ClassInfoVisitor infoVisitor = new ClassInfoVisitor();

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setDependencies(URL[] deps) {
        this.deps = deps;
    }

    public URL[] getDependencies() {
        return this.deps;
    }

    private synchronized ClassInfo loadClassInfo(ClassReader reader) throws IOException {
        this.infoVisitor.reset();
        reader.accept((ClassVisitor)this.infoVisitor, false);
        return this.infoVisitor.getClassInfo();
    }

    private void loadClasses(Map infoMap, URL path) throws DiffException {
        try {
            File jarFile = null;
            if (!"file".equals(path.getProtocol()) || path.getHost() != null) {
                int i;
                jarFile = File.createTempFile("jardiff", "jar");
                jarFile.deleteOnExit();
                InputStream in = path.openStream();
                FileOutputStream out = new FileOutputStream(jarFile);
                byte[] buffer = new byte[4096];
                while ((i = in.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, i);
                }
                in.close();
                ((OutputStream)out).close();
            } else {
                jarFile = new File(path.getPath());
            }
            this.loadClasses(infoMap, jarFile);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    private void loadClasses(Map infoMap, File file) throws DiffException {
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class")) continue;
                ClassReader reader = new ClassReader(jar.getInputStream(entry));
                ClassInfo ci = this.loadClassInfo(reader);
                infoMap.put(ci.getName(), ci);
            }
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    public void loadOldClasses(URL loc) throws DiffException {
        this.loadClasses(this.oldClassInfo, loc);
    }

    public void loadNewClasses(URL loc) throws DiffException {
        this.loadClasses(this.newClassInfo, loc);
    }

    public void loadOldClasses(File file) throws DiffException {
        this.loadClasses(this.oldClassInfo, file);
    }

    public void loadNewClasses(File file) throws DiffException {
        this.loadClasses(this.newClassInfo, file);
    }

    public void diff(DiffHandler handler, DiffCriteria criteria) throws DiffException {
        ClassInfo ci;
        String s;
        ClassInfo ci2;
        Map.Entry entry;
        handler.startDiff(this.oldVersion, this.newVersion);
        handler.startOldContents();
        Iterator i = this.oldClassInfo.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            ci2 = (ClassInfo)entry.getValue();
            if (!criteria.validClass(ci2)) continue;
            handler.contains(ci2);
        }
        handler.endOldContents();
        handler.startNewContents();
        i = this.newClassInfo.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            ci2 = (ClassInfo)entry.getValue();
            if (!criteria.validClass(ci2)) continue;
            handler.contains(ci2);
        }
        handler.endNewContents();
        TreeSet onlyOld = new TreeSet(this.oldClassInfo.keySet());
        TreeSet onlyNew = new TreeSet(this.newClassInfo.keySet());
        TreeSet both = new TreeSet(this.oldClassInfo.keySet());
        onlyOld.removeAll(this.newClassInfo.keySet());
        onlyNew.removeAll(this.oldClassInfo.keySet());
        both.retainAll(this.newClassInfo.keySet());
        handler.startRemoved();
        i = onlyOld.iterator();
        while (i.hasNext()) {
            s = (String)((Object)i.next());
            ci = (ClassInfo)this.oldClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classRemoved(ci);
        }
        handler.endRemoved();
        handler.startAdded();
        i = onlyNew.iterator();
        while (i.hasNext()) {
            s = (String)((Object)i.next());
            ci = (ClassInfo)this.newClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classAdded(ci);
        }
        handler.endAdded();
        TreeSet removedMethods = new TreeSet();
        TreeSet removedFields = new TreeSet();
        TreeSet addedMethods = new TreeSet();
        TreeSet addedFields = new TreeSet();
        TreeSet changedMethods = new TreeSet();
        TreeSet changedFields = new TreeSet();
        handler.startChanged();
        i = both.iterator();
        while (i.hasNext()) {
            Map.Entry tmp;
            AbstractInfo newInfo;
            AbstractInfo oldInfo;
            String desc;
            Map.Entry entry2;
            String s2 = (String)((Object)i.next());
            ClassInfo oci = (ClassInfo)this.oldClassInfo.get(s2);
            ClassInfo nci = (ClassInfo)this.newClassInfo.get(s2);
            if (!criteria.validClass(oci) && !criteria.validClass(nci)) continue;
            Map oldMethods = oci.getMethodMap();
            Map oldFields = oci.getFieldMap();
            Map newMethods = nci.getMethodMap();
            Map newFields = nci.getFieldMap();
            Iterator j = oldMethods.entrySet().iterator();
            while (j.hasNext()) {
                entry2 = j.next();
                if (!criteria.validMethod((MethodInfo)entry2.getValue())) continue;
                removedMethods.add(entry2.getKey());
            }
            j = oldFields.entrySet().iterator();
            while (j.hasNext()) {
                entry2 = j.next();
                if (!criteria.validField((FieldInfo)entry2.getValue())) continue;
                removedFields.add(entry2.getKey());
            }
            j = newMethods.entrySet().iterator();
            while (j.hasNext()) {
                entry2 = j.next();
                if (!criteria.validMethod((MethodInfo)entry2.getValue())) continue;
                addedMethods.add(entry2.getKey());
            }
            j = newFields.entrySet().iterator();
            while (j.hasNext()) {
                entry2 = j.next();
                if (!criteria.validField((FieldInfo)entry2.getValue())) continue;
                addedFields.add(entry2.getKey());
            }
            changedMethods.addAll(removedMethods);
            changedMethods.retainAll(addedMethods);
            removedMethods.removeAll(changedMethods);
            addedMethods.removeAll(changedMethods);
            changedFields.addAll(removedFields);
            changedFields.retainAll(addedFields);
            removedFields.removeAll(changedFields);
            addedFields.removeAll(changedFields);
            j = changedMethods.iterator();
            while (j.hasNext()) {
                desc = (String)((Object)j.next());
                oldInfo = (MethodInfo)oldMethods.get(desc);
                if (criteria.differs((MethodInfo)oldInfo, (MethodInfo)(newInfo = (MethodInfo)newMethods.get(desc)))) continue;
                j.remove();
            }
            j = changedFields.iterator();
            while (j.hasNext()) {
                desc = (String)((Object)j.next());
                oldInfo = (FieldInfo)oldFields.get(desc);
                if (criteria.differs((FieldInfo)oldInfo, (FieldInfo)(newInfo = (FieldInfo)newFields.get(desc)))) continue;
                j.remove();
            }
            boolean classchanged = criteria.differs(oci, nci);
            if (!classchanged && removedMethods.isEmpty() && removedFields.isEmpty() && addedMethods.isEmpty() && addedFields.isEmpty() && changedMethods.isEmpty() && changedFields.isEmpty()) continue;
            handler.startClassChanged(s2);
            handler.startRemoved();
            j = removedFields.iterator();
            while (j.hasNext()) {
                handler.fieldRemoved((FieldInfo)oldFields.get(j.next()));
            }
            j = removedMethods.iterator();
            while (j.hasNext()) {
                handler.methodRemoved((MethodInfo)oldMethods.get(j.next()));
            }
            handler.endRemoved();
            handler.startAdded();
            j = addedFields.iterator();
            while (j.hasNext()) {
                handler.fieldAdded((FieldInfo)newFields.get(j.next()));
            }
            j = addedMethods.iterator();
            while (j.hasNext()) {
                handler.methodAdded((MethodInfo)newMethods.get(j.next()));
            }
            handler.endAdded();
            handler.startChanged();
            if (classchanged) {
                handler.classChanged(oci, nci);
            }
            j = changedFields.iterator();
            while (j.hasNext()) {
                tmp = j.next();
                handler.fieldChanged((FieldInfo)oldFields.get(tmp), (FieldInfo)newFields.get(tmp));
            }
            j = changedMethods.iterator();
            while (j.hasNext()) {
                tmp = j.next();
                handler.methodChanged((MethodInfo)oldMethods.get(tmp), (MethodInfo)newMethods.get(tmp));
            }
            handler.endChanged();
            handler.endClassChanged();
            removedMethods.clear();
            removedFields.clear();
            addedMethods.clear();
            addedFields.clear();
            changedMethods.clear();
            changedFields.clear();
        }
        handler.endChanged();
        handler.endDiff();
    }
}

