/*****************************************************************************
 Copyright (c) 2023-2024, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* SM3  */
#include "mac_test.h"

const struct mac_test sm3_test_json[] = {
        /* Vectors from a generator script */
        { 0, 256, 1, NULL,
          "\x21\xf2\x27\x41\xf1\x7b\xe7\x3b\x74\x08\x40\x66\xd1\x5f\x0f\x9e\xd6\xcf\x29\xd3\x25\xc1"
          "\xe9\xce\x6e\x61\xe7\xf4\x7c\xcf\x2c\xe7\x22\x04\xb5\x07\x83\x5a\xf3\x3e\xb1\x07\xa2\x71"
          "\x31\x4a\x65\x8c\x76\xbd\x53\xff\x7f\xbd\x03\x08",
          "\x7a\xd6\x85\xe5\x90\x99\xd6\xeb\x11\x6e\x3e\x6e\x39\x08\x3f\x44\x36\xf2\x02\x1a\x89\x0e"
          "\x93\xb9\x1a\x3b\x8d\x1d\xbd\x50\xb6\x4b",
          1, 448, NULL, 0 },
        { 0, 256, 2, NULL,
          "\x25\x7f\x7e\x16\x0f\xd2\x41\x06\x07\x52\x06\xf3\xff\x36\x37\x68\x2e\x59\x33\xfd\xe3\x94"
          "\xea\x81\x82\x30\x16\x4b\xea\x28\xeb\x3d\x1f\x52\x3c\x62\x96\xcf\xee\x91\x4c\x54\x28\xda"
          "\xdd\x6a\xa9\xad\x88\x84\xce\xd3\x2d\xd8\x4e",
          "\x6e\xcc\x9a\x09\x46\xe1\x3b\x3b\x27\x9c\x01\x42\x4d\x15\xb7\x41\x32\xfb\x72\xd9\x03\xe9"
          "\x48\xc3\x29\x4f\xf2\x75\x2a\x4a\x85\x7e",
          1, 440, NULL, 0 },
        { 0, 256, 3, NULL,
          "\x3f\x89\x42\x20\xe2\x3d\x37\x4d\x51\x71\xc0\xf1\x11\xaa\xd7\xe3\xdd\x03\xfa\x65\x3e\xfa"
          "\x38\xe6\x6c\x2a\xf4\x2c\xb0\xca\x71\x5a\x54\xc5\xb5\xfc\x4f\xae\xca\xe5\x31\xaf\xc0\xed"
          "\x41\xf4\xaf\xe4\xb4\x3a\x68\xcd\xca\xa9\x35\x88\x36\x94\xf6\x7b\x8a\x58\x4d\xed\x0a\xa0"
          "\x42\xa3\x96\xd8\x5d\xdf\xcc\x03\x2f\xf4\xfb\x25\x0e\x5d\xe9\xec\x00\x14\x57\x99\xb0\xc6"
          "\x05\xa0\xfa\x01\x8f\xcf\x82\xd8\xf0\x1e\x3a\xcd\x3b\xfd\x25\x71\xb4\x02\xa9\x5b\x17\xc4"
          "\x8b\x7a\x40\x2d\xc0\x4b\x26\xe4\x45\x47",
          "\x61\xc6\x17\xfa\x5d\x1f\xf2\xda\x3d\x46\xb7\x21\x02\x4d\xde\x5f\xe7\x3b\x1e\xf8\x50\x8b"
          "\x31\xe8\xa3\xc6\x3a\xde\xf2\x62\x8f\xb2",
          1, 960, NULL, 0 },
        { 0, 256, 4, NULL,
          "\x72\x08\x5f\x20\x7e\x8d\x02\x7a\xd5\x66\x06\x8f\xa7\xbc\x11\xb8\x59\x57\x39\x9a\xd4\xbd"
          "\xe5\xbb\xf4\xf1\xcc\x58\x6e\x3d\xce\x73\x73\xe9\x30\xf1\x83\x26\x7e\xeb\x8a\x16\xa5\xb6"
          "\x40\xa7\x92\xa1\x9b\x29\x15\x3b\x1b\xfc\x29\x6e\xc4\xc5\xa7\x1c\xef\xba\x2f\x10\x59\x2e"
          "\xd7\x19\x0e\xdf\xe5\xe0\x17\xfc\x7c\x0d\x61\x7c\x34\xc3\x91\x76\xf2\x0f\x64\xdd\x83\x7e"
          "\xb7\x4a\x98\x0a\x5e\xe0\xba\x48\xd4\xc7\x91\x86\xad\x94\x73\x37\x14\x2e\x60\x24\x28\xcf"
          "\xfd\x5b\x96\x89\x6f\xae\x9f\x16\x8a",
          "\xcb\x82\x5d\x42\xa9\x5e\xec\x9c\x91\x7c\x8c\x70\xc6\x49\x63\xbc\x0a\x65\xdd\xdc\x9a\x59"
          "\xcc\xf3\x9b\xe2\x57\x97\x7d\x5d\x53\xeb",
          1, 952, NULL, 0 },
        { 0, 256, 5, NULL,
          "\x61\xa2\xef\x71\x7f\xee\xde\x61\xe2\xe4\x9a\x24\x4f\xe6\x1b\xcd\x3e\xbc\xd8\xba\xe4\x00"
          "\xa5\x08\x87\xc8\x7b\xa1\xc2\xf9\x58\x44\x19\x87\xd3\x43\xd9\x1a\x2f\xba\x3f\x2b\x3a\x8b"
          "\xe1",
          "\x1c\xd0\x5b\xe1\xb3\x60\x78\xf3\x3e\x7b\xe5\xb2\xb6\x8b\x47\xa3\x80\x43\x70\x69\x0d\x1a"
          "\x16\xe1\x3d\xfc\x16\x00\x80\xd1\x6c\x2c",
          1, 360, NULL, 0 },
        { 0, 256, 6, NULL,
          "\x36\xfe\x9e\x35\x79\x86\x37\x4a\x61\xea\x12\x4b\xa8\x0c\xc4\xf8\xd7\x20\xd6\x71\xc0\x5f"
          "\x13\x30\x2c\x6c\xac\xc4\xf1\x0c\x69\x23\xc2\x32\xfa\x82\xe1\x49\xda\x2e\x2c\x9a\xc4\x87"
          "\x4c\xdc\x45\x42\x0f\xc7\x27\xb8\x09\x70",
          "\x4d\x34\x8b\xdf\x16\x10\xb6\xa6\x14\xe9\x08\xef\x3c\x27\x16\x63\x0f\x86\x13\xeb\xe5\x33"
          "\x3d\x85\x3b\xa8\x1b\x6f\xdf\x43\xfe\xfb",
          1, 432, NULL, 0 },
        { 0, 256, 7, NULL,
          "\xe5\x46\x62\xa0\x34\xce\x5b\x8d\x57\x57\xd0\x1b\x8b\x96\xd7\x38\x25\x44\x51\xd6\x88\x10"
          "\x28\x5f\x76\xb3\xad\x45\x27\xce\x35\x78\x51\x8a\x38\x94\x21\xa4\xb3\x67\x3e\x4a\xac\x5b"
          "\x89\xec\x2a\x83\x2e\x7e\x93\x2b\x56\xb4\x0b\xce\xc6\x4d\x6a\xde\xc6\xca\xe0",
          "\x17\x83\x38\x9f\x15\x6e\xdf\xc4\x8e\x91\xc9\x6a\xe2\xdd\xb2\x7c\x46\xce\x40\x5d\x99\x3b"
          "\x53\x24\x38\xc4\xf4\x81\x76\x04\x28\x8f",
          1, 504, NULL, 0 },
        { 0, 256, 8, NULL,
          "\x57\x5e\x2c\xd0\xc3\xa6\x1f\xff\xe6\x36\x44\x6a\xc5\xc0\x87\xeb\x1a\xe5\x0d\xc4\x54\x60"
          "\x36\x14\xfa\x6b\xb3\x29\xaf\x6a\xe9\x8a\x50\x2d\x8f\x9b\x6b\xdd\x26\xa5\xa1\x7c\xab\xa6"
          "\x27\xf1\xcd\xf2\x83\xad\xa1\xf5\x55\x56\xdc\x72\x2b\x85\x74\x6a\xd0\x2b\x6c\x79\x4a\x93"
          "\x97\x39\xfc\xa1\x65\x96",
          "\x5a\xdc\xb3\xfc\x04\x9e\xfa\x4f\xd9\xb0\xd7\xf0\x08\xc4\x07\xee\x8c\xe3\x99\x45\x0a\x46"
          "\xf1\x83\xe3\xb9\x0c\xe7\xa4\x7c\x92\x7a",
          1, 576, NULL, 0 },
        { 0, 256, 9, NULL,
          "\x3f\xa7\x24\x18\x2e\xc1\xaf\xae\xe1\xb9\x70\x48\xa8\xbe\xf3\x0b\x73\x1e\xfb\x64\x9a\x28"
          "\x58\x55\x2c\xe2\x99\x4c\x33\x3d\x3e\x06\x69\x9f\x76\x42\x1f\x48\x99\x9f\x1c\x6a\x0c\xa0"
          "\x5d\x5d\xdc\xf1\x37\xf0\xca\xbe\xc2\x91\xe7\x14\xad\xbf\x8a\x12\x67\x86\xa5\x61\xb9\x03"
          "\xef\xa4\xfe\x8d\x97\xe4\x20\xce\xcc\xa0\x97\xbb\x5b\x7d\xfc",
          "\xc7\xe5\xb3\xe2\xc5\x34\x91\x3d\x8a\xe5\x62\x74\x90\x9c\x71\x16\xdb\xbe\x0d\x0d\x97\x7b"
          "\xda\xb0\x9b\xe7\x73\xed\x4e\xcf\x21\x4f",
          1, 648, NULL, 0 },
        { 0, 256, 10, NULL,
          "\xaa\xb1\x12\x21\xc7\x43\x80\x95\xfb\x73\x21\xab\xfc\x1c\x16\x6a\x88\x32\xbb\xef\x16\x30"
          "\x81\xf7\x4b\x06\x74\xa8\xba\x9c\xac\x2e\x13\x62\x49\x33\x2f\xa4\xae\x63\x8f\xf8\x0e\xd5"
          "\x9a\xc9\x87\xbb\x30\x63\xad\x07\x4a\x1f\x44\x2a\x4f\x69\x29\x9b\x98\x84\x17\x2a\x9a\x6f"
          "\x4d\x7c\x6b\x5e\x35\x76\x32\xdd\x97\x86\x65\xf6\xf4\x70\x5c\xc4\xb4\xc9\xf2\xb3\x78\xe2"
          "\xd6\xda",
          "\x24\xa9\xd6\x5c\xb5\xb0\xb3\xa5\xd5\x79\x93\xb1\x07\xd4\x84\xcc\x7b\x7a\x16\x3d\xeb\xe8"
          "\x2b\x7e\x93\xf8\x56\x9e\x12\x1c\xaf\x4e",
          1, 720, NULL, 0 },
        { 0, 256, 11, NULL,
          "\x0f\x33\x1a\x6a\xec\xdf\xda\xc3\xa6\x34\xce\xad\x93\xe5\x7b\x81\xcc\x57\xcb\xab\xd6\x59"
          "\xa1\xbe\x95\x0c\xf1\x94\xb1\xdf\x03\x24\x26\x42\xe3\xfc\x4f\xec\x4f\x6f\x8d\xf6\xbe\xe8"
          "\xc1\x8a\xb9\x0e\xfb\xa4\xae\xa9\x12\x40\x25\x5e\xab\x5c\x5b\x1a\xe5\x09\x40\x9e\x39\x67"
          "\x9b\xb7\xc1\x79\x21\x88\x6a\x55\x29\xf4\x68\x3d\x78\x61\x40\x52\xb7\x38\xf0\x66\x0b\xcf"
          "\x85\xf7\x3e\x48\xee\x7d\x7f\x47\x53\xc8\xd4",
          "\xde\xf9\xa4\xa7\x56\x2e\xc4\xda\x8a\xa7\x35\xd4\x63\x3f\xf5\x88\x10\x75\x70\x91\xdc\xaf"
          "\x32\xd6\xb1\xf1\x93\xeb\x69\x24\x3d\x7b",
          1, 792, NULL, 0 },
        { 0, 256, 12, NULL,
          "\x49\xfe\xd7\x19\x15\x07\x31\x2c\x2b\xa7\xda\x0d\xc2\x2a\x5f\x1b\xbd\x06\xdd\xd9\xf3\x6e"
          "\x6e\xc3\x53\xbb\xa3\x04\x99\x22\x49\x92\x15\x37\x42\x3e\x20\xc2\xf7\xd3\x7f\x09\x45\xc4"
          "\xce\xab\x69\xc1\x6e\xbe\xc9\x2d\xa7\xaa\x1f\xc5\xbf\xa4\xa9\xc1\x17\xd5\xf0\xe6\x88\x41"
          "\xd0\x12\xa3\xe6\xe1\x8c\x10\xd3\x5d\xaa\x43\x86\xac\xea\xc8\x92\x0d\xf7\x8a\x42\xaa\xdb"
          "\x88\xa8\x4b\xe7\x5d\x27\x46\x5d\xc0\x18\xe3\xc9\x85\x55\xea\xa6\x52\xd1\xab\xda",
          "\x6f\x89\xc8\x23\x77\x53\x08\x09\x8d\xaf\x45\x0f\xcc\x41\xd1\xa9\xa8\x27\xc9\x2c\x79\x33"
          "\xf6\x24\x0a\x2d\x51\xec\xcb\x8b\x6b\x99",
          1, 864, NULL, 0 },
        { 0, 256, 13, NULL,
          "\xf2\xf4\x98\x44\x41\xcb\xaf\x68\xa7\xa6\x10\x5f\xa4\xd8\x8c\xf6\xd3\x2d\x58\x2a\xa9\xce"
          "\x34\x42\xde\x8e\x77\x3f\x5c\x18\x23\x68\xab\x42\xfd\x27\xee\x08\x42\xae\x63\x92\x42\x27"
          "\x3f\xb0\x1d\x37\x23\x35\x05\xc7\xdb\xd5\xff\x66\xac\xd4\x0f\x8b\x3d\x3f\xab\x38\x0f\x19"
          "\x17\x79\xda\xcd\x7a\xeb\xd0\x44\xef\xc0\x45\xc6\x07\xe7\x01\x31\x0a\xde\x61\x6f\x7b\x56"
          "\x06\x6d\x08\x95\xed\xc9\xcc\xb9\x0c\xa9\x11\x97\x46\x04\x0d\xee\xe7\xc0\x74\x07\xa2\x8c"
          "\x45\x06\x40\xec\x58\xd7\x11",
          "\x25\x0e\xf6\xf0\xd2\x84\x99\x2a\xad\x3a\x07\xc2\x36\xbc\x02\xbc\x56\xf3\xb2\x3e\x1d\xb4"
          "\x3d\x54\xaa\x62\x2d\x4d\xf2\x11\x8e\x28",
          1, 936, NULL, 0 },
        { 0, 256, 14, NULL,
          "\xa6\xb9\xe1\xe1\xdc\x0a\xbf\xfe\x08\x89\xb5\x7c\x5c\xca\x75\x85\x57\x77\x33\x81\x09\x32"
          "\x78\xca\xdd\x46\x95\x63\xe8\x85\x83\x35\x68\xb8\x8c\xd5\x17\x56\xe7\xfc\xe1\x3e\x2a\x4a"
          "\x44\x9a\x2c\x4b\xe2\xe8\x97\x46\xee\x6a\xa3\x4d\x3d\x08\xb4\x71\x44\xb7\x0a\x22\x2f\x6f"
          "\x6e\x87\x2a\x37\x52\xbf\x7a\x84\xaa\xb9\x18\xb0\xb9\x47\xa4\x46\x43\x56\x9b\xfd\xe1\x52"
          "\x47\xf7\x0d\x29\xea\x26\x0b\xb2\x26\x87\x7e\xf8\xbc\x9c\x75\x2a\x00\x4f\x5b\xa4\xbe\x44"
          "\xe8\xb9\x6a\xf2\x97\x5d\xb4\xe8\x20\x4c\x1a\x49\x0f\xb6\x31\x7b",
          "\xce\xea\x45\x7e\x5b\x0a\xd1\x09\xaf\x69\xb8\x66\x0a\x80\x0b\x4f\x88\x59\xa0\xde\xfe\x26"
          "\x2b\x6c\x00\xa4\xd8\x4e\xbb\x9d\x17\x3d",
          1, 1008, NULL, 0 },
        { 0, 256, 15, NULL,
          "\x56\xbb\x53\xb6\xf4\x01\x2d\x02\xa2\x75\x7f\x1c\x51\x25\x27\xbb\xe5\x86\xe4\x0f\x3c\x63"
          "\x62\x21\x31\x68\x25\xca\xca\xa7\xc7\xaa\x7c\x34\xf9\xce\xb8\x95\xd5\x73\x04\x18\x40\x21"
          "\xdc\x79\x66\x64\x27\x9c\xc0\x34\x84\x3b\x74\xc0\xc8\x4c\x25\xaf\x0f\xa5\x57\x73\x48\xc6"
          "\x02\xb8\x33\x4f\xd9\x0d\x23\x4e\x7b\x91\x03\x3a\x5c\x34\x56\x51\xa2\xf1\x2c\x6e\x9b\x9f"
          "\x23\xf4\x1d\x55\x26\xee\x9d\xc6\xd0\xf4\x2b\xd5\x75\x45\x28\x17\x43\x17\x00\xf4\xa6\x05"
          "\xd4\x91\x76\xe9\xc7\x1b\x50\xea\x2c\xd6\x1d\xfd\x14\xa9\x70\x0b\xe9\xff\x7c\xad\x73\xb6"
          "\x4a\xd2\x87",
          "\x81\xf2\xe0\xcc\x32\x5b\x46\xf5\xb5\xa3\x18\xc5\x11\x1a\x7c\x0e\x88\x36\x4c\xdc\xdc\x8b"
          "\x35\xa1\x74\x34\x98\x28\x2c\x29\xcf\x37",
          1, 1080, NULL, 0 },
        { 0, 256, 16, NULL,
          "\xcd\xb3\x6d\x98\xa2\x48\x85\x67\x98\xa9\xdd\x2e\xd9\x9d\x88\x3d\xee\xe9\x42\xcb\x17\x9d"
          "\xf1\x5e\x5e\x78\xaa\x33\x42\x2c\xdf\xe2\xa4\xba\xb9\x13\x44\x8d\xa9\x69\x03\x7f\x97\x67"
          "\x43\x30\x2c\x2f\x75\x46\x40\x3e\xfc\x5f\xab\xb1\x3c\x7d\x51\xdb\xd6\x3c\x29\x84\x99\xe3"
          "\xf1\x64\xdb\x3c\x80\x08\x50\xa7\x2c\x1e\xb5\x6c\x17\x20\x59\xf1\x46\xb7\xfe\xb7\x61\x65"
          "\x85\xd2\xc9\x68\x50\x7a\x91\xe6\x13\x77\x5c\x0d\x63\xd1\x07\x9d\x6e\x1e\xa7\x86\x2d\x34"
          "\x04\xa7\xe8\x08\x76\xd1\x3e\x99\x67\xa9\x21\xd0\xea\xa2\xdb\xf1\x58\xd9\x12\x06\xb1\x77"
          "\x66\x9c\xf5\xa1\x24\xea\xae\xed\x6d\x80\x79\x0c",
          "\x5c\x39\x16\xff\xa8\x14\x63\x80\x11\x9e\xbc\x96\xdd\xab\xa8\x3f\x02\x93\x24\xf9\xa7\x81"
          "\xc7\xd3\x95\x11\x9f\xbf\x69\x05\xd8\x4c",
          1, 1152, NULL, 0 },
        { 0, 256, 17, NULL,
          "\x11\xb9\x8f\xec\x5d\x0e\x0b\x83\xb3\x32\x41\x99\x24\xa8\x7a\x26\x24\x5c\x0d\x23\xa5\xc5"
          "\x83\x1d\xc3\xda\x2b\x8e\x79\x6c\xd9\xfc\x05\x28\x94\x0d\x83\xd9\xe2\x78\xf1\x79\x1f\x20"
          "\x53\x29\x06\xa0\x91\x86\xe6\x0e\x44\x18\x41\x86\x7d\x0a\xba\x03\xe7\x28\xc3\x9b\xc6\x1f"
          "\x6f\xa3\xe7\x13\x76\x61\x90\xe4\x7f\xdf\x42\x72\xe1\x7d\xe3\x0a\xfd\xb4\x87\x6c\x2f\x13"
          "\x80\x62\x32\xfb\xd0\x61\xfe\x3e\x1c\x7f\x5b\x2a\x43\x9a\x63\xbc\x33\xca\x7d\xc0\xfa\x2b"
          "\x17\x79\x13\xf3\x1f\x10\xec\x42\x52\x8f\xe2\x17\x5d\xd1\x99\xdb\x9c\xbf\x85\x58\x59\x01"
          "\x2d\xf1\x10\x22\xbf\xd0\xa4\x05\x92\xb9\x0d\x08\x3b\xbd\x5e\xe1\xf0\x67\xd8\xef\xa5\xab"
          "\x1c\x9b\x9a\xfc\x6b\x2f\xee\x89\x2e\x42\x27\x17\x9c\x2a\xd0\x19\xba\x45\x82\x6b\x16\xa9"
          "\xcf\xcb\xf9",
          "\x28\xa5\xae\xdc\x2f\x58\x1a\x86\x36\xcb\x08\xf4\x78\x05\xdf\xad\x97\x2b\x38\xbe\xeb\x77"
          "\x1b\x69\xba\x8d\x15\xa3\xda\x4f\xb3\xe7",
          1, 1432, NULL, 0 },
        { 0, 256, 18, NULL,
          "\x00\xa7\xa4\xe1\xe7\xe4\xc6\xde\x3a\x48\xe9\x64\x0f\xb9\x40\xbd\xb9\x30\x9c\x27\x5f\x59"
          "\x18\x1b\x72\xf3\x6e\xac\x5a\x57\x24\xab\x97\x4d\x72\x59\x24\x79\x8a\x33\xb3\xbe\xb3\x46"
          "\x6a\x0c\x11\x04\x9e\x56\x05\x7e\x1f\xe3\xc8\xc3\x70\x80\xd5\xf9\xdc\x32\x70\xa0\x4e\x43"
          "\xa5\x65\xd8\xb8\xb2\xd0\x45\x35\xd8\xfe\xfa\x6a\x4e\x90\xb3\x5e\x25\xe4\x26\xcc\xad\x7f"
          "\xd1\xa3\x7e\xa8\xa7\x07\x7a\x48\x06\xfd\x44\x16",
          "\xd6\x53\xba\x62\x3c\x60\x3e\x86\x23\x39\x7c\xec\x03\xc8\x81\xcf\x85\x37\x8d\x47\x8f\x82"
          "\x63\x7a\x5c\xc8\x7d\x54\xfa\x23\x31\x6f",
          1, 800, NULL, 0 },
        { 0, 256, 19, NULL,
          "\xc3\x7e\xbd\x8a\xb7\x00\x63\x5b\xcb\xd5\x23\x31\x76\x92\x77\x17\x7a\xdc\x5a\x32\xf5\xb2"
          "\x96\x5b\x9e\x50\xa2\x04\x3c\x13\x17\xde\xa4\xc3\x68\x4f\xfd\x9a\x59\x92\x26\x27\xc8\x57"
          "\x44\x80\xa0\x05\x42\xca\x79\x17\xde\x8c\x2f\x06\x43\x4b\x70\xb9\x62\x3c\x17\xae\x77\x1a"
          "\x67\x6a\x78\xb6\xc3\xd2\x78\x0d\x6a\x0a\x64\xfc\xb6\xc7\xc7\x0c\xb8\x4d\xae\x07\xd7\xe5"
          "\x77\xcd\xb9\x5a\x32\x57\x27\x21\x1c\x2c\x0e\x54\xb3\x09\x4e\xc2\x7a\x15\x15\xf0\xf6\xfe"
          "\x69\xed\x71\x26\xad\xbd\x1d\x1e\xd8\x7c\x66\xb0\x27\x47\x30\x5c\x54\xc2\xc9\x41\x69\x75"
          "\xb5\x0f\x19\x37\x04\xd9\x31\x23\x00\xc2\x4d\x18\xcf\x11\x34\xb0\x40\xf6\x0b\x39\xbb\x43"
          "\xda\x16\x08\xcf",
          "\x0d\x6b\x5d\x11\xcd\x3b\x50\x67\x76\xab\xa6\xe0\x76\x12\x76\x67\x88\x29\x59\xfa\xb2\xdc"
          "\x7a\x3b\x2e\x98\xd5\x8a\x33\xa7\xe3\x56",
          1, 1264, NULL, 0 },
        { 0, 256, 20, NULL,
          "\x31\xdf\xd0\x5e\xc7\x24\xa2\x86\x6e\xd8\xac\x2a\x74\xe5\x74\x38\x3e\x50\xad\x44\x7a\x06"
          "\xac\xad\x8f\xc7\xbd\x45\xee\x0c\x50\xa8\x1f\x11\xd9\xec\x7c\x5b\x00\xd3\x3d\xa7\x64\x0e"
          "\xc9\x76\x6f\x12\xa1\x74\x75\x44\xa6\x9d\xd2\x64\x50\x51\x1d\x1d\xde\xe8\x88\x41\x36\x0b"
          "\xf8\x56\x9e\x29\x81\x71\x40\xf1\x61\x06\x72\xcf\xdc\xe4\x91\xdc\xb9\xf2\xf1\xe9\xe2\xf0"
          "\xa2\xd1\xc6\x89\xb5\xf6\xe4\xe3\xba\x4c\x50\xbf\x06\x97\x24\xa9\x60",
          "\xda\xcc\x85\x43\x6b\x2e\x57\xcd\x5d\x8b\xb7\xd5\x17\x38\x3c\x71\xc3\xcc\x5e\x4b\x2c\xe9"
          "\x30\xda\x23\x81\xd7\x2a\x59\xe4\x0a\x73",
          1, 840, NULL, 0 },
        { 0, 256, 21, NULL,
          "\x4f\x33\x8c\x0e\x7e\xc6\x12\x36\x38\xb2\x95\xaa\x77\x2c\xf3\xe4\x4b\xb8\x0c\x3a\xb9\x23"
          "\xa6\xc3\x88\xd4\xc4\xa2\x9d\x17\x8a\x66\x3d\x06\xf4\xea\x16\x7e\x0a\x78\xe6\x73\x12\x8a"
          "\xac\xdb\x6f\x5c\x8d\x37\xbd\x84\x7e\x08\xd7\x88\x91\xeb\x34\x58\x76\x1e\x39\x16\xa9\x8e"
          "\xe4\x26\x27\x01\xf8\x43\x7a\x82\x64\xac\x78\x16\x7c\x09\xd5\xb2\x18\x8b\x18\x7b\x15\x1e"
          "\xce\x5c\x04\xce\x0a\xd6\xa9\x23\xf5\xef\xc7\x99\x8e\x95\xcd\xb7\xc5\xc6\xbf\x11\x63\x18"
          "\x6a",
          "\x56\x55\x1b\x88\x96\xb2\x98\x4f\x86\xee\x2a\x64\x69\xed\x5d\x55\xc9\x04\x55\xe6\xa8\xcb"
          "\x9c\x98\xb4\xee\x7e\xf3\x03\xbd\xa4\x91",
          1, 888, NULL, 0 },
        { 0, 256, 22, NULL,
          "\x6b\x83\xd8\x9b\xf0\x6b\x7e\xa5\xe8\xcc\x0f\x45\x62\x09\x27\x57\xbd\xdb\x95\x9c\xdd\x19"
          "\x21\x3a\xc2\x6c\xfd\x11\x47\x18\x95\x84\xa1\xb8\xf6\x26\x30\x1c\x67\x4e\x5a\xeb\xdf\x7a"
          "\x1c\xce\x62\xe8\x64\xb9\xe4\x5f\x50\x5a\x9f\x69\x9a\x63\xcd\x2e\xcb\x8a\x04\x55\xf9\xb8"
          "\x62\xb6\xc8\x38\x8a\x66\x2c\xe4\xd3\x04\xb6\xae\x05\x90\x05\x32\xdf\x57\xec\xc0\x67\xd6"
          "\x43\xf7\x6b\x74\xc2\x8f\xb3\xc0\x28\x44\xa1\x17\x71\x80\xb4\xbc\xb6\x75\xa8\xe4\x9c\x99"
          "\x82\x7a\x93\xb0\x10\x53\xa3\x90\xea\xe5\x98\xf7\x4d\x38\x1e\x99\xd6\x1e\xd1\x7b\x50\x23"
          "\xc1\x69\xae\xb1\x24\xf3\x2b\xb9\x73\x0b\x97\x25\xc6\x7d\x94\x56\x4f\xb5\x58\x56\xd1\x51"
          "\xc3\x87\xb3\x1c\x20\x47\xcc\x1f\x82\x11",
          "\x82\x9c\xcb\x68\xad\xb2\xbb\x82\x77\xf3\xaf\x89\x11\xe5\xc7\x50\x8e\x6c\x11\x85\xb1\xc6"
          "\xaa\xe8\xbc\x66\x79\xa2\x17\xba\xcb\x8a",
          1, 1312, NULL, 0 },
        { 0, 256, 23, NULL,
          "\x6e\x7e\x66\x1c\x4b\xd1\x9e\xf5\x2d\x8b\x11\x47\xb9\x6e\xf0\xb4\x4e\x8a\x46\x52\x62\x76"
          "\xcf\x57\xba\x07\xff\xff\x37\xa4\xcb\xdc\xca\xc4\x12\x8e\x67\x37\x39\x38\x10\x1f\xe9\xa8"
          "\xe4\x48\xbd\xaa\x6f\x10\x2c\x7c\x75\x35\x16\x87\xdb\x0b\x41\xb1\xbc\xb2\x71\xd2\xef\x8a"
          "\x56\x70\x38\x93\xe5\x79\xb9\x63\x2a\x09\xc3\x35\xe9\xf4\x8d\xb2\x32\xda\x37\x36\x50\x82"
          "\x1b\xef\x29\xc5\xf4\x71\xac\xfb\x7f\x8b\x65\x6d\xf0\xae\x1c\x83\xd0\x88\x72\x90\xc4\xb5"
          "\x60\x94\xf7\xcc\xd3\x8f\x23\x08\xe5\x25\x60\x5b\xd6\xab\xcc\x1a\x7d\x17\xa8\x46\x82\x26"
          "\x1c\x30\x13\x60\xfc\xa6\xca\x8b\x53\x26\x09\xb9\xb1\x0a\x3e\x4c\xb3\x27\x7c\x18\x58\x37"
          "\xc2\xd3\x77\x67\xed\xec\xe9\xd7\x40\xb0\x1a\x93\xb6\x7e\x31\xc7\xa4\x86\xa3\x28",
          "\x56\x79\x32\x7d\x12\xc4\x9d\x5b\xa5\xc2\x38\xb1\x50\x34\x26\x91\x9c\xcb\xc6\xd9\x54\xf0"
          "\x7c\x0c\xdf\xc0\xa0\xe8\xff\xa2\xfc\x74",
          1, 1392, NULL, 0 },
        { 0, 256, 24, NULL,
          "\x3e\xe0\x7d\xfc\x14\x2d\xed\xc2\x47\xd3\xaf\xa7\xa8\x0f\x56\xca\xc3\x8b\x4e\x8d\x2b\xa1"
          "\x65\x71\xf9\x1e\xb3\xc5\x53\xd7\x91\x83\x9b\x0d\xf2\x2e\x83\x0e\xa6\x31\xb4\x63\x67\x34"
          "\x23\x3b\xac\x9f\x3d\x2a\xd6\x38\x52\x9a\xfc\x38\x18\x0f\x62\x4d\xe8\x4b\xb8\x7e\x45\x5f"
          "\x28\xfe\x44\xc4\x16\xf9\x1f\x03\x06\x67\xc9\x2b\x3d\x98\xd5\xff\xe6\xdb\x8b\x70\x0f\xaa"
          "\x02\x20\xe9\x83\xeb\x3a\x42\x8e\xc3\x90\x79\xb0\x07\xa3\xf6\x5e\xb9\xa9\xe3\x81\x3c\x4c"
          "\xc9\xec\xac\x10\x3f\xcb\x35\x46\x98\xf7\xab\xd0\x13\xbf\x75\x6b\x41\x90\xaa\x4c\xa0\x99"
          "\x06\x25\x5a\x31\x2a\x5a\xc3\x09\x08\x35\x2d\x80\x8d\xbd\x89\xe8\x7a\x10\x28\xe9\xe5",
          "\x61\xf0\x05\x61\x80\x5c\x56\x16\x67\xb1\x07\x9b\x31\x10\x55\xc9\x4c\x99\x39\xf6\x68\xb4"
          "\x7b\x56\x71\x7f\x67\xc8\x12\xde\xca\x0a",
          1, 1224, NULL, 0 },
        { 0, 256, 25, NULL,
          "\xd9\x23\x41\xec\xb1\x28\xe5\x67\x81\xc1\x53\xc7\xbe\xa7\xfa\xb9\x0b\xf0\x6e\x73\xf5\x09"
          "\x3e\xe3\x90\xa5\x3a\x1c\xe8\x08\x28\x56\xb8\xbe\xe1\x38\xb1\x68\x09\xae\x25\x11\x28\x03"
          "\x0e\x7c\x38\xbd\x80\x8d\x0b\x7e\x46\x5e\x00\xa0\x70\x50\xac\x7c\x92\x72\x45\xb7\xe1\x4a"
          "\x40\xd3\xf3\xf5\x17\x5d\xd3\xc3\x9a\x63\xa4\x5e\x0c\x69\x32\xad\x62\x55\x62\x14\x74\x87"
          "\x16\xdd\x34\x93\x60\x8e\xb7\xb6\x6b\x44\xa6\x07\x77\x51\xa3\x86\xe6\x0b\xbf\xf6\xd9\x52"
          "\x3e\xa0\x06\x03\x4a\xbd\xac\xdb\x23\x79\x71\x6f\x4c\x0d\xfa\xe5\xa4\x2f\x71\xe3\xbf\x9d"
          "\x96\xff\xf2\x53\x0a\xec\xc8\x26\x97\xba",
          "\xf3\x43\xff\xfe\xa2\xcb\xc7\x88\xc7\xa7\x16\x33\xba\xfe\x9d\x26\x64\xd4\xb1\xfc\xbb\x07"
          "\x7e\xa6\xc2\x9a\x1f\xe0\x55\x42\x2e\xdd",
          1, 1136, NULL, 0 },
        { 0, 256, 26, NULL,
          "\x49\x10\x5c\x3f\x30\x8f\xfc\x72\xd1\xcc\xc5\xcc\x58\x36\x60\xbf\xe0\xe2\x74\x53\xca\x06"
          "\xa0\x88\xbb\xf0\x6e\x25\x8b\xa2\x1e\xcf\x2e\xa3\x53\xd8\x6b\x4c\xaf\xa6\xe4\xfc\x01\xc0"
          "\x74\xb8\xea\x96\xd3\x1a\x49\x52\xdb\x1f\x49\x6c\xe5\xb4\x5c\xfa\x8d\xb0\xd1\x5d\x04\x76"
          "\xe2\xc4\x6d\x58\x50\x9e\x67\x3f\x60\x56\x4a\x26\x36\x20\xbc\x88\x72\x7f\xdd\xda\x28\xda"
          "\x21\x1a\x1d\x30\x3d\xe4\xb4\x8b\x95\xb7\x1e\x9c\xb0\x98\x41\xe2\xd7\x37\x76",
          "\x7f\x37\x3a\x4b\xd3\xdd\xf1\x1e\x5d\x51\xbf\x2c\xd5\x4e\xea\x0b\x60\xd2\xea\x11\xaf\xfd"
          "\xae\x3f\x20\xcb\x1f\xa2\x9a\xa5\xd8\xf9",
          1, 856, NULL, 0 },
        { 0, 256, 27, NULL,
          "\x3b\x74\xc1\xca\x69\xfb\xcf\x06\x89\x76\xdb\xd0\x52\xc5\xf0\xac\xc5\xfb\x26\x74\x86\xca"
          "\x33\x31\xb8\x0b\xef\x64\x62\xa2\xdf\xcd\x06\x4a\xe3\xf3\x09\x5d\x8c\x7a\xca\xfd\xba\x52"
          "\x5b\x78\xa1\x22\xce\xc6\x66\x4b\xc8\x55\x54\xd7\xbf\xe3\x62\xa9\xb3\x3e\xb1\x19\xae\x8a"
          "\xf8\x95\x0e\xee\x88\x0f\x25\x2f\x08\x8a\x59\xab\xdf\x4a\xb9\xda\x9f\x9c\xce\x65\xd5\xa8"
          "\x94\xa3\x52\xe3\x6c\x60\x93\x0c\x76\x8a\x66\xf0\x06\x5d\x8a\x7e\x84\x6b\x88\xac\x46\xb5"
          "\x8e\x05\xa0\xa1\xf6\xe7\xd6\x42\xe8\x4d\xee\x67\xf7\x24\xfe\x5a\xc6\x67\x81\xe3\xc0\xf0"
          "\x07\x5a\x43\x09\x5b\x02",
          "\x89\x46\x13\x60\x20\xf0\x44\x7d\x70\xb6\x80\x9c\xf4\x4c\x5c\xc0\x85\xeb\xb7\x97\x19\x86"
          "\x82\x85\x7e\xb0\x2f\x1b\x8e\xe2\x44\xeb",
          1, 1104, NULL, 0 },
        { 0, 256, 28, NULL,
          "\x6d\xab\x92\x6c\x47\x4b\x0f\xb1\xa8\xa7\x1b\x0c\x49\xfe\x3d\xc6\xa2\xcb\x12\xcd\xec\x66"
          "\x90\xc2\x76\xd7\x49\xfe\x77\x3e\xdf\x88\x0f\x39\x91\x60\x26\xc6\xff\xc0\x36\xdb\xd4\x4d"
          "\xe1\x90\xca\x96\x5e\x33\x85\x4f\x94\xb4\x42\x48\x42\xea\x06\x88\x3e\x8e\xd8\x30\xd6\x68"
          "\x57\x2f\x4f\xd8\x81\x60\x09\x84\xb4\xd0\xeb\xcb\x01\xb1\x19\x2a\x67\xd5\x19\xf7\xea\x54"
          "\x16\x54\x0c\x42\x1e\x46\xd4\x11\x4f\x49\x49\x72\x31\xd0\x36\xee\xad\xee\xce\x1b\x36\x96"
          "\x1c\x96\x7b\xce\x5a\xf6\xdf\x72\xe7\xbb\x8c\x33\x0f\x99\x14\x4d\x68\x37\x22\x8f\x1a\xa3"
          "\x49\xb9\xaa\x25\xf2\x3c\x7b\xcf\x46\x6f\x9f\xa7\xb0\xdb\x14\x69\x98\xd2\xa2\x82\x42\x13"
          "\x3f\x0a\x42\xd8\xce\x9a\x23\x92\xc5\x2e\x25\x7e\x7d\xd1",
          "\xef\x06\x38\x39\xc1\xb9\xa2\x6a\xe6\xe1\x16\x92\xc3\xf9\xe4\x74\x14\x1b\x4f\x12\xc1\x32"
          "\x2c\xf8\xae\xef\x4b\x83\x48\x43\x78\xf8",
          1, 1344, NULL, 0 },
        { 0, 256, 29, NULL,
          "\xac\xfc\xaa\x02\xe8\x93\xca\x8d\xf0\x0f\x43\xde\xe2\xb3\x9d\x33\x85\xf4\x62\xaf\x91\x7b"
          "\x6d\x4e\x4c\x48\x30\xc7\x93\x64\xac\x4c\xac\xb8\xc6\xc3\xbc\x2a\xfc\xae\xbb\xec\x4a\x33"
          "\xad\x6d\x2b\xb0\xc0\xec\xe1\xd1\x33\xcd\xd4\xbb\x2d\x87\xeb\xe4\x25\xdf\x74\xac\xf2\xd5"
          "\x4c\xf9\xc1\x93\x39\x31\x42\x71\x6b\x4d\x29\xcc\x18\x76\xe3\xb4\x8f\x96\x49\xb5\x66\x74"
          "\xb6\x7b\x39\x6a\xbd\x38\x1a\x53\x6a\xda\x22\x47\xe8\xcf\x7b",
          "\x2d\x49\x56\xa6\x1f\x3f\x70\x07\x5a\x78\xb5\x30\xde\xa5\x76\xae\x0f\x8b\x24\x41\x33\x88"
          "\x42\x8a\x8c\x8e\xe2\x78\xb8\x6f\x46\x2b",
          1, 824, NULL, 0 },
        { 0, 256, 30, NULL,
          "\xbc\x17\xc8\xc7\xb4\x8a\x71\x6b\x94\xbf\x09\x0d\x8a\x6f\x00\xf6\x87\x2a\xe2\xe7\x93\x1f"
          "\xab\x78\x9d\x44\x3d\xc4\xa1\x74\x60\x9f\x44\xb5\x61\x84\xc4\xe7\x1b\xed\xa8\x13\xc7\xc5"
          "\x84\x69\xaa\xa2\xb0\xf3\x0d\x31\x6d\x60\xd9\xef\x84\x44\xef\x4a\xc9\x73\x46\xa5\xdf\xed"
          "\x38\x43\xc7\x58\x33\x30\xa5\x2c\x1a\x69\x0b\x76\x8e\x9c\x1e\x65\x63\x2c\x8f\xe7\x23\x01"
          "\x6d\xf2\x6d\x3d\xcd\x44\x3e\x0d\xf8\xe4\x9d\x5f\x25\xc6\x16\x0b\x9b\x28\x52\x93\x97\x9a"
          "\x12\xd4\xec\x90\x95\x52\xdf\x00\x60\x02\x48\xe1\x8b\x36\x80\xc5\xc3\x22\x47\x52\x47\xce"
          "\x1e\x6c\x8e\xd3\x3c\x4d\x6b\xe1\x08\xdb\xf1\xa7\x17\xd2\x17\x32\x8c\x7b\x18\x26\x37\xf7"
          "\xaa\x93\xc6\xec\xd9\x69\x39\xd5\x61\x78\x85\x3a\xf6\x43\x43\x84\x0e\x38\x71\xc2\x03\x57"
          "\x05\xea\x37\xa0",
          "\x19\x6e\x86\xc2\x11\xd7\x57\x7f\x6e\x8e\xda\x9c\x1e\xe0\x07\x58\x73\xaa\xb6\x40\x22\x8a"
          "\x76\xf0\xf0\x04\x8a\x66\x9d\x3b\xc3\x04",
          1, 1440, NULL, 0 },
        { 0, 256, 31, NULL,
          "\x2b\x33\x81\xe8\xf2\x6f\xf3\xed\xaa\xa2\xf1\xc4\x66\x68\x99\xf8\xb7\xaf\xbf\xaf\x00\x82"
          "\x6a\x92\x09\x2f\x24\x77\x4d\x2b\x34\xc9\x23\x2b\x0b\x20\x12\x2b\x7c\x4b\x2d\x1b\x83\x67"
          "\x82\xdf\x23\xf8\xc4\x90\x10\x5b\x6e\x61\xa9\x33\x21\xe5\xd2\xbe\x88\xe0\x96\xb2\x14\xa2"
          "\xfd\xb9\x34\xbb\x62\xda\xb1\x06\x49\xed\xbe\xb7\x3b\xa7\x78\x22\xfe\xb6\x5a\x4a\xe6\xdd"
          "\x52\x6a\x8c\xdd\x00\xb0\xc1\x8b\xca\xce\x40\x17\x67\x21\x5b\x18\xf8\x66\x6b\xa4\xca\xb3"
          "\x92\x61\x92\x9d\xb0\xb1\x1f\x2d\x14\x86\x62\x57\x74\x2a\x30\xe7\x7e\xc7\xcf\xb6\x5b\xb3"
          "\x1b\x52\xf7\x83\x48\x08\x13\x2f",
          "\xb6\xce\xaa\xeb\xe7\x14\x8a\x9a\x13\x6a\xa5\x32\x02\xd5\xb9\xb7\x87\xf8\xb4\x30\x24\xfb"
          "\x90\x06\xd8\xcf\x07\x16\x02\x17\xc3\x43",
          1, 1120, NULL, 0 },
        { 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0 }
};
